;--------------------------------------------------
;
; DOUBLE PRECISION FLOATING POINT PACKAGE
;
;--------------------------------------------------
;
DS1 EQU TEMP
DM1 EQU DS1+2
DS2 EQU DS1+10
DM2 EQU DS2+2
DFPU EQU DS2+10
DFPT EQU DFPU+10
DTEMP EQU DFPT+10
DEXPO EQU DTEMP+10
DIGITS EQU DEXPO+2
DWIDTH EQU DIGITS+2
DSTRADDR EQU DWIDTH+2
DSERCNT EQU DSTRADDR+2
DDIVFLAG EQU DSERCNT+2
DDIVTEMP EQU DDIVFLAG+2
DDIVCNT EQU DDIVTEMP+2
;
;--------------------------------------------------
;
; DFLT. DOUBLE FLOAT TOP-OF-STACK. CONVERT THE
; INTEGER TOS TO A DOUBLE PRECISION FLOATING POINT
; NUMBER, AND PUSH THE RESULT.
;
;--------------------------------------------------
;
DFLT MOVEQ #0,D0
 MOVE.W #$40E0,D1
 MOVE.W (SP)+,D2
 BGT DFLT1
 BEQ DFLT0
 NEG.W D2
 BMI DFLTMIN
 MOVE.W #$C0E0,D1
DFLT1 MOVEQ #$10,D3
;
DFLT2 SUB.W D3,D1
 ADD.W D2,D2
 BPL DFLT2
;
 LSL.L #5,D2
 SWAP D2
 ANDI.W #$000F,D2
 OR.W D1,D2
 MOVE.L D2,-(SP)
 MOVE.L D0,-(SP)
 JMP (A2)
;
DFLT0 MOVE.L D0,-(SP)
 MOVE.L D0,-(SP)
 JMP (A2)
;
DFLTMIN MOVE.L #$0000C0E0,-(SP)
 MOVE.L D0,-(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; DFLO. DOUBLE FLOAT NEXT TO TOP-OF-STACK. TOS IS A
; DOUBLE PRECISION FLOATING POINT NUMBER, TOS-1 IS
; AN INTEGER. CONVERT TOS-1 TO A DOUBLE PRECISION
; FLOATING POINT NUMBER, AND PUSH TOS-1 AND TOS.
;
;--------------------------------------------------
;
DFLO MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 MOVE.W #$40E0,D3
 MOVE.W (SP)+,D4
 BGT DFLO1
 BEQ DFLO0
 NEG.W D4
 BMI DFLOMIN
 MOVE.W #$C0E0,D3
DFLO1 MOVEQ #$10,D0
;
DFLO2 SUB.W D0,D3
 ADD.W D4,D4
 BPL DFLO2
;
 LSL.L #5,D4
 SWAP D4
 ANDI.W #$000F,D4
 OR.W D3,D4
 MOVEQ #0,D3
 MOVEM.L D1-D4,-(SP)
 JMP (A2)
;
DFLO0 MOVEQ #0,D3
 MOVEQ #0,D4
 MOVEM.L D1-D4,-(SP)
 JMP (A2)
;
DFLOMIN MOVE.L #$0000C0E0,D4
 MOVEQ #0,D3
 MOVEM.L D1-D4,-(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; DFLTR. DOUBLE FLOAT REAL TOP-OF-STACK. CONVERT
; THE REAL TOS TO A DOUBLE PRECISION FLOATING POINT
; NUMBER, AND PUSH THE RESULT.
;
;--------------------------------------------------
;
DFLTR MOVE.L (SP)+,D1
 MOVE.L D1,D2
 ADD.W D2,D2
 BEQ DFLTR0
 LSR.W #4,D2
 ADDI.W #$3800,D2
 TST.W D1
 BPL DFLTR1
 ORI.W #$8000,D2
DFLTR1 ROR.L #3,D1
 MOVEQ #0,D3
 MOVE.W D1,D3
 ANDI.W #$000F,D1
 ANDI.W #$E000,D3
 OR.W D2,D1
 MOVE.L D1,-(SP)
 MOVE.L D3,-(SP)
 JMP (A2)
;
DFLTR0 MOVE.L D2,-(SP)
 MOVE.L D2,-(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; DFLOR. DOUBLE FLOAT REAL NEXT TO TOP-OF-STACK.
; TOS IS A DOUBLE PRECISION FLOATING POINT NUMBER,
; TOS-1 IS A REAL. CONVERT TOS-1 TO A DOUBLE
; PRECISION FLOATING POINT NUMBER, AND PUSH TOS-1
; AND TOS.
;
;--------------------------------------------------
;
DFLOR MOVEM.L (SP)+,D1-D3
 MOVE.L D3,D4
 ADD.W D3,D3
 BEQ DFLOR0
 LSR.W #4,D3
 ADDI.W #$3800,D3
 TST.W D4
 BPL DFLOR1
 ORI.W #$8000,D3
DFLOR1 ROR.L #3,D4
 MOVE.W D4,D0
 ANDI.W #$000F,D4
 ANDI.W #$E000,D0
 OR.W D3,D4
 MOVEQ #0,D3
 MOVE.W D0,D3
 MOVEM.L D1-D4,-(SP)
 CLR.W D0
 JMP (A2)
;
DFLOR0 MOVEQ #0,D4
 MOVEM.L D1-D4,-(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; DTNC. TRUNCATE DOUBLE. TRUNCATE THE DOUBLE TOS
; AND CONVERT TO AN INTEGER, AND THEN PUSH THE
; RESULT.
;
;--------------------------------------------------
;
DTNC ADDQ.W #4,SP
 MOVE.L (SP)+,D1
 MOVE.W D1,D2
 ADD.W D2,D2
 LSR.W #5,D2
 MOVE.W #$040E,D3
 SUB.W D2,D3
 BLS DTNC2
 CMPI.W #15,D3
 BHI DTNC0
 ORI.W #$0010,D1
 SWAP D1
 ASR.L #5,D1
 LSR.W D3,D1
 TST.L D1
 BPL DTNC1
 NEG.W D1
DTNC1 MOVE.W D1,-(SP)
 JMP (A2)
;
DTNC2 SWAP D1
 BPL DTNCERR
 CMPI.L #$C0E0001F,D1
 BHI DTNCERR
 MOVE.W #-32768,-(SP)
 JMP (A2)
;
DTNC0 MOVE.W #0,-(SP)
 JMP (A2)
;
DTNCERR SUBQ.W #2,A4
 SUBQ.W #8,SP
 JMP XFPIERR
;
;--------------------------------------------------
;
; DRND. ROUND DOUBLE. ROUND THE DOUBLE TOS, THEN
; TRUNCATE AND CONVERT TO AN INTEGER, AND FINALLY
; PUSH THE RESULT.
;
;--------------------------------------------------
;
DRND ADDQ.W #4,SP
 MOVE.L (SP)+,D1
 MOVE.W D1,D2
 MOVE.L D1,D4
 ADD.W D2,D2
 LSR.W #5,D2
 MOVE.W #$040E,D3
 SUB.W D2,D3
 BLS DRND3
 CMPI.W #16,D3
 BHI DTNC0
 ORI.W #$0010,D1
 SWAP D1
 ASR.L #5,D1
 LSR.W D3,D1
 BCC DRND1
 ADDQ.W #1,D1
 BVS DRND3
DRND1 TST.L D1
 BPL DRND2
 NEG.W D1
DRND2 MOVE.W D1,-(SP)
 JMP (A2)
;
DRND3 SWAP D4
 BPL DTNCERR
 CMPI.L #$C0E0000F,D4
 BHI DTNCERR
 MOVE.W #-32768,-(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; SINGLE. CONVERT THE DOUBLE TOS TO A REAL AND
; PUSH IT.
;
;--------------------------------------------------
;
SINGLE MOVE.L (SP)+,D2
 MOVE.L (SP)+,D1
 MOVE.W D1,D3
 ANDI.W #$7FF0,D3
 SUBI.W #$3800,D3
 BLS SINGLE0
 CMPI.W #$0FF0,D3
 BHI SINGLEER
 TST.W D1
 BPL SINGLE1
 ORI.W #$1000,D3
SINGLE1 ANDI.W #$000F,D1
 CLR.B D2
 OR.W D2,D1
 ANDI.W #$E00F,D1
 OR.W D3,D1
 ROL.L #3,D1
 ANDI.W #$1000,D2
 BEQ SINGLE2
 SWAP D1
 ADDQ.L #1,D1
 BVS SINGLEER
 SWAP D1
SINGLE2 MOVE.L D1,-(SP)
 JMP (A2)
;
SINGLE0 MOVEQ #0,D0
 MOVE.L D0,-(SP)
 JMP (A2)
;
SINGLEER SUBQ.W #2,A4
 SUBQ.W #8,SP
 JMP XFPIERR
;
;--------------------------------------------------
;
; DABS. ABSOLUTE VALUE OF DOUBLE. PUSH THE
; ABSOLUTE VALUE OF THE DOUBLE TOS.
;
;--------------------------------------------------
;
DABS BCLR #7,6(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; DNEG. NEGATE DOUBLE. NEGATE THE DOUBLE TOS, AND
; PUSH THE RESULT.
;
;--------------------------------------------------
;
DNEG TST.W 6(SP)
 BEQ DNEGX
 BCHG #7,6(SP)
DNEGX JMP (A2)
;
;--------------------------------------------------
;
; DOUBLE COMPARISONS. COMPARE THE DOUBLE TOS-1 TO
; THE DOUBLE TOS, AND PUSH THE RESULT, TRUE OR
; FALSE.
;
;--------------------------------------------------
;
; EQUDBLE. TOS-1 = TOS.
;
EQUDBLE LEA 8(SP),A0
 CMPM.L (SP)+,(A0)+
 BNE EQUDBLE1
 CMPM.L (SP)+,(A0)+
 SEQ D0
 NEG.B D0
 MOVEA.W A0,SP
 MOVE.W D0,-(SP)
 JMP (A2)
;
EQUDBLE1 LEA 12(SP),SP
DFALSE MOVE.W #FALSE,-(SP)
 JMP (A2)
;
; NEQDBLE. TOS-1 <> TOS.
;
NEQDBLE LEA 8(SP),A0
 CMPM.L (SP)+,(A0)+
 BNE NEQDBLE1
 CMPM.L (SP)+,(A0)+
 SNE D0
 NEG.B D0
 MOVEA.W A0,SP
 MOVE.W D0,-(SP)
 JMP (A2)
;
NEQDBLE1 LEA 12(SP),SP
DTRUE MOVE.W #TRUE,-(SP)
 JMP (A2)
;
; LEQDBLE. TOS-1 <= TOS.
;
LEQDBLE MOVEM.L (SP)+,D1-D4
 SWAP D2
 BMI LEQDBLE2
 SWAP D4
 BMI DTRUE
 CMP.L D2,D4
 BNE LEQDBLE1
 SWAP D1
 SWAP D3
 CMP.L D1,D3
LEQDBLE1 DC.W $53C0 ;SLS D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
LEQDBLE2 SWAP D4
 BPL DFALSE
 CMP.L D4,D2
 BNE LEQDBLE3
 SWAP D1
 SWAP D3
 CMP.L D3,D1
LEQDBLE3 DC.W $53C0 ;SLS D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LESDBLE. TOS-1 < TOS.
;
LESDBLE MOVEM.L (SP)+,D1-D4
 SWAP D2
 BMI LESDBLE2
 SWAP D4
 BMI DTRUE1
 CMP.L D2,D4
 BNE LESDBLE1
 SWAP D1
 SWAP D3
 CMP.L D1,D3
LESDBLE1 SCS D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
LESDBLE2 SWAP D4
 BPL DFALSE1
 CMP.L D4,D2
 BNE LESDBLE3
 SWAP D1
 SWAP D3
 CMP.L D3,D1
LESDBLE3 SCS D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
DTRUE1 MOVE.W #TRUE,-(SP)
 JMP (A2)
;
DFALSE1 MOVE.W #FALSE,-(SP)
 JMP (A2)
;
; GEQDBLE. TOS-1 >= TOS.
;
GEQDBLE MOVEM.L (SP)+,D1-D4
 SWAP D2
 BMI GEQDBLE2
 SWAP D4
 BMI DFALSE1
 CMP.L D2,D4
 BNE GEQDBLE1
 SWAP D1
 SWAP D3
 CMP.L D1,D3
GEQDBLE1 SCC D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
GEQDBLE2 SWAP D4
 BPL DTRUE1
 CMP.L D4,D2
 BNE GEQDBLE3
 SWAP D1
 SWAP D3
 CMP.L D3,D1
GEQDBLE3 SCC D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GRTDBLE. TOS-1 > TOS.
;
GRTDBLE MOVEM.L (SP)+,D1-D4
 SWAP D2
 BMI GRTDBLE2
 SWAP D4
 BMI DFALSE1
 CMP.L D2,D4
 BNE GRTDBLE1
 SWAP D1
 SWAP D3
 CMP.L D1,D3
GRTDBLE1 SHI D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
GRTDBLE2 SWAP D4
 BPL DTRUE1
 CMP.L D4,D2
 BNE GRTDBLE3
 SWAP D1
 SWAP D3
 CMP.L D3,D1
GRTDBLE3 SHI D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
;--------------------------------------------------
;
; UNPACK. CONVERT THE DOUBLE TOS FROM IEEE-FORMAT
; (53-BIT-MANTISSA) TO EXTENDED FORMAT (64-BIT-
; MANTISSA) AND STORE IT IN MEMORY POINTED AT BY
; A0.
;
;--------------------------------------------------
;
UNPACK MOVEA.L (SP)+,A1
 MOVE.L (SP)+,D3
 MOVE.L (SP)+,D2
 MOVE.W D2,D1
 ASR.W #4,D1
 ANDI.W #$87FF,D1
 ANDI.W #$000F,D2
 ORI.W #$0010,D2
 ROR.L #5,D2
 MOVE.W D3,D4
 LSR.W #5,D4
 OR.W D4,D2
 ANDI.W #$001F,D3
 ROR.L #5,D3
 MOVE.W D1,(A0)+
 MOVE.L D2,(A0)+
 MOVE.L D3,(A0)+
 JMP (A1)
;
;--------------------------------------------------
;
; PACK. CONVERT THE 10 BYTE NUMBER IN FPACC1 TO AN
; 8 BYTE IEEE NUMBER, PUSH IT, AND RETURN.
;
;--------------------------------------------------
;
TESTPACK MOVEA.L (SP)+,A0
 TST.W (SP)+
 BPL PACK1
 TAS DS1 ;SET X NEGATIVE
 BRA PACK1
;
PACK MOVEA.L (SP)+,A0
PACK1 LEA DS1,A1
 MOVE.W (A1)+,D1
 MOVE.L (A1)+,D2
 MOVE.L (A1)+,D3
 ADD.L D1,D1
 LSL.W #4,D1
 LSR.L #1,D1
 MOVE.L D2,D4
 SWAP D4
 CLR.B D4
 ADD.W D4,D4
 ROL.W #4,D4
 OR.B D4,D1
 LSL.L #5,D2
 MOVE.L D3,D4
 SWAP D4
 CLR.B D4
 ROL.W #5,D4
 OR.B D4,D2
 LSL.L #5,D3
 SWAP D3
 BPL PACK2
 ADDQ.W #1,D3
 BCC PACK2
 ADDQ.L #1,D2
 BCC PACK2
 ADDQ.W #1,D1
 BVS FPERR
PACK2 MOVEM.W (SP)+,D5-D7/A3
 SWAP D2
 MOVE.W D1,-(SP)
 MOVE.L D2,-(SP)
 MOVE.W D3,-(SP)
 CLR.W D0
 JMP (A0)
;
;--------------------------------------------------
;
; DSQR. SQUARE DOUBLE. SQUARE TOS, AND PUSH THE
; RESULT.
;
;--------------------------------------------------
;
DSQR LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 LEA DS1,A0
 BSR LMUL
 BSR PACK
 JMP (A2)
;
;--------------------------------------------------
;
; DMUL. MULTIPLY DOUBLES. MULTIPLY TOS AND TOS-1,
; AND PUSH THE RESULTING PRODUCT.
;
;--------------------------------------------------
;
DMUL LEA DS1,A0
 BSR UNPACK
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR LMUL1
 BSR PACK
 JMP (A2)
;
; STORE A ZERO IN FPACC1
;
DZERO MOVEQ #0,D0
 LEA DS1,A1
 MOVE.W D0,(A1)+
 MOVE.L D0,(A1)+
 MOVE.L D0,(A1)+
 RTS
;
; FETCH AN 10 BYTE F.P. NUMBER TO FPACC#2
;
LMUL LEA DS2,A1
 MOVE.W (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
;
; PERFORM A 64 BIT FLOATING POINT MULTIPLY
;
LMUL1 MOVE.W DS1,D1
 MOVE.W D1,D3
 MOVE.W DS2,D2
 EOR.W D2,D3
 ADD.W D1,D1 ;TEST FOR ZERO
 BEQ DZERO ;EXIT IF FPACC1 0
 ADD.W D2,D2 ;TEST FOR ZERO
 BEQ DZERO ;EXIT IF FPACC2 0
 ADD.W D2,D1 ;ADD EXPONENTS
 LSR.W #1,D1 ;CORRECT FOR SHIFT
 SUBI.W #$03FF,D1 ;CORRECT OFFSET
 BMI DZERO ;ZERO IF <= 0
 ANDI.W #$8000,D3
 MOVE.W D3,DS1 ;STORE THE SIGN
 MOVEA.W D1,A1 ;SAVE EXPONENT
;
; NOW MULTIPLY TWO 64 BIT MANTISSAS
;
;    A3 A2 A1 A0   *   B3 B2 B1 B0
;
 MOVEM.W DM1+2,D3-D5 ;FETCH A2 A1 A0
 MOVEM.L DM2,D6-D7 ;FETCH B3 B2 B1 B0
 MOVE.W D5,D1
 MULU D7,D1 ;A0 * B0
 CLR.W D1 ;DISCARD LOWER 16
 SWAP D1 ;D1 = $0000HHHH
 MOVE.W D4,D2
 MULU D7,D2 ;A1 * B0
 ADD.L D2,D1 ;SUM PARTIALS
 MOVE.W D5,D2
 SWAP D7
 MULU D7,D2 ;A0 * B1
 ADD.L D2,D1
 CLR.W D1
 ADDX.W D1,D1
 SWAP D1
 MOVE.W D4,D2
 MULU D7,D2 ;A1 * B1
 ADD.L D2,D1
 MOVE.W D3,D2
 SWAP D7
 MULU D7,D2 ;A2 * B0
 ADD.L D2,D1
 CLR.W D0
 ADDX.W D0,D0
 MOVE.W D5,D2
 MULU D6,D2 ;A0 * B2
 ADD.L D2,D1
 MOVE.W D0,D1
 CLR.W D0
 ADDX.W D0,D1
 SWAP D1
 MOVE.W D4,D2
 MULU D6,D2 ;A1 * B2
 ADD.L D2,D1
 ADDX.W D0,D0
 SWAP D6
 MULU D6,D5 ;A0 * B3
 ADD.L D5,D1
 CLR.W D2
 ADDX.W D2,D0
 MOVE.W DM1,D5
 MOVE.W D5,D2
 MULU D7,D2 ;A3 * B0
 ADD.L D2,D1
 CLR.W D2
 ADDX.W D2,D0
 SWAP D7
 MOVE.W D3,D2
 MULU D7,D2 ;A2 * B1
 ADD.L D2,D1
 MOVE.W D0,D1
 CLR.W D0
 ADDX.W D0,D1
 SWAP D1
 MULU D5,D7 ;A3 * B1
 ADD.L D7,D1
 ADDX.W D0,D0
 MULU D6,D4 ;A1 * B3
 ADD.L D4,D1
 CLR.W D4
 ADDX.W D4,D0
 MOVE.W D3,D2
 MOVE.W D6,D7
 SWAP D6
 MULU D6,D2 ;A2 * B2
 ADD.L D2,D1
 ADDX.W D4,D0
 MOVE.W D1,D2
 MOVE.W D0,D1
 CLR.W D0
 SWAP D1
 MULU D5,D6 ;A3 * B2
 ADD.L D6,D1
 ADDX.W D0,D0
 MULU D7,D3 ;A2 * B3
 ADD.L D3,D1
 ADDX.W D4,D0
 SWAP D2
 MOVE.W D1,D2
 SWAP D2
 MOVE.W D0,D1
 SWAP D1
 MOVE.W A1,D0
 MULU D7,D5 ;A3 * B3
 ADD.L D5,D1
 BMI LMUL2
 SUBQ.W #1,D0
 BMI DZERO1
 ADD.L D2,D2
 ADDX.L D1,D1
LMUL2 ADDQ.W #1,D0
 CMPI.W #$07FF,D0 ;TEST EXP OVFL
 BHI LMULOVFL ;REPORT OVERFLOW
;
; MULTIPLICATION IS COMPLETE, STORE THE RESULT.
;
 LEA DS1,A1
 OR.W D0,(A1)+ ;STORE EXP
 MOVE.L D1,(A1)+ ;STORE MANTISSA
 MOVE.L D2,(A1)+
 RTS
;
; THE FLOATING POINT MULTIPLY ROUTINE IS COMPLETED
;
LMULOVFL BRA FPERR ;REPORT OVERFLOW
;
; STORE A ZERO IN FPACC1
;
DZERO1 BRA DZERO
;
;--------------------------------------------------
;
; DDIV. DIVIDE DOUBLES. DIVIDE TOS-1 BY TOS, AND
; PUSH THE RESULTING QUOTIENT.
;
;--------------------------------------------------
;
DDIV LEA DS1,A0
 BSR UNPACK
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR LDIV1
 BSR PACK
 JMP (A2)
;
; REPORT DIVISION BY ZERO.
;
LDIV0 BRA DIVBY0
;
; THE MANTISSAS ARE EQUAL.
;
LDIVONE MOVE.W (SP)+,D3
 ADDQ.W #8,SP
 MOVE.L #$80000000,D4
 MOVEQ #0,D5
 BRA.L LDIVX
;
; FETCH AN 8 BYTE F.P. NUMBER TO FPACC#2
;
LDIV LEA DS2,A1
 MOVE.W (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
;
; PERFORM A 62 BIT FLOATING POINT DIVIDE   
;
LDIV1 MOVE.W DS1,D1
 MOVE.W D1,D0
 ADD.W D0,D0
 BEQ LDIV0
 MOVE.W DS2,D2
 EOR.W D2,D1
 ADD.W D2,D2
 BEQ DZERO1
 ANDI.W #$8000,D1
 MOVE.W D1,DS1
 SUB.W D0,D2
 ASR.W #1,D2
 ADDI.W #$03FF,D2
 LEA -10(SP),SP
 MOVEA.W SP,A1
 MOVE.W D2,(A1)+
 MOVEM.L DM1,D6-D7
 MOVEM.L DM2,D2-D3
 MOVE.W #0,DDIVFLAG
 MOVE.W #4,DDIVCNT
 CMP.L D6,D2
 BCS LDIV3
 BNE LDIV2
 CMP.L D7,D3
 BCS LDIV3
 BEQ LDIVONE
LDIV2 MOVE.W #1,DDIVFLAG
 SUB.L D7,D3
 SUBX.L D6,D2
;
LDIV3 MOVE.L D2,D0
 SWAP D6
 DIVU D6,D0
 BVC LDIV4
 MOVEQ #$FF,D0
LDIV4 MOVE.W D0,D5
 MOVE.W D0,D4
 MOVE.W D0,D1
 MULU D7,D5
 MOVE.W D5,DDIVTEMP
 CLR.W D5
 SWAP D5
 SWAP D7
 MULU D7,D1
 SWAP D7
 MULU D6,D4
 ADD.L D1,D5
 MOVE.W D0,D1
 SWAP D6
 MULU D6,D1
 SWAP D5
 ADD.W D1,D5
 SWAP D5
 CLR.W D1
 SWAP D1
 ADDX.L D1,D4
 CLR.W D1
 SUB.W DDIVTEMP,D1
 SUBX.L D5,D3
 SUBX.L D4,D2
 BPL LDIV7
 MOVEQ #0,D4
 MOVE.L D6,D5
 SWAP D5
 MOVE.W D5,D4
 SWAP D7
 MOVE.W D7,D5
 SWAP D7
;
LDIV6 SUBQ.W #1,D0
 ADD.W D7,D1
 ADDX.L D5,D3
 ADDX.L D4,D2
 BMI LDIV6
;
LDIV7 MOVE.W D0,(A1)+
 SWAP D3
 SWAP D2
 MOVE.W D3,D2
 CLR.W D3
 SUBQ.W #1,DDIVCNT
 BNE LDIV3
;
 MOVE.W (SP)+,D3
 MOVE.L (SP)+,D4
 MOVE.L (SP)+,D5
 SUBQ.W #1,D3
 MOVE.W DDIVFLAG,D1
 BEQ LDIVX
 ADDQ.W #1,D3
 SUBQ.W #2,D1
 ROXR.L #1,D4
 ROXR.L #1,D5
LDIVX TST.W D3
 BLE DZERO2
 CMPI.W #$07FF,D3
 BHI LDIVOVFL
 LEA DS1,A1
 OR.W D3,(A1)+
 MOVE.L D4,(A1)+
 MOVE.L D5,(A1)+
 RTS
;
DZERO2 BRA DZERO
;
LDIVOVFL BRA FPERR
;
;--------------------------------------------------
;
; DSUB. SUBTRACT DOUBLES. SUBTRACT TOS FROM TOS-1,
; AND PUSH THE RESULTING REMAINDER.
;
;--------------------------------------------------
;
DSUB BCHG #7,6(SP)
;
;--------------------------------------------------
;
; DADD. ADD DOUBLES. ADD TOS AND TOS-1, AND PUSH
; THE RESULTING SUM.
;
;--------------------------------------------------
;
DADD LEA DS1,A0
 BSR UNPACK
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR LADD1
 BSR PACK
 JMP (A2)
;
LADDRTN2 LEA DS1,A1
 MOVE.W D5,(A1)+
 MOVE.L D6,(A1)+
 MOVE.L D7,(A1)+
LADDRTN1 RTS
;
; START OF 64 BIT FLOATING POINT SUBTRACT
;
LSUB BCHG #7,DS1 ;TOGGLE D7 OF DS1
;
; FETCH AN 10 BYTE F.P. NUMBER TO FPACC#2
;
LADD LEA DS2,A1
 MOVE.W (A0)+,(A1)+ ;A0 IS PTR TO FP#
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
;
; PERFORM A 64 BIT FLOATING POINT SIGNED ADD 
;
LADD1 LEA DS1,A1
 MOVE.W (A1)+,D1 ;FPACC#1 TO D1-D3
 MOVE.L (A1)+,D2
 MOVE.L (A1)+,D3
 MOVE.W (A1)+,D5 ;FPACC#2 TO D5-D7
 MOVE.L (A1)+,D6
 MOVE.L (A1)+,D7
;
; FIRST TEST WHETHER EITHER # IS ZERO
;
 MOVE.W D5,D4 ;X2 TO D4
 ADD.W D4,D4 ;TEST FOR ZERO
 BEQ LADDRTN1 ;DONE IF X2 = 0
;
 MOVE.W D1,D0 ;X1 TO D0
 ADD.W D0,D0 ;TEST FOR ZERO
 BEQ LADDRTN2 ;RESULT IS FPACC2
;
; WE MUST PLACE THE NUMBER WHOSE ABSOLUTE VALUE
; IS GREATEST IN FPACC1.  FIRST WE TEST THE 
; EXPONENTS, THEN THE MOST SIGNIFICANT 32 
; BITS OF THE MANTISSAS AND FINALLY THE LEAST 
; SIGNIFICANT 32 BITS OF THE MANTISSAS. 
;
 CMP.W D0,D4 ;COMPARE EXPS      
 BCS LADD1GE2 ;OK IF X1 > X2
 BNE LADDSWAP ;SWAP IF X1 < X2
;
 CMP.L D2,D6 ;COMP MOST SIG 32
 BCS LADD1GE2 ;OK IF DM1 > DM2
 BNE LADDSWAP ;SWAP IF DM1 < DM2
;
 CMP.L D3,D7 ;COMP LAST 32 BITS
 BLS LADD1GE2 ;OK IF DM1 >= DM2
;
; SWAP THE TWO FLOATING POINT ACCUMULATORS 
;
LADDSWAP EXG D0,D4
 EXG D1,D5
 EXG D2,D6
 EXG D3,D7
;
; ABS(FPACC1) IS NOW > OR = ABS(FPACC2)
;
LADD1GE2 SUB.W D4,D0 ;D0 = X1 - X2
 LSR.W #1,D0 ;COMP'SAT FOR ADD'S
;
; FIRST TEST FOR FEWER THAN 16 SHIFTS
;
 CMPI.W #16,D0
 BCS LADDLT16
;
; NEXT TEST FOR FEWER THAN 32 SHIFTS
;
 CMPI.W #32,D0
 BCS LADDLT32
;
; FINALLY TEST FOR FEWER THAN 64 SHIFTS
;
 CMPI.W #64,D0
 BCC LADDX ;DONE IF DIFF >=64
;
; THERE ARE FEWER THAN 64 SHIFTS BUT >= 32
;
 MOVE.L D6,D7
 MOVEQ #0,D6
 SUBI.W #32,D0
 LSR.L D0,D7
 BRA LADD2
;
; THERE ARE FEWER THAN 32 SHIFTS BUT >= 16
;
LADDLT32 MOVE.W D6,D7
 SWAP D7
 CLR.W D6
 SWAP D6
 MOVE.L D6,D4
 SUBI.W #16,D0
 ROR.L D0,D4
 LSR.L D0,D7
 MOVE.W D4,D6
 CLR.W D4
 OR.L D4,D7
 BRA LADD2
;
; THERE ARE FEWER THAN 16 SHIFTS
;
LADDLT16 MOVEQ #0,D4
 MOVE.W D6,D4
 LSR.L D0,D6
 ROR.L D0,D4
 LSR.L D0,D7
 CLR.W D4
 OR.L D4,D7
;
; MANT2 IS NOW ALIGNED TO CORRESPOND TO EQUAL
; EXPONENTS FOR FPACC1 AND FPACC2.
;
; TEST THE SIGNS; SUBTRACT IF DIFFERENT
;
LADD2 EOR.W D1,D5
 BMI LSUB2 ;DIFF SIGNS; SUB
;
; THE SIGNS ARE THE SAME; PERFORM ADDITION
;
 ADD.L D7,D3 ;ADD DM2 TO DM1
 ADDX.L D6,D2
 BCC LADDX ;EXIT IF NO OVFL
;
 ROXR.L #1,D2 ;SHIFT MANT1 R TO
 ROXR.L #1,D3 ;COMPENSATE OVFL
 ADDQ.W #1,D1 ;ADD 1 TO EXPONENT
 BTST #11,D1 ;TEST FOR OVERFLOW
 BNE LADDOVFL
LADDX LEA DS1,A1
 MOVE.W D1,(A1)+ ;STORE EXPONENT1
 MOVE.L D2,(A1)+ ;STORE MANTISSA1
 MOVE.L D3,(A1)+
 RTS
;
LADDOVFL BRA FPERR
;
; THE SIGNS ARE DIFFERENT; SUBTRACT
;
LSUB2 SUB.L D7,D3 ;D2,3 := DM1 - DM2
 SUBX.L D6,D2 ;NO UNDERFLOW POSS
;
; NORMALIZE; MANT1 IS IN D2 & D3; DS1,X1 IN D1
;
LNORM SWAP D2
 BEQ LNORM3 ;LNORM3 IF B63-32=0
 TST.W D2 ;TEST B63-48
 BEQ LNORM2 ;LNORM2 IF B63-48=0
 SWAP D2
 BMI LADDX ;OK IF B31 = 1
;
LNORM1 SUBQ.W #1,D1
 ADD.L D3,D3 ;SHIFT MANT1 LEFT
 ADDX.L D2,D2
 BPL LNORM1 ;DO UNTIL NORML'ZD
;
 BRA LNORMX ;EXIT
;
; THE MOST SIG 16 BITS OF THE MANT ARE ZERO
;
LNORM2 SWAP D3
 MOVE.W D3,D2
 CLR.W D3
 SUBI.W #16,D1
 TST.L D2
 BPL LNORM1
 BRA LNORMX
;
; THE MOST SIG 32 BITS OF THE MANT ARE ZERO
;
LNORM3 EXG D2,D3
 SWAP D2
 BEQ LNORM0 ;RESULT IS ZERO
 TST.W D2
 BEQ LNORM5
 SUBI.W #32,D1
 SWAP D2
 BMI LNORMX
;
LNORM4 SUBQ.W #1,D1
 ADD.L D2,D2
 BPL LNORM4
;
 BRA LNORMX
;
; THE MOST SIG 48 BITS OF THE MANT ARE ZERO
;
LNORM5 SUBI.W #48,D1
 TST.L D2
 BPL LNORM4
;
; MANT1 (64 BITS) IS NOW NORMALIZED.
; TEST FOR UNDERFLOW.
;
LNORMX MOVE.W D1,D0
 LSL.W #1,D0
 BGT LADDX
LNORM0 BRA DZERO
;
 CHAIN DT
