;
; MULTIPLY DOUBLE BY 10
;
FASTMUL MOVE.W (A1)+,D1
 BEQ FASTMULX ;EXIT IF ZERO
 MOVE.L (A1)+,D2 ;FETCH MANTISSA
 MOVE.L (A1)+,D3
 ADDQ.W #3,D1 ;MULT EXP BY 8
 MOVE.L D2,D4
 MOVE.L D3,D5
 LSR.L #1,D4 ;SHIFT MANT TWICE
 ROXR.L #1,D5
 LSR.L #1,D4
 ROXR.L #1,D5
 ADDX.L D5,D3 ;8*MANT + 2*MANT
 ADDX.L D4,D2
 BCC FASTMUL1
 ROXR.L #1,D2
 ROXR.L #1,D3
 ADDQ.W #1,D1
FASTMUL1 MOVE.L D3,-(A1)
 MOVE.L D2,-(A1)
 MOVE.W D1,-(A1)
 ANDI.W #$7800,D1
 BNE FASTMULE
FASTMULX RTS
;
FASTMULE BRA FPERR
;
;--------------------------------------------------
;
; WRITE DOUBLE
;
;--------------------------------------------------
;
SIGNIF EQU 15 ;15 SIGNIF. DIGITS
SYSTEM EQU 0 ;SEGMENT 0
GET EQU 7
READINT EQU 12
WRITESTR EQU 19
DSIGN EQU DDIVTEMP+2
READIT EQU DSIGN+1
NEEDCHAR EQU 1
FEOF EQU 4
FSTATE EQU 6
;
NODIGITS ADDQ.W #2,SP ;SKIP WIDTH
NOWIDTH MOVEQ #0,D0
 MOVE.L D0,DIGITS ;W=0 & D=0
 BRA DWRITE1
;
DWRITE MOVE.W (SP)+,DIGITS
 BMI NODIGITS
 MOVE.W (SP)+,DWIDTH
 BMI NOWIDTH
DWRITE1 LEA DS1,A0
 BSR UNPACK
 MOVE.W GDIRP,D0
 BEQ DWRITE1A
 MOVE.W D0,D7
 MOVE.W #NIL,GDIRP
DWRITE1A MOVE.W D7,DSTRADDR ;HEAP IS TEMP STORE
 MOVEA.W D7,A0
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
;
; DETERMINE THE SIGN AND SET FPACC1 POSITIVE
;
 MOVEQ #' ',D0
 BCLR #7,DS1
 BEQ DWRITE2
 MOVEQ #'-',D0
 ANDI.W #$07FF,D1
;
; SCALE FPACC1 TO 1 <= FPACC1 <= 10
;
DWRITE2 MOVE.W D0,(A0) ;STORE SIGN
 CLR.W DEXPO ;DEFAULT EXP IS 0
 LEA DTEMP,A0 ;COPY FPACC1
 MOVE.W D1,(A0)+
 BEQ.L DWRITE11 ;DON'T SCALE FOR 0
 MOVE.L D2,(A0)+
 MOVE.L D3,(A0)+
 BSR DLOG ;LOG2(X)
 LEA @DLG2(PC),A0
 BSR LMUL ;LG(X)
 LEA DS1,A0
 MOVE.W (A0)+,D2
 ANDI.W #$07FF,D2 ;ABS(LG(X))
 CMPI.W #$03FF,D2 ;ABS(LG(X)) >= 1 ?
 BCC DWRITE3 ;SKIP IF >= 1
;
; ABS(LG(X)) < 1  ==>  0.1 < X < 10
;
 MOVE.W -(A0),D0 ;SAVE SIGN(LG(X))
 LEA DTEMP,A1
 MOVE.W (A1)+,(A0)+ ;RESTORE X
 MOVE.L (A1)+,(A0)+
 MOVE.L (A1)+,(A0)+
 TST.W D0
 BPL DWRITE6 ;SKIP IF X >= 1
 MOVE.W #-1,DEXPO ;EXP IS -1
 LEA DS1,A1
 BSR FASTMUL ;X := X * 10
 BRA DWRITE6
;
; ABS(LG(X)) >= 1  ==>  X <= 0.1  OR  10 <= X
; WE DIVIDE X BY 10 ^ INT(LG(X)) AND STORE
; INT(LG(X)) AS THE EXPONENT OF THE RESULT.
;
DWRITE3 MOVE.W #$040E,D1
 SUB.W D2,D1
 MOVE.W (A0),D2 ;FIRST 16 BITS
 LSR.W D1,D2
 MOVE.W D2,DEXPO ;SAVE INT(LG(X))
 BCHG #7,DS1
 BEQ DWRITE4
;
; X IS NEGATIVE. EXP = INT(LG(X)) - 1
;
 ADDQ.W #1,D2
 NOT.W DEXPO ;NEGATE AND DECR
;
; DEXPO CONTAINS THE EXPONENT IN TWO'S COMPLEMENT
; FORM. NOW CALCULATE 10 ^ (-DEXPO).
;
DWRITE4 LSL.W D1,D2
 BCC DWRITE5
 ROXR.W #1,D2
 ADDQ.W #1,DS1
DWRITE5 MOVE.W D2,(A0)+
 MOVEQ #0,D0
 MOVE.W D0,(A0)+
 MOVE.L D0,(A0)+
 LEA @DINVLG2(PC),A0
 BSR LMUL
 BSR DEXP2
;
; SCALE X BY MULTPLYING WITH 10 ^ (-INT(LG(X)))
;
 LEA DTEMP,A0
 BSR LMUL
;
; X IS NOW IN THE RANGE 1 <= X <= 10. ADD HALF OF
; THE LEAST SIGNIFICANT DIGIT TO BE DISPLAYED SO
; THAT A PROPER ROUNDING IS ACHIEVED.
;
DWRITE6 MOVE.W DIGITS,D0
 BEQ DWRITE7 ;TAKE DEFAULT
 ADD.W DEXPO,D0
 CMPI.W #SIGNIF-1,D0
 BLT DWRITE8
DWRITE7 LEA @TINY15(PC),A0 ;DEFAULT VALUE
 BRA DWRITE9
;
DWRITE8 ADDQ.W #1,D0
 BMI DWRITE10 ;ROUNDING USELESS
 ADD.W D0,D0 ;TABLE LOOKUP
 MOVE.W D0,D1 ;MULT INDEX BY 10
 ADD.W D0,D0
 ADD.W D0,D0
 ADD.W D1,D0
 LEA @TINY(PC),A0
 ADDA.W D0,A0
DWRITE9 BSR LADD ;ADD 5E-??
;
; IF X >= 10 THEN INCR EXP AND SET X TO 1
;
DWRITE10 CMPI.L #$0402A000,DS1 ;X >= 10 ?
 BCS DWRITE11 ;SKIP IF X < 10
 ADDQ.W #1,DEXPO
 LEA DS1,A0
 MOVEQ #0,D0
 MOVE.L #$03FF8000,(A0)+
 MOVE.L D0,(A0)+
 MOVE.W D0,(A0)+
;
; X IS IN THE RANGE 1 <= X < 10. NOW EXTRACT
; 15 DECIMAL DIGITS BY SUCCESSIVELY TRUNCATING
; THE INTEGER PART AND MULTIPLYING THE
; FRACTIONAL PART BY TEN.
;
DWRITE11 MOVEA.W DSTRADDR,A0
 ADDQ.W #3,A0
 MOVE.B #SIGNIF,DSERCNT
 MOVEQ #0,D0
 MOVE.W D0,DM2+2
 MOVE.L D0,DM2+4
;
DWRITE12 MOVE.W DS1,D2
 MOVE.W D2,D3
 MOVEQ #'0',D0
 MOVE.B D0,(A0)+
 SUBI.W #$03FE,D2
 BLE DWRITE13 ;SKIP IF < 1
 MOVEQ #0,D1
 MOVE.W DM1,D1
 LSL.L D2,D1
 SWAP D1
 ADD.W D1,D0
 MOVE.B D0,-1(A0)
 ROR.W D2,D1
 MOVE.W D1,DM2
 ORI.W #$8000,D3
 MOVE.W D3,DS2
 BSR LADD1
DWRITE13 LEA DS1,A1
 BSR FASTMUL ;X := X * 10
 SUBQ.B #1,DSERCNT
 BNE DWRITE12
;
; THE DOUBLE X HAS BEEN CONVERTED TO AN ASCII
; STRING WITH SIGN AND 15 DIGITS. NOW DETERMINE
; HOW MANY DIGITS ARE TO BE DISPLAYED AND WHERE
; THE DECIMAL POINT IS TO BE PLACED.
;
 MOVEA.W DSTRADDR,A0
 MOVE.W DEXPO,D1
 MOVE.W DIGITS,D0
 BEQ DWRITE14 ;TAKE DEFAULT
 CMPI.W #SIGNIF,D1
 BLT.L DWRITE19
;
; DISPLAY X IN DEFAULT FORMAT:
;
;   -M.MMMMMMMMMMMMMMD-NNN
;
DWRITE14 MOVE.B 3(A0),2(A0)
 MOVE.B #'.',3(A0)
 LEA SIGNIF+3(A0),A1
 TST.W D1
 BEQ DWRITE18 ;NO EXP IF X = 0
 MOVE.B #'D',(A1)+
 TST.W D1
 BPL DWRITE15 ;NO SIGN IF X > 0
 MOVE.B #'-',(A1)+
 NEG.W D1 ;SET EXP POSITIVE
;
; DISPLAY 1, 2 OR 3 EXPONENT DIGITS
;
DWRITE15 MOVEQ #'0',D2
 CMPI.W #10,D1
 BCS DWRITE17
 CMPI.W #100,D1
 BCS DWRITE16
 EXT.L D1
 DIVU #100,D1
 ADD.W D2,D1
 MOVE.B D1,(A1)+
 SWAP D1 ;D1 = EXP MOD 100
DWRITE16 EXT.L D1
 DIVU #10,D1
 ADD.W D2,D1
 MOVE.B D1,(A1)+
 SWAP D1 ;D1 = EXP MOD 10
DWRITE17 ADD.W D2,D1
 MOVE.B D1,(A1)+
;
; STORE THE LENGTH OF THE STRING AND EXIT.
;
DWRITE18 MOVE.W A1,D1
 SUB.W A0,D1
 SUBQ.W #1,D1
 MOVE.B D1,(A0)
DWRITEX MOVEM.W (SP)+,D5-D7/A3
 MOVE.W A0,-(SP) ;PUSH STRING ADDR
 CLR.W D0
 MOVE.B (A0),D0
 MOVE.W D0,-(SP) ;PUSH STRING LENGTH
 CMP.W DWIDTH,D0
 BGE DWRITEX1
 MOVE.W DWIDTH,(SP)
;
; PROTECT STRING BY INCREMENTING THE HEAP POINTER
;
DWRITEX1 ADDQ.W #1,D0 ;MAKE POINTER EVEN
 BTST #0,D0
 BEQ DWRITEX2
 ADDQ.W #1,D0
DWRITEX2 ADD.W D0,D7
 MOVEQ #SYSTEM,D0 ;CXP 0, 19
 MOVEQ #WRITESTR,D1
 MOVEA.L PCODE,A0
 JSR (A0)
;
; RESTORE HEAP POINTER AND EXIT
;
 MOVE.W DSTRADDR,D7
 MOVE.W #NIL,GDIRP
 JMP (A2)
;
; DISPLAY X IN USER DEFINED FORMAT.
;
DWRITE19 TST.W D1
 BMI DWRITE22
;
; EXPONENT IS POSITIVE. INSERT THE DECIMAL POINT
; AT THE CORRECT POSITION AND INSERT BLANKS IF
; MORE DECIMALS ARE SPECIFIED THAN CAN BE
; EXTRACTED FROM X.
;
 LEA 3(A0),A1
 LEA 2(A0),A3
 MOVE.W D1,D2
;
DWRITE20 MOVE.B (A1)+,(A3)+
 DBF D2,DWRITE20
;
 MOVE.B #'.',(A3)
 ADD.W D0,D1 ;EXP + DECIMALS
 ADDQ.W #3,D1 ;STRING OVERHEAD
 MOVE.B D1,(A0) ;STRING LENGTH
 SUBI.W #SIGNIF+3,D1
 BMI DWRITEX
 MOVEQ #' ',D0
 LEA SIGNIF+3(A0),A1
;
DWRITE21 MOVE.B D0,(A1)+
 DBF D1,DWRITE21
;
 BRA DWRITEX
;
; THE EXPONENT IS NEGATIVE. MOVE THE SIGNIFICANT
; DIGITS TO THEIR PROPER POSITION, THEN FILL THE
; GAP WITH 0.000... AND APPEND BLANKS IF THE STRING
; THUS OBTAINED IS SHORTER THAN SPECIFIED BY THE
; USER.
;
DWRITE22 NEG.W D1 ;SET EXP POSITIVE
 LEA SIGNIF+3(A0),A1
 LEA SIGNIF+3(A0,D1.W),A3
 MOVEQ #SIGNIF-1,D2
;
DWRITE23 MOVE.B -(A1),-(A3)
 DBF D2,DWRITE23
;
 SUBQ.W #1,A1
 MOVE.W #$302E,(A1)+ ;'0.'
 MOVE.W D1,D2
 SUBQ.W #2,D2
 BMI DWRITE25
 MOVEQ #'0',D3
;
DWRITE24 MOVE.B D3,(A1)+
 DBF D2,DWRITE24
;
DWRITE25 LEA SIGNIF+3(A0,D1.W),A1
 NEG.W D1
 ADD.W D0,D1
 ADDQ.W #3,D0
 MOVE.B D0,(A0)
 SUBI.W #SIGNIF+1,D1
 BMI DWRITEX
 MOVEQ #' ',D0
;
DWRITE26 MOVE.B D0,(A1)+
 DBF D1,DWRITE26
;
 BRA DWRITEX
;
; ROUNDING CONSTANTS
;
TINY DC.W $0401 ;5E0
 DC.L $A0000000
 DC.L $00000000
 DC.W $03FE ;5E-1
 DC.L $80000000
 DC.L $00000000
 DC.W $03FA ;5E-2
 DC.L $CCCCCCCC
 DC.L $CCCCCCCD
 DC.W $03F7 ;5E-3
 DC.L $A3D70A3D
 DC.L $70A3D70A
 DC.W $03F4 ;5E-4
 DC.L $83126E97
 DC.L $8D4FDF3B
 DC.W $03F0 ;5E-5
 DC.L $D1B71758
 DC.L $E219652C
 DC.W $03ED ;5E-6
 DC.L $A7C5AC47
 DC.L $1B478423
 DC.W $03EA ;5E-7
 DC.L $8637BD05
 DC.L $AF6C69B6
 DC.W $03E6 ;5E-8
 DC.L $D6BF94D5
 DC.L $E57A42BC
 DC.W $03E3 ;5E-9
 DC.L $ABCC7711
 DC.L $8461CEFD
 DC.W $03E0 ;5E-10
 DC.L $89705F41
 DC.L $36B4A597
 DC.W $03DC ;5E-11
 DC.L $DBE6FECE
 DC.L $BDEDD5BF
 DC.W $03D9 ;5E-12
 DC.L $AFEBFF0B
 DC.L $CB24AAFF
 DC.W $03D6 ;5E-13
 DC.L $8CBCCC09
 DC.L $6F5088CC
 DC.W $03D2 ;5E-14
 DC.L $E12E1342
 DC.L $4BB40E13
TINY15 DC.W $03CF ;5E-15
 DC.L $B424DC35
 DC.L $095CD80F
;
;--------------------------------------------------
;
; READ DOUBLE
;
;--------------------------------------------------
;
; CALL OPERATING SYSTEM PROCEDURE FGET
;
DGET MOVEM.W 4(SP),D5-D7/A3 ;RESTORE REGISTERS
 MOVE.W 14(SP),-(SP) ;PUSH FIB POINTER
 MOVEQ #SYSTEM,D0
 MOVEQ #GET,D1
 MOVEA.L PCODE,A0
 JSR (A0) ;FGET(F)
 LEA 4(SP),A3
 RTS
;
; EXIT FROM READ DOUBLE ROUTINE
;
DREADERR MOVE.W #BADFORMT,IORSLT ;BAD FORMAT
DREADX TST.W DS1
 BEQ DREADX1
 MOVEQ #$80,D1 ;IF SIGN THEN X:=-X
 AND.B DSIGN,D1
 OR.B D1,DS1
DREADX1 BSR PACK ;EXTENDED -> IEEE
 MOVEA.W 8(SP),A0 ;GET DOUBLE ADDR
 MOVE.L (SP)+,(A0)+ ;STORE DOUBLE
 MOVE.L (SP)+,(A0)+
 ADDQ.W #4,SP ;SKIP 2 PARAMS
 JMP (A2)
;
; READ DOUBLE. INITIALIZE FPACC1.
;
DREAD MOVEM.W D5-D7/A3,-(SP) ;SAVE REGISTERS
 MOVEA.W SP,A3
 LEA DS1,A0 ;FPACC1 := 0
 MOVEQ #0,D0
 MOVE.W D0,(A0)+
 MOVE.L D0,(A0)+
 MOVE.L D0,(A0)+
 MOVE.W D0,DSIGN ;SET FLAGS TO FALSE
;
; CHARACTER ALREADY PRESENT? IF NOT, GET ONE.
;
 MOVEA.W 10(SP),A0 ;GET FIB POINTER
 CMPI.W #NEEDCHAR,FSTATE(A0)
 BNE DREAD2
;
; SKIP LEADING BLANKS
;
DREAD1 BSR DGET ;GET A CHARACTER
DREAD2 MOVEA.W 10(SP),A0
 TST.W FEOF(A0) ;EOF REACHED?
 BNE DREADX ;EXIT IF EOF
 MOVEA.W (A0),A1 ;GET BUFFER ADDR
 MOVE.B (A1),D0 ;GET CHAR READ
 CMPI.B #' ',D0
 BEQ DREAD1 ;LOOP IF BLANK
;
; READ OPTIONAL SIGN
;
 CMPI.B #'-',D0
 SEQ DSIGN ;STORE SIGN
 BEQ DREAD3
 CMPI.B #'+',D0
 BNE DREAD4
;
; A SIGN WAS PRESENT. FETCH NEXT CHARACTER.
;
DREAD3 BSR DGET
 MOVEA.W 10(SP),A0
 TST.W FEOF(A0)
 BNE DREADX ;EXIT IF EOF
 MOVEA.W (A0),A1
 MOVE.B (A1),D0
;
; IS IT A DIGIT?
;
DREAD4 LEA DS1,A1
 CMPI.B #'0',D0
 BCS DREAD5
 CMPI.B #'9',D0
 BHI DREAD5
;
; IT IS A DIGIT. X := X * 10 + DIGIT.
;
 MOVE.B #TRUE,READIT
 BSR FASTMUL ;X := X * 10
 SUBI.B #'0',D0 ;CONV TO BINARY
 EXT.W D0
 ADD.W D0,D0
 ADD.W D0,D0
 LEA DS2,A1
 LEA @D0TO9(PC),A0 ;LOAD FP NUMBER
 MOVE.L 0(A0,D0.W),(A1)+
 MOVEQ #0,D0
 MOVE.L D0,(A1)+
 MOVE.W D0,(A1)+
 BSR LADD1 ;X := X*10 + DIGIT
 BRA DREAD3 ;GET NEXT DIGIT
;
; CHECK FOR DECIMAL POINT.
;
DREAD5 LEA DTEMP,A0
 MOVE.W (A1)+,(A0)+ ;SAVE X IN DTEMP
 MOVE.L (A1)+,(A0)+
 MOVE.L (A1)+,(A0)+
 CMPI.B #'.',D0
 BNE.L DREAD8
;
; A DECIMAL POINT HAS BEEN READ. INITIALIZE DFPU.
;
 LEA DFPU,A0
 MOVE.L #$0402A000,(A0)+ ;DFPU := 10
 MOVEQ #0,D0
 MOVE.L D0,(A0)+
 MOVE.W D0,(A0)+
;
; READ THE FRACTIONAL PART.
;
DREAD6 BSR DGET ;GET NEXT CHAR
 MOVEA.W 10(SP),A0
 MOVEA.W (A0),A1
 MOVE.B (A1),D0
 CMPI.B #'0',D0 ;IS IT A DIGIT?
 BCS DREAD7
 CMPI.B #'9',D0
 BHI DREAD7
;
; A DIGIT HAS BEEN READ. X := X + DIGIT/DFPU
;
 SUBI.B #'0',D0 ;CONV TO BINARY
 MOVE.B #TRUE,READIT
 LEA DS1,A0
 LEA DFPU,A1
 MOVE.W (A1)+,(A0)+ ;FPACC1 := DFPU
 MOVE.L (A1)+,(A0)+
 MOVE.L (A1)+,(A0)+
 EXT.W D0
 ADD.W D0,D0
 ADD.W D0,D0
 LEA @D0TO9(PC),A1
 MOVE.L 0(A1,D0.W),(A0)+ ;FPACC2 := 0..9
 MOVEQ #0,D0
 MOVE.L D0,(A0)+
 MOVE.W D0,(A0)+
 BSR LDIV1 ;DIGIT/DFPU
 MOVEA.W A0,A1
 BSR FASTMUL ;DFPU := DFPU * 10
 LEA DTEMP,A0
 BSR LADD ;X + DIGIT/DFPU
 LEA DS1+6,A1
 MOVE.L (A1),-(A0) ;X := X+DIGIT/DFPU
 MOVE.L -(A1),-(A0)
 MOVE.W -(A1),-(A0)
 MOVEA.W 10(SP),A0
 TST.W FEOF(A0)
 BEQ DREAD6
;
; THE FRACTIONAL PART HAS BEEN READ.
;
DREAD7 TST.W FEOF(A0)
 BNE DREADX ;EXIT IF EOF
 TST.B READIT ;ANY DIGITS SO FAR?
 BEQ DREADERR ;NO -> BAD FORMAT
 MOVEA.W (A0),A1
 MOVE.B (A1),D0
;
; CHECK FOR EXPONENT PART.
;
DREAD8 CMPI.B #'D',D0
 BEQ DREAD9
 CMPI.B #'d',D0
 BEQ DREAD9
 CMPI.B #'E',D0
 BEQ DREAD9
 CMPI.B #'e',D0
 BEQ DREAD9
;
; THERE IS NO EXPONENT. EXIT.
;
 TST.B READIT ;ANY DIGITS SO FAR?
 BNE DREADX ;YES -> EXIT
 BRA DREADERR ;NO  -> BAD FORMAT
;
; READ THE EXPONENT.
;
DREAD9 MOVEA.W 10(SP),A0
 TST.W FSTATE(A0)
 BNE DREAD10
 BSR DGET
 BRA DREAD11
;
DREAD10 MOVE.W #NEEDCHAR,FSTATE(A0)
;
; CALL OPERATING SYSTEM PROCEDURE READINT
;
DREAD11 MOVEM.W (SP),D5-D7/A3 ;RESTORE REGISTERS
 MOVE.W 10(SP),-(SP) ;PUSH FIB POINTER
 MOVE.W #DEXPO,-(SP) ;RESULT TO DEXPO
 MOVEQ #SYSTEM,D0
 MOVEQ #READINT,D1
 MOVEA.L PCODE,A0
 JSR (A0)
 MOVEA.W SP,A3
 MOVEA.W 10(SP),A0
 TST.W FEOF(A0)
 BNE DREADX ;EXIT IF EOF
;
; SET MANTISSA TO 1 IF THERE IS AN EXPONENT ONLY.
;
 TST.B READIT ;ANY MANT DIGITS?
 BNE DREAD12 ;YES -> SKIP
 ADDQ.B #1,READIT ;READIT := TRUE
 LEA DTEMP,A0
 MOVE.L #$03FF8000,(A0)+ ;X := 1
 MOVEQ #0,D0
 MOVE.L D0,(A0)+
 MOVE.W D0,(A0)+
;
; MULTIPLY X BY (10 ^ EXPONENT).
;
DREAD12 MOVE.W #$040E,D1
 MOVE.W DEXPO,D2
 BEQ DREADX ;DONE IF ZERO
 BPL DREAD13 ;SKIP IF POSITIVE
 MOVE.W #$840E,D1
 NEG.W D2 ;ABS(EXPONENT)
 BMI DREAD14
;
; CONVERT EXPONENT TO FLOATING POINT FORMAT.
;
DREAD13 SUBQ.W #1,D1
 ADD.W D2,D2
 BPL DREAD13 ;SHIFT UNTIL NORMAL
;
DREAD14 LEA DS1,A0
 MOVE.W D1,(A0)+
 MOVE.W D2,(A0)+
 MOVEQ #0,D0
 MOVE.W D0,(A0)+
 MOVE.L D0,(A0)+
;
; CALCULATE (10 ^ EXPONENT)
;
 LEA @DINVLG2(PC),A0
 BSR LMUL ;EXP/LG(2)
 BSR DEXP2 ;2 ^ (EXP/LG(2))
;
; CALCULATE X * 10 ^ EXPONENT AND EXIT.
;
 LEA DTEMP,A0
 BSR LMUL
 BRA DREADX
;
; FLOATING POINT NUMBERS 0 TO 9
;
D0TO9 DC.L $00000000 ;0
 DC.L $03FF8000 ;1
 DC.L $04008000 ;2
 DC.L $0400C000 ;3
 DC.L $04018000 ;4
 DC.L $0401A000 ;5
 DC.L $0401C000 ;6
 DC.L $0401E000 ;7
 DC.L $04028000 ;8
 DC.L $04029000 ;9
;
;--------------------------------------------------
;
; ASSEMBLE DOUBLE FLOATING POINT CONSTANT. THIS IS
; A COMPILER SUPPORT FUNCTION WITH THE SYNTAX
;
; DCONST(SYMBUFP,IPART,ENDI,FPART,ENDF,EPART,
;        ENDE,SIGN): DOUBLE;
;
; SYMBUFP POINTS TO THE ARRAY THAT CONTAINS THE
; CONSTANT IN ASCII FORMAT. THE OTHER PARAMETERS
; POINT TO THE BEGINNING AND END OF THE INTEGER
; PART, THE FRACTIONAL PART AND THE EXPONENT
; PART.
;
;--------------------------------------------------
;
ENDE EQU DSIGN+2
EPART EQU ENDE+2
ENDF EQU EPART+2
FPART EQU ENDF+2
ENDI EQU FPART+2
IPART EQU ENDI+2
SYMBUFP EQU IPART+2
;
; FOR I := 1 TO DSERCNT DO
;    X := X * 10 + SYMBUFP^[SYMCURSOR]
;
ACCUMUL LEA DS1,A1
 BSR FASTMUL ;X := X * 10
ACCUMUL1 MOVEA.W 4(SP),A0 ;RECALL SYMCURSOR
 MOVEQ #$D0,D0 ;D0 := -'0'
 ADD.B (A0)+,D0
 MOVE.W A0,4(SP) ;INC(SYMCURSOR)
 EXT.W D0
 ADD.W D0,D0
 ADD.W D0,D0
 LEA DS2,A1
 LEA @D0TO9(PC),A0 ;CONVERT TO FP
 MOVE.L 0(A0,D0.W),(A1)+
 MOVEQ #0,D0
 MOVE.L D0,(A1)+
 MOVE.W D0,(A1)+
 BSR LADD1 ;X := X*10 + DIGIT
 SUBQ.W #1,DSERCNT
 BPL ACCUMUL
;
 RTS
;
; CONVERT FROM ASCII TO BINARY.
;
DCONST LEA DSIGN,A0
 MOVE.L (SP)+,(A0)+ ;POP PARAMETERS
 MOVE.L (SP)+,(A0)+
 MOVE.L (SP)+,(A0)+
 MOVE.L (SP)+,(A0)+
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVEQ #0,D0
 LEA DS1,A0
 MOVE.W D0,(A0)+ ;X := 0
 MOVE.L D0,(A0)+
 MOVE.L D0,(A0)+
;
; ASSEMBLE THE INTEGER PART.
;
 MOVE.W ENDI,D1
 MOVE.W IPART,D2
 SUB.W D2,D1
 BCS DCONST1
 MOVE.W D1,DSERCNT
 ADD.W SYMBUFP,D2
 MOVE.W D2,-(SP)
 BSR ACCUMUL1
 MOVEA.W A3,SP
;
; ASSEMBLE FRACTIONAL PART.
;
DCONST1 MOVE.W #-1,DEXPO ;DEFAULT-1
 MOVE.W ENDF,D1
 MOVE.W FPART,D2
 SUB.W D2,D1
 BCS DCONST2
 MOVE.W D1,DEXPO
 MOVE.W D1,DSERCNT
 ADD.W SYMBUFP,D2
 MOVE.W D2,-(SP)
 BSR ACCUMUL
 MOVEA.W A3,SP
;
; ASSEMBLE EXPONENT PART.
;
DCONST2 MOVEQ #0,D0
 MOVE.W ENDE,D1
 MOVE.W EPART,D2
 SUB.W D2,D1
 BCS DCONST5
 ADD.W SYMBUFP,D2
 MOVEA.W D2,A0
 BRA DCONST4
;
; EXP := EXP * 10 + DIGIT
;
DCONST3 ADD.W D0,D0
 MOVE.W D0,D2
 ADD.W D0,D0
 ADD.W D0,D0
 ADD.W D2,D0
DCONST4 MOVEQ #$D0,D2 ;D2 := -'0'
 ADD.B (A0)+,D2
 EXT.W D2
 ADD.W D2,D0
 DBF D1,DCONST3
;
; EXP := EXP + LENGTH(FRACTIONAL PART)
;
DCONST5 MOVE.W DEXPO,D1
 ADDQ.W #1,D1
 TST.W DSIGN
 BMI DCONST5A
 MOVE.W #$040E,D2
 SUB.W D1,D0
 BEQ DCONSTX
 BCC DCONST6
 MOVE.W #$840E,D2
 NEG.W D0
 BPL DCONST6
 BRA DCONST6A
;
DCONST5A MOVE.W #$840E,D2
 ADD.W D1,D0
 BEQ DCONSTX
 BMI DCONST6A
;
; NORMALIZE MANTISSA
;
DCONST6 SUBQ.W #1,D2
 ADD.W D0,D0
 BPL DCONST6
;
; SAVE X AND SET THE SIGN.
;
DCONST6A LEA DS1,A0
 LEA DTEMP,A1
 MOVE.L (A0),(A1)+ ;DTEMP := X
 MOVE.W D2,(A0)+
 MOVE.W D0,(A0)+
 MOVEQ #0,D0
 MOVE.L (A0),(A1)+
 MOVE.L D0,(A0)+
 MOVE.W (A0),(A1)+
 MOVE.W D0,(A0)+
;
; CALCULATE 10 ^ EXPONENT.
;
 LEA @DINVLG2(PC),A0
 BSR LMUL
 BSR DEXP2
;
; CALCULATE X * 10 ^ EXPONENT AND EXIT.
;
 LEA DTEMP,A0
 BSR LMUL
DCONSTX BSR PACK
 JMP (A2)
;
RAMDISK EQU *
