;--------------------------------------------------
;
; DOUBLE PRECISION TRANSCENDENTALS
;
;--------------------------------------------------
;
; PERFORM SERIES EVALUATION
;
DSERSQU LEA DS1,A1
 MOVE.W (A1)+,D1
 MOVE.L (A1)+,D2
 MOVE.L (A1)+,D3
 MOVE.W D1,(A1)+ ;FPACC1 TO FPACC2
 MOVE.L D2,(A1)+
 MOVE.L D3,(A1)+
 MOVE.W D1,(A1)+ ;FPACC1 TO DFPU
 MOVE.L D2,(A1)+
 MOVE.L D3,(A1)+
 BSR LMUL1 ;SQUARE IT
 LEA DFPT,A1
 MOVE.W DS1,(A1)+ ;X SQUARED TO DFPT
 MOVE.L DM1,(A1)+
 MOVE.L DM1+4,(A1)+
 BSR LMUL
 BSR DSERIES ;DO SERIES EVAL
 LEA DFPU,A1
 MOVE.W (A1)+,DS2 ;DFPU TO FPACC2
 MOVE.L (A1)+,DM2
 MOVE.L (A1)+,DM2+4
 BRA LMUL1 ;SQUARE IT ;DONE
;
DSER1 LEA DFPT,A1
 MOVE.W (A1)+,DS2
 MOVE.L (A1)+,DM2
 MOVE.L (A1)+,DM2+4
 BSR LMUL1 ;FPACC1 * DFPT
DSERIES BSR LADD ;ADD NEXT P(I)
 SUBQ.B #1,DSERCNT ;DECR COUNT
 BNE DSER1 ;LOOP UNTIL ZERO
;
 RTS  ;RETURN
;
;--------------------------------------------------
;
; CALC LOG2(X) THEN MULT BY LG(2) RESULT LG(X)
;
;--------------------------------------------------
;
DLG LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR DLOG ;CALC LOG BASE 2
 LEA @DLG2(PC),A0 ;PTR TO LG(2)
 BSR LMUL ;ACC = ACC * LG(2)
 BSR PACK
 JMP (A2)
;
;--------------------------------------------------
;
; CALC LOG2(X) THEN MULT BY LN(2) RESULT LN(X)
;
;--------------------------------------------------
;
DLN LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR DLOG ;CALC LOG BASE 2
 BSR LMUL ;ACC = ACC * LN(2)
 BSR PACK
 JMP (A2)
;
;--------------------------------------------------
;
; CALC LOG2(X)
;
;--------------------------------------------------
;
DLOG2 LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR DLOG
 BSR PACK
 JMP (A2)
;
DLOGERR BRA FPERR
;
; CALCULATE THE LOGARITHM TO THE BASE 2
;
DLOG LEA DS1,A1
 MOVE.W (A1)+,D1
 BLE DLOGERR ;NO LOG IF <= 0
;
; THE OPERAND IS LEGAL; PROCEED WITH LOG2 CALC
;
 MOVE.L (A1)+,D2
 MOVE.L (A1)+,D3
 MOVE.W #$03FE,D0 ;EXP = -1 TO D0
 SUB.W D0,D1 ;2'S COMPL RESULT
;
; SET THE OPERAND RANGE TO SQR(.5) <= X < SQR(2)
;
 CMPI.L #$B504F333,D2 ;CMP WITH SQRT(2)
 BNE DLOGA ;DONE IF NOT SAME
 CMPI.L #$F9DE6484,D3 ;COMPARE 2ND HALF
;
DLOGA BCC DLOGB ;O.K. IF FPACC1 >=
;
 ADDQ.W #1,D0 ;EXP = $3FF
 SUBQ.W #1,D1 ;DECR ORIG EXP
;
DLOGB LEA DFPT,A1
 MOVE.W D0,DS1
 MOVE.W D0,(A1)+ ;FPACC1 TO DFPT
 MOVE.L D2,(A1)+
 MOVE.L D3,(A1)+
 MOVE.W D1,-(SP) ;STORE INTGR PART
 LEA @DLOGK(PC),A0
 BSR LADD ;CALC X-1
 LEA DFPU,A1
 MOVE.W DS1,(A1)+ ;FPACC1 TO DFPU
 MOVE.L DM1,(A1)+
 MOVE.L DM1+4,(A1)+
 MOVE.W (A1)+,DS1 ;RECALL X
 MOVE.L (A1)+,DM1
 MOVE.L (A1)+,DM1+4
 BSR LADD ;CALC X+1
 LEA DFPU,A1
 MOVE.W (A1)+,DS2 ;(X-1) TO FPACC2
 MOVE.L (A1)+,DM2
 MOVE.L (A1)+,DM2+4
 BSR LDIV1 ;CALC (X-1)/(X+1)
;
; THE RANGE OF X IS NOW .-172 TO +.172. STORE
; X IN DFPU AND STORE Z = X*X IN DFPT, FPACC1
;
; PERFORM SERIES EVALUATION, FORM IS Z*P(Z*Z)
; WHERE Z = (X-1)/(X+1).
;
 MOVE.B #6,DSERCNT ;SET SERIES N = 6
 BSR DSERSQU ;DO SERIES EVAL
;
; THE FRACTIONAL PART OF THE LOG2 IS COMPLETED
;
 MOVE.W #$040E,D1 ;SET EXP = #16
 MOVE.W (SP)+,D2
 BGT DLOGC ;SKIP IF > 0
 BEQ DLOGEXIT ;DONE IF = 0
 NEG.W D2 ;ABS(EXPONENT)
 MOVE.W #$840E,D1 ;SET SIGN NEG
;
DLOGC SUBQ.W #1,D1 ;X2 = X2 - 1
 ADD.W D2,D2 ;SHIFT MANT2 LEFT
 BPL DLOGC ;REPT TILL D15 = 1
;
 LEA DS2,A1
 MOVEQ #0,D0
 MOVE.W D1,(A1)+ ;STORE X2
 MOVE.W D2,(A1)+ ;STORE M2
 MOVE.W D0,(A1)+ ;ZERO B16-B63
 MOVE.L D0,(A1)+
 BRA LADD1 ;ADD EXP TO LOG
;
DLOGEXIT RTS  ;LOG2 DONE
;
; CALCULATE THE FRACTIONAL PART OF FPACC1
;
DFRAC0 BRA DZERO
;
DFRAC MOVE.W DS1,D1 ;FETCH THE EXP
 MOVE.W D1,D0 ;SAVE SIGN
 ANDI.W #$07FF,D0 ;MASK THE SIGN BIT
 SUBI.W #$03FE,D0 ;CALC EXP - $03FE
 BLE DLOGEXIT ;DONE IF UNDER ONE
 ANDI.W #$8000,D1
 ORI.W #$03FE,D1
 CMPI.W #16,D0 ;< 16 SHIFTS?
 BCS DUND16 ;SKIP IF LESS
 CMPI.W #32,D0 ;< 32 SHIFTS?
 BCS DUND32 ;SKIP IF LESS
 CMPI.W #64,D0 ;NO FRACTION?
 BCC DFRAC0 ;RESULT IS ZERO
;
; WE HAVE 32 OR MORE SHIFTS TO PERFORM
;
 SUBI.W #32,D0
 MOVEQ #0,D3
 MOVE.L DM1+4,D2
 LSL.L D0,D2
 BRA LNORM ;NORMALIZE
;
; WE HAVE 16 OR MORE SHIFTS TO PERFORM
;
DUND32 SUBI.W #16,D0
 MOVE.L DM1+2,D2
 MOVE.L DM1+6,D3
 CLR.W D3
 ROL.L D0,D3
 LSL.L D0,D2
 OR.W D3,D2
 CLR.W D3
 BRA LNORM ;NORMALIZE
;
; WE HAVE LESS THAN 16 SHIFTS TO PERFORM
;
DUND16 MOVE.L DM1,D2
 MOVE.L DM1+4,D3
 MOVE.L D3,D4
 CLR.W D4
 LSL.L D0,D3
 ROL.L D0,D4
 LSL.L D0,D2
 OR.W D4,D2
 BRA LNORM ;NORMALIZE
;
; CONSTANTS USED BY THE LOG ROUTINES (HART 2665)
;
DLOGK DC.W $83FF ;MINUS ONE
 DC.L $80000000
 DC.L $00000000
DFPONE DC.W $03FF ;ONE
 DC.L $80000000
 DC.L $00000000
 DC.W $03FC ;P(6)
 DC.L $FA6118DC
 DC.L $43A4B800
 DC.W $03FD ;P(5)
 DC.L $85C807A0
 DC.L $95A7C000
 DC.W $03FD ;P(4)
 DC.L $A4289100
 DC.L $003A8000
 DC.W $03FD ;P(3)
 DC.L $D30BA7EE
 DC.L $2158C000
 DC.W $03FE ;P(2)
 DC.L $93BB628E
 DC.L $F5F9F000
 DC.W $03FE ;P(1)
 DC.L $F6384EE1
 DC.L $CAE3A000
 DC.W $0400 ;P(0)
 DC.L $B8AA3B29
 DC.L $5C183800
 DC.W $03FE ;LN(2)
 DC.L $B17217F7
 DC.L $D1CF79AC
DLG2 DC.W $03FD ;LG(2)
 DC.L $9A209A84
 DC.L $FBCFF799
;
;--------------------------------------------------
;
; POWER OF TEN. TOS IS A DOUBLE. PUSH THE DOUBLE
; VALUE 10 ^ TOS.
;
;--------------------------------------------------
;
DPWROF10 LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 LEA @DINVLG2(PC),A0 ;PTR TO 1/LG(2)
 BSR LMUL
 BSR DEXP2 ;CALC EXP BASE 2
 BSR PACK
 JMP (A2)
;
;--------------------------------------------------
;
; POWER OF E. TOS IS A DOUBLE. PUSH THE DOUBLE
; VALUE E ^ TOS.
;
;--------------------------------------------------
;
DEXP LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 LEA @DINVLN2(PC),A0 ;PTR TO 1/LN(2)
 BSR LMUL
 BSR DEXP2 ;CALC EXP BASE 2
 BSR PACK
 JMP (A2)
;
;--------------------------------------------------
;
; POWER OF TWO. TOS IS A DOUBLE. PUSH THE DOUBLE
; VALUE 2 ^ TOS.
;
;--------------------------------------------------
;
DPWROF2 LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR DEXP2 ;CALC EXP BASE 2
 BSR PACK
 JMP (A2)
;
; TREAT UNDERFLOW AND OVERFLOW.
;
DEXPOVFL TST.W (SP)+ ;TEST SIGN
 BMI DZERO ;SET X TO 0
 BRA FPERR ;REPORT OVERFLOW
;
; CALCULATE THE EXPONENT FUNCTION, BASE 2
;
DEXP2 MOVE.W DS1,D0
 SMI -(SP) ;STORE THE SIGN
 ANDI.W #$07FF,D0 ;MASK SIGN BIT
 MOVE.W #$040A,D1 ;-- TEST FOR ARG
 SUB.W D0,D1 ;  OUT OF RANGE --
 BLE DEXPOVFL ;OVFL IF X>=$040A
;
; STORE THE INTEGER PART
;
 MOVE.W D0,DS1 ;SET SIGN POSITIVE
 MOVEQ #0,D2
 CMPI.W #11,D1 ;LESS THAN 1?
 BHI DEXP2A ;SKIP IF UNDER 1
 ADDQ.W #4,D1 ;CORRECT SHIFT CNT
 MOVE.W DM1,D2
 LSR.W D1,D2
DEXP2A MOVE.W D2,-(SP)
;
; CALCULATE AND NORMALIZE FRACTIONAL PART
;
 BSR DFRAC ;X := X - INT(X)
 LEA @DEXPK(PC),A0
 BSR LADD ;Z := X - 0.5
;
; PERFORM SERIES EVALUATION (HART #1069)
;
 MOVE.B #2,DSERCNT
 BSR DSERSQU
 LEA DS1,A1
 MOVE.W (A1)+,DFPU ;DFPU := P
 MOVE.L (A1)+,DFPU+2
 MOVE.L (A1)+,DFPU+6
 MOVE.L DFPT+6,-(A1) ;FPACC1 := Z * Z
 MOVE.L DFPT+2,-(A1)
 MOVE.W DFPT,-(A1)
 MOVE.B #3,DSERCNT
 BSR DSERIES
 LEA DS1,A0
 LEA DFPT,A1
 MOVE.W (A0)+,(A1)+ ;DFPT := Q
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 LEA DFPU,A0
 BSR LADD ;Q+P
 LEA DS1,A1
 LEA DFPU,A0
 MOVE.W (A1),D1 ;FPACC1 :=: DFPU
 MOVE.W (A0),(A1)+
 MOVE.W D1,(A0)+
 MOVE.L (A1),D1
 MOVE.L (A0),(A1)+
 MOVE.L D1,(A0)+
 MOVE.L (A1),D1
 MOVE.L (A0),(A1)+
 MOVE.L D1,(A0)+
 BSR LSUB ;Q-P
 LEA DFPU,A0
 BSR LDIV ;(Q+P)/(Q-P)
 MOVE.W (SP)+,D1
 ADD.W D1,DS1 ;ADD INTEGER PART
 TST.W (SP)+ ;TEST SIGN OF ARG
 BMI DEXP2B
 LEA @DSQRT2(PC),A0
 BRA LMUL ;EXIT
;
DEXP2B LEA @DINVSQRT(PC),A0
 BRA LDIV ;EXIT
;
; CONSTANTS USED TO CALCULATE EXP FUNCTION
;
DINVLG2 DC.W $0400 ;1/LG(2)
 DC.L $D49A784B
 DC.L $CD1B8AFE
DINVLN2 DC.W $03FF ;1/LN(2)
 DC.L $B8AA3B29
 DC.L $5C17F0BC
;
DEXPK DC.W $83FE ;-0.5
 DC.L $80000000
 DC.L $00000000
 DC.W $0404 ;KP(4)
 DC.L $F2759C1A
 DC.L $87D82516
 DC.W $040D ;KP(2)
 DC.L $EC9DF182
 DC.L $53AFEE92
 DC.W $0413 ;KP(0)
 DC.L $FDF402C6
 DC.L $07D9FA50
 DC.W $0409 ;KQ(4)
 DC.L $DAA934BF
 DC.L $C1C5BAD1
 DC.W $0411 ;KQ(2)
 DC.L $A005A4DB
 DC.L $9D0FE034
 DC.W $0415 ;KQ(0)
 DC.L $B73040B8
 DC.L $713968EA
DSQRT2 DC.W $03FF ;1.4142
 DC.L $B504F333
 DC.L $F9DE6484
DINVSQRT DC.W $03FE ;0.7071
 DC.L $B504F333
 DC.L $F9DE6484
;
;--------------------------------------------------
;
; CALC THE SQUARE ROOT OF THE 68000 FPACC1
;
;--------------------------------------------------
;
DSQRT0 BMI FPERR ;ERROR IF NEG
DZEROX MOVEM.W (SP)+,D5-D7/A3
 MOVEQ #0,D0
 MOVE.L D0,-(SP)
 MOVE.L D0,-(SP)
 JMP (A2)
;
DSQRT LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 TST.W D1 ;CHK SIGN
 BLE DSQRT0
;
; THE OPERAND IS LEGAL; PROCEED WITH SQRT CALC
;
 LEA DFPU+10,A0
 MOVE.L D3,-(A0)
 MOVE.L D2,-(A0)
 MOVE.W #$03FE,-(A0) ;1/2 <= X < 1
 BTST #0,D1 ;IS EXP EVEN?
 BEQ DEVNEXP ;SKIP IF EVEN
 SUBQ.W #1,(A0) ;DECR EXP
 LSR.L #1,D2 ;MANT = MANT/2
;
; CALCULATE AND STORE THE EXP OF THE RESULT
;
DEVNEXP MOVE.W #$01FF,D5
 LSR.W #1,D1
 ADDX.W D5,D1
 MOVE.W D1,-(SP)
;
; SET Y0 = $FFFF (1ST GUESS DELIBERATELY HIGH)
;
 MOVE.W #$FFFF,D2
;
; PERFORM Y(N+1) = (Y(N) + X/Y(N))/2 4 TIMES
;
 MOVE.W #3,D0 ;SET FOR 4 LOOPS
 MOVE.W D2,D5 ;Y0 = $FFFF
;
DSQRT1 MOVE.L D2,D6 ;MOVE X TO D6
 DIVU D5,D6 ;D6 = X/Y
 ADD.W D6,D5 ;D5 = Y + X/Y
 ROXR.W #1,D5 ;DIV BY 2
 DBF D0,DSQRT1 ;LOOP 4 TIMES
;
; FLOAT THE 16 BIT APPROXIMATION
;
 SWAP D5
 CLR.W D5
 MOVEQ #0,D6
 LEA DS1,A1
 MOVE.W #$03FE,(A1)+
 MOVE.L D5,(A1)+
 MOVE.L D6,(A1)+
;
; FIFTH ITERATION
;
 LEA DFPT,A1
 MOVE.W #$03FE,(A1)+
 MOVE.L D5,(A1)+
 MOVE.L D6,(A1)+
 BSR LDIV
 BSR LADD
;
; SIXTH ITERATION
;
 LEA DS1,A0
 LEA DFPT,A1
 SUBQ.W #1,(A0)
 MOVE.W (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 LEA DFPU,A0
 BSR LDIV
 BSR LADD
;
; RESTORE THE EXPONENT OF THE RESULT
;
 MOVE.W (SP)+,D1
 SUBI.W #$03FF,D1
 ADD.W D1,DS1
 BSR PACK
 JMP (A2)
;
;--------------------------------------------------
;
; CALCULATE THE COSINE OF THE 68000 FPACC1
;
;--------------------------------------------------
;
DCOS LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 TAS DS1 ;SET FPACC1 NEG
 LEA @DCOSK(PC),A0 ;POINT A0 AT #PI/2
 BSR LADD ;90 DEG - ACCUM
 BRA DSIN1
;
;--------------------------------------------------
;
; CALCULATE THE SINE OF THE 68000 FPACC1
;
;--------------------------------------------------
;
DSIN LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
DSIN1 BCLR #7,DS1 ;SET FPACC1 POS
 SNE -(SP) ;STORE THE SIGN
 LEA @DSINK(PC),A0 ;POINT AT 1/(2#PI)
 BSR LMUL
 BSR DFRAC ;RESULT UND 360 DEG
 ADDQ.W #2,DS1 ;MULT FPACC1 BY 4
 CMPI.W #$0400,DS1 ;FPACC1 < 2 ?
 BCS DUNDTWO ;SKIP IF UNDER TWO
;
; TOGGLE THE SIGN AND SUBTRACT TWO
;
 NOT.W (SP) ;TOGGLE SIGN
 LEA @DMINUS2(PC),A0 ;-2 TO FPACC2
 BSR LADD
;
; THE OPERAND IS NOW IN THE RANGE 0 TO 1.999999
; IF LESS THAN ONE, PROCEED WITH CALCULATION,
; ELSE SUBTRACT OPERAND FROM ONE AND PROCEED
;
DUNDTWO CMPI.W #$03FF,DS1
 BCS DUNDONE ;SKIP IF < 1
;
; SET X = 90 DEGREES MINUS X
;
 LEA @DFPTWO(PC),A0 ;2 TO FPACC2
 BSR LSUB ;SUBTRACT
;
; THE RANGE OF X IS NOW 0 TO .99999999.
; NOW PERFORM SERIES EVALUATION, N = 7
;
DUNDONE MOVE.B #7,DSERCNT ;SET SERIES N = 7
 LEA @DSINK1(PC),A0
 BSR DSERSQU ;FORM X*P(X*X)
 BSR TESTPACK ;SINE CALC DONE
 JMP (A2)
;
; CONSTANTS USED BY THE COSINE AND SINE CALCS
; FORMULA 3344 HART, FORM X*P(X*X)
;
DSINK DC.W $03FC ;1/(2#PI)
 DC.L $A2F9836E
 DC.L $4E44152A
DMINUS2 DC.W $8400 ;-2
 DC.L $80000000
 DC.L $00000000
DFPTWO DC.W $0400 ;2
 DC.L $80000000
 DC.L $00000000
DSINK1 DC.W $83E0 ;P7
 DC.L $B1313233
 DC.L $A2180000
 DC.W $03E6 ;P6
 DC.L $F44E7501
 DC.L $852C0000
 DC.W $83EC ;P5
 DC.L $F18311E1
 DC.L $9C260000
 DC.W $03F2 ;P4
 DC.L $A83C1924
 DC.L $E79B0000
 DC.W $83F7 ;P3
 DC.L $99696670
 DC.L $BE990000
 DC.W $03FB ;P2
 DC.L $A335E33B
 DC.L $A8830000
 DC.W $83FE ;P1
 DC.L $A55DE731
 DC.L $2DEB0000
DCOSK DC.W $03FF ;P0 = #PI/2
 DC.L $C90FDAA2
 DC.L $2168C235
;
;--------------------------------------------------
;
; CALCULATE THE TANGENT FUNCTION IN RADIANS
;
;--------------------------------------------------
;
DTAN LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
;
; FIRST REDUCE THE RANGE TO -180 DEG < X < 180 DEG
;
 LEA @DTANK(PC),A0 ;PTR TO 1/PI
 BSR LMUL ;(#1 = 180 DEG)
 BSR DFRAC ;RESULT < 180 DEG
;
; REDUCE THE RANGE TO 0 <= X < 180 DEG
;
 BCLR #7,DS1 ;SET ARG POSITIVE
 SNE -(SP) ;SET SIGN FLAG
 MOVE.W #0,-(SP) ;CLEAR FLAGS
;
; REDUCE THE RANGE TO 0 <= X < 90 DEG
;
 CMPI.W #$03FE,DS1 ;FPACC < 1/2 ?
 BCS DTUH ;SKIP IF < 1/2
 NOT.W 2(SP) ;FLIP SIGN FLAG
 LEA @DFPONE(PC),A0 ;ONE TO FPACC2
 BSR LSUB ;180 DEG - X
;
; IF THE ARGUMENT IS 45 DEGREES OR MORE, SET
; THE INVERT FLAG AND LET X = 90 DEG - X
;
DTUH CMPI.W #$03FD,DS1 ;FPACC < 1/4 ?
 BCS DTUQ ;SKIP IF < 1/4
 MOVE.W #2,(SP) ;B1 IS INVERT FLAG
 LEA @DFPHALF(PC),A0 ;1/2 TO FPACC2
 BSR LSUB ;90 DEG - X
;
; THE ARGUMENT IS NOW LESS THAN 45 DEGREES; REDUCE
; THE RANGE TO 22.5 DEGREES AND SET THE REDUCTION
; (RED.) FLAG IF 22.5 DEG <= ARGUMENT.
;
DTUQ CMPI.W #$03FC,DS1 ;FPACC < 1/8 ?
 BCS DTUE ;SKIP IF < 1/8
 ADDQ.W #1,(SP) ;B0 IS RED. FLAG
 ADDQ.W #2,DS1 ;RANGE 0 TO 1
 BRA DTUE1
;
; THE ARGUMENT IS NOW LESS THAN 22.5 DEGREES;
; PERFORM SERIES EVALUATION HART 4187 FORM X*P(X*X)
;
DTUE ADDQ.W #3,DS1 ;RANGE 0 TO 1
DTUE1 LEA @DTANK1(PC),A0 ;PTR TO SERIES K'S
 MOVE.B #8,DSERCNT ;SET SERIES N = 8
 BSR DSERSQU ;DO SERIES EVAL
;
; ADJUST FOR RANGE REDUCTION IF NEEDED
;
 LSR (SP) ;TEST RED. FLAG
 BCC DNOTRNG ;SKIP IF NOT SET
 LEA DS1,A1
 MOVE.W (A1)+,D1
 MOVE.L (A1)+,D2
 MOVE.L (A1)+,D3
 MOVE.W D1,(A1)+
 MOVE.L D2,(A1)+
 MOVE.L D3,(A1)+
 MOVE.W D1,(A1)+ ;X TO DFPU
 MOVE.L D2,(A1)+
 MOVE.L D3,(A1)+
 BSR LMUL1 ;SQUARE
 LEA @DFPONE(PC),A0 ;PTR TO 1
 BSR LSUB ;1 - X*X
 LEA DFPU,A0 ;PTR TO X
 BSR LDIV ;X/(1 - X*X)
 ADDQ.W #1,DS1 ;2X/(1 - X*X)
;
; INVERT IF THE INVERT FLAG IS SET
;
DNOTRNG TST.W (SP)+ ;TEST INV. FLAG
 BEQ DTANX ;EXIT IF NOT SET
 LEA @DFPONE(PC),A0 ;PTR TO 1
 BSR LDIV ;INVERT FPACC1
DTANX BSR TESTPACK ;TANGENT CALC DONE
 JMP (A2)
;
; CONSTANTS USED BY THE TANGENT ROUTINE
;
DFPHALF DC.W $03FE ;1/2
 DC.L $80000000
 DC.L $00000000
DTANK DC.W $03FD ;1/PI
 DC.L $A2F9836E
 DC.L $4E44152A
DTANK1 DC.W $03DD ;P8
 DC.L $D967E1E4
 DC.L $26B50000
 DC.W $03E1 ;P7
 DC.L $9C3DCBC6
 DC.L $36420000
 DC.W $03E5 ;P6
 DC.L $A36961F9
 DC.L $A9400000
 DC.W $03E9 ;P5
 DC.L $A2F56855
 DC.L $79470000
 DC.W $03ED ;P4
 DC.L $A2FA50DA
 DC.L $798D0000
 DC.W $03F1 ;P3
 DC.L $A2FFFC90
 DC.L $F6260000
 DC.W $03F5 ;P2
 DC.L $A335E33C
 DC.L $201E0000
 DC.W $03F9 ;P1
 DC.L $A55DE731
 DC.L $2DAE0000
 DC.W $03FD ;P0 = PI/8
 DC.L $C90FDAA2
 DC.L $2168C235
;
;--------------------------------------------------
;
; CALCULATE THE ARC TANGENT FUNCTION IN RADIANS
;
;--------------------------------------------------
;
DARCTAN0 ADDQ.W #2,SP
 BRA DZEROX
;
DARCTAN LEA DS1,A0
 BSR UNPACK
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BCLR #7,DS1 ;SET SIGN POS
 SNE -(SP) ;STORE SIGN
 MOVE.W DS1,D0
 BEQ DARCTAN0 ;RESULT IS ZERO
 MOVE.W #0,-(SP) ;CLEAR INV FLAG
 CMPI.W #$03FF,D0 ;ONE OR GREATER?
 BCS DARCTAN1 ;SKIP IF NOT
 LEA @DFPONE(PC),A0
 BSR LDIV ;CALC RECIPROCAL
 MOVE.W #1,(SP) ;SET INV FLAG
;
; TEST WHETHER RANGE REDUCTION IS NECESSARY
;
DARCTAN1 LEA @DX1(PC),A0
 MOVE.L DS1,D1
 MOVEQ #3,D0
;
DARCTAN2 CMP.L (A0),D1
 BNE DARCTAN3
 MOVE.L DS1+4,D2
 CMP.L 4(A0),D2
 BNE DARCTAN3
 MOVE.W DS1+8,D2
 CMP.W 8(A0),D2
DARCTAN3 LEA 40(A0),A0
 DBCS D0,DARCTAN2
;
 BCC DARCTAN4
 LEA -40(A0),A0
DARCTAN4 SUBQ.W #3,D0 ;SET RED. FLAG
 MOVE.W D0,-(SP) ;STORE IT
 BEQ DARCTAN5 ;NO REDUCTION
 LEA -30(A0),A0 ;POINT TO AN
 BSR LADD ;X + AN
 BSR LDIV ;BN/(X + AN)
 MOVE.L A0,DTEMP ;STORE CN ADDR
 LEA -20(A0),A0 ;PTR TO AN
 BSR LSUB ;AN - BN/(X + AN)
;
; RANGE REDUCTION TO -X1 TO X1 ACCOMPLISHED
; PERFORM SERIES EVALUATION; FORM IS X*P(X*X)
;
DARCTAN5 MOVE.B #5,DSERCNT ;SET N = 5
 LEA @DATNK(PC),A0 ;PTR TO ATN CONSTS
 BSR DSERSQU ;DO SERIES EVAL
;
; ADD CN IF RANGE REDUCTION WAS DONE
;
 TST.W (SP)+ ;TEST RED. FLAG
 BEQ DARCTAN6 ;SKIP IF ZERO
 MOVEA.L DTEMP,A0 ;FETCH CN PTR
 BSR LADD ;ADD CN
;
; CORRECT FOR PREVIOUS INVERSION IF NEEDED
;
DARCTAN6 TST.W (SP)+ ;TEST INV FLAG
 BEQ DARCTANX ;EXIT IF ZERO
 LEA @DCOSK(PC),A0 ;PTR TO PI/2
 BSR LSUB ;90 DEG - FPACC1
DARCTANX BSR TESTPACK ;ARC TAN DONE
 JMP (A2)
;
; CONSTANTS USED TO EVALUATE ARC TANGENT
;
DATNK DC.W $83FB ;P5
 DC.L $B5AB6364
 DC.L $E40E0000
 DC.W $03FB ;P4
 DC.L $E381AEE4
 DC.L $C3E40000
 DC.W $83FC ;P3
 DC.L $92491C85
 DC.L $32D10000
 DC.W $03FC ;P2
 DC.L $CCCCCCC8
 DC.L $1F2E0000
 DC.W $83FD ;P1
 DC.L $AAAAAAAA
 DC.L $AA2B0000
 DC.W $03FF ;P0
 DC.L $80000000
 DC.L $00000000
;
; CONSTANTS USED TO ADJUST RANGE OF ATN CALC
;
DX1 DC.W $03FB ;X1
 DC.L $C9B5DC62
 DC.L $D96D0000
 DC.W $0401 ;A1
 DC.L $A0DFF712
 DC.L $123C0000
 DC.W $0403 ;B1
 DC.L $D231718D
 DC.L $ED740000
 DC.W $03FC ;C1 = PI/16
 DC.L $C90FDAA2
 DC.L $2168C235
 DC.W $03FD ;X2
 DC.L $9B5041AA
 DC.L $E31F0000
 DC.W $0400 ;A2
 DC.L $9A827999
 DC.L $FCEF0000
 DC.W $0401 ;B2
 DC.L $DA827999
 DC.L $FCEF0000
 DC.W $03FD ;C2 = 2PI/16
 DC.L $C90FDAA2
 DC.L $2168C235
 DC.W $03FE ;X3
 DC.L $88D5B8C8
 DC.L $41A70000
 DC.W $03FF ;A3
 DC.L $BF90C712
 DC.L $D3A30000
 DC.W $0400 ;B3
 DC.L $CF595AEE
 DC.L $A7CA0000
 DC.W $03FE ;C3 = 3PI/16
 DC.L $96CBE3F9
 DC.L $990E91A8
 DC.W $03FE ;X4
 DC.L $D2180157
 DC.L $21420000
 DC.W $03FF ;A4
 DC.L $80000000
 DC.L $00000000
 DC.W $0400 ;B4
 DC.L $80000000
 DC.L $00000000
 DC.W $03FE ;C4 = 4PI/16
 DC.L $C90FDAA2
 DC.L $2168C235
;
 CHAIN DIO
