;**************************************************
;
; MOTOROLA 68000 FLOATING POINT PACKAGE
; (NOT ORIGINAL VERSION)   8/08/82
;
; COPYRIGHT 1982 DIGITAL ACOUSTICS INC.
;
; THIS FLOATING POINT PACKAGE IS COMPATIBLE
; WITH THAT USED IN APPLESOFT 
;
; MODIFIED TO WORK WITH THE INTER68 P-CODE INTER-
; PRETER BY ULRICH SCHMIDT (SEPTEMBER 1983)
;
; FOLLOWING ARE MEMORY ASSIGNMENTS FOR THIS CODE:  
;
TREG EQU TEMP
S1 EQU TREG+8
X1 EQU S1+1
M1 EQU X1+1
G1 EQU M1+4
S2 EQU G1+2
X2 EQU S2+1
M2 EQU X2+1
G2 EQU M2+4
FPT EQU G2+2
FPU EQU FPT+8
LOGX EQU FPU+8
SINSGN EQU LOGX   
SERCNT EQU LOGX+1 
EXPADD EQU LOGX+2 ;EXP ADDER
;
; EXPAND A 4 BYTE FP NUMBER INTO AN 8 BYTE NUMBER.
;
EXPAND MOVE.W D1,D2
 ASR.W #7,D2
 ANDI.W #$80FF,D2
 ADDQ.B #2,D2
 BCS FPERR
 TAS D1
 SWAP D1
 ASL.L #8,D1
 LEA S1,A1
 MOVE.W D2,(A1)+
 MOVE.L D1,(A1)+
 MOVE.W #0,(A1)+
 RTS
;
; CONVERT AN 8 BYTE FP NUMBER INTO A 4 BYTE NUMBER.
;
COMPRESS LEA S1,A0
 MOVE.W (A0)+,D1
 SUBQ.B #2,D1
 BCS FPZERO
 MOVE.W D1,D2
 ANDI.W #$8000,D2
 MOVEQ #0,D0
 MOVE.L (A0)+,D3
 TST.B D3
 BPL COMPR1
 ADDI.L #$100,D3
 ADDX.B D0,D1
COMPR1 ASL.W #7,D1
 OR.W D2,D1
 LSR.L #8,D3
 SWAP D3
 ANDI.W #$7F,D3
 OR.W D1,D3
 MOVEA.W A3,SP
 MOVEM.W (SP)+,D5-D7/A3
 MOVE.L D3,-(SP)
 JMP (A2)
;
FPERR MOVEA.W A3,SP
 MOVEM.W (SP)+,D5-D7/A3
 CLR.W D0
 SUBQ.W #2,A4
 BRA XFPIERR
;
FPZERO MOVEA.W A3,SP
 MOVEM.W (SP)+,D5-D7/A3
 MOVEQ #0,D0
 MOVE.L D0,-(SP)
 JMP (A2)
;
RETN1 RTS  ;SUBROUTINE DONE
;
; START OF FLOATING POINT SUBTRACT  
;
FPSUB BCHG #7,S1 ;TOGGLE D7 OF S1
;
; FETCH A 6 BYTE F.P. NUMBER TO FPACC#2 
;
FPADD MOVE.W (A0)+,S2
 MOVE.L (A0)+,M2
;
; START OF FLOATING POINT ADD 
;
FPADD1 MOVE.B X2,D0
 BEQ RETN1 ;DONE IF X2 = 0
;
 MOVE.L M1,D1 ;MOVE MANT1 TO D1
 CLR.B D5 ;MANT2 GUARD
 MOVE.B G1,D6 ;MANT1 GUARD
 CMP.B X1,D0 ;COMPARE EXPONENTS
 BCS ONEGT2 ;OK IF X1 > X2 
;
 BNE MSWAP ;SWAP IF X1 < X2
;
 CMP.L M2,D1 ;COMPARE MANTISSAS 
 BCC ONEGT2 ;OK IF M1>=M2 
;
; SWAP THE FPACCS AND CLEAR THE GUARD BYTE
;
MSWAP MOVE.L M2,D1
 MOVE.L M1,M2 
 MOVE.L D1,M1
 MOVE.W S2,D2
 MOVE.W S1,S2
 MOVE.W D2,S1
 MOVE.B D6,D5
 CLR.B D6
;
; FPACC1 IS >= FPACC2;  NOW ALIGN MANTISSAS
;
ONEGT2 MOVE.B X2,D0
 MOVE.B X1,D2
 BEQ RZER ;DONE IF EXP IS 0
;
 MOVE.L M2,D3 ;MANT2 TO D3
 SUB.B D0,D2 ;D2=X1-X2
 BEQ ALIGND ;SKIP IF EXP'S EQ
;
 CMPI.B #33,D2
 BCC ADDX ;DONE IF DIFF>#31
;
; FIRST TEST WHETHER 8 OR MORE SHIFTS ARE REQ'D
;
 CMPI.B #8,D2
 BCS SHIFTR ;SKIP IF < 8
 BEQ SHIF8R ;SKIP IF = 8
;
; SHIFT MANT2 RIGHT N-8 BITS, WHERE N IS
; THE TOTAL NUMBER OF BIT SHIFTS REQUIRED
;
 SUBQ.B #8,D2
 LSR.L D2,D3
;    
; EXACTLY 8 BIT SHIFTS ARE NEEDED. TRANSFER THE 
; LOWEST 8 BITS TO THE GUARD BYTE
; AND THEN SHIFT THE 32 BIT MANT2 8 BITS RIGHT
;
SHIF8R MOVE.B D3,D5
 LSR.L #8,D3
 BRA ALIGND ;MANTS ALIGNED
;
; SHIFT THE 32 BIT MANT IN D3 RIGHT BY # IN D2
;
SHIFTR LSR.L #1,D3
 ROXR.B #1,D5 ;SHIFT CY TO D5
 SUBQ.B #1,D2
 BNE SHIFTR ;LOOP UNTIL D2 = 0
;
; THE MANTISSAS ARE ALIGNED IN D1 AND D3
;
ALIGND MOVE.B S1,D2
 MOVE.B S2,D4
 EOR.B D2,D4
 BMI MSUB ;SUBTRACT IF DIFF
;
; ADD THE TWO MANTISSAS AND GUARD BYTES
;
 ADD.B D5,D6 ;G2+G1 TO G1
 ADDX.L D3,D1 ;D1 = D3+D1
 BCC ADDX ;SKIP IF NO CY
;
; NORMALIZE THE MANT RIGHT AND INCREMENT EXP1
;
 ROXR.L #1,D1
 ROXR.B #1,D6
 ADDQ.B #1,X1
 BEQ OV ;REPORT OVERFLOW
;
ADDX MOVE.L D1,M1
 MOVE.B D6,G1
 RTS
;
OV BRA FPERR
;
; THE RESULT IS ZERO;  CLR S1, EXP1, MANT1
;
RZER MOVEQ #0,D0
 MOVE.L D0,S1 ;ZERO S1, EXP1
 MOVE.L D0,M1+2 ;ZERO MANT1,G1
 RTS
;
; SUBTRACT MANT2 FROM MANT1
;
MSUB MOVE.B X1,D2 ;EXP1 TO D2
 SUB.B D5,D6 ;(GUARD BYTES)
 SUBX.L D3,D1 ;M1 = M1-M2
 BMI SUBX ;OK IF D31= 1
;
 BNE NORM ;NORM IF M1<>0
;
; MANT1 IS ZERO;  FETCH THE GUARD BYTE
;
 MOVE.B D6,D1
 BEQ RZER ;ZERO IF GRD= 0
;
 SUBI.B #32,D2 ;X1 = X1- 32
 BLS RZER ;0 IF EXP=< 0
;
 CLR.W D6 ;CLR GUARD BYTE
 SWAP D1
 ASL.L #8,D1
 BMI SUBX ;OK IF D31= 1
;
 BRA LT8 ;UNCOND BRANCH
;
; NORMALIZE MANT1 (IN D1) AND EXP1 (IN D2);
; FIRST CHECK IF 16 BIT SHIFTS ARE NEEDED
;
NORM CMPI.L #$00010000,D1
;
; IF MANT1 < $00010000, THEN SWAP HALVES & ADJ EXP
;
 BCC LT16 ;SKIP IF LESS
;
 SUBI.B #16,D2
 BLS RZER
;
 SWAP D1
 ASL.W #8,D6
 MOVE.W D6,D1
 MOVE.L D1,D7
 BMI SUBX ;SKIP IF D31= 1
;
; CHECK WHETHER 8 BIT SHIFTS ARE NEEDED
;
LT16 CMPI.L #$01000000,D1
;
; IF MANT1 < $01000000, SHIFT L 8 BITS & ADJ EXP
;
 BCC LT8 ;SKIP IF LESS
;
 SUBQ.B #8,D2 ;X1= X1- 8
 BLS RZER ;ZERO ON UNDERFLOW
;
 ASL.L #8,D1 ;SHIFT M1 #8 LEFT
 MOVE.B D6,D1
 CLR.W D6
 MOVE.L D1,D7
 BMI SUBX ;SKIP IF D31= 1
;
; SHIFT ONE BIT AT A TIME UNTIL NORMALIZED
;
LT8 SUBQ.B #1,D2 
 BLS RZER ;ZERO ON UNDERFLOW
;
 ADD.B D6,D6
 ADDX.L D1,D1
 BPL LT8 ;LOOP UNTIL D31= 1
;
; THE NORMALIZATION IS DONE;  RESTORE X1,M1,G1
;
SUBX MOVE.B D2,X1 
 MOVE.L D1,M1
 MOVE.B D6,G1
 RTS
;
OVFL1 BRA FPERR
;
RZER1 BRA RZER
;
; FETCH A 6 BYTE F.P. # TO FPACC2, MULTIPLY
; TIMES FPACC1, LEAVE THE RESULT IN FPACC1
;
FPMUL MOVE.W (A0)+,S2
 MOVE.L (A0)+,M2
;
; CALCULATE THE EXPONENT OF THE RESULT
;
FPMUL1 MOVE.B X1,D5 ;X1 TO D5
 BEQ RZER1 ;ZERO IF X1= 0
;
 MOVE.B X2,D6 ;X2 TO D6
 BEQ RZER1 ;ZERO IF X2= 0
;
 ADD.B D5,D6 ;ADD EXPONENTS
 BCC UND80 ;SKIP IF CY= 0
;
 BMI OVFL1 ;OVFL IF CY, D7= 1
;
 BPL OV80 ;EXP $80 TO $FF
;
UND80 BPL RZER1 ;EXP UNDERFLOW
;
OV80 ADDI.B #$80,D6 ;CORRECT EXP
 BEQ RZER1 ;BR IF EXP IS ZERO
;
; CALCULATE AND STORE THE SIGN OF THE RESULT
;
 MOVE.B S2,D5
 EOR.B D5,S1
;
; THE FOLLOWING CODE MULTIPLIES 32 * 40 BITS
;
 MOVE.W G1,D0
 CLR.B D0
 MOVE.W D0,D3
 MOVE.W M1+2,D1
 MOVE.W D1,D4
 MOVE.W M1,D2
 MOVE.W D2,D5
 MOVE.W M2+2,D7
 MULU D7,D0
 MULU D7,D1
 MULU D7,D2
 MOVE.W M2,D7
 MULU D7,D3
 MULU D7,D4
 MULU D7,D5
;
; MULTIPLICATION IS COMPLETE
; NOW ALIGN AND ADD THE PARTIAL PRODUCTS
;
; D0 =                       HHHH HHHH
; D1 =                  HHHH HHHH
; D2 =             HHHH HHHH
; D3 =                  HHHH HHHH
; D4 =             HHHH HHHH
; D5 =        HHHH HHHH
; PRODUCT =   MMMM MMMM GG
; WHERE M= 32 BIT MANTISSA,  G= 8 BIT GUARD
;
 CLR.W D0
 SWAP D0
 ADD.L D0,D1
 ADD.L D1,D3
 BCC MUL2
 ADDQ.L #1,D5
MUL2 CLR.W D3
 SWAP D3
 ADD.L D3,D2
 ADD.L D2,D4
 BCC MUL4
 SWAP D5
 ADDQ.W #1,D5
 SWAP D5
;
; STORE THE GUARD BYTRE IN D0, BITS B15 THRU B8
;
MUL4 MOVE.W D4,D0
 CLR.W D4
 SWAP D4
;
; NO CARRY IS POSSIBLE ON AN ADD TO D5
;
 ADD.L D4,D5
 BMI MULX ;SKIP IF D31= 1
;
; NORMALIZE BY SHIFTING LEFT ONE BIT, X1= X1- 1
;
 ADD.W D0,D0
 ADDX.L D5,D5
 SUBQ.B #1,D6
 BEQ DRZER
MULX MOVE.B D6,X1
 MOVE.L D5,M1
 MOVE.W D0,G1
 RTS
;
DIVBY0 MOVEA.W A3,SP
 MOVEM.W (SP)+,D5-D7/A3
 CLR.W D0
 SUBQ.W #2,A4
 BRA XDIVZER
;
OVFL BRA FPERR
;
DRZER BRA RZER ;RESULT IS ZERO
;
; FETCH A 6 BYTE F.P. NUMBER TO FPACC2, ROUND 
; FPACC1, THEN DIVIDE FPACC1 INTO FPACC2.
; THE RESULT IS STORED IN FPACC1 WITH GUARD.
;
FPDIV MOVE.W (A0)+,S2
 MOVE.L (A0)+,M2
;
; FETCH MANT1, BOTH EXPONENTS TO DATA REGS
;
FPDIV1 CLR.W D4
 CLR.W D6
 MOVE.B X1,D6 ;X1 TO D6
 BEQ DIVBY0 ;CAN'T DIV BY 0
 MOVE.B X2,D4 ;X2 TO D4
 BEQ DRZER ;ZERO IF X2 = 0
 MOVE.L M1,D0
;
; ROUND X1, M1, G1  (X1, M1 ARE IN DATA REGS)
;
 ASL G1 ;MSB OF GRD TO CY
 BCC FPDIV2 ;SKIP IF NO CY
 ADDQ.L #1,D0 ;INCR MANT1
 BCC FPDIV2 ;SKIP IF NO CY
;
; SET MANT1= $80000000 AND INCR X1
;
 ROXR.L #1,D0
 ADDQ.B #1,D6
;
; THE RESULT IS ZERO IF X1 OVERFLOWS
;
 BEQ DRZER ;RZER ON X1 OVFL
;
; CALCULATE THE EXPONENT OF THE RESULT
;
FPDIV2 SUB.W D6,D4 ;16 BIT SUBTR
 ADDI.W #$80,D4 ;(CORRECT EXP)
;
; (DO NOT TEST FOR OV/UNDFLOW NOW)
;
; CALCULATE AND STORE THE SIGN OF THE RESULT
;
 MOVE.B S2,D6
 EOR.B D6,S1
;
; PERFORM 32 BIT INTEGER DIVISION
;
 CLR.W D5
 MOVE.L M2,D7
 CMP.L D0,D7
 BCS D0GTD7
 BEQ ONE ;RESULT ONE IF EQL
 MOVEQ #1,D5
 SUB.L D0,D7
D0GTD7 MOVEA.W D5,A1 ;SAVE D5
 BSR DIVSUB
 SWAP D3
 MOVE.L D6,D7
 BSR DIVSUB
;
; REMAINDER IN D6, BITS 15 THRU 8 (GUARD BYTE)
;
 DIVU D1,D6
 BVC FPDIV3
 MOVEQ #$FF,D6
;
; THE INTEGER DIVISION IS DONE;  NOW NORMALIZE
;
FPDIV3 MOVE.W A1,D5 ;RECALL D5 DATA
 BEQ DIVX
;
; THE RESULT IS EQUAL TO OR GREATER THAN ONE;
; NORMALIZE RIGHT AND INCREMENT X1
;
 SUBQ.W #2,D5
 ROXR.L #1,D3
 ROXR.W #1,D6
 ADDQ.W #1,D4
;
; TEST EXPONENT FOR UNDERFLOW OR OVERFLOW
;
DIVX MOVE.W D4,D0
 BMI DRZER
 ANDI.W #$FF00,D0
 BNE OVFL
;
; RETURN X1, MANT1, GUARD BYTE TO FPACC1
;
 MOVE.B D4,X1
 MOVE.L D3,M1
 MOVE.W D6,G1
 RTS
;
; THE TWO MANTISSAS ARE EQUAL; THE RESULT= #1
;
ONE ADDQ.W #1,D4
 MOVE.L #$80000000,D3
 CLR.W D6
 BRA DIVX ;RETURN W/X1,M1,G1
;
; SUBROUTINE; DIVIDE 16 BITS INTO 32
;
DIVSUB MOVE.L D7,D6
 MOVE.L D0,D1
 CLR.W D1
 SWAP D1
 DIVU D1,D7
 BVC DIVOK
 MOVEQ #$FF,D7
DIVOK MOVE.W D7,D2
 MOVE.W D7,D3
 MULU D0,D2
 MULU D1,D7
 MOVE.W D2,D5
 CLR.W D2
 SWAP D2
 ADD.L D2,D7
 CLR.W D2
 SUB.W D5,D2
 SUBX.L D7,D6
 BPL SHIFTW
NEG SUBQ.W #1,D3
 ADD.W D0,D2
 ADDX.L D1,D6
 BMI NEG
SHIFTW SWAP D6
 MOVE.W D2,D6
 RTS
;
; CALCULATE THE LOGARITHM TO THE BASE 10
;
LOG MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR LOGLN
 LEA @LG2(PC),A0 ;PTR TO LG(2)
 BSR FPMUL
 BRA COMPRESS
;
; CALCULATE THE LOGARITHM TO THE BASE 2
;
LOG2 MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR LOGLN
 BRA COMPRESS
;
; CALCULATE THE LOGARITHM TO THE BASE E 
;
LNERR BRA FPERR
;
LNZERO BRA FPZERO
;
LN MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 BSR LOGLN
 BSR FPMUL
 BRA COMPRESS
;
LOGLN MOVE.W D1,D2
 BLE LNERR ;NO LN IF NEG
 ANDI.W #$7F80,D2
 BEQ LNERR ;NO LN IF ZERO
 CMPI.L #$00003F80,D1
 BEQ LNZERO
 BSR EXPAND
 MOVE.W S1,D1
;
; THE OPERAND IS LEGAL;  PROCEED WITH LOG2 CALC
;
 MOVEQ #$80,D0
 SUB.B D0,D1 ;2'S COMP RESULT
 MOVE.B D1,LOGX ;STORE INT PART
;
; SET OPERAND RANGE TO .5=< X < 1
;
 MOVE.B D0,X1
 LEA @LOGK(PC),A0 ;PTR TO LOGK TBL
 BSR FPADD ;ADD 1/SQR(2)
 BSR FPDIV ;DIV INTO SQR(2)
 BSR FPSUB ;SUBTR FROM #1
;
; THE RANGE OF X IS NOW -.172 TO +.172. STORE
; X IN FPU AND STORE Z= X*X IN FPT, FPACC1
;
; PERFORM SERIES EVALUATION, FORM IS X*P(X*X) 
;
 MOVE.B #3,SERCNT ;SET SERIES N = 3 
 BSR SERSQU ;DO SERIES EVAL
 BSR FPADD ;ADD -1/2
;
; THE FRACTIONAL PART OF THE LOG2 IS COMPLETED
;
 MOVEQ #0,D0
 MOVE.W D0,S2
 MOVE.L D0,M2
 MOVE.B LOGX,M2
 BEQ LGEXIT ;DONE IF LGEXP 0
 BMI LGNEG ;SKIP IF NEGATIVE
 MOVE.L M2,D1 ;MANT2 TO D1
LOGLN1 MOVEQ #$88,D0
;
; SET X2 = $88
;
LOGLN2 SUBQ.B #1,D0 ;X2= X2- 1
 ADD.L D1,D1 ;SHIFT MANT2 L
 BPL LOGLN2 ;REPT TILL D31= 1
;
 MOVE.B D0,X2 ;STORE X2 IN FPACC2
 MOVE.L D1,M2 ;STORE M2 IN FPACC2
 BRA FPADD1 ;ADD INTEGER PART
;
LGEXIT RTS
;
; THE INTEGER PORTION OF THE LOG IS NEGATIVE
;
LGNEG MOVE.B #$80,S2
 MOVEQ #0,D1
 SUB.L M2,D1
 BRA LOGLN1
;
; PERFORM SERIES EVALUATION
;
SERIES BSR FPMUL
 BRA SER2
SER1 MOVE.W FPT,S2
 MOVE.L FPT+2,M2
 BSR FPMUL1 ;FPACC1 * FPT
SER2 BSR FPADD ;ADD NEXT P(I)
 SUBQ.B #1,SERCNT ;DECR COUNT
 BNE SER1 ;LOOP UNTIL ZERO
 RTS  ;RETURN
;
SERSQU BSR FPSQU ;X SQD TO FPT
 BSR SERIES ;DO SERIES EVAL
;
 MOVE.W FPU,S2
 MOVE.L FPU+2,M2
 BRA FPMUL1
;
; ROUND FPACC1, LEAVE A COPY IN FPU, THEN
; SQUARE IT AND LEAVE A ROUNDED COPY IN FPT
;
FPSQU BSR ROUND
 MOVE.W D0,FPU
 MOVE.L D1,FPU+2 ;LEAVE X IN FPU
 MOVE.W D0,S2
 MOVE.L D1,M2
 BSR FPMUL1 ;ACC = Z
 BSR ROUND ;ROUND Z
 MOVE.W D0,FPT
 MOVE.L D1,FPT+2 ;LEAVE Z IN FPT
 RTS
;
; ROUND FPACC, LEAVE S1,X1 IN D0, MANT1 IN D1
;
ROUND MOVE.W S1,D0
 MOVE.L M1,D1
 MOVE.B G1,D2
 BPL RNDX ;EXIT IF D7= 0
 ADDQ.L #1,D1 ;INCR MANT1
 BCC RNDX ;EXIT IF CY= 0
 ROXR.L #1,D1 ;M1= 1/2
 ADDQ.B #1,D0 ;EXP= EXP+ 1
 BEQ OVF ;REPORT OVFL
RNDX RTS  ;ROUND COMPLETED
;
OVF BRA FPERR
;
LOGK DC.W $0080
 DC.L $B504F334 ;1/SQR(2)
 DC.W $0081
 DC.L $B504F334 ;SQR(2)
 DC.W $0081
 DC.L $80000000 ;#1
 DC.W $007F
 DC.L $DE56CB79 ;.4342
 DC.W $0080
 DC.L $939B0B64 ;.5765
 DC.W $0080
 DC.L $F6389316 ;.9618
 DC.W $0082
 DC.L $B8AA3B20 ;2/LN(2)
 DC.W $8080
 DC.L $80000000 ;-1/2
 DC.W $0080
 DC.L $B17217F8 ;LN(2)
LG2 DC.W $007F
 DC.L $9A209A85 ;LOG(2)
;
; CALCULATE THE FRACTIONAL PART OF FPACC1
;
FRAC CLR.W D2
 MOVE.B X1,D2
 CMPI.B #$80,D2 ;BR IF EQ OR LESS
 BLS FRACX ;DONE IF UNDER ONE
 CMPI.B #$A7,D2 ;NO FRACTION?
 BHI FRACZ ;BR IF NO FRAC
 SUBI.B #$81,D2
 MOVE.L M1,D1
 MOVE.B G1,D6
FR1 ADD.B D6,D6
 ADDX.L D1,D1
 DBF D2,FR1
 MOVEQ #$80,D2 ;RESTORE X1
;
; NORMALIZE; X1=D2, M1=D1, G1.B=D6
;
 MOVE.L D1,D3 ;TEST D31
SNORM BMI SUBX ;DONE IF NORMALIZED
 BRA NORM ;ELSE NORMALIZE
FRACZ BRA RZER ;RESULT IS ZERO
FRACX RTS
;
COSINUS CLR.B S1 ;SET FPACC1 POS
 BSR ROUND ;ROUND FPACC1
 LEA @COSK(PC),A0 ;POINT A0 AT COSK
 BSR FPSUB ;90 DEG - ACCUM 
SINUS MOVE.B S1,SINSGN
 CLR.B S1 ;SET FPACC1 POS
 LEA @SINK(PC),A0 ;POINT A0 AT SINK
 BSR FPMUL ;MULT BY 1/2#PI
 BSR FRAC ;RESULT UND 360 DEG
 MOVE.B X1,D2
 BPL UNDHAL ;SKIP IF UNDER 1/2
;
; TOGGLE THE SIGN AND SUBTRACT 1/2
;
 BCHG #7,SINSGN ;TOGGLE SIGN
 SUBQ.B #1,D2
 MOVE.L M1,D1
 MOVE.B G1,D6
 ADD.B D6,D6
 ADDX.L D1,D1
 BSR SNORM ;NORMALIZE RESULT
;
; THE OPERAND IS NOW IN THE RANGE O TO .499999
; IF LESS THAN 1/4, PROCEED WITH CALCULATION,
; ELSE SUBTRACT OPERAND FROM 1/2 AND PROCEED
;
UNDHAL MOVE.B X1,D2
 ADDQ.B #1,D2
 BPL UNDQUA ;SKIP IF < 1/4
;
; SET X = 90 DEGREES MINUS X
;
 BSR FPSUB ;SUBTR FROM 1/2
UNDQUA LEA @SINK1(PC),A0 ;RESTORE POINTER
;
; THE RANGE OF X IS NOW 0 TO .24999999.
; NOW PERFORM SERIES EVALUATION, N = 5
;
 MOVE.B #5,SERCNT ;SET SERIES N = 5 
 BSR SERSQU ;FORM X*P(X*X)     
 MOVE.B SINSGN,S1 ;RESTORE SIGN
 RTS
;
; CALCULATE THE SINE OF THE 68000 FPACC#1
;
SIN MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ SINZERO
 BSR EXPAND
 BSR SINUS
 BRA COMPRESS
;
SINZERO BRA FPZERO
;
; CALCULATE THE COSINE OF THE 68000 FPACC1
;
COS MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ COSONE
 BSR EXPAND
 BSR COSINUS
 BRA COMPRESS
;
COSONE BRA.L XRONE
;
; CALCULATE THE TANGENS OF THE 68000 FPACC#1.
;
TAN MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ TANZERO
 BSR EXPAND
 MOVE.L S1,TREG ;STORE FPACC1
 MOVE.L M1+2,TREG+4
 BSR SINUS ;CALC THE SINE
 BSR ROUND ;ROUND THE RESULT
 MOVE.L TREG,S1
 MOVE.L TREG+4,M1+2 ;RECALL X
 MOVE.W D0,TREG
 MOVE.L D1,TREG+2 ;STORE RND'D SINE
 BSR COSINUS ;CALC COSINE
 LEA TREG,A0
 BSR FPDIV ;DIV SIN BY COS
 BRA COMPRESS
;
TANZERO BRA FPZERO
;
; CALC THE SQUARE ROOT OF THE 68000 FPACC1
;
SQRTERR BRA FPERR
;
SQRTZERO BRA FPZERO
;
SQRT MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ SQRTZERO
 BSR EXPAND
 MOVE.B S1,D2 ;CHK SIGN
 BMI SQRTERR ;NO LOG IF NEG
;
; THE OPERAND IS LEGAL; PROCEED WITH SQR CALC
;
 MOVE.B X1,D2
 MOVE.L M1,D7
 MOVE.B #$80,X1
 MOVE.B D2,D3
 LSR.B #1,D3 ;IS EXP EVEN?
 BCC EVNEXP ;SKIP IF EVEN
 MOVE.B #$7F,X1
 LSR.L #1,D7
;
; CALCULATE AND STORE THE EXP OF THE RESULT
;
EVNEXP MOVEQ #$40,D3
 LSR.B #1,D2
 ADDX.B D3,D2
 MOVE.B D2,LOGX
;
; SET Y0 = $FFFF  (1ST GUESS DELIBERATELY HIGH)
;
 MOVE.W #$FFFF,D7
;
; PERFORM Y(N+1) = (Y(N) + X/Y(N))/2 4 TIMES
;
 MOVEQ #3,D0 ;SET FOR 4 LOOPS
 MOVE.W D7,D5 ;Y0 = $FFFF
SQL1 MOVE.L D7,D6 ;MOVE X TO D6
 DIVU D5,D6 ;D6 = X/Y
 ADD.W D6,D5 ;D5 = Y + X/Y
 ROXR.W #1,D5 ;DIV BY 2
 DBF D0,SQL1 ;LOOP 4 TIMES
;
; MOVE X TO TEMP FP REG U AND TO FPACC2
;
 BSR ROUND ;ROUND FPACC1
 MOVE.W D0,FPU
 MOVE.L D1,FPU+2 ;LEAVE X IN FPU
 MOVE.W D0,S2
 MOVE.L D1,M2 ;X TO FPACC2
;
; FLOAT THE 16 BIT APPROXIMATION
;
 MOVEQ #0,D0
 MOVE.L D0,M1+2
 MOVE.W #$0080,S1
 MOVE.W D5,M1
;
; PERFORM ONE ITERATION OF Y1 = (Y0 + X/Y0)/2
; FIRST MOVE Y(N) TO TEMP FP REGISTER T
;
 BSR ROUND
 MOVE.W D0,FPT
 MOVE.L D1,FPT+2
;
; RECALL X TO FPACC2
;
 MOVE.W FPU,S2
 MOVE.L FPU+2,M2
 BSR FPDIV1 ;CALC X/Y
 LEA FPT,A0 ;POINT AT Y
 BSR FPADD ;ADD Y TO X/Y
 SUBQ.B #1,X1 ;DIVIDE BY 2
;
; RESTORE EXPONENT OF THE RESULT
;
 MOVEQ #$80,D1
 ADD.B LOGX,D1
 ADD.B D1,X1
 BRA COMPRESS
;
; CALCULATE THE EXPONENT FUNCTION, BASE 10.
; FIRST DIVIDE BY LG(2) AND THEN CALC EXP2.
;
EXP10 MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ XRONE
 BSR EXPAND
 LEA @INVLG2(PC),A0 ;POINT TO 1/LG(2)
 BSR FPMUL
 BSR EXPBIN
 BRA COMPRESS
;
; CALCULATE THE EXPONENT FUNCTION, BASE 2.
;
EXP2 MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ XRONE
 BSR EXPAND
 BSR EXPBIN
 BRA COMPRESS
;
XRONE MOVEA.W A3,SP
 MOVEM.W (SP)+,D5-D7/A3 ;RESULT IS ONE
 CLR.W D0
 MOVE.L #$00003F80,-(SP)
 JMP (A2)
;
EXOVFL MOVE.B SINSGN,D7 ;TEST SIGN
 BMI FPZERO ;RES = 0 IF NEG
 BRA FPERR ;REPORT OVERFLOW
;
; CALCULATE THE EXPONENT FUNCTION, BASE E
; FIRST DIVIDE BY LN2 AND THEN CALC EXP2
;
EXP MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ XRONE
 BSR EXPAND
 LEA @INVLN2(PC),A0 ;POINT TO 1/LN2
 BSR FPMUL
 BSR EXPBIN
 BRA COMPRESS
;
; CALCULATE THE EXPONENT FUNCTION, BASE 2
;
EXPBIN MOVE.B S1,SINSGN ;STORE THE SIGN
 MOVEQ #0,D0
 MOVE.B D0,S1 ;SET SIGN POSITIVE
 MOVE.B D0,EXPADD ;CLR EXP ADDER
 MOVE.B X1,D0 ;EXP TO D0
 BPL EXP2A ;SKIP IF X1<$80
;
 MOVEQ #$88,D1
 SUB.B D0,D1 
 BLE EXOVFL ;OVFL IF X1>=$88
;
 MOVE.B M1,D2
 LSR.B D1,D2
 MOVE.B D2,EXPADD ;STORE EXP ADDER
;
 BSR FRAC ;FRACTIONAL PART
;
EXP2A MOVE.B #7,SERCNT ;SET N = 7
 BSR ROUND ;RND'D X TO FPT
 MOVE.W D0,FPT
 MOVE.L D1,FPT+2
;
; PERFORM SERIES EVALUATION;  HART 1044
;
 LEA @EXPK(PC),A0
 BSR SERIES ;SERIES EVAL 
;
; NOW ADD THE EXP ADDER TO X1
;
 MOVE.B EXPADD,D0 ;FETCH ADDER
 ADD.B D0,X1 ;ADD TO X1
 BCS EXOVFL ;OVERFLOW ON CY
;
; INVERT FPACC1 IF THE SIGN IS NEG
;
 MOVE.B SINSGN,D0
 BPL EXP2X ;DONE IF POS
;
 MOVE.L #$00818000,S2
 CLR.W M2+2
 BRA FPDIV1
;
EXP2X RTS
;
; CALCULATE THE ARC TANGENT FUNCTION IN RADIANS
;
ARCTAN0 BRA FPZERO
;
ARCTAN MOVE.L (SP)+,D1
 MOVEM.W D5-D7/A3,-(SP)
 MOVEA.W SP,A3
 MOVE.W D1,D2
 ANDI.W #$7F80,D2
 BEQ ARCTAN0
 BSR EXPAND
 MOVE.W S1,D0 ;S1, X1 TO D0
 MOVE.W D0,TREG ;STORE IN TREG
 BPL ATNPOS ;SKIP IF POS
 MOVE.B D0,D1 ;TEST IF EXP = 0
 BEQ ATNPOS ;DON'T CHG SGN IF 0
 BCHG #7,S1 ;CHANGE THE SIGN
ATNPOS CMPI.B #$81,D0 ;ONE OR GREATER?
 BCS UNDONE ;SKIP IF NOT
 MOVE.L #$00818000,S2 ;CALC RECIPROCAL
 CLR.W M2+2
 BSR FPDIV1
UNDONE MOVE.B #11,SERCNT ;SET N = 11
 LEA @ATANK(PC),A0 ;PTR TO ATAN CONSTS
;
; PERFORM SERIES EVALUATION; FORM IS X*P(X*X) 
;
 BSR SERSQU ;DO SERIES EVAL
 MOVE.W TREG,D0 ;RECALL S1, X1
 CMPI.B #$81,D0 ;ONE OR GREATER?
 BCS NOINV ;SKIP IF NOT
 LEA @COSK(PC),A0 ;PTR TO PI/2
 BSR FPSUB ;90 DEG - FPACC1
NOINV MOVE.W TREG,D0 ;RECALL S1
 BPL ATNX ;DONE IF POS
 BCHG #7,S1 ;ELSE CHANGE SIGN
ATNX BRA COMPRESS ;ARCTAN DONE
;
; CONSTANTS USED TO EVALUATE ARC TANGENT
;
ATANK DC.W $8076 ;-6.84793912 E-4
 DC.L $B383BDD3
 DC.W $0079 ;4.85092416 E-3
 DC.L $9EF4A6F5
 DC.W $807B ;-.0161170184
 DC.L $83FCB010
 DC.W $007C ;.03420963804
 DC.L $8C1F67CA
 DC.W $807C ;-.0542791328
 DC.L $DE53CBC1
 DC.W $007D ;.0724571965
 DC.L $9464704C
 DC.W $807D ;-.0898023954
 DC.L $B7EA517A
 DC.W $007D ;.1109324134
 DC.L $E330887E
 DC.W $807E ;-.1428398076
 DC.L $9244993A
 DC.W $007E ;.1999991206
 DC.L $CCCC91C7
 DC.W $807F ;-.333333316
 DC.L $AAAAAA13
 DC.W $0081 ;F.P. #1
 DC.L $80000000
;
INVLG2 DC.W $0082 ;1/LG(2)
 DC.L $D49A784C
INVLN2 DC.W $0081 ;1/LN2 
 DC.L $B8AA3B29
;
; HART 1044, P(X); N= 7
;
EXPK DC.W $0071 ;2.14987637E-5
 DC.L $B4583E56
 DC.W $0074 ;1.4352314E-4
 DC.L $967EB31B
 DC.W $0077 ;1.34226348E-3
 DC.L $AFEEE385
 DC.W $007A ;9.61401701E-3
 DC.L $9D841C2A
 DC.W $007C ;.0555051269
 DC.L $E359580A
 DC.W $007E ;.240226385
 DC.L $F5FDE7C6
 DC.W $0080 ;APPX LN(2)
 DC.L $B1721810
 DC.W $0081 ;ONE
 DC.L $80000000
;
; TABLE USED BY COSINE AND SINE CALCS
;
COSK DC.W $0081
 DC.L $C90FDAA2 ;#PI/2
SINK DC.W $007E
 DC.L $A2F9836E ;1/2#PI
 DC.W $0080
 DC.L $80000000 ;1/2
SINK1 DC.W $8084
 DC.L $E61A2D1B ;-14.3813907
 DC.W $0086
 DC.L $A807FBF8 ;42.0077971
 DC.W $8087
 DC.L $99688901 ;-76.7041703
 DC.W $0087
 DC.L $A335DFE1 ;81.6052237
 DC.W $8086
 DC.L $A55DE728 ;-41.3417021
 DC.W $0083
 DC.L $C90FDAA2 ;2#PI
;
 CHAIN DFP
