;**************************************************
;*
;* RUNTIME SUPPORT PACKAGE (RSP)
;*
;**************************************************
;
; CHARACTER DEVICE WRITE TABLE
;
WRITTBL DC.L CONWRITE
 DC.L CONWRITE
 DC.L GRAFWRIT
 DC.L 0
 DC.L 0
 DC.L PRTWRITE
 DC.L 0
 DC.L REMWRITE
;
; CHARACTER DEVICE READ TABLE
;
READTBL DC.L CONREAD
 DC.L CONREAD
 DC.L 0
 DC.L 0
 DC.L 0
 DC.L PRTREAD
 DC.L REMREAD
 DC.L 0
;
; THE DLE FLAGS INDICATE WHETHER THE LAST
; CHARACTER WRITTEN OR READ WAS A DLE CHARACTER.
;
DLEFLAGS DS.B 8
;
; DISK NUMBER VECTOR.
;
; IF BYTE = FF THEN
;    DEVICE IS NOT A DISK DRIVE
; ELSE
;    DEVICE IS A REGULAR DISK DRIVE AND
;    BYTE = DRIVE NUMBER.
;
DISKNUM DC.B $FF ;UNIT #1
 DC.B $FF ;UNIT #2
 DC.B $FF ;UNIT #3
 DC.B 0 ;UNIT #4
 DC.B 1 ;UNIT #5
 DC.B $FF ;UNIT #6
 DC.B $FF ;UNIT #7
 DC.B $FF ;UNIT #8
 DC.B 4 ;UNIT #9
 DC.B 5 ;UNIT #10
 DC.B 2 ;UNIT #11
 DC.B 3 ;UNIT #12
;
; THE FOLLOWING SUBROUTINE CHECKS WHETHER D0 CON-
; TAINS A VALID DEVICE NUMBER. THE Z FLAG IS SET
; FOR A VALID NUMBER AND RESET OTHERWISE. NO
; REGISTERS ARE AFFECTED EXCEPT D0.
;
CHKDEV TST.B D0
 BLE CHKDEV1
 BTST #1,FLAVOR
 BEQ CHKDEV0
 CMPI.B #MAXUNIT,D0
 BRA CHKDEV01
;
CHKDEV0 CMPI.B #12,D0
CHKDEV01 BHI CHKDEV2
 MOVEQ #FALSE,D0
 RTS
;
CHKDEV1 BEQ CHKDEV2
 MOVEQ #FALSE,D0
 RTS
;
CHKDEV2 MOVE.W #BADUNIT,IORSLT
 MOVEQ #TRUE,D0
 RTS
;
;
IOCHECK MOVE.W IORSLT,D1
 BNE IOCHECK1
 JMP (A2)
;
IOCHECK1 SUBQ.W #2,A4
 BRA XUIOERR
;
;
IORESULT MOVE.W IORSLT,-(SP)
 JMP (A2)
;
; FLIP A BLOCK OF WORDS.
;
FLIP MOVE.W (A0),D2
 MOVE.B (A0)+,(A0)+
 MOVE.B D2,-2(A0)
 DBF D1,FLIP
;
 RTS
;
; FLIP A DIRECTORY POINTED AT BY A0.
;
FLIPDIR MOVE.W D3,-(SP)
 MOVEQ #2,D1
 BSR FLIP
 ADDQ.L #8,A0
 MOVEQ #3,D1
 BSR FLIP
 MOVEQ #0,D3
 MOVE.W D4,D3
 DIVU #26,D3 ;SIZEOF(DIRENTRY)
 SUBQ.W #2,D3
 BCS FLIPDIRX
 ADDQ.L #4,A0
;
FLIPDIR1 MOVEQ #2,D1
 BSR FLIP
 LEA 16(A0),A0
 MOVEQ #1,D1
 BSR FLIP
 DBF D3,FLIPDIR1
;
FLIPDIRX MOVE.W (SP)+,D3
 RTS
;
; FLIP THE FILE SYSTEM.MISCINFO.
;
FLIPINFO MOVE.W #143,D1
 BSR FLIP
 RTS
;
; FLIP THE FIRST BLOCK OF A CODE FILE.
;
FLIPCODE MOVEQ #31,D1
 BSR FLIP
 LEA 128(A0),A0
 MOVEQ #49,D1
 BSR FLIP
 RTS
;
; UNITREAD AND UNITWRITE DO DEVICE-ORIENTED I/O.
; REGISTER USAGE:
;
; D3   BLOCKNUMBER
; D4   LENGTH
; D5   ARRAY
; D6   UNITNUMBER
; D7   MODE
; A3   POINTS TO THE NEXT CHAR IN THE BUFFER
; A4   POINTS TO THE DLE FLAGS
; A5   INDICATES READ/WRITE MODE
; A6   POINTS TO BIOS ROUTINES
;
; BIOS ROUTINES ARE CALLED IN SEVERAL PLACES.
; THEY EXPECT THEIR PARAMETERS PASSED IN D0-D2.
; THE IORESULT CODE IS PASSED BACK IN D1, THE
; CHARACTER READ IN D0. BIOS ROUTINES DESTROY
; REGISTERS D0-D2 AND A0-A1.
;
RWEXIT ADDQ.W #6,SP
 JMP (A2)
;
CODEREAD MOVEQ #3,D0
 BRA RW
;
INFOREAD MOVEQ #2,D0
 BRA RW
;
UNITREAD MOVEQ #FALSE,D0
 BRA RW
;
UNITWRTE MOVEQ #TRUE,D0
RW MOVE.W (SP)+,D2
 MOVE.W (SP)+,D3
 MOVE.W (SP)+,D4
 BLE RWEXIT
 MOVEA.W (SP)+,A0
 ADDA.W (SP)+,A0
 MOVE.W (SP)+,D1
 MOVEM.W D5-D7/A3-A6,-(SP)
 MOVE.L A0,D5
 MOVE.W D1,D6
 MOVE.W D2,D7
 MOVEA.W D0,A5
 MOVE.B SPCHAR,-(SP)
;
; CHANGE SPCHAR ACCORDING TO THE MODE PARAMETER
;
 LSR.B #4,D2
 ANDI.B #3,D2
 OR.B D2,SPCHAR
;
; VALIDATE THE UNIT NUMBER
;
 MOVE.B D6,D0
 BSR CHKDEV
 BNE RWEXIT2
 MOVE.W A5,D1
 MOVE.B D6,D0
 CMPI.B #12,D0
 BLS RWCHDISK
;
; NOW WE MUST SERVICE A USER DEVICE.
;
 MOVEM.W D3-D7,-(SP)
 CMPI.W #TRUE,D1
 BEQ WUSER
 BSR.L USERREAD
RWEXIT1 TST.B D1
 BMI RWBREAK
 MOVE.W D1,IORSLT
RWEXIT2 MOVE.B (SP)+,SPCHAR
 MOVEM.W (SP)+,D5-D7/A3-A6
 JMP (A2)
;
RWBREAK BTST #NOBREAK,MISCINFO+1
 BNE RWEXIT2
 MOVE.B (SP)+,SPCHAR
 MOVEM.W (SP)+,D5-D7/A3-A6
 SUBQ.W #2,A4
 BRA XUBREAK
;
WUSER BSR.L USERWRIT
 BRA RWEXIT1
;
RWCHDISK LEA @DISKNUM-1(PC),A1
 ADDA.W D0,A1
 TST.B (A1)
 BMI.L RWCHAR
;
; REGULAR DISK
;
 CLR.W D6
 MOVE.B (A1),D6
 CMPI.W #TRUE,D1
 BEQ WDISK
 MOVE.W D7,-(SP) ;MODE
 MOVE.W D6,-(SP) ;DRIVE
 MOVE.L D5,-(SP) ;BUFFER ADDR
 MOVE.W D4,-(SP) ;LENGTH
 MOVE.W D3,-(SP) ;BLOCK
 BSR.L DISKREAD
 TST.B D1
 BMI RWBREAK
 MOVE.W D1,IORSLT
 MOVEA.L D5,A0
 CMPI.W #DIRBLK,D3
 BNE RWDISK1
 BSR FLIPDIR
 BRA RWEXIT2
;
RWDISK1 CMPA.W #2,A5
 BNE RWDISK2
 BSR FLIPINFO
 BRA RWEXIT2
;
RWDISK2 CMPA.W #3,A5
 BNE RWEXIT2
 BSR FINDSEX
 LEA 256(A0),A1
 MOVEQ #15,D1
;
RWDISK3 TST.W (A1)+
 DBNE D1,RWDISK3
;
 CMPI.B #63,-2(A1)
 BHI RWEXIT2
 BSR FLIPCODE
 BRA RWEXIT2
;
WDISK MOVE.W D7,-(SP) ;MODE
 MOVE.W D6,-(SP) ;DRIVE
 MOVE.L D5,-(SP) ;BUFFER ADDR
 MOVE.W D4,-(SP) ;LENGTH
 MOVE.W D3,-(SP) ;BLOCK
 CMPI.W #DIRBLK,D3
 BNE WDISK1
 MOVEA.L D5,A0
 BSR FLIPDIR
 BSR.L DISKWRIT
 TST.B D1
 BMI RWBREAK
 MOVE.W D1,IORSLT
 MOVEA.L D5,A0
 BSR FLIPDIR
 BRA RWEXIT2
;
WDISK1 BSR.L DISKWRIT
 BRA RWEXIT1
;
; CHARACTER DEVICE
;
RWNOCHAR MOVE.W #BADMODE,IORSLT
 BRA RWEXIT2
;
RWCHAR MOVE.W #NOERROR,IORSLT
 SUBQ.W #1,D4
 MOVEA.L D5,A3
 LEA @DLEFLAGS-1(PC),A4
 ADDA.W D6,A4
 MOVE.B D6,D0
 ADD.B D0,D0
 ADD.B D0,D0
 MOVE.W A5,D1
 CMPI.W #TRUE,D1
 BEQ WCHAR
 LEA @READTBL-4(PC),A1
 MOVE.L 0(A1,D0.W),D3
 BEQ RWNOCHAR
 MOVEA.L D3,A6
 LEA @WRITTBL-4(PC),A1
 MOVEA.L 0(A1,D0.W),A5
;
; READ 'LENGTH' CHARACTERS.
;
RCHAR MOVE.W D6,D2
 MOVEQ #FALSE,D1
 JSR (A6)
 TST.B D1
 BMI RWBREAK
 MOVE.W D1,IORSLT
 MOVE.B D0,(A3)+ ;CHAR -> BUFFER
 BTST #2,D7 ;DLE ENABLED?
 BNE RCHAR1 ;NO => JUMP
 CMP.B EOF,D0 ;EOF REACHED?
 BNE RCHAR1 ;NO => JUMP
 SUBQ.W #1,D6 ;CONSOLE?
 BNE RWEXIT2 ;NO => EXIT
;
; THE EOF CHARACTER HAS BEEN READ FROM THE CONSOLE.
; NOW WE FILL THE REST OF THE BUFFER WITH NULL.
;
 SUBQ.W #1,A3
 MOVEQ #0,D0
;
REOF MOVE.B D0,(A3)+
 DBF D4,REOF
;
 BRA RWEXIT2
;
; ECHO THE CHARACTER IF IT CAME FROM THE CONSOLE.
;
RCHAR1 CMPI.B #CONSOLE,D6
 BNE RCHAREX
 BSR W1CHAR
 TST.B D1
 BMI RWBREAK
 MOVE.W D1,IORSLT
RCHAREX DBF D4,RCHAR
;
 BRA RWEXIT2
;
WCHAR LEA @WRITTBL-4(PC),A1
 MOVE.L 0(A1,D0.W),D3
 BEQ RWNOCHAR
 MOVEA.L D3,A5
;
; WRITE 'LENGTH' CHARACTERS.
;
WCHAR1 MOVE.B (A3)+,D0
 BSR W1CHAR
 TST.B D1
 BMI RWBREAK
 MOVE.W D1,IORSLT
 DBF D4,WCHAR1
;
 BRA RWEXIT2
;
; WRITE ONE CHARACTER.
;
W1CHAR BTST #2,D7 ;DLE ENABLED?
 BNE CRCHECK ;NO => JUMP
 MOVEQ #NOERROR,D1
 TST.B (A4) ;LAST CHAR = DLE?
 BEQ DLECHECK ;NO => JUMP
;
; THE LAST CHARACTER WRITTEN WAS A DLE, THEREFORE
; THIS CHARACTER DENOTES THE NUMBER OF BLANKS THAT
; SHOULD BE OUTPUT, WITH AN OFFSET OF 32.
;
 SUBI.B #33,D0
 BCS DLEEXIT
 MOVE.W D0,D3
;
DLEEXPND MOVE.W D6,D2
 MOVEQ #TRUE,D1
 MOVEQ #' ',D0
 JSR (A5)
 DBF D3,DLEEXPND
;
DLEEXIT MOVE.B #FALSE,(A4)
 RTS
;
DLECHECK CMPI.B #DLE,D0
 BNE CRCHECK
 MOVE.B #TRUE,(A4)
 RTS
;
; IF THE CHARACTER IS A CR, AND THE AUTOMATIC LINE
; FEED OPTION IS ENABLED, THEN OUTPUT BOTH A CR AND
; A LF.
;
CRCHECK CMPI.B #CR,D0
 BNE W1CHAR1
 BTST #3,D7
 BNE W1CHAR1
 MOVE.W D6,D2
 MOVEQ #TRUE,D1
 JSR (A5)
 MOVEQ #LF,D0
W1CHAR1 MOVE.W D6,D2
 MOVEQ #TRUE,D1
 JSR (A5)
 RTS
;
; UNITSTATUS(UNITNUM, ARRAY[...], CONTROLWORD)
;
UNITSTAT MOVEQ #4,D1
 MOVE.W (SP)+,D2
 MOVE.W (SP)+,D3
 ADD.W (SP)+,D3
 MOVE.W (SP)+,D4
 MOVE.B D4,D0
 BSR CHKDEV
 BNE USTATEX2
 MOVE.W D2,-(SP)
 MOVE.W D3,-(SP)
 MOVE.B D4,D0
 CMPI.B #12,D0
 BHI USTAT2
 CMPI.B #REMIN,D0
 BNE USTAT1
 MOVEQ #REMOUT,D0
USTAT1 LEA @DISKNUM-1(PC),A0
 ADDA.W D0,A0
 TST.B (A0)
 BMI USTAT4
 MOVE.B (A0),D0
 BSR.L DISKSTAT
USTATEX1 TST.B D1
 BMI USTATBRK
 MOVE.W D1,IORSLT
USTATEX2 JMP (A2)
;
USTATBRK BTST #NOBREAK,MISCINFO+1
 BNE USTATEX2
 SUBQ.W #2,A4
 BRA XUBREAK
;
USTAT2 BSR.L USERSTAT
 BRA USTATEX1
;
USTAT4 CMPI.B #SYSTERM,D0
 BHI USTAT5
 BSR.L CONSTAT
 BRA USTATEX1
;
USTAT5 CMPI.B #PRINTER,D0
 BNE USTAT6
 BSR.L PRTSTAT
 BRA USTATEX1
;
USTAT6 CMPI.B #REMOUT,D0
 BNE USTATERR
 BSR.L REMSTAT
 BRA USTATEX1
;
USTATERR ADDQ.W #4,SP
 MOVE.W #NOUNIT,IORSLT
 JMP (A2)
;
; UNITBUSY INDICATES WHETHER A SPECIFIED DEVICE IS
; BUSY.
;
UNITBUSY MOVE.W (SP)+,D1
 MOVE.B D1,D0
 BSR CHKDEV
 BNE UBUSYERR
 MOVE.B D1,D0
 BSR.L UBUSY
 TST.B D1
 BMI UBUSYBRK
 MOVE.W D0,-(SP)
 MOVE.W D1,IORSLT
UBUSYEX JMP (A2)
;
UBUSYERR MOVE.W #FALSE,-(SP)
 JMP (A2)
;
UBUSYBRK BTST #NOBREAK,MISCINFO+1
 BNE UBUSYEX
 SUBQ.W #2,A4
 BRA XUBREAK
;
; UNITWAIT WAITS FOR A SPECIFIED DEVICE TO COMPLETE
; THE I/O IN PROGRESS.
;
UNITWAIT MOVE.W (SP)+,D1
 MOVE.B D1,D0
 BSR CHKDEV
 BNE UWAITEX
 MOVE.B D1,D0
 BSR.L UWAIT
 TST.B D1
 BMI UWAITBRK
 MOVE.W D1,IORSLT
UWAITEX JMP (A2)
;
UWAITBRK BTST #NOBREAK,MISCINFO+1
 BNE UWAITEX
 SUBQ.W #2,A4
 BRA XUBREAK
;
; UNITCLEAR(UNITNUMBER) CANCELS ALL I/O OPERATIONS
; TO THE SPECIFIED UNIT AND RESETS THE HARDWARE TO
; ITS POWER-UP STATE. IORSLT IS SET TO A NON-ZERO
; VALUE IF THE SPECIFIED UNIT IS NOT PRESENT. THE
; FORM UNITCLEAR(1) FLUSHES THE TYPE-AHEAD BUFFER
; FOR CONSOLE: AND RESETS HORIZONTAL SCROLLING TO
; FULL LEFT.
;
UNITCLR MOVEQ #2,D1
 MOVE.W (SP)+,D4
 MOVE.B D4,D0
 BSR CHKDEV
 BNE UCLREX2
 MOVE.B D4,D0
 CMPI.B #12,D0
 BHI UCLR2
 CMPI.B #REMIN,D0
 BNE UCLR1
 MOVEQ #REMOUT,D0
UCLR1 LEA @DISKNUM-1(PC),A0
 ADDA.W D0,A0
 TST.B (A0)
 BMI UCLR4
 MOVE.B (A0),D0
 BSR.L DISKINIT
UCLREX1 TST.B D1
 BMI UCLRBRK
 MOVE.W D1,IORSLT
UCLREX2 JMP (A2)
;
UCLRBRK BTST #NOBREAK,MISCINFO+1
 BNE UCLREX2
 SUBQ.W #2,A4
 BRA XUBREAK
;
UCLR2 BSR.L USERINIT
 BRA UCLREX1
;
UCLR4 CMPI.B #SYSTERM,D0
 BHI UCLR5
 BSR.L CONINIT
 BRA UCLREX1
;
UCLR5 CMPI.B #PRINTER,D0
 BNE UCLR6
 BSR.L PRTINIT
 BRA UCLREX1
;
UCLR6 CMPI.B #REMOUT,D0
 BNE UCLR7
 BSR.L REMINIT
 BRA UCLREX1
;
UCLR7 CMPI.B #GRAFIC,D0
 BNE UCLRERR
 BSR.L GRAFINIT
 BRA UCLREX1
;
UCLRERR MOVE.W #NOUNIT,IORSLT
 JMP (A2)
;
;**************************************************
;*
;* BASIC I/O SUBSYSTEM (BIOS)
;*
;**************************************************
;
; NOTE: BIOS ROUTINES DESTROY REGISTERS D0-D2,
;       A0-A1.
;
; MAIN BIOS JUMP TABLE CALLED FROM INTERPRETER.
;
CONREAD JMP CREAD ;CONSOLE READ
CONWRITE JMP CWRITE ;CONSOLE WRITE
CONINIT JMP CINIT ;CONSOLE INIT
PRTWRITE JMP PWRITE ;PRINTER WRITE
PRTINIT JMP PINIT ;PRINTER INIT
DISKWRIT JMP DSKWRIT ;DISK WRITE
DISKREAD JMP DSKREAD ;DISK READ
DISKINIT JMP DSKINIT ;DISK INIT
REMREAD JMP RREAD ;REMOTE READ
REMWRITE JMP RWRITE ;REMOTE WRITE
REMINIT JMP RINIT ;REMOTE INIT
GRAFWRIT JMP GWRITE ;GRAFIC WRITE
GRAFINIT JMP GINIT ;GRAFIC INIT
PRTREAD JMP PREAD ;PRINTER READ
CONSTAT JMP CSTAT ;CONSOLE STATUS
PRTSTAT JMP PSTAT ;PRINTER STATUS
DISKSTAT JMP DSTAT ;DISK STATUS
REMSTAT JMP RSTAT ;REMOTE STATUS
CONCHECK JMP CONCK ;CONSOLE CHECK
USERREAD JMP USRREAD ;USER READ
USERWRIT JMP USRWRIT ;USER WRITE
USERINIT JMP USRINIT ;USER INIT
USERSTAT JMP USRSTAT ;USER STATUS
UBUSY JMP BUSY
UWAIT JMP WAIT
TIME JMP REALTIME
XITOS JMP GOHOST
PEEK JMP PEEKHOST
POKE JMP POKEHOST
BLOCKMOV JMP BLKMOVE
 JMP LINE
 JMP PADDLE
 JMP NOTE
 JMP KEYPRESS
CFGHOST JMP CONFHOST
;
; WAIT UNTIL HOST IS READY TO RECEIVE A BYTE.
;
TOHOST BTST #6,STATUS
 BNE TOHOST
;
 RTS
;
; WAIT UNTIL HOST IS READY TO SEND A BYTE.
;
FROMHOST TST.B STATUS
 BPL FROMHOST
;
 RTS
;
; GET A CHARACTER FROM THE HOST.
;
READCH BSR TOHOST
 MOVE.B D1,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,D0
 BSR FROMHOST
 MOVE.B DATIN,D1
 RTS
;
; SEND A CHARACTER TO THE HOST.
;
WRITECH BSR TOHOST
 MOVE.B D1,DATOUT
 BSR TOHOST
 MOVE.B D0,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,D1
 RTS
;
; INITIALIZE A HOST RESIDENT DEVICE.
;
INITCH BSR TOHOST
 MOVE.B D1,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,D1
 RTS
;
; READ FROM CONSOLE:
;
CREAD MOVEQ #0,D1
 BRA READCH
;
; WRITE TO CONSOLE:
;
CWRITE MOVEQ #1,D1
 BRA WRITECH
;
; INITIALIZE CONSOLE:
;
CINIT MOVEQ #2,D1
 BRA INITCH
;
; WRITE TO PRINTER:
;
PWRITE MOVEQ #3,D1
 BRA WRITECH
;
; INITIALIZE PRINTER:
;
PINIT MOVEQ #4,D1
 BRA INITCH
;
; DMA TRANSFER FROM THE 68000 TO THE HOST. COUNT IS
; IN D0, THE START ADDRESS IS IN A0.
;
DMAWX RTS
;
DMAWRITE TST.W D0
 BLE DMAWX
DMAW0 CMPI.W #31*256,D0
 BHI DMAW8K
 CMPI.W #15*256,D0
 BHI DMAW4K
 CMPI.W #7*256,D0
 BHI DMAW2K
 CMPI.W #3*256,D0
 BHI DMAW1K
 CMPI.W #256,D0
 BHI DMAW512
 MOVEQ #256/8,D1
 BRA DMAW1
;
DMAW512 MOVEQ #512/8,D1
 BRA DMAW1
;
DMAW1K MOVE.W #1024/8,D1
 BRA DMAW1
;
DMAW2K MOVE.W #2048/8,D1
 BRA DMAW1
;
DMAW4K MOVE.W #4096/8,D1
 BRA DMAW1
;
DMAW8K MOVE.W #8192/8,D1
;
DMAW1 MOVE.B STATUS,D2
 ANDI.B #3,D2
 SUBQ.B #3,D2
 BNE DMAW1
;
 MOVE.W D1,D2
 SUBQ.W #1,D2
;
DMAW2 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 MOVE.B (A0)+,DATOUT
 DBF D2,DMAW2
;
DMAW3 MOVE.B STATUS,D2
 ANDI.B #2,D2
 BNE DMAW3
;
 ASL.W #3,D1
 SUB.W D1,D0
 BGT DMAW0
 RTS
;
; DMA TRANSFER FROM THE HOST TO THE 68000. COUNT IS
; IN D0, THE DESTINATION ADDRESS IS IN A0.
;
DMARX MOVEA.L (SP)+,A2
 RTS
;
DMAREAD MOVE.L A2,-(SP)
 LEA STATUS,A1
 LEA DATIN,A2
DMAR0 TST.W D0
 BLE DMARX
 CMPI.W #31*256,D0
 BHI DMAR8K
 CMPI.W #15*256,D0
 BHI DMAR4K
 CMPI.W #7*256,D0
 BHI DMAR2K
 CMPI.W #3*256,D0
 BHI DMAR1K
 CMPI.W #256,D0
 BHI DMAR512
 MOVE.W #256,D1
 BRA DMAR1
;
DMAR512 MOVE.W #512,D1
 BRA DMAR1
;
DMAR1K MOVE.W #1024,D1
 BRA DMAR1
;
DMAR2K MOVE.W #2048,D1
 BRA DMAR1
;
DMAR4K MOVE.W #4096,D1
 BRA DMAR1
;
DMAR8K MOVE.W #8192,D1
DMAR1 SUB.W D1,D0
 BPL DMAR2
 ADD.W D0,D1
DMAR2 SUBQ.W #1,D1
;
DMAR3 MOVE.B (A1),D2
 ANDI.B #3,D2
 SUBQ.B #3,D2
 BNE DMAR3
;
 MOVE.B (A2),D2
;
DMAR4 TST.B (A1)
 BPL DMAR4
;
 MOVE.B (A2),(A0)+
 DBF D1,DMAR4
;
 TST.W D0
 BPL DMAR6
 NOT.W D0
;
DMAR5 TST.B (A1)
 BPL DMAR5
;
 MOVE.B (A2),D2
 DBF D0,DMAR5
;
DMAR6 MOVE.B (A1),D2
 ANDI.B #2,D2
 BNE DMAR6
;
 MOVE.B (A2),D2
 BRA DMAR0
;
; READ/WRITE FROM RAM VOLUME.
;
RAMRW MOVEQ #0,D0
 MOVE.W 4(SP),D0 ;GET BLOCK #
 MOVEQ #9,D2
 LSL.L D2,D0 ;MULT BY 512
 ADD.L #RAMDISK,D0
 MOVEA.L D0,A0
;
; CHECK WHETHER FILE IS TOO LONG
;
 MOVE.W 6(SP),D2 ;GET LENGTH
 ADD.L D2,D0
 MOVE.W #NOERROR,-(SP)
 CMP.L MEMSIZE,D0
 BLS RAMRW1
 MOVE.W #BADBLOCK,(SP)
 MOVE.L MEMSIZE,D0
 SUB.L A0,D0
 BLS RAMRWX
 MOVE.W D0,D2
RAMRW1 MOVEA.L 10(SP),A1 ;GET BUFFER ADDR
 CMPI.B #6,D1
 BEQ RAMRW2
 CMPI.B #19,D1
 BEQ RAMRW2
 EXG A0,A1
RAMRW2 MOVE.W D2,D1
 LSR.W #2,D1
 BEQ RAMRW4
 SUBQ.W #1,D1
;
RAMRW3 MOVE.L (A0)+,(A1)+
 DBF D1,RAMRW3
;
 ANDI.W #3,D2
RAMRW4 SUBQ.W #1,D2
 BCS RAMRWX
;
RAMRW5 MOVE.B (A0)+,(A1)+
 DBF D2,RAMRW5
;
RAMRWX MOVE.W (SP)+,D1 ;ERROR CODE
 MOVEQ #0,D0
 MOVEA.L (SP),A0
 LEA 16(SP),SP
 JMP (A0)
;
; TRANSFER DISK PARAMETERS.
;
PARTRANS MOVE.W -(A0),D0
 BSR TOHOST
 MOVE.W D0,(A1)
 BSR TOHOST
 MOVE.B D0,(A1)
 DBF D2,PARTRANS
;
 RTS
;
; WRITE TO DISK
;
DSKWRIT MOVEQ #5,D1
 BRA DISKRW
;
; READ FROM DISK
;
DSKREAD MOVEQ #6,D1
;
; TEST IF RAM VOLUME IS ACCESSED.
;
DISKRW MOVE.B @RAMVOL(PC),D0
 CMP.B 13(SP),D0 ;RAMVOL = DRIVE# ?
 BEQ RAMRW
;
; DISK VOLUME IS ON THE HOST SIDE.
;
 LEA STATUS,A1
 BSR TOHOST
 MOVE.B D1,(A1)
 LEA 16(SP),A0
 MOVEQ #2,D2
 BSR PARTRANS
 SUBQ.W #2,A0
 MOVEQ #1,D2
 BSR PARTRANS
 MOVEA.L 8(SP),A0
 MOVE.W 6(SP),D0
 MOVEQ #6,D2
 CMP.B D2,D1
 BEQ DSKREAD1
 CMPI.B #19,D1
 BEQ DSKREAD1
 BTST #0,CONFIG
 BEQ DSKWRIT0
 BSR DMAWRITE
 BRA DISKRW2
;
DSKWRIT0 SUBQ.W #1,D0
;
DSKWRIT1 BTST D2,(A1)
 BNE DSKWRIT1
;
 MOVE.B (A0)+,(A1)
 DBF D0,DSKWRIT1
;
 BRA DISKRW2
;
DSKREAD1 BTST #0,CONFIG
 BEQ DSKREAD2
 BSR DMAREAD
 BRA DISKRW2
;
DSKREAD2 MOVE.L A2,D2
 LEA DATIN,A2
 SUBQ.W #1,D0
;
DSKREAD3 TST.B (A1)
 BPL DSKREAD3
;
 MOVE.B (A2),(A0)+
 DBF D0,DSKREAD3
;
 MOVEA.L D2,A2
DISKRW2 BSR FROMHOST
 CLR.W D0
 CLR.W D1
 MOVE.B DATIN,D1
 MOVEA.L (SP),A0
 LEA 16(SP),SP
 JMP (A0)
;
; INITIALIZE DISK
;
DSKINIT CMP.B @RAMVOL(PC),D0 ;RAMVOL = DRIVE# ?
 BEQ RAMINIT
 BSR TOHOST
 MOVE.B #7,DATOUT
 MOVE.W D0,D1
 BRA INITCH
;
; INITIALIZE RAM DISK.
;
RAMINIT MOVE.W #NOERROR,D1
 RTS
;
; READ FROM REMOTE:
;
RREAD MOVEQ #8,D1
 BRA READCH
;
; WRITE TO REMOTE:
;
RWRITE MOVEQ #9,D1
 BRA WRITECH
;
; INITIALIZE REMOTE:
;
RINIT MOVEQ #10,D1
 BRA INITCH
;
; WRITE TO GRAFIC:
;
GWRITE MOVEQ #11,D1
 BRA WRITECH
;
; INITIALIZE GRAFIC:
;
GINIT MOVEQ #12,D1
 BRA INITCH
;
; READ FROM PRINTER:
;
PREAD MOVEQ #13,D1
 BRA READCH
;
; CHECK STATUS OF CHARACTER DEVICE.
;
CPRSTAT MOVEA.L (SP)+,A0
 MOVEA.W (SP)+,A1
 BSR TOHOST
 MOVE.B D1,DATOUT
 MOVE.W (SP)+,D2
 BSR TOHOST
 MOVE.W D2,DATOUT
 BSR TOHOST
 MOVE.B D2,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 BSR FROMHOST
 MOVE.B DATIN,D1
 JMP (A0)
;
; CHECK CONSOLE: STATUS
;
CSTAT MOVEQ #14,D1
 BRA CPRSTAT
;
; CHECK PRINTER: STATUS
;
PSTAT MOVEQ #15,D1
 BRA CPRSTAT
;
; CHECK DISK STATUS
;
DSTAT MOVEQ #16,D1
DSTAT1 MOVEA.L (SP)+,A0
 MOVEA.W (SP)+,A1
 CMP.B @RAMVOL(PC),D0
 BEQ RAMSTAT
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR TOHOST
 MOVE.B D0,DATOUT
 MOVE.W (SP)+,D2
 BSR TOHOST
 MOVE.W D2,DATOUT
 BSR TOHOST
 MOVE.B D2,DATOUT
 MOVEQ #7,D2
;
DSTAT2 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 DBF D2,DSTAT2
;
 BSR FROMHOST
 MOVE.B DATIN,D1
 JMP (A0)
;
; CHECK RAM DISK STATUS
;
RAMSTAT MOVE.L #256,(A1)+ ;BYTES PER SECTOR
 MOVE.W #2,(A1)+ ;SECTORS PER TRACK
 MOVE.L MEMSIZE,D2
 SUBI.L #RAMDISK,D2
 MOVEQ #9,D1
 LSR.L D1,D2 ;MOD 512
 MOVE.W D2,(A1)+ ;TRACKS PER DISK
 MOVEQ #NOERROR,D1
 ADDQ.W #2,SP ;SKIP MODE PARAM
 JMP (A0)
;
; CHECK REMOTE: STATUS.
;
RSTAT MOVEQ #17,D1
 BRA CPRSTAT
;
; CONSOLE CHECK FOR CHAR AVAIL
;
CONCK BSR TOHOST
 MOVE.B #18,DATOUT
 RTS
;
; READ USER DEVICE.
;
USRREAD MOVEQ #19,D1
 BRA DISKRW
;
; WRITE TO USER DEVICE.
;
USRWRIT MOVEQ #20,D1
 BRA DISKRW
;
; INITIALIZE USER DEVICE.
;
USRINIT CMP.B @RAMVOL(PC),D0
 BEQ RAMINIT
 BSR TOHOST
 MOVE.B #21,DATOUT
 MOVE.W D0,D1
 BRA INITCH
;
; CHECK STATUS OF USER DEVICE.
;
USRSTAT MOVEQ #22,D1
 BRA DSTAT1
;
; CHECK IF DEVICE IS BUSY.
;
BUSY BSR TOHOST
 MOVE.B #23,DATOUT
 MOVE.W D0,D1
 BRA READCH
;
; WAIT FOR DEVICE TO COMPLETE I/O.
;
WAIT BSR TOHOST
 MOVE.B #24,DATOUT
 MOVE.W D0,D1
 BRA INITCH
;
; READ THE REAL-TIME CLOCK.
;
REALTIME MOVEA.L (SP)+,A0
 MOVEA.W (SP)+,A1
 MOVEQ #25,D1
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 MOVEA.W (SP)+,A1
 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 BSR FROMHOST
 MOVE.B DATIN,(A1)+
 BSR FROMHOST
 MOVE.B DATIN,D1
 JMP (A0)
;
; EXIT TO THE HOST.
;
GOHOST BSR TOHOST
 MOVE.B #26,DATOUT
 JMP IDLE
;
; READ A BYTE FROM THE HOST'S MEMORY INTO D0. THE
; MEMORY ADDRESS IS PASSED IN D1.
;
PEEKHOST BSR TOHOST
 MOVE.B #27,DATOUT
 BSR TOHOST
 MOVE.W D1,DATOUT
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,D0
 RTS
;
; MOVE A BYTE FROM D0 INTO THE HOST'S MEMORY.
; THE MEMORY ADDRESS IS PASSED IN D1.
;
POKEHOST BSR TOHOST
 MOVE.B #28,DATOUT
 BSR TOHOST
 MOVE.W D1,DATOUT
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR TOHOST
 MOVE.B D0,DATOUT
 RTS
;
; MOVE A BLOCK OF MEMORY FROM THE 68000 TO THE
; HOST. THE HOST'S TARGET ADDRESS IS PASSED IN D1,
; THE 68000 SOURCE ADDRESS IS PASSED IN A1. D2 CON-
; TAINS THE NUMBER OF BYTES TO BE TRANSFERRED.
;
BLKMOVE BSR TOHOST
 MOVE.B #29,DATOUT
 BSR TOHOST
 MOVE.W D1,DATOUT
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR TOHOST
 MOVE.W D2,DATOUT
 BSR TOHOST
 MOVE.B D2,DATOUT
 BTST #0,CONFIG
 BEQ BLKMOVE1
 MOVE.W D2,-(SP)
 CLR.B D2
 MOVE.W D2,D0
 ADD.W A1,D2
 MOVE.W D2,-(SP)
 MOVEA.W A1,A0
 BSR DMAWRITE
 MOVEA.W (SP)+,A1
 MOVE.W (SP)+,D2
 ANDI.W #$00FF,D2
;
BLKMOVE1 MOVEQ #6,D0
 LEA DATOUT,A0
 SUBQ.W #1,D2
 BCS BLKMOVE3
;
BLKMOVE2 BTST D0,(A0)
 BNE BLKMOVE2
;
 MOVE.B (A1)+,(A0)
 DBF D2,BLKMOVE2
;
BLKMOVE3 RTS
;
; LINE TRANSFERS THE CONTENTS OF THE LINE BUFFER
; TO THE HOST. ON ENTRY, D1 CONTAINS THE NUMBER
; OF ENTRIES IN THE LINE BUFFER, EACH CONSISTING
; OF ONE 16-BIT ADDRESS FOLLOWED BY A GARBAGE
; BYTE AND FINALLY BY THE DOT BYTE. ADDRESS AND
; DOT BYTE ARE SENT TO THE HOST. THE STARTING
; ADDRESS OF THE LINE BUFFER IS PASSED IN A0.
;
LINE MOVEQ #6,D0
 LEA DATOUT,A1
 BSR TOHOST
 MOVE.B #30,(A1)
 BSR TOHOST
 MOVE.W D1,(A1)
 BSR TOHOST
 MOVE.B D1,(A1)
 SUBQ.W #1,D1
 BCS LINEX
;
LINE1 MOVE.W (A0)+,D2
;
LINE2 BTST D0,(A1)
 BNE LINE2
;
 MOVE.W D2,(A1)
;
LINE3 BTST D0,(A1)
 BNE LINE3
;
 MOVE.B D2,(A1)
 MOVE.W (A0)+,D2
;
LINE4 BTST D0,(A1)
 BNE LINE4
;
 MOVE.B D2,(A1)
 DBF D1,LINE1
;
LINEX RTS
;
; THE FUNCTION PADDLE(SELECT) RETURNS AN INTEGER IN
; THE RANGE 0 TO 255 WHICH REPRESENTS THE POSITION
; OF THE SELECTED PADDLE.
;
PADDLE BSR TOHOST
 MOVE.B #31,DATOUT
 BSR TOHOST
 MOVE.W D1,DATOUT
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR FROMHOST
 MOVE.W DATIN,D1
 BSR FROMHOST
 MOVE.B DATIN,D1
 RTS
;
; THE NOTE PROCEDURE HAS THE FORM NOTE(PITCH,
; DURATION) WHERE PITCH IS AN INTEGER FROM 0
; THROUGH 50 AND DURATION IS AN INTEGER FROM 0
; THROUGH 255. PITCH = D1, DURATION = D2.
;
NOTE BSR TOHOST
 MOVE.B #32,DATOUT
 BSR TOHOST
 MOVE.W D1,DATOUT
 BSR TOHOST
 MOVE.B D1,DATOUT
 BSR TOHOST
 MOVE.W D2,DATOUT
 BSR TOHOST
 MOVE.B D2,DATOUT
 RTS
;
; THE KEYPRESS FUNCTION, WHICH HAS NO PARAMETERS,
; RETURNS TRUE IF A KEY HAS BEEN PRESSED ON THE
; KEYBOARD. KEYPRESS DOES NOT READ THE CHARACTER
; FROM CONSOLE OR KEYBOARD OR HAVE ANY OTHER
; EFFECT ON I/O.
;
KEYPRESS BSR TOHOST
 MOVE.B #33,DATOUT
 BSR FROMHOST
 MOVE.B DATIN,D0
 RTS
;
; CONFHOST. CONFIGURE HOST. TRANSFER A CONFIGURA-
; TION BYTE TO THE HOST (PASSED IN D0).
;
CONFHOST BSR TOHOST
 MOVE.B #34,DATOUT
 BSR TOHOST
 MOVE.B D0,DATOUT
 RTS
;
 CHAIN FP
