 TITLE Inter68 v1.1d  -  A P-Code Interpreter for the 68000
;==================================================
;
; COPYRIGHT (C) 1984 BY
;
;    ULRICH SCHMIDT
;    AN DER JUNKERSMUEHLE 33/35
;    5100 AACHEN
;    GERMANY
;    TEL.: 0241/77407
;
;**************************************************
;*
;* REGISTER USAGE
;*
;**************************************************
;
; THE P-MACHINE USES 16-BIT WORDS, WITH TWO 8-BIT
; BYTES PER WORD. IT HAS AN EVALUATION STACK,
; SEVERAL REGISTERS, AND A USER MEMORY CONTAINING A
; PROGRAM STACK AND A HEAP. ALL REGISTERS ARE
; POINTERS TO WORD-ALIGNED STRUCTURES, EXCEPT IPC,
; WHICH IS A POINTER TO BYTE-ALIGNED INSTRUCTIONS.
;
; A7 IS THE EVALUATION STACK POINTER (SP). A POINT-
;    ER TO THE CURRENT "TOP" OF THE EVALUATION
;    STACK (POINTING TO THE LAST WORD IN USE). IT
;    IS USED TO PASS PARAMETERS, RETURN FUNCTION
;    VALUES, AND AS AN OPERAND SOURCE FOR MANY
;    INSTRUCTIONS. THE EVALUATION STACK IS EXTENDED
;    BY LOADS, AND IS CUT BACK BY STORES AND
;    ARITHMETIC OPERATIONS.
;
; A6 IS THE PROGRAM STACK POINTER (KP). A POINTER
;    TO THE CURRENT TOP OF THE PROGRAM STACK. THE
;    PROGRAM STACK STARTS IN HIGH USER MEMORY AND
;    GROWS DOWNWARD TOWARD THE HEAP.
;
; A5 IS THE BASE PROCEDURE POINTER (BASE). A POINT-
;    ER TO THE ACTIVATION RECORD OF THE MOST RE-
;    CENTLY INVOKED BASE PROCEDURE (LEX LEVEL 0).
;    GLOBAL (LEX LEVEL 0) VARIABLES ARE ACCESSED BY
;    INDEXING OFF BASE.
;
; A4 IS THE INTERPRETER PROGRAM COUNTER (IPC). CON-
;    TAINS THE ADDRESS OF THE NEXT INSTRUCTION TO
;    BE EXECUTED, IN THE CODE SEGMENT OF THE
;    CURRENTLY EXECUTING PROCEDURE.
;
; A3 IS THE MARKSTACK POINTER (MP). A POINTER TO
;    MSSTAT, IN THE TOPMOST MARKSTACK ON THE PRO-
;    GRAM STACK, IN THE ACTIVATION RECORD OF THE
;    CURRENTLY EXECUTING PROCEDURE. VARIABLES LOCAL
;    TO THE CURRENT PROCEDURE ARE ACCESSED BY
;    INDEXING OFF MP.
;
; A2 IS DEDICATED TO POINT TO THE FETCH LOOP.
; A1 IS A SCRATCH REGISTER.
; A0 IS A SCRATCH REGISTER.
;
; D7 IS THE HEAP OR NEW POINTER (NP). A POINTER TO
;    THE CURRENT TOP OF THE DYNAMIC HEAP (ONE WORD
;    BEYOND THE LAST WORD IN USE). THE HEAP STARTS
;    IN LOWER USER MEMORY AND GROWS UPWARD TOWARD
;    THE PROGRAM STACK. IT CONTAINS ALL DYNAMIC
;    VARIABLES (SEE JENSEN AND WIRTH, CHAPTER 10).
;    IT IS EXTENDED BY THE STANDARD PROCEDURE
;    'NEW', AND IS CUT BACK BY THE STANDARD
;    PROCEDURE 'RELEASE'.
;
; D6 IS THE JUMP TABLE POINTER (JTAB). A POINTER TO
;    THE TABLE OF ATTRIBUTES AND JUMP TABLE ENTRIES
;    IN THE PROCEDURE CODE SECTION OF THE
;    CURRENTLY EXECUTING PROCEDURE.
;
; D5 IS THE SEGMENT POINTER (SEG). IT POINTS TO THE
;    PROCEDURE DICTIONARY OF THE SEGMENT TO WHICH
;    THE CURRENTLY EXECUTING PROCEDURE BELONGS.
;
; D4 IS A SCRATCH REGISTER.
; D3 IS A SCRATCH REGISTER.
; D2 IS A SCRATCH REGISTER.
; D1 IS A SCRATCH REGISTER.
;
; D0 HOLDS THE OP-CODE JUST FETCHED, MULTIPLIED
;    BY 2. BITS 8 .. 15 ARE ALWAYS ZERO.
;
 FWRD L
 BRANCH S
 SHORT F
;
; FOLLOWING ARE I/O ASSIGNMENTS:
;
STATUS EQU $0FFA
DATIN EQU $0FF8
DATOUT EQU STATUS
;
; FOLLOWING ARE MEMORY ASSIGNMENTS
; USED BY THE BOOTSTRAP ROM (MONITOR):
;
IDLE EQU $0122
ADRERR EQU $1006
ILINST EQU $100C
ZERDIV EQU $1012
CHECK EQU $1018
TRAPV EQU $101E
EM1010 EQU $1030
EM1111 EQU $1036
TRAP0 EQU $103C
TRAP1 EQU TRAP0+6
TRAP2 EQU TRAP1+6
TRAP3 EQU TRAP2+6
TRAP4 EQU TRAP3+6
TRAP5 EQU TRAP4+6
TRAP6 EQU TRAP5+6
TRAP7 EQU TRAP6+6
TRAP8 EQU TRAP7+6
TRAP9 EQU TRAP8+6
TRAP10 EQU TRAP9+6
TRAP11 EQU TRAP10+6
TRAP12 EQU TRAP11+6
TRAP13 EQU TRAP12+6
;
;**************************************************
;*
;* COMMUNICATION BETWEEN OPERATING SYSTEM AND THE
;* P-MACHINE (AREA 'SYSCOM')
;*
;**************************************************
;
SYSCOM EQU $1100
;
; IORSLT: CONTAINS THE ERROR CODE RETURNED BY THE
;      LAST ACTIVATED OR TERMINATED I/O OPERATION.
;
IORSLT EQU SYSCOM
;
; XEQERR: CONTAINS THE ERROR CODE OF THE LAST
;      EXECUTION ERROR.
;
XEQERR EQU SYSCOM+2
;
; SYSUNIT: CONTAINS THE VOLUME NUMBER OF THE DEVICE
;      FROM WHICH THE OPERATING SYSTEM WAS BOOTED
;
SYSUNIT EQU SYSCOM+4
;
; BUGSTATE: (NOT USED; INTENDED FOR FUTURE
;      DEBUGGING ROUTINES.)
;
BUGSTATE EQU SYSCOM+6
;
; GDIRP: CONTAINS A POINTER TO THE MOST RECENT DISK
;      DIRECTORY READ IN, UNLESS DYNAMIC ALLOCATION
;      OR DEALLOCATION HAS TAKEN PLACE SINCE THEN
;      (SEE THE 'MRK', 'RLS', AND 'NEW' INSTRUC-
;      TIONS).
;
GDIRP EQU SYSCOM+8
;
; BOMBP: CONTAINS A POINTER TO THE ACTIVATION RE-
;      CORD OF THE OPERATING SYSTEM ROUTINE
;      'EXECERROR' WHEN AN EXECUTION ERROR OCCURS
;      (SEE THE ERROR HANDLING SECTION).
;
BOMBP EQU SYSCOM+$A
;
; STKBASE: CONTAINS A COPY OF THE BASE REGISTER.
;
STKBASE EQU SYSCOM+$C
;
; LASTMP: CONTAINS A COPY OF THE MP REGISTER.
;
LASTMP EQU SYSCOM+$E
;
; JTAB: CONTAINS A COPY OF THE JTAB REGISTER.
;
JTAB EQU SYSCOM+$10
;
; SEG: CONTAINS A COPY OF THE SEG REGISTER.
;
SEG EQU SYSCOM+$12
;
; MEMTOP: POINTER TO TOP OF MEMORY (BOTTOM OF
;      PROGRAM STACK).
;
MEMTOP EQU SYSCOM+$14
;
; BOMIPC: CONTAINS THE VALUE OF IPC WHEN AN
;      EXECUTION ERROR OCCURS.
;
BOMIPC EQU SYSCOM+$16
;
; HLTLINE: (NOT USED; INTENDED FOR FUTURE
;      DEBUGGING ROUTINES.)
;
HLTLINE EQU SYSCOM+$18
;
; BRKPTS: (NOT USED; INTENDED FOR FUTURE
;      DEBUGGING ROUTINES.)
;
BRKPTS EQU SYSCOM+$1A
;
; MISCINFO: CONFIGURATION INFORMATION.
;
MISCINFO EQU SYSCOM+$3A
;
CRTTYPE EQU SYSCOM+$3C
;
CRTCTRL EQU SYSCOM+$3E
;
HEIGHT EQU SYSCOM+$4A ;SCREEN HEIGHT
WIDTH EQU SYSCOM+$4C ;SCREEN WIDTH
UP EQU SYSCOM+$4E ;CURSOR UP
DOWN EQU SYSCOM+$4F ;CURSOR DOWN
LEFT EQU SYSCOM+$50 ;CURSOR LEFT
RIGHT EQU SYSCOM+$51 ;CURSOR RIGHT
EOF EQU SYSCOM+$52 ;KEY TO END FILE
FLUSH EQU SYSCOM+$53 ;KEY FOR FLUSH
BREAK EQU SYSCOM+$54 ;KEY FOR BREAK
STOP EQU SYSCOM+$55 ;KEY FOR STOP
CHARDEL EQU SYSCOM+$56 ;KEY TO DELETE CHAR
BADCH EQU SYSCOM+$57 ;NON PRINTING CHAR
LINEDEL EQU SYSCOM+$58 ;KEY TO DELETE LINE
ALTMODE EQU SYSCOM+$59 ;EDITOR ESCAPE KEY
ESCAPE EQU SYSCOM+$5A ;LEAD IN FROM KEYBD
ACCEPT EQU SYSCOM+$5B ;EDITOR ACCEPT KEY
BCKSPACE EQU SYSCOM+$5C ;BACKSPACE
;
; SEGMENT TABLE = ARRAY [0 .. 63] OF
;    RECORD
;       UNITNUM : INTEGER;
;       BLOCKNUM: INTEGER;
;       CODELENG: INTEGER
;    END
;
SEGTABLE EQU SYSCOM+$60
;
;**************************************************
;
; FOLLOWING ARE THE LOCATIONS OF SYSTEM PERMANENTS.
; THESE LOCATIONS ARE DEFINED TO HAVE THE SAME
; FUNCTION & REMAIN IN THE SAME PLACE FOR FUTURE
; VERSIONS OF THIS INTERPRETER.
;
;**************************************************
;
; PCODE POINTS TO THE ENTRY POINT THAT PROVIDES
; ACCESS TO P-CODE PROCEDURES FOR ASSEMBLY
; LANGUAGE PROGRAMS
;
PCODE EQU $12E0
;
; DISKNUMP POINTS TO THE DISKNUM VECTOR.
;
DISKNUMP EQU PCODE+4
;
; BIOS POINTS TO THE BIOS JUMP VECTOR.
;
BIOS EQU DISKNUMP+4
;
; IBREAK AND ISYSCOM ARE SET BY THE INTERPRETER
; BOOT FOR ASSEMBLY CALLS TO CONINIT.
;
IBREAK EQU BIOS+4
ISYSCOM EQU IBREAK+4
;
; THE VERSION BYTE IS 1.2 FOR THIS RELEASE.
;
VERSION EQU ISYSCOM+4
;
; THE FLAVOR BYTE TELLS FOR WHICH MEMORY SIZE AND
; FOR WHICH OPERATING SYSTEM INTER68 IS CONFIGURED.
; THE ENCODING IS AS FOLLOWS:
;
;    BIT 0 SET --> INTER68 RESIDES ABOVE ZERO PAGE
;    BIT 1 SET --> INTERPRETS APPLE PASCAL 1.2
;
FLAVOR EQU VERSION+1
;
; THE SPCHAR BYTE CONTROLS THE SPECIAL CHARACTER
; CHECKING:
;
; BIT 0 SET --> DON'T CHECK FOR CTRL A,Z,K,W,E.
; BIT 1 SET --> DON'T CHECK FOR CTRL S & F.
;
SPCHAR EQU FLAVOR+1
;
; THE CONFIGURATION BYTE CONTAINS USER DEFINABLE
; INFORMATION:
;
;    BIT 0 SET --> STUFFER BOARD PRESENT
;    BIT 2 SET --> 16081 PROCESSOR PRESENT
;    BIT 1,3-6 --> UNUSED IN THIS VERSION
;    BIT 7 SET --> DEBUGGING MODE
;
CONFIG EQU SPCHAR+1
;
; MEMSIZE CONTAINS THE HIGHEST RAM ADDRESS + 1.
;
MEMSIZE EQU CONFIG+1
;
; STACK CONTAINS THE INITIAL STACK ADDRESS.
;
STACK EQU MEMSIZE+4
;
; THE SPACE FROM $1300-$147F MAY BE USED AS
; TEMPORARY SCRATCH SPACE. INTER68 ALSO USES
; THIS SPACE FOR TEMPORARY STORAGE.
;
TEMP EQU STACK+4
;
; THE SPACE FROM $1480-$14FF IS RESERVED FOR USE
; BY INTER68. USER PROGRAMS MUST NOT WRITE TO THIS
; SPACE OR THE SYSTEM MAY CRASH.
;
;**************************************************
;*
;* FOLLOWING ARE MISCELLANEOUS CONSTANTS
;*
;**************************************************
;
SPMAX EQU $1500 ;MAXIMUM TOS
SPOFF EQU 10 ;SAFETY MARGIN
MPOFF EQU 10 ;MARKSTACK OFFSET
NIL EQU 0
FALSE EQU 0
TRUE EQU 1
NOBREAK EQU 6
ACK EQU 6
LF EQU 10
CR EQU 13
DLE EQU 16
BUFFER EQU $4000
DIRSIZE EQU 2028
FBLKSIZE EQU 512
DIRBLK EQU 2
MAXUNIT EQU 20
HIGHADDR EQU $15000
;
CONSOLE EQU 1
SYSTERM EQU 2
GRAFIC EQU 3
PRINTER EQU 6
REMIN EQU 7
REMOUT EQU 8
;
 ORG $10000,SYSTEM.68000.OBJ0,D1
;
START BRA.L INIT
;
 ASC 'Copyright (C) 1984 Ulrich Schmidt'
;
;**************************************************
;*
;* OP-CODE FETCH LOOP
;*
;**************************************************
;
; LOAD CONSTANT NIL. PUSH THE IMPLEMENTATION-
; DEPENDENT VALUE OF NIL.
;
LDCN CLR.W D0
;
; SHORT LOAD ONE-WORD CONSTANT. FOR AN INSTRUCTION
; SLDC X, PUSH THE OP-CODE, X, WITH HIGH BYTE ZERO.
;
SLDC MOVE.W D0,-(SP)
;
; FETCH NEXT OP-CODE
;
FETCHOFF EQU @$10000
;
FETCH MOVE.B (A4)+,D0
 BPL SLDC
 ADD.B D0,D0
 MOVEA.W @TABLE(PC,D0.W),A0
 JMP FETCHOFF(A0,A2.L)
;
; FLAGS TO INDICATE BYTE SEX
;
SEX DS.B 64
CURRSEX DS.B 1
;
; P-MACHINE OP-CODES
;
TABLE DC.W ABI
 DC.W ABR
 DC.W ADI
 DC.W ADR
 DC.W LAND
 DC.W DIF
 DC.W DVI
 DC.W DVR
 DC.W CHK
 DC.W FLO
 DC.W FLT
 DC.W INN
 DC.W INT
 DC.W LOR
 DC.W MODI 
 DC.W MPI
 DC.W MPR
 DC.W NGI
 DC.W NGR
 DC.W LNOT
 DC.W SRS
 DC.W SBI
 DC.W SBR
 DC.W SGS
 DC.W SQI
 DC.W SQR
 DC.W STO
 DC.W IXS
 DC.W UNI
 DC.W LDE
 DC.W CSP
 DC.W LDCN
 DC.W ADJ
FJPADDR DC.W FJP
 DC.W INC
 DC.W IND
 DC.W IXA
 DC.W LAO
 DC.W LSA
 DC.W LAE
 DC.W MOV
 DC.W LDO
 DC.W SAS
 DC.W SRO
XJPADDR DC.W XJP
 DC.W RNP
 DC.W CIP
 DC.W EQU
 DC.W GEQ
 DC.W GRT
 DC.W LDA
LDCADDR DC.W LDC
 DC.W LEQ
 DC.W LES
 DC.W LOD
 DC.W NEQ
 DC.W STR
UJPADDR DC.W UJP
 DC.W LDP
 DC.W STP
 DC.W LDM
 DC.W STM
 DC.W LDB
 DC.W STB
 DC.W IXP
 DC.W RBP
 DC.W CBP
 DC.W EQUI
 DC.W GEQI
 DC.W GRTI
 DC.W LLA
 DC.W LDCI
 DC.W LEQI
 DC.W LESI
 DC.W LDL
 DC.W NEQI
 DC.W STL
 DC.W CXP
 DC.W CLP
 DC.W CGP
 DC.W LPA
 DC.W STE
 DC.W BADPCODE ;D2
EFJADDR DC.W EFJ
NFJADDR DC.W NFJ
 DC.W BPT
 DC.W XIT
 DC.W FETCH
 DC.W SLDL1
 DC.W SLDL2
 DC.W SLDL3
 DC.W SLDL4
 DC.W SLDL5
 DC.W SLDL6
 DC.W SLDL7
 DC.W SLDL8
 DC.W SLDL9
 DC.W SLDL10
 DC.W SLDL11
 DC.W SLDL12
 DC.W SLDL13
 DC.W SLDL14
 DC.W SLDL15
 DC.W SLDL16
 DC.W SLDO1
 DC.W SLDO2
 DC.W SLDO3
 DC.W SLDO4
 DC.W SLDO5
 DC.W SLDO6
 DC.W SLDO7
 DC.W SLDO8
 DC.W SLDO9
 DC.W SLDO10
 DC.W SLDO11
 DC.W SLDO12
 DC.W SLDO13
 DC.W SLDO14
 DC.W SLDO15
 DC.W SLDO16
 DC.W SIND0
 DC.W SIND1
 DC.W SIND2
 DC.W SIND3
 DC.W SIND4
 DC.W SIND5
 DC.W SIND6
 DC.W SIND7
;
BADPCODE SUBQ.W #1,A4
 BRA.L XNOTIMP
;
ERRMSG ASC 'No file '
TID ASC '68000.PASCAL'
TIDLENG EQU *-TID
ERRMSGL EQU *-ERRMSG
;
;**************************************************
;*
;* INTERPRETER INITIALIZATION
;*
;**************************************************
;
RAMVOL DS.B 1
WARMBOOT DC.B FALSE
;
; DEFAULT BYTE SEX FOR VARIOUS MACHINE TYPES
;
PMINUS EQU 0
PPLUS EQU 1
;
MTYPE DC.B PMINUS ; 0
 DC.B PPLUS ; 1
 DC.B PMINUS ; 2
 DC.B PPLUS ; 3
 DC.B PPLUS ; 4
 DC.B PPLUS ; 5
 DC.B PPLUS ; 6
 DC.B PMINUS ; 7
 DC.B PPLUS ; 8
 DC.B PPLUS ; 9
 DC.B PPLUS ;10
 DC.B PPLUS ;11
 DC.B PPLUS ;12
 DC.B PPLUS ;13
 DC.B PPLUS ;14
 DC.B PPLUS ;15
;
; DETERMINE THE BYTE SEX FOR EACH SEGMENT OF A
; NEWLY LOADED SEGMENT DICTIONARY.
;
FINDSEX MOVEM.L D0-D2/A0-A2,-(SP)
 LEA @SEX(PC),A2
 LEA 2(A0),A1
 LEA 256(A0),A0
 MOVEQ #15,D1
 MOVEQ #0,D2
;
FINDSEX1 TST.W (A1)
 BEQ FINDSEX4
 MOVE.B (A0),D0
 BEQ FINDSEX4
 CMPI.B #63,D0
 BHI FINDSEX3
 MOVE.B 1(A0),D2
 ANDI.W #$000F,D2
 MOVE.B @MTYPE(PC,D2.W),0(A2,D0.W)
 BRA FINDSEX4
;
FINDSEX3 ANDI.W #$000F,D0
 MOVE.B 1(A0),D2
 MOVE.B @MTYPE(PC,D0.W),0(A2,D2.W)
FINDSEX4 ADDQ.W #4,A1
 ADDQ.W #2,A0
 DBF D1,FINDSEX1
;
 MOVEQ #14,D1
 MOVEQ #0,D2
 SUBA.W #15*4,A1
 SUBA.W #15*2,A0
;
FINDSEX5 TST.W (A1)
 BEQ FINDSEX6
 TST.B (A0)
 BNE FINDSEX6
 MOVEQ #15,D0
 SUB.B D1,D0
 MOVE.B D2,0(A2,D0.W)
FINDSEX6 ADDQ.W #4,A1
 ADDQ.W #2,A0
 DBF D1,FINDSEX5
;
 MOVEM.L (SP)+,D0-D2/A0-A2
 RTS
;
; DETERMINE THE BYTE SEX OF THE SEGMENT WHOSE
; SEGMENT NUMBER IS PASSED IN D0.
;
LOADSEX MOVE.L A0,-(SP)
 LEA @SEX(PC),A0
 MOVE.B 0(A0,D0.W),D0
 CMP.B @CURRSEX(PC),D0
 BEQ LOADSEX2
 MOVE.B D0,CURRSEX-SEX(A0)
 BEQ LOADSEX1
 MOVE.W #FJUMP,FJPADDR-SEX(A0)
 MOVE.W #XJUMP,XJPADDR-SEX(A0)
 MOVE.W #LOADC,LDCADDR-SEX(A0)
 MOVE.W #UJUMP,UJPADDR-SEX(A0)
 MOVE.W #EFJUMP,EFJADDR-SEX(A0)
 MOVE.W #NFJUMP,NFJADDR-SEX(A0)
 BRA LOADSEX2
;
LOADSEX1 MOVE.W #FJP,FJPADDR-SEX(A0)
 MOVE.W #XJP,XJPADDR-SEX(A0)
 MOVE.W #LDC,LDCADDR-SEX(A0)
 MOVE.W #UJP,UJPADDR-SEX(A0)
 MOVE.W #EFJ,EFJADDR-SEX(A0)
 MOVE.W #NFJ,NFJADDR-SEX(A0)
LOADSEX2 MOVEA.L (SP)+,A0
 RTS
;
; INITIALIZE THE INTERPRETER.
;
INIT BTST #6,STATUS
 BNE INIT
;
; SEND AN ACKNOWLEDGEMENT BYTE.
;
 MOVE.B #ACK,DATOUT
 MOVE.L #XBADMEM,ADRERR+2
 MOVE.L #XBADMEM,ILINST+2
 MOVE.L #XDIVZER,ZERDIV+2
 MOVE.L #XINVNDX,CHECK+2
 MOVE.L #XINTOVR,TRAPV+2
 MOVE.L #XBADMEM,EM1010+2
 MOVE.L #XBADMEM,EM1111+2
;
; TRAP VECTORS #0 - #13 POINT TO EXECUTION ERROR
; ROUTINES #0 - #13.
;
 MOVE.L #XSYSERR,TRAP0+2
 MOVE.L #XINVNDX,TRAP1+2
 MOVE.L #XNOPROC,TRAP2+2
 MOVE.L #XNOEXIT,TRAP3+2
 MOVE.L #XSTKOVR,TRAP4+2
 MOVE.L #XINTOVR,TRAP5+2
 MOVE.L #XDIVZER,TRAP6+2
 MOVE.L #XBADMEM,TRAP7+2
 MOVE.L #XUBREAK,TRAP8+2
 MOVE.L #XSYIOER,TRAP9+2
 MOVE.L #XUIOERR,TRAP10+2
 MOVE.L #XNOTIMP,TRAP11+2
 MOVE.L #XFPIERR,TRAP12+2
 MOVE.L #XS2LONG,TRAP13+2
;
; INITIALIZE SYSTEM PERMANENTS.
;
 LEA PCODE,A0
 MOVE.L #CALLPAS,(A0)+
 MOVE.L #DISKNUM,(A0)+
 MOVE.L #CONREAD,(A0)+
 MOVE.L #XUBREAK,(A0)+
 MOVE.L #SYSCOM,(A0)+
 MOVE.B #$12,(A0)+
 MOVE.B #1,(A0)+
 MOVEQ #0,D0
 MOVE.B D0,(A0)+
;
; INITIALIZE STACK AND HEAP POINTERS.
;
 MOVEA.W STACK+2,SP
 MOVE.W SP,D7
;
; INITIALIZE SYSCOM.
;
 LEA SYSCOM,A0
 LEA @FETCH(PC),A2
 MOVEQ #119,D1
;
CLRSYS MOVE.L D0,(A0)+
 DBF D1,CLRSYS
;
 MOVE.B TEMP,D0
 MOVE.W D0,SYSUNIT
 MOVE.B TEMP+1,D0
 LEA @DISKNUM-1(PC),A4
 MOVE.B 0(A4,D0.W),RAMVOL
 MOVEQ #0,D0
 LEA START-2,A6
 MOVE.W A6,MEMTOP
;
; INITIALIZE THE SEGMENT COUNTERS.
;
 LEA @SEGCOUNT(PC),A0
 MOVEQ #31,D1
;
CLRSEG MOVE.L D0,(A0)+
 DBF D1,CLRSEG
;
; INITIALIZE THE DLE FLAGS.
;
 LEA @DLEFLAGS(PC),A0
 MOVE.L D0,(A0)+
 MOVE.L D0,(A0)+
;
; INITIALIZE THE BYTE SEX FLAGS.
;
 LEA @SEX(PC),A0
 MOVEQ #15,D1
;
CLRSEX MOVE.L D0,(A0)+
 DBF D1,CLRSEX
;
 MOVE.B #TRUE,CURRSEX
 BSR LOADSEX
;
; FIND OUT WHETHER THE USER WANTS TO BOOT FROM THE
; RAM DISK.
;
 MOVE.W SYSUNIT,D6
 MOVE.B @RAMVOL(PC),D5
 CMP.B 0(A4,D6.W),D5
 BNE.L READDIR
;
; THE RAM DISK IS THE ROOT VOLUME. FIRST FIND OUT
; WHETHER THE RAM DISK IS ALREADY FORMATTED FROM A
; PREVIOUS SESSION.
;
 TAS WARMBOOT
 BNE.L READDIR ;SKIP IF WARM BOOT
;
; GIVE THE USER A LAST CHANCE IN CASE HE HAS
; INADVERTENTLY RELOADED THE INTERPRETER. CHECK
; IF THE FIRST DIRECTORY ENTRY CONTAINS
; MEANINGFUL DATA.
;
 MOVE.L #$07494E54,D5 ;'INT'
 MOVE.L #$45523638,D6 ;'ER68'
 LEA @RAMDISK+1030(PC),A3
 CMP.L (A3)+,D5
 BNE INITRAM
 CMP.L (A3)+,D6
 BEQ.L READDIR
;
; THE RAM DISK DIRECTORY CONTAINS GARBAGE. NOW
; TRANSFER AS MANY FILES AS POSSIBLE FROM DISK #4
; TO THE RAM DISK.
;
; READ THE DISK DIRECTORY OF UNIT #4.
;
INITRAM MOVEQ #0,D0
 MOVE.L D0,-(SP)
 MOVE.L #BUFFER,-(SP)
 MOVE.W #DIRSIZE,-(SP)
 MOVE.W #DIRBLK,-(SP)
 BSR.L DISKREAD
 TST.W D1
 BNE.L INITERR
;
; CHANGE THE BYTE SEX OF THE DISK DIRECTORY.
;
 LEA BUFFER,A0
 MOVE.W #DIRSIZE,D4
 BSR.L FLIPDIR
;
; DETERMINE THE NUMBER OF BLOCKS TO BE TRANSFERRED.
; LIMIT THE NUMBER IF NECESSARY SO THAT IT DOES'NT
; EXCEED THE RAM DISK CAPACITY.
;
 LEA @RAMDISK(PC),A3 ;POINT TO RAM DISK
 MOVEQ #0,D3 ;# OF FIRST BLOCK
 MOVEQ #26,D4 ;SIZE OF DIRENTRY
 MULU BUFFER+16,D4 ;MULT BY NUMOFFILES
 BEQ.L INITERR ;ERROR IF NO FILES
 ADDI.L #BUFFER+2,D4 ;LAST ENTRY
 MOVEA.L D4,A0
 MOVEQ #0,D4
 MOVE.W (A0),D4 ;LAST BLOCK
 MOVEQ #9,D0
 LSL.L D0,D4 ;MULT BY 512
 MOVE.L MEMSIZE,D1
 SUBI.L #RAMDISK,D1
 CMP.L D4,D1 ;TOO MANY BLOCKS?
 BCC INITRAM1 ;NO, SO SKIP
 MOVE.L D1,D4 ;YES, SO LIMIT
;
; WE ARE NOW READY TO START THE TRANSFER. WE MOVE
; UP TO 63 BLOCKS AT A TIME, AND LOOP UNTIL ALL
; BLOCKS ARE TRANSFERRED.
;
INITRAM1 MOVEQ #0,D0
 MOVE.L D0,-(SP) ;MODE & DRIVE #
 MOVE.L A3,-(SP) ;DESTINATION ADDR
 MOVE.L #63*512,D1 ;DEFAULT SIZE
 CMP.L D1,D4 ;TOO LONG?
 BCC INITRAM2 ;NO, SKIP
 MOVE.L D4,D1 ;YES, TRANSFER REST
INITRAM2 SUB.L D1,D4 ;DECR BLOCK COUNT
 ADDA.L D1,A3 ;INCR DEST ADDRESS
 MOVE.W D1,-(SP)
 MOVE.W D3,-(SP) ;BLOCK NUMBER
 MOVEQ #9,D0
 LSR.W D0,D1
 ADD.W D1,D3 ;INCR BLOCK NUMBER
 BSR.L DISKREAD
 TST.W D1
 BNE.L INITERR
 TST.L D4 ;ALL DONE?
 BNE INITRAM1 ;NO, LOOP
;
; MAKE THE RAM DISK DIRECTORY READABLE BY CHANGING
; ITS BYTE SEX.
;
 LEA @RAMDISK+1024(PC),A0
 MOVE.W #DIRSIZE,D4
 BSR.L FLIPDIR
;
; CHANGE THE RAM DISK NAME TO 'INTER68'.
;
 LEA @RAMDISK+1030(PC),A3
 MOVE.L D5,(A3)+
 MOVE.L D6,(A3)+
;
; CALCULATE THE NUMBER OF BLOCKS AND PUT IT IN
; THE RAM DISK DIRECTORY.
;
 MOVE.L MEMSIZE,D1
 SUBI.L #RAMDISK,D1
 MOVEQ #9,D0
 LSR.L D0,D1
 MOVE.W D1,(A3)+
;
; IF NOT ALL FILES OF DISK #4 HAVE BEEN TRANSFERRED
; THEN THE DISK DIRECTORY CONTAINS TOO MANY
; ENTRIES. REMOVE THOSE ENTRIES THAT DO NOT CORRE-
; SPOND TO A FILE ON THE RAM DISK BY DECREMENTING
; THE 'NUMBER OF FILES'-FIELD IN THE FIRST DISK
; DIRECTORY ENTRY.
;
; FIND THE LAST DIRECTORY ENTRY.
;
 MOVEQ #26,D6 ;SIZE OF DIRENTRY
 MULU (A3),D6
 ADDI.L #RAMDISK+1026,D6
 MOVEA.L D6,A0
;
; REMOVE ALL SUPERFLUOUS ENTRIES.
;
INITRAM3 CMP.W (A0),D3
 BCC INITRAM4
 SUBQ.W #1,(A3)
 BEQ.L INITERR ;ERROR IF NO FILES
 LEA -26(A0),A0 ;NEXT ENTRY
 BRA INITRAM3
;
; THE RAM DISK IS CORRECTLY SET UP. CHANGE THE
; DIRECTORY BYTE SEX BACK TO NEGATIVE BYTE SEX.
;
INITRAM4 LEA @RAMDISK+1024(PC),A0
 MOVE.W #DIRSIZE,D4
 BSR.L FLIPDIR
;
; READ THE DISK DIRECTORY OF THE ROOT VOLUME.
;
READDIR MOVEQ #0,D0
 MOVE.W D0,-(SP) ;MODE PARAM
 MOVE.W SYSUNIT,D6 ;GET ROOT VOL #
 MOVE.B 0(A4,D6.W),D0
 MOVE.W D0,-(SP) ;DRIVE #
 MOVE.L #BUFFER,-(SP)
 MOVE.W #DIRSIZE,-(SP)
 MOVE.W #DIRBLK,-(SP)
 BSR.L DISKREAD ;READ ROOT DIR
 TST.W D1
 BNE.L INITERR
 LEA BUFFER,A0
 MOVE.W #DIRSIZE,D4
 BSR.L FLIPDIR
;
; FORMAT THE RAM DISK IF THIS IS A COLD BOOT.
;
 TAS WARMBOOT
 BNE.L LOOKOS ;SKIP IF WARM BOOT
;
; HAS THE INTERPRETER BEEN LOADED INADVERTENTLY?
;
 MOVE.L #$07494E54,D5 ;'INT'
 MOVE.L #$45523638,D6 ;'ER68'
 LEA @RAMDISK+1030(PC),A3
 CMP.L (A3)+,D5
 BNE FORMAT
 CMP.L (A3)+,D6
 BEQ.L LOOKOS
;
; WRITE THE FIRST DIRECTORY ENTRY.
;
FORMAT LEA @RAMDISK+1024(PC),A3
 MOVE.L #$00000600,(A3)+ ;BLOCK 0 - 6
 MOVEQ #0,D0
 MOVE.W D0,(A3)+
 MOVE.L D5,(A3)+
 MOVE.L D6,(A3)+
 MOVE.L MEMSIZE,D1
 SUBI.L #RAMDISK,D1
 MOVEQ #9,D2
 LSR.L D2,D1
 ROL.W #8,D1
 MOVE.W D1,(A3)+
 MOVE.W D0,(A3)+ ;NUMOFFILES := 0
 MOVE.W BUFFER+18,D1 ;TIME
 ROL.W #8,D1
 MOVE.W D1,(A3)+
 MOVE.W BUFFER+20,D1 ;DATE
 ROL.W #8,D1
 MOVE.W D1,(A3)+
;
; LOOK FOR THE OPERATING SYSTEM.
;
LOOKOS MOVE.W BUFFER+16,D1
 BEQ INITERR
 SUBQ.W #1,D1
 MOVEQ #TIDLENG-1,D2
 LEA @TID(PC),A0
 MOVE.W #BUFFER+26+6,D3
;
INIT3 MOVEA.W D3,A3
 CMPI.B #TIDLENG,(A3)+
 BNE INIT5
 MOVE.W D2,D4
 MOVEA.L A0,A1
;
INIT4 CMPM.B (A1)+,(A3)+
 DBNE D4,INIT4
;
 BEQ FOUND
INIT5 ADDI.W #26,D3
 DBF D1,INIT3
;
; FILE NOT FOUND. EXIT TO HOST.
;
INITERR MOVEQ #ERRMSGL-1,D3
 LEA @ERRMSG(PC),A4
 LEA @CONWRITE(PC),A3
;
INITERR1 CLR.W D0
 MOVE.B (A4)+,D0
 JSR (A3)
 DBF D3,INITERR1
;
 CLR.W D0
 BRA.L XIT
;
; READ THE SEGMENT DICTIONARY OF THE OPERATING
; SYSTEM.
;
FOUND MOVEQ #0,D0
 MOVE.W D0,-(SP)
 MOVEA.W D3,A0
 MOVE.W -6(A0),D5
 ADDA.W SYSUNIT,A4
 MOVE.B (A4),D0
 MOVE.W D0,-(SP)
 MOVE.L #BUFFER,-(SP)
 MOVE.W #FBLKSIZE,-(SP)
 MOVE.W D5,-(SP)
 BSR.L DISKREAD
 TST.W D1
 BNE INITERR
;
; TRANSFER THE SEGMENT DICTIONARY TO THE
; SEGMENT TABLE.
;
 LEA BUFFER,A0
 BSR FINDSEX
 MOVEQ #15,D0
 LEA @SEX(PC),A1
;
FOUND2A TST.L (A1)+
 DBNE D0,FOUND2A
;
 SNE D0
 NEG.B D0
 MOVE.B D0,SEX
 MOVEQ #0,D0
 BSR LOADSEX
 TST.B CURRSEX
 BNE FOUND3
 BSR.L FLIPCODE
FOUND3 LEA SEGTABLE,A0
 LEA BUFFER,A1
 MOVEQ #16-1,D1
 MOVE.W SYSUNIT,D0
;
FILLSEG MOVE.W D0,(A0)+
 MOVE.W (A1)+,D2
 ADD.W D5,D2
 MOVE.W D2,(A0)+
 MOVE.W (A1)+,(A0)+
 DBF D1,FILLSEG
;
; READ SEGMENT 0.
;
 MOVEQ #0,D0
 BSR.L INVOKE
 TST.B CURRSEX
 BNE SETUP
;
; READ SEGMENT 15.
;
 MOVEQ #15,D0
 BSR.L READSEG
;
; TEST FOR VERSION 1.2
;
 CMPI.B #$A2,$100+BUFFER
 BEQ.L FLIP12
;
; FLIP THE FIRST 28 PROCEDURES IN THE NORMAL WAY.
;
 MOVEA.W @PROCDIC(PC),A0
 MOVEQ #27,D1
 BSR.L FLIPBYT1
;
; FLIP PROCEDURES 29-57 AND CORRECT THEIR OFFSETS.
;
 BRA FLIP11
;
FLIPSYS MOVE.W -(A0),D2
 ROL.W #8,D2
 SUB.W D4,D2
 MOVE.W D2,(A0)
 MOVEA.W A0,A1
 SUBA.W D2,A1
 MOVEQ #3,D2
;
FLIPSYS1 MOVE.W -(A1),D3
 MOVE.B (A1)+,(A1)
 MOVE.B D3,-(A1)
 DBF D2,FLIPSYS1
;
 DBF D1,FLIPSYS
;
 RTS
;
FLIP11 MOVE.W #$3512,D4
 MOVEQ #28,D1
 BSR FLIPSYS
 BRA SETUP
;
; TREAT VERSION 1.2
;
FLIP12 MOVEA.W @PROCDIC(PC),A0
 BSET #1,FLAVOR
 MOVEQ #29,D1
 BSR.L FLIPBYT1
 MOVE.W #$3524,D4
 MOVEQ #0,D1
 BSR FLIPSYS
 MOVEQ #0,D1
 BSR.L FLIPBYT1
 MOVEQ #0,D1
 BSR FLIPSYS
 MOVEQ #0,D1
 BSR.L FLIPBYT1
 MOVEQ #23,D1
 BSR FLIPSYS
;
; SET UP MARKSTACK FOR PROCEDURE 1, SEGMENT 0.
;
SETUP MOVEQ #0,D1
 MOVEQ #1,D0
 BSR.L EXTERN
 MOVEA.W A3,A5
 MOVE.W A3,(A3)
 MOVE.W A3,2(A3)
 MOVE.W #SYSCOM,MPOFF+2(A3)
 JMP (A2)
;
 CHAIN SYSTEM.68000.A
