;**************************************************
;*
;* ERROR HANDLING
;*
;**************************************************
;
; WHENEVER AN EXECUTION ERROR OCCURS, THE P-MACHINE
; STOPS EXECUTING THE CURRENT INSTRUCTION AND DOES
; THE FOLLOWING:
;
; 1. ENTERS THE ERROR CODE INTO SYSCOM^.XEQERR,
;
; 2. CALCULATES WHAT MP WILL BE AFTER STEP 4, AND
;    SETS SYSCOM^.BOMBP TO THAT (THE SIZE OF
;    EXECERROR'S ACTIVATION RECORD IS KNOWN BY THE
;    P-MACHINE),
;
; 3. STORES THE CURRENT VALUE OF IPC INTO
;    SYSCOM^.BOMIPC,
;
; 4. POINTS IPC TO A CXP 0,2 P-CODE INSTRUCTION
;    (CALL OPERATING SYSTEM PROCEDURE EXECERROR)
;    AND
;
; 5. RESUMES EXECUTION OF INTERPRETER CODE,
;    STARTING WITH THE CXP.
;
;
; SYSTEM ERROR OF UNDEFINED NATURE. (FATAL)
;
XSYSERR MOVEQ #0,D1
EXECERR MOVE.W D1,XEQERR
 MOVE.W A4,BOMIPC
 MOVE.W A6,D1
 SUBI.W #14,D1
 MOVE.W D1,BOMBP
 BTST #1,FLAVOR
 BEQ EXECERR1
 MOVEA.W D5,A0
 MOVE.B (A0),D0
 MOVE.W D0,SEG
 MOVEA.W D6,A0
 MOVE.B (A0),D0
 MOVE.W D0,JTAB
 SUBA.W -(A0),A0
 MOVE.W A4,D1
 SUB.W A0,D1
 MOVE.W D1,BOMIPC
EXECERR1 MOVEQ #0,D0
 BSR LOADSEX
 MOVEQ #0,D1
 MOVEQ #2,D0
 BRA.L CXP2
;
; INVALID INDEX, VALUE OUT OF RANGE FOR STRING OR
; SUBRANGE. DOES NOT OCCUR IF R- COMPILER OPTION
; USED.
;
XINVNDX MOVEQ #1,D1
 BRA EXECERR
;
; NO SEGMENT: BAD CODE FILE. FILE READS CORRECTLY
; FROM DISK, BUT NOT A VALID SEGMENT.
;
XNOPROC MOVEQ #2,D1
 BRA EXECERR
;
; PROCEDURE NOT PRESENT AT EXIT TIME: EXIT FROM A
; PROCEDURE THAT WAS NOT PREVIOUSLY CALLED OR
; ACTIVE.
;
XNOEXIT MOVEQ #3,D1
 BRA EXECERR
;
; STACK OVERFLOW: THE PROGRAM STACK AND THE HEAP
; TOGETHER HAVE EXCEEDED AVAILABLE USER MEMORY.
;
XSTKOVR MOVEQ #4,D1
 MOVE.W #NIL,GDIRP
 MOVE.W #$6200,D7
 LEA $8000,A6
 BRA EXECERR
;
; INTEGER OVERFLOW. INTEGER ARITHMETIC GAVE A
; RESULT > 16 BITS. LONG INTEGER ARITHMETIC GAVE
; AN INTERMEDIATE RESULT > 36 DIGITS OR FINAL
; RESULT WAS ASSIGNED TO VARIABLE OF INSUFFICIENT
; SIZE.
;
XINTOVR MOVEQ #5,D1
 BRA EXECERR
;
; DIVIDE BY ZERO.
;
XDIVZER MOVEQ #6,D1
 BRA EXECERR
;
; INVALID MEMORY REFERENCE.
;
XBADMEM MOVEQ #7,D1
 BRA EXECERR
;
; USER BREAK: "BREAK" KEY PRESSED.
;
XUBREAK MOVEQ #8,D1
 BRA EXECERR
;
; SYSTEM I/O ERROR: ERROR IN ATTEMPTING TO READ
; AN OPERATING SYSTEM SEGMENT FROM DISK. (FATAL)
;
XSYIOER MOVEQ #9,D1
 BRA EXECERR
;
; USER I/O ERROR: ERROR WHEN USER'S PROGRAM 
; ATTEMPTED A BLOCKREAD, BLOCKWRITE, GET, OR PUT.
; IF FILE SYSTEM.PASCAL AVAILABLE, THIS ERROR IS
; FURTHER REPORTED AS AN I/O ERROR.
;
XUIOERR MOVEQ #10,D1
 BRA EXECERR
;
; UNIMPLEMENTED INSTRUCTION: OP-CODE NOT IMPLEMEN-
; TED, OR CSP TO NON-EXISTENT ROUTINE.
;
XNOTIMP MOVEQ #11,D1
 BRA EXECERR
;
; FLOATING POINT MATH ERROR: ERROR IN REAL NUMBER
; FORMAT, OVERFLOW, UNDERFLOW, ETC.
;
XFPIERR MOVEQ #12,D1
 BRA EXECERR
;
; STRING TOO LONG: ATTEMPT TO STORE A SOURCE
; STRING INTO A DESTINATION STRING OF INSUFFICIENT
; SIZE.
;
XS2LONG MOVEQ #13,D1
 BRA EXECERR
;
; HALT, BREAKPOINT (WITHOUT DEBUGGER IN CORE).
;
XHLTBPT MOVEQ #14,D1
 BRA EXECERR
;
; PROGRAMMED BREAK-POINT
;
XPRGBPT MOVEQ #15,D1
 BRA EXECERR
;
;
; I/O ERROR NUMBERS
;
; NO ERROR.
;
NOERROR EQU 0
;
; DISKETTE HAS BAD BLOCK: PARITY ERROR (CRC).
;
HARDERR EQU 1
;
; BAD DEVICE (VOLUME) NUMBER.
;
BADUNIT EQU 2
;
; BAD MODE: ILLEGAL OPERATION.
;
BADMODE EQU 3
;
; UNDEFINED HARDWARE ERROR.
;
TIMEOUT EQU 4
;
; LOST DEVICE: DEVICE IS NO LONGER ON-LINE, AFTER
; SUCCESSFULLY STARTING AN OPERATION USING THAT
; DEVICE.
;
LOSTUNIT EQU 5
;
; LOST FILE: FILE IS NO LONGER IN THE DISKETTE
; DIRECTORY, AFTER SUCCESSFULLY STARTING AN
; OPERATION USING THAT FILE.
;
LOSTFILE EQU 6
;
; BAD TITLE: ILLEGAL FILENAME.
;
BADTITLE EQU 7
;
; NO ROOM: INSUFFICIENT SPACE ON THE SPECIFIED
; DISKETTE.
;
NOSPACE EQU 8
;
; NO DEVICE: THE SPECIFIED VOLUME IS NOT ON-LINE.
;
NOUNIT EQU 9
;
; NO FILE: THE SPECIFIED FILE IS NOT IN THE
; DIRECTORY OF THE SPECIFIED VOLUME.
;
NOFILE EQU 10
;
; DUPLICATE FILE: ATTEMPT TO RE-WRITE A FILE WHEN
; A FILE OF THAT NAME ALREADY EXISTS.
;
DUPFILE EQU 11
;
; NOT CLOSED: ATTEMPT TO OPEN AN ALREADY-OPEN
; FILE.
;
FILEOPEN EQU 12
;
; NOT OPEN: ATTEMPT TO ACCESS A CLOSED FILE.
;
NOTOPEN EQU 13
;
; BAD FORMAT: ERROR IN READING REAL OR INTEGER.
;
BADFORMT EQU 14
;
; RING BUFFER OVERFLOW: CHARACTERS ARE ARRIVING
; FASTER THAN THE INPUT BUFFER CAN ACCEPT THEM.
;
BUFOFLOW EQU 15
;
; WRITE-PROTECT ERROR: THE SPECIFIED DISKETTE IS
; WRITE-PROTECTED.
;
WRITEERR EQU 16
;
; DEVICE ERROR: FAILED TO COMPLETE A READ OR WRITE
; CORRECTLY (BAD ADDRESS OR DATA FIELD ON
; DISKETTE).
;
BADBLOCK EQU 64
;
;**************************************************
;*
;* ONE-WORD LOADS AND STORES
;*
;**************************************************
;
;******** CONSTANT ********
;
; LDCI W. LOAD ONE-WORD CONSTANT. PUSH W.
;
LDCI MOVE.B (A4)+,D1
 MOVE.B (A4)+,-(SP)
 MOVE.B D1,1(SP)
 JMP (A2)
;
;******** LOCAL ********
;
; SLDL 1 .. SLDL 16. SHORT LOAD LOCAL WORD. FOR AN
; INSTRUCTION SLDL X, FETCH THE WORD WITH OFFSET X
; IN MP ACTIVATION RECORD AND PUSH IT.
;
SLDL1 MOVE.W 1*2+MPOFF(A3),-(SP) 
 JMP (A2)
;
SLDL2 MOVE.W 2*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL3 MOVE.W 3*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL4 MOVE.W 4*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL5 MOVE.W 5*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL6 MOVE.W 6*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL7 MOVE.W 7*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL8 MOVE.W 8*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL9 MOVE.W 9*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL10 MOVE.W 10*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL11 MOVE.W 11*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL12 MOVE.W 12*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL13 MOVE.W 13*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL14 MOVE.W 14*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL15 MOVE.W 15*2+MPOFF(A3),-(SP)
 JMP (A2)
;
SLDL16 MOVE.W 16*2+MPOFF(A3),-(SP)
 JMP (A2)
;
; LDL B. LOAD LOCAL WORD. FETCH THE WORD WITH
; OFFSET B IN MP ACTIVATION RECORD AND PUSH IT.
;
LDL MOVE.B (A4)+,D0
 BMI LDL1
 ADD.W D0,D0
 MOVE.W MPOFF(A3,D0.W),-(SP)
 JMP (A2)
;
LDL1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W MPOFF(A3,D1.W),-(SP)
 JMP (A2)
;
; LLA B. LOAD LOCAL ADDRESS. FETCH ADDRESS OF THE
; WORD WITH OFFSET B IN MP ACTIVATION RECORD AND
; PUSH IT.
;
LLA MOVE.B (A4)+,D0
 BMI LLA1
 MOVE.W D0,D1
 ADDQ.W #MPOFF/2,D1
 ADD.W D1,D1
 ADD.W A3,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
LLA1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADDQ.W #MPOFF/2,D1
 ADD.W D1,D1
 ADD.W A3,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; STL B. STORE LOCAL WORD. STORE TOS INTO WORD WITH
; OFFSET B IN MP ACTIVATION RECORD.
;
STL MOVE.B (A4)+,D0
 BMI STL1
 ADD.W D0,D0
 MOVE.W (SP)+,MPOFF(A3,D0.W)
 JMP (A2)
;
STL1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W (SP)+,MPOFF(A3,D1.W)
 JMP (A2)
;
;******** GLOBAL ********
;
; SLDO 1 .. SLDO 16. SHORT LOAD GLOBAL WORD. FOR AN
; INSTRUCTION SLDO X, FETCH THE WORD WITH OFFSET X
; IN BASE ACTIVATION RECORD AND PUSH IT.
;
SLDO1 MOVE.W 1*2+MPOFF(A5),-(SP) 
 JMP (A2)
;
SLDO2 MOVE.W 2*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO3 MOVE.W 3*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO4 MOVE.W 4*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO5 MOVE.W 5*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO6 MOVE.W 6*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO7 MOVE.W 7*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO8 MOVE.W 8*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO9 MOVE.W 9*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO10 MOVE.W 10*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO11 MOVE.W 11*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO12 MOVE.W 12*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO13 MOVE.W 13*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO14 MOVE.W 14*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO15 MOVE.W 15*2+MPOFF(A5),-(SP)
 JMP (A2)
;
SLDO16 MOVE.W 16*2+MPOFF(A5),-(SP)
 JMP (A2)
;
; LDO B. LOAD GLOBAL WORD. FETCH THE WORD WITH
; OFFSET B IN BASE ACTIVATION RECORD AND PUSH IT.
;
LDO MOVE.B (A4)+,D0
 BMI LDO1
 ADD.W D0,D0
 MOVE.W MPOFF(A5,D0.W),-(SP)
 JMP (A2)
;
LDO1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W MPOFF(A5,D1.W),-(SP)
 JMP (A2)
;
; LAO B. LOAD GLOBAL ADDRESS. FETCH ADDRESS OF WORD
; WITH OFFSET B IN BASE ACTIVATION RECORD AND PUSH
; IT.
;
LAO MOVE.B (A4)+,D0
 BMI LAO1
 MOVE.W D0,D1
 ADDQ.W #MPOFF/2,D1
 ADD.W D1,D1
 ADD.W A5,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
LAO1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADDQ.W #MPOFF/2,D1
 ADD.W D1,D1
 ADD.W A5,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; SRO B. STORE GLOBAL WORD. STORE TOS INTO WORD
; WITH OFFSET B IN BASE ACTIVATION RECORD.
;
SRO MOVE.B (A4)+,D0
 BMI SRO1
 ADD.W D0,D0
 MOVE.W (SP)+,MPOFF(A5,D0.W)
 JMP (A2)
;
SRO1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W (SP)+,MPOFF(A5,D1.W)
 JMP (A2)
;
;******** INTERMEDIATE ********
;
; LOD DB, B. LOAD INTERMEDIATE WORD. FETCH WORD
; WITH OFFSET B IN THE ACTIVATION RECORD FOUND BY
; TRAVERSING DB STATIC LINKS, AND PUSH IT.
;
LOD MOVEA.L A3,A0
 MOVE.B (A4)+,D1
 BEQ LOD2
 EXT.W D1
 SUBQ.W #1,D1
;
LOD1 MOVEA.W (A0),A0
 DBF D1,LOD1
;
LOD2 MOVE.B (A4)+,D0
 BMI LOD3
 ADD.W D0,D0
 MOVE.W MPOFF(A0,D0.W),-(SP)
 JMP (A2)
;
LOD3 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W MPOFF(A0,D1.W),-(SP)
 JMP (A2)
;
; LDA DB, B. LOAD INTERMEDIATE ADDRESS. FETCH
; ADDRESS OF WORD WITH OFFSET B IN THE ACTIVATION
; RECORD FOUND BY TRAVERSING DB STATIC LINKS, AND
; PUSH IT.
;
LDA MOVEA.L A3,A0
 MOVE.B (A4)+,D1
 BEQ LDA2
 EXT.W D1
 SUBQ.W #1,D1
;
LDA1 MOVEA.W (A0),A0
 DBF D1,LDA1
;
LDA2 MOVE.B (A4)+,D0
 BMI LDA3
 MOVE.W D0,D1
 ADDQ.W #MPOFF/2,D1
 ADD.W D1,D1
 ADD.W A0,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
LDA3 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADDQ.W #MPOFF/2,D1
 ADD.W D1,D1
 ADD.W A0,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; STR DB, B. STORE INTERMEDIATE WORD. STORE TOS
; INTO THE WORD WITH OFFSET B IN ACTIVATION RECORD
; FOUND BY TRAVERSING DB STATIC LINKS.
;
STR MOVEA.L A3,A0
 MOVE.B (A4)+,D1
 BEQ STR2
 EXT.W D1
 SUBQ.W #1,D1
;
STR1 MOVEA.W (A0),A0
 DBF D1,STR1
;
STR2 MOVE.B (A4)+,D0
 BMI STR3
 ADD.W D0,D0
 MOVE.W (SP)+,MPOFF(A0,D0.W)
 JMP (A2)
;
STR3 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W (SP)+,MPOFF(A0,D1.W)
 JMP (A2)
;
;******** INDIRECT ********
;
; SIND 0. LOAD INDIRECT WORD. FETCH THE WORD
; POINTED TO BY TOS AND PUSH IT (THIS IS A SPECIAL
; CASE OF SIND X, DESCRIBED BELOW).
;
SIND0 MOVEA.W (SP),A0
 MOVE.W (A0),(SP)
 JMP (A2)
;
; SIND 1 .. 7. SHORT INDEX AND LOAD WORD. FOR AN
; INSTRUCTION SIND X, INDEX THE WORD POINTER TOS
; BY X WORDS, AND PUSH THE WORD POINTED TO BY THE
; RESULT.
;
SIND1 MOVEA.W (SP),A0
 MOVE.W 1*2(A0),(SP)
 JMP (A2)
;
SIND2 MOVEA.W (SP),A0
 MOVE.W 2*2(A0),(SP)
 JMP (A2)
;
SIND3 MOVEA.W (SP),A0
 MOVE.W 3*2(A0),(SP)
 JMP (A2)
;
SIND4 MOVEA.W (SP),A0
 MOVE.W 4*2(A0),(SP)
 JMP (A2)
;
SIND5 MOVEA.W (SP),A0
 MOVE.W 5*2(A0),(SP)
 JMP (A2)
;
SIND6 MOVEA.W (SP),A0
 MOVE.W 6*2(A0),(SP)
 JMP (A2)
;
SIND7 MOVEA.W (SP),A0
 MOVE.W 7*2(A0),(SP)
 JMP (A2)
;
; IND B. STATIC INDEX AND LOAD WORD. INDEX THE WORD
; POINTER TOS BY B WORDS, AND PUSH THE WORD POINTED
; TO BY THE RESULT.
;
IND MOVE.B (A4)+,D0
 BMI IND1
 ADD.W D0,D0
 MOVEA.W (SP)+,A0
 MOVE.W 0(A0,D0.W),-(SP)
 JMP (A2)
;
IND1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVEA.W (SP)+,A0
 MOVE.W 0(A0,D1.W),-(SP)
 JMP (A2)
;
; STO. STORE INDIRECT WORD. STORE TOS INTO THE WORD
; POINTED TO BY TOS-1.
;
STO MOVE.W (SP)+,D1
 MOVEA.W (SP)+,A0
 MOVE.W D1,(A0)
 JMP (A2)
;
;******** EXTENDED ********
;
; LDE UB, B. LOAD EXTENDED WORD. FETCH THE WORD
; WITH OFFSET B IN DATA SEGMENT UB (FROM AN
; INTRINSIC UNIT) AND PUSH IT.
;
LDE MOVE.B (A4)+,D0
 ADD.W D0,D0
 MOVEA.W @PROCDIC(PC,D0.W),A0
 MOVE.B (A4)+,D0
 BMI LDE1
 ADD.W D0,D0
 MOVE.W 0(A0,D0.W),-(SP)
 JMP (A2)
;
LDE1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W 0(A0,D1.W),-(SP)
 JMP (A2)
;
; LAE UB, B. LOAD EXTENDED ADDRESS. FETCH ADDRESS
; OF THE WORD WITH OFFSET B IN DATA SEGMENT UB
; (FROM AN INTRINSIC UNIT), AND PUSH IT.
;
LAE MOVE.B (A4)+,D0
 ADD.W D0,D0
 MOVE.W @PROCDIC(PC,D0.W),D2
 MOVE.B (A4)+,D0
 BMI LAE1
 ADD.W D0,D0
 ADD.W D0,D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
LAE1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 ADD.W D1,D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
; STE UB, B. STORE EXTENDED WORD. STORE TOS INTO
; THE WORD WITH OFFSET B IN DATA SEGMENT UB (FROM
; AN INTRINSIC UNIT).
;
STE MOVE.B (A4)+,D0
 ADD.W D0,D0
 MOVEA.W @PROCDIC(PC,D0.W),A0
 MOVE.B (A4)+,D0
 BMI STE1
 ADD.W D0,D0
 MOVE.W (SP)+,0(A0,D0.W)
 JMP (A2)
;
STE1 MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 MOVE.W (SP)+,0(A0,D1.W)
 JMP (A2)
;
; SEGMENT PROCEDURE DICTIONARY TABLE
;
PROCDIC DS.W 64
;
 CHAIN SYSTEM.68000.B,D2
