;**************************************************
;*
;* MULTIPLE-WORD LOADS AND STORES (REALS AND SETS)
;*
;**************************************************
;
; LDC UB, <BLOCK>. LOAD MULTIPLE-WORD CONSTANT.
; FETCH WORD-ALIGNED <BLOCK> OF UB WORDS IN REVERSE
; WORD ORDER, AND PUSH THE BLOCK.
;
LDC CLR.W D1
 MOVE.B (A4)+,D1
 MOVE.W A4,D2
 ADDQ.W #1,D2
 ANDI.W #$FFFE,D2
 MOVEA.W D2,A4
 SUBQ.W #1,D1
;
LDC1 MOVE.B (A4)+,D2
 MOVE.B (A4)+,-(SP)
 MOVE.B D2,1(SP)
 DBF D1,LDC1
;
 JMP (A2)
;
LOADC CLR.W D1
 MOVE.B (A4)+,D1
 MOVE.W A4,D2
 ADDQ.W #1,D2
 ANDI.W #$FFFE,D2
 MOVEA.W D2,A4
 SUBQ.W #1,D1
;
LOADC1 MOVE.W (A4)+,-(SP)
 DBF D1,LOADC1
;
 JMP (A2)
;
; LDM UB. LOAD MULTIPLE WORDS. FETCH A BLOCK OF UB
; WORDS, WHOSE BEGINNING IS POINTED TO BY TOS, AND
; PUSH THE BLOCK.
;
LDM MOVE.B (A4)+,D0
 MOVEA.W (SP)+,A0
 MOVE.W SP,D1
 SUB.W D0,D1
 SUB.W D0,D1
 CMPI.W #SPMAX+SPOFF+1,D1
 BLS LDM2
 MOVEA.W D1,SP
 MOVEA.W D1,A1
 MOVE.W D0,D1
 SUBQ.W #1,D1
;
LDM1 MOVE.W (A0)+,(A1)+
 DBF D1,LDM1
;
 JMP (A2)
;
LDM2 SUBQ.W #2,A4
 SUBQ.W #2,SP
 BRA XSTKOVR
;
; STM UB. STORE MULTIPLE WORDS. TOS IS A BLOCK OF
; UB WORDS, TOS-1 IS A WORD POINTER TO A SIMILAR
; BLOCK. TRANSFER THE BLOCK FROM TOS TO THE
; DESTINATION BLOCK POINTED AT BY TOS-1.
;
STM MOVE.B (A4)+,D0
 BEQ STM2
 MOVE.W D0,D1
 ADD.W D0,D0
 MOVEA.W 0(SP,D0.W),A0
 SUBQ.W #1,D1
;
STM1 MOVE.W (SP)+,(A0)+
 DBF D1,STM1
;
STM2 ADDQ.W #2,SP
 JMP (A2)
;
;**************************************************
;*
;* BYTE ARRAY HANDLING
;*
;**************************************************
;
; LDB. LOAD BYTE. INDEX THE BYTE POINTER TOS-1 BY
; THE INTEGER INDEX TOS, AND PUSH THE BYTE (AFTER
; ZEROING HIGH BYTE) POINTED TO BY THE RESULTING
; BYTE POINTER
;
LDB MOVEA.W (SP)+,A0
 ADDA.W (SP)+,A0
 MOVE.B (A0),D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; STB. STORE BYTE. INDEX THE BYTE POINTER TOS-2 BY
; THE INTEGER INDEX TOS-1, AND PUSH THE BYTE TOS
; INTO THE LOCATION POINTED TO BY THE RESULTING
; BYTE POINTER.
;
STB MOVE.W (SP)+,D1
 MOVEA.W (SP)+,A0
 ADDA.W (SP)+,A0
 MOVE.B D1,(A0)
 JMP (A2)
;
;**************************************************
;*
;* STRING HANDLING
;*
;**************************************************
;
; LSA UB, <CHARS>. LOAD CONSTANT STRING ADDRESS.
; PUSH A BYTE POINTER TO THE LOCATION CONTAINING
; UB, AND THEN SKIP IPC PAST <CHARS>.
;
LSA MOVE.W A4,-(SP)
 MOVE.B (A4)+,D0
 ADDA.W D0,A4
 JMP (A2)
;
; SAS UB. STRING ASSIGN. TOS IS EITHER A SOURCE
; BYTE POINTER OR A CHARACTER. (CHARACTERS ALWAYS
; HAVE A HIGH BYTE OF ZERO, WHILE POINTERS NEVER
; DO.) TOS-1 IS A DESTINATION BYTE POINTER. UB IS
; THE DECLARED SIZE OF THE DESTINATION STRING. IF
; THE DECLARED SIZE IS LESS THAN THE CURRENT SIZE
; OF THE SOURCE STRING, GIVE AN EXECUTION ERROR;
; OTHERWISE TRANSFER ALL BYTES OF SOURCE CONTAINING
; VALID INFORMATION TO THE DESTINATION STRING.
;
SAS MOVEA.W (SP)+,A0
 MOVEA.W (SP)+,A1
 CMPA.W #$00FF,A0
 BLS SAS5
 MOVE.B (A0),D0
 CMP.B (A4)+,D0
 BHI SAS6
 ADDQ.W #1,D0
 MOVE.W D0,D1
 LSR.W #2,D1
 BEQ SAS2
 SUBQ.W #1,D1
;
SAS1 MOVE.L (A0)+,(A1)+
 DBF D1,SAS1
;
 ANDI.W #3,D0
SAS2 MOVE.W D0,D1
 BEQ SAS4
 SUBQ.W #1,D1
;
SAS3 MOVE.B (A0)+,(A1)+
 DBF D1,SAS3
;
SAS4 JMP (A2)
;
SAS5 TST.B (A4)+
 BEQ SAS6
 MOVE.W A0,D1
 ORI.W #$0100,D1
 MOVE.W D1,(A1)
 JMP (A2)
;
SAS6 SUBQ.W #2,A4
 SUBQ.W #4,SP
 BRA XS2LONG
;
; IXS. INDEX STRING ARRAY. TOS IS AN INTEGER INDEX,
; TOS-1 IS A STRING BASE WORD POINTER. INSURE THAT
; TOS IS IN THE RANGE 1 .. CURRENTLENGTH OF THE
; STRING POINTED AT BY TOS-1. IF NOT, GIVE AN
; EXECUTION ERROR. THIS INSTRUCTION IS NOT
; GENERATED IF THE R- COMPILER OPTION IS USED.
;
IXS MOVE.W (SP),D1
 BEQ IXS1
 MOVEA.W 2(SP),A0
 MOVE.B (A0),D0
 CMP.W D0,D1
 BHI IXS1
 JMP (A2)
;
IXS1 SUBQ.W #1,A4
 BRA XINVNDX
;
;**************************************************
;*
;* RECORD AND ARRAY HANDLING
;*
;**************************************************
;
; MOV B. MOVE WORDS. TRANSFER A SOURCE BLOCK OF B
; WORDS, POINTED TO BY BYTE POINTER TOS, TO A
; SIMILAR DESTINATION BLOCK POINTED TO BY BYTE
; POINTER TOS-1.
;
MOV MOVEA.W (SP)+,A0
 MOVEA.W (SP)+,A1
 MOVE.B (A4)+,D0
 BPL MOV1
 ADD.B D0,D0
 ASL.W #7,D0
 MOVE.B (A4)+,D0
MOV1 MOVE.W D0,D1
 LSR.W #1,D1
 BEQ MOV3
 SUBQ.W #1,D1
;
MOV2 MOVE.L (A0)+,(A1)+
 DBF D1,MOV2
;
MOV3 ANDI.W #1,D0
 BEQ MOV4
 MOVE.W (A0)+,(A1)+
MOV4 JMP (A2)
;
; INC B. INCREMENT FIELD POINTER. INDEX THE WORD
; POINTER TOS BY B WORDS AND PUSH THE RESULTANT
; WORD POINTER.
;
INC MOVE.B (A4)+,D0
 BMI INCBIG
 ADD.W D0,D0
 ADD.W D0,(SP)
 JMP (A2)
;
INCBIG MOVE.B D0,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
 ADD.W D1,D1
 ADD.W D1,(SP)
 JMP (A2)
;
; IXA B. INDEX ARRAY. TOS IS AN INTEGER INDEX,
; TOS-1 IS THE ARRAY BASE WORD POINTER, AND B IS
; THE SIZE (IN WORDS) OF AN ARRAY ELEMENT. COMPUTE
; A WORD POINTER TO THE INDEXED ELEMENT AND PUSH
; THE POINTER.
;
IXA MOVE.B (A4)+,D0
 SUBQ.B #1,D0
 BNE IXA1
 MOVE.W (SP)+,D1
 ADD.W D1,D1
 ADD.W D1,(SP)
 JMP (A2)
;
IXA1 ADDQ.B #1,D0
 CLR.W D1
 MOVE.B D0,D1
 BPL IXA2
 MOVE.B D1,-(SP)
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D1
IXA2 ADD.W D1,D1
 MULU (SP)+,D1
 ADD.W D1,(SP)
 JMP (A2)
;
; IXP UB1, UB2. INDEX PACKED ARRAY. TOS IS AN
; INTEGER INDEX, TOS-1 IS THE ARRAY BASE WORD
; POINTER. UB1 IS THE NUMBER OF ELEMENTS PER WORD,
; AND UB2 IS THE FIELD WIDTH (IN BITS). COMPUTE A
; PACKED FIELD POINTER TO THE INDEXED FIELD AND
; PUSH THE RESULTING POINTER.
;
IXP MOVEQ #0,D1
 MOVE.W (SP)+,D1
 MOVE.B (A4)+,D0
 BEQ IXP1
 DIVU D0,D1
 ADD.W D1,D1
 ADD.W D1,(SP)
 MOVE.B (A4)+,D0
 MOVE.W D0,-(SP)
 SWAP D1
 MULU D0,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
IXP1 SUBQ.W #2,A4
 SUBQ.W #2,SP
 BRA XDIVZER
;
; LPA UB, <CHARS>. LOAD A PACKED ARRAY. PUSH A BYTE
; POINTER TO THE FIRST LOCATION FOLLOWING THE ONE
; THAT CONTAINS UB, AND THEN SKIP IPC PAST <CHARS>.
;
LPA MOVE.B (A4)+,D0
 MOVE.W A4,-(SP)
 ADDA.W D0,A4
 JMP (A2)
;
; LDP. LOAD A PACKED FIELD. FETCH THE FIELD
; INDICATED BY THE PACKED FIELD POINTER TOS, AND
; PUSH IT.
;
LDP MOVEM.W (SP)+,D0-D1/A0
 MOVE.W (A0),D2
 ASR.W D0,D2
 ADD.B D1,D1
 AND.W @MASK(PC,D1.W),D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
; STP. STORE INTO A PACKED FIELD. STORE THE DATA
; TOS INTO THE FIELD INDICATED BY THE PACKED FIELD
; POINTER TOS-1.
;
STP MOVEM.W (SP)+,D1-D3/A0
 ADD.B D3,D3
 MOVE.W @MASK(PC,D3.W),D3
 AND.W D3,D1
 ASL.W D2,D1
 ASL.W D2,D3
 NOT.W D3
 AND.W (A0),D3
 OR.W D1,D3
 MOVE.W D3,(A0)
 JMP (A2)
;
; TABLE OF MASKS FOR PACKED FIELD MANIPULATIONS
;
MASK DC.W %0000000000000000
 DC.W %0000000000000001
 DC.W %0000000000000011
 DC.W %0000000000000111
 DC.W %0000000000001111
 DC.W %0000000000011111
 DC.W %0000000000111111
 DC.W %0000000001111111
 DC.W %0000000011111111
 DC.W %0000000111111111
 DC.W %0000001111111111
 DC.W %0000011111111111
 DC.W %0000111111111111
 DC.W %0001111111111111
 DC.W %0011111111111111
 DC.W %0111111111111111
 DC.W %1111111111111111
;
;**************************************************
;*
;* DYNAMIC VARIABLE ALLOCATION
;*
;**************************************************
;
; NEW. NEW VARIABLE ALLOCATION. TOS IS THE SIZE (IN
; WORDS) TO ALLOCATE THE VARIABLE, AND TOS-1 IS A
; WORD POINTER TO A DYNAMIC VARIABLE. GDIRP IS A
; POINTER TO A TEMPORARY DIRECTORY BUFFER PLACED IN
; MEMORY DIRECTLY ABOVE THE HEAP. IF GDIRP IS NON-
; NIL, SET GDIRP TO NIL. STORE NP INTO THE WORD
; POINTED TO BY TOS-1, AND INCREMENT NP BY TOS
; WORDS.
;
NEW MOVE.W GDIRP,D1
 BEQ NEW1
 MOVE.W D1,D7
 MOVE.W #NIL,GDIRP
NEW1 MOVE.W (SP)+,D1
 MOVEA.W (SP)+,A0
 MOVE.W D7,(A0)
 ADD.W D1,D7
 ADD.W D1,D7
 CMP.W A6,D7
 BCC NEW2
 JMP (A2)
;
NEW2 SUBQ.W #2,A4
 SUBQ.W #4,SP
 BRA XSTKOVR
;
; MRK. MARK HEAP. SET GDIRP TO NIL IF NECESSARY;
; THEN STORE NP INTO THE WORD INDICATED BY WORD
; POINTER TOS.
;
MRK MOVE.W GDIRP,D1
 BEQ MRK1
 MOVE.W D1,D7
 MOVE.W #NIL,GDIRP
MRK1 MOVEA.W (SP)+,A0
 MOVE.W D7,(A0)
 JMP (A2)
;
; RLS. RELEASE HEAP. STORE THE WORD INDICATED BY
; THE WORD POINTER TOS INTO NP, THEN SET GDIRP TO
; NIL.
;
RLS MOVEA.W (SP)+,A0
 MOVE.W (A0),D7
 MOVE.W #NIL,GDIRP
 JMP (A2)
;
;**************************************************
;*
;* TOP-OF-STACK ARITHMETIC
;*
;**************************************************
;
;******** INTEGERS ********
;
; NOTE: OVERFLOWS DO NOT CAUSE AN EXECUTION ERROR.
;
; ABI. ABSOLUTE VALUE OF INTEGER. PUSH THE ABSOLUTE
; VALUE OF INTEGER TOS. RESULT IS UNDEFINED IF TOS
; IS INITIALLY -32768.
;
ABI TST.W (SP)
 BPL NGI1
;
; NGI. NEGATE INTEGER. PUSH THE TWO'S COMPLEMENT
; OF TOS.
;
NGI NEG.W (SP)
NGI1 JMP (A2)
;
; ADI. ADD INTEGERS. ADD TOS AND TOS-1, AND PUSH
; THE RESULTING SUM.
;
ADI MOVE.W (SP)+,D1
 ADD.W D1,(SP)
 JMP (A2)
;
; SBI. SUBTRACT INTEGERS. SUBTRACT TOS FROM TOS-1,
; AND PUSH THE RESULTING DIFFERENCE.
;
SBI MOVE.W (SP)+,D1
 SUB.W D1,(SP)
 JMP (A2)
;
; MPI. MULTIPLY INTEGERS. MULTIPLY TOS AND TOS-1,
; AND PUSH THE RESULTING PRODUCT. THIS INSTRUCTION
; MAY CAUSE AN OVERFLOW IF THE RESULT IS LARGER
; THAN 16 BITS.
;
MPI MOVE.W (SP)+,D1
 MULS (SP)+,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; SQI. SQUARE INTEGER. SQUARE TOS, AND PUSH THE
; RESULT. MAY CAUSE OVERFLOW IF RESULT IS LARGER
; THAN 16 BITS.
;
SQI MOVE.W (SP)+,D1
 MULS D1,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; DVI. DIVIDE INTEGERS. DIVIDE TOS-1 BY TOS AND
; PUSH THE RESULTING INTEGER QUOTIENT (ANY
; REMAINDER IS DISCARDED).
;
DVI MOVE.W (SP)+,D1
 BEQ DVI1
 MOVE.W (SP)+,D2
 EXT.L D2
 DIVS D1,D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
DVI1 SUBQ.W #1,A4
 SUBQ.W #2,SP
 BRA XDIVZER
;
; MODI. MODULO INTEGERS. DIVIDE TOS-1 BY TOS AND
; PUSH THE RESULTING REMAINDER (AS DEFINED IN
; JENSEN AND WIRTH).
;
MODI MOVE.W (SP)+,D1
 BEQ DVI1
 MOVE.W (SP)+,D2
 EXT.L D2
 DIVS D1,D2
 SWAP D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
; CHK. CHECK AGAINST SUBRANGE BOUNDS. INSURE THAT
; TOS-1 <= TOS-2 <= TOS, LEAVING TOS-2 ON THE
; STACK. IF CONDITIONS ARE NOT SATISFIED, GIVE AN
; EXECUTION ERROR.
;
CHK MOVE.W (SP)+,D1
 MOVE.W (SP)+,D2
 CMP.W (SP),D2
 BGT CHK1
 CMP.W (SP),D1
 BLT CHK1
 JMP (A2)
;
CHK1 SUBQ.W #1,A4
 SUBQ.W #4,SP
 BRA XINVNDX
;
; INTEGER COMPARISONS. COMPARE TOS-1 TO TOS AND
; PUSH THE RESULT, TRUE OR FALSE.
;
; EQUI. TOS-1 = TOS.
;
EQUI CMPM.W (SP)+,(SP)+
 SNE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; NEQI. TOS-1 <> TOS.
;
NEQI CMPM.W (SP)+,(SP)+
 SEQ D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LEQI. TOS-1 <= TOS.
;
LEQI CMPM.W (SP)+,(SP)+
 SGT D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LESI. TOS-1 < TOS.
;
LESI CMPM.W (SP)+,(SP)+
 SGE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GEQI. TOS-1 >= TOS.
;
GEQI CMPM.W (SP)+,(SP)+
 SLT D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GRTI. TOS-1 > TOS.
;
GRTI CMPM.W (SP)+,(SP)+
 SLE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
;******** NON-INTEGER COMPARISONS ********
;
; COMPARE TOS-1 TO TOS, AND PUSH THE RESULT, TRUE
; OR FALSE. THE TYPE OF COMPARISON IS SPECIFIED BY
; UB:
;
;    CONTENTS OF        VALUE OF UB
;    TOS-1 & TOS        FOR COMPARISON
;
;    DOUBLES                    0
;    REALS                      2
;    STRINGS                    4
;    BOOLEANS                   6
;    SETS                       8
;    BYTE ARRAYS               10
;    WORDS                     12
;
; COMPARISONS USING SPECIFIC VALUES OF UB ARE
; SHOWN IN THE FOLLOWING INSTRUCTION DSCRIPTIONS.
;
NOTIMP SUBQ.W #2,A4
 BRA XNOTIMP
;
; EQU UB. TOS-1 = TOS.
;
EQU MOVE.B (A4)+,D0
 MOVEA.W @EQUTYPE(PC,D0.W),A0
EQU1 JMP 0(PC,A0.W)
;
EQUTYPE DC.W EQUDBLE-EQU1
 DC.W EQUREAL-EQU1
 DC.W EQUSTR-EQU1
 DC.W EQUBOOL-EQU1
 DC.W EQUPOWR-EQU1
 DC.W EQUBYT-EQU1
 DC.W EQUWORD-EQU1
;
; NEQ UB. TOS-1 <> TOS.
;
NEQ MOVE.B (A4)+,D0
 MOVEA.W @NEQTYPE(PC,D0.W),A0
NEQ1 JMP 0(PC,A0.W)
;
NEQTYPE DC.W NEQDBLE-NEQ1
 DC.W NEQREAL-NEQ1
 DC.W NEQSTR-NEQ1
 DC.W NEQBOOL-NEQ1
 DC.W NEQPOWR-NEQ1
 DC.W NEQBYT-NEQ1
 DC.W NEQWORD-NEQ1
;
; LEQ UB. TOS-1 <= TOS.
;
LEQ MOVE.B (A4)+,D0
 MOVEA.W @LEQTYPE(PC,D0.W),A0
LEQ1 JMP 0(PC,A0.W)
;
LEQTYPE DC.W LEQDBLE-LEQ1
 DC.W LEQREAL-LEQ1
 DC.W LEQSTR-LEQ1
 DC.W LEQBOOL-LEQ1
 DC.W LEQPOWR-LEQ1
 DC.W LEQBYT-LEQ1
;
; LES UB. TOS-1 < TOS.
;
LES MOVE.B (A4)+,D0
 MOVEA.W @LESTYPE(PC,D0.W),A0
LES1 JMP 0(PC,A0.W)
;
LESTYPE DC.W LESDBLE-LES1
 DC.W LESREAL-LES1
 DC.W LESSTR-LES1
 DC.W LESBOOL-LES1
 DC.W NOTIMP-LES1
 DC.W LESBYT-LES1
;
; GEQ UB. TOS-1 >= TOS.
;
GEQ MOVE.B (A4)+,D0
 MOVEA.W @GEQTYPE(PC,D0.W),A0
GEQ1 JMP 0(PC,A0.W)
;
GEQTYPE DC.W GEQDBLE-GEQ1
 DC.W GEQREAL-GEQ1
 DC.W GEQSTR-GEQ1
 DC.W GEQBOOL-GEQ1
 DC.W GEQPOWR-GEQ1
 DC.W GEQBYT-GEQ1
;
; GRT UB. TOS-1 > TOS.
;
GRT MOVE.B (A4)+,D0
 MOVEA.W @GRTTYPE(PC,D0.W),A0
GRT1 JMP 0(PC,A0.W)
;
GRTTYPE DC.W GRTDBLE-GRT1
 DC.W GRTREAL-GRT1
 DC.W GRTSTR-GRT1
 DC.W GRTBOOL-GRT1
 DC.W NOTIMP-GRT1
 DC.W GRTBYT-GRT1
;
;******** REALS ********
;
; NOTE: ALL OVERFLOWS CAUSE AN EXECUTION ERROR, BUT
;       UNDERFLOW IS TREATED AS A ZERO RESULT, NOT
;       AS AN ERROR.
;
; FLT. FLOAT TOP-OF-STACK. CONVERT THE INTEGER TOS
; TO A FLOATING POINT NUMBER, AND PUSH THE RESULT.
;
FLT MOVE.W #$4700,D1
 MOVEQ #0,D2
 MOVE.W (SP)+,D2
 BGT FLT1
 BEQ FLTZERO
 MOVE.W #$C700,D1
 NEG.W D2
 BMI FLTMIN
FLT1 MOVE.W #$80,D0
;
FLT2 SUB.W D0,D1
 ADD.W D2,D2
 BPL FLT2
;
 ANDI.W #$7FFF,D2
 ASL.L #8,D2
 SWAP D2
 OR.W D1,D2
FLTZERO MOVE.L D2,-(SP)
 JMP (A2)
;
FLTMIN MOVE.L #$0000C700,-(SP)
 JMP (A2)
;
; FLO. FLOAT NEXT TO TOP-OF-STACK. TOS IS A REAL,
; TOS-1 IS AN INTEGER. CONVERT TOS-1 TO A REAL
; NUMBER, PUSH THIS NUMBER, THEN PUSH THE
; UNCHANGED TOS.
;
FLO MOVE.L (SP)+,D3
 MOVE.W #$4700,D1
 MOVEQ #0,D2
 MOVE.W (SP)+,D2
 BGT FLO1
 BEQ FLOZERO
 MOVE.W #$C700,D1
 NEG.W D2
 BMI FLOMIN
FLO1 MOVE.W #$80,D0
;
FLO2 SUB.W D0,D1
 ADD.W D2,D2
 BPL FLO2
;
 ANDI.W #$7FFF,D2
 ASL.L #8,D2
 SWAP D2
 OR.W D1,D2
FLOZERO MOVE.L D2,-(SP)
 MOVE.L D3,-(SP)
 JMP (A2)
;
FLOMIN MOVE.L #$0000C700,-(SP)
 MOVE.L D3,-(SP)
 JMP (A2)
;
; TNC. TRUNCATE REAL. TRUNCATE (AS DEFINED IN
; JENSEN AND WIRTH) THE REAL TOS AND CONVERT TO AN
; INTEGER, AND THEN PUSH THE RESULT.
;
TNC MOVE.L (SP)+,D1
 MOVE.L D1,D2
 ADD.W D1,D1
 CLR.B D1
 MOVE.W #$8E00,D3
 SUB.W D1,D3
 BLS TNC2
 CMPI.W #$F00,D3
 BHI TNCRND0
 LSR.W #8,D3
 SWAP D2
 ASR.L #8,D2
 ORI.W #$8000,D2
 LSR.W D3,D2
 TST.L D2
 BPL TNC1
 NEG.W D2
TNC1 MOVE.W D2,-(SP)
 JMP (A2)
;
TNC2 SWAP D2
 BPL TNCRNDER
 CMPI.L #$C70000FF,D2
 BHI TNCRNDER
 MOVE.W #-32768,-(SP)
 JMP (A2)
;
TNCRND0 MOVE.W #0,-(SP)
 JMP (A2)
;
TNCRNDER SUBQ.W #2,A4
 SUBQ.W #4,SP
 BRA XFPIERR
;
; RND. ROUND REAL. ROUND (AS DEFINED IN JENSEN AND
; WIRTH) THE REAL TOS, THEN TRUNCATE AND CONVERT TO
; AN INTEGER, AND FINALLY PUSH THE RESULT.
;
RND MOVE.L (SP)+,D1
 MOVE.L D1,D2
 MOVE.L D1,D4
 ADD.W D1,D1
 CLR.B D1
 MOVE.W #$8E00,D3
 SUB.W D1,D3
 BLS RND3
 CMPI.W #$1000,D3
 BHI TNCRND0
 LSR.W #8,D3
 SWAP D2
 ASR.L #8,D2
 ORI.W #$8000,D2
 LSR.W D3,D2
 BCC RND1
 ADDQ.W #1,D2
 BVS RND3
RND1 TST.L D2
 BPL RND2
 NEG.W D2
RND2 MOVE.W D2,-(SP)
 JMP (A2)
;
RND3 SWAP D4
 BPL TNCRNDER
 CMPI.L #$C700007F,D4
 BHI TNCRNDER
 MOVE.W #-32768,-(SP)
 JMP (A2)
;
; ABR. ABSOLUTE VALUE OF REAL. PUSH THE ABSOLUTE
; VALUE OF THE REAL TOS.
;
ABR BCLR #7,2(SP)
 JMP (A2)
;
; SBR. SUBTRACT REALS. SUBTRACT TOS FROM TOS-1, AND
; PUSH THE RESULTING REMAINDER.
;
SBR TST.W 2(SP)
 BEQ ADR
 BCHG #7,2(SP)
;
; ADR. ADD REALS. ADD TOS AND TOS-1, AND PUSH THE
; RESULTING SUM.
;
ADR MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 MOVEM.W D5-D7,-(SP)
 MOVEQ #$80,D7
 MOVE.W D2,D4
 AND.B D7,D4
 ADD.W D4,D4
 BEQ ADRONE
 MOVE.W D1,D3
 AND.B D7,D3
 ADD.W D3,D3
 BEQ ADRTWO
 OR.B D7,D1
 OR.B D7,D2
 SWAP D1
 SMI D5
 SWAP D2
 SMI D6
 ASL.L #8,D1
 ASL.L #8,D2
 CMP.W D4,D3
 BHI ADR1GE2
 BNE ADRSWAP
 CMP.L D2,D1
 BCC ADR1GE2
;
; SWAP THE FPACCS
;
ADRSWAP EXG D5,D6
 EXG D3,D4
 EXG D1,D2
;
; FPACC1 IS >= FPACC2; NOW ALIGN MANTISSAS.
;
ADR1GE2 MOVE.W D3,D7
 SUB.W D4,D7
 CMPI.W #$1800,D7
 BHI ADREXIT
 LSR.W #8,D7
 LSR.L D7,D2
 EOR.B D5,D6
 BMI SUBTRACT
 MOVE.B D2,D1
 ADD.L D2,D1
 BCC ADREXIT
 ROXR.L #1,D1
 ADDI.W #$100,D3
 BCC ADREXIT
 MOVEM.W (SP)+,D5-D7
 SUBQ.W #1,A4
 BRA XFPIERR
;
ADRONE MOVEM.W (SP)+,D5-D7
 MOVE.L D1,-(SP)
 JMP (A2)
;
ADRTWO MOVEM.W (SP)+,D5-D7
 MOVE.L D2,-(SP)
 JMP (A2)
;
SBRZERO MOVEM.W (SP)+,D5-D7
 MOVEQ #0,D0
 MOVE.L D0,-(SP)
 JMP (A2)
;
; SUBTRACT MANT2 FROM MANT1.
;
SUBTRACT SUB.L D2,D1
 BEQ SBRZERO
 BMI SBRROUND
 MOVE.W #$100,D7
;
; NORMALIZE MANT1 (IN D1) AND EXP1 (IN D3)
;
SBRNORM SUB.W D7,D3
 BEQ SBRZERO
 ADD.L D1,D1
 BPL SBRNORM
;
SBRROUND TST.B D1
 BEQ ADREXIT
 ADDI.L #$100,D1
 BCC ADREXIT
 ROXR.L #1,D1
 ADDI.W #$100,D3
ADREXIT LSR.L #8,D1
 SWAP D1
 ANDI.W #$7F,D1
 LSR.W #1,D3
 OR.W D3,D1
 TST.B D5
 BPL ADREXIT1
 ORI.W #$8000,D1
ADREXIT1 MOVEM.W (SP)+,D5-D7
 MOVE.L D1,-(SP)
 JMP (A2)
;
; NGR. NEGATE REAL. NEGATE THE REAL TOS, AND PUSH
; THE RESULT.
;
NGR TST.W 2(SP)
 BEQ NGREXIT
 BCHG #7,2(SP)
NGREXIT JMP (A2)
;
; SQR. SQUARE REALS. SQUARE TOS, AND PUSH THE
; RESULT.
;
SQR MOVE.L (SP),-(SP)
;
; MPR. MULTIPLY REALS. MULTIPLY TOS AND TOS-1, AND
; PUSH THE RESULTING PRODUCT.
;
MPR MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 MOVEM.W D5-D7,-(SP)
;
; CALCULATE THE EXPONENT OF THE RESULT.
;
 MOVE.W D1,D6
 MOVE.W D2,D7
 MOVEQ #$80,D3
 AND.B D3,D6
 AND.B D3,D7
 ADD.W D6,D6
 BEQ MPRZERO
 ADD.W D7,D7
 BEQ MPRZERO
 ADD.W D6,D7
 BCC MPRUNDFL
 CMPI.W #$7E00,D7
 BHI MPROVFL
 BRA MPR1
;
MPRZERO MOVEM.W (SP)+,D5-D7
 MOVEQ #0,D0
 MOVE.L D0,-(SP)
 JMP (A2)
;
MPROVFL MOVEM.W (SP)+,D5-D7
 SUBQ.W #1,A4
 BRA XFPIERR
;
MPRUNDFL BPL MPRZERO
MPR1 SUBI.W #$7F00,D7
;
; CALCULATE THE SIGN OF THE RESULT.
;
 OR.B D3,D1
 OR.B D3,D2
 SWAP D1
 SMI D0
 SWAP D2
 SMI D4
 EOR.B D4,D0
;
; THE FOLLOWING CODE MULTIPLIES 24 * 24 BITS
;
 MOVE.W D1,D3
 MOVE.W D1,D5
 SWAP D1
 CLR.W D4
 MOVE.B D1,D4
 MOVE.W D4,D6
 MULU D2,D3
 MULU D2,D4
 SWAP D2
 ANDI.W #$FF,D2
 MULU D2,D5
 MULU D2,D6
;
; MULTIPLICATION IS COMPLETE. NOW ALIGN AND ADD
; THE PARTIAL PRODUCTS.
;
; D3 =           HHHH HHHH
; D4 =      00HH HHHH
; D5 =      00HH HHHH
; D6 = 0000 HHHH
;      -------------------
; PRODUCT = MMMM MM (24 BIT MANTISSA)
;
 CLR.W D3
 SWAP D3
 ADD.L D4,D3
 ADD.L D5,D3
 SWAP D6
 ADD.L D6,D3
 BPL MPR2
 ADDI.W #$100,D7
 BCS MPROVFL
 BRA MPR3
;
; ROUND THE RESULT.
;
MPR2 ADD.L D3,D3
MPR3 TST.B D3
 BPL MPR4
 ADDI.L #$100,D3
 BCC MPR4
 ADDI.W #$100,D7
 BCS MPROVFL
MPR4 LSR.L #8,D3
 SWAP D3
 ANDI.W #$7F,D3
 LSR.W #1,D7
 OR.W D7,D3
 TST.B D0
 BPL MPREXIT
 ORI.W #$8000,D3
MPREXIT MOVEM.W (SP)+,D5-D7
 MOVE.L D3,-(SP)
 JMP (A2)
;
; DVR. DIVIDE REALS. DIVIDE TOS-1 BY TOS, AND PUSH
; THE RESULTING QUOTIENT.
;
DVROVFL MOVEM.W (SP)+,D0/D5-D7
 SUBQ.W #1,A4
 BRA XFPIERR
;
DVRBY0 MOVEM.W (SP)+,D0/D5-D7
 SUBQ.W #1,A4
 BRA XDIVZER
;
DVRZERO MOVEM.W (SP)+,D0/D5-D7
 MOVEQ #0,D0
 MOVE.L D0,-(SP)
 JMP (A2)
;
DVR MOVE.L (SP)+,D3
 MOVE.L (SP)+,D4
 MOVEM.W D0/D5-D7,-(SP)
 MOVE.L D3,D0
 MOVE.L D4,D7
 ADD.W D3,D3
 LSR.W #8,D3
 BEQ DVRBY0
 ADD.W D4,D4
 LSR.W #8,D4
 BEQ DVRZERO
;
; CALCULATE THE EXPONENT OF THE RESULT.
;
 SUB.W D3,D4
 ADDI.W #$7F,D4
;
; (DO NOT TEST FOR OV/UNDFLOW NOW.)
;
; CALCULATE THE SIGN OF THE RESULT.
;
 TAS D0
 TAS D7
 SWAP D4
 CLR.W D4
 SWAP D0
 SMI D3
 SWAP D7
 SMI D4
 EOR.B D3,D4
;
; PERFORM 32 BIT INTEGER DIVISION.
;
 ASL.L #8,D0
 ASL.L #8,D7
 CMP.L D0,D7
 BCS DENGTNUM
 ORI.W #$8000,D4
 SUB.L D0,D7
;
; DENOMINATOR > NUMERATOR.
;
DENGTNUM MOVE.L D7,D6
 BSR DVRSUB
 SWAP D3
 MOVE.L D6,D7
 BSR DVRSUB
;
; THE INTEGER DIVISION IS DONE; NOW NORMALIZE.
;
 TST.W D4
 BMI DVRNORM
 SWAP D4
 SUBQ.W #1,D4
 BRA DVRTEST
;
DVRNORM LSR.L #1,D3
;
; TEST EXPONENT FOR UNDERFLOW OR OVERFLOW.
;
 SWAP D4
 TST.W D4
DVRTEST BMI DVRZERO
 CMPI.W #$FF,D4
 BHI DVROVFL
;
; ROUND THE RESULT.
;
 TST.B D3
 BPL DVR1
 ADDI.L #$100,D3
 BCC DVR1
 ADDQ.B #1,D4
 BCS DVROVFL
DVR1 LSR.L #8,D3
 SWAP D3
 ANDI.W #$7F,D3
 ASL.W #7,D4
 BEQ DVRZERO
 OR.W D4,D3
 SWAP D4
 TST.B D4
 BEQ DVREXIT
 ORI.W #$8000,D3
DVREXIT MOVEM.W (SP)+,D0/D5-D7
 MOVE.L D3,-(SP)
 JMP (A2)
;
; SUBROUTINE; DIVIDE 16 BITS INTO 32.
;
DVRSUB MOVE.L D0,D1
 CLR.W D1
 SWAP D1
 DIVU D1,D7
 BVC DVROK
 MOVEQ #$FF,D7
DVROK MOVE.W D7,D2
 MOVE.W D7,D3
 MULU D0,D2
 MULU D1,D7
 MOVE.W D2,D5
 CLR.W D2
 SWAP D2
 ADD.L D2,D7
 CLR.W D2
 SUB.W D5,D2
 SUBX.L D7,D6
 BPL SHIFTWRD
;
NEGATIVE SUBQ.W #1,D3
 ADD.W D0,D2
 ADDX.L D1,D6
 BMI NEGATIVE
;
SHIFTWRD SWAP D6
 MOVE.W D2,D6
 RTS
;
; POT. POWER OF TEN. IF THE INTEGER TOS IS IN THE
; RANGE 0 <= TOS <= 38, PUSH THE REAL (AND THUS
; IMPLEMENTATION-DEPENDENT) VALUE 10 ^ TOS. IF NOT,
; GIVE AN EXECUTION ERROR. THIS FACILITY ALLOWS THE
; REST OF THE SYSTEM TO BE INDEPENDENT OF FLOATING
; POINT FORMAT.
;
POT MOVE.W (SP)+,D1
 CMPI.W #38,D1
 BHI POTERROR
 ADD.W D1,D1
 ADD.W D1,D1
 MOVE.L @POWERS(PC,D1.W),-(SP)
 JMP (A2)
;
POTERROR SUBQ.W #2,A4
 SUBQ.W #2,SP
 BRA XFPIERR
;
POWERS DC.L $00003F80 ;10 ^ 00
 DC.L $00004120 ;10 ^ 01
 DC.L $000042C8 ;10 ^ 02
 DC.L $0000447A ;10 ^ 03
 DC.L $4000461C ;10 ^ 04
 DC.L $500047C3 ;10 ^ 05
 DC.L $24004974 ;10 ^ 06
 DC.L $96804B18 ;10 ^ 07
 DC.L $BC204CBE ;10 ^ 08
 DC.L $6B284E6E ;10 ^ 09
 DC.L $02F95015 ;10 ^ 10
 DC.L $43B751BA ;10 ^ 11
 DC.L $D4A55368 ;10 ^ 12
 DC.L $84E75511 ;10 ^ 13
 DC.L $E62156B5 ;10 ^ 14
 DC.L $5FA95863 ;10 ^ 15
 DC.L $1BCA5A0E ;10 ^ 16
 DC.L $A2BC5BB1 ;10 ^ 17
 DC.L $0B6B5D5E ;10 ^ 18
 DC.L $C7235F0A ;10 ^ 19
 DC.L $78EC60AD ;10 ^ 20
 DC.L $D7276258 ;10 ^ 21
 DC.L $86786407 ;10 ^ 22
 DC.L $681665A9 ;10 ^ 23
 DC.L $C21C6753 ;10 ^ 24
 DC.L $59516904 ;10 ^ 25
 DC.L $6FA66AA5 ;10 ^ 26
 DC.L $CB8F6C4E ;10 ^ 27
 DC.L $3F396E01 ;10 ^ 28
 DC.L $8F086FA1 ;10 ^ 29
 DC.L $F2CA7149 ;10 ^ 30
 DC.L $6F7C72FC ;10 ^ 31
 DC.L $C5AE749D ;10 ^ 32
 DC.L $37197645 ;10 ^ 33
 DC.L $84DF77F6 ;10 ^ 34
 DC.L $130C799A ;10 ^ 35
 DC.L $97CE7B40 ;10 ^ 36
 DC.L $BDC27CF0 ;10 ^ 37
 DC.L $76997E96 ;10 ^ 38
;
; REAL COMPARISONS. COMPARE THE REAL TOS-1 TO THE
; REAL TOS, AND PUSH THE RESULT, TRUE OR FALSE.
;
; EQUREAL. TOS-1 = TOS.
;
EQUREAL CMPM.L (SP)+,(SP)+
 SNE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; NEQREAL. TOS-1 <> TOS.
;
NEQREAL CMPM.L (SP)+,(SP)+
 SEQ D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LEQREAL. TOS-1 <= TOS.
;
LEQREAL MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 SWAP D1
 BMI LEQREALN
 SWAP D2
 BMI FPTRUE
 CMP.L D1,D2
 SHI D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
LEQREALN SWAP D2
 BPL FPFALSE
 CMP.L D1,D2
 SCC D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LESREAL. TOS-1 < TOS.
;
LESREAL MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 SWAP D1
 BMI LESREALN
 SWAP D2
 BMI FPTRUE
 CMP.L D1,D2
 SCC D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
LESREALN SWAP D2
 BPL FPFALSE
 CMP.L D1,D2
 SHI D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
FPFALSE MOVE.W #FALSE,-(SP)
 JMP (A2)
;
FPTRUE MOVE.W #TRUE,-(SP)
 JMP (A2)
;
; GEQREAL. TOS-1 >= TOS.
;
GEQREAL MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 SWAP D1
 BMI GEQREALN
 SWAP D2
 BMI FPFALSE
 CMP.L D1,D2
 SCS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
GEQREALN SWAP D2
 BPL FPTRUE
 CMP.L D1,D2
 DC.W $53C0 ;SLS D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GRTREAL. TOS-1 > TOS.
;
GRTREAL MOVE.L (SP)+,D1
 MOVE.L (SP)+,D2
 SWAP D1
 BMI GRTREALN
 SWAP D2
 BMI FPFALSE
 CMP.L D1,D2
 DC.W $53C0 ;SLS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
GRTREALN SWAP D2
 BPL FPTRUE
 CMP.L D1,D2
 SCS D0
 NEG.B D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
 CHAIN SYSTEM.68000.C,D2
