;******** STRINGS ********
;
; STRING COMPARISONS. FIND THE STRING POINTED TO BY
; WORD POINTER TOS-1, COMPARE IT LEXICOGRAPHICALLY
; TO THE STRING POINTED TO BY WORD POINTER TOS, AND
; PUSH THE RESULT, TRUE OR FALSE.
;
; THE FOLLOWING SUBROUTINE COMPARES TWO STRINGS AND
; SETS THE CONDITION CODES ACCORDINGLY.
;
CMPSTR MOVE.L (SP)+,D4
 MOVEA.W (SP),A0 ;STRING ADDRESS 1
 MOVEA.W 2(SP),A1 ;STRING ADDRESS 2
 MOVE.W #$00FF,D1
 CMP.W A0,D1
 BCS CMPSTR1
 MOVE.W A0,D2 ;S1 IS SINGLE CHAR
 ORI.W #$0100,D2 ;LENGTH(S1) := 1
 MOVEA.W SP,A0
 MOVE.W D2,(A0)
CMPSTR1 CMP.W A1,D1
 BCS CMPSTR2
 MOVE.W A1,D2 ;S2 IS SINGLE CHAR
 ORI.W #$0100,D2 ;LENGTH(S2) := 1
 LEA 2(SP),A1
 MOVE.W D2,(A1)
CMPSTR2 CLR.W D1
 MOVE.B (A0)+,D0
 MOVE.B (A1)+,D1
 MOVE.W D0,D2
 CMP.W D1,D0
 BLS CMPSTR3
 MOVE.W D1,D2
CMPSTR3 CMPI.W #6,D2
 BLS CMPSTR5
 ADDQ.W #1,D2
 MOVE.W D2,D3
 LSR.W #2,D3
 SUBQ.W #2,D3
 CMPM.B (A0)+,(A1)+
 BNE CMPSTRX
 CMPM.W (A0)+,(A1)+
 BNE CMPSTRX
;
CMPSTR4 CMPM.L (A0)+,(A1)+
 DBNE D3,CMPSTR4
;
 BNE CMPSTRX
 ANDI.W #3,D2
CMPSTR5 TST.W D2
 BEQ CMPSTR7
 SUBQ.W #1,D2
;
CMPSTR6 CMPM.B (A0)+,(A1)+
 DBNE D2,CMPSTR6
;
 BNE CMPSTRX
CMPSTR7 CMP.W D0,D1
CMPSTRX ADDQ.W #4,SP
 MOVEA.L D4,A0
 JMP (A0)
;
; EQUSTR. TOS-1 = TOS.
;
EQUSTR BSR CMPSTR
 SNE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; NEQSTR. TOS-1 <> TOS.
;
NEQSTR BSR CMPSTR
 SEQ D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LEQSTR. TOS-1 <= TOS.
;
LEQSTR BSR CMPSTR
 SHI D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LESSTR. TOS-1 < TOS.
;
LESSTR BSR CMPSTR
 SCC D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GEQSTR. TOS-1 >= TOS.
;
GEQSTR BSR CMPSTR
 SCS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GRTSTR. TOS-1 > TOS.
;
GRTSTR BSR CMPSTR
 DC.W $53C0 ;SLS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
;******** LOGICAL ********
;
; LAND. LOGICAL AND. PUSH THE RESULT OF TOS-1 AND
; TOS.
;
LAND MOVE.W (SP)+,D1
 AND.W D1,(SP)
 JMP (A2)
;
; LOR. LOGICAL OR. PUSH THE RESULT OF TOS-1 OR TOS.
;
LOR MOVE.W (SP)+,D1
 OR.W D1,(SP)
 JMP (A2)
;
; LOGICAL NOT. PUSH THE ONE'S COMPLEMENT OF TOS.
;
LNOT NOT.W (SP)
 JMP (A2)
;
; BOOLEAN COMPARISONS. COMPARE BIT 0 OF TOS-1 TO
; BIT 0 OF TOS AND PUSH THE RESULT, TRUE OR FALSE.
;
; EQUBOOL. TOS-1 = TOS.
;
EQUBOOL MOVE.W (SP)+,D1
 MOVE.W (SP)+,D2
 EOR.W D2,D1
 NOT.W D1
 ANDI.W #1,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; NEQBOOL. TOS-1 <> TOS.
;
NEQBOOL MOVE.W (SP)+,D1
 MOVE.W (SP)+,D2
 EOR.W D2,D1
 ANDI.W #1,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; LEQBOOL. TOS-1 <= TOS.
;
LEQBOOL MOVEQ #1,D1
 MOVEQ #1,D2
 AND.W (SP)+,D1
 AND.W (SP)+,D2
 CMP.W D1,D2
 SHI D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LESBOOL. TOS-1 < TOS.
;
LESBOOL MOVEQ #1,D1
 MOVEQ #1,D2
 AND.W (SP)+,D1
 AND.W (SP)+,D2
 CMP.W D1,D2
 SCC D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GEQBOOL. TOS-1 >= TOS.
;
GEQBOOL MOVEQ #1,D1
 MOVEQ #1,D2
 AND.W (SP)+,D1
 AND.W (SP)+,D2
 CMP.W D1,D2
 SCS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GRTBOOL. TOS-1 > TOS.
;
GRTBOOL MOVEQ #1,D1
 MOVEQ #1,D2
 AND.W (SP)+,D1
 AND.W (SP)+,D2
 CMP.W D1,D2
 DC.W $53C0 ;SLS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
;******** SETS ********
;
; ADJ UB. ADJUST SET. FORCE THE SET TOS TO OCCUPY
; UB WORDS, EITHER BY EXPANSION (PUTTING ZEROES
; "BETWEEN" TOS AND TOS-1) OR COMPRESSION
; (CHOPPING OF HIGH WORDS OF SET), DISCARD THE
; LENGTH WORD, AND PUSH THE RESULTING SET.
;
ADJ MOVE.B (A4)+,D0 ;D0 := UB
 MOVE.W (SP)+,D1 ;D1 := TOS
 CMP.W D1,D0
 BHI ADJ2
 BEQ ADJEX
;
; NOW WE HAVE UB < TOS --> MOVE UB WORDS "UP"
; BY TOS-UB WORDS.
;
 LEA 0(SP,D0.W),A0
 ADDA.W D0,A0
 ADD.W D1,D1
 LEA 0(SP,D1.W),A1
 MOVE.W D0,D1
 SUBQ.W #1,D1
;
ADJ1 MOVE.W -(A0),-(A1)
 DBF D1,ADJ1
;
 MOVEA.W A1,SP
 JMP (A2)
;
; NOW WE HAVE UB > TOS --> MOVE TOS WORDS "DOWN"
; BY UB-TOS WORDS AND FILL THE GAP WITH ZEROES.
;
ADJ2 MOVEA.W SP,A0
 MOVE.W D0,D2
 SUB.W D1,D2
 SUBA.W D2,SP
 SUBA.W D2,SP
 CMPA.W #SPMAX+SPOFF,SP
 BLS ADJERR
 MOVEA.W SP,A1
 SUBQ.W #1,D1
 BCS ADJ4
;
ADJ3 MOVE.W (A0)+,(A1)+
 DBF D1,ADJ3
;
ADJ4 SUBQ.W #1,D2
 CLR.W D0
;
ADJ5 MOVE.W D0,(A1)+
 DBF D2,ADJ5
;
ADJEX JMP (A2)
;
ADJERR ADD.W D2,D2
 LEA -2(SP,D2.W),SP
SETOVFL SUBQ.W #1,A4
 BRA XSTKOVR
;
; SGS. BUILD A SINGLETON SET. PUSH THE SET [TOS].
;
SGS MOVE.W (SP)+,D1
 MOVEQ #15,D0
 AND.B D1,D0
 MOVEQ #0,D2
 BSET D0,D2
 MOVE.W D2,-(SP)
 LSR.W #4,D1
 BEQ SGS2
 MOVE.W #SPMAX+SPOFF,D3
 ADD.W D1,D3
 ADD.W D1,D3
 CMP.W SP,D3
 BHI SETOVFL
 MOVEQ #0,D0
 MOVE.W D1,D2
 SUBQ.W #1,D2
;
SGS1 MOVE.W D0,-(SP)
 DBF D2,SGS1
;
SGS2 ADDQ.W #1,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
; SRS. BUILD A SUBRANGE SET. PUSH THE SET
; [TOS-1 .. TOS] (PUSH THE SET [] IF TOS-1 > TOS).
;
SRS MOVE.W (SP)+,D1
 MOVE.W (SP)+,D2
 CMP.W D1,D2
 BHI EMPTYSET
 MOVEQ #$F0,D3
 MOVEQ #$F0,D4
 AND.W D1,D4
 AND.W D2,D3
 SUB.W D3,D4
 MOVEQ #15,D0
 AND.B D1,D0
 ADD.B D0,D0
 LEA @MASK+2(PC),A0
 MOVE.W 0(A0,D0.W),D3
 TST.W D4
 BEQ SRS2
 MOVE.W D3,-(SP)
 MOVEQ #$FF,D3
 LSR.W #4,D4
 SUBQ.W #2,D4
 BCS SRS2
 MOVEA.W SP,A0
 SUBA.W D4,A0
 SUBA.W D4,A0
 CMPA.W #SPMAX+SPOFF,A0
 BLS SRSERR
;
SRS1 MOVE.W D3,-(SP)
 DBF D4,SRS1
;
SRS2 MOVEQ #15,D0
 AND.B D2,D0
 ADD.B D0,D0
 AND.W @SETMASK(PC,D0.W),D3
 MOVE.W D3,-(SP)
 LSR.W #4,D2
 BEQ SRS4
 MOVE.W #SPMAX+SPOFF,D3
 ADD.W D2,D3
 ADD.W D2,D3
 CMP.W SP,D3
 BHI SRSERR
 MOVEQ #0,D0
 SUBQ.W #1,D2
;
SRS3 MOVE.W D0,-(SP)
 DBF D2,SRS3
;
SRS4 LSR.W #4,D1
 ADDQ.W #1,D1
 MOVE.W D1,-(SP)
 JMP (A2)
;
EMPTYSET MOVE.W #0,-(SP)
 JMP (A2)
;
SRSERR SUBQ.W #1,A4
 BRA XSTKOVR
;
; TABLE OF MASKS FOR SET MANIPULATIONS
;
SETMASK DC.W %1111111111111111
 DC.W %1111111111111110
 DC.W %1111111111111100
 DC.W %1111111111111000
 DC.W %1111111111110000
 DC.W %1111111111100000
 DC.W %1111111111000000
 DC.W %1111111110000000
 DC.W %1111111100000000
 DC.W %1111111000000000
 DC.W %1111110000000000
 DC.W %1111100000000000
 DC.W %1111000000000000
 DC.W %1110000000000000
 DC.W %1100000000000000
 DC.W %1000000000000000
;
; INN. SET MEMBERSHIP. IF INTEGER TOS-1 IS IN SET
; TOS, PUSH TRUE. IF NOT, PUSH FALSE.
;
INN MOVE.W (SP)+,D1
 MOVE.W D1,D4
 ADD.W D4,D4
 MOVE.W 0(SP,D4.W),D2
 MOVE.W D2,D3
 LSR.W #4,D3
 CMP.W D3,D1
 BLS INNFALSE
 ADD.W D3,D3
 MOVE.W 0(SP,D3.W),D3
 ANDI.W #%1111,D2
 BTST D2,D3
 BEQ INNFALSE
 ADDA.W D4,SP
 MOVE.W #TRUE,(SP)
 JMP (A2)
;
INNFALSE ADDA.W D4,SP
 MOVE.W #FALSE,(SP)
 JMP (A2)
;
; UNI. SET UNION. PUSH THE UNION OF SETS TOS AND
; TOS-1. (TOS OR TOS-1)
;
UNI MOVE.W (SP),D1 ;LENGTH(SET1)
 BEQ UNIEXIT ;DONE IF EMPTY SET
 LEA 2(SP,D1.W),A0
 ADDA.W D1,A0
 MOVE.W (A0)+,D2 ;LENGTH(SET2)
 BEQ UNI4 ;SKIP IF EMPTY SET
 CMP.W D1,D2
 BCS UNI2
 ADDQ.W #2,SP
 SUBQ.W #1,D1
;
UNI1 MOVE.W (SP)+,D2
 OR.W D2,(A0)+
 DBF D1,UNI1
;
 JMP (A2)
;
UNI2 LEA 2(SP),A1
 SUBQ.W #1,D2
;
UNI3 MOVE.W (A0)+,D3
 OR.W D3,(A1)+
 DBF D2,UNI3
;
UNI4 LEA 2(SP,D1.W),A1
 ADDA.W D1,A1
;
UNI5 MOVE.W -(A1),-(A0)
 DBF D1,UNI5
;
 MOVEA.W A0,SP
UNIEXIT JMP (A2)
;
; INT. SET INTERSECTION. PUSH THE INTERSECTION OF
; SETS TOS AND TOS-1. (TOS AND TOS-1)
;
INT MOVE.W (SP)+,D1
 LEA 0(SP,D1.W),A0
 ADDA.W D1,A0
 MOVEA.W A0,A1
 MOVE.W (A0)+,D2
 BEQ INTEXIT
 CMP.W D1,D2
 BHI INT2
 SUBQ.W #1,D2
;
INT1 MOVE.W (SP)+,D3
 AND.W D3,(A0)+
 DBF D2,INT1
;
INTEXIT MOVEA.W A1,SP
 JMP (A2)
;
INT2 MOVE.W D1,D3
 BEQ INT4
 SUBQ.W #1,D3
;
INT3 MOVE.W (SP)+,D4
 AND.W D4,(A0)+
 DBF D3,INT3
;
 SUB.W D1,D2
INT4 SUBQ.W #1,D2
 CLR.W D0
;
INT5 MOVE.W D0,(A0)+
 DBF D2,INT5
;
 JMP (A2)
;
; DIF. SET DIFFERENCE. PUSH THE DIFFERENCE OF SETS
; TOS-1 AND TOS. (TOS-1 AND NOT TOS).
;
DIF MOVE.W (SP)+,D1
 LEA 0(SP,D1.W),A0
 ADDA.W D1,A0
 MOVEA.W A0,A1
 MOVE.W (A0)+,D2
 BEQ DIFEXIT
 CMP.W D1,D2
 BHI DIF2
 SUBQ.W #1,D2
;
DIF1 MOVE.W (SP)+,D1
 NOT.W D1
 AND.W D1,(A0)+
 DBF D2,DIF1
;
DIFEXIT MOVEA.W A1,SP
 JMP (A2)
;
DIF2 SUBQ.W #1,D1
 BCS DIFEXIT
;
DIF3 MOVE.W (SP)+,D2
 NOT.W D2
 AND.W D2,(A0)+
 DBF D1,DIF3
;
 JMP (A2)
;
; SET COMPARISONS. COMPARE SET TOS-1 TO THE SET
; TOS, AND PUSH THE RESULT, TRUE OR FALSE.
;
; COMPARE TWO SETS AND SET THE CONDITION CODES
; ACCORDINGLY.
;
CMPPOWR MOVE.L (SP)+,D4
 MOVE.W (SP)+,D1
 MOVEA.W SP,A0
 LEA 0(SP,D1.W),A1
 ADDA.W D1,A1
 MOVE.W (A1)+,D2
 MOVE.W D2,D3
 ADD.W D3,D3
 ADD.W A1,D3
 CMP.W D1,D2
 BLS CMPPOWR1
 EXG D1,D2
 EXG A0,A1
CMPPOWR1 TST.W D1
 BEQ CMPPOWRX
 SUB.W D2,D1
 SUBQ.W #1,D2
 BCS CMPPOWR3
;
CMPPOWR2 CMPM.W (A0)+,(A1)+
 DBNE D2,CMPPOWR2
;
 BNE CMPPOWRX
CMPPOWR3 TST.W D1
 BEQ CMPPOWRX
 SUBQ.W #1,D1
;
CMPPOWR4 TST.W (A0)+
 DBNE D1,CMPPOWR4
;
CMPPOWRX MOVEA.W D3,SP
 MOVEA.L D4,A0
 JMP (A0)
;
; EQUPOWR. TOS-1 = TOS.
;
EQUPOWR BSR CMPPOWR
 SNE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; NEQPOWR. TOS-1 <> TOS.
;
NEQPOWR BSR CMPPOWR
 SEQ D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LEQPOWR. TOS-1 <= (SUBSET OF) TOS.
;
LEQPOWR MOVEQ #FALSE,D0
 BRA LGPOWR
;
; GEQPOWR. TOS-1 >= (SUPERSET OF) TOS.
;
GEQPOWR MOVEQ #TRUE,D0
LGPOWR MOVE.W (SP)+,D1
 MOVEA.W SP,A0
 LEA 0(SP,D1.W),A1
 ADDA.W D1,A1
 MOVE.W (A1)+,D2
 MOVE.W D2,D3
 ADD.W D3,D3
 ADD.W A1,D3
 TST.B D0
 BNE LGPOWR1
 EXG D1,D2
 EXG A0,A1
LGPOWR1 MOVE.W D1,D4
 BEQ LGPOWRT
 CMP.W D1,D2
 BCC LGPOWR2
 MOVE.W D2,D4
 BEQ LGPOWR4
LGPOWR2 SUBQ.W #1,D4
;
LGPOWR3 MOVE.W (A1)+,D0
 NOT.W D0
 AND.W (A0)+,D0
 DBNE D4,LGPOWR3
;
 BNE LGPOWRF
 SUB.W D2,D1
 BLS LGPOWRT
LGPOWR4 SUBQ.W #1,D1
;
LGPOWR5 TST.W (A0)+
 DBNE D1,LGPOWR5
;
 BNE LGPOWRF
LGPOWRT MOVEA.W D3,SP
 MOVEQ #TRUE,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
LGPOWRF MOVEA.W D3,SP
 MOVEQ #FALSE,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
;******** BYTE ARRAYS ********
;
; BYTE ARRAY COMPARISONS. COMPARE BYTE ARRAY TOS-1
; TO BYTE ARRAY TOS, AND PUSH THE RESULT, TRUE OR
; FALSE. <=, <, >=, AND > MUST BE USED WITH PACKED
; ARRAYS OF CHAR, ONLY. B GIVES THE NUMBER OF
; BYTES TO COMPARE.
;
; THE FOLLOWING SUBROUTINE COMPARES TWO BYTE ARRAYS
; AND SETS THE CONDITION CODES ACCORDINGLY.
;
CMPBYTE MOVE.L (SP)+,D3
 MOVEA.W (SP)+,A0
 MOVEA.W (SP)+,A1
 CLR.W D1
 MOVE.B (A4)+,D1
 BPL CMPBYTE1
 ADD.B D1,D1
 ASL.W #7,D1
 MOVE.B (A4)+,D1
CMPBYTE1 MOVE.W D1,D2
 LSR.W #2,D2
 BEQ CMPBYTE3
 SUBQ.W #1,D2
;
CMPBYTE2 CMPM.L (A0)+,(A1)+
 DBNE D2,CMPBYTE2
;
 BNE CMPBYTE5
CMPBYTE3 ANDI.W #3,D1
 BEQ CMPBYTE5
 SUBQ.W #1,D1
;
CMPBYTE4 CMPM.B (A0)+,(A1)+
 DBNE D1,CMPBYTE4
;
CMPBYTE5 MOVEA.L D3,A0
 JMP (A0)
;
; EQUBYT B. TOS-1 = TOS.
;
EQUBYT BSR CMPBYTE
 SNE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; NEQBYT B. TOS-1 <> TOS.
;
NEQBYT BSR CMPBYTE
 SEQ D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LEQBYT B. TOS-1 <= TOS.
;
LEQBYT BSR CMPBYTE
 SHI D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; LESBYT B. TOS-1 < TOS.
;
LESBYT BSR CMPBYTE
 SCC D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GEQBYT B. TOS-1 >= TOS.
;
GEQBYT BSR CMPBYTE
 SCS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; GRTBYT B. TOS-1 > TOS.
;
GRTBYT BSR CMPBYTE
 DC.W $53C0 ;SLS D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
;******** RECORDS AND WORD ARRAYS ********
;
; WORD OR MULTIWORD STRUCTURE COMPARISONS. COMPARE
; WORD STRUCTURE TOS-1 TO WORD STRUCTURE TOS, AND
; PUSH THE RESULT, TRUE OR FALSE. B GIVES THE
; NUMBER OF WORDS TO COMPARE.
;
; THE FOLLOWING SUBROUTINE COMPARES TWO WORD
; STRUCTURES AND SETS THE CONDITION CODES
; ACCORDINGLY.
;
CMPWORD MOVE.L (SP)+,D3
 MOVEA.W (SP)+,A0
 MOVEA.W (SP)+,A1
 CLR.W D1
 MOVE.B (A4)+,D1
 BPL CMPWORD1
 ADD.B D1,D1
 ASL.W #7,D1
 MOVE.B (A4)+,D1
CMPWORD1 MOVE.W D1,D2
 LSR.W #1,D2
 BEQ CMPWORD3
 SUBQ.W #1,D2
;
CMPWORD2 CMPM.L (A0)+,(A1)+
 DBNE D2,CMPWORD2
;
 BNE CMPWORD4
CMPWORD3 ANDI.W #1,D1
 BEQ CMPWORD4
 CMPM.W (A0)+,(A1)+
CMPWORD4 MOVEA.L D3,A0
 JMP (A0)
;
; EQUWORD B. TOS-1 = TOS.
;
EQUWORD BSR CMPWORD
 SNE D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
; NEQWORD B. TOS-1 <> TOS.
;
NEQWORD BSR CMPWORD
 SEQ D0
 ADDQ.B #1,D0
 MOVE.W D0,-(SP)
 JMP (A2)
;
 CHAIN SYSTEM.68000.D,D2
