;**************************************************
;*
;* JUMPS
;*
;**************************************************
;
; SIMPLE (NON-CASE STATEMENT) JUMPS ARE ALL TWO
; BYTES LONG. THE FIRST BYTE IS THE OP-CODE, THE
; SECOND IS A SB JUMP OFFSET. IF THIS OFFSET IS
; NON-NEGATIVE, IT IS SIMPLY ADDED TO IPC. (A VALUE
; OF ZERO FOR THE JUMP OFFSET WILL MAKE ANY JUMP A
; TWO-BYTE NOP.) IF SB IS NEGATIVE, THEN SB DIV 2
; IS USED AS A WORD OFFSET INTO JTAB, AND IPC IS
; SET TO THE BYTE ADDRESS (JTAB^[SB DIV 2]) -
; CONTENTS OF (JTAB[SB DIV 2]).
;
; UJP SB. UNCONDITIONAL JUMP. JUMP AS DESCRIBED
; ABOVE.
;
UJP MOVE.B (A4)+,D1
 EXT.W D1
 BPL UJP1
 ADD.W D6,D1
 MOVEA.W D1,A4
 MOVE.W (A4),D1
 ROL.W #8,D1
 SUBA.W D1,A4
 JMP (A2)
;
UJP1 ADDA.W D1,A4
 JMP (A2)
;
UJUMP MOVE.B (A4)+,D1
 EXT.W D1
 BPL UJP1
 ADD.W D6,D1
 MOVEA.W D1,A4
 MOVE.W (A4),D1
 SUBA.W D1,A4
 JMP (A2)
;
; FJP SB. FALSE JUMP. JUMP IF TOS IS FALSE.
;
FJP LSR (SP)+
 BCC UJP
 ADDQ.W #1,A4
 JMP (A2)
;
FJUMP LSR (SP)+
 BCC UJUMP
 ADDQ.W #1,A4
 JMP (A2)
;
; EFJ SB. EQUAL FALSE JUMP. JUMP IF INTEGER
; TOS-1 <> INTEGER TOS.
;
EFJ CMPM.W (SP)+,(SP)+
 BNE UJP
 ADDQ.W #1,A4
 JMP (A2)
;
EFJUMP CMPM.W (SP)+,(SP)+
 BNE UJUMP
 ADDQ.W #1,A4
 JMP (A2)
;
; NFJ SB. NOT EQUAL FALSE JUMP. JUMP IF INTEGER
; TOS-1 = INTEGER TOS.
;
NFJ CMPM.W (SP)+,(SP)+
 BEQ UJP
 ADDQ.W #1,A4
 JMP (A2)
;
NFJUMP CMPM.W (SP)+,(SP)+
 BEQ UJUMP
 ADDQ.W #1,A4
 JMP (A2)
;
; XJP W1, W2, W3, <CASE TABLE>.
;
; CASE JUMP. W1 IS WORD-ALIGNED, AND IS THE MINIMUM
; INDEX OF THE TABLE. W2 IS THE MAXIMUM INDEX. W3
; IS AN UNCONDITIONAL JUMP INSTRUCTION PAST THE
; TABLE. THE CASE TABLE IS (W2 - W1 + 1) WORDS
; LONG, AND CONTAINS SELF-RELATIVE LOCATIONS.
;
; IF TOS, THE ACTUAL INDEX, IS NOT IN THE RANGE
; W1 .. W2, THEN POINT IPC AT W3. OTHERWISE, USE
; (TOS - W1) AS AN INDEX INTO THE CASE TABLE, AND
; SET IPC TO THE BYTE ADDRESS (CASETABLE[TOS - W1])
; MINUS THE CONTENTS OF (CASETABLE[TOS - W1]).
;
XJP MOVE.W A4,D1
 ADDQ.W #1,D1
 ANDI.W #$FFFE,D1
 MOVEA.W D1,A4
 MOVE.W (A4)+,D1
 ROL.W #8,D1
 MOVE.W (SP)+,D2
 CMP.W D1,D2
 BLT XJP1
 MOVE.W (A4)+,D3
 ROL.W #8,D3
 CMP.W D3,D2
 BGT XJP2
 SUB.W D1,D2
 ADD.W D2,D2
 ADDQ.W #2,D2
 ADDA.W D2,A4
 MOVE.W (A4),D1
 ROL.W #8,D1
 SUBA.W D1,A4
 JMP (A2)
;
XJP1 ADDQ.W #2,A4
XJP2 JMP (A2)
;
XJUMP MOVE.W A4,D1
 ADDQ.W #1,D1
 ANDI.W #$FFFE,D1
 MOVEA.W D1,A4
 MOVE.W (A4)+,D1
 MOVE.W (SP)+,D2
 CMP.W D1,D2
 BLT XJP1
 CMP.W (A4)+,D2
 BGT XJP2
 SUB.W D1,D2
 ADD.W D2,D2
 ADDQ.W #2,D2
 ADDA.W D2,A4
 MOVE.W (A4),D1
 SUBA.W D1,A4
 JMP (A2)
;
;**************************************************
;*
;* PROCEDURE AND FUNCTION CALLS
;*
;**************************************************
;
; CALL A 68000 MACHINE CODE ROUTINE.
;
MCODE TST.W D2
 BMI MCODE1
 LEA @SEGCOUNT(PC),A1
 SUBQ.W #1,0(A1,D2.W)
MCODE1 SUBA.W -(A0),A0
 MOVEA.L A0,A1
 LEA @INLINE1(PC),A0
 JSR (A1)
 MOVEQ #0,D0
 MOVEA.W D5,A1
 MOVE.B (A1),D0
 BSR LOADSEX
 JMP (A2)
;
; EXIT FOR STACK OVERFLOWS.
;
BUILDNOT SUBQ.W #2,A4
 BRA XSTKOVR
;
; BUILD AN ACTIVATION RECORD FOR AN EXTERNAL
; PROCEDURE CALL.
;
EXTERN ADD.B D1,D1
 LEA @PROCDIC(PC),A0
 SWAP D7
 MOVE.W 0(A0,D1.W),D7
 MOVE.W D1,D2
 BRA EXTERN1
;
; BUILD AN ACTIVATION RECORD. THIS IS A GENERAL
; PURPOSE SUBROUTINE USED IN PROCEDURE/FUNCTION
; INVOCATION. UPON CALLING THE SUBROUTINE, THE
; NUMBER OF THE CALLED PROCEDURE MUST BE CONTAINED
; IN THE LEAST SIGNIFICANT BYTE OF REGISTER D0.
;
BUILDAR SWAP D7
 MOVE.W D5,D7
 MOVEQ #-1,D2
;
; SAVE THE RETURN ADDRESS.
;
EXTERN1 MOVE.L (SP)+,D4
;
; FIND THE PROCEDURE CODE SECTION FOR THE CALLED
; PROCEDURE.
;
 MOVE.W D7,D1
 SWAP D7
 SUB.W D0,D1
 SUB.W D0,D1
 MOVEA.W D1,A0
 SUBA.W (A0),A0
;
; TAKE SPECIAL ACTION FOR MACHINE CODE ROUTINES.
;
 TST.B (A0)
 BEQ MCODE
;
; FROM THE TABLE OF ATTRIBUTES (JTAB) IN THE CALLED
; PROCEDURE'S CODE SECTION, FIND THE DATA SIZE AND
; PARAMETER SIZE OF THE CALLED PROCEDURE.
;
 SUBQ.W #8,A0
 MOVEQ #MPOFF+2,D1
 ADD.W (A0)+,D1
 MOVE.W (A0)+,D2
 ADDQ.W #2,A0
 ADD.W D2,D1
;
; EXTEND THE PROGRAM STACK BY A NUMBER OF BYTES
; EQUAL TO THE DATA SIZE PLUS THE PARAMETER SIZE
; PLUS THE MARKSTACK SIZE. CHECK FOR PROGRAM STACK
; OVERFLOW.
;
 MOVE.W A6,D3
 CMP.W D3,D1
 BHI BUILDNOT
 SUB.W D1,D3
;
; DO THE STACK AND THE HEAP COLLIDE?
;
 CMP.W D3,D7
 BLS BUILDAR1
;
; YES! TRY TO DISCARD THE TEMPORARY DIRECTORY
; BUFFER.
;
 MOVE.W GDIRP,D1
 BEQ BUILDNOT
 CMP.W D3,D1
 BHI BUILDNOT
 MOVE.W D1,D7
 MOVE.W #NIL,GDIRP
;
; COPY A NUMBER OF BYTES EQUAL TO THE PARAMETER
; SIZE, FROM THE EVALUATION STACK'S TOS (POINTED TO
; BY SP) INTO THE SPACE JUST ALLOCATED. THIS PASSES
; PARAMETERS TO THE NEW PROCEDURE FROM ITS CALLER.
;
BUILDAR1 MOVEQ #MPOFF+2,D1
 ADD.W D3,D1
 MOVEA.W D1,A1
 LSR.W #1,D2
 BEQ BUILDAR3
 SUBQ.W #1,D2
;
BUILDAR2 MOVE.W (SP)+,(A1)+
 DBF D2,BUILDAR2
;
; BUILD A MARKSTACK, SAVING SP, IPC, SEG, JTAB, AND
; MP.
;
 MOVEA.W D1,A1
BUILDAR3 MOVE.W SP,-(A1)
 MOVE.W A4,-(A1)
 MOVE.W D5,-(A1)
 MOVE.W D6,-(A1)
 MOVE.L A3,-(A1)
;
; SAVE KP ON THE PROGRAM STACK AND CALCULATE A NEW
; KP.
;
 MOVE.W A6,-(A1)
 MOVEA.W A1,A6
;
; CALCULATE NEW VALUES FOR IPC, JTAB, AND MP.
;
 MOVEA.W A0,A4
 SUBA.W (A0)+,A4
 MOVE.W A0,D6
 MOVE.W D3,A3
 SWAP D7
 MOVE.W D7,D5
 SWAP D7
 MOVE.W D3,LASTMP
 BTST #1,FLAVOR
 BNE BUILD12
 MOVE.W A0,JTAB
 MOVE.W D5,SEG
;
; RETURN TO CALLER.
;
BUILD12 MOVEA.L D4,A1
 JMP (A1)
;
; INLINE ASSEMBLER ROUTINES (WORD ALIGNED)
;
PUTREGS MOVEM.L D5-D7/A2-A7,REGS
 RTS
;
; GETREGS MOVEM.L @REGS(PC),D5-D7/A2-A7
;
GETREGS DC.W $4CFA,$FCE0,$0004
 RTS
;
REGS DS.L 9
 DC.L CONREAD
 DC.L SYSCOM
 DC.L TABLE
 DC.L FETCH
 DC.L EXECERR
;
 BRA.L PUTREGS
;
 BRA.L GETREGS
;
INLINE1 MOVEA.L (SP)+,A4
 BRA INLINE2
;
 DS.L 16
 DS.W 1
;
INLINE2 MOVEQ #0,D0
 JMP (A2)
;
INLINE MOVE.W A4,D1
 ADDQ.W #1,D1
 ANDI.W #$FFFE,D1
 MOVEA.W D1,A4
 LEA @INLINE1(PC),A0
 LEA 2(A4),A1
 ADDA.W (A4)+,A4
 JMP (A1)
;
; CLP UB. CALL LOCAL PROCEDURE. CALL PROCEDURE UB,
; WHICH IS AN IMMEDIATE CHILD OF THE CURRENTLY
; EXECUTING PROCEDURE AND IN THE SAME SEGMENT.
; STATIC LINK OF MARKSTACK IS SET TO OLD MP.
;
CLP MOVE.B (A4)+,D0
 BEQ INLINE
 BSR BUILDAR
 MOVE.W 2(A3),(A3)
 JMP (A2)
;
; CGP UB. CALL GLOBAL PROCEDURE. CALL PROCEDURE UB,
; WHICH IS AT LEX LEVEL 1 AND IN THE SAME SEGMENT
; AS THE CURRENTLY EXECUTING PROCEDURE. STATIC LINK
; OF THE MARKSTACK IS SET TO BASE.
;
CGP MOVE.B (A4)+,D0
 BSR BUILDAR
 MOVE.W A5,(A3)
 JMP (A2)
;
; CIP UB. CALL INTERMEDIATE PROCEDURE. CALL PROCE-
; DURE UB IN SAME SEGMENT AS THE CURRENTLY EXECUT-
; ING PROCEDURE. THE STATIC LINK OF THE MARKSTACK
; IS SET BY LOOKING UP THE CALL CHAIN UNTIL AN AC-
; TIVATION RECORD IS FOUND WHOSE CALLER HAD A LEX
; LEVEL ONE LESS THAN THE PROCEDURE BEING CALLED.
; USE THAT ACTIVATION RECORD'S DYNAMIC LINK AS THE
; STATIC LINK OF THE NEW MARKSTACK.
;
CIP MOVE.B (A4)+,D0
 BSR BUILDAR
 MOVE.B 1(A0),D0
CIPCXP SUBQ.B #1,D0
 MOVEA.W A3,A1
 BRA CIP2
;
CIP1 MOVEA.W 2(A1),A1
CIP2 MOVEA.W 4(A1),A0
 CMP.B 1(A0),D0
 BNE CIP1
;
 MOVE.W 2(A1),(A3)
 JMP (A2)
;
; CBP UB. CALL BASE PROCEDURE. CALL PROCEDURE UB,
; WHICH IS AT LEX LEVEL -1 OR 0. THE STATIC LINK OF
; THE MARKSTACK IS SET TO THE STATIC LINK IN BASE'S
; ACTIVATION RECORD. THE BASE IS SAVED, AFTER WHICH
; IT IS POINTED AT THE ACTIVATION RECORD JUST
; CREATED.
;
CBP MOVE.B (A4)+,D0
 BSR BUILDAR
CBPCXP MOVE.W A5,-(SP)
 MOVE.W SP,10(A3)
 MOVE.W (A5),(A3)
 MOVEA.W A3,A5
 MOVE.W A3,STKBASE
 JMP (A2)
;
; CXP UB1, UB2. CALL EXTERNAL PROCEDURE. CALL PRO-
; CEDURE UB2, IN SEGMENT UB1. USED TO CALL ANY PRO-
; CEDURE NOT IN THE SAME SEGMENT AS THE CALLING
; PROCEDURE, INCLUDING PROCEDURES AT LEX LEVEL -1
; OR 0. IT WORKS AS FOLLOWS:
;
; 1) IS DESIRED SEGMENT IN MEMORY?
;
; 2A) NO: READ IN SEGMENT FROM DISK USING THE IN-
;     FORMATION IN THE SEGTABLE, THEN BUILD AN
;     ACTIVATION RECORD.
;
; 2B) YES: BUILD ACTIVATION RECORD NORMALLY.
;
; 3) CALCULATE THE STATIC LINK FOR THE MARKSTACK:
;    IF THE CALLED PROCEDURE HAS A LEX LEVEL OF -1
;    OR 0, SET AS IN CBP; OTHERWISE SET AS IN CIP.
;
 DS.B 2
CALLPAS MOVE.L (SP)+,-(A6) ;SAVE RTN ADDR
 MOVE.W A4,-(A6) ;SAVE IPC
 MOVE.W #NIL,-(A6) ;SET FLAG
 LEA @CALLPAS(PC),A4
 MOVE.B D1,-(A4) ;STORE PROC #
 MOVE.B D0,-(A4) ;STORE SEG #
 CLR.W D0
;
CXP MOVE.B (A4),D0
 BSR LOADSEX
 MOVE.B (A4),D0
 BEQ CXP1
 MOVEQ #1,D1
 CMP.B D1,D0
 BNE CXPINV
 CMP.B 1(A4),D1
 BNE CXPINV
 MOVEQ #FALSE,D0
 BSR.L CFGHOST
CXPINV MOVE.B (A4),D0
 BSR INVOKE
 BEQ CXP1
 MOVE.B (A4),D0
 MOVE.W D0,D1
 ADD.W D1,D1
 LEA @PROCDIC(PC),A0
 MOVEA.W 0(A0,D1.W),A0
 CMP.B (A0),D0
 BNE CXPERR
 TST.B CURRSEX
 BNE CXP1
 BSR.L FLIPBYTE
CXP1 CLR.W D1
 MOVE.B (A4)+,D1
 MOVE.B (A4)+,D0
CXP2 BSR EXTERN
 MOVE.B 1(A0),D0
 BLE CBPCXP
 BRA CIPCXP
;
CXPERR SUBQ.W #1,A4
 BRA XNOPROC
;
; IF A NEW SEGMENT IS CALLED AND IT HAS NEVER BEEN
; INVOKED BEFORE THEN THIS SUBROUTINE READS IT IN
; FROM DISK. IF THE SEGMENT HAS ALREADY BEEN
; INVOKED THE INVOCATION TABLE IS BUMPED BY ONE TO
; SHOW THAT IT IS STILL IN USE AND THE LEVEL TO
; WHICH IT IS IN USE.
;
INVOKE MOVE.W D0,D1
 ADD.W D1,D1
 LEA @SEGCOUNT(PC),A0
 ADDA.W D1,A0
 TST.W (A0)
 BEQ INVOKE1
 ADDQ.W #1,(A0)
 MOVEQ #FALSE,D0
 RTS
;
INVOKE1 ADDQ.W #1,(A0)
 MOVE.W D1,D2
 ADD.W D0,D2
 ADD.W D2,D2
 LEA SEGTABLE+2,A0
 ADDA.W D2,A0
 LEA @PROCDIC(PC),A1
 TST.W (A0)+
 BNE INVOKE2
;
; THE SEGMENT IS IN MEMORY.
;
 SUBA.W (A0),A6
 MOVE.W A6,D2
 SUBQ.W #2,D2
 MOVE.W D2,0(A1,D1.W)
 MOVEQ #FALSE,D0
 RTS
;
; THE SEGMENT IS NOT IN MEMORY.
;
INVOKE2 MOVE.W A6,D2
 SUBQ.W #2,D2
 MOVE.W D2,0(A1,D1.W)
;
; THE FOLLOWING SUBROUTINE READS A SEGMENT FROM
; DISK. THE SEGMENT NUMBER MUST BE PASSED IN D0.
;
READSEG MOVE.W D0,D1
 ADD.W D1,D1
 ADD.W D0,D1
 ADD.W D1,D1
 LEA SEGTABLE,A0
 ADDA.W D1,A0
 MOVE.W (A0)+,D0
 TST.B D0
 BMI READSEG2
 LEA @DISKNUM-1(PC),A1
 ADDA.W D0,A1
 TST.B (A1)
 BPL READSEG1
;
; UNIT IS NEITHER REGULAR NOR USER DISK => ERROR.
;
 BRA READSEG7
;
; REPORT STACK OVERFLOW.
;
READSEG8 SUBQ.W #1,A4
 ADDQ.W #4,SP
 CLR.W D0
 BRA XSTKOVR
;
READSEG1 MOVE.B (A1),D0
READSEG2 MOVE.W A6,D2
 MOVE.W 2(A0),D4
 SUB.W D4,D2
 BCS READSEG8
 MOVEQ #NIL,D1
;
; CHECK FOR STACK/HEAP COLLISION.
;
 CMP.W D2,D7
 BLS READSEG3
;
; COLLISION! TRY TO REMOVE TEMPORARY DIRECTORY.
;
 MOVE.W GDIRP,D3
 BEQ READSEG8
 MOVE.W D3,D7
 MOVE.W D1,GDIRP
 CMP.W D2,D7
 BHI READSEG8
READSEG3 MOVEA.W D2,A6
 BRA READBIOS
;
READSEG6 TST.B D1
 BMI READBRK
 MOVE.W D1,IORSLT
READSEG7 SUBQ.W #1,A4
 ADDQ.W #4,SP
 CLR.W D0
 BRA XSYIOER
;
READBRK BTST #NOBREAK,MISCINFO+1
 BNE READSEG7
 SUBQ.W #1,A4
 ADDQ.W #4,SP
 CLR.W D0
 BRA XUBREAK
;
; SET UP STACK FOR BIOS CALL.
;
READBIOS MOVE.W D1,-(SP)
 MOVE.W D0,-(SP)
 MOVE.L A6,-(SP)
 MOVE.L (A0),-(SP)
 TST.B D0
 BPL READSEG4
 BSR.L USERREAD
 BRA READSEG5
;
READSEG4 BSR.L DISKREAD
READSEG5 TST.W D1
 BNE READSEG6
 MOVEQ #TRUE,D0
 RTS
;
; FLIP THE SELF-RELATIVE POINTERS INTO THE
; CORRECT BYTE ORDER (HIGH BYTE AT LOWER ADDRESS).
; THE SEGMENT NUMBER MUST BE PASSED IN D0.
;
FLIPBYTE LEA @PROCDIC(PC),A0
 ADD.B D0,D0
 MOVEA.W 0(A0,D0.W),A0
 CLR.W D1
 MOVE.B 1(A0),D1
 SUBQ.W #1,D1
;
; FLIP THE PROCEDURE DICTIONARY.
;
FLIPBYT1 MOVE.W -(A0),D2
 MOVE.B (A0)+,(A0)
 MOVE.B D2,-(A0)
 MOVEA.W A0,A1
 SUBA.W (A0),A1
 MOVEQ #3,D2
;
; FLIP THE TABLE OF ATTRIBUTES.
;
FLIPBYT2 MOVE.W -(A1),D3
 MOVE.B (A1)+,(A1)
 MOVE.B D3,-(A1)
 DBF D2,FLIPBYT2
;
 DBF D1,FLIPBYT1
;
 RTS
;
; CSP UB. CALL THE STANDARD PASCAL PROCEDURE UB.
;
CSPERR TST.B CONFIG
 BMI.L HIGHADDR
 SUBQ.W #2,A4
 BRA XNOTIMP
;
USERCSP CMPI.B #168,D0
 BHI CSPERR
 ADD.B D0,D0
 MOVEA.W @USEROP(PC,D0.W),A0
UCSP1 JMP 0(PC,A0.W)
;
USEROP DC.W TAN-UCSP1 ;128
 DC.W PTRACE-UCSP1 ;129
 DC.W SYSCMD-UCSP1 ;130
 DC.W SYSINFO-UCSP1 ;131
 DC.W INC1-UCSP1 ;132
 DC.W DEC1-UCSP1 ;133
 DC.W INCN-UCSP1 ;134
 DC.W DECN-UCSP1 ;135
 DC.W DUPI-UCSP1 ;136
 DC.W COMMENT-UCSP1 ;137
 DC.W DFLT-UCSP1 ;138
 DC.W DFLO-UCSP1 ;139
 DC.W DFLTR-UCSP1 ;140
 DC.W DFLOR-UCSP1 ;141
 DC.W DTNC-UCSP1 ;142
 DC.W DRND-UCSP1 ;143
 DC.W SINGLE-UCSP1 ;144
 DC.W DABS-UCSP1 ;145
 DC.W DNEG-UCSP1 ;146
 DC.W DADD-UCSP1 ;147
 DC.W DSUB-UCSP1 ;148
 DC.W DMUL-UCSP1 ;149
 DC.W DDIV-UCSP1 ;150
 DC.W DSQR-UCSP1 ;151
 DC.W DSQRT-UCSP1 ;152
 DC.W DEXP-UCSP1 ;153
 DC.W DPWROF10-UCSP1 ;154
 DC.W DPWROF2-UCSP1 ;155
 DC.W DLN-UCSP1 ;156
 DC.W DLG-UCSP1 ;157
 DC.W DLOG2-UCSP1 ;158
 DC.W DSIN-UCSP1 ;159
 DC.W DCOS-UCSP1 ;160
 DC.W DTAN-UCSP1 ;161
 DC.W DARCTAN-UCSP1 ;162
 DC.W DREAD-UCSP1 ;163
 DC.W DWRITE-UCSP1 ;164
 DC.W EXP10-UCSP1 ;165
 DC.W EXP2-UCSP1 ;166
 DC.W LOG2-UCSP1 ;167
 DC.W DCONST-UCSP1 ;168
;
SPECIAL CMPI.B #194,D0
 BHI CSPERR
 SUBI.B #192,D0
 MOVEA.W @SPECOP(PC,D0.W),A0
SCSP JMP 0(PC,A0.W)
;
SPECOP DC.W CODEREAD-SCSP ;96
 DC.W INFOREAD-SCSP ;97
;
CSP MOVE.B (A4)+,D0
 BMI USERCSP
 ADD.B D0,D0
 BMI SPECIAL
 MOVEA.W @SUBOP(PC,D0.W),A0
CSP1 JMP 0(PC,A0.W)
;
; STANDARD PASCAL PROCEDURES
;
SUBOP DC.W IOCHECK-CSP1 ; 0
 DC.W NEW-CSP1 ; 1
 DC.W MVL-CSP1 ; 2
 DC.W MVR-CSP1 ; 3
 DC.W EXIT-CSP1 ; 4
 DC.W UNITREAD-CSP1 ; 5
 DC.W UNITWRTE-CSP1 ; 6
 DC.W IDS-CSP1 ; 7
 DC.W TRS-CSP1 ; 8
 DC.W TIM-CSP1 ; 9
 DC.W FLC-CSP1 ;10
 DC.W SCN-CSP1 ;11
 DC.W UNITSTAT-CSP1 ;12
 DC.W CSPERR-CSP1 ;13
 DC.W CSPERR-CSP1 ;14
 DC.W CSPERR-CSP1 ;15
 DC.W CSPERR-CSP1 ;16
 DC.W CSPERR-CSP1 ;17
 DC.W CSPERR-CSP1 ;18
 DC.W CSPERR-CSP1 ;19
 DC.W CSPERR-CSP1 ;20
 DC.W LOADSEG-CSP1 ;21
 DC.W FREESEG-CSP1 ;22
 DC.W TNC-CSP1 ;23
 DC.W RND-CSP1 ;24
 DC.W SIN-CSP1 ;25
 DC.W COS-CSP1 ;26
 DC.W LOG-CSP1 ;27
 DC.W ARCTAN-CSP1 ;28
 DC.W LN-CSP1 ;29
 DC.W EXP-CSP1 ;30
 DC.W SQRT-CSP1 ;31
 DC.W MRK-CSP1 ;32
 DC.W RLS-CSP1 ;33
 DC.W IORESULT-CSP1 ;34
 DC.W UNITBUSY-CSP1 ;35
 DC.W POT-CSP1 ;36
 DC.W UNITWAIT-CSP1 ;37
 DC.W UNITCLR-CSP1 ;38
 DC.W XHLTBPT-CSP1 ;39
 DC.W MEMAVAIL-CSP1 ;40
;
; LOAD RESIDENT SEGMENT
;
LOADSEG MOVE.W (SP),D0
 BSR INVOKE
 BNE LOADSEG1
 ADDQ.W #2,SP
 JMP (A2)
;
LOADSEG1 MOVE.W (SP)+,D0
 MOVE.W D0,D1
 ADD.W D1,D1
 LEA @PROCDIC(PC),A0
 MOVEA.W 0(A0,D1.W),A0
 CMP.B (A0),D0
 BNE LOADERR
 LEA @SEX(PC),A0
 TST.B 0(A0,D0.W)
 BNE LOADSEG2
 BSR FLIPBYTE
LOADSEG2 JMP (A2)
;
LOADERR SUBQ.W #2,SP
 SUBQ.W #2,A4
 BRA XNOPROC
;
; UNLOAD RESIDENT SEGMENT
;
FREESEG MOVE.W (SP)+,D0
 BSR FREESEG1
 JMP (A2)
;
FREESEG1 ADD.W D0,D0
 BEQ FREESEG2
 LEA @SEGCOUNT(PC),A1
 SUBQ.W #1,0(A1,D0.W)
 BNE FREESEG2
 LEA SEGTABLE,A1
 MOVE.W D0,D1
 ADD.W D0,D1
 ADD.W D0,D1
 ADDA.W 4(A1,D1.W),A6
FREESEG2 RTS
;
; SEGMENT USAGE COUNT TABLE
;
SEGCOUNT DS.W 64
;
; MEMAVAIL. RETURNS THE NUMBER OF FREE WORDS
; BETWEEN PROGRAM STACK AND HEAP.
;
MEMAVAIL MOVE.W A6,D2
 MOVE.W GDIRP,D1
 BEQ MEMAVL1
 SUB.W D1,D2
 LSR.W #1,D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
MEMAVL1 SUB.W D7,D2
 LSR.W #1,D2
 MOVE.W D2,-(SP)
 JMP (A2)
;
; RNP DB. RETURN FROM NON-BASE PROCEDURE. DB IS THE
; NUMBER OF WORDS THAT SHOULD BE RETURNED AS A
; FUNCTION VALUE (0 FOR PROCEDURES, 1 FOR NON-REAL
; FUNCTIONS, AND 2 FOR REAL FUNCTIONS). COPY DB
; WORDS FROM THE BOTTOM OF THE CURRENT PROCEDURE'S
; ACTIVATION RECORD, AND PUSH THEM ONTO THE EVALUA-
; TION STACK. USE THE INFORMATION IN THE CUR-
; RENT MARKSTACK TO RESTORE THE CALLING PROCEDURE'S
; CORRECT ENVIRONMENT.
;
RNP MOVEA.W 10(A3),SP
RNP1 MOVEA.W -2(A3),A6
 LEA 2(A3),A0
 MOVEA.W (A0)+,A3
 MOVE.W A3,LASTMP
 MOVE.W (A0)+,D6
 BTST #1,FLAVOR
 BNE RNP1A
 MOVE.W D6,JTAB
RNP1A CMP.W (A0)+,D5
 BEQ RNP2
 MOVEA.W D5,A1
 MOVE.B (A1),D0
 BSR FREESEG1
 MOVE.W -2(A0),D5
 BTST #1,FLAVOR
 BNE RNP1B
 MOVE.W D5,SEG
RNP1B MOVEA.W D5,A1
 MOVE.B (A1),D0
 BSR LOADSEX
RNP2 CLR.W D1
 MOVE.B (A4)+,D1 ;GET UB
 MOVEA.W (A0)+,A4 ;RESTORE IPC
 MOVE.W D1,D2
 BEQ RNPEXIT ;SKIP IF NO RESULT
 ADD.W D2,D2
 LEA 2(A0,D2.W),A0
 SUBQ.W #1,D1
;
RNP3 MOVE.W -(A0),-(SP) ;COPY RESULT
 DBF D1,RNP3
;
RNPEXIT TST.W (A6) ;RETURN TO MCODE?
 BEQ MRETURN
 JMP (A2) ;RETURN TO P-CODE
;
MRETURN MOVEA.L (A6)+,A4 ;RESTORE IPC
 MOVEA.L (A6)+,A0
 JMP (A0) ;RETURN TO M-CODE
;
; RBP DB. RETURN FROM BASE PROCEDURE. MOVE THE
; SAVED BASE INTO THE BASE REGISTER, AND THEN
; PROCEED AS IN THE RNP INSTRUCTION.
;
RBP MOVEA.W 10(A3),SP
 MOVEA.W (SP)+,A5
 MOVE.W A5,STKBASE
 BRA RNP1
;
; XIT. EXIT THE OPERATING SYSTEM. DO A "COLD BOOT"
; OF THE SYSTEM, LIKE THE OPERATING SYSTEM'S H(ALT
; COMMAND.
;
XIT BRA.L XITOS
;
; EXIT. EXIT FROM PROCEDURE. TOS IS THE PROCEDURE
; NUMBER, TOS-1 IS THE SEGMENT NUMBER.
;
EXIT CLR.W D1
 MOVE.W (SP)+,D1
 MOVE.W (SP)+,D0
;
; FIRST, SET IPC TO POINT TO THE EXIT CODE OF THE
; CURRENTLY EXECUTING PROCEDURE.
;
 MOVEA.W D6,A0
 TST.B 1(A0)
 BMI XIT
 LEA -4(A0),A4
 SUBA.W (A4),A4
;
; THEN, IF THE CURRENT PROCEDURE IS THE ONE TO
; EXIT FROM, RETURN CONTROL TO THE INSTRUCTION
; FETCH LOOP.
;
 MOVEA.W A3,A1
 CMP.B (A0),D1
 BNE EXIT2
 MOVEA.W D5,A0
 CMP.B (A0),D0
 BNE EXIT2
 JMP (A2)
;
; OTHERWISE, CHANGE THE IPC OF EACH MARKSTACK TO
; POINT TO THE EXIT CODE OF THE PROCEDURE THAT
; INVOKED IT, UNTIL THE DESIRED PROCEDURE IS FOUND.
;
EXIT1 MOVEA.W 2(A1),A1
EXIT2 MOVEA.W 4(A1),A0
 TST.B 1(A0)
 BMI EXITERR
 SUBQ.W #4,A0
 SUBA.W (A0),A0
 MOVE.W A0,8(A1)
 MOVEA.W 4(A1),A0
 CMP.B (A0),D1
 BNE EXIT1
 MOVEA.W 6(A1),A0
 CMP.B (A0),D0
 BNE EXIT1
 JMP (A2)
;
; IF AT ANY TIME THE SAVED IPC OF MAIN BODY OF THE
; OPERATING SYSTEM IS ABOUT TO BE CHANGED, GIVE AN
; EXECUTION ERROR.
;
EXITERR SUBQ.W #4,SP
 BRA XNOEXIT
;
;**************************************************
;*
;* SYSTEM SUPPORT PROCEDURES
;*
;**************************************************
;
;******** BYTE-ARRAY PROCEDURES ********
;
; FLC. FILLCHAR(DST, LEN, CHAR). TOS (CHAR) IS THE
; SOURCE CHARACTER. TOS-1 (LEN) IS THE NUMBER OF
; BYTES IN THE DESTINATION ARRAY WHICH ARE TO BE
; FILLED WITH THE SOURCE CHAR. TOS-2 (DST) IS A
; BYTE POINTER TO THE FIRST BYTE TO BE FILLED IN
; THE DESTINATION PACKED ARRAY OF CHARACTERS. COPY
; THE CHARACTER FROM TOS INTO TOS-1 CHARACTERS OF
; THE DESTINATION ARRAY.
;
FLC MOVE.W (SP)+,D0
 MOVE.W (SP)+,D1
 BLE FLCNOT
 MOVE.W (SP)+,D2
 ADD.W (SP)+,D2
 MOVEA.W D2,A0
 ANDI.B #1,D2
 BEQ FLC1
 MOVE.B D0,(A0)+
 SUBQ.W #1,D1
FLC1 MOVE.W D1,D2
 ANDI.W #3,D2
 LSR.W #2,D1
 BEQ FLC4
 MOVE.B D0,(A0)+
 MOVE.B D0,(A0)+
 MOVE.B D0,(A0)+
 MOVE.B D0,(A0)+
 MOVE.L -(A0),D3
 ADDQ.W #4,A0
 SUBQ.W #2,D1
 BCS FLC4
;
FLC2 MOVE.L D3,(A0)+
 DBF D1,FLC2
;
 BRA FLC4
;
FLC3 MOVE.B D0,(A0)+
FLC4 DBF D2,FLC3
;
 JMP (A2)
;
FLCNOT ADDQ.W #4,SP
 JMP (A2)
;
; SCN. SCAN(MAXDISP, MASK, CHAR, START, FORPAST).
; TOS (FORPAST) IS A TWO-BYTE QUANTITY (USUALLY THE
; DEFAULT INTEGER 0) WHICH IS PUSHED, BUT LATER
; DISCARDED WITHOUT BEING USED IN THIS IMPLEMENTA-
; TION. TOS-1 (START) IS A BYTE POINTER TO THE
; FIRST CHARACTER TO BE SCANNED IN A PACKED ARRAY
; OF CHARACTERS. TOS-2 (CHAR) IS THE CHARACTER
; AGAINST WHICH EACH SCANNED CHARACTER OF THE
; ARRAY IS TO BE CHECKED. TOS-3 (MASK) IS 0 IF THE
; CHECK IS FOR EQUALITY, OR 1 IF THE CHECK IS FOR
; INEQUALITY. TOS-4 (MAXDISPLACEMENT) GIVES THE
; MAXIMUM NUMBER OF CHARACTERS TO BE SCANNED (SCAN
; TO THE LEFT F NEGATIVE). IF A CHARACTER CHECK
; YIELDS TRUE, PUSH THE NUMBER OF CHARACTERS
; SCANNED (NEGATIVE, IF SCANNING TO THE LEFT). IF
; MAXDISP IS REACHED BEFORE CHARACTER CHECK YIELDS
; TRUE, PUSH MAXDISP.
;
SCN ADDQ.W #2,SP
 MOVE.W (SP)+,A0
 ADDA.W (SP)+,A0
 MOVE.W (SP)+,D0
 TST.W (SP)+
 BNE SCNNE
 MOVE.W (SP)+,D1
 MOVE.W D1,D2
 BMI SCNLEQ
;
SCNREQ CMP.B (A0)+,D0
 DBEQ D1,SCNREQ
;
 BNE SCNREQ1
 SUB.W D1,D2
SCNREQ1 MOVE.W D2,-(SP)
 JMP (A2)
;
SCNLEQ NEG.W D1
 ADDQ.W #1,A0
;
SCNLEQ1 CMP.B -(A0),D0
 DBEQ D1,SCNLEQ1
;
 BNE SCNLEQ2
 ADD.W D1,D2
SCNLEQ2 MOVE.W D2,-(SP)
 JMP (A2)
;
SCNNE MOVE.W (SP)+,D1
 MOVE.W D1,D2
 BMI SCNLNE
;
SCNRNE CMP.B (A0)+,D0
 DBNE D1,SCNRNE
;
 BEQ SCNRNE1
 SUB.W D1,D2
SCNRNE1 MOVE.W D2,-(SP)
 JMP (A2)
;
SCNLNE NEG.W D1
 ADDQ.W #1,A0
;
SCNLNE1 CMP.B -(A0),D0
 DBNE D1,SCNLNE1
;
 BEQ SCNLNE2
 ADD.W D1,D2
SCNLNE2 MOVE.W D2,-(SP)
 JMP (A2)
;
; MVL. MOVELEFT(SRC, DST, NUMBYTES). TOS (NUMBYTES)
; GIVES THE NUMBER OF BYTES TO MOVE. TOS-1 (DST) IS
; A BYTE POINTER TO THE DESTINATION ARRAY'S FIRST
; BYTE WHICH WILL RECEIVE A MOVED BYTE. TOS-2 (SRC)
; IS A BYTE POINTER TO THE SOURCE ARRAY'S FIRST
; BYTE WHICH WILL BE MOVED. COPY TOS BYTES FROM THE
; SOURCE ARRAY TO THE DESTINATION ARRAY, PROCEEDING
; TO THE RIGHT THROUGH BOTH ARRAYS.
;
MVL MOVE.W (SP)+,D1
 BLE MVNOT
 MOVE.W (SP)+,D2
 ADD.W (SP)+,D2
 MOVE.W (SP)+,D3
 ADD.W (SP)+,D3
 MOVEA.W D2,A1
 MOVEA.W D3,A0
 SUB.W D3,D2
 LSR.W #1,D2
 BCS MVL5
 SUBQ.W #1,D2
 BEQ MVL5
 LSR.W #1,D3
 BCC MVL1
 MOVE.B (A0)+,(A1)+
 SUBQ.W #1,D1
MVL1 MOVE.W D1,D2
 LSR.W #2,D1
 BRA MVL3
;
MVL2 MOVE.L (A0)+,(A1)+
MVL3 DBF D1,MVL2
;
 MOVE.W D2,D1
 ANDI.W #3,D1
 BRA MVL5
;
MVL4 MOVE.B (A0)+,(A1)+
MVL5 DBF D1,MVL4
;
 JMP (A2)
;
MVNOT ADDQ.W #8,SP
 JMP (A2)
;
; MVR. MOVERIGHT(SRC, DST, NUMBYTES). TOS (NUM-
; BYTES) GIVES THE NUMBER OF BYTES TO MOVE. TOS-1
; (DST) IS A BYTE POINTER TO THE DESTINATION
; ARRAY'S FIRST BYTE WHICH WILL RECEIVE A MOVED
; BYTE. TOS-2 (SRC) IS A BYTE POINTER TO THE SOURCE
; ARRAY'S FIRST BYTE WHICH WILL BE MOVED. COPY TOS
; BYTES FROM THE SOURCE ARRAY TO THE DESTINATION
; ARRAY, PROCEEDING TO THE LEFT THROUGH BOTH
; ARRAYS.
;
MVR MOVE.W (SP)+,D1
 BLE MVNOT
 MOVE.W (SP)+,D2
 ADD.W (SP)+,D2
 MOVE.W (SP)+,D3
 ADD.W (SP)+,D3
 ADD.W D1,D2
 ADD.W D1,D3
 MOVEA.W D2,A1
 MOVEA.W D3,A0
 SUB.W D2,D3
 LSR.W #1,D3
 BCS MVR5
 SUBQ.W #1,D3
 BEQ MVR5
 LSR.W #1,D2
 BCC MVR1
 MOVE.B -(A0),-(A1)
 SUBQ.W #1,D1
MVR1 MOVE.W D1,D2
 LSR.W #2,D1
 BRA MVR3
;
MVR2 MOVE.L -(A0),-(A1)
MVR3 DBF D1,MVR2
;
 MOVE.W D2,D1
 ANDI.W #3,D1
 BRA MVR5
;
MVR4 MOVE.B -(A0),-(A1)
MVR5 DBF D1,MVR4
;
 JMP (A2)
;
; PROCEDURE PTRACE;
;
PTRACE MOVE.W (SP)+,D1 ;POP SET
 ADD.W D1,D1
 ADDA.W D1,SP
 JMP (A2)
;
; PROCEDURE SYSCMD (I, J: INTEGER);
;
SYSCMD ADDQ.W #4,SP
 JMP (A2)
;
; FUNCTION SYSINFO (I, J: INTEGER): INTEGER;
;
SYSINFO MOVE.L (SP)+,D1
 MOVE.W #0,-(SP)
 JMP (A2)
;
; INCREMENT (TOS) BY 1.
;
INC1 MOVEA.W (SP)+,A0
 ADDQ.W #1,(A0)
 JMP (A2)
;
; DECREMENT (TOS) BY 1.
;
DEC1 MOVEA.W (SP)+,A0
 SUBQ.W #1,(A0)
 JMP (A2)
;
; INCREMENT (TOS-1) BY TOS.
;
INCN MOVE.W (SP)+,D1
 MOVEA.W (SP)+,A0
 ADD.W D1,(A0)
 JMP (A2)
;
; DECREMENT (TOS-1) BY TOS.
;
DECN MOVE.W (SP)+,D1
 MOVEA.W (SP)+,A0
 SUB.W D1,(A0)
 JMP (A2)
;
; DUPLICATE TOS ON THE STACK.
;
DUPI MOVE.W (SP),-(SP)
 JMP (A2)
;
; SKIP COMMENT (WORD ALIGNED).
;
COMMENT MOVE.W A4,D1
 ADDQ.W #1,D1
 ANDI.W #$FFFE,D1
 MOVEA.W D1,A4
 ADDA.W (A4)+,A4
 JMP (A2)
;
;******** COMPILER PROCEDURES ********
;
; BPT B. BREAKPOINT. INSERT B INTO THE HALTLINE
; FIELD AND CALL THE DEBUGGING ROUTINE IF B IS
; CONTAINED IN THE LIST OF SET BREAKPOINTS. THE
; DEBUGGING ROUTINE IS CALLED UNCONDITIONALLY IF
; THE FIRST LIST ENTRY CONTAINS A NEGATIVE VALUE.
;
BPT CLR.W D1
 MOVEA.W A4,A1
 MOVE.B (A4)+,D1
 BPL BPT1
 ADD.B D1,D1
 ASL.W #7,D1
 MOVE.B (A4)+,D1
BPT1 MOVE.W D1,HLTLINE
 LEA BRKPTS,A0
 TST.W (A0)
 BMI BPT3
 MOVEQ #15,D2
;
BPT2 CMP.W (A0)+,D1
 DBEQ D2,BPT2
;
 BEQ BPT3
 JMP (A2)
;
BPT3 LEA -1(A1),A4
 BRA XPRGBPT
;
; TRS. TREESEARCH(FCP, FCP2, NAME). TOS-2 (FCP) IS
; A BYTE POINTER TO THE ROOT OF A BINARY TREE. TOS
; (NAME) IS A BYTE POINTER TO A LOCATION WHICH CON-
; TAINS THE ADDRESS OF AN 8-CHARACTER NAME THAT YOU
; WISH TO FIND OR TO PLACE IN THE TREE. SEARCH THE
; TREE, LOOKING FOR A RECORD WITH THE REQUIRED
; NAME. STORE THE ADDRESS OF THE LAST NODE VISITED,
; ON COMPLETION OF THE SEARCH, INTO THE LOCATION
; POINTED TO BY BYTE POINTER TOS-1 (FCP2), AND PUSH
; THE RESULT OF THE SEARCH:
;
;     0   IF THE LAST NODE WAS A RECORD WITH THE
;         SEARCH NAME,
;
;     1   IF THE SEARCH NAME SHOULD BE A NEW
;         RECORD, ATTACHING TO THE LAST TREE NODE
;         BY THE RIGHT LINK,
;
;    -1   IF THE SEARCH NAME SHOULD BE A NEW
;         RECORD, ATTACHING TO THE LAST TREE NODE
;         BY THE LEFT LINK.
;
; THIS IS AN ASSEMBLY-LANGUAGE BINARY TREE SEARCH
; USED BY THE COMPILER. IT IS FAST, BUT DOES NOT DO
; TYPE CHECKING ON THE PARAMETERS. THE BINARY TREE
; USES NODES OF TYPE
;
;      CTP = RECORD
;               NAME: PACKED ARRAY [1..8] OF CHAR;
;               LLINK, RLINK: ^CTP;
;               ...
;               OTHER INFORMATION
;               ...
;            END;
;
TRS MOVEA.W (SP)+,A0
 MOVE.L (A0)+,D1
 MOVE.L (A0)+,D2
 MOVEA.W (SP)+,A1
 MOVEA.W (SP)+,A0
;
TRSEARCH CMP.L (A0),D1
 BNE TRSNEQ
 CMP.L 4(A0),D2
 BEQ TRSFOUND
TRSNEQ BCS TRSLEFT
 MOVE.W 8(A0),D3
 BEQ TRSRLINK
 MOVEA.W D3,A0
 BRA TRSEARCH
;
TRSLEFT MOVE.W 10(A0),D3
 BEQ TRSLLINK
 MOVEA.W D3,A0
 BRA TRSEARCH
;
TRSFOUND MOVE.W #0,-(SP)
 MOVE.W A0,(A1)
 JMP (A2)
;
TRSRLINK MOVE.W #1,-(SP)
 MOVE.W A0,(A1)
 JMP (A2)
;
TRSLLINK MOVE.W #-1,-(SP)
 MOVE.W A0,(A1)
 JMP (A2)
;
; IDSEARCH. USED BY THE COMPILER TO PARSE RESERVED
; WORDS AND IDENTIFIERS.
;
IDS MOVEA.W (SP)+,A0
 MOVEA.W (SP),A1
 ADDA.W (A1),A0
 MOVE.L #$20202020,D1
 MOVE.L D1,-(SP)
 MOVE.L D1,-(SP)
 MOVEQ #0,D0
 MOVE.B (A0)+,D2
 CMPI.B #'a',D2
 BCS IDS1
 CMPI.B #'z',D2
 BHI.L IDSNEQ
 SUB.B D1,D2
 BRA IDS2
;
IDS1 CMPI.B #'A',D2
 BCS IDSNEQ
 CMPI.B #'Z',D2
 BHI IDSNEQ
IDS2 MOVEA.W SP,A1
 MOVE.B D2,(A1)+
 MOVEQ #7,D3
 SUBQ.B #1,D0
;
IDS3 ADDQ.B #1,D0
 MOVE.B (A0)+,D4
 CMPI.B #'a',D4
 BCS IDS4
 CMPI.B #'z',D4
 BHI IDSEARCH
 SUB.B D1,D4
 BRA IDS6
;
IDS4 CMPI.B #'A',D4
 BCS IDS5
 CMPI.B #'Z',D4
 BLS IDS6
 CMPI.B #'_',D4
 BEQ IDS3
IDS5 CMPI.B #'0',D4
 BCS IDSEARCH
 CMPI.B #'9',D4
 BHI IDSEARCH
IDS6 TST.B D3
 BEQ IDS3
 SUBQ.B #1,D3
 MOVE.B D4,(A1)+
 BRA IDS3
;
IDSEARCH SUBI.B #'A',D2
 EXT.W D2
 ADD.W D2,D2
 ADD.W D2,D2
 MOVEA.L @IDTABLE(PC,D2.W),A0
 MOVE.W (A0)+,D1
 BEQ IDSNEQ
 SUBQ.W #1,D1
 MOVE.L (SP),D2
 MOVE.L 4(SP),D3
;
IDS7 CMP.L (A0),D2
 BNE IDS8
 CMP.L 4(A0),D3
 BEQ IDSFOUND
IDS8 LEA 12(A0),A0
 DBF D1,IDS7
;
IDSNEQ MOVEA.W 8(SP),A1
 ADD.W D0,(A1)+
 MOVEQ #$15,D0
 MOVE.L D0,(A1)+
 MOVE.L (SP)+,(A1)+
 MOVE.L (SP)+,(A1)+
 ADDQ.W #2,SP
 JMP (A2)
;
IDSFOUND ADDQ.W #8,SP
 MOVEA.W (SP)+,A1
 ADD.W D0,(A1)+
 CLR.W D0
 MOVE.L 8(A0),(A1)+
 JMP (A2)
;
IDTABLE DC.L A
 DC.L B
 DC.L C
 DC.L D
 DC.L E
 DC.L F
 DC.L G
 DC.L NOENTRY
 DC.L I
 DC.L NOENTRY
 DC.L NOENTRY
 DC.L L
 DC.L M
 DC.L N
 DC.L O
 DC.L P
 DC.L NOENTRY
 DC.L R
 DC.L S
 DC.L T
 DC.L U
 DC.L V
 DC.L W
 DC.L NOENTRY
 DC.L NOENTRY
 DC.L NOENTRY
;
NOENTRY DC.W 0
;
A DC.W 2
 ASC 'AND     '
 DC.W $27,2
 ASC 'ARRAY   '
 DC.W $2C,0
;
B DC.W 1
 ASC 'BEGIN   '
 DC.W $13,0
;
C DC.W 2
 ASC 'CASE    '
 DC.W $15,0
 ASC 'CONST   '
 DC.W $1C,0
;
D DC.W 3
 ASC 'DO      '
 DC.W 6,0
 ASC 'DIV     '
 DC.W $27,3
 ASC 'DOWNTO  '
 DC.W 8,0
;
E DC.W 3
 ASC 'END     '
 DC.W 9,0
 ASC 'ELSE    '
 DC.W $D,0
 ASC 'EXTERNAL'
 DC.W $35,0
;
F DC.W 4
 ASC 'FOR     '
 DC.W $18,0
 ASC 'FILE    '
 DC.W $2E,0
 ASC 'FUNCTION'
 DC.W $20,0
 ASC 'FORWARD '
 DC.W $22,0
;
G DC.W 1
 ASC 'GOTO    '
 DC.W $1A,0
;
I DC.W 4
 ASC 'IF      '
 DC.W $14,0
 ASC 'IN      '
 DC.W $29,$E
 ASC 'IMPLEMEN'
 DC.W $34,0
 ASC 'INTERFAC'
 DC.W $33,0
;
L DC.W 1
 ASC 'LABEL   '
 DC.W $1B,0
;
M DC.W 1
 ASC 'MOD     '
 DC.W $27,4
;
N DC.W 1
 ASC 'NOT     '
 DC.W $26,0
;
O DC.W 2
 ASC 'OF      '
 DC.W $B,0
 ASC 'OR      '
 DC.W $28,7
;
P DC.W 3
 ASC 'PROCEDUR'
 DC.W $1F,0
 ASC 'PACKED  '
 DC.W $2B,0
 ASC 'PROGRAM '
 DC.W $21,0
;
R DC.W 2
 ASC 'REPEAT  '
 DC.W $16,0
 ASC 'RECORD  '
 DC.W $2D,0
;
S DC.W 2
 ASC 'SET     '
 DC.W $2A,0
 ASC 'SEGMENT '
 DC.W $21,0
;
T DC.W 3
 ASC 'THEN    '
 DC.W $C,0
 ASC 'TO      '
 DC.W 7,0
 ASC 'TYPE    '
 DC.W $1D,0
;
U DC.W 3
 ASC 'UNTIL   '
 DC.W $A,0
 ASC 'USES    '
 DC.W $31,0
 ASC 'UNIT    '
 DC.W $32,0
;
V DC.W 1
 ASC 'VAR     '
 DC.W $1E,0
;
W DC.W 2
 ASC 'WHILE   '
 DC.W $17,0
 ASC 'WITH    '
 DC.W $19,0
;
;******** MISCELLANEOUS ********
;
; TIM. TIME. POP TWO POINTERS TO TWO INTEGERS, AND
; PLACE IN THOSE INTEGERS A 32-BIT INDICATION OF
; THE CURRENT TIME.
;
TIM BSR.L TIME
 TST.B D1
 BMI TIMEBRK
 MOVE.W D1,IORSLT
TIMEX JMP (A2)
;
TIMEBRK BTST #NOBREAK,MISCINFO+1
 BNE TIMEX
 SUBQ.W #2,A4
 BRA XUBREAK
;
 CHAIN RSP,S5,D1
