; ide.device read/write-routines     version 1.2 February 1998
; support for ATAPI devices and two drives support added 10.9.2000

; ! set tabs to 3 !

TRUE	equ	1
FALSE	equ	0
LOOP		equ	150000		; timeout value for ATA - motor is on
LOOP2		equ	5000000		; timeout value for ATA - motor is off
LOOP3		equ	10000			; timeout value for ATAPI

;Configuration:
	cnop	0,4
	PUBLIC	buffer
buffer			ds.b	512		;buffer for ATA/ATAPI IDENTIFY DRIVE

	xref	_LVOAllocSignal		;external references
	xref	_LVOSignal				;these will be linked from amiga.lib
	xref	_LVOWait
	xref	_LVOFindTask

   include	"exec/io.i"
	include	"exec/types.i"
	include "exec/lists.i"
	include "exec/libraries.i"
	include "exec/devices.i"
	include "exec/io.i"
	include "exec/tasks.i"
   include	"atid500.i"			; defines the Hardware Address of the interface
   include	"ata.i"				; defines ATA bits and commands
	include	"devices/scsidisk.i"
	include	"dodata.i"			; macros for read and write 512 bytes
	include	"mydev.i"

DLY400NS macro						;wait 400 nanoseconds
	movem.l	d0/d1,-(sp)
	move.l	#4,d0
atst\@
	move.b	TF_ALTERNATE_STATUS,d1
	dbra		d0,atst\@
	movem.l   (sp)+,d0/d1
	endm

DLY5US macro ;wait 5 microseconds
   move.l   d0,-(sp)
   move.l   #9,d0
lihkhv\@
   sub.l    #1,d0
   bne      lihkhv\@
   move.l   (sp)+,d0
  endm


;CMD_READ    equ 2       ;these are defined better in "exec/io.i"
IOM_COMMAND  equ $1c

;some of the error codes rdwt.asm returns:
BADLENGTH   equ -4
BADUNIT     equ -1


   Public   ATIDRdWt
ATIDRdWt:
   ;a0 io data address
   ;a1 iob 
   ;a2 == a1
	;a3 unitptr
   ;d0 io length
   ;d1 io offset
   ;d2 unit number
   movem.l  d1-d7/a0-a6,-(sp)
	bsr		SelectDrive
	beq		errcode
   move.l   d0,d3
   move.l   #BADUNIT,d0			;Check that unit is 0 or 1
	move.l	d2,d4
	and.l		#$FFFFFFFE,d4
   bne      Quits
   move.l   #BADLENGTH,d0		;Check if length is multiple of 512
   move.l   d3,d4
   and.l    #$1ff,d4
   bne      Quits
   lsr.l    #8,d3
   lsr.l    #1,d3					;Number of sectors
   move.l   #BADLENGTH,d0		;No sectors ?
   cmp.l    #0,d3
   beq      Quits
   lsr.l    #8,d1
   lsr.l    #1,d1					;Start block
   move.l   a0,a5
   move.l   d1,d6
   move.l   d3,d7
jooei									;a2 = iob !
   bsr      doblocks				;a5:startaddress, d6:startblock, d7:numberofblocks
Quits
   cmp.l    #0,d0
   bne      errcode
okcode
   movem.l  (sp)+,d1-d7/a0-a6
   rts								;EXIT RDWT.ASM
errcode
   bset.b   #1,$bfe001			;Amiga power led off
	cmp.l		#ATA_DRV,mdu_drv_type(a3)
	bne		Quits
	move.l	mdu_UnitNum(a3),d0	;Reset drive - some drives may freeze at bad block
	lsl.b		#4,d0
	or.b		#$a0,d0
	move.b	d0,TF_DRIVE_HEAD
	DLY5US
	WATA		#8+SRST+nIEN,TF_DEVICE_CONTROL	;no int., reset ;nIEN=2 SRST=4
	bsr		pause
	WATA		#8+nIEN,TF_DEVICE_CONTROL
	bsr		pause
   bclr.b   #1,$bfe001			;Amiga power led on
	bsr		waitnotbusy1
	move.l	#1,d0
	bra		okcode
	


	PUBLIC	wasfirstcall
wasfirstcall											;a3 = unitptr
	movem.l	a0/a1/a5,-(sp)
	RATA		TF_STATUS,d0							;clear drive interrupt line
	move.l	#FALSE,mdu_firstcall(a3)

	cmp.l		#TRUE,mdu_auto(a3)
	bne		notauto

;get drive parameters
	move.l	#FALSE,mdu_lba(a3)					;presumption
	bsr		SelectDrive
	WATA		#ATA_IDENTIFY_DRIVE,TF_COMMAND	;get drive data
	bsr		waitnotbusy1
	beq		wfc1
	move.b	TF_STATUS,d0
	and.b		#ERR,d0									;atapi drive abort this command
	beq		atadrv									;and set CYLH to EBh and
	cmp.b		#$EB,TF_CYLINDER_HIGH				;CYLL to 14h
	bne		wfc1
	cmp.b		#$14,TF_CYLINDER_LOW
	beq		wfc2
wfc1
	move.l	#UNKNOWN_DRV,mdu_drv_type(a3)
	bra		kr2
wfc2
	WATA		#IDENTIFY_PACKET_DEVICE,TF_COMMAND	;get atapi drive data
	bsr		waitdrq1
	beq		wfc1
	move.l	#ATAPI_DRV,mdu_drv_type(a3)
	move.l	#TRUE,mdu_lba(a3)
	clr.l		mdu_sectors_per_track(a3)
	clr.l		mdu_heads(a3)
	clr.l		mdu_cylinders(a3)
	bra		kr3
atadrv
	move.l	#ATA_DRV,mdu_drv_type(a3)	;ata drive
kr3
	lea		buffer,a5						;get identify data
	bsr		readdata
	lea		buffer,a5
   ;IF Y=0 SWAP BYTES IN WORD BECAUSE AMIGA DATA0..7 IS DRIVE DATA8.15
	IFEQ Y,0
		move.l	A5,A0			;buffer start
		movem.l	d1-d2,-(sp)	;d1-d2 to stack
		move.w	#256-1,d0	;move.word because dbra uses 16bits of register
lk		move.w	(a0),d1
		move.w	d1,d2
		lsl.w		#8,d1
		lsr.w		#8,d2
		and.w		#$ff,d2
		or.w		d2,d1
		move.w	d1,(a0)+
		dbra		d0,lk
		movem.l	(sp)+,d1-d2	;restore d1-d2
	ENDC

	lea		buffer,a5				;copy serial number to internal info buffer
	add.l		#20,a5
	lea		mdu_ser_num(a3),a0
	move.b	#10,d0
ckl1
	move.w	(a5)+,(a0)+
	subq.b	#1,d0
	bne		ckl1
	move.b	#0,(a0)
	lea		buffer,a5
	add.l		#46,a5
	lea		mdu_firm_rev(a3),a0	;copy firm. revision to int. buffer
	move.b	#4,d0
ckl2
	move.w	(a5)+,(a0)+
	subq.b	#1,d0
	bne		ckl2
	move.b	#0,(a0)
	lea		buffer,a5
	add.l		#54,a5
	lea		mdu_model_num(a3),a0	;copy model number to int. buffer
	move.b	#20,d0
ckl3
	move.w	(a5)+,(a0)+
	subq.b	#1,d0
	bne		ckl3
	move.b	#0,(a0)

	cmp.l		#ATA_DRV,mdu_drv_type(a3)
	beq		noeritd
	WATA		#0,TF_FEATURES			;for atapi cdrom with
	bra		kr2
noeritd
	lea		buffer,a5
	clr.l		d0
	move.w	1*2(a5),d0				;Word 1 Number of logical cylinders
	move.l	d0,mdu_cylinders(a3)	;store to internal buffer
 	move.w	6*2(a5),d0				;Word 6 Default Translation sectors
	and.l		#$ffff,d0
	move.l	d0,mdu_sectors_per_track(a3)	;store to internal buffer
	move.w	3*2(a5),d0				;Word 3 Default Translation Mode number of heads
	and.l		#$ffff,d0
	move.l	d0,mdu_heads(a3)		;store to internal buffer
	move.w	49*2(A5),d0				;Word 49 Capabilities
	and.w		#$200,d0					;Bit 9 1=LBA Supported
	beq		nolba
	move.w	60*2(a5),d0				;Words 60-61 # of user addressable sectors (LBA)
	swap.l	d0
	and.w		61*2(a5),d0
	move.l	d0,mdu_numlba(a3)		;store to internal buffer
	beq		nolba						;propably no lba support if no lba sectors
	move.l	#TRUE,mdu_lba(a3)		;store to internal buffer
	bra		endauto
nolba										;Then it's CHS
	move.l	#FALSE,mdu_lba(a3)	;store to internal buffer
	;Conner Peripherals CP3044 lies about its default translation mode
	lea		CP3044txt,a0
	move.l	a5,a1
	add.l		#$50,a1
ko move.b	(a0)+,d0
	beq		wascp3044
	move.b	(a1)+,d1
	cmp.b		d0,d1
	beq		ko
;not cp3044
	bra		endauto
wascp3044
	move.l	#4,mdu_heads(a3)
	move.l	#40,mdu_sectors_per_track(a3)
	bra		endauto
CP3044txt	dc.b	$43,$50,$33,$30,$34,$34,$20,0	;"CP3044 "
	cnop		0,4
endauto
notauto
	RATA		TF_STATUS,d0					;clear interrupt line
	cmp.l		#ATA_DRV,mdu_drv_type(a3)
	bne		kr2
	move.l	mdu_sectors_per_track(a3),d0	;send to drive which CHS translation
	WATA		d0,TF_SECTOR_COUNT			;to use - important to drives with
	move.l	mdu_heads(a3),d0				;LBA support
	subq.b	#1,d0
	or.b		#$a0,d0
	tst.l		mdu_UnitNum(a3)
	beq		pis1
	bset.b	#4,d0
pis1
	WATA		d0,TF_DRIVE_HEAD
	DLY400NS
	bsr		waitreadytoacceptnewcommand
	WATA		#ATA_INITIALIZE_DRIVE_PARAMETERS,TF_COMMAND	;get drive data
	bsr		waitnotbusy1
kr2
	movem.l	(sp)+,a0/a1/a5
	rts

RWV_READ    equ 11
RWV_WRITE   equ 12
readwrite	dc.l 0
doblocks    ;d7=sectors>0 (A5=startaddress, d6=startblock)
	move.l	#RWV_READ,readwrite
	cmp.w		#CMD_READ,IOM_COMMAND(a2)
	beq		gsfg
	move.l	#RWV_WRITE,readwrite
gsfg
	movem.l	d6-d7/a5,-(sp)
	bsr		dorwv						;first read or write/format
	movem.l	(sp)+,d6-d7/a5
	cmp.l		#0,d0
	rts

dorwv
domore
	move.l	d7,d5
	move.l	d7,d4
	and.l		#$ff,d5
	bne		between1and255
	move.l	#$100,d5					;256 sectors
between1and255
	move.l	d5,d4						;d5 is number of sectors in this round
	cmp.l		#RWV_READ,readwrite
	beq		wasread
	bsr		writesectors			;Format or Write
	cmp.l		#0,d0
	beq		sectoracok
	rts
wasread
	bsr		readsectors
	cmp.l		#0,d0
	beq		sectoracok
	rts
sectoracok
	add.l		d5,d6						;next block number
	sub.l		d5,d7
	bne		domore
	move.l	#0,d0
	rts

;short power led blink
	PUBLIC	blink
blink
	move.l	d0,-(sp)
   bset.b   #1,$bfe001				;Amiga power led off
	move.l	#100000,d0
bl2
	subq.l	#1,d0
	bne		bl2
   bclr.b   #1,$bfe001				;Amiga power led on
	move.l	#100000,d0
bl3
	subq.l	#1,d0
	bne		bl3
	move.l	(sp)+,d0
bl1
	rts

readsectors			;d4 is the number of sectors to read (between 1 and 256)
	bsr		waitreadytoacceptnewcommand
	cmp.l		#0,d0
	bne		rsfl
	move.l	d6,d0						;logical block number
	bsr		issueread
readnextblk
	DLY400NS								;wait for BSY go high (400 ns)
	RATA		TF_STATUS,d0			;Also clears the disabled interrupt
	bsr		waitnotbusy1
	beq		rsfl
	bsr		waitdrq1
	beq		rsfl
	bsr		readdata
	DLY5US								;wait DRQ go 0
	sub.l		#1,d4
	bne		readnextblk
	bsr		checkforerrors
	cmp.l		#0,d0
	bne		rsfl
	move.l	#0,d0						;return value 0 means OK
	rts
rsfl										;some error in reading
	move.l	#1,d0
	rts

writesectors		;d4 is the number of sectors to write (between 1 and 256)
	bsr		waitreadytoacceptnewcommand
	cmp.l		#0,d0
	bne		wekfha
	move.l	d6,d0
	bsr		issuewrite
writenextoneblockki
	bsr		waitdrq1
	beq		wekfha
	bsr		writedata
	DLY5US								;BSY will go high within 5 microseconds after filling buffer
	RATA		TF_STATUS,d0			;Also clears the disabled interrupt
	bsr		waitnotbusy1
	beq		wekfha
	bsr		checkforerrors
	cmp.l		#0,d0
	bne		wekfha
	sub.l		#1,d4
	bne		writenextoneblockki
	rts									;d0==0   ok
wekfha
	move.l	#1,d0
	rts									;some error in writing

checkforerrors
	bsr		waitnotbusy1
	beq		cfe1
	RATA		TF_ALTERNATE_STATUS,d0
	and.l		#DWF+ERR,d0
	rts
cfe1
	move.l	#111,d0
	rts

waitreadytoacceptnewcommand
	move.l	d1,-(sp)
	move.l	#LOOP,d1
	cmp.l		#TRUE,mdu_motor(a3)
	beq		fovc
	move.l	#LOOP2,d1
fovc
	subq.l	#1,d1
	beq		wre1
	bsr		waitnotbusy1
	beq		wre1
	RATA		TF_STATUS,d0
	and.b		#BSY+DRDY+DWF+ERR,d0
	cmp.b		#DRDY,d0
	bne		oiuy
	move.l	#0,d0
	move.l	(sp)+,d1
	rts
oiuy
	and.b		#DWF+ERR,d0
	beq		fovc
wre1
	move.l	(sp)+,d1
	move.l	#-865,d0
	rts

readdata
	RATADATA
	rts

issueread
	cmp.l		#TRUE,mdu_lba(a3)
	beq		issueLBAread
	bsr		getCHS
issueCHSread
	move.l	d0,-(sp)
	move.l	mdu_UnitNum(a3),d0
	lsl.b		#4,d0
	or.b		d2,d0
	or.b		#$a0,d0
	WATA		d0,TF_DRIVE_HEAD
	move.l	(sp)+,d0
	WATA		d4,TF_SECTOR_COUNT
	WATA		d0,TF_CYLINDER_LOW
	WATA		d1,TF_CYLINDER_HIGH
	WATA		d3,TF_SECTOR_NUMBER
	WATA		#ATA_READ_SECTORS,TF_COMMAND
	rts

issueLBAread
	move.l	mdu_UnitNum(a3),d2
	lsl.b		#4,d2
	add.b		#L,d2
	WATA		d2,TF_DRIVE_HEAD				;L=lba  lba bits 24..27
	WATA		d4,TF_SECTOR_COUNT
	WATA		d0,TF_SECTOR_NUMBER			;lba bits 0..7
	lsr.l		#8,d0
	WATA		d0,TF_CYLINDER_LOW 			;lba bits 8..15
	lsr.l		#8,d0
	WATA		d0,TF_CYLINDER_HIGH			;lba bits 16..23
	WATA		#ATA_READ_SECTORS,TF_COMMAND
	rts

writedata
	WATADATA
	rts

issuewrite
	cmp.l		#TRUE,mdu_lba(a3)
	beq		issueLBAwrite
	bsr		getCHS
issueCHSwrite
	move.l	d0,-(sp)
	move.l	mdu_UnitNum(a3),d0
	lsl.b		#4,d0
	or.b		d2,d0
	or.b		#$a0,d0
	WATA		d0,TF_DRIVE_HEAD
	move.l	(sp)+,d0
	WATA		d4,TF_SECTOR_COUNT
	WATA		d0,TF_CYLINDER_LOW
	WATA		d1,TF_CYLINDER_HIGH
	WATA		d3,TF_SECTOR_NUMBER
	WATA		#ATA_WRITE_SECTORS,TF_COMMAND
	rts

issueLBAwrite
	move.l	mdu_UnitNum(a3),d2
	lsl.b		#4,d2
	add.b		#L,d2
	WATA		d2,TF_DRIVE_HEAD				;L=lba; lba bits 24..27
	WATA		d4,TF_SECTOR_COUNT
	WATA		d0,TF_SECTOR_NUMBER			;LBA  bits  0..7
	lsr.l		#8,d0
	WATA		d0,TF_CYLINDER_LOW			;LBA  bits  8..15
	lsr.l		#8,d0
	WATA		d0,TF_CYLINDER_HIGH			;LBA  bits  16..23
	WATA		#ATA_WRITE_SECTORS,TF_COMMAND
	rts

getCHS		;convert block number to Cylinder / Head / Sector numbers
	move.l	d0,d3					;d0 = number of block (block numbers begin from 0)
	move.l	mdu_sectors_per_track(a3),d2
	divu		d2,d3
	swap.l	d3
	add.w		#1,d3					;sector numbers begin at 1
	and.l		#$ff,d3				;sector number byte
	move.l	mdu_sectors_per_track(a3),d2		;d0 = number of block
	divu		d2,d0
	and.l		#$ffff,d0			;16bit word
	move.l	mdu_heads(a3),d2
	divu		d2,d0					;d0 = cyl
	move.l	d0,d2
	swap.l	d2
	and.l		#$f,d2				;d2 = head
	move.l	d0,d1
	and.l		#$ff,d0				;cylinder low
	lsr.l		#8,d1
	and.l		#$ff,d1				;cylinder high
	rts

;perform safe switch to act_drv drive
	PUBLIC	SelectDrive
SelectDrive:
	movem.l	d0/d1,-(sp)
	bsr		waitnotbusy1
	beq		sdr1
	bsr		waitnotdrq1
	beq		sdr1
	clr.l		d0
	move.b	TF_DRIVE_HEAD,d0
	and.b		#$10,d0
	lsr.b		#4,d0
	cmp.l		mdu_UnitNum(a3),d0
	beq		sdr3
	move.l	mdu_UnitNum(a3),d0
	lsl.b		#4,d0
	or.b		#$a0,d0
	move.b	d0,TF_DRIVE_HEAD
	DLY400NS
;	cmp.l		#ATA_DRV,act_drv_type
;	bne		sdr2
	bra		sdr2
	move.l	#LOOP,d0
	cmp.l		#TRUE,mdu_motor(a3)
	beq		sdr4
	move.l	#LOOP2,d0
sdr4
	subq.l	#1,d0
	beq		sdr1
	move.b	TF_STATUS,d1
	and.b		#BSY+DRDY+SKC,d1
	cmp.b		#DRDY+SKC,d1
	beq		sdr3
	bra		sdr4
sdr2
	bsr		waitnotbusy1
	beq		sdr1
	bsr		waitnotdrq1
	beq		sdr1
sdr3
	moveq.l	#1,d0						; clear zero flag
sdr1
	movem.l	(sp)+,d0/d1
	rts


rs_cmd		dc.w	$0300,0,$2000,0,0,0
act_Status	dc.b	0
act_Flags	dc.b	0
act_Actual	dc.l	0
sense_data	ds.b	20					; sense data of last packet command


; a0 = scsi_Data, d0 = scsi_Length, a2 = scsi_Command, a6 = SCSICmd
; d2 = unit number, a3 = io_unit

	Public SCSIDirectCmd
SCSIDirectCmd
	movem.l	a0-a6/d0-d6,-(sp)
	bsr		SelectDrive
	beq		sdc1
	move.l	a0,a5
sdc3
	move.l	d0,d1
	and.l		#$FFFF0000,d0				;no more than 64KB at once now :-(
	beq		sdc5							;maybe will be fixed later
	move.b	#$BB,scsi_Status(a6)		;scsi_status = BBh -> length was >64KB
	move.b	#1,IO_ERROR(a1)
	clr.w		scsi_SenseActual(a6)
	bra		sdc2
sdc5
	move.w	scsi_CmdLength(a6),d3
	move.b	scsi_Flags(a6),act_Flags
	bsr		Packet
	move.l	act_Actual,d1
	add.l		d1,scsi_Actual(a6)
	move.b	act_Status,scsi_Status(a6)
	cmp.b		#$50,act_Status
	beq		sdc2
	clr.w		scsi_SenseActual(a6)
	move.b	#1,IO_ERROR(a1)
	cmp.b		#$FF,act_Status			;status = FFh means timeout
	bne		sdc1
	move.b	#$08,TF_COMMAND			;then reset atapi device
	DLY400NS
	bsr		waitnotbusy1
	bra		sdc2
sdc1											;read sense data if error
	lea		sense_data,a5
	btst.b	#SCSIB_AUTOSENSE,scsi_Flags(a6)
	beq		sdc6
	move.w	scsi_SenseLength(a6),d1
	bra		sdc7
sdc6
	move.w	#20,d1
sdc7
	move.w	#12,d3
	lea		rs_cmd,a2
	move.b	#SCSIF_READ,act_Flags
	bsr		Packet						;do packet request sense
	btst.b	#SCSIB_AUTOSENSE,scsi_Flags(a6)
	beq		sdc9
	move.l	scsi_SenseData(a6),a5
	lea		sense_data,a2
	move.l	act_Actual,d0
	move.w	d0,scsi_SenseActual(a6)
	beq		sdc2
	subq.w	#1,d0
sdc8
	move.b	(a2)+,(a5)+
	dbra		d0,sdc8
sdc9
	lea		sense_data,a2
	move.b	2(a2),d0
	and.b		#$F,d0
	clr.l		mdu_no_disk(a3)
	cmp.b		#2,d0
	bne		sdc91
	move.l	#1,mdu_no_disk(a3)		;medium is not present
sdc91
	cmp.b		#6,d0
	bne		sdc2
	add.l		#1,mdu_change_cnt(a3)
sdc2
	movem.l	(sp)+,a0-a6/d0-d6
	rts


act_cmd		ds.w	8

; a0 = scsi_Data, a2 = scsi_Command, a3 = io_unit, a6 = SCSICmd
; d1 = scsi_Length, d2 = unit number, d3 = cmd_length

;send packet to atapi drive and read/write data if needed
Packet
	movem.l	a0-a4/d0-d6,-(sp)
	clr.l		act_Actual
	DLY400NS
	bsr		waitnotbusy1					;wait till drive is not ready
	beq		pretec
	bsr		waitnotdrq1
	beq		pretec
	lsl.b		#4,d2
	or.b		#$a0,d2
	WATA		d2,TF_DRIVE_HEAD				;set task file registers
	DLY400NS
	WATA		#0,TF_SECTOR_COUNT
	move.b	d1,TF_CYLINDER_LOW
	lsr.w		#8,d1
	move.b	d1,TF_CYLINDER_HIGH
	WATA		#nIEN+8,TF_DEVICE_CONTROL
	bsr		waitnotbusy1
	beq		pretec
	WATA		#ATA_PACKET,TF_COMMAND		;send packet command
	DLY400NS
	bsr		waitdrq1
	beq		pretec
	move.b	TF_STATUS,d0
	and.b		#ERR,d0
	bne		pa_err
	lea		act_cmd,a1						;prepare packet
	clr.l		(a1)
	clr.l		4(a1)
	clr.l		8(a1)
	clr.l		12(a1)
	lsr.w		#1,d3
pa2
	move.w	(a2)+,(a1)+
	subq.w	#1,d3
	bne		pa2
	lea		act_cmd,a1
	move.w	(a1)+,TF_DATA					;write packet to drive
	move.w	(a1)+,TF_DATA
	move.w	(a1)+,TF_DATA
	move.w	(a1)+,TF_DATA
	move.w	(a1)+,TF_DATA
	move.w	(a1)+,TF_DATA
pa3
	move.l	#LOOP3,d2						;wait to packet execution result
pa4
	subq.l	#1,d2
	beq		pretec
	bsr		pause
	move.b	TF_ALTERNATE_STATUS,d0
	btst		#7,d0
	bne		pa4
	move.b	TF_SECTOR_COUNT,d1
	and.b		#3,d1	  	  
	btst.b	#3,d0
	bne		pa5
	cmp.b		#3,d1
	beq		pa6
	bra		pa4
pa5
	btst		#0,d1
	bne		pa4
pa6
	move.b	TF_ALTERNATE_STATUS,d0
	btst		#7,d0
	bne		pa4
	RATA		TF_STATUS,d0
	and.b		#DRQ,d0
	beq		pa10								;skip if no data
	clr.l		d3
	RATA		TF_CYLINDER_HIGH,d3			;else read data length
	lsl.w		#8,d3
	RATA		TF_CYLINDER_LOW,d3
	move.l	d3,act_Actual
	btst		#0,d3
	beq		pa7
	addq.l	#1,d3
pa7
	tst.l		d3									;test data length and
	beq		pa_zero							;data buffer address
	cmp.l		#0,a5
	beq		pa_err
	move.l	a5,d0
	and.l		#1,d0
	bne		pa_err
	lsr.l		#1,d3
	btst.b	#SCSIB_READ_WRITE,act_Flags	;read or write required?
	beq		pa9
pa8												;read data from drive
	cmp.l		#256,d3							;(if possible, use RATADATA for speed up)
	bcc		pa82
	subq.l	#1,d3
pa81
	move.w	TF_DATA,(a5)+
	dbra		d3,pa81
	bra		pa3
pa82
	RATADATA	(a5)
	sub.l		#256,d3
	bne		pa8
	bra		pa3
pa9												;write data to drive
	subq.l	#1,d3
pa91
	move.w	(a5)+,TF_DATA
	dbra		d3,pa91
	bra		pa3
pa10
	bsr		waitnotbusy1
	beq		pretec
	move.b	TF_STATUS,d1
	move.b	d1,act_Status
	and.b		#ERR,d1							;test, if error occured
	bne		pa_err
pa11
;	bsr		waitnotbusy1
	movem.l	(sp)+,a0-a4/d0-d6
	rts											;return from Packet

pretec											;if timeout, return status=FFh
	move.b	#$FF,act_Status
	bra		pa11
pa_err											;if error, return actual status
	move.b	TF_STATUS,act_Status
	bra		pa11

pa_zero											;if zero length occured, return AAh
	move.b	#$AA,act_Status
	bra		pa11


waitdrq1
	movem.l	d0/d1,-(sp)
	move.l	#LOOP,d1
	cmp.l		#TRUE,mdu_motor(a3)
	beq		wd
	move.l	#LOOP2,d1
wd
	subq.l	#1,d1
	beq		wd1
	move.b	TF_ALTERNATE_STATUS,d0
	and.b		#BSY+DRQ,d0
	cmp.b		#DRQ,d0
	bne		wd
wd1
	tst.l		d1
	movem.l	(sp)+,d0/d1
	rts


waitdrdy1
	movem.l	d0/d1,-(sp)
	move.l	#LOOP,d1
	cmp.l		#TRUE,mdu_motor(a3)
	beq		dr
	move.l	#LOOP2,d1
dr
	subq.l	#1,d1
	beq		dr1
	move.b	TF_ALTERNATE_STATUS,d0
	and.b		#BSY+DRDY,d0
	cmp.b		#DRDY,d0
	bne		dr
dr1
	tst.l		d1
	movem.l	(sp)+,d0/d1
	rts

	PUBLIC waitnotbusy1
waitnotbusy1
	movem.l	d0/d1,-(sp)
	move.l	#LOOP,d1
	cmp.l		#TRUE,mdu_motor(a3)
	beq		wn
	move.l	#LOOP2,d1
wn	subq.l	#1,d1
	beq		wn1
	move.b	TF_ALTERNATE_STATUS,d0
	and.b		#BSY,d0
	bne		wn
wn1
	tst.l		d1
	movem.l	(sp)+,d0/d1
	rts

	PUBLIC waitnotdrq1
waitnotdrq1
	movem.l	d0/d1,-(sp)
	move.l	#LOOP,d1
	cmp.l		#TRUE,mdu_motor(a3)
	beq		wq
	move.l	#LOOP2,d1
wq	subq.l	#1,d1
	beq		wq1
	move.b	TF_ALTERNATE_STATUS,d0
	and.b		#DRQ,d0
	bne		wq
wq1
	tst.l		d1
	movem.l	(sp)+,d0/d1
	rts

waitbusy1
	movem.l	d0/d1,-(sp)
	move.l	#LOOP,d1
	cmp.l		#TRUE,mdu_motor(a3)
	beq		wb
	move.l	#LOOP2,d1
wb	subq.l	#1,d1
	beq		wb1
	move.b	TF_ALTERNATE_STATUS,d0
	and.b		#BSY,d0
	beq		wb
wb1
	tst.l		d1
	movem.l	(sp)+,d0/d1
	rts

	PUBLIC	pause
pause
	move.l	d0,-(sp)
	move.l	#500,d0
pu1
	dbra		d0,pu1
	move.l	(sp)+,d0
	rts

   END
