          CPU 6502

;****************************
;*                          *
;*         Apple II         *
;*      Applesoft BASIC     *
;*                          *
;****************************

; Applesoft BASIC (c) by Apple Computer Inc.
;			 Microsoft Inc.


; Diesem Listing liegt ausschlielich die folgende Literatur zugrunde:
; This listing was created using only the following literature:
;
;  - Peeker 5/85 S73..77
;  - Buck, M. "Apple II ROM Listing"
;    Rckrath Mikrocomputer, ISBN 3-925074-04-X
;  - Esders, E. "Das Buch zum Apple II"
;    Franzis-Verlag GmbH, ISBN 3-7723-7641-X
;  - "Apple ][ Reference Manual"
;    Apple Computer Inc., #A2L0001A (030-0004-C)
;



; Zero-Page - Adressen
assoft    EQU $00   ; BASIC Soft-Entry
gostrout  EQU $03   ; Sprung zur String-Druckroutine
userjmp   EQU $0A   ; Sprung zum USR - Handler
charac    EQU $0D   ; Hilfsregister zum Vergleich einzelner Zeichen
endchr    EQU $0E
indflg    EQU $0F   ; Anzahl der Dimensionen des letzten Feldes
                    ; Lnge einer neuen BASIC - Zeile
                    ; Token - Zhler bei Befehlskodierung
dimflag   EQU $10   ; DIM - Flag
valtyp	  EQU $11   ; $00: Numerisch  / $FF: String
numtyp    EQU $12   ; $00: Real / $80: Integer
dataflg   EQU $13   ; Garbage-Collection - Flag
                    ; DATA - Flag bei Befehlskodierung
subflg    EQU $14   ; Flag fr Variablenverwaltung:
                    ; $00  normale Variablenbehandlung
                    ; $40  Feldvariable (bei STORE ohne Indizes)
                    ; $80  keine Integer-Variablen erlaubt
intypflg  EQU $15   ; Eingabeflag: $00 = INPUT, $40 = GET, $98 = READ
comprtyp  EQU $16   ; Vergleichstyp - Code
signflg   EQU $16   ; Vorzeichen-Flag fr TAN - Berechnung
shapell   EQU $1A   ; Zeiger bei Graphikroutinen
shapelh   EQU $1B
hcolor1   EQU $1C   ; aktuelle HiRes-Colormaske
counth    EQU $1D   ; HiRes-Schrittzhler MSB
wndleft   EQU $20   ; Textfenster, linker Rand (0..39)
wndwdth   EQU $21   ; Textfenster, horizontale Breite (1..40)
wndtop	  EQU $22   ; Textfenster, oberste Zeile (0..22)
wndbtm	  EQU $23   ; Textfenster, unterste Zeile (wndtop+1..24)
ch        EQU $24   ; Cursor horizontal
cv	  EQU $25   ; Cursor vertikal
gbasl	  EQU $26   ; Zeiger auf Anfang einer Graphikzeile
gbash     EQU $27
basl	  EQU $28
bash	  EQU $29
bas2l	  EQU $2A
bas2h	  EQU $2B
h2        EQU $2C   ; Koordinate bei Blockgraphik
v2        EQU $2D
mask	  EQU $2E
color     EQU $30   ; Bitmaske fr Punkt innerhalb eines Byte
mode	  EQU $31
invflg    EQU $32   ; INVERSE - Flag
prompt    EQU $33   ; Register fr Prompt - Zeichen
cswl      EQU $36   ; Vektor fr Ausgaberoutine im Monitor
cswh      EQU $37
kswl      EQU $38   ; Vektor fr Eingaberoutine im Monitor
kswh      EQU $39
a1l       EQU $3C   ; Beginn des Speicherbereiches fr Tape RW
a1h       EQU $3D
a2l       EQU $3E   ; Ende des Speicherbereiches fr Tape RW
a2h       EQU $3F
rndl      EQU $4E   ; Monitor - Zufallszahl
rndh      EQU $4F
linnuml   EQU $50   ; BASIC - Zeilennummer
linnumh   EQU $51
temppt	  EQU $52   ; Stackpointer des Deskriptoren-Stack
lastpt	  EQU $53   ; Zeiger auf obersten Deskriptor im Deskriptoren-Stack
auxl	  EQU $54
tempst	  EQU $55   ; Deskriptoren - Stack ($55..$5D)
indexl    EQU $5E   ; allgemeiner Zeiger
indexh    EQU $5F
ptrgul    EQU $60   ; allgemeiner Zeiger
ptrguh    EQU $61
result	  EQU $62   ; ($62..$66) Hilfsregister fr Multiplikation / Division
texttabl  EQU $67   ; Start des Programtextes
texttabh  EQU $68
vartabl   EQU $69   ; Start der einf. Variablen (LOMEM)
vartabh   EQU $6A
arytabl   EQU $6B   ; Start der Arrays
arytabh   EQU $6C
strendl   EQU $6D   ; Ende der Arrays + 1
strendh   EQU $6E
fretopl   EQU $6F   ; Start der Stringpointer
fretoph   EQU $70
frespcl   EQU $71   ; temporrer Stringpointer
frespch   EQU $72
memsizel  EQU $73   ; HiMem - Pointer (Ende + 1 des verfgbaren RAMs)
memsizeh  EQU $74
curlinl   EQU $75   ; gerade bearbeitete Zeile
curlinh   EQU $76   ; <-- $FF im direct mode
oldlinl   EQU $77   ; letzte bearbeitete Zeile
oldlinh   EQU $78
otxtptrl  EQU $79   ; Zeiger auf letzten Befehl
otxtptrh  EQU $7A
datlinl   EQU $7B   ; aktuelle 'DATA'-Zeile
datlinh   EQU $7C
datptrl   EQU $7D   ; Pointer zur 'DATA'-Adresse
datptrh   EQU $7E
inpsrcel  EQU $7F   ; Pointer zur aktuellen Eingaberoutine ('inbuff')
inpsrceh  EQU $80
lstvarnl  EQU $81   ; zuletzt benutzter Variablenname
lstvarnh  EQU $82
varpntl   EQU $83   ; zuletzt benutzte Variable
varpnth   EQU $84
forpntl   EQU $85   ; gemerkter Variablenzeiger bei LET, NEXT, etc
forpnth   EQU $86
txtptrsvl EQU $87   ; gemerkter CHRGET - Zeiger bei Eingabeoperation
txtptrsvh EQU $88
cmpflag   EQU $89   ; Vergleichsflag (> 1, = 2, >= 3, < 4, <> 5, <= 6)
FAC5	  EQU $8A   ; (temp3) $8A..8E Real-Speicher
fncnaml   EQU $8A   ; Zeiger auf FN-Definitions-Variable
fncnamh   EQU $8B
dscptrl   EQU $8C   ; Zeiger auf gltigen String-Deskriptor
dscptrh   EQU $8D
dsclen    EQU $8F   ; Lnge einer Variablen im Speicher (3 oder 7)
jmpadrs   EQU $90   ; $90..$92 JMP-Befehl bei Funktionsaufruf
length	  EQU $91
extrasv   EQU $92   ; gemerkte Rundungsstelle von FAC1
FAC3	  EQU $93   ; (temp1) $93..97 Real-Speicher
highdsl   EQU $94   ; Zeiger auf 1. Element einer Feldvariablen
highdsh   EQU $95
hightrl   EQU $96   ; Zeiger fr Blocktransfer
hightrh   EQU $97
FAC4	  EQU $98   ; (temp2) $98..9C Real-Speicher
indx	  EQU $99
tmpexp	  EQU $99   ; Zhler fr Nachkommastellen
expon	  EQU $9A   ; Exponentenregister
dpflg	  EQU $9B   ; Dezimalpunkt-Flag
lowtrl    EQU $9B   ; BASIC-Zeilenpointer
lowtrh    EQU $9C
expsgn	  EQU $9C   ; Vorzeichen des Exponenten
dsctmp	  EQU $9D   ; temp. String-Deskriptor
FAC1      EQU $9D   ; $9D..A2 Fliekommaakku 
FAC1exp   EQU $9D   ; FAC1 Exponent
vpntl	  EQU $A0   ; Zeiger auf neue Variable bzw. Integerteil des FAC1
vpnth	  EQU $A1   ;
FAC1sign  EQU $A2   ; FAC1 Vorzeichen
serlen	  EQU $A3   ; Vorzeichen der Mantisse
fpgen	  EQU $A4   ; Hilfsregister fr Mantissenverschiebung
FAC2	  EQU $A5   ; (arg) $A5..AA Fliekommaakku
FAC2exp   EQU $A5   ; FAC2 Exponent
FAC2sign  EQU $AA   ; FAC2 Vorzeichen
xorfsgn   EQU $AB   ; FAC1sgn XOR FAC2sgn
strng1l   EQU $AB
strng1h   EQU $AC
extrafac  EQU $AC   ; Rundungsstelle fr FAC1
strng2l   EQU $AD   ; Hilfsregister fr Befehlskodierung
strng2h   EQU $AE
prgendl   EQU $AF   ; End-of-Pgm - Pointer
prgendh   EQU $B0
; $B1 bis $C8 wird von der CHRGET-Routine belegt
txtptrl   EQU $B8   ; BASIC - Textpointer
txtptrh   EQU $B9
rndval    EQU $C9   ; $C9..CD Zufallszahl
dxl	  EQU $D0   ; Differenzregister fr HPLOT
dxh	  EQU $D1
dy	  EQU $D2
qdrnt	  EQU $D3   ; Quadrant fr DRAW, XDRAW
el	  EQU $D4   ; Saldoregister fr HPLOT
eh	  EQU $D5
lock	  EQU $D6   ; $00 im direct mode, bit 7 = 1 fr Autostart
errflg    EQU $D8   ; $80 bei ONERR GOTO
errlinl   EQU $DA   ; Zeilennummer fr RESUME
errlinh   EQU $DB
errposl   EQU $DC   ; 'txtptr' auf Fehlerstelle
errposh   EQU $DD
errnum    EQU $DE   ; Fehlercode
errstk    EQU $DF   ; CPU-Stackptr mit Fehler
hcursxl   EQU $E0   ; HiRes - Cursor
hcursxh   EQU $E1
hcursy    EQU $E2
hcolorz   EQU $E4   ; HiRes - Color Code Byte
hndx	  EQU $E5   ; Spaltenindex eines Punktes in hgr2-Routinen
hpag      EQU $E6   ; aktuelle HiRes-Seite
scalez	  EQU $E7   ; Shape scale
shapepntl EQU $E8   ; Start der Shapetabelle
shapepnth EQU $E9
colcount  EQU $EA   ; Kollisionsflag
first     EQU $F0   ; LoRes-Plotkoordinate X
speedz	  EQU $F1   ; Ausgabegeschwindigkeit, 1 = maximal schnell
trcflg	  EQU $F2   ; $80 fr TRACE
ormask    EQU $F3   ; $40 bei FLASH
onerrtpl  EQU $F4   ; 'txtptr' fr ONERR GOTO
onerrtph  EQU $F5
onerrcll  EQU $F6   ; Zeilennummer der ONERR GOTO-Anweisung
onerrclh  EQU $F7
remstk    EQU $F8   ; CPU-Stackpointer
rotz	  EQU $F9   ; Shape rotation

in        EQU $0200 ; Zeicheneingabepuffer

; Hardware - Adressen
kbd	  EQU $C000 ; Tastaturlatch
txtclr    EQU $C050
txtset    EQU $C051
mixclr    EQU $C052
mixset    EQU $C053
lowscr    EQU $C054
hiscr     EQU $C055
lores     EQU $C056
hires     EQU $C057

; Monitor - Routinen
charget   EQU $B1    ; hole nchstes BASIC-Zchn
chargot   EQU $B7    ; lies altes Zeichen
amper     EQU $03F5  ; & - Vektor
plot      EQU $F800  ; PLOT ausfhren
hline     EQU $F819  ; HLIN ausfhren
vline     EQU $F828  ; VLIN ausfhren
setcol    EQU $F864  ; COLOR= ausfhren
scrn      EQU $F871  ; SCRN( ausfhren
prtax     EQU $F941  ; Wort hex ausgeben
prntx     EQU $F944  ; Byte hex ausgeben
pread     EQU $FB1E  ; lies Paddle-Port
settxt    EQU $FB39  ; Textmode einschalten
setgr     EQU $FB40  ; Graphikmode einschalten
tabv      EQU $FB5B  ; VTAB ausfhren
home      EQU $FC58  ; HOME
wait      EQU $FCA8  ; Verzgerungsroutine
rd2bit	  EQU $FCFA
rdkey     EQU $FD0C  ; hole ein Zeichen
getln     EQU $FD6A  ; hole Eingabezeile
cout      EQU $FDED  ; gib Zeichen aus
inport    EQU $FE8B  ; IN#
outport   EQU $FE95  ; PR#
twrite    EQU $FECD  ; schreibe Kassette
tread     EQU $FEFD  ; lies von Kassette
monread2  EQU $FF02
bell      EQU $FF3A  ; Glockenzeichen ausgeben


          ORG $D000           ; ROM start address

; Einsprungadressen der Befehle
cmdtabl   ADR end-1,for-1
          ADR next-1,data-1
          ADR input-1,del-1
          ADR dim-1,read-1
          ADR gr-1,text-1
	  ADR prnu-1,innu-1
          ADR call-1,lplot-1
          ADR hlin-1,vlin-1
	  ADR hgr2-1,hgr-1
	  ADR hcolor-1,hplot-1
	  ADR draw-1,xdraw-1
          ADR htab-1,home-1
	  ADR rot-1,scale-1
          ADR shload-1,trace-1
          ADR notrace-1,normal-1
          ADR inverse-1,flash-1
	  ADR colset-1,pop-1		; POP = RETURN
          ADR vtab-1,himem-1
          ADR lomem-1,onerr-1
          ADR resume-1,recall-1
          ADR store-1,speed-1
          ADR let-1,goto-1
	  ADR run-1,if-1
          ADR restore-1,amper-1
	  ADR gosub-1,pop-1
          ADR rem-1,stop-1
	  ADR ongoto-1,aswait-1
          ADR load-1,save-1
          ADR def-1,poke-1
          ADR print-1,cont-1
          ADR list-1,clear-1
          ADR get-1,new-1

; Einsprungadressen der Funktionen (Aufruf ber 'jmpadrs')
unfnc	  ADR sgn,int
          ADR abs,userjmp
          ADR fre,error                 ; fr SCRN( nur Dummy - Adresse
          ADR pdl,pos
          ADR sqr,rnd
          ADR log,exp
          ADR cos,sin
          ADR tan,atn
          ADR peek,len
	  ADR str,val
	  ADR asc,chrstr
          ADR leftstr,rightstr
          ADR midstr

; Einsprungadressen der Operationen, Hierarchiebytes
mathtbl   BYT $79
          ADR faddt-1
          BYT $79
          ADR fsubt-1
          BYT $7B
          ADR fmultt-1
          BYT $7B
          ADR fdivt-1
          BYT $7D
	  ADR fpwrtt-1
          BYT $50
	  ADR and-1
          BYT $46
	  ADR or-1
          BYT $7F
minus	  ADR negop-1
          BYT $7F
equal	  ADR equop -1
          BYT $64
plus	  ADR posop-1

; Keywords,
;  beim letzten Zeichen ist bit7 gesetzt
toktabl   BYT $45,$4E,$C4		; END
          BYT $46,$4F,$D2               ; FOR
          BYT $4E,$45,$58,$D4           ; NEXT
          BYT $44,$41,$54,$C1           ; DATA
          BYT $49,$4E,$50,$55,$D4       ; INPUT
          BYT $44,$45,$CC               ; DEL
          BYT $44,$49,$CD               ; DIM
          BYT $52,$45,$41,$C4           ; READ
          BYT $47,$D2                   ; GR
          BYT $54,$45,$58,$D4           ; TEXT
          BYT $50,$52,$A3               ; PR#
          BYT $49,$4E,$A3               ; IN#
          BYT $43,$41,$4C,$CC           ; CALL
          BYT $50,$4C,$4F,$D4           ; PLOT
          BYT $48,$4C,$49,$CE           ; HLIN
          BYT $56,$4C,$49,$CE           ; VLIN
          BYT $48,$47,$52,$B2           ; HGR2
	  BYT $48,$47,$D2		; HGR
	  BYT $48,$43,$4F,$4C,$4F,$52,$BD  ; HCOLOR=
          BYT $48,$50,$4C,$4F,$D4       ; HPLOT
	  BYT $44,$52,$41,$D7		; DRAW
	  BYT $58,$44,$52,$41,$D7	; XDRAW
          BYT $48,$54,$41,$C2           ; HTAB
          BYT $48,$4F,$4D,$C5           ; HOME
	  BYT $52,$4F,$54,$BD		; ROT=
	  BYT $53,$43,$41,$4C,$45,$BD	; SCALE=
          BYT $53,$48,$4C,$4F,$41,$C4   ; SHLOAD
          BYT $54,$52,$41,$43,$C5       ; TRACE
          BYT $4E,$4F,$54,$52,$41,$43,$C5  ; NOTRACE
          BYT $4E,$4F,$52,$4D,$41,$CC   ; NORMAL
          BYT $49,$4E,$56,$45,$52,$53,$C5  ; INVERSE
          BYT $46,$4C,$41,$53,$C8       ; FLASH
          BYT $43,$4F,$4C,$4F,$52,$BD   ; COLOR=
          BYT $50,$4F,$D0               ; POP
          BYT $56,$54,$41,$C2           ; VTAB
          BYT $48,$49,$4D,$45,$4D,$BA   ; HIMEM:
          BYT $4C,$4F,$4D,$45,$4D,$BA   ; LOMEM:
          BYT $4F,$4E,$45,$52,$D2       ; ONERR
          BYT $52,$45,$53,$55,$4D,$C5   ; RESUME
          BYT $52,$45,$43,$41,$4C,$CC   ; RECALL
          BYT $53,$54,$4F,$52,$C5       ; STORE
          BYT $53,$50,$45,$45,$44,$BD   ; SPEED
          BYT $4C,$45,$D4               ; LET
          BYT $47,$4F,$54,$CF           ; GOTO
          BYT $52,$55,$CE               ; RUN
          BYT $49,$C6                   ; IF
          BYT $52,$45,$53,$54,$4F,$52,$C5  ; RESTORE
          BYT $A6                       ; &
          BYT $47,$4F,$53,$55,$C2       ; GOSUB
          BYT $52,$45,$54,$55,$52,$CE   ; RETURN
          BYT $52,$45,$CD               ; REM
          BYT $53,$54,$4F,$D0           ; STOP
          BYT $4F,$CE                   ; ON
          BYT $57,$41,$49,$D4           ; WAIT
          BYT $4C,$4F,$41,$C4           ; LOAD
          BYT $53,$41,$56,$C5           ; SAVE
          BYT $44,$45,$C6               ; DEF
          BYT $50,$4F,$4B,$C5           ; POKE
          BYT $50,$52,$49,$4E,$D4       ; PRINT
          BYT $43,$4F,$4E,$D4           ; CONT
          BYT $4C,$49,$53,$D4           ; LIST
          BYT $43,$4C,$45,$41,$D2       ; CLEAR
          BYT $47,$45,$D4               ; GET
          BYT $4E,$45,$D7               ; NEW
          BYT $54,$41,$42,$A8           ; TAB(
          BYT $54,$CF                   ; TO
          BYT $46,$CE                   ; FN
          BYT $53,$50,$43,$A8           ; SPC(
          BYT $54,$48,$45,$CE           ; THEN
          BYT $41,$D4                   ; AT
          BYT $4E,$4F,$D4               ; NOT
          BYT $53,$54,$45,$D0           ; STEP
          BYT $AB                       ; +
          BYT $AD                       ; -
          BYT $AA                       ; *
          BYT $AF                       ; /
          BYT $DE                       ; ^
          BYT $41,$4E,$C4               ; AND
          BYT $4F,$D2                   ; OR
          BYT $BE                       ; >
          BYT $BD                       ; =
          BYT $BC                       ; <
          BYT $53,$47,$CE               ; SGN
          BYT $49,$4E,$D4               ; INT
          BYT $41,$42,$D3               ; ABS
          BYT $55,$53,$D2               ; USR
          BYT $46,$52,$C5               ; FRE
          BYT $53,$43,$52,$4E,$A8       ; SCRN(
          BYT $50,$44,$CC               ; PDL
          BYT $50,$4F,$D3               ; POS
          BYT $53,$51,$D2               ; SQR
          BYT $52,$4E,$C4               ; RND
          BYT $4C,$4F,$C7               ; LOG
          BYT $45,$58,$D0               ; EXP
          BYT $43,$4F,$D3               ; COS
          BYT $53,$49,$CE               ; SIN
          BYT $54,$41,$CE               ; TAN
          BYT $41,$54,$CE               ; ATN
          BYT $50,$45,$45,$CB           ; PEEK
          BYT $4C,$45,$CE               ; LEN
          BYT $53,$54,$52,$A4           ; STR$
          BYT $56,$41,$CC               ; VAL
          BYT $41,$53,$C3               ; ASC
          BYT $43,$48,$52,$A4           ; CHR$
          BYT $4C,$45,$46,$54,$A4       ; LEFT$
          BYT $52,$49,$47,$48,$54,$A4   ; RIGHT$
          BYT $4D,$49,$44,$A4           ; MID$
          BYT $00

; Fehlermeldungen,
;  beim letzten Zeichen ist bit7 gesetzt
errmsg
nywofor   BYT $4E,$45,$58,$54,$20,$57,$49,$54
          BYT $48,$4F,$55,$54,$20,$46,$4F,$D2     ; NEXT without FOR
syntxerr  BYT $53,$59,$4E,$54,$41,$D8		  ; syntax
rtnwogsb  BYT $52,$45,$54,$55,$52,$4E,$20,$57
          BYT $49,$54,$48,$4F,$55,$54,$20,$47
          BYT $4F,$53,$55,$C2                     ; RETURN without GOSUB
oofdata   BYT $4F,$55,$54,$20,$4F,$46,$20,$44
          BYT $41,$54,$C1                         ; out of DATA
illquan   BYT $49,$4C,$4C,$45,$47,$41,$4C,$20
          BYT $51,$55,$41,$4E,$54,$49,$54,$D9     ; illegal quantity
ovflow	  BYT $4F,$56,$45,$52,$46,$4C,$4F,$D7	  ; overflow
oofmem	  BYT $4F,$55,$54,$20,$4F,$46,$20,$4D
	  BYT $45,$4D,$4F,$52,$D9		  ; out of memory
undstat   BYT $55,$4E,$44,$45,$46,$27,$44,$20
          BYT $53,$54,$41,$54,$45,$4D,$45,$4E
	  BYT $D4				  ; undef'd statement
badsubs   BYT $42,$41,$44,$20,$53,$55,$42,$53
          BYT $43,$52,$49,$50,$D4                 ; bad subscript
redimarr  BYT $52,$45,$44,$49,$4D,$27,$44,$20
	  BYT $41,$52,$52,$41,$D9		  ; redim'd array
divbyzro  BYT $44,$49,$56,$49,$53,$49,$4F,$4E
          BYT $20,$42,$59,$20,$5A,$45,$52,$CF     ; division by zero
illdir	  BYT $49,$4C,$4C,$45,$47,$41,$4C,$20
          BYT $44,$49,$52,$45,$43,$D4             ; illegal direct
typemiss  BYT $54,$59,$50,$45,$20,$4D,$49,$53
          BYT $4D,$41,$54,$43,$C8                 ; type mismatch
strtolng  BYT $53,$54,$52,$49,$4E,$47,$20,$54
          BYT $4F,$4F,$20,$4C,$4F,$4E,$C7         ; string too long
formtocx  BYT $46,$4F,$52,$4D,$55,$4C,$41,$20
          BYT $54,$4F,$4F,$20,$43,$4F,$4D,$50
          BYT $4C,$45,$D8                         ; formula too complex
cantcon   BYT $43,$41,$4E,$27,$54,$20,$43,$4F
	  BYT $4E,$54,$49,$4E,$55,$C5		  ; can't continue
undfunc   BYT $55,$4E,$44,$45,$46,$27,$44,$20
	  BYT $46,$55,$4E,$43,$54,$49,$4F,$CE	  ; undef'd function
errin	  BYT $20,$45,$52,$52,$4F,$52,$07,$00	  ; ' ERROR'
inmsg	  BYT $20,$49,$4E,$20,$00		  ; ' IN '
breakin   BYT $0D,$42,$52,$45,$41,$4B,$07,$00	  ; 'BREAK'



; Suche FOR / NEXT - Parameter im Stack
; I: forpntl.forpnth NEXT - Variable falls angegeben, sonst forpnth=0
; O: gefunden -> Z=1, X=S, A=Var.NameLB, sonst Z=0
gtforpnt  TSX		      ; zwei Return-Adressen berspringen
          INX
          INX
          INX
          INX
fndfor	  LDA $0101,X
          CMP #$81            ; 'FOR'-Token
	  BNE ret1	      ; nein, zurck mit Byte im Akku
	  LDA forpnth	      ; Laufvariable MSB
	  BNE samefor_	      ; nicht null, d.h. NEXT-Variable angegeben
          LDA $0102,X         ; sonst FOR-Variable der letzten Schleife nehmen
          STA forpntl
          LDA $0103,X
          STA forpnth
samefor_  CMP $0103,X	      ; bereinstimmung mit gemerkter Variablen?
	  BNE nxfor	      ; nein, weitersuchen
	  LDA forpntl	      ; Laufvariable LSB
          CMP $0102,X         ; bereinstimmung?
	  BEQ ret1	      ; ja, aktuelle Schleife gefunden und fertig
nxfor	  TXA		      ; sonst 18 Positionen berspringen
          CLC                 ;     und weitersuchen
          ADC #$12
          TAX
	  BNE fndfor
ret1	  RTS

; Noch Platz fr Speicherblock-Verschiebung?
; I: A,Y = neues erwnschtes Blockende
bltu	  JSR reason	      ; noch gengend freier Speicherplatz
          STA strendl         ; neues Ende der Feldvariablen
          STY strendh

; Speicherblock verschieben
; I: lowtrl.lowtrh alter Anfang;  hightrl.hightrh altes Ende + 1
;    highdsl.highdsh neues Ende + 1  (highds > hightr)
; O: hightrl.hightrh + 1 = lowtrl.lowtrh = alter Anfang
;    highdsl.highdsh + 1 neuer Anfang
;    X = 0;  Y = 0;  A = letztes Byte
bltu2	  SEC
	  LDA hightrl	      ; altes Ende + 1, LSB
	  SBC lowtrl	      ; alter Blockanfang, LSB
          STA indexl          ; Blocklnge modulo 256
          TAY
	  LDA hightrh	      ; altes Ende + 1, MSB
	  SBC lowtrh	      ; alter Anfang, MSB
          TAX                 ; Anzahl voller Blcke zu je 256 Byte
          INX
          TYA                 ; Y = 0?
	  BEQ nxpag	      ; ja, kein Restblock -> volle Blcke verschieben
          LDA hightrl
          SEC
          SBC indexl          ; Lnge des Restblockes
	  STA hightrl	      ; Anfang Restblock, LSB
	  BCS setend
	  DEC hightrh	      ; Anfang Restblock, MSB
          SEC
setend	  LDA highdsl	      ; neues Ende + 1, LSB
          SBC indexl          ; Lnge des Restblockes abziehen
          STA highdsl
	  BCS nxbyt
          DEC highdsh
	  BCC nxbyt
mvbyt	  LDA (hightrl),Y     ; Verschiebeschleife fr Restblock
          STA (highdsl),Y
nxbyt	  DEY
	  BNE mvbyt
          LDA (hightrl),Y     ; Verschiebeschleife fr volle Blcke
          STA (highdsl),Y
nxpag	  DEC hightrh
          DEC highdsh
          DEX
	  BNE nxbyt	      ; nchsten vollen Block verschieben
          RTS

; Testen, ob Platz im Stack ausreicht
; Es mssen mindestens 54 Bytes Reserve bleiben, damit bei maximaler Unterprogramm-
; verschachtelung der Stack nicht berluft und der Zahlenstring von FOUT nicht
; berschrieben wird.
; I: A = bentigter Platz im Stack in Worten (16 bit)
; O: falls ok, X = S; C = 1
chkmem	  ASL
          ADC #$36            ; wenn weniger als 54 Bytes in Reserve,
	  BCS memerr	      ;   'OUT OF MEMORY'-  Error
          STA indexl
          TSX                 ; freie Bytes auf Stack
          CPX indexl
	  BCC memerr	      ; bleiben weniger als 54 -> OUT OF MEMORY
          RTS

; Teste, ob freier Speicher vorhanden, fhre sonst
; garbage collection durch
; I: A,Y = gewnschtes Ende;  fretopl.fretoph = max. Ende
; O: falls ok, A,Y = gewnschtes Ende; C=0
reason	  CPY fretoph	      ; prfe MSB
	  BCC ret2	      ; ok, fertig
	  BNE rs1	      ; sonst aufrumen
	  CMP fretopl	      ; prfe LSB
	  BCC ret2	      ; ok, fertig
rs1	  PHA		      ; A, Y auf den Stack
          LDX #$09            ; Zhler fr Schleife
          TYA
rs2	  PHA
          LDA FAC3 ,X         ; rette FAC3 und FAC4 auf den Stack
          DEX
	  BPL rs2
          JSR garbag          ; Speicher aufrumen
          LDX #$F7            ; Zhler fr Schleife
rs3	  PLA		      ; hole FAC3 und FAC4 wieder vom Stack
	  STA FAC1,X	      ; Pointer zurckholen
          INX
	  BMI rs3
          PLA                 ; hole A,Y wieder vom Stack
          TAY
          PLA
          CPY fretoph         ; jetzt genug Platz?
	  BCC ret2	      ; ok
	  BNE memerr	      ; sonst 'Out of Memory'
          CMP fretopl
	  BCS memerr
ret2	  RTS

memerr	  LDX #$4D	      ; 'Out of Memory' - Offset

; Behandlung von Fehlermeldungen
; I: X = Fehlertext - Offset
error     BIT errflg          ; teste ONERR GOTO - Flag
	  BPL doerrmsg	      ; bit7=0 -> regulre Beh.
	  JMP handlerr		;  sonst ONERR - Handler
doerrmsg  JSR crdo	      ; CR ausgeben
	  JSR outques	      ; drucke Fragezeichen
erlup	  LDA errmsg,X	      ; hole Meldungs-Zeichen
          PHA                 ; rette es
          JSR outdo           ; gib es aus
          INX
          PLA                 ; stelle Zchn wieder her
	  BPL erlup	      ; bit7 = 0 -> nchstes
	  JSR stkini	      ; Stack und Deskriptorenstack initialisieren
	  LDA #errin # 256
	  LDY #errin / 256    ; Ptr zum Text 'ERROR'
prntin_   JSR strout	      ; drucke Meldung
          LDY curlinh
          INY                 ; = $FF wenn direct mode
	  BEQ restart	      ; direct mode -> Warmstart
	  JSR inprt	      ; drucke 'IN' + Zeilennr

; BASIC - Warmstart
restart   JSR crdo	      ; CR ausgeben
          LDX #$DD            ; Prompt ']'
          JSR inlin2          ; hole Eingabezeile (X, Y = $1FF; A = 0)
          STX txtptrl         ; setze txtptr auf 
          STY txtptrh         ;         Zeilenstart-1
          LSR errflg          ; schalte ONERR GOTO ab
          JSR charget         ; lies erstes Zeichen
          TAX
	  BEQ restart	      ; kein Eingabezeichen --> Warmstart
          LDX #$FF
          STX curlinh         ; setze direct mode
	  BCC nxlin	      ; Cy=0 -> Zchn ist Ziffer (Programmzeile)
	  JSR getin	      ; wandle Zeile in Token
	  JMP trace_	      ; fhre Zeile aus

; Neue Programmzeile bernehmen
; Eine Programmzeile hat im Speicher folgendes Format:
;  Linkadresse LSB, MSB: RAM-Adresse der folgenden Zeile
;  Zeilennummer LSB, MSB: erlaubt sind 0..63999
;  Programmtext, hier wurden alle Keywords durch Token ersetzt
;  $00: EOL
; Das Ende des Programmtextes wird durch die Linkadresse $0000 dargestellt.
; I: A = erste Ziffer der Zeilennummer
nxlin	  LDX prgendl	      ; Programmtextende + 1
          STX vartabl         ; = Variablenanfang, damit Variblen direkt
          LDX prgendh         ;      hinter dem Programmtext
          STX vartabh
          JSR linget          ; lies BASIC-Zeilennr
	  JSR getin	      ; wandle Zeile in Token
          STY indflg          ; Lnge der neuen Zeile
          JSR fndlin          ; suche Zeile im Speicher
	  BCC newln_	      ; Cy=0 -> noch nicht da, neue Zeile anlegen

; alte Zeile lschen:
; Berechne Pointer zur Zeilenlschung:
; Berechne Quellpointer 'index' ($5E.5F) zum Start der nchsthheren Zeile
; sowie Zielpointer 'genptr1' ($60.61) zum Start der zu ersetzenden Zeile
; aus 'linnum' ($50.51).
          LDY #$01
          LDA (lowtrl),Y      ; AdrH der folgenden Programmzeile
	  STA indexh	      ;  als Basiszeiger auf Quellbereich MSB
	  LDA vartabl	      ; Lnge des Programmtextes LSB
	  STA indexl	      ;  als Basiszeiger auf Quellbereich LSB
          LDA lowtrh          ; AdrH der zu lschenden Zeile
	  STA ptrguh	      ;  als Basiszeiger auf Zielbereich, MSB
          LDA lowtrl          ; AdrL der zu lschenden Zeile
          DEY
          SBC (lowtrl),Y      ; minus AdrL der folgenden Zeile (C war 1)
          CLC                 ;   ergibt negative Zeilenlnge
	  ADC vartabl	      ; addiert zum bisherigen Programmtextende, LSB
	  STA vartabl	      ; gibt neues Ende des Programmtextes, LSB
	  STA ptrgul	      ; als Basiszeiger auf Zielbereich, LSB
          LDA vartabh
	  ADC #$FF	      ; MSB korrigieren falls bertrag (C = 0)
          STA vartabh
          SBC lowtrh          ; minus AdrH der alten Zeile
          TAX                 ; ergibt Anzahl der zu verschiebenden Seiten
          SEC
          LDA lowtrl          ; AdrL der alten Zeile
          SBC vartabl         ; minus neues Ende des Programmtextes
          TAY                 ;  ergibt Index auf erstes zu verschiebendes Byte
	  BCS nl1
          INX                 ; Blockzahl korrigieren
	  DEC ptrguh	      ; Basiszeiger auf Zielbereich, MSB
nl1	  CLC
	  ADC indexl	      ; Index plus Basiszeiger auf Quellbereich, LSB
	  BCC mvdwn	      ; ggf. Basiszeiger auf Quellbereich korrigieren
          DEC indexh
          CLC
; Lsche Zeile im Speicher:
; Kopiere alle Zeilen, beginnend bei der nchsthheren auf die zu lschende
; Zeile, diese wird dadurch aus dem Speicher entfernt.
mvdwn	  LDA (indexl),Y
          STA (ptrgul),Y
          INY                 ; Zeiger innerhalb des 256 byte - Blockes
	  BNE mvdwn
          INC indexh
          INC ptrguh
          DEX                 ; Blockzhler
	  BNE mvdwn

; Enthlt die Eingabezeile nur noch EOL, so wurde nur die Zeilennummer
; eingegeben, also Zeile lschen.
newln_	  LDA in	      ; erstes Zeichen
	  BEQ linkset	      ; Leerzeile, nichts einfgen
; Erzeuge Platz fr neue Zeile:
; Berechne Quell- und Zielpointer fr Speicherblocktransfer
          LDA memsizel        ; unterstes Stringende := HIMEN
          LDY memsizeh        ;    (damit Strings gelscht)
          STA fretopl
          STY fretoph
          LDA vartabl         ; Ende des Programmtextes + 1
          STA hightrl         ; altes Blockende + 1
          ADC indflg          ; Lnge der neuen Zeile dazu
          STA highdsl         ; gibt neues Blockende + 1
          LDY vartabh
          STY hightrh
	  BCC  mvprg
          INY
mvprg	  STY highdsh
	  JSR bltu	      ; Block verschieben
          LDA linnuml
          LDY linnumh
          STA in-2            ; Setze Zeilennr (linnum) vor die Eingabezeile
          STY in-1
          LDA strendl         ; neues Ende des Programmtextes + 1
          LDY strendh
          STA vartabl         ; eintragen als Variablenanfangs - Vektor
          STY vartabh
; Transferiere neue Zeile zum Programmspeicher
          LDY indflg          ; hole Lnge der Eingabezeile
insrtlin  LDA $01FB,Y	      ; neue Zeile einfgen
          DEY
          STA (lowtrl),Y
	  BNE insrtlin
linkset   JSR setptrs	      ; lsche alle Variablen

; Linkadressen neu berechnen
          LDA texttabl        ; Anfang des Programmtextes
          LDY texttabh
          STA indexl          ; auf 'index' bertragen
          STY indexh
          CLC                 ; initialisiere Carry
; justiere Linkfeld-Zeilenpointer
nxlink	  LDY #$01	      ; OffsetPtr zum Linkfeld
	  LDA (indexl),Y      ;  alte Linkadresse, MSB
	  BNE putlink	      ; Programmende noch nicht erreicht
          LDA vartabl         ; sonst Programmendevektor eintragen
          STA prgendl
          LDA vartabh
          STA prgendh
	  JMP restart	      ; hole neue Eingabe
putlink   LDY #$04	      ; OffsetPtr auf 1. Zchn
findeol   INY
          LDA (indexl),Y      ; lies Zeichen der Zeile
	  BNE findeol	      ; suche EOL
          INY                 ; Zeilenlnge
          TYA
          ADC indexl          ; zum Zeiger addieren und als Linkadresse eintr.
	  TAX		      ; Linkadresse LSB merken
          LDY #$00
          STA (indexl),Y      ; eintragen
          LDA indexh
          ADC #$00
          INY
          STA (indexl),Y
          STX indexl          ; aktualisiere 'index' fr nchste Zeile
          STA indexh
	  BCC nxlink	      ; -> nchste Zeile (unbedingter Sprung)

; hole Eingabezeile ohne Prompt
inlin	  LDX #$80
; hole Eingabezeile mit Prompt
inlin2    STX prompt
          JSR getln
          CPX #$EF            ; Zeile zu lang? (max 239 Zeichen)
	  BCC gdbufs
          LDX #$EF            ; Lnge begrenzen
gdbufs	  LDA #$00
          STA in,X            ; $0 als Endmarke anfgen
          TXA                 ; Z - Flag aktualisieren
	  BEQ noi	      ; Leerzeile, fertig
strip	  LDA in-1,X
          AND #$7F            ; berall bit7 lschen
          STA in-1,X
          DEX
	  BNE strip
noi	  LDA #$00
          LDX #$FF            ; X, Y zeigt auf Eingabepuffer - 1
          LDY #$01
          RTS

; hole ein einzelnes Zeichen
inchr     JSR rdkey
          AND #$7F            ; bit 7 lschen
          RTS

; wandle Eingabezeile in Tokenform um
getin	  LDX txtptrl	      ; Zeiger in Eigabepuffer
          DEX
          LDY #$04            ; Zeiger vorbereiten (vgl. $D5B0)
	  STY dataflg	      ; DATA - Flag lschen
	  BIT lock	      ; teste Autostart - Flag
	  BPL parse	      ; kein Autostart
          PLA
          PLA                 ; entferne Rcksprungadresse vom Stack
	  JSR setptrs	      ; lsche die Variablen
          JMP newstt          ; und starte das Programm
parse	  INX
nxchr	  LDA in,X	      ; Zeichen aus Tastaturpuffer holen
	  BIT dataflg
	  BVS se	      ; DATA - Flag gesetzt, Leerz. nicht ignorieren
          CMP #$20
	  BEQ parse	      ; sonst Leerzeichen berspringen
se	  STA endchr	      ; Zeichen merken
          CMP #$22            ; Anfhrungszeichen?
	  BEQ shin	      ; ja, String bernehmen
	  BVS putin	      ; Im DATA - Statement nicht kodieren
          CMP #$3F            ; ist es '?' ?
	  BNE tok_	      ; nein -->
          LDA #$BA            ; sonst wie PRINT behandeln
	  BNE putin	      ; immer
tok_	  CMP #$30
	  BCC istok_	      ; keine Ziffer
          CMP #$3C
	  BCC putin	      ; Ziffer, ':' und ';' nicht kodieren
istok_	  STY strng2l	      ; Y retten
          LDA #$D0
          STA FAC1            ; Zeiger auf Befehlstabelle ($CFD0)
          LDA #$CF
          STA FAC1 +1
          LDY #$00
          STY indflg          ; Token - Zhler lschen
          DEY                 ; nun zeigt (FAC1),Y auf $D0CF
          STX txtptrl         ; rette Zeiger fr Eingabepuffer
          DEX
ny	  INY		      ; erhhe Zeiger fr Befehlstabelle
	  BNE nx
          INC FAC1 +1
nx	  INX
lin	  LDA in,X	      ; hole Zeichen
          CMP #$20
	  BEQ nx	      ; Leerzeichen ignorieren
          SEC
          SBC (FAC1),Y        ; mit Zeichen aus Befehlstabelle vergleichen
	  BEQ ny	      ; stimmt berein, nchstes Zeichen vergleichen
          CMP #$80
	  BNE skiptok	      ; Zeichen stimmt nicht, mit nchstem Befehl vers.
          ORA indflg          ; A = Token, Bit7 = 1
          CMP #$C5            ; Token fr AT?
	  BNE puttok	      ; nein
          LDA in+1 ,X         ; hole folgendes Zeichen
          CMP #$4E            ; ist es N?
	  BEQ skiptok	      ;   dann interpretiere als ATN
          CMP #$4F            ; ist es O?
	  BEQ skiptok	      ;   dann interpretiere als A TO
          LDA #$C5            ; sonst Interpretation als AT
puttok	  LDY strng2l	      ; hole gerettetes Y (Zeiger fr kodierte Zeile)
; Einsprung bei ?, :, :, 0..9 oder DATA
putin	  INX		      ; Zeiger erhhen
          INY
          STA $01FB,Y         ; Zeichen oder Token eintragen
          LDA $01FB,Y         ; Z - Flag aktualisieren
	  BEQ done	      ; Endmarke erreicht, Kodierung beendet
          SEC
          SBC #$3A            ; ASCII fr ':'?
	  BEQ ssf	      ; ja, DATA - Flag lschen
          CMP #$49            ; DATA - Token ($49+$3A=$83) ?
	  BNE rem_	      ; nein -->
ssf	  STA dataflg	      ; sonst DATA - Flag setzen (bit 6 = 1)
rem_	  SEC
          SBC #$78            ; REM - Token ($3A+$78=$B2) ?
	  BNE nxchr	      ; nein -->
          STA endchr          ; REM erkannt, bis Endmarke bernehmen
shftin	  LDA in,X	      ; hole neues Zeichen
	  BEQ putin	      ; Zeilenende, fertig
          CMP endchr          ; gemerktes Anfhrungszeichen?
	  BEQ putin	      ; ja, von nun an wieder kodieren
shin	  INY		      ; sonst weiter bernehmen bis $0 oder '"'
          STA $01FB,Y
          INX
	  BNE shftin	      ; unbedingter Sprung
; Tabellenzeiger auf nchstes Token setzen
skiptok   LDX txtptrl	      ; hole Zeiger fr Eingabezeile
          INC indflg          ; Tokenzhler erhhen
sk2	  LDA (FAC1),Y	      ; hole Zeichen aus Tabelle
          INY                 ; Zeiger erhhen
	  BNE plu_
          INC FAC1 +1
plu_	  ASL		      ; bit 7 ins Carry (beim letzten Zeichen gesetzt)
	  BCC sk2	      ; weiter
          LDA (FAC1),Y        ; 1. Zeichen des nchsten Befehls in der Tabelle
	  BNE lin	      ; prfen, ob es dieser Befehl ist
          LDA in,X            ; kein Befehl passt, Zeichen unkodiert bernehmen
	  BPL puttok	      ; und mit dem nchsten Zeichen weitermachen
; Routine abschlieen
done	  STA $01FD,Y	      ; Endmarke eintragen
          DEC txtptrh         ; 'txtptr' auf $01FF setzen
          LDA #$FF
          STA txtptrl
          RTS

; Lokalisiere BASIC - Zeilennummer
; I: linnum (Zeilennummer)
; O: gefunden -> C=1; lowtr zeigt auf Zeilenanfang
;    nicht gefunden -> C=0; lowtr zeigt auf nchste Zeile
fndlin    LDA texttabl        ; Zeiger auf erste Programmzeile
          LDX texttabh
fl1	  LDY #$01
          STA lowtrl
          STX lowtrh
	  LDA (lowtrl),Y      ; Linkadresse, MSB
	  BEQ nosuch	      ; Programmende, zurck mit C=0
          INY
          INY
          LDA linnumh
          CMP (lowtrl),Y
	  BCC ret3	      ; gesuchte Zeile existiert nicht
	  BEQ fl2	      ; MSB stimmt, vergleiche LSB
          DEY                 ; stimmt nicht, weiter bei nchster Zeile
	  BNE getlink	      ; ungedingter Sprung
fl2	  LDA linnuml
          DEY
          CMP (lowtrl),Y
	  BCC ret3	      ; existiert nicht, zurck mit C=0
	  BEQ ret3	      ; Zeile gefunden, C=1
getlink   DEY
          LDA (lowtrl),Y      ; setze Zeiger auf Anfang der nchsten Zeile
          TAX
          DEY
          LDA (lowtrl),Y
	  BCS fl1	      ; unbedingter Sprung
nosuch	  CLC		      ; Einsprung falls Zeile nicht gefunden
ret3	  RTS

; NEW  - Function Handler
; Das Programm wird nicht wirklich gelscht, stattdessen wird das Linkfeld der
; ersten Zeile auf $0000 gesetzt.
new	  BNE ret3	      ; nur durchfhren, falls Endmarke folgt
scrtch	  LDA #$00
	  STA lock	      ; lsche Autostart-Flag
          TAY
          STA (texttabl),Y    ; setze zwei EOL an den Anfang
          INY                 ;   des Programmspeichers
          STA (texttabl),Y
          LDA texttabl        ; setze Anfang der Variablen und Programm-Ende +1
          ADC #$02            ; jeweils auf Programm-Anfang + 2
          STA vartabl
          STA prgendl
          LDA texttabh
          ADC #$00
          STA vartabh
	  STA prgendh
setptrs   JSR stxtpt	      ; setze 'txtptr' auf Programmanfang - 1
          LDA #$00            ; CLEAR durchfhren

; CLEAR - Function Handler
clear	  BNE ret4	      ; nur durchfhren, falls Endzeichen folgt
clearc	  LDA memsizel	      ; unteres Stringende auf HIMEN setzen,
          LDY memsizeh        ;   d.h. alle Strings lschen
          STA fretopl
          STY fretoph
          LDA vartabl         ; Feldvariablen - Anfangszeiger und Variablen -
          LDY vartabh         ; Endzeiger := Variablen - Anfangszeiger,
          STA arytabl         ;   d.h. smtliche Variablen lschen
          STY arytabh
          STA strendl
          STY strendh
          JSR restore         ; initialisiere 'datptr'
; Stack initialisieren
stkini	  LDX #$55
          STX temppt          ; Deskriptorenstack initialisieren
          PLA                 ; rette Rcksprungadresse
          TAY
          PLA
          LDX #$F8
          TXS                 ; den Stackpointer initialisieren
          PHA
          TYA
          PHA                 ; und die Rcksprungadresse wiederholen
          LDA #$00
          STA otxtptrh        ; CONT unterbinden
          STA subflg          ; normale Variablenbehandlung
ret4	  RTS

; 'txtptr' auf Programmstart - 1 setzen
stxtpt	  CLC
          LDA texttabl
          ADC #$FF
          STA txtptrl
          LDA texttabh
          ADC #$FF
          STA txtptrh
          RTS

; LIST - Function Handler
list	  BCC strtrng	      ; Ziffer folgt --> Anfangswert angegeben
	  BEQ strtrng	      ; nix --> alles auflisten
          CMP #$C9            ;
	  BEQ strtrng	      ; '-' - Token --> Endpunkt angegeben
          CMP #$2C            ; ',' ist auch ok,
	  BNE ret4	      ; sonst tschss
strtrng   JSR linget	      ; interpretiere Zeilennummer falls C = 0
          JSR fndlin          ; suche zugehrige Zeile
          JSR chargot         ; hole nchstes Befehlszeichen
	  BEQ mainlst	      ; war keins, alles listen
          CMP #$C9            ;
	  BEQ endrng	      ; es ist '-'
          CMP #$2C            ; oder ','
	  BNE ret3	      ; sonst falsche Syntax
endrng	  JSR charget	      ; neues Befehlszeichen
          JSR linget          ; zweite Zeilennummer aus Programmtext holen
	  BNE ret4	      ; kommt noch was --> Ende
mainlst   PLA		      ; Rcksprungadresse vom Stack holen
          PLA
          LDA linnuml         ; letzte zu listende Zeile
          ORA linnumh         ;  (beide null, falls nichts angegeben)
	  BNE nxlst
          LDA #$FF            ; da nichts angegeben, auf Maximalwert setzen
          STA linnuml
          STA linnumh
nxlst	  LDY #$01
	  LDA (lowtrl),Y      ; Linkadresse, MSB
	  BEQ listed	      ; Programmende erreicht, fertig
          JSR iscntc          ; kam ctrl-C?
          JSR crdo
          INY
          LDA (lowtrl),Y      ; aktuelle Zeilennummer nach X, A
          TAX
          INY
          LDA (lowtrl),Y
          CMP linnumh         ; mit Bereichsende vergleichen
	  BNE lstd_
          CPX linnuml
	  BEQ lst1lin
lstd_	  BCS listed	      ; berschritten, fertig
lst1lin   STY forpntl	      ; Index retten
          JSR linprt          ; Zeilennummer drucken
          LDA #$20            ; Leerzeichen
listloop  LDY forpntl	      ; Index wieder holen
          AND #$7F
sendchr   JSR outdo	      ; ASCII - Zeichen im Akku drucken
          LDA ch
          CMP #$21            ; schon in Spalte 33 ?
	  BCC ncr
          JSR crdo            ; neue Zeile,
          LDA #$05            ;  in Spalte 5 beginnen
          STA ch
ncr	  INY
          LDA (lowtrl),Y      ; nchstes Zeichen
	  BNE token_	      ; nicht Zeilenende, --> zur Druckroutine
          TAY                 ; =0
          LDA (lowtrl),Y      ; Linkadresse = Anfang der nchsten Zeile
          TAX
          INY
          LDA (lowtrl),Y
          STX lowtrl          ; auf Zeiger bertragen
          STA lowtrh
	  BNE nxlst	      ; weiter mit dieser neuen Zeile (unbedingt)
listed	  LDA #$0D
          JSR outdo           ; CR ausgeben
          JMP newstt          ; weiter in der Interpreter - Hauptschleife
; Hole neues Zeichen aus der Applesoft - Befehlstabelle
getchr	  INY		      ; Zeiger um 1 erhhen
	  BNE gc
          INC FAC1 +1
gc	  LDA (FAC1),Y	      ; Zeichen laden
          RTS
; Druckroutine fr LIST
token_	  BPL sendchr	      ; kein Token, also drucken und weiter
          SEC                 ; Token
          SBC #$7F            ; minus 127
          TAX                 ; als Zhler fr Suchschleife
          STY forpntl         ; Zeiger fr Programmzeile retten
          LDY #$D0            ; Zeiger auf Anfang der Befehlstabelle
          STY FAC1
          LDY #$CF
          STY FAC1 +1
          LDY #$FF            ; (FAC1),Y zeigt nun auf $D0CF
skptk	  DEX		      ; nchster Befehl (=0 falls richtiger Befehl)
	  BEQ prtok	      ; ist der Fall, Befehl ausdrucken
toklp	  JSR getchr	      ; hole nchstes Zeichen
	  BPL toklp	      ; weiter bis Befehlsende erreicht (bit 7 = 1)
	  BMI skptk	      ; weiter mit nchstem Befehl
prtok	  LDA #$20
          JSR outdo           ; Leerzeichen drucken
toklup	  JSR getchr	      ; neues Zeichen aus Befehlstabelle
	  BMI tokdone	      ; bit 7 = 1, Befehl fertig
          JSR outdo           ; Zeichen drucken
	  BNE toklup	      ; weiter mit nchstem Zeichen (unbedingt)
tokdone   JSR outdo	      ; letztes Zeichen drucken
          LDA #$20            ; Leerzeichen
	  BNE listloop	      ; weiter im Listing (unbedingt)

; FOR - Function Handler
for       LDA #$80
          STA subflg          ; Integer als Laufvariable verboten
          JSR let             ; Anfangswert der Laufvariable zuweisen
	  JSR gtforpnt	      ; existiert schon eine Schleife mit dieser Var.?
          BNE for2            ; nein --> weiter
          TXA                 ; sonst alte Schleife vom Stack werfen
          ADC #$0F
          TAX
          TXS
for2      PLA                 ; Rcksprungadresse entfernen
          PLA
          LDA #$09
	  JSR chkmem	      ; noch Platz fr 18 Byte im Stack?
          JSR datan           ; suche nchstes EOS/EOL
          CLC                 ; Startadresse des Schleifenkrpers berechnen:
          TYA                 ; Abstand zum nchsten Befehl
          ADC txtptrl         ;  zum aktuellen Zeiger addieren
          PHA                 ;  und auf Stack schieben
          LDA txtptrh
          ADC #$00
          PHA
          LDA curlinh
          PHA
          LDA curlinl
          PHA                 ; aktuelle Zeilennummer auf Stack schieben
          LDA #$C1
          JSR synchr          ; Syntax-check auf 'TO'
          JSR chknum          ; Prfung, ob Laufvariable numerisch
          JSR frmnum          ; Ausdruck nach TO auswerten
	  LDA FAC1sign	      ; Vorzeichen von FAC1 (bit 7 = 0 falls +)
          ORA #$7F            ; in MSB von FAC1 eintragen
          AND FAC1+1
          STA FAC1+1
	  LDA #step # 256
	  LDY #step / 256     ; Adresse fr indirekten Sprung $D7AF merken
          STA indexl
          STY indexh
	  JMP pushfac	      ; FAC1 (Schl.endwert) auf Stack, dann hier weiter
step	  LDA #one # 256      ; Zeiger auf FP - Konstante 1.0
          LDY #one / 256
          JSR movfm           ; 1 als Standard - STEP auf Stack
          JSR chargot
          CMP #$C7            ; folgt 'STEP' - Token ?
	  BNE onestep	      ; nein --> weiter
          JSR charget
          JSR frmnum          ; sonst Ausdruck auswerten
onestep   JSR sign	      ; Vorzeichen in den Akku
	  JSR pshfacx	      ; FAC1 (STEP-Wert) und VZ auf Stack
          LDA forpnth
          PHA
          LDA forpntl
          PHA                 ; Zeiger auf Laufvariable sichern
          LDA #$81
          PHA                 ; FOR - Token als Flag sichern

; Interpreter - Hauptschleife (Befehlsausfhrung)
newstt    TSX
          STX remstk          ; rette Stackpointer
          JSR iscntc          ; teste auf ctrl-C
          LDA txtptrl
          LDY txtptrh
          LDX curlinh
          INX                 ; teste direct mode flag
	  BEQ dirct	      ; $FF --> DIrektmodus
          STA otxtptrl
          STY otxtptrh
dirct	  LDY #$00
          LDA (txtptrl),Y     ; lies letztes Zeichen
	  BNE colon_	      ; wenn kein EOL,teste EOS
          LDY #$02
	  LDA (txtptrl),Y     ; lies Linkadresse MSB
          CLC
	  BEQ goend	      ; Programmende --> Warmstart (C = 0)
          INY                 ; sonst neue Zeilennummer holen
          LDA (txtptrl),Y
          STA curlinl         ; und in den Zeilenzeiger eintragen
          INY
          LDA (txtptrl),Y
          STA curlinh
          TYA                 ; Linkfeld Offset -> Akku
          ADC txtptrl
          STA txtptrl         ; justiere 'txtptr'
	  BCC trace_
          INC txtptrh

; Ersteinsprung bei Direktmodus (vgl. $D459)
; fhre einzelne Anweisung aus
trace_	  BIT trcflg	      ; tracebit testen
	  BPL tr1	      ; bit7=0 -> kein TRACE
          LDX curlinh         ; = 255 falls im Direktmodus
          INX
	  BEQ tr1	      ; direct mode: kein TRACE
          LDA #$23
          JSR outdo           ; '#' ausgeben
          LDX curlinl
          LDA curlinh
          JSR linprt          ; aktuelle Zeilennummer drucken
          JSR outsp           ; drucke ein Leerzeichen
tr1	  JSR charget	      ; lies erstes Byte
	  JSR gocmd	      ; rufe Token-Handler auf
          JMP newstt          ; weiter in der Interpreter-Hauptschleife

goend	  BEQ end4

; Applesoft - Function - Handler aufrufen
; I: Akku enthlt Token
gocmd	  BEQ ret5	      ; EOL,EOS -> Return
gocmd2	  SBC #$80	      ; substr. Tokenoffset
	  BCC notok	      ; Akku < $80 -> kein Token, kann nur LET sein
          CMP #$40            ; Token gltig?
	  BCS jsy	      ; >$BF, kein primrer Befehl -> Syntax Error
          ASL                 ; generiere Pointer
          TAY
	  LDA cmdtabl+1,Y     ; lege Handler-Adresse auf Stack
          PHA
	  LDA cmdtabl,Y
          PHA
          JMP charget         ; hole nchstes Zeichen, Return zum Handler

notok	  JMP let	      ; direkt zum LET-Handler

colon_	  CMP #$3A	      ; vergleiche mit EOS ':'
	  BEQ trace_	      ; wenn gleich, nchste Anweisung ausfhren
jsy	  JMP synerr	      ; sonst Syntax Error ausgeben

; RESTORE - Function Handler
restore   SEC
          LDA texttabl
          SBC #$01
          LDY texttabh
	  BCS setda
          DEY
setda	  STA datptrl	      ; setze DATA-Pointer auf
          STY datptrh         ; Start of Program
ret5	  RTS

; ctrl-C - Test
iscntc    LDA kbd             ; lies Keyboard
          CMP #$83            ; ist es ctrl-C
	  BEQ gk	      ; ja, behandle Unterbrechung
          RTS
gk	  JSR inchr	      ; lies Kbd regulr
erflg_	  LDX #$FF
          BIT errflg          ; teste ONERR - Flag
	  BPL ctrc_	      ; bit7=0 -> normale Fehlerbehandlung
	  JMP handlerr
ctrc_	  CMP #$03	      ; C = 1 wenn ctrl-C oder grer

; STOP - Function Handler
; I: C=1 (falls keine Ziffer folgt)
stop	  BCS end2

; END - Function Handler
end       CLC
end2	  BNE ret6	      ; es folgt kein Endezeichen, Routine abbrechen
          LDA txtptrl         ; Zeiger auf Trennzeichen vor letztem Befehl
          LDY txtptrh
          LDX curlinh
          INX                 ; teste direct mode flag
	  BEQ end3	      ; --> Direktmodus
          STA otxtptrl        ; letzten Befehl
          STY otxtptrh
          LDA curlinl         ; und letzte Zeilennummer retten
          LDY curlinh
          STA oldlinl
          STY oldlinh
end3	  PLA		      ; Rcksprungadresse entfernen
          PLA
end4	  LDA #breakin # 256
	  LDY #breakin / 256  ; Text 'BREAK'
	  BCC gostart	      ; C = 0 wenn END
	  JMP prntin_	      ; sonst Break-Meldung ausgeben
gostart   JMP restart

; CONT - Function Handler
cont	  BNE ret6	      ; nchstes Zeichen kein Trennzeichen --> Return
cantctp   LDX #$D2            ; Offset Fehlermeldung
          LDY otxtptrh        ; = 0 nach Clear, sonst geretteter Zeiger
	  BNE con	      ; <>0 --> ok
          JMP error           ; 'Cant continue' - Error
con	  LDA otxtptrl
          STA txtptrl         ; setze 'txtptr' auf zu-
          STY txtptrh         ; letzt bearbeitete Zeile
          LDA oldlinl
          LDY oldlinh         ; hole Nummer der unterbrochenen Zeile
          STA curlinl
          STY curlinh         ; setze 'curlin'
ret6	  RTS

; SAVE - Function Handler
save      SEC
          LDA prgendl         ; Programmtext - Ende
          SBC texttabl        ; minus Programmtext - Anfang
          STA linnuml         ; ergibt Lnge des Programmtextes
          LDA prgendh
          SBC texttabh
          STA linnumh
	  JSR vartio	      ; Bereich $50-52 schreiben
          JSR twrite          ;   (Programmlnge)
	  JSR progio	      ; Programm schreiben
          JMP twrite          ; RTS von dort

; LOAD - Function Handler
load	  JSR vartio	      ; Bereich $50-52 lesen
          JSR tread
          CLC
          LDA texttabl        ; Programmtext - Anfang
          ADC linnuml         ; plus Lnge
          STA vartabl         ; ergibt Programmtext - Ende + 1
          LDA texttabh
          ADC linnumh
          STA vartabh
          LDA temppt
	  STA lock	      ; Autostart - Flag eintragen
	  JSR progio
          JSR tread           ; Programm lesen
	  BIT lock	      ; prfe Autostart - Flag
	  BPL jlnk	      ; nicht gesetzt
	  JMP setptrs	      ; sonst 'txtptr' auf Anfang, RUN durchfhren
jlnk	  JMP linkset	      ; CLEAR durchfhren, dann Warmstart

; Setze Monitor - Register fr Lngendaten
vartio	  LDA #$50
          LDY #$00
          STA a1l
          STY a1h             ; 'a1' := $0050 (Start)
          LDA #$52
          STA a2l
          STY a2h             ; 'a2' := $0052 (Ende)
	  STY lock	      ; kein Autostart
          RTS

; Setze Monitor - Register fr Programmtext
progio	  LDA texttabl
          LDY texttabh
          STA a1l             ; 'a1' := 'texttab'
          STY a1h             ;   (Start)
          LDA vartabl
          LDY vartabh
          STA a2l             ; 'a2' := 'vartab'
          STY a2h             ;   (Ende)
          RTS

; RUN - Function Handler
run       PHP                 ; rette Z (gesetzt falls Trennzeichen folgt)
          DEC curlinh         ; lsche direct mode (nun sicher <> 255)
          PLP
	  BNE runline	      ; es folgt kein Trennzeichen -> bedingtes RUN
	  JMP setptrs	      ; 'txtptr' auf Anfang, RUN
runline   JSR clearc	      ; Variablen lschen
	  JMP goline	      ; GOTO ausfhren

; GOSUB - Function Handler
gosub     LDA #$03
	  JSR chkmem	      ; noch 6 Byte Platz auf dem Stack?
          LDA txtptrh
          PHA
          LDA txtptrl         ; sichere 'txtptr'
          PHA
          LDA curlinh
          PHA
          LDA curlinl         ; sichere aktuelle Zeilennummer
          PHA
          LDA #$B0
          PHA                 ; GOSUB-Token als Flag
goline	  JSR chargot	      ; hole erste Ziffer des Sprungzieles
          JSR goto            ; fhre GOTO aus
          JMP newstt          ; weiter in der Interpretationsschleife

; GOTO - Function Handler
goto      JSR linget          ; lies Zeilennummer
          JSR remn            ; berechne Offset zum EOL --> Y
	  LDA curlinh	      ; aktuelle Zeilennummer, MSB
	  CMP linnumh	      ; anzuspringende Zeilennummer, MSB
	  BCS go1	      ; suche ab Programm-Anfang
          TYA                 ; hole Lnge der aktuellen Zeile
          SEC
          ADC txtptrl         ; addieren, 'txtptr' zeigt nun auf nchste Zeile
          LDX txtptrh
	  BCC go2
          INX
	  BCS go2	      ; immer
go1	  LDA texttabl
          LDX texttabh        ; hole Programmstartpointer
go2	  JSR fl1	      ; suche Programmzeile mit Zeilenr in 'linnum'
	  BCC udefsp	      ; Cy=0 -> nicht gefunden, UNDEF'D STATEMENT ERROR
          LDA lowtrl          ; sonst Startadresse
          SBC #$01            ;  minus 1 (Cy=1)
          STA txtptrl         ;  gibt neuen 'txtptr'
          LDA lowtrh
          SBC #$00            ; Bercksichtige bertrag
          STA txtptrh         ; 'txtptr' steht nun auf
ret7	  RTS		      ;  EOL vor der Zielzeile

; RETURN - und POP - Function Handler
pop	  BNE ret7	      ; nur durchfhren, falls Trennzeichen folgt
          LDA #$FF            ; verhindern, da Laufvariable erkannt wird
          STA forpntl         ;  falls offene FOR/NEXT - Schleife auf Stack
	  JSR gtforpnt	      ; suche nchsten Block im Stack
          TXS                 ; 2 Rckspradr und evtl Schleifenparam entfernen
          CMP #$B0            ; ist es GOSUB-Flag?
	  BEQ return	      ; ja, weiter mit RETURN / POP

underr	  LDX #$16	      ; Ptr auf 'RURN WITHOUT GOSUB'
          BYT $2C             ; Dummy BIT $5AA2
udefsp	  LDX #$5A	      ; Ptr auf 'UNDEF'D STATEMENT'
          JMP error           ; Fehlerbehandlung

gsyner	  JMP synerr	      ; Syntax Error

return	  PLA		      ; hole Flag vom Stack (=$B0)
          PLA                 ; hole 'curlin' LSB
          CPY #$42            ; machen wir POP?
	  BEQ pull3	      ; ja,korrigiere SP direkt
          STA curlinl
          PLA
          STA curlinh         ; sonst 'curlin' und
          PLA                 ;  'txtptr' wiederherstellen
          STA txtptrl
          PLA
          STA txtptrh

; DATA - Einsprung
data      JSR datan           ; berechne Differenz zum nchsten Trennzeichen
addon	  TYA		      ;  (EOS/EOL)
	  CLC
          ADC txtptrl         ; addiere zum 'txtptr'
          STA txtptrl
	  BCC ret8
          INC txtptrh
ret8	  RTS

; Suche nchstes Trennzeichen (EOS / EOL)
; O: Abstand in Y

; Einsprung fr EOS ':' suchen
datan     LDX #$3A            ; ASCII fr ':' End of Statement
          BYT $2C             ; Dummy BIT $00A2
; Einsprung fr EOL $00 suchen
remn      LDX #$00            ; End of Line
          STX charac          ; Suchmarke merken
          LDY #$00
          STY endchr          ; EOL ist alternative Suchmarke
rm1	  LDA endchr
          LDX charac
          STA charac
          STX endchr          ; vertausche Suchmarken
rm2	  LDA (txtptrl),Y     ; hole BASIC-Zeichen
	  BEQ ret8	      ; Zeilenende, fertig
          CMP endchr          ; primres Suchzeichen?
	  BEQ ret8	      ; ja, fertig
          INY                 ; nchstes Zeichen
          CMP #$22            ; ist es Quote '"'?
	  BNE rm2	      ; nein, suche weiter
	  BEQ rm1	      ; innerhalb eines Strings EOS ignorieren

; POP durchfhren
pull3	  PLA		      ; Zeilennummer MSB und
          PLA                 ;  'txtptr' vom Stack werfen
          PLA
          RTS

; IF - Function Handler
if	  JSR frmevl	      ; berechne If-Ausdruck
          JSR chargot         ; Zeichen danach holen
          CMP #$AB            ; ist es GOTO?
	  BEQ true_
          LDA #$C4            ; ist es THEN?
          JSR synchr          ;  wenn nicht, Syntaxfehler
true_	  LDA FAC1exp	      ; Ergebnis-Flag,
	  BNE iftrue	      ;  <> 0 falls Bedingung erfllt

; REM - Function Handler
rem       JSR remn            ; Offset zum EOL berechnen
	  BEQ addon	      ; immer
iftrue	  JSR chargot	      ; lies nchstes Zeichen
	  BCS jgocmd	      ; Cy=1 -> Ausdruck
          JMP goto            ; sonst Zeilennummer, weiter bei GOTO
jgocmd	  JMP gocmd	      ; zur Befehlsausfhrung

; ON - Function Handler
ongoto	  JSR getbyt	      ; Berechne Ausdruck -> 'vpnth'
          PHA                 ; nchstes Zeichen auf Stack retten
          CMP #$B0            ; ist es GOSUB?
	  BEQ oncnt
goto_	  CMP #$AB	      ; ist es GOTO?
	  BNE gsyner	      ; nein -> Syntax Error
oncnt	  DEC vpnth	      ; Index als Zhler
	  BNE nxnum	      ; gewnschte Sprungadresse noch nicht erreicht
          PLA                 ; hole Zeichen zurck
	  JMP gocmd2	      ; und interpretiere es
nxnum	  JSR charget	      ; lies neues Zeichen
          JSR linget          ; um eine Sprungadresse weiterrcken
          CMP #$2C            ; folgt ein Komma?
	  BEQ oncnt	      ; weitere Nummern existieren
          PLA                 ; sonst ON - Statement ignorieren
ret9	  RTS

; Interpretiere BASIC-Zeilennummer
; I: A = 1.Zeichen, Cy = 0 falls Ziffer
; O: 'linnum' enthlt die Zeilennummer, A das nchste Zeichen
linget    LDX #$00
          STX linnuml
          STX linnumh         ; Zeilennummer lschen
aschex	  BCS ret9	      ; keine Ziffer, fertig
          SBC #$2F
          STA charac          ; $30 subtrahieren gibt reine Ziffer ($0..$9)
          LDA linnumh
          STA indexl
	  CMP #$19	      ; MSB der Zeilennummer ber 25?
	  BCS goto_	      ;  (25*256 =64000) --> zu gro, SYNTAX ERROR
          LDA linnuml
          ASL
          ROL indexl
          ASL
          ROL indexl
          ADC linnuml
          STA linnuml
          LDA indexl
          ADC linnumh
          STA linnumh
          ASL linnuml
          ROL linnumh         ; 'linnum' := 'linnum' * 10
          LDA linnuml
          ADC charac          ; gemerkte Ziffer addieren
          STA linnuml
	  BCC nxdig
          INC linnumh         
nxdig	  JSR charget	      ; hole nchstes Zeichen
	  JMP aschex	      ; weiter falls Ziffer und kein berlauf

; LET - Function Handler
;
; Einfache Variablen belegen immer 7 Byte.
; FP:  Name1 (bit7=0), Name2 (bit7=0), Exponent, Mantisse
; Int: Name1 (bit7=1), Name2 (bit7=0), MSB, LSB, $00, $00, $00
; Str: Name1 (bit7=0), Name2 (bit7=1), Deskriptor, $00, $00
;      Deskriptor: Adresse LSB, MSB, Lnge
let       JSR ptrget          ; angegebene Variable suchen oder neu einrichten
          STA forpntl         ; rette Pointer zum Variablenwert
          STY forpnth
          LDA #$D0            ; Token fr '=' mu folgen,
          JSR synchr          ;  sonst SYNTAX ERROR
          LDA numtyp
          PHA                 ; Flags fr Integer- und Stringvariable auf Stack
          LDA valtyp
          PHA
          JSR frmevl          ; berechne Ausdruck
          PLA                 ; bit 7 = 1 falls Stringvariable angegeben wurde
          ROL                 ; Cy := bit7
	  JSR chkval	      ; stimmen Ausdruck und Variablentyp berein?
	  BNE letstr	      ; Stringausdruck in Stringvariable eintragen
          PLA                 ; bit 7 von 'numtyp' = 1 falls Integer angegeben
let2	  BPL letreal	      ; bit7=0 -> Real
	  JSR rndb	      ; FAC1 runden
          JSR ayint           ; wandle FAC1 in Integer
          LDY #$00
	  LDA vpntl
          STA (forpntl),Y     ; Integer in die Variable eintragen
          INY
	  LDA vpnth
          STA (forpntl),Y
          RTS

letreal   JMP setfor	      ; FAC1 gepackt in die Variable eintragen

; Stringdeskriptor in die Variable eintragen
; I: 'vpnt' zeigt auf Deskriptor; 'forpnt' auf die Variable
; O: $8C.8D zeigt auf Originaldeskriptor; Y=2
letstr	  PLA		      ; Einsprung von LET, Integerflag entfernen
putstr	  LDY #$02
	  LDA (vpntl),Y       ; Stringanfang im Stringbereich, d.h >= 'fretop'?
          CMP fretoph
	  BCC copstr	      ; nein, weiter
	  BNE desc_	      ; ja, prfe zweite Voraussetzung
          DEY
	  LDA (vpntl),Y
	  CMP fretopl	      ; vergleiche LSB
	  BCC copstr	      ; nicht im Stringbereich, weiter
desc_	  LDY vpnth	      ; Deskriptor im Var.bereich, d.h. >= 'vartab'
	  CPY vartabh	      ; vergleiche MSB
	  BCC copstr	      ; nein, weiter
	  BNE newdesc	      ; ja, String in den Stringbereich bertragen
	  LDA vpntl
	  CMP vartabl	      ; vergleiche LSB
	  BCS newdesc	      ; String in den Stringbereich bertragen
copstr	  LDA vpntl	      ; Zeiger auf Deskriptor
	  LDY vpnth
	  JMP copy	      ; Deskriptor in die angegebene Variable eintragen

; String in den Stringbereich bertragen
newdesc   LDY #$00
	  LDA (vpntl),Y       ; Stringlnge
          JSR strini          ; Anfang Strings herabsetzen, neuer Deskr in FAC1
	  LDA dscptrl	      ; Zeiger auf Originaldeskriptor
	  LDY dscptrh
	  STA strng1l	      ; auf Hilfszeiger bertragen
	  STY strng1h
          JSR movins          ; String in den Stringbereich kopieren
	  LDA #FAC1 # 256     ; Zeiger auf neuen Deskriptor
	  LDY #FAC1 / 256

; DEskriptor in Variable eintragen
copy	  STA dscptrl	      ; Zeiger auf gltigen Deskriptor
	  STY dscptrh
	  JSR fretms	      ; Desk. aus Deskr.-Stack entfernen falls obenauf
          LDY #$00            ; Deskriptor kopieren
	  LDA (dscptrl),Y     ; Lnge
          STA (forpntl),Y
          INY
	  LDA (dscptrl),Y     ; Adresse LSB
          STA (forpntl),Y
          INY
	  LDA (dscptrl),Y     ; Adresse MSB
          STA (forpntl),Y
          RTS

prstring  JSR strprt	      ; String drucken
          JSR chargot         ; hole neues Zeichen

; PRINT - Function Handler
print     BEQ crdo            ; folgt nichts -> crlf und fertig
print2	  BEQ ret10	      ; folgt nichts -> fertig
          CMP #$C0            ; 'TAB(' - Token
	  BEQ tabwhere	      ; ja, Cursor positionieren (Cy=1)
          CMP #$C3            ; 'SPC(' - Token
          CLC
	  BEQ tabwhere	      ; ja, Space ausgeben (Cy=0)
          CMP #$2C            ; ASCII fr ','
          CLC
	  BEQ tab	      ; ja, Tabulatorsprung
          CMP #$3B            ; ASCII fr ';'
	  BEQ nextchr	      ; ja, falls EOL/EOS folgt kein crlf ausgeben
          JSR frmevl          ; sonst folgenden Ausdruck berechnen
          BIT valtyp          ; Stringflag prfen
	  BMI prstring	      ; String drucken
          JSR fout            ; sonst FAC1 in String umwandeln
	  JSR strlit	      ; Stringparameter feststellen
	  JMP prstring	      ; und String drucken

; CR ausgeben
crdo      LDA #$0D
          JSR outdo
negate	  EOR #$FF	      ; das brauchen wir spter
ret10	  RTS

; ',' - Tab ausgeben (8)
tab	  LDA ch
          CMP #$18            ; Zeilenende erreicht?
	  BCC nxclm	      ; kleiner, bleibt in der selben Zeile
          JSR crdo            ; neue Zeile
	  BNE nextchr	      ; und am Anfang los
nxclm	  ADC #$10	      ; nchstes Vielfaches von 16 bestimmen
          AND #$F0
          STA ch              ; Cursorposition setzen
	  BCC nextchr	      ; und weiter mit neuem Zeichen (unbedingt)

; TAB( -  und SPC( - Function Handler
tabwhere  PHP		      ; Cy retten
	  JSR gtbytc	      ; hole 8 bit - Integer aus Programmtext -> X
          CMP #$29            ; folgendes Zeichen = ')'?
	  BEQ spc_	      ; ok, weiter
	  JMP synerr	      ; sonst 'SYNTAX ERROR'
spc_	  PLP		      ; hole Cy wieder
	  BCC tabit	      ; C=0 -> SPC(, Leerzeichen drucken
          DEX
          TXA                 ; TAB - Wert
          SBC ch              ; Cursor-Spalte abziehen
	  BCC nextchr	      ; Ziel links von aktueller Pos, TAB ignorieren
          TAX                 ; Differenz = Anzahl zu druckender Leerzeichen
tabit	  INX
nxspc	  DEX
	  BNE dospc	      ; Leerzeichen drucken

; ';' - Tab ausgeben (quasi Null)
nextchr   JSR charget	      ; nchstes Zeichen
          JMP print2          ;   verarbeiten
dospc	  JSR outsp
	  BNE nxspc	      ; (immer)

; String ausgeben
strout	  JSR strlit	      ; String auswerten
; String ausgeben
strprt	  JSR frefac	      ; Deskriptorenstack bereinigen
          TAX                 ; Lnge des Strings
          LDY #$00            ; Zeiger initialisieren
          INX
nxchar	  DEX
	  BEQ ret10	      ; fertig, -->
          LDA (indexl),Y      ; hole Zeichen
          JSR outdo           ; und drucke es
          INY
          CMP #$0D            ; ist es CR?
	  BNE nxchar	      ; nein, weiter
	  JSR negate	      ; invertieren
	  JMP nxchar	      ; und weiter mit dem nchsten Zeichen

; Blank ausgeben
outsp     LDA #$20
          BYT $2C             ; 'BIT $3FA9'
; Fragezeichen ausgeben
outques   LDA #$3F
; Drucke ASCII-Zeichen incl. Speed, Mode
outdo     ORA #$80            ; Bit 7 setzen
          CMP #$A0
	  BCC send	      ; bei ctrl-Zeichen FLASH-Flag ignorieren
          ORA ormask          ; Bit 6 setzen bei FLASH
send	  JSR cout	      ; Zeichen ber Monitorroutine drucken
          AND #$7F            ; Bit 7 lschen
          PHA                 ; Zeichen retten
	  LDA speedz
          JSR wait            ; SPEED-Wert warten
          PLA                 ; Zeichen zurckholen
          RTS

; Fehleingabenbehandlung fr INPUT und READ
inputerr  LDA intypflg
	  BEQ resperr	      ; Fehler bei INPUT ($00)
	  BMI readerr	      ; Fehler bei READ ($98)
          LDY #$FF            ; Fehler bei Get, simuliere Direktmodus
	  BNE erlin
readerr   LDA datlinl	      ; DATA-Zeile holen
          LDY datlinh
erlin	  STA curlinl	      ; als aktuelle Zeile nehmen
          STY curlinh         ;  (bei GET-Fehler = $FF)
	  JMP synerr	      ; 'SYNTAX ERROR'
inperr	  PLA		      ; extra Einsprung bei INPUT - Fehler
resperr   BIT errflg
	  BPL doreent	      ; kein ONERR
          LDX #$FE            ; sonst Code fr INPUT-Fehler laden
	  JMP handlerr		;  und zur Fehlerbehandlung
doreent   LDA #reent # 256
	  LDY #reent / 256
          JSR strout          ; '?REENTER' ausgeben
          LDA otxtptrl
          LDY otxtptrh
          STA txtptrl         ; 'txtptr' wiederherstellen
          STY txtptrh
          RTS                 ; INPUT - Anweisung erneut durchfhren

; GET - Function Handler
get       JSR errdir          ; falls Direktmodus ILLEGAL DIRECT ERROR
          LDX #$01            ;  'inpsrce' auf $0201
          LDY #$02
          LDA #$00
          STA in+1            ; Null als Endmarke
          LDA #$40            ; Eingabeflag auf GET setzen
	  JSR maininp	      ; und READ ausfhren
          RTS

; INPUT - Function Handler
input     CMP #$22            ; folgt '"'?
	  BNE qout	      ; nein, kein Dialogstring
          JSR strtxt          ; String auswerten
          LDA #$3B
          JSR synchr          ; Syntax-Check auf ';'
          JSR strprt          ; String ausgeben
	  JMP dir_	      ; Fragezeichen unterdrcken
qout	  JSR outques	      ; '?' ausgeben
dir_	  JSR errdir	      ; prfen ob im Direktmodus, Fehler wenn ja
          LDA #$2C
          STA in-1            ; Komma vor 'inbuff' setzen
	  JSR inlin	      ; Eingabezeile holen (Y.X zeigt auf $01FF)
          LDA in              ; hole 1. Zeichen
          CMP #$03            ; Test auf ctrl-C
	  BNE zf	      ; nein, READ ausfhren
	  JMP erflg_	      ; sonst ctrl-C verarbeiten, d.h. STOP

nxin	  JSR outques	      ; '?' ausgeben,
	  JMP inlin	      ;  Zeile einlesen

; READ - Function Handler
read      LDX datptrl
          LDY datptrh
          LDA #$98            ; Code fr READ
          BYT $2C             ; 'BIT $00A9'
zf	  LDA #$00	      ; Code fr INPUT

; Haupt - Eingaberoutine
; I: X.Y zeigt auf Eingabedaten, A = Eingabeflag
maininp   STA intypflg	      ; Eingabeflag setzen
          STX inpsrcel        ; Eingabezeiger merken
          STY inpsrceh
nxinp	  JSR ptrget	      ; suche Variable, ggf neu einrichten
          STA forpntl         ; Zeiger auf Variable
          STY forpnth
          LDA txtptrl
          LDY txtptrh
          STA txtptrsvl
          STY txtptrsvh       ; 'txtptr' sichern
          LDX inpsrcel
          LDY inpsrceh
          STX txtptrl
          STY txtptrh         ; 'txtptr' auf Eingabezeiger setzen
          JSR chargot         ; hole Eingabezeichen
	  BNE instart	      ; kein Trennzeichen
	  BIT intypflg
	  BVC sndq_	      ; INPUT/READ zu wenig Daten vorhanden
          JSR rdkey           ; GET, hole Zeichen ber Monitorroutine
          AND #$7F            ; lsche bit 7
          STA in              ; Zeichen eintragen
          LDX #$FF            ; 'inpsrce' auf $01FF
          LDY #$01
	  BNE stxp	      ; immer
sndq_	  BMI findata	      ; READ ($98), weitere Daten suchen
	  JSR outques	      ; INPUT ($00), '?' ausgeben
	  JSR nxin	      ; Engabezeile empfangen (mit 2. Fragezeichen)
stxp	  STX txtptrl
          STY txtptrh
instart   JSR charget	      ; hole Datenzeichen
          BIT valtyp          ; prfe Stringflag
	  BPL numin	      ; numerische Variable ->

; String als Daten
          BIT intypflg
	  BVC putchr	      ; kein GET
          INX
          STX txtptrl         ; Zeiger im Eingabepuffer merken
          LDA #$00
          STA charac          ; EOL als Endmarke fr GET - Zeichen
	  BEQ penchr	      ; berspringen, da fr INPUT/READ
putchr	  STA charac	      ; 1.Zeichen vorlufig als Trennzeichen eintragen
          CMP #$22            ; '"'?
	  BEQ pechr	      ; ja, beide Trennzeichen auf '"'
          LDA #$3A            ; sonst ASCII fr EOS ':'
          STA charac
          LDA #$2C            ; und ASCII fr ',' als Trennzeichen
penchr	  CLC		      ; kein '"', erstes Zeichen gehrt zum String
pechr	  STA endchr
          LDA txtptrl
          LDY txtptrh         ; Datenzeiger
          ADC #$00            ;  um 1 erhhen falls Anfhrungszeichen
	  BCC skp
          INY
skp	  JSR strlt2	      ; String auswerten,Endmarken in 'charac','endchr'
          JSR $E73D           ; 'txtptr' auf Stringende
	  JSR putstr	      ; Deskriptor in Variable eintragen
	  JMP wnx	      ; weiter in der Programmzeile

; numerische Daten
numin	  PHA		      ; rette 1. Datenzeichen
          LDA in              ; setze Z-Flag
	  BEQ inpfin	      ; Endzeichen, d.h. keine Eingabe erfolgt
datin	  PLA		      ; hole Zeichen wieder
          JSR fin             ; String in FP-Konstante in FAC1 umwandeln
          LDA numtyp
	  JSR let2	      ; Wert in Variable eintragen
wnx	  JSR chargot	      ; hole Datenzeichen hinter letztem Datensatz
	  BEQ swpnt	      ; Trennzeichen
          CMP #$2C            ; ist es ','?
	  BEQ swpnt	      ; ja, ok
	  JMP inputerr	      ; sonst Fehlerbehandlung
swpnt	  LDA txtptrl
          LDY txtptrh
          STA inpsrcel
          STY inpsrceh
          LDA txtptrsvl
          LDY txtptrsvh
          STA txtptrl         ; 'txtptr' wiederherstellen
          STY txtptrh
          JSR chargot         ; hole Zeichen aus Programmzeile
	  BEQ inpdone	      ; Trennzeichen, Routine abschlieen
          JSR chkcom          ; prfe ob Komma folgt
	  JMP nxinp	      ; falls ja, weiter mit nchster Eingabe

inpfin	  LDA intypflg
	  BNE datin	      ; kein INPUT -> weiter
	  JMP inperr	      ;  sonst Fehlerbehandlung

; suche DATA - Statement
findata   JSR datan	      ; suche nchstes Trennzeichen, Offset -> Y
          INY
          TAX                 ; Z-Flag aktualisieren
	  BNE nxs	      ; nicht Zeilenende
          LDX #$2A            ; 'OUT OF DATA' - Offset
          INY
	  LDA (txtptrl),Y     ; Linkadresse, MSB
	  BEQ gerr	      ; Programmende -> OUT OF DATA
          INY
	  LDA (txtptrl),Y     ; Zeilennummer LSB
          STA datlinl
          INY
	  LDA (txtptrl),Y     ; und MSB
          INY
          STA datlinh         ; in DATA - Pointer eintragen
nxs	  LDA (txtptrl),Y     ; hole erstes Token
          TAX                 ; in X merken
	  JSR addon	      ; 'txtptr' um Y erhhen
          CPX #$83            ; ist es DATA - Token
	  BNE findata	      ; nein, nchstes DATA - Statement suchen
	  JMP instart	      ; weiter bei unterbrochenem READ

; Eingaberoutine abschlieen
inpdone   LDA inpsrcel	      ; Eingabezeiger holen
          LDY inpsrceh
          LDX intypflg
	  BPL ntd	      ; INPUT oder GET
	  JMP setda	      ; nchstes DATA - Statement in DATA - Zeiger
ntd	  LDY #$00
          LDA (inpsrcel),Y    ; hole nchstes Datenzeichen
	  BEQ ret11	      ; Endmarke, fertig (bei GET immer der Fall)
	  LDA #exig # 256
	  LDY #exig / 256
          JMP strout          ; sonst EXTRA IGNORED ausgeben

ret11	  RTS

exig	  BYT $3F,$45,$58,$54,$52,$41,$20,$49	  ; '?EXTRA I'
          BYT $47,$4E,$4F,$52,$45,$44,$0D,$00     ; 'GNORED '
reent	  BYT $3F,$52,$45,$45,$4E,$54,$45,$52	  ; '?REENTER'
          BYT $0D,$00

; NEXT - Function Handler
next	  BNE varnxt	      ; kein Trennzeichen, Variable angegeben
          LDY #$00
	  BEQ skpv	      ; berspringe Variablensuche
varnxt	  JSR ptrget	      ; suche Laufvariable
skpv	  STA forpntl	      ; Zeiger auf Variable merken
          STY forpnth
	  JSR gtforpnt	      ; suche FOR im Stack
	  BEQ gotfor	      ; gefunden ->
	  LDX #$00	      ; 'NEXT WITHOUT FOR' ausgeben
gerr	  BEQ jerror
gotfor	  TXS		      ; aktuelle Schleifenparameter oben auf Stack
          INX
          INX
          INX
          INX
	  TXA		      ; Zeiger auf STEP - Wert, LSB
          INX
          INX
          INX
          INX
          INX
          INX
	  STX ptrgul	      ; Zeiger auf TO - Wert, LSB
	  LDY #$01	      ; MSB fr beide Zeiger (Stack = Page1)
          JSR movfm           ; STEP - Wert nach FAC1 bertragen
          TSX
          LDA $0109,X         ; Vorzeichen des STEP - Wertes
	  STA FAC1sign	      ; ins Vorzeichenflag des FAC1
          LDA forpntl         ; Zeiger auf Laufvariable
          LDY forpnth
          JSR fadd            ; FAC := FAC + STEP - Wert
	  JSR setfor	      ; Ergebnis in die Laufvariable eintragen
	  LDY #$01	      ; Zeiger auf TO - Wert, MSB
	  JSR fcomp2	      ; FAC1 mit TO - Wert vergleichen
          TSX
          SEC
          SBC $0109,X         ; minus Vorzeichen STEP - Wert
	  BEQ endfor	      ; TO - Wert berschritten, Schleife fertig
          LDA $010F,X
          STA curlinl
          LDA $0110,X
          STA curlinh         ; 'curlin' auf Zeilennummer des FOR - Befehls
          LDA $0112,X
          STA txtptrl
          LDA $0111,X
          STA txtptrh         ; 'txtptr' hinter FOR - Befehl setzen
gonewst   JMP newstt	      ; zur Programmausfhrung

; Schleife abschlieen
endfor	  TXA		      ; Schleifendaten aus Stack entfernen
          ADC #$11
          TAX
          TXS
          JSR chargot
          CMP #$2C            ; folgt Komma?
	  BNE gonewst	      ; nein, NEXT - Befehl fertig
          JSR charget
	  JSR varnxt	      ; sonst weiter mit nchster NEXT - Variablen

; Interpretiere Real-Ausdruck
; I: 'txtptr' zeigt aud das erste Zeichen des Ausdrucks
; O: Ergebnis in FAC1
frmnum    JSR frmevl
; prfe ob Ausdruck numerisch
chknum    CLC                 ; Cy=0: numerisch
          BYT $24             ; 'BIT $38'
; prfe ob Stringausdruck
chkstr    SEC                 ; Cy=1: String
chkval	  BIT valtyp	      ; Variablentyp testen
	  BMI cv2	      ; String ->
	  BCS mismtch	      ; sollte aber... -> TYPE MISMATCH
ret12	  RTS
cv2	  BCS ret12	      ; ist String, soll auch... -> ok
mismtch   LDX #$A3	      ; 'TYPE MISMATCH'- Offset
jerror	  JMP error

; Interpretiere beliebigen Ausdruck eines Typs
;
; Zunchst holt GETVAL einen Operanden. Folgt auf diesen ein Trennzeichen, wird
; die Routine sofort abgeschlossen.
; Folgt ein Vergleichszeichen, so wird die Vergleichsoperation bestimmt und das
; Vergleichsflag entsprechend gesetzt. Je nach Prioritts-Flag werden Daten dieser
; Operation (Routinen-Adresse, Operand, Vergleichsflag, Priorittsflag) auf den
; Stack geschoben; oder aber, falls die offene Operation auf dem Stack Vorrang
; hatte, diese mit dem neuen Operanden vollzogen.
; I: 'txtptr' zeigt auf erstes Zeichen
; O: falls Ausdruck numerisch -> FAC1
;    sonst zeigt 'vpnt' auf den Stringdeskriptor
;    'txtptr' zeigt hinter den Ausdruck, 'valtyp' ist aktualisiert
frmevl    LDX txtptrl         ; 'txtptr' vor den Ausdruck setzen
          BNE frmevl1
          DEC txtptrh
frmevl1   DEC txtptrl
          LDX #$00            ; als Marke: keine offene Operation auf Stack
          BYT $24             ; 'BIT $48'
fevloop   PHA		      ; Vergleichsflag auf Stack
          TXA                 
          PHA                 ; Priorittsflag auf Stack
          LDA #$01
	  JSR chkmem	      ; genug Platz im Stack?
	  JSR getval	      ; Operand aus Programmtext holen
          LDA #$00
          STA cmpflag         ; Vergleichsflag lschen
frmevl2   JSR chargot	      ; neues Zeichen holen
cprop	  SEC
          SBC #$CF
	  BCC chktyp	      ; Token < $CF, keine Vergleichsoperation
          CMP #$03
	  BCS chktyp	      ; Token >= $D2, keine Vergleichsoperation
          CMP #$01            ; Cy = 0 falls  > - Vergleich
          ROL
          EOR #$01            ; damit ist > 1 / = 2 / < 4
          EOR cmpflag         ; >= 3 / <> 5 / <= 6 / ==, <<, >> 0
          CMP cmpflag         ; mit altem Flag vergleichen
	  BCC sntxerr	      ; zwei gleiche Relationen -> SYNTAX ERROR
          STA cmpflag         ; Flag merken
          JSR charget         ; neues Zeichen
	  JMP cprop	      ; damit weiter
chktyp	  LDX cmpflag
	  BNE compare	      ; Vergleichsoperation, Parameter bestimmen
	  BCS notmath	      ; Token fr SGN oder folgende
          ADC #$07
	  BCC notmath	      ; Token fr STEP oder Befehl davor
          ADC valtyp          ; Cy = 1, 'valtyp' = $FF bei String
	  BNE arith	      ; springen da nicht Token fr '+' oder kein String
	  JMP cat	      ; sonst Stringverknpfung durchfhren
arith	  ADC #$FF	      ; Code korrigieren, da Cy=1 addiert wurde
          STA indexl          ; Token minus $AA bei + - * / ^ AND OR
          ASL                 ; mal zwei
          ADC indexl          ; ergibt 3* (Token - $AA)
          TAY                 ; als Zeiger in Tabelle der arith. Operationen
preftest  PLA		      ; Prioritt auf Stack
	  CMP mathtbl,Y       ;  mit Prioritt der Operation vergleichen
	  BCS domth	      ; Vorrang fr Stackoperation, Op. durchfhren
          JSR chknum          ; Stringflag darf nicht gesetzt sein
nxop	  PHA		      ; Priorittsflag zurck auf Stack
savop	  JSR pshmad	      ; Op.-Routinenadr. und Op. auf Stack, weiter ausw

; Einsprung bei Rckkehr von Operations - Routine
          PLA                 ; Prioritt der nchsten Operation auf Stack
	  LDY txtptrsvl       ; Tabellenzeiger der soeben vollzogenen Operation
	  BPL prefnc	      ; war nicht die letzte Operation im Ausdruck
          TAX                 ; Z-Flag aktualisieren
	  BEQ goex	      ; keine offene Operation mehr, Auswertung fertig
	  BNE domath	      ; nchste offene Operation auf Stack durchfhren

; Vorbereitung fr Vergleichsoperationen
compare   LSR valtyp	      ; Stringflag lschen, Cy=1 falls es gesetzt war
          TXA                 ; Vergleichscode
          ROL                 ; verdoppeln; Cy --> bit0
          LDX txtptrl
	  BNE nd
          DEC txtptrh
nd	  DEC txtptrl	      ; 'txtptr' um eins verringern
          LDY #$1B            ; Tabellenzeiger fr Vergleichsoperation
          STA cmpflag         ; modifizierten Vergleichscode merken
	  BNE preftest	      ; unbedingter Sprung zum Priorittsvergleich

prefnc	  CMP mathtbl,Y       ; vergl. Stack-Prior. mit Prior. der letzten Op.
	  BCS domath	      ; Vorrang fr Stack - Operation, durchfhren
	  BCC nxop	      ; Zwischenerg. als Operand, offene Operation

; offene Operation auf Stack retten
pshmad	  LDA mathtbl+2,Y     ; Sprungadressen fr Op.-Routine aus Tabelle
          PHA                 ; auf Stack retten
	  LDA mathtbl+1,Y
          PHA
	  JSR pshf	      ; Operand (in FAC1) auf Stack retten
          LDA cmpflag         ; Vergleichsflag laden
	  JMP fevloop	      ; nchstes Element des Ausdrucks auswerten

sntxerr   JMP synerr

pshf	  LDA FAC1sign
	  LDX mathtbl,Y       ; Prioritt der Operation nach X retten
pshfacx   TAY		      ; Vorzeichen nach Y
          PLA
          STA indexl
          INC indexl
          PLA
          STA indexh          ; Rcksprungadresse nach 'index' retten
          TYA
	  PHA		      ; FAC1sign auf Stack
pushfac   JSR rndb	      ; FAC1 runden
	  LDA FAC1+4
          PHA
	  LDA FAC1+3
          PHA
	  LDA FAC1+2
          PHA
	  LDA FAC1+1
          PHA
	  LDA FAC1
          PHA                 ; FAC auf Stack legen
          JMP (indexl)        ; Funktion aufrufen

; Auswertung abschlieen
notmath   LDY #$FF	      ; Kennzeichen, da Ende des Ausdrucks erreicht
          PLA                 ; Prioritt vom Stack
goex	  BEQ exit	      ; keine offene Operation mehr, Auswertung beendet
domth	  CMP #$64	      ; offene Vergleichsoperation
	  BEQ dmth	      ; ja, Operand darf String sein
          JSR chknum          ; sonst mu er numerisch sein
dmth	  STY txtptrsvl       ; tabellenzeiger merken

; Operation auf Stack durchfhren
domath	  PLA		      ; modifiziertes Vergleichsflag
          LSR                 ; in Normalform bringen, Cy=1 falls Stringvergleich
          STA comprtyp        ; Vergleichsflag merken
          PLA                 ; Operand vom Stack nach FAC2 bertragen
          STA FAC2
          PLA
          STA FAC2+1
          PLA
          STA FAC2+2
          PLA
          STA FAC2+3
          PLA
          STA FAC2+4
          PLA
          STA FAC2+5          ; Vorzeichen von FAC2
eosign	  EOR FAC1sign	      ; mit Vorzeichen von FAC1 verknpfen
          STA xorfsgn         ; gibt Kombivorzeichen
exit	  LDA FAC1exp
          RTS                 ; Operation durchfhren, bzw. fertig, zurck

; Konstante oder Variable aus dem Programmtext holen
;
; - Numerische Konstanten sind Strings, werden umgewandelt und nach FAC1 kopiert.
; - Variablen werden gesucht und deren Wert nach FAC1 gebracht.
;   Bei Strings kommt der Zeiger auf den Deskriptor nach 'vpnt'.
; - Fr Stringkonstante wird ein Deskriptor auf dem Deskriptoren-Stack erzeugt,
;   'vpnt' zeigt darauf.
; - Funktionen und FN-Ausdrcke werden ausgewertet, das Ergebnis steht in FAC1.
; - Zur Auswertung von Klammerausdrcken wird FRMEVL rekursiv aufgerufen,
; - ansonsten wird SYNTAX ERROR ausgegeben.
getval	  LDA #$00
          STA valtyp          ; Stringflag lschen
skip	  JSR charget	      ; hole erstes Zeichen
	  BCS var_	      ; keine Ziffer
number	  JMP fin	      ; wandle String in Real, fertig
var_	  JSR isletc	      ; prfe ob Buchstabe, Cy=1 wenn ja
	  BCS varl	      ; ja, d.h Variablenwert nach FAC1
          CMP #$2E            ; '.'?
	  BEQ number	      ; ja, Zahlenwert nach FAC1
          CMP #$C9            ; '-' - Token
	  BEQ min	      ; ja, Vorzeichenwechsel als offene Op. auf Stack
          CMP #$C8            ; '+' - Token
	  BEQ skip	      ; ja, Pluszeichen ignorieren
          CMP #$22            ; '"'
	  BNE not_	      ; nein, kein String

; Separiere String vom Programmtext
strtxt    LDA txtptrl
          LDY txtptrh
          ADC #$00
	  BCC st1
          INY                 ; 'txtptr' zeigt jetzt auf erstes Stringzeichen
st1	  JSR strlit	      ; String auswerten
	  JMP point	      ; 'txtptr' (Stringende) holen, fertig
not_	  CMP #$C6	      ; Token fr NOT?
	  BNE fn_	      ; nein
          LDY #$18            ; Tabellenzeiger fr NOT
	  BNE equl	      ; NOT als offene Operation auf Stack

; FAC1 := NOT FAC1
equop	  LDA FAC1exp	      ; = 0 falls Bedingung nicht erfllt
	  BNE notz	      ; Bedingung erfllt, um zu negieren Y=0
          LDY #$01            ; Wahrheitswert war null, ergibt negiert Y=1
          BYT $2C             ; 'BIT $00A0'
notz	  LDY #$00
          JMP sgnflt          ; Integer in Y umwandeln in FP - Konstante

fn_	  CMP #$C2	      ; Token fr FN?
	  BNE sgn_	      ; nein
	  JMP funct	      ; sonst FN auswerten
sgn_	  CMP #$D2	      ; Token fr SGN?
	  BCC parchk	      ; keine Funktion, prfe ob Klammerausdruck
	  JMP unary	      ; zur Funktionsauswertung
parchk	  JSR chkopn	      ; prfe ob '(', sonst SYNTAX ERROR
          JSR frmevl          ; Term auswerten

; Check auf Zeichen ')'
chkcls    LDA #$29
          BYT $2C             ; 'BIT $28A9'
; Check auf Zeichen '('
chkopn    LDA #$28
          BYT $2C             ; 'BIT $2CA9'
; Check auf Zeichen ','
chkcom    LDA #$2C
; Syntax - Check
synchr    LDY #$00
          CMP (txtptrl),Y
	  BNE synerr
          JMP charget

synerr	  LDX #$10	      ; 'SYNTAX' - Offset
          JMP error

min	  LDY #$15	      ; Tabellenzeiger fr Vorzeichenwechsel
equl	  PLA		      ; entferne Rcksprungadresse
          PLA
	  JMP savop

; Variablenwert holen
; I: 'txtptr' zeigt auf Variablennamen
; O: Inhalt, falls numerisch, in FAC1
;    sonst zeigt 'vpnt' auf Stringdeskriptor
varl	  JSR ptrget	      ; Variable suchen, ggf. neu einrichten
	  STA vpntl	      ; Zeiger auf Variablen - Eintrag
	  STY vpnth
          LDX valtyp
	  BEQ vr1	      ; kein String
          LDX #$00
	  STX strng1h	      ; ?
          RTS
vr1	  LDX numtyp
	  BPL vr2	      ; FP - Variable, Wert nach FAC1

; float 2byte signed integer
floatvr   LDY #$00
	  LDA (vpntl),Y
          TAX
          INY
	  LDA (vpntl),Y
          TAY
          TXA                 ; Integer in A.Y
          JMP givayf          ; in FP umwandeln
vr2	  JMP movfm	      ; FP - Variable (A.Y als Zeiger) nach FAC1

; SCRN - Function Handler
screen	  JSR charget	      ; hole nchstes Zeichen
          JSR plotfns         ; hole Plot - Parameter fr LoRes - Graphik
          TXA                 ; 2. Parameter
          LDY first           ; 1. Parameter
          JSR scrn            ; Monitorroutine aufrufen
          TAY
          JSR sgnflt          ; Farbcode nach FAC1 bringen
          JMP chkcls          ; ')' mu folgen, sonst SYNTAX ERROR

; Auswertung von Funktionen
unary	  CMP #$D7	      ; Token fr SCRN(?
	  BEQ screen	      ; ja, zur Routine
          ASL                 ; Token mal 2 mod 256
          PHA                 ; retten
          TAX
          JSR charget         ; neues Zeichen
          CPX #$CF
	  BCC notinstr	      ; Token war < $E8, d.h nicht LEFT$/MID$/RIHT$
          JSR chkopn          ; sonst prfen ob '(' folgt
          JSR frmevl          ; 1. Ausdruck auswerten
          JSR chkcom          ; prfen ob Komma folgt
          JSR chkstr          ; prfen ob Stringausdruck
          PLA                 ; Token mal 2 mod 256
          TAX                 ; in X merken
	  LDA vpnth	      ; Stringdeskriptor
          PHA                 ; auf Stack retten
	  LDA vpntl
          PHA
          TXA                 ; 'Token' retten
          PHA
	  JSR getbyt	      ; 1. Parameter aus Programmtext -> X
          PLA                 ; 'Token'
          TAY                 ; als Tabellenzeiger nach Y
          TXA                 ; 1. Parameter
          PHA                 ; auf Stack retten
	  JMP gorout	      ; Routine anspringen

notinstr  JSR parchk	      ; Klammerausdruck auswerten
          PLA                 ; Token mal 2 mod 256
          TAY                 ; als Tabellenzeiger
gorout	  LDA unfnc-164,Y     ; Sprungadresse aus Tabelle
	  STA jmpadrs+1
	  LDA unfnc-163,Y
	  STA jmpadrs+2
	  JSR jmpadrs	      ; Routine aufrufen
	  JMP chknum	      ; Ergebnis muss numerisch sein, falls ok, fertig

; FAC1 := FAC1 OR FAC2
or	  LDA FAC2exp	      ; erster Wahrheitswert
	  ORA FAC1exp	      ; oder zweiter Wahrheitswert ungleich null?
	  BNE true1	      ; ja, OR - Bedingung erfllt

; FAC1 := FAC1 AND FAC2
and	  LDA FAC2exp	      ; 1, Wahrheitswert
	  BEQ false1	      ; Null, d.h. nicht erfllt
	  LDA FAC1exp	      ; 2. Wahrheitswert
	  BNE true1	      ; ungleich Null, damit AND - Bedingung erfllt
false1	  LDY #$00	      ; neuer Wahrheitswert Null
          BYT $2C             ; 'BIT $01A0'
true1	  LDY #$01	      ; neuer Wahrheitswert Eins
          JMP sgnflt          ; Wert in Y nach FAC1

; Routine fr Vergleichsoperationen
; I: C=1 falls erster Ausdruck String
posop	  JSR chkval	      ; prfe ob 2. Ausdruck vom gleichen Typ wie 1.
	  BCS strcmp	      ; Vergleiche zwei Strings

; Vergleiche FAC2 mit FAC1
agcmpfc   LDA FAC2sign        ; Vorzeichen FAC2
          ORA #$7F
          AND FAC2+1
          STA FAC2+1          ; in hchste Mantissenstelle eintragen
          LDA #$A5
          LDY #$00            ; Zeiger auf FAC2
          JSR fcomp           ; FAC1 mit FAC2 vergleichen
          TAX                 ; $01, $00, $FF bei 1.Zahl < = > 2. Zahl
	  JMP numcmp	      ; Wahrheitswert der Vergleichsop. feststellen

; Vergleich zweier Strings
; I: Zeiger auf die Stringdeskriptoren in 'vpnt' und FAC2+3.4
strcmp	  LDA #$00
          STA valtyp          ; Stringflag lschen
          DEC cmpflag
	  JSR frefac	      ; unntzen String entfernen
          STA dsctmp
          STX dsctmp+1
          STY dsctmp+2        ; Deskriptor fr den zweiten String
          LDA FAC2+3          ; Deskriptorzeiger fr den ersten String
          LDY FAC2+4
	  JSR fretmp	      ; unntzen String entfernen
          STX FAC2+3          ; Zeiger auf 1. String
          STY FAC2+4
          TAX                 ; Lnge des 1. Strings
          SEC
          SBC dsctmp          ; minus Lnge des zweiten Strings
	  BEQ sfs	      ; beide gleich lang
          LDA #$01
	  BCC sfs	      ; erster String krzer
          LDX dsctmp          ; X =  Lnge des krzeren Strings
          LDA #$FF
sfs	  STA FAC1sign
          LDY #$FF            ; als Index, ergibt Anfangswert 0
          INX
cmploop   INY		      ; Vergleichsschleife
          DEX
	  BNE docmp	      ; Lnge des krzeren String noch nicht erreicht
	  LDX FAC1sign	      ; Lngenvergleich
numcmp	  BMI cmpdone	      ; Lnge1 > Lnge2, C=1
          CLC
	  BCC cmpdone	      ; Lnge1 <= Lnge2, C=0
docmp	  LDA (FAC2+3),Y      ; Zeichen aus 1. String
          CMP (dsctmp+1),Y    ; mit Zeichen aus 2. String vergleichen
	  BEQ cmploop	      ; bereinstimmung, vergleiche nchstes Zeichen
          LDX #$FF
	  BCS cmpdone	      ; 1. Ausdruck > 2. Ausdruck
          LDX #$01
cmpdone   INX		      ; X= 0,1,2 bei 1. Ausdruck >,=,< 2. Ausdruck
          TXA
          ROL A               ; A= 1, 2, 4
          AND comprtyp        ; bit 0, 1, 2 bedeutet >, =, < im Vergleichsflag
	  BEQ jf	      ; keine bereinstimmung, Wahrheitswert = 0
          LDA #$01            ; Eins als Wahrheitswert
jf	  JMP float	      ; Wahrheitswert nach FAC1

; PDL( - Function Handler
pdl       JSR conint          ; Paddlenummer aus Programmtext holen
          JSR pread           ; Paddle abfragen ber Monitorroutine
          JMP sgnflt          ; Ergebnis nach FAC1

nxdim	  JSR chkcom	      ; prfe ob Komma folgt

; DIM - Function Handler
;
; Feldvariable besitzen folgende Struktur:
;  2 Bytes Name+Typ, Lnge LSB, MSB, Anzahl der Dimensionen,
;  Dimension des letzten Index LSB, MSB , ...,
;  Dimension des ersten Index LSB; MSB, Elemente (0,0,...,0), (1,0,...,0), ...
; d.h. der erste Index wchst am schnellsten, der letzte am langsamsten.
; FP/Integer/String-Elemente sind 5/2/3 Bytes lang.
dim       TAX                 ; 1.Namenbyte = Buchstabe, --> bit 6 = 1
	  JSR ptrget2	      ; Variable dimensionieren
          JSR chargot         ; hole neues Zeichen
	  BNE nxdim	      ; Kein Trennzeichen, weitere Variable dim.
          RTS

; Lokalisiere Variable des Typs Real, Int, Str
; I: 'txtptr' zeigt auf 1. Namensbyte
; O: A.Y = 'varpnt' zeigt auf Variablen - Eintragung,
;    'lowtr' zeigt auf Variablennamen
ptrget    LDX #$00            ; nicht von DIM gerufen
          JSR chargot         ; hole erstes Zeichen Varname
ptrget2   STX dimflag	      ; bit 6 = 1 falls DIM
ptrget3   STA lstvarnl
          JSR chargot
          JSR isletc          ; prfe ob Buchstabe
	  BCS namok	      ; ja,ok
badnam	  JMP synerr	      ; nein, SYNTAX ERROR
namok	  LDX #$00
          STX valtyp          ; kein String
          STX numtyp          ; kein Integer
	  JMP mornam	      ; Vektoren berspringen

basic	  JMP coldst	      ; Kaltstart
basic2	  JMP restart	      ; Warmstart
	  BYT $00

mornam	  JSR charget	      ; zweites Zeichen holen
	  BCC gtlt	      ; Ziffer -->
          JSR isletc
	  BCC strng_	      ; kein Buchstabe -->
gtlt	  TAX		      ; sonst merken
bypass	  JSR charget	      ; nchstes Zeichen holen
	  BCC bypass	      ; solange Zahlen kommen
          JSR isletc
	  BCS bypass	      ; oder Buchstaben
strng_	  CMP #$24
	  BNE intvar_	      ; kein String ('$')
          LDA #$FF
          STA valtyp          ; sonst String setzen
	  BNE nin	      ; und weiter
intvar_   CMP #$25
	  BNE scdch	      ; kein Integer ('%')
          LDA subflg          ; Integer erlaubt?
	  BMI badnam	      ; nein  --> Syntax Error
          LDA #$80
          STA numtyp          ; sonst Integer setzen
          ORA lstvarnl
          STA lstvarnl        ; bit7 vom 1. Namensbyte :=1
nin	  TXA
          ORA #$80            ; setze bit7 im 2. Namensbyte wenn kein Real
          TAX
          JSR charget         ; neues Zeichen holen
scdch	  STX lstvarnh	      ; 2. Namensbyte eintragen
          SEC
          ORA subflg          ; = #$40 falls Feldvariable ohne '(', vgl STORE
          SBC #$28            ; minus ASCII fr '(' ergibt 0, falls Feld
	  BNE bsb	      ; nicht 0, prfen ob von STORE aufgerufen
jary	  JMP array	      ; --> Feldvariable suchen
bsb	  BIT subflg	      ; Teste Variablen - Hilfsflag
	  BMI vsearch	      ; >= $80, sicher nicht von STORE
	  BVS jary	      ; bit 6 = 1, d.h von STORE gerufen -->Feld suchen
vsearch   LDA #$00
          STA subflg          ; Hilfsflag lschen

; einfache Variable suchen
          LDA vartabl         ; erste Variable
          LDX vartabh
          LDY #$00
nxvar	  STX lowtrh
nv1	  STA lowtrl
          CPX arytabh         ; schon bei den Arrays?
	  BNE nv2
          CMP arytabl
	  BEQ notfnd	      ; nicht vorhanden,anlegen!
nv2	  LDA lstvarnl
          CMP (lowtrl),Y      ; ersten Buchst. vergl.
	  BNE nxptr	      ; isnich ->
          LDA lstvarnh
          INY
          CMP (lowtrl),Y      ; zweiten Buchst. vergl.
	  BEQ setvpnt	      ; gefunden!
          DEY
nxptr	  CLC
          LDA lowtrl
          ADC #$07            ; nchste Variable
	  BCC nv1
          INX
	  BNE nxvar

; Test auf Buchstaben
; O: Cy=1 wenn Buchstabe
isletc    CMP #$41
	  BCC rtn1	      ; kleiner als 'A' -> Cy=0
          SBC #$5B
          SEC
          SBC #$A5            ; grer als 'Z' -> Cy=0
rtn1	  RTS

; einfache Variable erzeugen, mit Null besetzen
; falls nur der Wert erfragt wurde, wird keine Variable angelegt und
; Null zurckgeliefert
notfnd	  PLA		      ; LSB Rcksprungadresse
          PHA
	  CMP #$D7	      ; kam Aufruf von frmevl?
	  BNE newvar	      ; nein, dann von ptrget. Variable neu einrichten
          TSX
          LDA $0102,X         ; MSB Rcksprungadresse
	  CMP #$DE	      ; kam Aufruf von varl?
	  BNE newvar	      ; nein, also Variable neu einrichten
	  LDA #twobrk  #256   ; sonst nicht neu einrichten, da gesuchter Vaiable
	  LDY #twobrk  /256   ; nichts zugewiesen wird. Zeiger auf FP-Konst. 0
          RTS

twobrk	  BYT $00, $00	      ; FP-Konstante 0 (nur Exp, MSB)

; Platz fr einfache Variable schaffen
newvar	  LDA arytabl	      ; Anfang der Feldvariablen
          LDY arytabh
	  STA lowtrl	      ; als alter Blockanfang
          STY lowtrh
	  LDA strendl	      ; Ende der Feldvariablen +1
          LDY strendh
	  STA hightrl	      ; als altes Blockende +1
          STY hightrh
          CLC
	  ADC #$07	      ; plus 7
	  BCC nwv
          INY
nwv	  STA highdsl	      ; als neues Blockende +1
          STY highdsh
	  JSR bltu	      ; Feldvariablen um 7 Bytes verschieben
	  LDA highdsl	      ; neuer Blockanfang
          LDY highdsh
          INY
	  STA arytabl	      ; als neuen Anfang der Feldvariablen eintragen
          STY arytabh

; neue Variable initialisieren
          LDY #$00
	  LDA lstvarnl	      ; 1. Namensbyte eintragen
	  STA (lowtrl),Y
          INY
	  LDA lstvarnh	      ; 2. Namensbyte eintragen
          STA (lowtrl),Y
          LDA #$00            ; mit Null vorbesetzen
          INY
          STA (lowtrl),Y
          INY
          STA (lowtrl),Y
          INY
          STA (lowtrl),Y
          INY
          STA (lowtrl),Y
          INY
          STA (lowtrl),Y

; Zeiger auf neue Variable setzen
setvpnt   LDA lowtrl	      ; Zeiger auf Variablennamen
          CLC
	  ADC #$02	      ; um 2 erhhen
          LDY lowtrh
	  BCC svp
          INY
svp	  STA varpntl	      ; ergibt Zeiger auf Variablen-Eintragung
	  STY varpnth
          RTS

;Zeiger hinter Feldvariablen-Kopf setzen
getary	  LDA indflg	      ; Anzahl der Dimensionen
getary2   ASL		      ; verdoppeln
	  ADC #$05	      ; und 5 addieren ergibt Lnge des Variablenkopfes
	  ADC lowtrl	      ; Lnge zum Zeiger auf Variablennamen addieren
          LDY lowtrh
	  BCC gd
          INY
gd	  STA highdsl
	  STY highdsh	      ; ergibt Zeiger hinter den Variablenkopf, d.h.
	  RTS		      ; auf die erste Eintragung

negnum	  BYT $90,$80,$00,$00 ; ($20)  FP-Konstante -32768.0005
          
; Interpretiere positiven Integer-Ausdruck (0..32767)
makint	  JSR charget	      ; erstes Zeichen holen
	  JSR frmnum	      ; numerischen Ausdruck auswerten --> FAC1
mkint	  LDA FAC1sign
	  BMI mi1	      ; Index negativ -> ILLEGAL QUANTITY ERROR

; wandle FAC mit Quantity-check in 2byte signed Integer
ayint	  LDA FAC1exp
	  CMP #$90	      ; Hchstwert fr gltige Integer
	  BCC mi2	      ; Betrag von FAC1 kleiner 32768
	  LDA #negnum#256
	  LDY #negnum/256     ; Zeiger auf FP-Konstante -32768.0005
	  JSR fcomp	      ; und FAC mit Konstante vergleichen
mi1	  BNE iqerr	      ; kleiner als -32768.0005 -> ILLEGAL QUANTITY ERROR
mi2	  JMP qint	      ; FAC1 in Integerformat bringen

; Feldvariable suchen
array	  LDA subflg
	  BNE fndary	      ; =$40 (Aufruf von Store), keine Indizierung auswerten
	  LDA dimflag
	  ORA numtyp	      ; DIM-Flag mit Integer-Flag kombinieren
	  PHA		      ; und retten
	  LDA valtyp
	  PHA		      ; Stringflag retten
	  LDY #$00	      ; Dimensionszhler initialisieren
nxtdim	  TYA
	  PHA		      ; Anzahl der auf Stack geretteten Indizes
	  LDA lstvarnh
	  PHA
	  LDA lstvarnl	      ; Variablenname auf Stack retten
	  PHA
	  JSR makint	      ; Index aus dem Programmtext holen
	  PLA
	  STA lstvarnl	      ; Variablennamen vom Stack zurckholen
	  PLA
	  STA lstvarnh
	  PLA
	  TAY		      ; Dimensionszhler nach Y
	  TSX
	  LDA $0102,X	      ; DIM/Integer-Flag vom Stack kopieren
	  PHA
	  LDA $0101,X	      ; Stringflag kopieren
	  PHA
	  LDA vpntl	      ; Indexbytes ersetzen Flags iam alten Ort im Stack
	  STA $0102,X
	  LDA vpnth
	  STA $0101,X
	  INY		      ; Dimensionszhler erhhen
	  JSR chargot	      ; hole nchstes Zeichen
	  CMP #$2C	      ; Komma?
	  BEQ nxtdim	      ; ja, nchsten Index verarbeiten
	  STY indflg	      ; Anzahl der Dimensionen merken
	  JSR chkcls	      ; Prfe, ob '(' folgt, sonst SYNTAX ERROR
	  PLA
	  STA valtyp
	  PLA
	  STA numtyp	      ; Stringflag und Integerflag wiederherstellen
	  AND #$7F
	  STA dimflag	      ; DIM-Flag wiederherstellen
fndary	  LDX arytabl
	  LDA arytabh
aryloop   STX lowtrl
	  STA lowtrh	      ; Anfang der Feldvariablen in Suchzeiger eintragen
	  CMP strendh	      ; Feldvariablenende +1 erreicht?
	  BNE arynam_	      ; nein -->
	  CPX strendl	      ; LSB vergleichen
	  BEQ notfound	      ; ja, Feld neu anlegen
arynam_   LDY #$00
	  LDA (lowtrl),Y      ; sonst Variablennamen vergleichen
	  INY
	  CMP lstvarnl	      ; erstes Namensbyte
	  BNE nxary	      ; stimmt nicht berein -->
	  LDA lstvarnh	      ; zweites Namensbyte
	  CMP (lowtrl),Y
	  BEQ aryfound	      ; stimmt, Feldvariable gefunden
nxary	  INY
	  LDA (lowtrl),Y      ; sonst Lnge der Feldvariablen
	  CLC
	  ADC lowtrl	      ; zum Suchzeiger addieren
	  TAX
	  INY
	  LDA (lowtrl),Y
	  ADC lowtrh
	  BCC aryloop	      ; neue Feldvariable vergleichen

suberr	  LDX #$6B	      ; 'BAD SUBSCRIPT'-Offset
          BYT $2C             ; 'BIT $35A2'

iqerr	  LDX #$35	      ; 'ILLEGAL QTY'-  Offset
jer	  JMP error

aryfound  LDX #$78	      ; 'REDIM'D ARRAY'-Offset
	  LDA dimflag
	  BNE jer	      ; wenn DIM-Flag gesetzt, Fehlermeldung
	  LDA subflg	      ; =$40 falls von STORE aufgerufen
	  BEQ chkdim	      ; nicht von STORE, also Feldelement suchen
	  SEC
	  RTS		      ; sonst fertig
chkdim	  JSR getary	      ; Array-Header berspringen, Zeiger auf das erste Feldelement
	  LDA indflg	      ; Anzahl angegebener Dimensionen
	  LDY #$04
	  CMP (lowtrl),Y      ; mit Felddimension vergleichen
	  BNE suberr	      ; stimmt nicht --> BAD SUBSCRIPT ERROR
	  JMP fndelem	      ; alles ok, Feldelement suchen

; Feldvariable neu einrichten
notfound  LDA subflg
	  BEQ makary	      ; nicht von STORE, ok
outodp	  LDX #$2A	      ; 'OUT OF DATA' - Offset
          JMP error
makary	  JSR getary	      ; highds auf das erste Feldelement setzen
	  JSR reason	      ; genug Platz fr Variablenkopf?

; Lnge eines Feldelementes bestimmen
	  LDA #$00
	  TAY
	  STA strng2h	      ; Lnge, MSB
	  LDX #$05
	  LDA lstvarnl	      ; 1. Namensbyte (bit7 = 1 falls Integer)
	  STA (lowtrl),Y      ; in Variablenkopf eintragen
	  BPL nint	      ; keine Integervariable, da bit7 = 0
	  DEX
nint	  INY
	  LDA lstvarnh	      ; 2. Namensbyte (bit7 = 0 falls FP)
	  STA (lowtrl),Y
	  BPL rar	      ; FP-Variable, da bit7 = 0
	  DEX
	  DEX
rar	  STX strng2l	      ; Lnge also 2/3/5 Bytes bei Int/String/FP

; einzelne Dimensionierungen in Variablenkopf eintragen
	  LDA indflg	      ; Anzahl der Dimensionen
	  INY
	  INY
	  INY
	  STA (lowtrl),Y
savdim	  LDX #$0B
	  LDA #$00	      ; Defaultwert ist 11
	  BIT dimflag
	  BVC dfltdim	      ; kein Aufruf durch DIM
	  PLA
	  CLC		      ; sonst DIM-Wert vom Stack holen
	  ADC #$01	      ; um 1 erhhen wegen 0. Element
	  TAX
	  PLA
	  ADC #$00
dfltdim   INY
	  STA (lowtrl),Y      ; DIM-Wert in Variablenkopf eintragen
	  INY
	  TXA
	  STA (lowtrl),Y
	  JSR mult	      ; neue Lnge = alte Lnge x Dimensionierung
	  STX strng2l	      ; neue Lnge merken
	  STA strng2h
	  LDY indexl	      ; geretteten Y-Wert holen
	  DEC indflg	      ; nchste Dimension
	  BNE savdim

; prfen ob Platz reicht, Feld nullsetzen
	  ADC highdsh	      ; Feldlnge ohne Variablenkopf (X,A) zu Zeiger auf
	  BCS gme	      ; erstes Feldelement addieren, OUT OF MEMORY falls
	  STA highdsh	      ; Summe > 65535
	  TAY
	  TXA
	  ADC highdsl
	  BCC zary
	  INY		      ; Neues Feldvariablen-Ende +1 in A,Y
	  BEQ gme
zary	  JSR reason	      ; prfe ob gengend Platz fr neues Feld
	  STA strendl	      ; ok, neues Feldvariablen-Ende +1 eintragen
	  STY strendh
	  LDA #$00
	  INC strng2h
	  LDY strng2l	      ; als Index in Schleife
	  BEQ nxpg
zlup	  DEY		      ; Schleife fllt Feld mit Nullen
	  STA (highdsl),Y     ; Null eintragen
	  BNE zlup	      ; weiter solange Y nicht Null
nxpg	  DEC highdsh	      ; dann MSB dekrementieren
	  DEC strng2h
	  BNE zlup
	  INC highdsh	      ; Zeiger auf 1. Feldelement korrigieren
	  SEC
	  LDA strendl	      ; Feldende +1
	  SBC lowtrl	      ; minus Kopfanfang ergibt gesamte Lnge
	  LDY #$02
	  STA (lowtrl),Y      ; Feldlnge LSB eintragen
	  LDA strendh
	  INY
	  SBC lowtrh
	  STA (lowtrl),Y      ; Feldlnge MSB eintragen
	  LDA dimflag	      ; Aufruf durch DIM?
	  BNE rtn2	      ; ja, fertig
	  INY

; Feldelement suchen
fndelem   LDA (lowtrl),Y      ; Anzahl der Dimensionen merken
	  STA indflg
	  LDA #$00
	  STA strng2l	      ; Register fr laufende Nummer des Elementes lschen
dimlup	  STA strng2h
	  INY
	  PLA		      ; Index vom Stack nach 'vpnt'
	  TAX
	  STA vpntl
	  PLA
	  STA vpnth
	  CMP (lowtrl),Y      ; Index mit dem DIM-Wert vergleichen
	  BCC dimok	      ; MSB kleiner, ok
	  BNE gse	      ; Index zu gro -> BAD SUBSCRIPT ERROR
	  INY		      ; MSB war gleich, LSB vergleichen
	  TXA
	  CMP (lowtrl),Y
	  BCC dimok2	      ; kleiner, ok

gse	  JMP suberr	      ; sonst -> BAD SUBSCRIPT ERROR
gme	  JMP memerr	      ; -> OUT OF MEMORY ERROR

dimok	  INY
dimok2	  LDA strng2h
	  ORA strng2l
	  CLC
	  BEQ nxdm	      ; beide Registerbytes null, nicht multiplizieren
	  JSR mult	      ; X,A = strng2 x DIM-Wert
	  TXA
	  ADC vpntl	      ; plus Index
	  TAX		      ; ergibt aktuelle Element-Position
	  TYA
	  LDY indexl	      ; hole gerettetes Y
nxdm	  ADC vpnth
	  STX strng2l	      ; aktuelle Element-Position merken
	  DEC indflg	      ; Dimensionszhler dekrementieren
	  BNE dimlup	      ; weitere Dimensionen bercksichtigen
	  STA strng2h	      ; strng2 enthlt nun Element-Position im Feld
	  LDX #$05	      ; Elementlnge aus Variablenart bestimmen
	  LDA lstvarnl	      ; 1. Namensbyte (bit7 = 1 falls Integer)
	  BPL ninta	      ; nicht Integer
	  DEX
ninta	  LDA lstvarnh	      ; 2. Namensbyte (bit7 = 0 falls FP)
	  BPL rary	      ; FP-Variable
	  DEX
	  DEX
rary	  STX $64	      ; Lnge = 2/3/5 bei Integer/String/FP
	  LDA #$00	      ; Lnge, MSB
	  JSR mu1	      ; Abstand X,Y = Lnge x Position
	  TXA
	  ADC highdsl	      ; zum Zeiger aufs 1. Feldelement addieren
	  STA varpntl
	  TYA
	  ADC highdsh
	  STA varpnth	      ; varpnt zeigt nun auf das gesuchte Element
	  TAY
	  LDA varpntl	      ; A,Y ebenfalls
rtn2	  RTS

; Multiplikationsroutine
; Faktoren in strng2 und (lowtr),Y
mult	  STY indexl	      ; rette Y
	  LDA (lowtrl),Y
	  STA $64
	  DEY
	  LDA (lowtrl),Y
mu1	  STA $65
	  LDA #$10
	  STA FAC4+1	      ; Bitzhler fr 16bit-Multiplikation
	  LDX #$00	      ; Ergebnisregister lschen
	  LDY #$00
mu2	  TXA		      ; Ergebnisregister linksverschieben
	  ASL
	  TAX
	  TYA
	  ROL A
	  TAY
	  BCS gme	      ; berlauf -> OUT OF MEMORY
	  ASL strng2l
	  ROL strng2h	      ; Multiplikatorbit ins Carry
	  BCC mu3	      ; wenn 0 nicht addieren
	  CLC
	  TXA
	  ADC $64	      ; Multiplikand zu Ergebnisregister addieren
	  TAX
	  TYA
	  ADC $65
	  TAY
	  BCS gme	      ; berlauf -> OUT OF MEMORY
mu3	  DEC FAC4+1	      ; Bitzhler dekrementieren
	  BNE mu2	      ; weiter mit nchster Stelle
	  RTS

; FRE - Function Handler
fre	  LDA valtyp	      ; String-Flag gesetzt?
	  BEQ fre2	      ; nein
	  JSR frefac	      ; sonst unntzen String entfernen, falls erforderlich
fre2	  JSR garbag	      ; Garbage Collection durchfhren
          SEC
	  LDA fretopl	      ; Anfang des Stringbereiches
	  SBC strendl	      ; minus Variablen-Ende +1
	  TAY		      ; ergibt freien Speicherplatz
          LDA fretoph
          SBC strendh

; float 2byte signed integer
; Y,A nach FAC1
givayf    LDX #$00
	  STX valtyp	      ; String-Flag lschen
	  STA FAC1+1	      ; Integer in FAC1-Mantisse eintragen
	  STY FAC1+2
	  LDX #$90	      ; Exponentenwert fur FAC1
	  JMP flo1	      ; weiter bei SGN-Routine

; POS - Function Handler
pos	  LDY ch	      ; Cursor horizontal

; float 1byte unsigned integer
; Y nach FAC1
sgnflt	  LDA #$00	      ; MSB auf $00 setzen
	  SEC
	  BEQ givayf	      ; und wie 2byte behandeln

; Check direct mode
errdir	  LDX curlinh	      ; $FF im Direktmodus
	  INX
	  BNE rtn2	      ; ok, fertig
illdirp   LDX #$95            ; 'ILLEGAL DIRECT'-Offset
          BYT $2C
undfnc	  LDX #$E0	      ; 'UNDEF'D FN' - Offset
	  JMP Error

; DEF  - Function Handler
; z.B. DEF FN  F(X), wobei F=Name, X=Argument
def	  JSR fnc_	      ; Namen der Funktion bestimmen
	  JSR errdir	      ; prfe ob Direktmodus
	  JSR chkopn	      ; prfe ob '(' folgt
	  LDA #$80
	  STA subflg	      ; sperre Integer-Variablen als Argument
	  JSR ptrget	      ; suche Argument-Variable
	  JSR chknum	      ; muss numerisch sein
	  JSR chkcls	      ; prfe, ob ')' folgt
	  LDA #$D0	      ; Token '='
	  JSR synchr	      ; mu folgen, sonst SYNTAX ERROR
	  PHA		      ; erstes Zeichen der FN-Definition auf Stack
	  LDA varpnth
	  PHA
	  LDA varpntl
	  PHA
	  LDA txtptrh
	  PHA
	  LDA txtptrl
	  PHA
	  JSR data	      ; txtptr auf das nchste Trennzeichen setzen
	  JMP fncdata	      ; 5 Byte vom Stack in FN-Variable eintragen

; FN-Namen aus Programmtext holen
fnc_	  LDA #$C2	      ; Token fr FN
	  JSR synchr	      ; mu folgen, sonst SYNTAX ERROR
; lokalisiere Variable des Typs Function
seardvn   ORA #$80
	  STA subflg	      ; sperre Integervariablen
	  JSR ptrget3	      ; suche FN-Variable
	  STA fncnaml
	  STY fncnamh	      ; Zeiger auf Variable
	  JMP chknum	      ; prfe ob numerische Variable, fertig

; Funktion auswerten
funct	  JSR fnc_	      ; FN-Namen suchen
	  LDA fncnamh	      ; Zeiger darauf sichern
	  PHA
	  LDA fncnaml
	  PHA
	  JSR parchk	      ; Klammerausdruck mit Argument auswerten ->FAC1
	  JSR chknum	      ; prfe ob numerisch
	  PLA		      ; Zeiger auf Namen-Variable wiederholen
	  STA fncnaml
	  PLA
	  STA fncnamh
	  LDY #$02
	  LDA (fncnaml),Y
	  STA varpntl	      ; varpnt zeigt auf das Argument
	  TAX
	  INY
	  LDA (fncnaml),Y
	  BEQ undfnc	      ; kein FN-Parameter vorhanden, UNDEFN'D FUNCTION
	  STA varpnth	      ; sonst MSB eintragen
	  INY
savold	  LDA (varpntl),Y     ; momentanen Wert der Argument-Variablen
	  PHA		      ; auf Stack
	  DEY
	  BPL savold
	  LDY varpnth	      ; X,Y zeigt auf Argument-Variable
	  JSR movmf	      ; FN-Argument in Argumentvariable eintragen
	  LDA txtptrh
	  PHA
	  LDA txtptrl
	  PHA
	  LDA (fncnaml),Y
	  STA txtptrl
	  INY
	  LDA (fncnaml),Y
	  STA txtptrh	      ; txtptr auf FN-Ausdruck setzen
	  LDA varpnth
	  PHA
	  LDA varpntl
	  PHA
	  JSR frmnum	      ; FN-Ausdruck auswerten, Ergebnis nach FAC1
	  PLA
	  STA fncnaml
	  PLA
	  STA fncnamh	      ; Zeiger auf Argumentvariable in 'fncnam' zwischenlagern
	  JSR chargot	      ; hole Zeichen hinter FN-Definition
	  BEQ getold	      ; wenn Trennzeichen, dann ok
	  JMP synerr	      ; sonst SYNTAX ERROR
getold	  PLA
	  STA txtptrl
	  PLA
	  STA txtptrh	      ; txtptr wieder auf Programmzeile richten

; 5 Byte vom Stack ab Zeiger FAC5 eintragen
fncdata   LDY #$00
	  PLA
	  STA (FAC5),Y
	  PLA
	  INY
	  STA (FAC5),Y
	  PLA
	  INY
	  STA (FAC5),Y
	  PLA
	  INY
	  STA (FAC5),Y
	  PLA
	  INY
	  STA (FAC5),Y
	  RTS

; STR$ - Function Handler
str	  JSR chknum	      ; prfe ob Argument numerisch
	  LDY #$00	      ; als Zeiger, String wird ab $00FF,Y zwischengelagert
	  JSR facstrng	       ; Argument in FAC1 als String ab $00FF
	  PLA		      ; Rcksprungadresse entfernen
	  PLA
	  LDA #$FF	      ; Zeiger auf Stringanfang
	  LDY #$00
	  BEQ strlit	      ; String auswerten

; Initialisiere Stringspeicherraum
; I: Akku enthlt Stringlnge
strini	  LDX vpntl	      ; Zeiger auf neuesten String im Deskriptoren-Stack
	  LDY vpnth
	  STX dscptrl	      ; als Zeiger auf aktuellen Deskriptor
	  STY dscptrh
strspa	  JSR getspa	      ; unteres Stringende herabsetzen
	  STX FAC1+1	      ; Adresse des Stringanfangs
	  STY FAC1+2
	  STA FAC1	      ; Stringlnge
	  RTS

; Stringdeskriptor bestimmen und auf Deskriptoren-Stack
; String -> Stringbereich, falls aus Page 0 oder 2
; I: A,Y zeigt auf Stringanfang
; O: FAC1 = Deskriptor, FAC1+3 zeigt auf Deskriptorenstack
; strng2 zeigt hinter String
strlit	  LDX #$22	      ; ASCII fr '"'
	  STX charac	      ; als Endmarke eintragen
	  STX endchr
; generiere String-Deskriptor
strlt2	  STA strng1l	      ; Zeiger auf Stringanfang als Arbeitszeiger
	  STY strng1h
	  STA FAC1+1	      ; und fr Deskriptor merken
	  STY FAC1+2
	  LDY #$FF	      ; Index fr Schleife
fend	  INY
	  LDA (strng1l),Y     ; hole Zeichen
	  BEQ zend	      ; Endmarke, Ende gefunden
	  CMP charac
	  BEQ quo_	      ; Endmarke1, Ende gefunden
	  CMP endchr	      ; Endmarke2 ?
	  BNE fend	      ; nein, suche weiter nach Stringende
quo_	  CMP #$22	      ; Endmarke1 / 2 war '"'?
	  BEQ nz	      ; ja, dann C=1
zend	  CLC
nz	  STY FAC1	      ; Stringlnge im Deskriptor eintragen
	  TYA
	  ADC strng1l	      ; Lnge zu Stringanfang addieren
	  STA strng2l	      ; ergibt Zeiger hinter String
	  LDX strng1h
	  BCC fe1
	  INX		      ; falls ntig MSB korrigieren
fe1	  STX strng2h
	  LDA strng1h	      ; Stringanfang MSB
	  BEQ fe2	      ; String beginnt in Zeropage (STR$), umkopieren
	  CMP #$02	      ; liegt String in Page 2 (INPUT, GET)?
	  BNE putnew	      ; nein, nicht kopieren
fe2	  TYA		      ; Stringlnge
	  JSR strini	      ; Platz im Stringbereich scaffen
	  LDX strng1l	      ; Zeiger auf Anfang des Originalstrings
	  LDY strng1h
	  JSR movstr	      ; und kopieren

; Deskriptor auf Deskriptorenstack setzen
putnew	  LDX temppt	      ; Zeiger auf neue Eintragung
	  CPX #tempst+9       ; Deskriptorenstack voll?
	  BNE putemp	      ; nein, neuen Deskriptor eintragen
frmcplp   LDX #$BF            ; 'FORMULA TOO...'-Offset
jerr	  JMP Error
putemp	  LDA FAC1	      ; Deskriptor in Stack eintragen
	  STA $00,X
	  LDA FAC1+1
	  STA $01,X
	  LDA FAC1+2
	  STA $02,X
	  LDY #$00
	  STX FAC1+3	      ; Zeiger auf neuesten Deskriptor im Stack
	  STY FAC1+4
	  DEY		      ; Y=$FF
	  STY valtyp	      ; Stringflag setzen
	  STX lastpt	      ; Adresse des obersten Deskriptors im Stack
	  INX
	  INX
	  INX
	  STX temppt	      ; Zeiger um 3 erhhen
	  RTS

; Platz fr neuen String im Stringbereich schaffen
; I: Akku = Stringlnge
; O: A,X,Y = neuer Deskriptor, frespc = neue Anfangsadresse
getspa	  LSR dataflg	      ; lsche Garbage Collection - Flag
getspc	  PHA		      ; Lnge merken
	  EOR #$FF
	  SEC
	  ADC fretopl	      ; d.h. Lnge wird subtrahiert von Stringereich-Anfang
	  LDY fretoph
	  BCS cy
	  DEY		      ; ggf. MSB korrigieren
cy	  CPY strendh	      ; mit Feldvariablen-Ende +1 vergleichen
	  BCC full	      ; zu wenig Platz -> Garbage Collection
	  BNE gotspa	      ; Platz reicht, weiter
	  CMP strendl	      ; MSB gleich, prfe LSB
	  BCC full
gotspa	  STA fretopl	      ; neuer Stringbereich-Anfang
	  STY fretoph
	  STA frespcl	      ; Hilfsazeiger fr String-Kopierroutine
	  STY frespch
	  TAX
	  PLA		      ; damit Deskriptor in A,X,Y
	  RTS
full	  LDX #$4D	      ; Offset fr OUT OF MEMORY ERROR
	  LDA dataflg	      ; =$80 falls Garbage Collection schon erledigt
	  BMI jerr	      ; Dann Fehlermeldung ausgeben
	  JSR garbag	      ; sonst Garbage Collection
	  LDA #$80	      ; und danach das Flag setzen
	  STA dataflg
	  PLA		      ; Stringlnge holen
	  BNE getspc	      ; und nochmal versuchen

; Garbage Collector
;
; Zunchst wird der Stringbereichs-Anfang auf HIMEM: gesetzt, d.h. es gibt
; keine gltigen Strings im Stringbereich.
; Jetzt werden smtliche Stringvariablen sowie der Deskriptoren-Stack durchsucht,
; um den string mit der hchsten Adresse zu finden, der noch nicht im String-
; bereich steht. Dieser wird jetzt in den Stringbereich kopiert und der
; zugehrige Deskriptor aktualisiert. Dieser Vorgang wird so lange wiederholt,
; bis endlich alle aktuellen Strings erfasst worden sind.
garbag    LDX memsizel
	  LDA memsizeh	      ; HIMEM, d.h. Stringbereich-Ende +1
fndvar	  STX fretopl
	  STA fretoph	      ; als Stringbereich-Anfang setzen
	  LDY #$00
	  STY fncnamh	      ; als Abbruch-Flag
	  LDA strendl
	  LDX strendh
	  STA lowtrl	      ; Feldvariablen-Ende als Zeiger auf den hchsten
	  STX lowtrh	      ;   zu bercksichtigenden String
	  LDA #tempst # 256
	  LDX #tempst / 256
	  STA indexl	      ; Suchzeiger auf Beginn des Deskriptoren-Stacks
	  STX indexh
; Strings aus Deskriptoren-Stack bercksichtigen
tvar	  CMP temppt	      ; Suchzeiger hinter letzter Eintragung im Deskr.-Stack?
	  BEQ svars	      ; ja, damit Deskr.-Stack ganz bercksichtigt
	  JSR dvar	      ; falls oberster String, in 'lowtr' und 'fncnam' merken
	  BEQ tvar	      ; weiter im Deskriptoren-Stack
; Strings aus einfachen Variablen bercksichtigen
svars	  LDA #$07	      ; Lnge einfacher Variablen = 7 Bytes
	  STA dsclen
	  LDA vartabl
	  LDX vartabh
	  STA indexl	      ; Anfang der einfachen Variablen als Suchzeiger
	  STX indexh
svar	  CPX arytabh	      ; Anfang der Feldvariablen erreicht?
	  BNE svargo	      ; nein ->
	  CMP arytabl
	  BEQ aryvar	      ; einfache Variablen fertig, weiter mit Arrays
svargo	  JSR dvars	      ; String-Parameter merken falls neuer oberster String
	  BEQ svar	      ; weiter mit nchster Variablen
; Strings aus Feldvariablen bercksichtigen
aryvar	  STA highdsl	      ; Zeiger auf Array-Kopf setzen
	  STX highdsh
	  LDA #$03	      ; Lnge einzelner Elemente im Stringfeld = 3 Bytes
	  STA dsclen
aryva2	  LDA highdsl	      ; Zeiger auf Kopf des aktuellen Arrays
	  LDX highdsh
aryva3	  CPX strendh	      ; schon Feldvariablen-Ende +1 erreicht?
	  BNE aryvgo	      ; nein, aktuelles Array bearbeiten
	  CMP strendl
	  BNE aryvgo
	  JMP grbpas	      ; Ende erreicht, obersten String bernehmen
; Einzelne Feldvariablen bearbeiten
aryvgo	  STA indexl
	  STX indexh	      ; als Suchzeiger auf einzelne Feldelemente
	  LDY #$00
	  LDA (indexl),Y      ; 1. Namensbyte retten
	  TAX
	  INY
	  LDA (indexl),Y      ; 2. Namensbyte bit7 retten
	  PHP
	  INY
	  LDA (indexl),Y      ; Lnge der Feldvariablen
	  ADC highdsl	      ; zu Zeiger auf Variablen-Kopf addieren
	  STA highdsl
	  INY
	  LDA (indexl),Y
	  ADC highdsh
	  STA highdsh	      ; ergibt Zeiger auf nchstes Array
	  PLP		      ; hole bit7 vom 2. Namensbyte zurck
	  BPL aryva2	      ; =0, also kein String
	  TXA		      ; 1. Namensbyte
	  BMI aryva2	      ; bit7 = 1, also kein String
	  INY
	  LDA (indexl),Y      ; Anzahl der Dimensionen
	  LDY #$00
	  ASL		      ; x2
	  ADC #$05	      ; plus 5 ergibt Kopflnge
	  ADC indexl	      ; zum Zeiger auf Kopfanfang addieren
	  STA indexl	      ; ergibt Zeiger auf erstes Element
	  BCC aryvgo1
	  INC indexh
aryvgo1   LDX indexh
arystr	  CPX highdsh	      ; nchstes Array erreicht, also hier fertig?
	  BNE gogo	      ; nein
	  CMP highdsl
	  BEQ aryva3	      ; weiter mit nchstem Array
gogo	  JSR dvar	      ; Stringparameter merken, falls neuer oberster String
	  BEQ arystr	      ; weiter mit dem nchsten Element
; prfe, ob neuen obersten String gefunden
dvars	  LDA (indexl),Y      ; 1. Namensbyte
	  BMI dvarts	      ; bit7=1, kein String
	  INY
	  LDA (indexl),Y      ; 2. Namensbyte
	  BPL dvarts	      ; bit7=0, kein String
	  INY
dvar	  LDA (indexl),Y      ; Lnge des Strings
	  BEQ dvarts	      ; = null, nicht oberster String
	  INY
	  LDA (indexl),Y      ; Anfangsadresse des Strings
	  TAX
	  INY
	  LDA (indexl),Y      ; nach X,A
	  CMP fretoph	      ; Adresse im Stringbereich?
	  BCC dv1	      ; nein, String also noch nicht bercksichtigt
	  BNE dvarts	      ; sonst String bereits als aktuell erkannt
	  CPX fretopl
	  BCS dvarts
dv1	  CMP lowtrh	      ; liegt String ber bisherigem obersten String?
	  BCC dvarts	      ; nein, weiter
	  BNE dv2	      ; sonst neuer oberster String gefunden
	  CPX lowtrl
	  BCC dvarts
dv2	  STX lowtrl	      ; Zeiger auf neuen obersten String setzen
	  STA lowtrh
	  LDA indexl	      ; Zeiger auf zugehrigen Deskriptor
	  LDX indexh
	  STA fncnaml	      ; merken
	  STX fncnamh
	  LDA dsclen	      ; Abstand zu nchstem Deskriptor
	  STA length	      ; merken
dvarts	  LDA dsclen
	  CLC
	  ADC indexl
	  STA indexl	      ; und zu Suchzeiger addieren
	  BCC vdone
	  INC indexh
vdone	  LDX indexh
	  LDY #$00
	  RTS		      ; weiter mit nchstem Deskriptor
; obersten String in Stringbereich bernehmen
grbpas	  LDX fncnamh	      ; =0 falls kein oberster String gefunden
	  BEQ vdone	      ; Garbage Collection beendet
	  LDA length	      ; bei einfacher Variable 7, sonst 3
	  AND #$04
	  LSR A 	      ; ergibt 2 oder 0
	  TAY		      ; als Index (bei einfacher Variablen Namen berspringen)
	  STA length
	  LDA (fncnaml),Y     ; Stringlnge aus Deskriptor
	  ADC lowtrl	      ; plus Zeiger auf String
	  STA hightrl	      ; ergibt Endadresse +1 fr Verschieberoutine
	  LDA lowtrh
	  ADC #$00
	  STA hightrh
	  LDA fretopl	      ; bisheriger Anfang der Strings
	  LDX fretoph
	  STA highdsl	      ; als neues Blockende +1
	  STX highdsh
	  JSR bltu2	      ; String in Stringbereich kopieren
	  LDY length
	  INY		      ; gemerkten Index erhhen
	  LDA highdsl
	  STA (fncnaml),Y     ; neue Stringadresse in Deskriptor eintragen
	  TAX
	  INC highdsh
	  LDA highdsh
	  INY
	  STA (fncnaml),Y
	  JMP fndvar	      ; weiter mit Suche nach neuem obersten String

; Strings verketten
cat	  LDA vpnth	      ; Zeiger auf Deskriptor des 1. Strings
	  PHA
	  LDA vpntl
	  PHA
	  JSR getval	      ; 2. String aus Programmtext holen
	  JSR chkstr	      ; prfe, ob String
	  PLA
	  STA strng1l
	  PLA
	  STA strng1h	      ; Deskriptorzeiger fr 1. String
	  LDY #$00
	  LDA (strng1l),Y     ; Lnge des 1. Strings
	  CLC
	  ADC (vpntl),Y       ; plus Lnge des zweiten Strings
	  BCC ntl	      ; ok, nicht zu lang
strtlgp   LDX #$B0            ; 'STRING TOO ...'-Offset
          JMP Error
ntl	  JSR strini	      ; Platz fr verketteten String schaffen
	  JSR movins	      ; 1. Teilstring an neuen Platz kopieren
	  LDA dscptrl	      ; Zeiger auf Deskriptor vom 2. String im Deskr.-Stack
	  LDY dscptrh
	  JSR fretmp	      ; Deskriptor vom Stack entfernen
	  JSR movestr	      ; 2. Teilstring hinter 1. kopieren
	  LDA strng1l
	  LDY strng1h
	  JSR fretmp	      ; Deskriptor fr 1. String vom Stack entfernen
	  JSR putnew	      ; Deskriptor fr verketteten String auf Stack
	  JMP frmevl2	      ; und zurck zur Routine frmevl

; String kopieren
; I: strng1 Zeiger auf Deskriptor, frespc Zieladresse
; O: frespc zeigt hinter neuen String
movins    LDY #$00
	  LDA (strng1l),Y     ; Stringlnge retten
	  PHA
	  INY
	  LDA (strng1l),Y     ; Zieldaresse
	  TAX		      ; nach X,Y bringen
	  INY
	  LDA (strng1l),Y
	  TAY
	  PLA		      ; Lnge holen
movstr	  STX indexl	      ; Adresse auf Zeiger bertragen
	  STY indexh
movestr   TAY		      ; Y als Schleifenzhler
	  BEQ mvs3	      ; Stringlnge  Null
	  PHA		      ; sonst Lnge sichern
mvs2	  DEY
	  LDA (indexl),Y      ; Zeichen fr Zeichen kopieren
	  STA (frespcl),Y
	  TYA
	  BNE mvs2
	  PLA		      ; Lnge zurckholen
mvs3	  CLC
	  ADC frespcl	      ; und zur Anfangsadresse addieren
	  STA frespcl	      ; gibt Zeiger hinter neuen String
	  BCC mvs4
	  INC frespch
mvs4	  RTS

; unntze Strings entfernen
; O: Deskriptor in A, index bzw in A,X,Y
frestr	  JSR chkstr	      ; prfe, ob letzter Ausdruck ein String war
frefac	  LDA vpntl	      ; Zeiger auf Deskriptor im Deskriptoren-Stack
	  LDY vpnth
fretmp	  STA indexl	      ; auf Hilfszeiger bertragen
	  STY indexh
	  JSR fretms	      ; Deskriptor vom Stack entfernen, falls obenauf
	  PHP
	  LDY #$00
	  LDA (indexl),Y      ; Deskriptor nach A,X,Y
	  PHA
	  INY
	  LDA (indexl),Y
	  TAX
	  INY
	  LDA (indexl),Y
	  TAY
	  PLA		      ; Stringlnge
	  PLP		      ; Z-Flag gesetzt falls Deskriptor entfernt wurde
	  BNE nb
	  CPY fretoph	      ; Stringadresse = Anfang des Stringbereiches?
	  BNE nb
	  CPX fretopl
	  BNE nb	      ; nein, nicht der unterste String, nicht lschen
	  PHA		      ; sonst Lnge retten
	  CLC
	  ADC fretopl	      ; Anfang des Stringbereiches um Stringlnge erhhen
	  STA fretopl
	  BCC nb1
	  INC fretoph
nb1	  PLA
nb	  STX indexl
	  STY indexh
	  RTS

; Deskriptor vom Deskriptorenstack entfernen, falls obenauf
; I: A,Y zeigt auf Stringdeskriptor
; O: Z-Flag =1, falls Deskriptor entfernt wurde
fretms	  CPY auxl	      ; Adresse des obersten Deskriptors auf Stack, MSB
	  BNE rtn3	      ; stimmt nicht berein, fertig
	  CMP lastpt	      ; LSB prfen
	  BNE rtn3
	  STA temppt	      ; sonst Zeiger fr nchste Eintragung setzen
	  SBC #$03
	  STA lastpt	      ; minus 3 ergibt Zeiger auf neuen obersten Deskriptor
	  LDY #$00	      ; Z-Flag setzen
rtn3	  RTS

; CHR$ - Function Handler
chrstr	  JSR conint	      ; ASCII-Code in FAC1 als Integer nach X
	  TXA
	  PHA
	  LDA #$01	      ; Stringlnge 1
	  JSR strspa	      ; Platz schaffen, Deskriptor in FAC1
	  PLA
	  LDY #$00
	  STA (FAC1+1),Y      ; ASCII-Code eintragen
	  PLA
	  PLA		      ; Rcksprungadresse entfernen
	  JMP putnew	      ; Deskriptor auf Deskriptoren-Stack

; LEFT$ - Function Handler
leftstr   JSR instrng	      ; Deskriptorzeiger nach 'dscptr', Parameter nach A,X
	  CMP (dscptrl),Y     ; Parameter mit Stringlnge vergleichen
	  TYA		      ; Akku lschen
; Einsprung von RIGHT$
ins1	  BCC ins2	      ; Anfang des Teilstrings < Stringlnge, ok
	  LDA (dscptrl),Y     ; sonst Stringlnge = Lnge des Teilstrings
	  TAX
	  TYA
ins2	  PHA		      ; Position des Teilstrings im Originalstring auf Stack
ins3	  TXA		      ; Lnge des Teilstrings
; Einsprung von MID$
ins4	  PHA		      ; Lnge des Teilstrings auf Stack
	  JSR strspa	      ; Platz fr neuen String im Stringbereich schaffen
	  LDA dscptrl	      ; Zeiger auf Stringdeskriptor
	  LDY dscptrh
	  JSR fretmp	      ; Originalstring mglichst entfernen
	  PLA		      ; Lnge des Teilstrings
	  TAY		      
	  PLA		      ; Position des Teilstrings im Original (0 bei LEFT$)
	  CLC
	  ADC indexl	      ; Adresse des Originalstrings plus Position
	  STA indexl	      ; ergibt Adresse des Teilstrings
	  BCC bpd
	  INC indexh
bpd	  TYA		      ; gemerkte Lnge des Teilstrings
	  JSR movestr	      ; Teilstring in Stringbereich bertragen
	  JMP putnew	      ; Deskriptor auf Deskriptoren-Stack

; RIGHT$ - Function Handler
rightstr  JSR instrng	      ; Deskriptorzeiger nach 'dscptr', Parameter nach A,X
	  CLC
	  SBC (dscptrl),Y     ; Parameter minus (Stringlnge +1)
	  EOR #$FF	      ; negieren ergibt Lnge des Teilstrings
	  JMP ins1	      ; weiter in der LEFT$-Routine

; MID$ - Function Handler
midstr	  LDA #$FF	      ; Default-Wert fr Lnge des Teilstrings
	  STA vpnth
	  JSR chargot	      ; hole letztes Zeichen
	  CMP #$29	      ; ASCII fr ')'?
	  BEQ ins5	      ; ja, kein Lngen-Parameter angegeben
	  JSR chkcom	      ; sonst mu Komma folgen
	  JSR getbyt	      ; Lngen-Parameter aus Programmtext holen
ins5	  JSR instrng	      ; Deskriptorzeiger nach 'dscptr', Parameter nach A,X
	  DEX		      ; Position des Teilstrings
	  TXA
	  PHA		      ; retten
	  CLC
	  LDX #$00
	  SBC (dscptrl),Y     ; minus (Originalstring-Lnge +1)
	  BCS ins3	      ; Pos. auerhalb Originalstring -> X=0
	  EOR #$FF	      ; ergibt maximaleLnge des Teilstrings
	  CMP vpnth	      ; dies mit Lngen-Parameter vergleichen
	  BCC ins4	      ; zu gro, weiter mit maximaler Lnge
	  LDA vpnth	      ; sonst Lngenparameter holen
	  BCS ins4	      ; und weiter bei LEFT$-Routine

; LEFT$/RIGHT$/MID$ - Parameter vom Stack holen
instrng   JSR chkcls	      ; prfe, ob ')' folgt
	  PLA		      ; Rcksprungadresse nach Y,length retten
	  TAY
	  PLA
	  STA length
	  PLA		      ; Rcksprungadresse nach $DF4C entfernen
	  PLA
	  PLA		      ; Positionsparameter vom Stack nach X
	  TAX
	  PLA		      ; Zeiger auf Stringdeskriptor
	  STA dscptrl
	  PLA
	  STA dscptrh
	  LDA length	      ; Rcksprungadresse wieder auf Stack
	  PHA
	  TYA
	  PHA
	  LDY #$00
	  TXA		      ; Positions-Parameter
	  BEQ goiq	      ; =0 -> ILLEGAL QUANTITY ERROR
	  RTS

; LEN - Function Handler
len	  JSR getstr	      ; Deskriptor vom Deskriptoren-Stack entfernen
	  JMP sgnflt	      ; Integer in Y nach FAC1 bringen

; Hilfsroutine fr LEN, ASC, VAL
getstr	  JSR frestr	      ; unntzen Deskriptor vom Deskr.-Stack entfernen
	  LDX #$00
	  STX valtyp	      ; String-Flag lschen
	  TAY		      ; Stringlnge nach Y
	  RTS

; ASC - Function Handler
asc	  JSR getstr	      ; Deskr. vom Stack entfernen, Lnge -> A
	  BEQ goiq	      ; Lnge =0, ILLEGAL QUANTITY ERROR
	  LDY #$00	      
	  LDA (indexl),Y      ; hole erste Stringzeichen
	  TAY
	  JMP sgnflt	      ; Integer in Y nach FAC1

goiq	  JMP iqerr	      ; ILLEGAL QUANTITY ERROR ausgeben

; 1byte-Integer aus Programmtext holen
; I: txtptr zeigt auf numerischen Ausdruck
; O: Integer in X bzw. 'vpnt'
gtbytc	  JSR charget	      ; neues Zeichen holen
getbyt	  JSR frmnum	      ; numerischen Ausdruck auswerten (nach FAC1)
conint	  JSR mkint	      ; FAC1 in Integer umwandeln
	  LDX vpntl
	  BNE goiq	      ; MSB >0 -> Integer >255 -> Fehler
	  LDX vpnth	      ; LSB nach X
	  JMP chargot	      ; kehre zurck mit neuem Zeichen im Akku

; VAL - Function Handler
val	  JSR getstr	      ; Deskriptor vom Stack entfernen
	  BNE vl2	      ; Stringlnge nicht Null
	  JMP zerofac	      ; sonst FAC1 nullsetzen und fertig
vl2	  LDX txtptrl
	  LDY txtptrh
	  STX strng2l
	  STY strng2h
	  LDX indexl
	  STX txtptrl	      ; Stringadresse nach txtptr bertragen
	  CLC
	  ADC indexl	      ; Stringlnge plus Stringadresse
	  STA ptrgul	      ; ergibt Zeiger hinter String
	  LDX indexh
	  STX txtptrh
	  BCC vl3
	  INX
vl3	  STX ptrguh
	  LDY #$00
	  LDA (ptrgul),Y      ; erstes Zeichen hinter String
	  PHA		      ; auf Stack retten
	  LDA #$00
	  STA (ptrgul),Y      ; durch Null ersetzen (als Endmarke)
	  JSR chargot	      ; hole erstes Stringzeichen
	  JSR fin	      ; String in FP-Konstante (in FAC1) umwandeln
	  PLA
	  LDY #$00
	  STA (ptrgul),Y      ; Zeichen hinter String wiederherstellen
point	  LDX strng2l
	  LDY strng2h
	  STX txtptrl
	  STY txtptrh
	  RTS

; Interpretiere 2byte,1byte - Ausdruck aus dem Programmtext
; O: Integers in 'linnum' und 'vpnt' bzw. X
gtnum	  JSR frmnum	      ; numerischen Ausdruck auswerten
	  JSR getadr	      ; FAC1 nach Integer in linnum
combyte   JSR chkcom	      ; prfe, ob Komma folgt
	  JMP getbyt	      ; und das letzte Byte holen

; Wandle FAC mit Quantitycheck in 2byte signed Integer
getadr	  LDA FAC1exp
	  CMP #$91	      ; Exponent zu gro?
	  BCS goiq
	  JSR qint	      ; FAC1 in Integerformat bringen
	  LDA vpntl
	  LDY vpnth
	  STY linnuml
	  STA linnumh
	  RTS

; PEEK - Function Handler
peek	  LDA linnuml
	  PHA
	  LDA linnumh
	  PHA
	  JSR getadr	      ; Adresse in Integer umwandeln
	  LDY #$00
	  LDA (linnuml),Y     ; Inhalt der Speicherzelle holen
	  TAY
	  PLA
	  STA linnumh
	  PLA
	  STA linnuml
	  JMP sgnflt	      ; Integer in Y nach FAC1 bringen

; POKE -  Function Handler
poke	  JSR gtnum	      ; interpretiere XXXX,YY
          TXA
          LDY #$00
          STA (linnuml),Y     ; schreibe YY nach XXXX
          RTS

; WAIT - Function Handler
aswait	  JSR gtnum	      ; Adresse nach linnum, Prfbitmaske nach X
	  STX forpntl	      ; Maske merken
	  LDX #$00	      ; Default-Wert fr Sollwertmaske
	  JSR chargot	      ; hole Zeiche aus Programmtext
	  BEQ wt2	      ; Trennzeichen, keine Maske angegeben
	  JSR combyte	      ; sonst Sollwert-Maske holen
wt2	  STX forpnth
	  LDY #$00
wt3	  LDA (linnuml),Y     ; Inhalt der Wait-Adresse holen
	  EOR forpnth	      ; Sollwertmaske invertiert Bits, die Null sein sollen
	  AND forpntl	      ; Prfbitmaske holt relevante Bits heraus
	  BEQ wt3	      ; kein relevantes Bit, warten
rtn4	  RTS


; Arithmetik-Routinen
;
; FAC1 := FAC1 + 0.5
faddh	  LDA #half # 256     ; Zeiger auf FP-Konstante 0.5
	  LDY #half / 256
	  JMP fadd

; FAC1 := (A,Y) - FAC1
fsub	  JSR conupk	      ; (A,Y) nach FAC2 bertragen

; FAC1 := FAC2- FAC1
fsubt	  LDA FAC1sign
	  EOR #$FF
	  STA FAC1sign	      ; Vorzeichen von FAC1 invertieren
	  EOR FAC2sign
	  STA xorfsgn
	  LDA FAC1exp
	  JMP faddt	      ; FAC1 = FAC2 + (-FAC1)

; Hilfsroutine fr Additionsroutine
ad0	  JSR shift	      ; Stellenwertigkeiten von FAC1, FAC2 angleichen
	  BCC ad5	      ; immer zurck

; FAC1 := (A,Y) + FAC1
fadd	  JSR conupk	      ; (A,Y) nach FAC2 bertragen

; FAC1 := FAC2 + FAC1
faddt	  BNE ad1	      ; FAC1 ungleich Null, Addition durchfhren
	  JMP movfa	      ; sonst FAC1 gleich FAC2 setzen, fertig
ad1	  LDX extrafac	      ; Rundungsstelle von FAC1
	  STX extrasv
	  LDX #FAC2	      ; Offset fr Mantissenverschiebung
	  LDA FAC2exp
ad2	  TAY
	  BEQ rtn4	      ; FAC2 = 0, damit fertig
	  SEC
	  SBC FAC1exp
	  BEQ ad5	      ; beide Exponenten gleich, keine Mantissenverschiebung ntig
	  BCC ad3	      ; Exponent 1 > Exponent 2
	  STY FAC1exp	      ; Exp.2 grer, fr Ergebnis nehmen
	  LDY FAC2sign
	  STY FAC1sign	      ; da Betrag von FAC2 grer, Vorzeichen von FAC2 nehmen
	  EOR #$FF	      ; Differenz der Exponenten negieren
	  ADC #$00
	  LDY #$00
	  STY extrasv	      ; gemerkte Rundungsstelle von FAC1 lschen
	  LDX #FAC1	      ; Offsetzeiger fr Mantissenverschiebung auf FAC1
	  BNE ad4	      ; immer springen
ad3	  LDY #$00
	  STY extrafac	      ; Rundungsstelle von FAC1 lschen
; Mantissen angleichen
ad4	  CMP #$F9	      ; Exponentendifferenz kleiner -7?
	  BMI ad0	      ; ja, kleinere Zahl nach rechtsa schieben bis Mantisse ok
	  TAY		      ; sonst kleinere Zahl bitweise verschieben bis ok
	  LDA extrafac
	  LSR $01,X	      ; hchstes Mantissenbyte rechtsschieben
	  JSR shftr	      ; weiter bei Verschieberoutine
; Vorzeichenanalyse
ad5	  BIT xorfsgn	      ; bit7 = 0 falls die Summanden gleiches Vorzeichen haben
	  BPL adman	      ; Vorzeichen gleich, Mantissen addieren
	  LDY #FAC1
	  CPX #FAC2	      ; war Exp.2 kleiner als Exp.1
	  BEQ subman	      ; ja
	  LDY #FAC2
; Mantissen subtrahieren
;   Y ist Zeiger auf Zahl mit grerem Exponenten, X zeigt auf die andere
subman	  SEC		      
	  EOR #$FF	      ; Rundungsstellen subtrahieren
	  ADC extrasv
	  STA extrafac
	  LDA $04,Y	      ; niedrigstes Mantissenbyte M1
	  SBC $04,X
	  STA FAC1+4
	  LDA $03,Y	      ; M2
	  SBC $03,X
	  STA FAC1+3
	  LDA $02,Y	      ; M3
	  SBC $02,X
	  STA FAC1+2
	  LDA $01,Y	      ; M4 subtrahieren
	  SBC $01,X
	  STA FAC1+1
sgnif	  BCS signif	      ; Mantissendifferenz positiv, ok
	  JSR negfac	      ; FAC1 komplementieren, da negativ
; FAC1 normieren (Mantisse linksbndig machen)
signif	  LDY #$00
	  TYA		      ; Akku als Zhler (fr Exponentenkorrektur)
	  CLC
floop	  LDX FAC1+1	      ; hchstes Mantissenbyte
	  BNE fr2	      ; nicht leer, um einzelne Bits verschieben
	  LDX FAC1+2	      ; sonst um ganze Bytes verschieben:
	  STX FAC1+1	      ; M3 -> M4
	  LDX FAC1+3
	  STX FAC1+2	      ; M2 -> M3
	  LDX FAC1+4
	  STX FAC1+3	      ; M1 -> M2
	  LDX extrafac
	  STX FAC1+4	      ; Rundungsstelle -> M1
	  STY extrafac	      ; Rundungsstelle lschen
	  ADC #$08	      ; Zhler um 8 erhhen
	  CMP #$20	      ; bereits um 4 Bytes verschoben?
	  BNE floop	      ; nein, weiter
zerofac   LDA #$00	      ; sonst ist die Mantisse Null
; FAC1 nullsetzen
atofac	  STA FAC1exp	      ; Exponent und Vorzeichen nullsetzen
atofacs   STA FAC1sign
	  RTS

; Mantissen addieren, Summe nach FAC1
adman	  ADC extrasv	      ; Rundungsstelle addieren
	  STA extrafac
	  LDA FAC1+4	      ; niedrigstes Mantissenbyte M1 addieren
	  ADC FAC2+4
	  STA FAC1+4
	  LDA FAC1+3	      ; M2
	  ADC FAC2+3
	  STA FAC1+3
	  LDA FAC1+2	      ; M3
	  ADC FAC2+2
	  STA FAC1+2
	  LDA FAC1+1	      ; M4
	  ADC FAC2+1
	  STA FAC1+1
	  JMP fr3	      ; berlaufstelle einfgen, falls ntig

; FAC1 normieren (linksbndig machen, bit-weise)
fr1	  ADC #$01	      ; Zhler erhhen
	  ASL extrafac	      ; Rundungsstelle verschieben
	  ROL FAC1+4	      ; M1
	  ROL FAC1+3	      ; M2
	  ROL FAC1+2	      ; M3
	  ROL FAC1+1	      ; M4
fr2	  BPL fr1	      ; hchstwertigstes bit Null, weiterschieben
	  SEC		      ; Akku = Anzahl der bits, um die linksverschoben wurde
	  SBC FAC1exp	      ; minus Exponent
	  BCS zerofac	      ; wenn Exponent zu klein, FAC1 nullsetzen
	  EOR #$FF	      ; Vorzeichen korrigieren
	  ADC #$01
	  STA FAC1exp	      ; und eintragen (C ist Null)
fr3	  BCC rtn5	      ; kein berlauf, fertig
fround	  INC FAC1exp	      ; sonst Exponent erhhen
	  BEQ overflow	      ; Exponentenoverflow -> OVERFLOW ERROR
	  ROR FAC1+1	      ; Mantisse um 1 bit rechtsverschieben, C=1 ins hchste bit
	  ROR FAC1+2
	  ROR FAC1+3
	  ROR FAC1+4
	  ROR extrafac
rtn5	  RTS

; FAC1 komplementieren
negfac	  LDA FAC1sign	      ; Vorzeichen umdrehen
	  EOR #$FF
	  STA FAC1sign
neg2	  LDA FAC1+1	      ; Mantisse invertieren
	  EOR #$FF
	  STA FAC1+1
	  LDA FAC1+2
	  EOR #$FF
	  STA FAC1+2
	  LDA FAC1+3
	  EOR #$FF
	  STA FAC1+3
	  LDA FAC1+4
	  EOR #$FF
	  STA FAC1+4
	  LDA extrafac
	  EOR #$FF
	  STA extrafac
; FAC1 um 1 an geringwertigster Bitstelle erhhen
	  INC extrafac
	  BNE rtn6
pluseps   INC FAC1+4
	  BNE rtn6
	  INC FAC1+3
	  BNE rtn6
	  INC FAC1+2
	  BNE rtn6
	  INC FAC1+1
rtn6	  RTS

overflow  LDX #$45	      ; 'OVERFLOW'-Offset
          JMP Error

; Hilfsregister rechtsverschieben
shftres   LDX #result-1
; Mantisse rechtsverschieben
; I: Akku = negative Anzahl zu verschiebender bits
;    X = Zeiger auf Mantisse in Zeropage
nxshft	  LDY $04,X	      ; Mantisse um ganze Bytes verschieben
	  STY extrafac	      ; M1 -> Rundungsstelle
	  LDY $03,X
	  STY $04,X	      ; M2 -> M1
	  LDY $02,X
	  STY $03,X	      ; M3 -> M2
	  LDY $01,X
	  STY $02,X	      ; M4 -> M3
	  LDY fpgen	      ; =$00 falls positiv, $FF falls negativ
	  STY $01,X	      ; nach M4
; allgemeiner Einsprung
shift	  ADC #$08	      ; Zhler erhhen
	  BMI nxshft	      ; noch kleiner Null, also um ganze Bytes verschieben
	  BEQ nxshft	      ; gleich Null, um ein ganzes Byte verschieben
	  SBC #$08	      ; sonst Zhler wieder auf alten Wert bringen
	  TAY
	  LDA extrafac
	  BCS sh3	      ; fertig wenn Zhler null
; Verschiebung um einzelne bits
sh1	  ASL $01,X	      ; hchstes bit nach C
	  BCC sh2	      ; =0, bei Rechtsverschiebung vorne Nullbit anfgen
	  INC $01,X	      ; sonst bit1 setzen, geht gleich ins Carry
sh2	  ROR $01,X	      ; ASL rckgngig machen, anzufgendes bit in C
	  ROR $01,X	      ; M4 rechtsschieben
shftr	  ROR $02,X	      ; M3
	  ROR $03,X	      ; M2
	  ROR $04,X	      ; M1
	  ROR A 	      ; Rundungsstelle verschieben
	  INY		      ; Zhler erhhen
	  BNE sh1	      ; und weiter schieben
sh3	  CLC
	  RTS

one	  BYT $81,$00,$00,$00,$00	; FP-Konstante 1

; Reihenkoeffizienten fr die LOG-Routine
logser	  BYT $03			; Grad des Polynoms
	  BYT $7F,$5E,$56,$CB, $79	; 0.434255942
	  BYT $80,$13,$9B,$0B,$64	; 0.576584541
	  BYT $80,$76,$38,$93,$16	; 0.961800759
	  BYT $82,$38,$AA,$3B,$20	; 2.88539007

sqrhalf   BYT $80,$35,$04,$F3,$34	; FP-Konstante SQR(0.5)
sqrtwo	  BYT $81,$35,$04,$F3,$34	; FP-Konstante SQR(2.0)
halfneg   BYT $80,$80,$00,$00,$00	; FP-Konstante -0.5
logtwo	  BYT $80,$31,$72,$17,$F8	; FP-Konstante log naturalis 2.0


; FAC1 := LOG (FAC1)
; nach der Formel ln (x * 2^k) = ln (x) + k * ln(2)
log	  JSR sign	      ; Vorzeichen von FAC1 testen
	  BEQ giq	      ; FAC1 = 0 -> ILLEGAL QUANTITY ERROR
	  BPL lg2	      ; FAC1 > 0 -> ok, natrlichen Logarithmus berechnen
giq	  JMP iqerr	      ; sonst Fehlermeldung
lg2	  LDA FAC1exp	      ; Exponent des Argumentes
	  SBC #$7F	      ; minus 128 gibt wahren Exponenten
	  PHA
	  LDA #$80	      ; 1 als neuer Exponent, damit 0.5 <= FAC1 < 1
	  STA FAC1exp
	  LDA #sqrhalf # 256  ; Zeiger auf Konstante SQR(0.5)
	  LDY #sqrhalf / 256
	  JSR fadd	      ; FAC1 = FAC1 + SQR(0.5)
	  LDA #sqrtwo # 256   ; Zeiger auf Konstante SQR(2)
	  LDY #sqrtwo / 256
	  JSR fdiv	      ; FAC1 = SQR(2) / FAC1
	  LDA #one # 256      ; Zeiger auf Konstante 1
	  LDY #one / 256
	  JSR fsub	      ; FAC1 = 1 - FAC1, damit x'=(x-k)/(x+k), k=SQR(0.5)
	  LDA #logser # 256   ; Zeiger auf Polynomkoeffizienten
	  LDY #logser / 256
	  JSR oddser	      ; Polynom mit x' auswerten, ergibt ln(x)/ln(2)+0.5
	  LDA #halfneg # 256  ; Zeiger auf Konstante -0.5
	  LDY #halfneg / 256
	  JSR fadd	      ; zu FAC1 addieren ergibt ln(x)/ln(2)
	  PLA		      ; Exponent zur Basis 2 (d.h. k) holen
	  JSR addacc	      ; zum gerundeten FAC1 addieren ergibt ln(x)/ln(2)+k
	  LDA #logtwo # 256   ; Zeiger auf Konstante ln (2)
	  LDY #logtwo / 256

; FAC1 := FAC1 * (A,Y)
fmult	  JSR conupk	      ; (A,Y) nach FAC2 bringen
fmultt	  BNE fmu	      ; wenn ungleich Null, Multiplikation ausfhren
	  JMP rtn7	      ; FAC1 = 0 also Produkt = 0, fertig

; FAC1 := FAC2* FAC1
fmu	  JSR adexp	      ; Exponenten addieren
	  LDA #$00
	  STA result	      ; Hilfsregister lschen
	  STA result+1
	  STA result+2
	  STA result+3
	  LDA extrafac	      ; FAC1 Byte fr Byte mit FAC2 multiplizieren,
	  JSR fm1	      ; Ergebnis im Hilfsregister aufsummieren
	  LDA FAC1+4	      ; M1
	  JSR fm1
	  LDA FAC1+3	      ; M2
	  JSR fm1
	  LDA FAC1+2	      ; M3
	  JSR fm1
	  LDA FAC1+1	      ; M4
	  JSR fm2
	  JMP res_fac	      ; Hilfsregister nach FAC1 bringen und linksbndig machen

; Akku * FAC2 zu Hilfsregister addieren und verschieben
fm1	  BNE fm2	      ; Akku <> 0, multiplizieren
	  JMP shftres	      ; sonst nur Hilfsregister um 1 Byte nach rechts verschieben
fm2	  LSR A 	      ; bit0 ins Carry
	  ORA #$80	      ; bit7 setzen (als Abbruchmarke)
fm3	  TAY		      ; merken
	  BCC fm4	      ; bit = 0, nur schieben
	  CLC		      ; bit = 1, auch addieren
	  LDA result+3
	  ADC FAC2+4	      ; FAC2 zu Hilfsregister addieren
	  STA result+3
	  LDA result+2
	  ADC FAC2+3
	  STA result+2
	  LDA result+1
	  ADC FAC2+2
	  STA result+1
	  LDA result
	  ADC FAC2+1
	  STA result
fm4	  ROR result	      ; Hilfsregister um 1 bit nach rechts schieben
	  ROR result+1
	  ROR result+2
	  ROR result+3
	  ROR extrafac	      ; letztes bit in Rundungsstelle schieben
	  TYA		      ; Multiplikator
	  LSR A 	      ; nchstes bit nach C bringen
	  BNE fm3	      ; Endmarke noch nicht erreicht, neues bit bearbeiten
rtn7	  RTS

; Lade FAC2 mit (A,Y)
conupk	  STA indexl	      ; Zeiger bernehmen
	  STY indexh
	  LDY #$04	      ; Index auf 4. Mantissenbyte
	  LDA (indexl),Y
	  STA FAC2+4
	  DEY
	  LDA (indexl),Y
	  STA FAC2+3
	  DEY
	  LDA (indexl),Y
	  STA FAC2+2
	  DEY
	  LDA (indexl),Y      ; Vorzeichen steckt in bit7
	  STA FAC2sign
	  EOR FAC1sign
	  STA xorfsgn	      ; Kombivorzeichen eintragen
	  LDA FAC2sign
	  ORA #$80	      ; bit7 setzen
	  STA FAC2+1
	  DEY
	  LDA (indexl),Y      ; Exponent bertragen
	  STA FAC2exp
	  LDA FAC1exp	      ; mit Exponent von FAC1 zurck
	  RTS

; Exponenten von FAC1 und FAC2 addieren
adexp	  LDA FAC2exp
adex2	  BEQ zero	      ; FAC2 = 0, also auch das Produkt, fertig
	  CLC
	  ADC FAC1exp
	  BCC adex3	      ; Produkt kleiner als 1
	  BMI jov	      ; Produkt zu gro, OVERFLOW ERROR
	  CLC
	  BYT $2C	      ; nchste Zeile berspringen
adex3	  BPL zero	      ; Produkt nullsetzen
	  ADC #$80	      ; Exponent des Ergebnisses in Normalform
	  STA FAC1exp
	  BNE adex4	      ; Produkt <> 0
	  JMP atofacs	      ; sonst noch Vorzeichen nullsetzen, fertig
adex4	  LDA xorfsgn	      ; Kombivorzeichen
	  STA FAC1sign	      ; als Vorzeichen des Ergebnisses
	  RTS

; fr EXP-Routine Argument prfen
outofrng  LDA FAC1sign
	  EOR #$FF
	  BMI jov	      ; FAC1 positiv, d.h. Argument zu gro -> OVERFLOW ERROR
zero	  PLA		      ; FAC1 negativ, d.h. Argument zu klein -> nullsetzen
	  PLA		      ; Rcksprungadresse entfernen
	  JMP zerofac	      ; FAC1 nullsetzen, fertig

jov	  JMP overflow	      ; OVERFLOW ERROR ausgeben

; FAC1 := FAC1 * 10
mul10	  JSR movaf	      ; FAC1 nach FAC2 bertragen
	  TAX		      ; Exponent von FAC1
	  BEQ rtn8	      ; FAC1 = 0, also auch das Ergebnis
	  CLC
	  ADC #$02	      ; plus 2 im Exponenten ergibt den 4fachen Wert
	  BCS jov	      ; berlauf?
	  LDX #$00
	  STX xorfsgn	      ; Kombi-Vorzeichen plus
	  JSR ad2	      ; FAC1 = FAC1 + FAC2, das ergibt 5fachen Wert
	  INC FAC1exp	      ; und nochmal verdoppeln
	  BEQ jov	      ; berlauf?
rtn8	  RTS

num10	  BYT $84,$20,$00,$00,$00	; FP-Konstante 10

; FAC1 := FAC1 / 10
div10	  JSR movaf	      ; FAC1 nach FAC2 bringen
	  LDA #num10 # 256    ; Zeiger auf Konstante 10
	  LDY #num10 / 256
	  LDX #$00
div	  STX xorfsgn	      ; Kombivorzeichen plus
	  JSR movfm	      ; Konstante nach FAC1 bertragen
	  JMP fdivt	      ; und Division durchfhren

; FAC1 := (A,Y) / FAC1
fdiv	  JSR conupk	      ; (A,Y) nach FAC2 bertragen

; FAC1 := FAC2 / FAC1
fdivt	  BEQ divz	      ; FAC1 = 0 -> DIVISION BY ZERO ERROR
	  JSR rndb	      ; FAC1 runden
	  LDA #$00
	  SEC
	  SBC FAC1exp	      ; ergibt negativen Exponenten
	  STA FAC1exp
	  JSR adexp	      ; Exponenten und Vorzeichen des Ergebnisses bestimmen
	  INC FAC1exp
	  BEQ jov	      ; Quotiont zu gro, OVERFLOW ERROR
	  LDX #$FC	      ; -4 als Index (in Zeropage modulo 256!)
	  LDA #$01	      ; setze bit0 = 1 als Abbruchmarke
fd1	  LDY FAC2+1	      ; Vergleiche FAC2 mit FAC1
	  CPY FAC1+1
	  BNE fd2
	  LDY FAC2+2
	  CPY FAC1+2
	  BNE fd2
	  LDY FAC2+3
	  CPY FAC1+3
	  BNE fd2
	  LDY FAC2+4
	  CPY FAC1+4
fd2	  PHP		      ; rette Statusflags
	  ROL A 	      ; C -> bit0, bit7 -> C
	  BCC fd3	      ; Abbruchmarke noch nicht erreicht
	  INX		      ; neues Byte des Quotienten voll
	  STA result+3,X      ; abspeichern im Hilfsregister ($62..$65)
	  BEQ fd6	      ; X=0, d.h. 4 Byte im Ergebnis, jedoch noch 2 weitere bits
	  BPL fd7	      ; X=1, Division fertig, Routine abschlieen
	  LDA #$01	      ; Abbruchbit fr nchstes Ergebnisbyte
fd3	  PLP		      ; Statusflags holen
	  BCS fd5	      ; FAC1 kleiner FAC2 -> subtrahieren
fd4	  ASL FAC2+4	      ; FAC2 um 1 bit nach links schieben
	  ROL FAC2+3
	  ROL FAC2+2
	  ROL FAC2+1
	  BCS fd2	      ; FAC2 nun sicher grer als FAC1, Vergleich nicht ntig
	  BMI fd1	      ; hchstes bit in FAC2 = 1, Vergleich durchfhren
	  BPL fd2	      ; FAC2 sicher kleiner als FAC1, Vergleich nicht ntig
; Mantissen subtrahieren
fd5	  TAY		      ; Ergebnisbyte retten
	  LDA FAC2+4
	  SBC FAC1+4	      ; subtrahieren
	  STA FAC2+4
	  LDA FAC2+3
	  SBC FAC1+3
	  STA FAC2+3
	  LDA FAC2+2
	  SBC FAC1+2
	  STA FAC2+2
	  LDA FAC2+1
	  SBC FAC1+1
	  STA FAC2+1
	  TYA		      ; Ergebnisbyte holen
	  JMP fd4	      ; weiter in der Hauptroutine

fd6	  LDA #$40	      ; Abbruchmarke fr 2 weitere Ergebnisbits
	  BNE fd3	      ; Division abschlieen

fd7	  ASL		      ; im letzten Ergebnisbyte nur bit 0 und 1 gltig
	  ASL
	  ASL
	  ASL
	  ASL
	  ASL
	  STA extrafac	      ; linksbndig in Rundungsstelle eintragen
	  PLP		      ; stack aktualisieren
	  JMP res_fac	      ; Hilfsregister nach FAC1 und linksbndig machen

divz	  LDX #$85	      ; 'DIVISION BY ZERO' -Offset
	  JMP error	      ; Fehlermeldung bearbeiten

; Hilfsregister linksbndig nach FAC1 bertragen
res_fac   LDA result
	  STA FAC1+1
	  LDA result+1
	  STA FAC1+2
	  LDA result+2
	  STA FAC1+3
	  LDA result+3
	  STA FAC1+4
	  JMP signif	      ; FAC1 linksbndig machen

; Lade FAC1 mit (A,Y)
movfm	  STA indexl	      ; Zeiger bernehmen
	  STY indexh
	  LDY #$04	      ; Index auf geringwertigstes Mantissenbyte
	  LDA (indexl),Y
	  STA FAC1+4
	  DEY
	  LDA (indexl),Y
	  STA FAC1+3
	  DEY
	  LDA (indexl),Y
	  STA FAC1+2
	  DEY
	  LDA (indexl),Y
	  STA FAC1sign	      ; hchstes Mantissenbyte enthlt Vorzeichen in bit7
	  ORA #$80	      ; bit7 auf 1 setzen
	  STA FAC1+1
	  DEY
	  LDA (indexl),Y
	  STA FAC1exp
	  STY extrafac	      ; Rundungsstelle lschen
	  RTS

; transferiere FAC1 gepackt nach Temp2 (FAC4)
mov2f	  LDX #FAC4	      ; Einsprung fr FAC4, X als Zeiger
	  BYT $2C	      ; nchste Zeile ignorieren

; transferiere FAC1 gepackt nach Temp1 (FAC3)
mov1f	  LDX #FAC3	      ; Einsprung fr FAC3, X als Zeiger
movml	  LDY #$00	      ; MSB
	  BEQ movmf	      ; immer springen

; Transferiere FAC1 gepackt nach (forpnt)
setfor	  LDX forpntl	      ; Einsprung fr forpnt als Zeiger
	  LDY forpnth

; FAC1 nach (X,Y) bertragen
movmf	  JSR rndb	      ; FAC1 runden
	  STX indexl	      ; Zeiger auf Zieladressen bernehmen
	  STY indexh
	  LDY #$04	      ; als Index
	  LDA FAC1+4
	  STA (indexl),Y
	  DEY
	  LDA FAC1+3
	  STA (indexl),Y
	  DEY
	  LDA FAC1+2
	  STA (indexl),Y
	  DEY
	  LDA FAC1sign	      ; Vorzeichen von FAC1
	  ORA #$7F
	  AND FAC1+1	      ; in hchstes Mantissenbyte einfgen
	  STA (indexl),Y
	  DEY
	  LDA FAC1exp
	  STA (indexl),Y
	  STY extrafac	      ; Rundungsstelle lschen
	  RTS

; Lade FAC1 mit FAC2
movfa	  LDA FAC2sign
mfa	  STA FAC1sign
	  LDX #$05	      ; Index fr Schleife
mfa2	  LDA FAC2-1,X
	  STA FAC1-1,X	      ; Byte fr Byte bertragen
	  DEX
	  BNE mfa2
	  STX extrafac	      ; Rundungsstelle lschen
	  RTS

; FAC1 gerundet nach FAC2 bertragen
movaf	  JSR rndb
maf	  LDX #$06	      ; Index fr Schleife
maf2	  LDA FAC1-1,X
	  STA FAC2-1,X
	  DEX
	  BNE maf2
	  STX extrafac	      ; Rundungsstelle lschen
rtn9	  RTS

; FAC1 runden
rndb	  LDA FAC1exp
	  BEQ rtn9	      ; FAC1 = 0, fertig
	  ASL extrafac	      ; bit7 der Rundungsstelle ins Carry
	  BCC rtn9	      ; abrunden, also fertig
round	  JSR pluseps	      ; aufrunden, Mantisse um 1 bit erhhen
	  BNE rtn9	      ; Mantisse nicht null, also kein berlauf
	  JMP fround	      ; sonst berlauf-Bit bercksichtigen

; Vorzeichen von FAC1 testen
sign	  LDA FAC1exp
	  BEQ rtn10	      ; FAC1 = 0
sign1	  LDA FAC1sign
sign2	  ROL A 	      ; bit7 ins Carry	  Akku C Z N  falls
	  LDA #$FF	      ; -1		  ====================
	  BCS rtn10	      ; 		  255  1 0 1  FAC1 < 0
	  LDA #$01	      ; +1		    0  ? 1 0  FAC1 = 0
rtn10	  RTS		      ; 		    1  0 0 0  FAC1 > 0

; FAC1 := SGN(FAC1)
sgn	  JSR sign	      ; Vorzeichen von FAC1 testen  +  0  -
; Float 1byte signed Integer
float	  STA FAC1+1	      ; Code nach M1		    1  0  255
	  LDA #$00
	  STA FAC1+2	      ; M2 = 0
	  LDX #$88	      ; Exponent fr Integer
flo1	  LDA FAC1+1	      ; Vorzeichen
	  EOR #$FF	      ; umkehren
	  ROL A 	      ; bit7 ins Carry		C = 1  1  0
flo2	  LDA #$00
	  STA FAC1+4
	  STA FAC1+3
	  STX FAC1exp	      ; Exponent eintragen
	  STA extrafac	      ; Rundungsstelle lschen
	  STA FAC1sign	      ; Vorzeichen lschen
	  JMP sgnif	      ; invertieren falls negativ, linksbndig machen

; FAC1 := ABS(FAC1)
abs	  LSR FAC1sign	      ; bit7 nullsetzen, d.h. positives Vorzeichen
	  RTS

; vergleiche FAC1 mit (A,Y)
fcomp	  STA ptrgul	      ; Zeiger bernehmen
fcomp2	  STY ptrguh
	  LDY #$00
	  LDA (ptrgul),Y      ; Exponent des Vergleichsregisters
	  INY
	  TAX		      ; merken
	  BEQ sign	      ; Vergleichsregister = 0 -> Vorzeichen von FAC1 testen
	  LDA (ptrgul),Y      ; hchstes Mantissenbyte, Vorzeichen in bit7
	  EOR FAC1sign	      ; mit Vorzeichen von FAC1 vergleichen
	  BMI sign1	      ; verschieden -> Vorzeichen von FAC1 testen
	  CPX FAC1exp	      ; Exponenten vergleichen (C=0 falls FAC1 grer)
	  BNE fc1	      ; ungleich
	  LDA (ptrgul),Y      ; sonst Mantissen vergleichen
	  ORA #$80	      ; bit7 setzen (statt Vorzeichen)
	  CMP FAC1+1	      ; hchstes Mantissenbyte vergleichen
	  BNE fc1
	  INY
	  LDA (ptrgul),Y
	  CMP FAC1+2
	  BNE fc1
	  INY
	  LDA (ptrgul),Y
	  CMP FAC1+3
	  BNE fc1
	  INY
	  LDA #$7F
	  CMP extrafac	      ; Rundungsstelle mit $7F vergleichen, C setzen
	  LDA (ptrgul),Y
	  SBC FAC1+4	      ; niedrigstes Byte vergleichen, C je nach Rundungsstelle
	  BEQ rtn11	      ; FAC1 = Vergleichsregister, fertig
fc1	  LDA FAC1sign
	  BCC fc2	      ; FAC1 betragsmig grer -> Vergleich auswerten
	  EOR #$FF	      ; sonst Vorzeichen umkehren
fc2	  JMP sign2	      ; Vergleichsflags setzen wie bei Vorzeichentest

; FAC1 in Integerformat bringen (Integer in 'vpnt')
qint	  LDA FAC1exp
	  BEQ zfac	      ; FAC1 = 0, Mantisse mit Nullen fllen
	  SEC
	  SBC #$A0	      ; Ergibt Stellenwert fr geringwertigstes bit
	  BIT FAC1sign
	  BPL qi1	      ; Vorzeichen ist positiv
	  TAX		      ; sonst Stellenwertigkeit retten
	  LDA #$FF	      ; zum Auffllen beim Verschieben
	  STA fpgen
	  JSR neg2	      ; Mantisse invertieren
	  TXA		      ; Stellenwertigkeit wiederholen
qi1	  LDX #FAC1
	  CMP #$F9	      ; Stellenwertigkeit mit -7 vergleichen
	  BPL qi2	      ; grer als -8
	  JSR shift	      ; Mantisse verschieben bis Stellenwertigkeit ok
	  STY fpgen	      ; Auffllbyte lschen
rtn11	  RTS
qi2	  TAY		      ; Stellenwertigkeit fr Verschiebung nach Y
	  LDA FAC1sign
	  AND #$80	      ; Vorzeichen herausholen
	  LSR FAC1+1	      ; hchstes Mantissenbyte nach rechts schieben
	  ORA FAC1+1	      ; Vorzeichen eintragen
	  STA FAC1+1
	  JSR shftr	      ; weiter bei Verschieberoutine
	  STY fpgen	      ; Auffllbyte nullsetzen
	  RTS

; FAC1 := INT(FAC1)
int	  LDA FAC1exp
	  CMP #$A0	      ; schon richtige Stellenwertigkeit fr Integerformat?
	  BCS rtn12	      ; FAC1 schon ganzzahlig, fertig
	  JSR qint	      ; sonst FAC1 ins Integerformat bringen
	  STY extrafac	      ; Rundungsstelle lschen
	  LDA FAC1sign	      ; Vorzeichen von FAC1 in Akku
	  STY FAC1sign	      ; Vorzeichenbyte lschen
	  EOR #$80	      ; Vorzeichen in bit7 negieren
	  ROL A 	      ; damit C=1 falls positives Argument
	  LDA #$A0	      ; Exponent fr Integerformat
	  STA FAC1exp
	  LDA FAC1+4	      ; niedrigstes Mantissenbyte
	  STA charac	      ; retten
	  JMP sgnif	      ; FAC1 linksbndig machen

zfac	  STA FAC1+1	      ; Mantisse von FAC1 mit Wert in Akku fllen
	  STA FAC1+2
	  STA FAC1+3
	  STA FAC1+4
	  TAY
rtn12	  RTS

; String in FP-Konstante (in FAC1) umwandeln
; I: txtptr zeigt auf Stringadresse, Akku = 1. Zeichen
fin       LDY #$00
	  LDX #$0A	      ; als Zhlindex
fin2	  STY tmpexp,X	      ; Adressen $99..$A3 lschen
	  DEX
	  BPL fin2
; Auswertung der Stringmantisse
	  BCC nxdigit	      ; 1. Stringzeichen ist Ziffer, zur Mantissenauswertung
	  CMP #$2D	      ; Ist es '-'?
	  BNE fin3	      ; nein, weiter
	  STX serlen	      ; bit7 =1, d.h. Mantissenvorzeichen minus
	  BEQ eval	      ; weiter mit dem nchsten Zeichen
fin3	  CMP #$2B	      ; Ist es '+'?
	  BNE chkdp	      ; nein, weiter
eval	  JSR charget	      ; neues Stringzeichen holen
nxdigit   BCC insrtdig	      ; Ziffer, zur Mantissenauswertung
chkdp	  CMP #$2E	      ; Ist es '.'?
	  BEQ setdp	      ; ja, Dezimalpunktflag setzen
; Auswertung des Stringexponenten
	  CMP #$45	      ; ISt es 'E'?
	  BNE adjexp	      ; nein, keine Zehnerpotenz angegeben, Routine abschlieen
	  JSR charget	      ; sonst neues Zeichen holen
	  BCC gogex	      ; Ziffer, zur Exponenten-Auswertung
	  CMP #$C9	      ; Token fr '-'?
	  BEQ setsgn	      ; ja, Exponent negativ
	  CMP #$2D	      ; ASCII fr '-'?
	  BEQ setsgn	      ; ja, Exponent negativ
	  CMP #$C8	      ; Token fr '+'?
	  BEQ dpdig	      ; ja, ignorieren
	  CMP #$2B	      ; ASCII fr '+'?
	  BEQ dpdig	      ; ja, ignorieren
	  BNE sgnchk	      ; sonst String fertig ausgewertet, Routine abschlieen
setsgn	  ROR expsgn	      ; C=1, d.h. Exponentenvorzeichen negativ machen
dpdig	  JSR charget	      ; neues Stringzeichen holen
gogex	  BCC getexp	      ; Ziffer, zur Exponenten-Auswertung
; Dezimalstellen auswerten
sgnchk	  BIT expsgn	      ; Vorzeichen des Exponenten prfen
	  BPL adjexp	      ; positiv, Stellenwertigkeit bercksichtigen
	  LDA #$00	      ; negativ, Exponentenregister negativ machen
	  SEC
	  SBC expon
	  JMP aex	      ; Stellenwertigkeit bercksichtigen

setdp	  ROR dpflg	      ; C=1, also Dezimalpunktflag setzen
	  BIT dpflg	      ; teste bit6 (=1 fall schonmal ein DPunkt kam)
	  BVC eval	      ; bit6 = 0, weiter mit nchstem Zeichen

adjexp	  LDA expon	      ; Exponentenregister enthlt Stellenwertigkeit
aex	  SEC
	  SBC tmpexp	      ; minus Anzahl der Nachkommastellen
	  STA expon	      ; ergibt wahre Stellenwertigkeit
	  BEQ evdone	      ; =0, also keine dezimale Verschiebung
	  BPL dpright	      ; positiv, FAC1 mit Zehnerpotenz multiplizieren
; durch Zehnerpotenz dividieren
dpleft	  JSR div10	      ; FAC1 = FAC1 / 10
	  INC expon
	  BNE dpleft
	  BEQ evdone
; mit Zehnerpotenz multiplizieren
dpright   JSR mul10	      ; FAC1 = FAC1 * 10
	  DEC expon
	  BNE dpright
evdone	  LDA serlen	      ; Vorzeichen der Mantisse
	  BMI evd	      ; negativ, Vorzeichenwechsel
	  RTS		      ; positiv, fertig
evd	  JMP negop	      ; Vorzeichenwechsel bei FAC1 durchfhren, dann fertig
; Mantissenziffer auswerten
insrtdig  PHA		      ; Ziffer retten
	  BIT dpflg	      ; teste Dezimalpunkt-Flag
	  BPL ndp	      ; Vorkommastelle
	  INC tmpexp	      ; sonst Nachkommastellenzhler erhhen
ndp	  JSR mul10	      ; FAC1 = FAC1 * 10, d.h. um eine Dezimale verschieben
	  PLA		      ; Ziffer (in ASCII) holen
	  SEC
	  SBC #$30	      ; das ergibt reine Ziffer
	  JSR addacc	      ; diese zum FAC1 addieren
	  JMP eval	      ; und weiter mit neuem Zeichen
;Zahl in Akku zu FAC1 addieren
addacc	  PHA
	  JSR movaf	      ; FAC1 gerundet nach FAC2 bertragen
	  PLA
	  JSR float	      ; Zahl in FP-Konstante umwandeln
	  LDA FAC2sign
	  EOR FAC1sign
	  STA xorfsgn
	  LDX FAC1exp
	  JMP faddt	      ; Addition durchfhren
; Exponentendifferenz auswerten
getexp	  LDA expon	      ; bisheriger Exponent
	  CMP #$0A	      ; mit 10 vergleichen
	  BCC mvdg	      ; kleiner, Ziffer im Exponent eintragen
	  LDA #$64	      ; sonst 100 als neuer Exponentenbetrag
	  BIT expsgn	      ; teste Vorzeichen
	  BMI stex	      ; negativ, damit wird FAC1 spter zu Null
	  JMP overflow	      ; positiv, OVERFLOW ERROR
mvdg	  ASL
	  ASL		      ; bisheriger Exponent mal vier
	  CLC
	  ADC expon	      ; plus eins macht fnf
	  ASL		      ; verdoppeln gibt 10
	  CLC
	  LDY #$00
	  ADC (txtptrl),Y     ; ASCII-Code der neuen Ziffer addieren
	  SEC
	  SBC #$30
stex	  STA expon
	  JMP dpdig	      ; weiter mit neuem Zeichen

hmmitnth  BYT $9B,$3E,$BC,$1F,$FD	; FP-Konstante	 99 999 999.906
bilmione  BYT $9E,$6E,$6B,$27,$FD	; FP-Konstante	999 999 999.25
billion   BYT $9E,$6E,$6B,$28,$00	; FP-Konstante 1000 000 000

; drucke ' IN ' + aktuelle Zeilennummer
inprt	  LDA #inmsg # 256
	  LDY #inmsg / 256    ; Zeiger auf ' IN '
	  JSR prstr	      ; String ausgeben
          LDA curlinh
	  LDX curlinl	      ; aktuelle Zeilennummer
; unsigned Integer - Zahl ausgeben
linprt	  STA FAC1+1
	  STX FAC1+2	      ; in FAC1 bertragen
	  LDX #$90	      ; als Exponent
          SEC
	  JSR flo2	      ; FAC1 normieren
; Real - Zahl ausgeben
prntfac   JSR fout	      ; FAC1 in String wandeln
prstr	  JMP strout	      ; und ausgeben

; Wandle FAC1 in Zahlenstring
; Durch Vergleich mit entsprechenden Konstanten werden nach und nach die
; einzelnen Ziffern bestimmt, auerdem Vorzeichen und Exponent.
; O: Stringadresse $0100 bei PRINT, $00FF bei STR$
fout	  LDY #$01	      ; Offset zu $00FF fr Zeiger auf neuen String
; Einsprung von STR$ mit Y=0, d.h. String liegt ab $00FF
facstrng  LDA #$2D	      ; ASCII fr '-'
	  DEY
	  BIT FAC1sign
	  BPL sfsg	      ; Vorzeichen positiv. weiter
	  INY
	  STA $00FF,Y	      ; sonst Minuszeichen eintragen
sfsg	  STA FAC1sign	      ; bit7 lschen, also Betrag bilden
	  STY strng2l	      ; Zeiger auf neuen String retten
	  INY
	  LDA #$30	      ; ASCII fr '0'
	  LDX FAC1exp
	  BNE notze	      ; FAC1 ungleich 0
	  JMP wndup	      ; sonst ASCII-Code fr '0' eintragen, fertig
; FAC1 in den Bereich (10^8, 10^9) bringen
notze	  LDA #$00
	  CPX #$80	      ; Exponent von FAC1 mit #$80 vergleichen
	  BEQ mb	      ; Betrag liegt zwischen 0.5 und 1
	  BCS ste	      ; Betrag ist >= 1
mb	  LDA #billion # 256  ; Zeiger auf FP-Konstante 1000 000 000
	  LDY #billion / 256
	  JSR fmult	      ; FAC1 = FAC1 * 1000 000 000
	  LDA #$F7	      ; -9
ste	  STA tmpexp	      ; als Stellenwert-Flag eintragen
cmpbm1	  LDA #bilmione # 256
	  LDY #bilmione / 256	; Zeiger auf Konstante 999 999 999.25
	  JSR fcomp	      ; FAC1 vergleichen
	  BEQ intpart	      ; gleich, ok, im Sollbereich
	  BPL jd10	      ; zu gro, durch 10 dividieren
cmphm	  LDA #hmmitnth # 256
	  LDY #hmmitnth / 256	; Zeiger auf Konstante 99 999 999.906
	  JSR fcomp	      ; FAC1 vergleichen
	  BEQ jm10	      ; gleich oder zu klein, mit 10 multiplizieren
	  BPL roun	      ; grer, ok, im Sollbereich

jm10	  JSR mul10	      ; FAC1 mit 10 multiplizieren
	  DEC tmpexp	      ; und Stellenwert-Flag verrringern
	  BNE cmphm	      ; prfen, ob nun im Sollbereich

jd10	  JSR div10	      ; FAC1 durch 10 dividieren
	  INC tmpexp	      ; und Stellenwert-Flag erhhen
	  BNE cmpbm1	      ; prfen, ob im Sollbereich
; Stringformat bestimmen (Exponentialdarstellung?)
roun	  JSR faddh	      ; FAC1 = FAC1 + 0.5 (d.h. aufrunden)
intpart   JSR qint	      ; FAC1 in Integerformat bringen, d.h. keine Nachkommastellen
	  LDX #$01
	  LDA tmpexp	      ; Stellenwert-Flag
	  CLC
	  ADC #$0A	      ; plus 10 gibt wahren Exponenten +2
	  BMI dploc	      ; <0, d.h. wahrer Exponent <-2, d.h. Betrag <0.01
	  CMP #$0B	      ; d.h. wahren Exponenten mit 9 vergleichen
	  BCS dpl	      ; Betrag >= 10^9, deshalb Exponentdarstellung
	  ADC #$FF	      ; minus 1
	  TAX		      ; wahren Exponenten +1 in X merken
	  LDA #$02
dploc	  SEC
dpl	  SBC #$02	      ; 	 nermale Darst.  Exponential-Darst.
	  STA expon	      ; ergibt	 0		 Exponenten
	  STX tmpexp	      ; ergibt	 Exponenten +1	 1
	  TXA		      ; Anzahl signifikanter Vorkommastellen
	  BEQ putdp	      ; =0, d.h. 0.1 <= Betrag < 1
	  BPL makstr	      ; >0, d.h. Betrag > 1
putdp	  LDY strng2l	      ; Zeiger auf den String
	  LDA #$2E	      ; ASCII fr Dezimalpunkt
	  INY
	  STA $00FF,Y	      ; in den String eintragen
	  TXA		      ; Anzahl signifikanter Vorkommastellen
	  BEQ svy	      ; 0.1 <= Betrag < 1
	  LDA #$30	      ; 0.01 <= Betrag > 0.1, daher '0' hinter Dezimalpunkt
	  INY
	  STA $00FF,Y	      ; ASCII fr '0' eintragen
svy	  STY strng2l	      ; Zeiger auf den string wieder retten
; Approximation der einzelnen Dezimalstellen
makstr	  LDY #$00	      ; als Zeiger auf Integerkonstante -100 000 000
	  LDX #$80	      ; als Zhler (bit7 = 1 bedeutet negative Konstante)
mslup	  LDA FAC1+4	      ; Konstante zu FAC1 addieren
	  CLC
	  ADC dectbl+3,Y
	  STA FAC1+4
	  LDA FAC1+3
	  ADC dectbl+2,Y
	  STA FAC1+3
	  LDA FAC1+2
	  ADC dectbl+1,Y
	  STA FAC1+2
	  LDA FAC1+1
	  ADC dectbl,Y
	  STA FAC1+1
	  INX		      ; Zhler erhhen
	  BCS parity_	      ; weiter mit dieser Konstanten falls Ergebnis positiv
	  BPL mslup	      ; und Konstante negativ oder umgekehrt
	  BMI counted
parity_   BMI mslup
counted   TXA		      ; Zhler = Ziffer +1
	  BCC makdigit	      ; d.h. Konstante war negativ
	  EOR #$FF	      ; sonst bzgl. 10 komplementieren,
	  ADC #$0A	      ; d.h. Akku = 10 - Akku
makdigit  ADC #$2F	      ; ergibt ASCII-Code der Ziffer
	  INY		      ; Zeiger auf nchste Konstante erhhen
	  INY
	  INY
	  INY
	  STY varpntl	      ; und merken
	  LDY strng2l	      ; Zeiger auf den String holen
	  INY
	  TAX		      ; Zifferncode merken
	  AND #$7F	      ; bit7 lschen
	  STA $00FF,Y	      ; und in String eintragen
	  DEC tmpexp	      ; Anzahl weiterer Vorkommastellen verringern
	  BNE savy	      ; Dezimalpunkt noch nicht erreicht
	  LDA #$2E	      ; sonst ASCII-Code fr Dezimalpunkt
	  INY
	  STA $00FF,Y	      ; in String eintragen
savy	  STY strng2l	      ; Zeiger auf den String wieder retten
	  LDY varpntl	      ; Zeiger auf Konstanten-Tabelle holen
	  TXA		      ; Ziffer, bit7 = Vorzeichen der alten Konstante
	  EOR #$FF	      ; invertieren
	  AND #$80	      ; neue Konstante hat umgekehrtes Vorzeichen
	  TAX		      ; X wieder als Zhler
	  CPY #$24	      ; alle 9 Stellen bestimmt?
	  BNE mslup	      ; nein, nchste Ziffer bestimmen
; unntige Nullen entfernen
	  LDY strng2l	      ; Zeiger auf den String holen
mvback	  LDA $00FF,Y	      ; suche hinterstes von null verschiedenes Zeichen
	  DEY
	  CMP #$30	      
	  BEQ mvback	      ; 0, weiter
	  CMP #$2E	      ; Dezimalpunkt?
	  BEQ needex_	      ; ja, keine Nachkommastelle, Zeiger auf Dezimalpunkt
	  INY		      ; sonst Zeiger auf erste Null setzen
; Format fr Exponentialdarstellung herstellen
needex_   LDA #$2B	      ; ASCII-Code fr '+'
	  LDX expon
	  BEQ markend	      ; keine Exponential-Darstellung
	  BPL putex	      ; Exponent positiv
	  LDA #$00
	  SEC
	  SBC expon	      ; ergibt Betrag des Exponenten
	  TAX
	  LDA #$2D	      ; ASCII fr '-'
putex	  STA $0101,Y	      ; in String eintragen, mit Lcke fr 'E'
	  LDA #$45	      ; ASCII_Code fr 'E'
	  STA $0100,Y	      ; in String eintragen
	  TXA		      ; Betrag des Exponenten
	  LDX #$2F	      ; X als Zhler vorbereiten
	  SEC
whatx	  INX
	  SBC #$0A	      ; so oft 10 subtrahieren, bis Ergebnis negativ
	  BCS whatx	      ; X enthlt dann den ASCII-Code der Zehnerstelle
	  ADC #$3A	      ; (Einerstelle-10) + 58 ergibt ASCII_Code der Einerstelle
	  STA $0103,Y	      ; Einerstelle des Exponenten eintragen
	  TXA
	  STA $0102,Y	      ; Zehnerstelle des Exponenten eintragen
	  LDA #$00	      ; als String-Endmarke
	  STA $0104,Y	      ; eintragen
	  BEQ pntstk	      ; Stringzeiger holen, fertig
; Einsprung falls Zahl =0 war
wndup	  STA $00FF,Y	      ; ASCII-Code fr '0' eintragen
markend   LDA #$00	      ; String-Endmarke anfgen
	  STA $0100,Y
pntstk	  LDA #$00	      ; Zeiger auf Zahlenstring
	  LDY #$01
	  RTS


half	  BYT $80,$00,$00,$00,$00	; FP-Konstante 0.5

; Konstanten im Integerformat
dectbl	  BYT $FA,$0A,$1F,$00		; - 100 000 000
	  BYT $00,$98,$96,$80		;    10 000 000
	  BYT $FF,$F0,$BD,$C0		;    -1 000 000
	  BYT $00,$01,$86,$A0		;	100 000
	  BYT $FF,$FF,$D8,$F0		;	-10 000
	  BYT $00,$00,$03,$E8		;	  1 000
	  BYT $FF,$FF,$FF,$9C		;	  - 100
	  BYT $00,$00,$00,$0A		;	     10
	  BYT $FF,$FF,$FF,$FF		;	     -1


; FAC1 := SQR(FAC1)
sqr	  JSR movaf	      ; FAC1 nach FAC2 bertragen
	  LDA #half # 256     ; Zeiger auf FP-Konstante 0.5
	  LDY #half / 256
fpwrt	  JSR movfm	      ; Konstante nach FAC1 bertragen

; FAC1 := FAC2 ^ FAC1
; mit der Formel a^b = exp( b * ln(a) )
; I: Akku enthlt Exponenten von FAC1
fpwrtt	  BEQ exp	      ; FAC1 = 0, weiter bei EXP liefert 1
	  LDA FAC2exp
	  BNE pw1	      ; Exponent von FAC2 ungleich Null
	  JMP atofac	      ; sonst Ergebnis = 0, FAC1 nullsetzen
pw1	  LDX #FAC5 # 256     ; Zeiger auf FAC5
	  LDY #FAC5 / 256
	  JSR movmf	      ; FAC1 nach FAC5 bertragen (=b)
	  LDA FAC2sign
	  BPL pw2	      ; Vorzeichen von FAC2 (=a) positiv
	  JSR int	      ; FAC1 = INT(FAC1) ergibt int(b)
	  LDA #FAC5 # 256
	  LDY #FAC5 / 256
	  JSR fcomp	      ; FAC1 <> FAC5? (gleich falls b ganzzahlig -> A=0, Y=4)
	  BNE pw2	      ; ungleich, also b nicht ganzzahlig (A=255, Y=1..4)
	  TYA		      ; damit bit7 = 0
	  LDY charac	      ; =b, ganzzahlig
pw2	  JSR mfa	      ; FAC2 -> FAC1, negativ falls a<0 und b nicht ganzzahlig
	  TYA		      ; =0 falls a>0; =b falls a<0 und b ganz; =1..4 sonst
	  PHA		      ; retten
	  JSR log	      ; ln(a) bzw ln(-a) falls a<0 und b ganz, sonst ILLEGAL QUANTITY
	  LDA #FAC5 # 256
	  LDY #FAC5 / 256
	  JSR fmult	      ; FAC1 = FAC1 * FAC5, ergibt b*ln(a)
	  JSR exp	      ; ergibt exp(b*ln(a))
	  PLA		      ; bit0=1 falls a<0 und b ungeradzahlig
	  LSR A 	      ; bit0 ins Carry
	  BCC rtn13	      ; Vorzeichen des Ergebnisses positiv, fertig

; FAC1 := - FAC1
negop	  LDA FAC1exp
	  BEQ rtn13	      ; Ergebnis = 0, fertig
	  LDA FAC1sign
	  EOR #$FF
	  STA FAC1sign	      ; negatives Vorzeichen eintragen
rtn13	  RTS


loge	  BYT $81,$38,$AA,$3B,$29	; FP-Konstante 1/ln(2)

; Reihenkoeffizienten fr EXP-Routine  ln(2)^k / k!  fr k=0..7
expser	  BYT $07			; Grad des Polynoms
	  BYT $71,$34,$58,$3E,$56	; 2.14987637 E-5
	  BYT $74,$16,$7E,$B3,$1B	; 1.43523140 E-4
	  BYT $77,$2F,$EE,$E3,$85	; 1.34226348 E-3
	  BYT $7A,$1D,$84,$1C,$2A	; 9.61401701 E-3
	  BYT $7C,$63,$59,$58,$0A	; 5.55051269 E-2
	  BYT $7E,$75,$FD,$E7,$C6	; 2.40226385 E-1
	  BYT $80,$31,$72,$18,$10	; 6.93147186 E-1 = ln(2)
	  BYT $81,$00,$00,$00,$00	; 1.0


; FAC1 := EXP(FAC1)
; mit der Formel exp(x) = 2 ^ (x/ln(2))
exp	  LDA #loge # 256     ; Zeiger auf Konstante
	  LDY #loge / 256
	  JSR fmult	      ; x / ln(2)
	  LDA extrafac	      ; Rundungsstelle von FAC1
	  ADC #$50
	  BCC x1	      ; abrunden
	  JSR round	      ; aufrunden
x1	  STA extrasv	      ; neue Rundungsstelle merken
	  JSR maf	      ; FAC1 nach FAC2 kopieren
	  LDA FAC1exp
	  CMP #$88
	  BCC x2	      ; FAC1 < 128
oor	  JSR outofrng	      ; sonst Argument zu gro -> OVERFLOW ERROR
x2	  JSR int
	  LDA charac	      ; ganzzahliger Anteil von FAC1
	  CLC
	  ADC #$81
	  BEQ oor	      ; FAC1 >= -127, OVERFLOW ERROR
	  SEC
	  SBC #$01	      ; minus 1
	  PHA		      ; ergibt int(x/ln(2) -1, retten
	  LDX #$05	      ; FAC2 mit FAC1 vertauschen
x3	  LDA FAC2exp,X
	  LDY FAC1exp,X
	  STA FAC1exp,X
	  STY FAC2exp,X
	  DEX
	  BPL x3
	  LDA extrasv	      ; gemerkte Rundungsstelle
	  STA extrafac	      ; in FAC1 eintragen
	  JSR fsubt	      ; FAC1 = FAC2 - FAC1, ergibt negativen Bruchteil
	  JSR negop	      ; FAC1 = -FAC1, ergibt dezimalen Bruchteil von x/ln(2)
	  LDA #expser # 256   ; Zeiger auf Tabelle der Polynomkoeffizienten
	  LDY #expser / 256
	  JSR series	      ; Polynom auswerten mit Argument x' ergibt exp(x')
	  LDA #$00
	  STA xorfsgn	      ; Kombivorzeichen lschen
	  PLA		      ; Exponent bzgl 2, = int(x/ln(2))-1
	  JSR adex2	      ; zum Exponenten von FAC1 addiert ergibt Gesamtexponenten
	  RTS

; Polynom auswerten (nur ungerade Potenzen)
; I: FAC1 enthlt das Argument x
oddser	  STA strng2l	      ; Zeiger auf Tabelle der Polynomkoeffizienten
	  STY strng2h
	  JSR mov1f	      ; FAC1 gerundet nach FAC3 bertragen
	  LDA #FAC3 # 256
	  JSR fmult	      ; FAC1 = FAC1 * FAC3 ergibt x^2
	  JSR sermain	      ; Polynom auswerten, ergibt k1 + k3*x^2 + k5*x^4 + ...
	  LDA #FAC3 # 256
	  LDY #FAC3 / 256
	  JMP fmult	      ; ergibt k1*x + k3*x^3 + k5*x^5 + ...

; Polynom nach dem Hornerschema auswerten
; I: FAC1 enthlt das Argument x
;    A,Y zeigt auf die Tabelle mit den Polynomkoeffizienten
; O: FAC1 enthlt das Ergebnis
series	  STA strng2l	      ; Zeiger auf Tabelle mit Polynomkoeffizienten
	  STY strng2h
sermain   JSR mov2f	      ; FAC1 nach FAC4 bertragen
	  LDA (strng2l),Y     ; Polynomgrad als Zhler
	  STA serlen
	  LDY strng2l
	  INY		      ; Zeiger auf ersten Koeffizienten, LSB
	  TYA
	  BNE ss
	  INC strng2h	      ; MSB korrigieren
ss	  STA strng2l	      ; LSB eintragen
	  LDY strng2h	      ; damit zeigt A,Y auf 1. Koeffizienten
serloop   JSR fmult	      ; mit x multiplizieren
	  LDA strng2l
	  LDY strng2h
	  CLC
	  ADC #$05	      ; Zeiger um 5 erhhen
	  BCC nxterm
	  INY
nxterm	  STA strng2l
	  STY strng2h
	  JSR fadd	      ; neuen Koeffizienten addieren
	  LDA #FAC4 # 256     ; Zeiger auf FAC4, enthlt x
	  LDY #FAC4 / 256
	  DEC serlen	      ; Zhler dekrementieren
	  BNE serloop	      ; Absolutglied noch nicht erreicht, weiter in Schleife
rtn14	  RTS


; Konstanten fr RND
rndadj1   BYT $98,$35,$44,$7A		; (68) 1.18795464 E+7
rndadj2   BYT $68,$28,$B1,$46		; (20) 3.92767778 E-8

; generiere Zufallszahl
rnd	  JSR sign	      ; Vorzeichen von FAC1 testen
	  TAX		      ; 255/0/1 bei -/0/+
	  BMI rd1	      ; negativ
	  LDA #rndval # 256   ; Zeiger auf vorherige Zufallszahl
	  LDY #rndval / 256
	  JSR movfm	      ; diese nach FAC1 bertragen
	  TXA
	  BEQ rtn14	      ; war RND(0), also fertig
	  LDA #rndadj1 # 256  ; 1. Konstante z1
	  LDY #rndadj1 / 256
	  JSR fmult	      ; FAC1 = FAC1 * z1
	  LDA #rndadj2 # 256  ; 2. Konstante z2
	  LDY #rndadj2 / 256
	  JSR fadd	      ; FAC1 = FAC1 + z2
; FAC1 durcheinander schtteln
rd1	  LDX FAC1+4	      ; Mantisse M4 mit M1 vertauschen
	  LDA FAC1+1
	  STA FAC1+4
	  STX FAC1+1
	  LDA #$00
	  STA FAC1sign	      ; positives Vorzeichen erzwingen
	  LDA FAC1exp
	  STA extrafac	      ; Exponent als Rundungsstelle verwenden
	  LDA #$80
	  STA FAC1exp	      ; $80 als neuer Exponent, damit Ergebnis <1
	  JSR signif	      ; FAC1 linksbndig machen
	  LDX #rndval # 256
	  LDY #rndval / 256
rd2	  JMP movmf	      ; neue Zufallszahl dort eintragen

; FAC1 := COS(FAC1)
cos	  LDA #pihalf # 256
	  LDY #pihalf / 256
	  JSR fadd	      ; cos(x) = sin(x+pi/2)

; FAC1 := SIN(FAC1)
sin	  JSR movaf	      ; FAC1 gerundet nach FAC2
	  LDA #pidoub # 256   ; Zeiger auf Konstante 2*pi
	  LDY #pidoub / 256
	  LDX FAC2sign	      ; Vorzeichen von FAC2 holen
	  JSR div	      ; FAC1 = FAC2 / (2*pi), d.h. Periode normieren
	  JSR movaf	      ; gerundet nach FAC2 bertragen
	  JSR int	      ; INT-Routine bestimmt Anzahl voller Perioden
	  LDA #$00
	  STA xorfsgn	      ; Kombi-Vorzeichen lschen
	  JSR fsubt	      ; FAC1 = FAC2 - FAC1, damit innerhalb der 1. Periode
; Argument in Intervall (-pi/2, pi/2) transformieren
	  LDA #quarter # 256  ; Zeifer auf FP-Konstante 0.25
	  LDY #quarter / 256
	  JSR fsub	      ; FAC1 = 0.25 - FAC1
	  LDA FAC1sign
	  PHA		      ; Vorzeichen merken
	  BPL si1	      ; positiv, Argument war im 1. Quadranten
	  JSR faddh	      ; FAC1 = FAC1 + 0.5
	  LDA FAC1sign
	  BMI si2	      ; negativ, Argument war im 4. Quadranten
	  LDA signflg	      ; Vorzeichen-Flag fr TAN-Routine
	  EOR #$FF	      ; negativ, da cos im 2. und 3. Quadranten negativ ist
	  STA signflg
si1	  JSR negop	      ; FAC1 = -FAC1
si2	  LDA #quarter # 256
	  LDY #quarter / 256
	  JSR fadd	      ; FAC1 = FAC1 + 0.25
	  PLA		      ; bit7 = 0 falls Argument im 1. Quadranten
	  BPL si3	      ; Vorzeichen nicht wechseln
	  JSR negop	      ; FAC1 = -FAC1
si3	  LDA #sinser # 256   ; Zeiger auf Tabelle mit Polynomkoeffizienten
	  LDY #sinser / 256
	  JMP oddser	      ; Polynom auswerten, fertig

; FAC1 := TAN(FAC1)
tan	  JSR mov1f	      ; FAC1 nach FAC3 bertragen
	  LDA #$00
	  STA signflg	      ; Vorzeichenflag auf '+' setzen
	  JSR sin	      ; FAC1 = sin(FAC1)
	  LDX #FAC5 # 256
	  LDY #FAC5 / 256
	  JSR rd2	      ; FAC1 gerundet nach FAC5 bertragen
	  LDA #FAC3 # 256
	  LDY #FAC3 / 256
	  JSR movfm	      ; FAC3 nach FAC1 zurckholen
	  LDA #$00
	  STA FAC1sign	      ; Vorzeichen positiv machen
	  LDA signflg	      ; enthlt Vorzeichen der Cosinus-Funktion
	  JSR tan2	      ; FAC1 = cos(FAC1)
	  LDA #FAC5 # 256
	  LDY #FAC5 / 256
	  JMP fdiv	      ; tan x = sin x / cos x

tan2	  PHA		      ; Vorzeichen-Flag retten
	  JMP si1	      ; FAC1 = sin(0.25-FAC1) mit normierten Argumenten
	  
pihalf	  BYT $81,$49,$0F,$DA,$A2	; FP-Konstante pi/2
pidoub	  BYT $83,$49,$0F,$DA,$A2	; FP-Konstante pi*2
quarter   BYT $7F,$00,$00,$00,$00	; FP-Konstante 0.25

; Reihenkoeffizienten fr SIN / COS / TAN
sinser	  BYT $05			; Polynomgrad
	  BYT $84,$E6,$1A,$2D,$1B	; -14.3813907
	  BYT $86,$28,$07,$FB,$F8	;  42.0077971
	  BYT $87,$99,$68,$89,$01	; -76.7041703
	  BYT $87,$23,$35,$DF,$E1	;  81.6052237
	  BYT $86,$A5,$5D,$E7,$28	; -41.3417021
	  BYT $83,$49,$0F,$DA,$A2	; 2 + pi


; ASCII fr 'MICROSOFT", jedoch bits 0, 1, 2 invertiert
	  BYT $A6,$D3,$C1,$C8,$D4,$C8,$D5,$C4,$CE,$CA


; FAC1 :=  ATN(FAC1)
atn	  LDA FAC1sign
	  PHA		      ; Vorzeichen von FAC1 retten
	  BPL atn1	      ; positiv
	  JSR negop	      ; sonst Betrag bilden
atn1	  LDA FAC1exp
	  PHA		      ; Exponent retten
	  CMP #$81
	  BCC atn2	      ; FAC1 < 1
	  LDA #one # 256
	  LDY #one / 256
	  JSR fdiv	      ; sonst Kehrwert bilden
atn2	  LDA #atnser # 256   ; Zeiger auf Tabelle mit Reihenkoeffizienten
	  LDY #atnser / 256
	  JSR oddser	      ; Polynom auswerten
	  PLA		      ; gemerkter Exponent
	  CMP #$81
	  BCC atn3	      ; Argument war <1
	  LDA #pihalf # 256
	  LDY #pihalf / 256
	  JSR fsub	      ; sonst Ergebnis korrigieren: FAC1 = pi/2 - FAC1
atn3	  PLA		      ; gemerktes Vorzeichen
	  BPL rtn15	      ; positiv, fertig
	  JMP negop	      ; sonst FAC1 = -FAC1
rtn15	  RTS

; Reihenkoeffizienten fr ATN
atnser	  BYT $0B			; Polynomgrad = 11
	  BYT $76,$B3,$83,$BD,$D3	; -6.84793912 E-4
	  BYT $79,$1E,$F4,$A6,$F5	;  4.85094216 E-3
	  BYT $7B,$83,$FC,$B0,$10	; -1.61117018 E-2
	  BYT $7C,$0C,$1F,$67,$CA	;  3.42096380 E-2
	  BYT $7C,$DE,$53,$CB,$C1	; -5.42791328 E-2
	  BYT $7D,$14,$64,$70,$4C	;  7.24571965 E-2
	  BYT $7D,$B7,$EA,$51,$7A	; -8.98023954 E-2
	  BYT $7D,$63,$30,$88,$7E	;  1.10932413 E-2
	  BYT $7E,$92,$44,$99,$3A	; -1.42839808 E-1
	  BYT $7E,$4C,$CC,$91,$C7	;  1.99999120 E-1
	  BYT $7F,$AA,$AA,$AA,$13	; -3.33333157 E-1
	  BYT $81,$00,$00,$00,$00	; 1.0


; 'charget' - Routine (wird spter in die ZP verlagert)
; 'txtptr' steht in einer LDA-Anweisung, das Programm modifiziert sich also selbst.
; O: C=0: Zeichen ist Ziffer, Z=1: Zeichen ist EOS/EOL ($00/$3A)
zpstuff   INC txtptrl	      ; nchstes Zeichen
	  BNE zpstuff1
          INC txtptrh
zpstuff1  LDA $EA60	      ; <- hier steht 'txtptr'
          CMP #$3A            ; ist es EOS ':' ?
	  BCS rtn16	      ; ein Zeichen hinter den Ziffern, also keine Ziffer
          CMP #$20            ; ist es Blank ' ' ?
	  BEQ zpstuff	      ; ja, berspringen
          SEC
          SBC #$30            ; ASCII-Offset fr Null
          SEC
	  SBC #$D0	      ; stelle Zeichen wieder her, damit C=1 falls keine Ziffer
rtn16	  RTS

	  BYT $80,$4F,$C7,$52,$58	; RND - Startwert 0.811635157


; Applesoft - Initialisierung (Kaltstart)
coldst	  LDX #$FF
          STX curlinh         ; direct mode setzen
          LDX #$FB
          TXS                 ; CPU-Stackpointer
	  LDA #coldst # 256
	  LDY #coldst / 256
          STA assoft+1
          STY assoft+2        ; setze Vektor $01.02
	  STA gostrout+1
	  STY gostrout+2      ; setze Vektor $04.05
          JSR normal
	  LDA #$4C	      ; OpCode fr JMP vor die Sprungadressen setzen
	  STA assoft	      
	  STA gostrout
	  STA jmpadrs
          STA userjmp
	  LDA #iqerr # 256
	  LDY #iqerr / 256
	  STA userjmp+1       ; User-Vektor auf ILLEGAL QUANTITY ERROR
	  STY userjmp+2
; Kopiere 'charget' - Routine und RND - Startwert in die Zeropage
          LDX #$1C
mvzp	  LDA zpstuff-1,X
          STA charget-1,X
	  STX speedz	      ; beim letzten Durchgang X=1 als Speed eintragen
          DEX
	  BNE mvzp
	  STX trcflg	      ; schalte auf NOTRACE
	  TXA
	  STA fpgen
	  STA auxl	      ; Adresse des obersten Deskriptors im Deskr.-Stack
	  PHA		      ; 0 auf Stack
          LDA #$03
	  STA dsclen	      ; Deskriptorlnge fr Garbage Collection vorgeben
          JSR crdo            ; neue Zeile
          LDA #$01
	  STA $01FD	      ; 1 in Stack eintragen
          STA $01FC
	  LDX #tempst
	  STX temppt	      ; Zeiger auf Anfang des Deskriptoren-Stacks ($55) setzen
	  LDA #$00
	  LDY #$08	      ; RAM-Test ab $0800 starten
          STA linnuml
          STY linnumh
; hchste verfgbare RAM-Adresse suchen
          LDY #$00
fndmemhi  INC linnumh	      ; Zeiger erhhen
	  LDA (linnuml),Y     ; $0900, $0A00, ... holen
          EOR #$FF
	  STA (linnuml),Y     ; und invertiert zurckschreiben
	  CMP (linnuml),Y     ; prfen, ob Inhalt geschrieben wurde
	  BNE memfound	      ; nein, RAM-Ende gefunden
          EOR #$FF
	  STA (linnuml),Y     ; alten Wert wieder eintragen
	  CMP (linnuml),Y     ; und nochmal vergleichen
	  BEQ fndmemhi
memfound  LDY linnuml
          LDA linnumh
          AND #$F0
	  STY memsizel	      ; 'memsize' auf Ende des letzten gefundenen 4k-Blocks setzen
	  STA memsizeh
	  STY fretopl	      ; und als Anfang des Stringbereiches nehmen
	  STA fretoph
          LDX #$00
          LDY #$08
	  STX texttabl	      ; Anfang des Programmtextes auf $0800
          STY texttabh
          LDY #$00
	  STY lock	      ; kein Autostart
          TYA
	  STA (texttabl),Y    ; EOL an Programmtextanfang schreiben
	  INC texttabl	      ; und Programm-Anfangszeiger auf $0801 erhhen
	  BNE memfnd1
          INC texttabh
memfnd1   LDA texttabl
          LDY texttabh
	  JSR reason	      ; falls 'texttab' ber 'memsize' -> OUT OF MEMORY ERROR
	  JSR scrtch	      ; NEW, CLEAR, Stack initialisieren
	  LDA #strout # 256
	  LDY #strout / 256
	  STA gostrout+1      ; Zeiger auf String-Druckroutine setzen
	  STY gostrout+2      
	  LDA #restart # 256
	  LDY #restart / 256
          STA assoft+1        ; Warmstartvektor setzen
          STY assoft+2
	  JMP (assoft+1)      ; Warmstart ausfhren

; CALL - Function Handler
call	  JSR frmnum	      ; interpretiere Sprungadresse
	  JSR getadr	      ; wandle in Integer um
          JMP (linnuml)       ; und ab gehts

; IN# - Function Handler
innu	  JSR getbyt	      ; Byte aus Programmtext holen
          TXA
          JMP inport

; PR# - Function Handler
prnu	  JSR getbyt
          TXA
          JMP outport

; Interpretiere LoRes - Koordinate
; O: 1.Parameter in first, 2. Parameter in h2 = v2 = X
plotfns   JSR getbyt          ; interpretiere X - Byte
	  CPX #$30
	  BCS goerr	      ; =>48 -> ILLEGAL QUANTITY ERROR
          STX first
          LDA #$2C
          JSR synchr          ; Check auf Komma
          JSR getbyt          ; interpretiere Y - Byte
          CPX #$30
	  BCS goerr	      ; =>48 -> ILLEGAL QUANTITY ERROR
          STX h2
          STX v2
          RTS

goerr	  JMP iqerr	      ; ILLEGAL QUANTITY ERROR ausgeben

; interpretiere aa,bb AT cc - Ausdruck (Parameter fr HLIN/VLIN)
; O: Parameter in first, h0 =, v0, X. Dabei first < h0, v0
lincoor   JSR plotfns	      ; hole 2. Parameter aus Programmtext
	  CPX first	      ; Parameter vergleichen
	  BCS at_	      ; 'first' ist kleiner, ok
          LDA first
	  STA h2	      ; sonst vertauschen
          STA v2
          STX first
at_	  LDA #$C5
	  JSR synchr	      ; Token fr 'AT' mu folgen, sonst SYNTAX ERROR
	  JSR getbyt	      ; 3. Parameter holen
          CPX #$30
	  BCS goerr	      ; =>48 -> ILLEGAL QUANTITY ERROR
          RTS

; PLOT - Function Handler
lplot     JSR plotfns         ; hole Koordinaten
	  TXA		      ; Y-Wert ist schon geprft
	  LDY first
          CPY #$28
	  BCS goerr	      ; X=>40 --> Fehler
          JMP plot

; HLIN - Function Handler
hlin	  JSR lincoor	      ; Parameter aus Programmtext holen
	  TXA		      ; Y-Koordinate ist schon geprft
          LDY h2
	  CPY #$28	      ; die grere X-Koordinate mu kleiner 40 sein
	  BCS goerr	      ; sonst Fehler
          LDY first
          JMP hline

; VLIN - Function Handler
vlin	  JSR lincoor
          TXA
          TAY
	  CPY #$28	      ; X-Koordinate mu kleiner als 20 sein
	  BCS goerr
          LDA first
          JMP vline

; COLOR= - Function Handler
colset    JSR getbyt
          TXA
          JMP setcol

; VTAB - Function Handler
vtab      JSR getbyt
setvtab   DEX		      ; oberste Zeile hat Nummer 0
          TXA
	  CMP #$18	      ; auerhalb des Bildschirms?
	  BCS goerr	      ; -> Fehler
          JMP tabv

; SPEED= - Function Handler
speed     JSR getbyt          ; Wert holen
	  TXA		      ; 0 = langsam, 255 = schnell
          EOR #$FF
          TAX
	  INX		      ; 2er-Komplement bilden
	  STX speedz	      ; und in SPEED-Flag eintragen
          RTS

; TRACE/NOTRACE - Function Handler
trace     SEC
	  BYT $90	      ; 'BCC $F288' nie ausgefhrt
notrace   CLC                 ; (nicht bei TRACE)
	  ROR trcflg	      ; Carry ins Trace-Flag
          RTS

; NORMAL/INVERSE/FLASH - Function Handler
normal	  LDA #$FF	      ; NORMAL-Maske
	  BNE nrm	      ; immer springen
inverse   LDA #$3F	      ; INVERSE-Maske
nrm	  LDX #$00
si	  STA invflg
          STX ormask
          RTS
flash     LDA #$7F
          LDX #$40
	  BNE si

; HIMEM: - Function Handler
himem     JSR frmnum          ; Ausdruck berechnen
          JSR getadr          ; in Adresse umformen
          LDA linnuml
	  CMP strendl	      ; mit Feldvariablen-Ende +1 vergleichen
          LDA linnumh
	  SBC strendh
	  BCS sethi	      ; liegt nicht darunter, ok
jmm	  JMP memerr	      ; sonst OUT OF MEMORY ERROR
sethi	  LDA linnuml
          STA memsizel
          STA fretopl
          LDA linnumh
          STA memsizeh        ; 'memsize' und 'fretop'
          STA fretoph         ;   auf HiMem setzen
          RTS

; LOMEM: - Function Handler
; Duch LOMEM: lt sich der Beginn des Bereiches der einfachen Variablen
; zwischen Programmtext und 'memsize' einstellen. Normalerweise kommen die
; Variablen direkt hinter dem Programmtext
lomem     JSR frmnum          ; Ausdruck berechnen
          JSR getadr          ; in Adresse umwandeln
          LDA linnuml
          CMP memsizel
          LDA linnumh
	  SBC memsizeh	      ; testen ob kleiner als HIMEM:
	  BCS jmm	      ; nein -> OUT OF MEMORY ERROR
          LDA linnuml
          CMP vartabl
          LDA linnumh
	  SBC vartabh	      ; testen ob unter altem LOMEM:-Wert
	  BCC jmm	      ; kleiner -> OUT OF MEMORY ERROR
          LDA linnuml
          STA vartabl
          LDA linnumh
	  STA vartabh	      ; neuen Wert eintragen
	  JMP clearc	      ; Variablen lschen

; ONERR - Function Handler
onerr	  LDA #$AB
	  JSR synchr	      ; GOTO mu folgen
          LDA txtptrl
          STA onerrtpl
          LDA txtptrh
          STA onerrtph        ; 'onerrtp' := 'txtptr'
          SEC
	  ROR errflg	      ; ONERR-Flag setzen
          LDA curlinl
	  STA onerrcll	      ; aktuelle Zeilennummer als Zeilennummer des ONERR-Statements
          LDA curlinh
          STA onerrclh
	  JSR remn	      ; suche nchste Programmzeile
	  JMP addon	      ; weiter im Programm

; ONERR - Fehlerbehandlungsroutine
; I: X enthlt Fehlercode
handlerr  STX errnum	      ; Fehlercode abspeichern
          LDX remstk
	  STX errstk	      ; Stackpointer retten
          LDA curlinl
          STA errlinl
          LDA curlinh
	  STA errlinh	      ; aktuelle Zeilennummer fr RESUME sichern
          LDA otxtptrl
          STA errposl
          LDA otxtptrh
	  STA errposh	      ; Zeiger auf Befehl, in dem der Fehler auftrat
          LDA onerrtpl
          STA txtptrl
          LDA onerrtph
	  STA txtptrh	      ; Zeiger auf ONERR-Statement in txtptr bertragen
          LDA onerrcll
          STA curlinl
          LDA onerrclh
	  STA curlinh	      ; Zeilennummer des ONERR-Statements als aktuelle Zeilennummer
	  JSR chargot	      ; Zeichen holen
	  JSR goto	      ; und GOTO ausfhren
	  JMP newstt	      ; weiter im Programm mit Fehlerbehandlung

; RESUME - Function Handler
resume	  LDA errlinl
	  STA curlinl
	  LDA errlinh	      ; Zeilennummer, in der der Fehler auftrat
	  STA curlinh	      ; als aktuelle Zeilennummer nehmen
	  LDA errposl
	  STA txtptrl
	  LDA errposh
	  STA txtptrh	      ; 'txtptr' auf den fehlerhaften Befehl zurckstellen
	  LDX errstk
	  TXS		      ; CPU-Stackpointer wiederherstellen
	  JMP newstt	      ; weiter im Programm beim unterbrochenen Befehl

jsyn	  JMP synerr	      ; SYNTAX ERROR ausgeben

; DEL - Function Handler
del	  BCS jsyn	      ; erstes Zeichen hinter DEL keine Ziffer -> Fehler
	  LDX prgendl	      ; Programmtext-Ende +1
	  STX vartabl	      ; als Anfang der einfachen Variablen bernehmen
	  LDX prgendh
	  STX vartabh
	  JSR linget	      ; Zeilennummer aus Programmtext holen
	  JSR fndlin	      ; angegebene Zeile suchen
	  LDA lowtrl	      ; Zeiger auf angegebene Zeile retten
	  STA ptrgul
	  LDA lowtrh
	  STA ptrguh
	  LDA #$2C
	  JSR synchr	      ; Komma mu folgen, sonst Fehler
	  JSR linget	      ; 2. Zeilennummer holen
	  INC linnuml	      ; erhhen, damit angegebene Zeile noch gelscht wird
	  BNE del1
	  INC linnumh
del1	  JSR fndlin	      ; Zeile hinter der angegebenen Zeile suchen
	  LDA lowtrl	      ; Zeiger auf diese Zeile
	  CMP ptrgul	      ; mit Zeiger auf erste zu lschende Zeile vergleichen
	  LDA lowtrh
	  SBC ptrguh
	  BCS movdwn	      ; liegt hinter dieser, angegebenen Bereich lschen
	  RTS
; angegebenen Bereich lschen
movdwn	  LDY #$00
movit	  LDA (lowtrl),Y      ; ein Zeichen von hinten holen
	  STA (ptrgul),Y      ; und nach vorne bertragen
	  INC lowtrl	      ; Zeiger auf Quellbereich erhhen
	  BNE mov1
	  INC lowtrh
mov1	  INC ptrgul	      ; Zeiger auf Zielbereich erhhen
	  BNE mov2
	  INC ptrguh
mov2	  LDA vartabl	      ; ursprngliches Programmtext-Ende +1
	  CMP lowtrl	      ; mit Zeiger auf Quellbereich vergleichen
	  LDA vartabh
	  SBC lowtrh
	  BCS movit	      ; Ende noch nicht erreicht, weiter verschieben
	  LDX ptrguh	      ; neues Programmtext-Ende +2
	  LDY ptrgul
	  BNE ndx	      ; um 1 verringern
	  DEX
ndx	  DEY
	  STX vartabh	      ; und eintragen
	  STY vartabl
	  JMP linkset	      ; CLEAR, Linkadressen berechnen, Warmstart

; GR - Function Handler
gr        LDA lores
          LDA mixset
          JMP setgr

; TEXT - Function Handler
text      LDA lowscr
          JMP settxt

; STORE -Function Handler
store	  JSR getarypt	      ; Array lokalisieren, Monitor-Register setzen
	  LDY #$03	      ; Zeiger ins Array ('lowtr' zeigt auf Variablenkopf)
	  LDA (lowtrl),Y      ; Feldlnge holen
	  TAX		      ; MSB
          DEY
	  LDA (lowtrl),Y      ; LSB
	  SBC #$01	      ; abzglich 1
	  BCS sli
          DEX
sli	  STA linnuml
          STX linnumh
          JSR twrite          ; Feldlnge schreiben
	  JSR tapepnt
          JMP twrite          ; Feld schreiben

; RECALL - Function Handler
recall	  JSR getarypt	      ; Array lokalisieren, Monitor-Register setzen
          JSR tread           ; Feldlnge lesen
          LDY #$02
	  LDA (lowtrl),Y      ; Lnge der angegebenen Feldvariablen
	  CMP linnuml	      ; mit der auf Band gefundenen vergleichen
          INY
          LDA (lowtrl),Y
	  SBC linnumh
	  BCS mok	      ; dimensionierte Feldlnge >= Datenlnge auf Band
	  JMP memerr	      ; sonst OUT OF MEMORY
mok	  JSR tapepnt
	  JMP tread	      ; Feld laden


; ROUTINEN FR HOCHAUFLSENDE GRAFIK

; HGR2 - Function Handler
hgr2	  BIT hiscr
          BIT mixclr
          LDA #$40            ; Seite 2 ab $4000
	  BNE sethpg	      ; weiter bei HGR

; HGR - Function Handler
hgr	  LDA #$20	      ; Seite 1 ab $2000
          BIT lowscr
          BIT mixset
sethpg	  STA hpag	      ; Seitenzeiger setzen
          LDA hires
          LDA txtclr
hclr	  LDA #$00
	  STA hcolor1	      ; Farbe schwarz whlen
; aktuelle HiRes-Page einfrben
bkgnd     LDA hpag
	  STA shapelh	      ; Page-Anfang MSB
          LDY #$00
	  STY shapell	      ; LSB
bkgnd1	  LDA hcolor1
	  STA (shapell),Y     ; Farbmaske eintragen
	  JSR cshft2	      ; Maske invertieren falls alternierende Bitfolge
          INY
	  BNE bkgnd1	      ; nchste Speicherstelle
          INC shapelh
          LDA shapelh
	  AND #$1F	      ; ergibt 0 falls Page-Ende erreicht
	  BNE bkgnd1
          RTS

; Berechne RAM-Adresse aus HiRes-Koordinaten, positioniere HiRes-Cursor 'hcurs'
; I: X-Koordinate in X,Y; Y-Koordinate im Akku
; O: RAM-Adresse des Zeilenanfangs in 'gbas'
;    Position in der  Zeile in 'hndx   ' = Y; Bitmaske in 'color'
hposn	  STA hcursy	      ; Y-Koordinate merken
	  STX hcursxl	      ; X-Koordinate merken
	  STY hcursxh	      ; 			  Block   Textzeile  Grafikzeile
	  PHA		      ; Bezeichnung von bit7..0:  b1,b0,  t2,t1,t0,  g2,g1,g0
	  AND #$C0	      ; bit6+7 herausholen
	  STA gbasl	      ; ergibt Blocknummer x64 (Block = Page-Drittel)
          LSR
	  LSR		      ; ergibt Blocknummer x16
	  ORA gbasl	      ; plus Blocknr. x64 ergibt Blocknr. x80
	  STA gbasl	      ; eintragen
          PLA
	  STA gbash	      ; Y-Koordinate eintragen
          ASL
	  ASL		      ; damit Textzeile linksbndig (t2 in bit7)
	  ASL
	  ROL gbash
          ASL
	  ROL gbash	      ; t2, t1 in bit0,1 von 'gbash'
          ASL
	  ROR gbasl	      ; t0 in bit7 ergibt  'gbasl' = t0 (Blockx40)   0  0  0
	  LDA gbash	      ; 		   'gbash' = t2 t1 t0 g2 g1 g0 t2 t1
	  AND #$1F	      ; lsche bit5..7
	  ORA hpag	      ; und setze die Seitennummer dafr ein
	  STA gbash	      ; 'gbash' enthlt 0 Page g2 g1 g0 t2 t1
	  TXA		      ; X-Koordinate LSB
	  CPY #$00	      ; MSB mit 0 vergleichen
	  BEQ hposn2	      ; X-Koordinate < 256 ->
	  LDY #$23	      ; sonst Position mit 35 vorbesetzen, d.h. 36. Spalte
	  ADC #$04	      ; LSB korrigieren, da 36x7=252 = 256-4
hposn1	  INY
hposn2	  SBC #$07	      ; Division durch 7, Y als Zhler
	  BCS hposn1
	  STY hndx	      ; Spalte (d.h.Byteposition) eintragen
	  TAX		      ; = Bitposition im letzten Byte -7  (256-7=249)
	  LDA msktbl-249,X    ; 'msktbl' + Bitposition ergibt Bitmaske
	  STA color	      ; eintragen
	  TYA		      ; Spalte
	  LSR		      ; Carry gesetzt falls ungerade
	  LDA hcolorz
	  STA hcolor1	      ; Farbmaske bertragen
	  BCS cshft2	      ; bei ungerader Spalte Maske invertieren falls alternierend
          RTS

; Setze Punkt auf 'hpag' an der Stelle 'hcurs'
; I: Koordinaten in A, X, Y
hplot0	  JSR hposn	      ; Cursor positionieren
          LDA hcolor1
	  EOR (gbasl),Y       ; Farbmaske mit Speicherstelle verknpfen
	  AND color	      ; Bitmaske holt Bit heraus
	  EOR (gbasl),Y       ; damit Bit aus Farbmaske kopiert
	  STA (gbasl),Y       ;   in Speicherzelle eintragen
          RTS

; RAM-Adresse fr linken oder rechten Nachbarpunkt
lftrt	  BPL right	      ; bit7=0, Adresse fr rechten Nachbarpunkt bestimmen
; linker Nachbarpunkt
left	  LDA color	      ; Bitmaske, bit7 = 1
	  LSR		      ; nach links schieben, LSR wegen gespiegelter Darstellung
	  BCS left1	      ; war Randbit, neuer Punkt im nchsten Byte
	  EOR #$C0	      ; bit7 setzen, bit6 lschen
lr1	  STA color	      ; und neue Bitmaske eintragen
          RTS
left1	  DEY		      ; Spaltenindex auf linke Nachbarspalte
	  BPL left2	      ; linker Bildschirmrand nicht erreicht, ok
	  LDY #$27	      ; sonst weiter in Spalte 39 (= rechter Bildschirmrand)
left2	  LDA #$C0	      ; Bitmaske fr bit6, bit7 = 1 wie immer
newndx	  STA color	      ; neue Bitmaske eintragen
	  STY hndx	      ; neuen Spaltenindex eintragen
; Farbmaske invertieren, falls alternierende Bitfolge
cshift	  LDA hcolor1
cshft2	  ASL		      ; Farbmaske verschieben
	  CMP #$C0	      ; bit5, 6 prfen
	  BPL rts1	      ; bit5 = bit6, alterniert nicht -> nicht invertieren
	  LDA hcolor1
	  EOR #$7F	      ; sonst Farbmaske invertieren
	  STA hcolor1	      ; und eintragen
rts1	  RTS
; rechter Nachbarpunkt
right	  LDA color	      ; Bitmaske nach rechts schieben
	  ASL		      ;  (ASL wegen gespiegelter Darstellung)
	  EOR #$80	      ; bit7 (war vorher bit6) invertieren
	  BMI lr1	      ; bit6 war 0, neuer Punkt im selben Byte, fertig
	  LDA #$81	      ; Bitmaske fr bit0, bit7 = 1 wie immer
	  INY		      ; Spaltenindex auf rechte Nachbarspalte
	  CPY #$28	      ; rechter Bildschirmrand erreicht?
	  BCC newndx	      ; nein, ok
	  LDY #$00	      ; sonst neuer Spaltenindex 0 (linker Rand)
	  BCS newndx	      ; Routine abschlieen

; Punkt invertieren fr XDRAW
lrudx1	  CLC
lrudx2	  LDA dxh	      ; bit0, 1, 2 = aktuelle Shape-Anweisung
	  AND #$04	      ; bit2 = Plot-Flag
	  BEQ lrud4	      ; Punkt nicht verndern, neuen Punkt bestimmen
          LDA #$7F
	  AND color	      ; Bitmaske, bit7 gelscht
	  AND (gbasl),Y       ; Originalbit holen
	  BNE lrud3	      ; wenn's eins war, wird's nullgesetzt
	  INC colcount		; sonst collision counter erhhen
          LDA #$7F
	  AND color	      ; Bitmaske um Punkt zu setzen
	  BPL lrud3	      ; Byte eintragen und neuen Punkt bestimmen
; Punkt setzen fr DRAW
lrud1	  CLC
lrud2	  LDA dxh	      ; bit0, 1, 2 = aktuelle Shape-Anweisung
	  AND #$04	      ; bit2 = Plot-Flag
	  BEQ lrud4	      ; Punkt nicht setzen, neuen Punkt bestimmen
	  LDA (gbasl),Y       ; Originalbit
	  EOR hcolor1	      ;  mit Farbmaske verknpfen
	  AND color	      ; bit herausholen
	  BNE lrud3	      ; Punkt ist noch nicht gesetzt
	  INC colcount		; sonst collision counter erhhen
lrud3	  EOR (gbasl),Y       ; neues bit einfgen
	  STA (gbasl),Y       ; und Byte eintragen
; neuen Punkt bestimmen nach Shape-Anweisung
lrud4	  LDA dxh	      ; bit0, 1 enthalten Zugrichtung
	  ADC qdrnt	      ; + Quadrant entsprechend ROT-Wert und Carry-Flag
	  AND #$03	      ; ergibt tatschliche Zugrichtung
	  CMP #$02	      ; bit1 ins Carry
	  ROR		      ; Carry -> bit7, bit0 -> Carry
	  BCS lftrt	      ; bit0 war 1, d.h. Zugrichtung links oder rechts

; Nachbarpunkt ber oder unter dem alten Punkt bestimmen
updown	  BMI down	      ; bit7 = 1, d.h. RAM-Adresse fr Punkt unterhalb bestimmen
; Punkt oberhalb bestimmen
up	  CLC
	  LDA gbash	      ; Adresse des Zeilenanfangs, MSB
	  BIT eq1c	      ; enthlt $!C, also Nummer der Grafikzeile herausholen
	  BNE up4	      ; nicht oberste Grafikzeile innerhalb der Textzeile, ok
	  ASL gbasl	      ; sonst t0 -> Carry
	  BCS up2	      ; ungerade Textzeile, zu MSB der Adresse $1C addieren
	  BIT lrud4+5	      ; enthlt $03, d.h. Nummer der geraden Textzeile holen
	  BEQ up1	      ; oberste Textzeile im Block, weiter im Block oberhalb
	  ADC #$1F	      ; Textzeile 2, 4 oder 6: zum MSB der Adresse $1B addieren
          SEC
	  BCS up3	      ; Addition vervollstndigen
up1	  ADC #$23	      ; zu $20/$40 addieren ergibt $43/$63
          PHA
; neuer Block
	  LDA gbasl	      ; $00	  / $50       / $A0
	  ADC #$B0	      ; $B0, C=0  / $00, C=1  / $50, C=1  fr Block 0/1/2
	  BCS up5
          ADC #$F0
up5	  STA gbasl	      ; $A0, C=1  / $00, C=1  / $50, C=1  (spter $50/$00/$28)
	  PLA		      ; $43/$63 minus 4 ergibt $3F/$5F, d.h. unterste Zeile
	  BCS up3	      ; Subtraktion durchfhren, Routine abschlieen
up2	  ADC #$1F	      ; C=1, also $20 addieren
up3	  ROR gbasl	      ; ASL rckgngig machen, Carry -> bit7
up4	  ADC #$FC	      ; minus 4
updwn1	  STA gbash	      ; MSB eintragen
          RTS

; Punkt unterhalb bestimmen
          CLC
down	  LDA gbash	      ; Adresse des Zeilenanfangs, MSB
	  ADC #$04	      ; plus 4 fr Grafikzeile darunter
	  BIT eq1c	      ; enthlt $1C, d.h. Nummer der Grafikzeile herausholen
	  BNE updwn1	      ; war nicht unterste Grafikzeile der Textzeile, ok
	  ASL gbasl	      ; sonst t0 -> Carry
	  BCC down1	      ; gerade Textzeile, $20 abziehen und Routine abschlieen
	  ADC #$E0	      ; minus $1F ergibt $21/$22/$23/$24 bei Textzeile 1/3/5/7
          CLC
	  BIT down+3	      ; enthlt $04, d.h. bit2 herausholen
	  BEQ down2	      ; nicht unterste Textzeile im Block, ok
; neuer Block
	  LDA gbasl	      ; $00	  / $50       / $A0	  bei Block 0/1/2
	  ADC #$50	      ; $50, C=0  / $A0, C=0  / $F0, C=0
	  EOR #$F0	      ; $A0	  / $50       / $00
	  BEQ down3
          EOR #$F0
down3	  STA gbasl	      ; $50	  / $A0       / $00
	  LDA hpag	      ; $20 bzw $40 je nach Page
	  BCC down2
down1	  ADC #$E0	      ; $20 subtrahieren
down2	  ROR gbasl	      ; ASL rckgngig machen, Carry -> bit7
	  BCC updwn1	      ; Routine abschlieen

; alte Koordinaten lschen
hlinrl	  PHA
          LDA #$00
          STA hcursxl
          STA hcursxh
          STA hcursy
          PLA

; Linie zeichnen
; Schrge Linien mssen durch eine treppenartige Figur angenhert werden. Dazu
; werden zunchst der horizontale und vertikale Abstand der Endpunkte bestimmt.
; Das Verhltnis dieser beiden Strecken legt die Steigung der Geraden fest. Die
; Summe dieser beiden Strecken ergibt die Anzahl der zu zeichnenden Punkte.
; Nun wird ein Saldo-Register eingerichtet. Jedesmal, wenn ein Punkt in horizontaler
; Richtung gesetzt wurde, wird die Y-Differenz der Endpunkte vom Saldo subtrahiert;
; jedesmal, wenn ein Punkt in vertikaler Richtung gesetzt wurde, wird die
; X-Differenz der Endpunkte zum Saldo addiert. Bei jedem Vorzeichenwechsel des
; Saldoregisters wechselt die Zugrichtung.
; Es wird hier nur mit den Betrgen der Endpunktdifferenzen gearbeitet. Die beiden
; Vorzeichen werden in ein Richtungs-Flag integriert, welches die Zugrichtung
; festlegt. Nachdem die zuvor bestimmte Gesamtzahl von Zgen erfolgt ist, ist
; die Routine beendet.
; I: alte Koordinaten 'hcursx','hcursy', neue (A,X / Y)
;
; Koordinatendifferenzen bestimmen
hglin	  PHA		      ; neue Koordinate, X-LSB retten
          SEC
	  SBC hcursxl	      ; minus alte X-Koordinate, LSB
	  PHA		      ; X-Differenz, LSB retten
          TXA                 ; X hat X-MSB
	  SBC hcursxh	      ; minus alte X-Koordinate MSB
	  STA qdrnt	      ; X-Differenz MSB retten (=$FF/$00/$01)
	  BCS hlin2	      ; neue X-Koordinate >= alte X-Koordinate
	  PLA		      ; sonst Betrag der X-Differenz bilden
	  EOR #$FF
          ADC #$01
	  PHA
          LDA #$00
	  SBC qdrnt
hlin2	  STA dxh	      ; MSB nach 'dxh'
	  STA eh	      ; und ins Saldo-Register, MSB
          PLA
	  STA dxl	      ; LSB nach 'dxl'
	  STA el	      ; und ins Saldo-Register, LSB
          PLA
	  STA hcursxl	      ; neue X-Koordinate
          STX hcursxh
	  TYA		      ; Y hat neue Y-Koordinate
          CLC
	  SBC hcursy	      ; minus alte Y-Koordinate
	  BCC hlin3	      ; neue Y-Koordinate =< alte Y-Koordinate
	  EOR #$FF	      ; sonst negieren
          ADC #$FE
hlin3	  STA dy	      ; -1 - Betrag der Y-Differenz
	  STY hcursy	      ; neue Y-Koordinate bernehmen
; Richtungsflag und Schrittzhler setzen
	  ROR qdrnt	      ; Carry -> bit7, im Richtungsflag also: bit7=1 nach oben
	  SEC		      ; 				      bit7=0 nach unten
	  SBC dxl	      ; -dxl = -dy - dxl -1		      bit6=1 nach links
	  TAX		      ; als Schrittzhler LSB		      bit6=0 nach rechts
          LDA #$FF
	  SBC dxh	      ; ergibt -dxh -1
	  STA counth	      ; als Schrittzhler MSB
	  LDY hndx	      ; Spaltenindex nach Y
	  BCS movex2	      ; und nun die Linie zeichnen

; Linie durch Treppe annhern
;
; Bewegung in X-Richtung
movex	  ASL		      ; bit6 -> bit7
	  JSR lftrt	      ; Adresse fr neuen Punkt bestimmen
          SEC
movex2	  LDA el	      
	  ADC dy
	  STA el	      ; neuer Saldo = Saldo - dy -1 +1 (+1 wegen C=1)
	  LDA eh
          SBC #$00
hcount	  STA eh
; Punkt auf Bildschirm bringen
	  LDA (gbasl),Y       ; Speicherzelle holen
	  EOR hcolor1	      ; mit Farbmaske verknpfen
	  AND color	      ; entscheidendes bit herausholen
	  EOR (gbasl),Y       ; und einfgen
          STA (gbasl),Y
	  INX		      ; Schrittzhler dekrementieren (negativ!)
	  BNE hlin4
          INC counth
	  BEQ rts2	      ; Endpunkt erreicht, fertig
hlin4	  LDA qdrnt	      ; Richtungsflag
	  BCS movex	      ; Saldo positiv, deswegen Bewegung in X-Richtung
; Bewegung in Y-Richtung
	  JSR updown	      ; Adresse fr neuen Punkt bestimmen
          CLC
	  LDA el
	  ADC dxl
	  STA el	      ; neuer Saldo = Saldo + Betrag der X-Differenz
	  LDA eh
	  ADC dxh
	  BVC hcount	      ; MSB eintragen, Punkt auf Bildschirm bringen


msktbl	  BYT $81,$82,$84,$88,$90,$A0,$C0	  ; Bitmasken

eq1c	  BYT $1C				  ; Hilfsbyte fr BIT

; Tabelle der Cosinuswerte fr ROT
costbl	  BYT $FF,$FE,$FA,$F4,$EC,$E1,$D4,$C5,$B4 ; 0..pi/4
	  BYT $A1,$8D,$78,$61,$49,$31,$18	  ;  ..pi/2
	  BYT $FF				  ; pi/2

; XY-Koordinaten aus RAM-Adresse berechnen
; I: 'gbas' Zeilenadresse, 'hndx' Spaltenindex, 'color' Bitmaske
; O: 'hcursx' X-Koordinate, 'hcursy' Y-Koordinate
hfind	  LDA gbasl	      ; enthlt als einzelne bits  t0  (Blockx40)  0  0  0
	  ASL		      ; t0 -> Carry		bit 7  6  5  4	3  2  1  0
	  LDA gbash	      ; 			    0  Page g3 g1 g0 t2 t1
	  AND #$03	      ; t2 und t1 herausholen
	  ROL		      ; t0 hinten anfgen
	  ORA gbasl	      ; an Blockbits hinten anfgen
	  ASL		      ; um 3 bit hochschieben
          ASL
	  ASL		      ; ergibt			    b1 b0 t2 t1 t0  0  0  0
	  STA hcursy	      ; als Y-Koordinate
          LDA gbash
	  LSR		      ; um 2 bit nach rechts schieben
          LSR
	  AND #$07	      ; bit0, 1, 2 herausholen (=g2, g1, g0)
	  ORA hcursy	      ; in Y-Koordinate einfgen
          STA hcursy
	  LDA hndx	      ; Spaltenindex
	  ASL		      ; x2
	  ADC hndx	      ; plus einmal ergibt dreifachen Wert
	  ASL		      ; x2
	  TAX		      ; ergibt sechsfachen Wert
          DEX
	  LDA color	      ; Bitmaske
	  AND #$7F	      ; bit7 lschen
hfind1	  INX		      ; X zhlt mit
	  LSR		      ; verschieben
	  BNE hfind1	      ; gesetztes bit noch im Byte, weiterschieben
	  STA hcursxh	      ; X-Koordinate, MSB zunchst nullsetzen
	  TXA		      ; Bitspalte + 6x Spaltenindex
          CLC
	  ADC hndx	      ; plus Spaltenindex ergibt X-Koordinate, LSB
	  BCC hfind2
	  INC hcursxh	      ; MSB auf 1 erhhen, falls X-Koordinate > 255
hfind2	  STA hcursxl
rts2	  RTS

; DRAW - Function Handler
; Die Routinen von DRAW und XDRAW konstruieren schrge Linien hnlich wie bei
; HPLOT beschrieben. Aus einer Tabelle werden der Sinus und der Cosinus des
; Drehwinkels gegenber der letzten Koordinatenachse bestimmt. Durch Fhrung
; von zwei Saldoregistern wird nun, je nach Verhltnis des Sinuswertes zum
; Cosinuswert, die Hufigkeit von Zgen in Richtung der letzten Koordinatenachse
; und von solchen in Richtung der nchsten Koordinatenachse im Uhrzeigersinn
; festgelegt. Je grer der Sinuswert, desto hufiger geht der Zug in Richtung
; der nchsten Achse, und desto grer wird somit der Winkel innerhalb dieses
; Quadranten.
; Der Quadrant selber wird festgelegt durch die Richtungsangabe der Shape-Anweisung
; und die Anzahl voller rechter Winkel im ROT-Wert.
; I: X,Y Zeiger auf Shape-Definition, Akku = ROT-Wert
draw0	  STX shapell
	  STY shapelh
; Haupteinsprung
draw1	  TAX
	  LSR		      ; bit4..7 -> bit0..3
          LSR
          LSR
          LSR
	  STA qdrnt	      ; als Quadrant (Anzahl rechter Winkel im Uhrzeigersinn)
          TXA
	  AND #$0F	      ; bit0..3 herausholen
	  TAX		      ; ergibt Winkel innerhalb des Quadranten
	  LDY costbl,X	      ; zugehrigen Cosinus-Wert aus Tabelle holen
	  STY dxl
	  EOR #$0F	      ; das ergibt 15 - Tabellenindex
          TAX
	  LDY costbl+1,X      ; Tabellenwert von 16-Index
	  INY		      ; ergibt Sinuswert
	  STY dy
	  LDY hndx	      ; Spaltenindex holen
          LDX #$00
	  STX colcount	      ; collision counter lschen
	  LDA (shapell,X)     ; hole 1. Byte der Shape-Definition
; Shape-Anweisung durchfhren
draw2	  STA dxh	      ; bit0, 1, 2 enthlt Shape-Anweisung
          LDX #$80
	  STX el	      ; Saldo-Register fr Cosinus
	  STX eh	      ; und fr Sinus initialisieren
	  LDX scalez	      ; X als Zhler fr SCALE-Wert
; Verhltnis der Sinus/Cosinus-Werte bestimmt Linienrichtung
draw3	  LDA el	      ; Cosinus-Saldo
          SEC
	  ADC dxl	      ; um Cosinus-Wert erhhen
	  STA el
	  BCC draw4	      ; kein berlauf
	  JSR lrud1	      ; Punkt setzen, nchsten Punkt in Richtung der
	  CLC		      ; Shape-Anweisung plus Quadrant bestimmen (=Nullrichtung)
draw4	  LDA eh	      ; Sinus-Saldo
	  ADC dy	      ; um Sinus-Wert erhhen
	  STA eh
	  BCC draw5	      ; kein berlauf
	  JSR lrud2	      ; Punkt setzen, nchsten in Nullrichtung + 90 bestimmen
draw5	  DEX		      ; Zhler dekrementieren
	  BNE draw3	      ; weiter mit dieser Shape-Anweisung
	  LDA dxh	      ; Byte mit Shape-Anweisung
	  LSR		      ; nchste Anweisung in bit3, 4, 5 -> bit0, 1, 2
          LSR
          LSR
	  BNE draw2	      ; Byte nicht 0, d.h. gltige Shape-Anweisung in bit0, 1, 2
	  INC shapell	      ; sonst Zeiger auf Shape-Definition erhhen
	  BNE draw6
          INC shapelh
draw6	  LDA (shapell,X)     ; und neues Byte mit Anweisungen holen
	  BNE draw2	      ; ungleich Null, also Ende noch nicht erreicht
	  RTS		      ; sonst fertig

; XDRAW - Function Handler
; I: X, Y Zeiger auf Shape-Definition, Akku = ROT-Wert
xdraw0	  STX shapell
	  STY shapelh
; Haupteinsprung
xdraw1	  TAX		      ; nur JSR's anders, sonst wie bei DRAW
          LSR
          LSR
          LSR
          LSR
	  STA qdrnt
          TXA
          AND #$0F
          TAX
	  LDY costbl,X
	  STY dxl
          EOR #$0F
          TAX
	  LDY costbl+1,X
          INY
	  STY dy
	  LDY hndx
          LDX #$00
	  STX colcount
          LDA (shapell,X)
; Shape-Anweisung durchfhren
xdraw2	  STA dxh
          LDX #$80
	  STX el
	  STX eh
	  LDX scalez
; Verhltnis der Sin/Cos - Werte bestimmt Linienrichtung
xdraw3	  LDA el
          SEC
	  ADC dxl
	  STA el
	  BCC xdraw4
	  JSR lrudx1
          CLC
xdraw4	  LDA eh
	  ADC dy
	  STA eh
	  BCC xdraw5
	  JSR lrudx2
xdraw5	  DEX
	  BNE xdraw3
	  LDA dxh
          LSR
          LSR
          LSR
	  BNE xdraw2
          INC shapell
	  BNE ni
          INC shapelh
ni	  LDA (shapell,X)
	  BNE xdraw2
          RTS

; Interpretiere HiRes - Koordinate
; O: X-Koordinate in X, Y; Y-Koordinate in Akku = FAC1exp
hfns	  JSR frmnum	      ; interpretiere Real-Ausdruck
	  JSR getadr	      ; wandle FAC1 in Integer
          LDY linnumh
          LDX linnuml
	  CPY #$01	      ; MSB mit 1 vergleichen
	  BCC hfns1	      ; ok, X-Koordinate < 256
	  BNE ggerr	      ; X-Koordinate > 511 -> ILLEGAL QUANTITIY ERROR
	  CPX #$18	      ; sonst LSB testen
	  BCS ggerr	      ; >= 24, -> ILLEGAL QUANTITY ERROR
hfns1	  TXA		      ; sonst X-Koordinate auf Stack retten
          PHA
          TYA
          PHA
          LDA #$2C
          JSR synchr          ; Test auf folgendes ','
	  JSR getbyt	      ; interpretiere Byte-Ausdruck
          CPX #$C0
	  BCS ggerr	      ; Byte >= 192 -> ILLEGAL QUANTITY ERROR
	  STX FAC1exp
          PLA
          TAY                 ; Y hat X-MSB
          PLA
          TAX                 ; X hat X-LSB
          LDA FAC1            ; A hat Y
          RTS

ggerr	  JMP goerr	      ; ILLEGAL QUANTITY ERROR ausgeben

; HCOLOR - Function Handler
hcolor	  JSR getbyt	      ; interpretiere Byte-Ausdruck
	  CPX #$08	      ; Byte >= 8 -> schlecht
	  BCS ggerr
sethcol   LDA colortbl,X      ; Farbmaske aus Tabelle holen
	  STA hcolorz	      ; und eintragen
rts3	  RTS

; Tabelle der Farbmasken
colortbl  BYT $00,$2A	      ; 00000000  00101010
	  BYT $55,$7F	      ; 01010101  01111111
	  BYT $80,$AA	      ; 10000000  10101010
	  BYT $D5,$FF	      ; 11010101  11111111

; HPLOT - Function Handler
hplot	  CMP #$C1	      ; folgt Token fr 'TO'?
	  BEQ hp3	      ; nein, weiter
	  JSR hfns	      ; sonst Punkt-Koordinaten holen -> X, Y / A
	  JSR hplot0	      ; RAM-Adresse berechnen, Punkt setzen
hp2	  JSR chargot	      
	  CMP #$C1	      ; kommt noch ein 'TO'?
	  BNE rts3	      ; nein, fertig
hp3	  JSR synchr
          JSR hfns            ; zweite Koordinate holen
	  STY FAC1exp	      ; X-Koordinate nach A, X und Y-Koordinate nach Y bringen
          TAY
          TXA
	  LDX FAC1exp
	  JSR hglin	      ; und Linie malen
	  JMP hp2	      ; weiter mit nchster Linie oder fertig

; ROT= - Function -Handler
rot	  JSR getbyt	      ; hole Byte aus Programmtext
	  STX rotz	      ; als ROT-Wert abspeichern
	  RTS

; SCALE= - Function Handler
scale	  JSR getbyt	      ; hole Byte aus Programmtext
	  STX scalez	      ; als SCALE-Wert abspeichern
	  RTS

; hole Parameter fr DRAW, XDRAW
; O: 'shapel' zeigt auf Shape-Definition, ROT-Wert im Akku
drwpnt	   JSR getbyt
	   LDA shapepntl      ; Zeiger auf Kopf der Shape-Tabelle
	   STA shapell
	   LDA shapepnth
	   STA shapelh
	   TXA		      ; Shape-Nummer
	   LDX #$00
	   CMP (shapell,X)    ; mit Anzahl der Shape-Definitionen in Tabelle vergleichen
	   BEQ dp1	      ; gleich ist ok
	   BCS ggerr	      ; zu gro gibt ILLEGAL QUANTITY ERROR
dp1	   ASL		      ; verdoppeln
	   BCC dp2	      ; Shape-Nummer <128
	   INC shapelh	      ; sonst Zeiger um 256 erhhen
	   CLC
dp2	   TAY
	   LDA (shapell),Y    ; Zeiger auf Offset-Tabelle
	   ADC shapell	      ; Offset des Shapes zum Anfang der Shapetabelle addieren
	   TAX
	   INY
	   LDA (shapell),Y
	   ADC shapepnth
	   STA shapelh	      ; Zeiger auf richtige Shape-Definition eintragen
	   STX shapell
	   JSR chargot	      ; hole Zeichen
	   CMP #$C5	      ; Token fr 'AT'
	   BNE dp3	      ; kein Startpunkt angegeben
	   JSR synchr
	   JSR hfns	      ; sonst Koordinaten des Startpunktes holen
	   JSR hposn	      ; und RAM-Adresse bestimmen
dp3	   LDA rotz
	   RTS

; DRAW - Function Handler Einsprung
draw	  JSR drwpnt
	  JMP draw1

; XDRAW - Function Handler Einsprung
xdraw	  JSR drwpnt
	  JMP xdraw1

; SHLOAD - Function Handler
shload	  LDA #linnuml / 256
          STA a1h
          STA a2h
	  LDY #linnuml # 256
          STY a1l
          INY
          STY a2l
	  JSR tread	      ; Lnge der Shapetabelle lesen
          CLC
          LDA memsizel
          TAX
	  DEX		      ; HiMem -1 als Endadresse fr Laderoutine
          STX a2l
	  SBC linnuml	      ; minus Lnge der Shapetabelle
          PHA
          LDA memsizeh
          TAY
          INX
	  BNE sl1
          DEY
sl1	  STY a2h
	  SBC linnumh	      ; ergibt Zeiger auf Tabellen-Anfang, MSB
	  CMP strendh	      ; mit Feldvariablen-Ende +1 vergleichen
	  BCC sl2	      ; Platz reicht nicht aus, Fehler
	  BNE sl3	      ; Platz reicht aus, ok
sl2	  JMP memerr	      ; OUT OF MEMORY ausgeben
sl3	  STA memsizeh	      ; Anfang der Shapetabelle als neues HiMem
	  STA fretoph	      ; und als Anfang des Stringbereiches eintragen,
	  STA a1h	      ; sowie als Anfangsadresse der Laderoutine
	  STA shapepnth       ; und als Zeiger auf den Anfang der Shapetabelle
          PLA
	  STA shapepntl       ; LSB eintragen
          STA memsizel
          STA fretopl
          STA a1l
	  JSR rd2bit	      ; Monitor-Routine ldt Shape-Tabelle vom Band
	  LDA #$03	      ; in den angegebenen Bereich
	  JMP monread2

; setze Monitorregister fr STORE / RECALL
; I: Lnge der Feldvariablen in 'linnum'
;    Zeiger auf Variablenkopf in 'lowtr'
tapepnt   CLC
	  LDA lowtrl	      ; Zeiger auf Variablenkopf
	  ADC linnuml	      ; plus Variablennlnge
	  STA a2l	      ; ins Bereichsende-Register
          LDA lowtrh
          ADC linnumh
	  STA a2h
          LDY #$04
	  LDA (lowtrl),Y      ; Anzahl der Dimensionen
	  JSR getary2
	  LDA highdsl	      ; Zeiger auf 1. Datenbyte
	  STA a1l	      ; ins Bereichsanfangs-Register
          LDA highdsh
          STA a1h
          RTS

; Array-Variable lokalisieren fr STORE/RECALL
getarypt  LDA #$40
	  STA subflg	      ; STORE-Flag setzen
          JSR ptrget          ; Variable suchen
          LDA #$00
	  STA subflg	      ; STORE-Flag lschen
	  JMP vartio	      ; setze Register 'a1':='linnum', 'a2':='temppt'

; HTAB - Function Handler
htab	  JSR getbyt	      ; hole Byte aus Programmtext
sethtab   DEX		      ; 1. Spalte hat die Spaltennummer 0
	  TXA
htab1	  CMP #$28	      ; Zeilenende erreicht?
	  BCC htab2	      ; ok, Cursor-Spalte eintragen
	  SBC #$28	      ; sonst 40 subtrahieren
          PHA
	  JSR crdo	      ; und neue Zeile anfangen
          PLA
	  JMP htab1
htab2	  STA ch
          RTS

	  BYT $CB,$D2,$D7
	  END
