; This file is part of the Resolution ][ library
;
; Copyright (c) 2000 Arthur Jerijian
; 
; Permission is hereby granted, free of charge, to any person obtaining
; a copy of this software and associated documentation files
; (the "Software"), to deal in the Software without restriction, including
; without limitation the rights to use, copy, modify, merge, publish,
; distribute, sublicense, and/or sell copies of the Software, and to permit
; persons to whom the Software is furnished to do so, subject to the
; following conditions:
; 
; The above copyright notice and this permission notice shall be included
; in all copies or substantial portions of the Software.
; 
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
; OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

; ======================================================================
;
; MAIN PROGRAM ENTRY POINT
;
; This module unifies all other modules and provides a jump table
; for function call entry
;
; Assemble with the command
;	xa -C -v -M main.asm -o resii.bin

; Include all definitions
#include "defs.asm"

; Define the program start address
.text
*= program_start

; Entry point jump table for public routines

	jmp	resii_graphics_enable
	jmp	resii_fill_background
	jmp	resii_x_offset
	jmp	resii_y_offset
	jmp	resii_inc_x_offset
	jmp	resii_dec_x_offset
	jmp	resii_inc_y_offset
	jmp	resii_dec_y_offset
	jmp	resii_draw_pixel_offset
	jmp	resii_draw_pixel
	jmp	resii_read_pixel_offset
	jmp	resii_read_pixel
	jmp	resii_draw_line

; Include all other modules
#include "init.asm"
#include "background.asm"
#include "pixel.asm"
#include "line.asm"
#include "tables.asm"

