/* 
 * Apple // emulator for Linux: Keyboard definitions
 *
 * Copyright 1994 Alexander Jean-Claude Bottema
 * Copyright 1995 Stephen Lee
 * Copyright 1997, 1998 Aaron Culliney
 * Copyright 1998, 1999, 2000, 2001 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 2 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#ifndef A2_KEYS_H
#define A2_KEYS_H

/* Numbering Scheme
 *
 * The low set of characters, 0-127 are ordinary ASCII characters that
 * are sent to the Apple keyboard register on each press (release ignored). 
 *
 * The top 32 of characters, 224-255, are used for characters that have 
 * influence when held down -- this includes the shift/control keys, 
 * apple keys/joystick buttons, and the fake joystick.  Their status is 
 * maintained in a bitmask.
 *
 * The rest of the high characters are used for internal things 
 *
 */

#define kNONE	128	/* Null action -- for unassigned keycodes */
#define kCaps	129	/* Caps Lock */

/* Actual actions */
#define kS6D1	130
#define kS6D2	131
#define kPause	132
#define kKBHelp	133
#define kDebug	134
#define kFast	135
#define kMenu	136
#define RST	137
#define BOT	138
#define J_C	139	/* Pseudo-Joystick recenter */

/* Used in menu screens */
#define kPGUP	140
#define kHOME	141
#define kPGDN	142
#define kEND 	143

/* Synonyms for menu use... */
#define kLEFT	8
#define kRIGHT	21
#define kUP	11
#define kDOWN	10
#define kESC	27

/* Shift/Ctrl */
#define kLShift 	224
#define BkLShift	0x00000001
#define kRShift 	225
#define BkRShift	0x00000002
#define kLCtrl		226
#define BkLCtrl		0x00000004
#define kRCtrl	 	227
#define BkRCtrl		0x00000008

/* Pseudo-joystick */
#define	J_U		228
#define BJ_U		0x00000010
#define	JUR		229
#define BJUR		0x00000020
#define	J_R		230
#define BJ_R		0x00000040
#define	JDR		231
#define BJDR		0x00000080
#define	J_D		232
#define BJ_D		0x00000100
#define	JDL		233
#define BJDL		0x00000200
#define	J_L		234
#define BJ_L		0x00000400
#define	JUL		235
#define BJUL		0x00000800
#define JB0		236		/* also Open Apple */
#define BJB0		0x00001000
#define JB1		237		/* also Solid Apple */
#define BJB1		0x00002000
#define JB2		238
#define BJB2		0x00004000


/* Bitmask defines not directly associated with a key */

#define BLock		0x80000000 /* Capslock state */

/* duplicate joystick buttons for real joystick */
#define BRJB0		0x40000000
#define BRJB1		0x20000000
#define BRJB2		0x10000000

#define	 TIMER_DELAY		30000L

#ifndef __ASSEMBLER__

extern short	joy_x, joy_y;
extern unsigned char   key_register;
extern int keys_down;

#ifdef PC_JOYSTICK
extern int c_open_joystick(void);
extern void c_calculate_joystick_parms(void);
extern void c_close_joystick(void);
extern void c_calibrate_joystick(void);
extern void poll_pcjoystick(void);
#endif

void c_read_raw_key(int scancode, int pressed);
void c_periodic_update(int dummysig);
void enter_debugger(void);
int c_mygetch(int block);
void initalize_keymaps(void);

#endif /* __ASSEMBLER__ */
#endif /* MA2_KEYS_H */
