;
; Lowest level console keyboard/video interface routines.
;
DGROUP	GROUP	_DATA	; Set up data group
; Define video screen attributes
NORMAL	EQU	07h    	; Normal mode video attributes
REVERSE	EQU	70h	; Special effect video attribute
CBASE	EQU	0B800h	; Color video screen segment
MBASE	EQU	0B000h	; Monochrome video screen segment
;
_DATA	segment	word public 'DATA'
;
_V_BASE DW	0b800h	; Mono=B000h, Cga=B800h
_V_PAGE	DB	0	; Current video page
_V_ATTR DB	0	; Current video attribute
_V_XY	DW	0	; X & Y Cursor position
_V_KEYS	DW	4800h	; KUP	(Up arrow)
	DW	5000h	; KDO	(Down arrow)
	DW	4B00h	; KBS	(Left arrow)
	DW	4D00h	; KND	(Right arrow)
	DW	4900h	; KPU	(PgUp)
	DW	5100h	; KPD	(PgDn)
	DW	4700h	; KPL	(Home)
	DW	4F00h	; KPR	(End)
	DW	8400h	; KHO	(CTRL-PgUp)
	DW	7600h	; KEN	(CTRL-PgDn)
	DW	5300h	; KDC	(Del)
	DW	0E08h	; KDP	(Backspace)
	DW	7700h	; KCL	(CTRL-Home)
	DW	4E2Bh	; K1	(Keypad '+')
	DW	4A2Dh	; K2	(Keypad '-')
	DW	5200h	; K3 	(Ins)
	DW	3B00h	; K4	(F1)
	DW	3C00h	; K5	(F2)
	DW	3D00h	; K6	(F3)
	DW	3E00h	; K7	(F4)
	DW	3F00h	; K8	(F5)
	DW	4000h	; K9	(F6)
	DW	4100h	; K10	(F7)
	DW	7400h	; K11	(CTRL-Right arrow)
	DW	7300h	; K12	(CTRL-Left arrow)
	DW	4200h	; K13	(F8)
	DW	4300h	; K14	(F9)
	DW	4400h	; K15	(F10)
	DW	0
_DATA ENDS
;
_TEXT	segment byte public 'CODE'
	assume	cs:_TEXT,ds:DGROUP
;
; Initialize the video display
;
_v_init	PROC	NEAR
	MOV	AH,0Fh	    ; Get video mode
	INT	10h	    ; Issue BIOS call
	MOV	DGROUP:_V_PAGE,BH; Save video page
	MOV	BX,CBASE    ; Assume COLOR address
	CMP	AL,07h	    ; Monochrome?
	JNZ	VINIT1	    ; No, assumption correct
	MOV	BX,MBASE    ; Get MONOCHROME address
VINIT1:	MOV	DGROUP:_V_BASE,BX; Set video base address
	MOV	DGROUP:_V_ATTR,NORMAL; Set for normal video
	MOV	AX,85h	    ; Clear screen code
	PUSH	AX	    ; Pass to subroutine
	CALL	_v_putc	    ; Clear the screen
	ADD	SP,2	    ; Clean up stack
	RET
_v_init	ENDP
	PUBLIC	_v_init
;
; Get a key from the keyboard with translations: c = vgetc();
;
_v_getc PROC	NEAR
; Position cursor on video display
	MOV	AH,02h	    ; Position cursor
	MOV	BH,DGROUP:_V_PAGE; Get page id
	MOV	DX,DGROUP:_V_XY; Get 'X' and 'Y' position
	INT	10h	    ; Call BIOS
; Call BIOS to read key
	XOR	AH,AH	    ; Function code 0 - read key
	INT	16h	    ; Call bios
; Lookup key for special entries
	MOV	CL,80h	    ; Beginning function code
	MOV	BX,OFFSET DGROUP:_V_KEYS ; Address of keys array
LOKKEY:	MOV	DX,[BX]	    ; Get key entry
	CMP	AX,DX	    ; Does it match?
	JZ	FNDKEY	    ; We found it
	ADD	BX,2	    ; Skip ahead
	INC	CL	    ; Advance key code
	OR	DH,DL	    ; End of table?
	JNZ	LOKKEY	    ; Keep looking
; Translate ENTER key to newline
	MOV	CL,'J'-40h  ; Newline is LINE-FEED
	CMP	AX,1C0Dh    ; ENTER key?
	JZ	FNDKEY	    ; Yes, we have it
; Not a special entry
	MOV	CL,AL	    ; Copy over original key
FNDKEY:	XOR	CH,CH	    ; Zero high byte
	MOV	AX,CX	    ; Set return value
	RET
_v_getc ENDP
	PUBLIC	_v_getc
;
; Write a character to the video display: vputc(char c);
;
_v_putc	PROC	NEAR
	PUSH	BP	    ; Save callers stack frame
	MOV	BP,SP	    ; Set up addressability to args
	PUSH	DI	    ; Save callers DI
	PUSH	SI	    ; Save callers SI
	PUSH	ES	    ; Save callers Extra segment
	PUSH	DS	    ; Save callers Data segment
; Set up addresability to the video display, and
; Establish the current cursor position.
	MOV	ES,DGROUP:_V_BASE; Point to video base
	MOV	DX,_V_XY    ; Get 'X' and 'Y' position
	MOV	AL,DH	    ; Copy 'Y'
	MOV	BL,160	    ; Size of line (in bytes)
	MUL	BL	    ; Calculate 'Y' offset
	MOV	BL,DL	    ; Copy 'X'
	XOR	BH,BH	    ; Zero high byte
	ADD	BX,BX	    ; * 2 for two byte entries
	ADD	BX,AX	    ; BX = character position
	MOV	AL,4[BP]    ; Get character to display
	MOV	AH,DGROUP:_V_ATTR; restore attribute
; Hsndle BELL
TSTBEL:	CMP	AL,'G'-40h  ; BELL code?
	JNZ	TSTSP1	    ; No, try next
	MOV	AX,0E07h    ; Write BELL code
	XOR	BX,BX	    ; Write to page 0
	INT	10h	    ; Call BIOS
	JMP	SHORT VEXIT1; and exit	    
; Handle special effects ON
TSTSP1:	CMP	AL,88h	    ; Special effects on?
	JNZ	TSTSP0	    ; No, try next
	MOV	AH,REVERSE  ; Set for reverse video
	JMP	SHORT SEXIT ; Set mode & exit
; Handle special effects OFF
TSTSP0:	CMP	AL,89h	    ; Special effects off?
	JNZ     TSTHO	    ; No, try next
	MOV	AH,NORMAL   ; Set for normal mode
SEXIT:	MOV	DGROUP:_V_ATTR,AH; Set new video mode
	JMP	SHORT VEXIT1; and proceed
; Handle HOME
TSTHO:	CMP	AL,84h	    ; Home?
	JNZ	TSTCR	    ; No, try next
	XOR	DX,DX	    ; Reset cursor
	JMP	SHORT VEXIT1; and proceed
; Handle CARRIAGE RETURN
TSTCR:	CMP	AL,'M'-40h  ; Is it carriage return
	JNZ	TSTBS	    ; No, try next
	XOR	DL,DL	    ; Reset 'X' position
	JMP	SHORT VEXIT1; and proceed
; Handle BACKSPACE & CURSOR LEFT
TSTBS:	CMP	AL,82h	    ; Cursor left?
	JZ	DOBS	    ; Yes, handle it
	CMP	AL,'H'-40h  ; Is it backspace
	JNZ	TSTUC	    ; No, try line-feed
DOBS:	AND	DL,DL	    ; Already at first col?
	JZ	VEXIT1	    ; Yes, don't backup
	DEC	DL	    ; Reduce 'X' position
VEXIT1:	JMP	SHORT VEXIT ; And exit
; Handle CURSOR UP
TSTUC:	CMP	AL,80h	    ; Up code?
	JNZ	TSTCL	    ; No, try next
	AND	DH,DH	    ; Already at first row?
	JZ	VEXIT	    ; Yes, ignore code
	DEC	DH	    ; Go up a line
	JMP	SHORT VEXIT ; and proceed
; Handle CLEAR SCREEN
TSTCL:	CMP	AL,85h	    ; Clear screen
	JNZ	TSTCD	    ; No, try next
	XOR	DX,DX	    ; Reset cursor position
	MOV	AH,02h	    ; Set cursor position
	MOV	BH,DGROUP:_V_PAGE; Get current page
	INT	10h	    ; Call BIOS
	MOV	CX,80*25    ; # entries to clear
	MOV	DI,DX	    ; Start of display
	JMP	SHORT DOCLR ; Perform the clear
; Handle CLEAR TO END OF SCREEN
TSTCD:	CMP	AL,86h	    ; Clear to end of screen?
	JNZ	TSTCE	    ; No, try clear to end of line
	MOV	CX,80*25    ; Get end of screen
	MOV	DI,BX	    ; Start from here
	SHR	BX,1	    ; Calculate cursor character position
	SUB	CX,BX	    ; Calculate # remaining
	JMP	SHORT DOCLR ; Perform the clear
; Handle CLEAR TO END OF LINE
TSTCE:	CMP	AL,87h	    ; Clear to end of line?
	JNZ	TSTLF	    ; No, try next
	MOV	CX,80	    ; Get length
	SUB	CL,DL	    ; Calculate # remaining
	MOV	DI,BX	    ; Start here
	JMP	SHORT DOCLR ; perform the clear
; Handle CURSOR DOWN
TSTLF:	CMP	AL,81h	    ; Cursor down?
	JZ	ADVY	    ; Yes, handle it
; Handle NEWLINE
	CMP	AL,'J'-40h  ; Is it newline?
	JNZ	TSTND	    ; Yes, advance line
	XOR	DL,DL	    ; Reset cursor
	JMP	ADVY	    ; And goto a new line
; Handle CURSOR FORWARD
TSTND:	CMP	AL,83h	    ; Non-destructive?
	JZ	ADVX	    ; Yes, advance cursor
; Normal Character, output it
NORCHR:	MOV	ES:[BX],AX  ; Write to video display
; Advance 'X' position
ADVX:	INC	DL	    ; Advance 'X'
	CMP	DL,80	    ; Are we over?
	JB	VEXIT	    ; No, its ok
	DEC	DL
	JMP SHORT VEXIT
;	XOR	DL,DL	    ; Reset 'X' posotion
; Advance 'Y' position
ADVY:	MOV	SI,160	    ; Copy second line...
	MOV	DI,0	    ; into first line
	INC	DH	    ; Advance # lines
	CMP	DH,25	; are we over?
	JB	VEXIT	    ; No, Its OK
	DEC	DH	    ; Reset it
	MOV	CX,80*24    ; # characters to move
	MOV	BX,ES	    ; Get video address
	MOV	DS,BX	    ; Set source display
    REP	MOVSW		    ; Scroll screen
	MOV	CX,80	    ; Size of one line
DOCLR:	MOV	AX,0720h    ; clear with blank
    REP	STOSW		    ; Clear line
; Restore parameters & exit
VEXIT:	POP	DS	    ; Restore callers Data seg
	POP	ES
	POP	SI
	POP	DI
	MOV	DGROUP:_V_XY,DX	; Resave 'X' and 'Y'
	POP BP		    ; Restore callers stack frame
	RET
_v_putc ENDP
	PUBLIC	_v_putc
;
; Position the cursor on the video display: gotoxy(int x, int y);
;
_v_gotoxy PROC	NEAR
	PUSH	BP	    ; Save callers stack frame
	MOV	BP,SP	    ; Set up addressability to args
	MOV	DL,4[BP]    ; Get 'X' value
	MOV	DH,6[BP]    ; Get 'Y' value
	MOV	DGROUP:_V_XY,DX; Set X/Y values
; Position cursor on video display
	MOV	AH,02h	    ; Position cursor
	MOV	BH,DGROUP:_V_PAGE; Get page id
	INT	10h	    ; Call BIOS
	POP	BP	    ; Restore callers stack frame
vh2:	RET
_v_gotoxy ENDP
	PUBLIC	_v_gotoxy
	EXTRN	_putchr:near
;
; Help text and display function, takes text from code segment, so that
; available data segment (edit buffer) is not reduced.
;
_x_help:MOV BX,offset xh
	JMP	SHORT vh1
_v_help:MOV	BX,OFFSET eh
vh1:	MOV	AL,CS:[BX]
	INC	BX
	XOR	AH,AH
	AND	AL,AL
	JZ	vh2
	PUSH	BX
	PUSH	AX
	CALL	_putchr
	POP	AX
	POP	BX
	JMP SHORT vh1
	PUBLIC	_v_help, _x_help
eh: DB	'Special keys                   Commands                   Line ranges',0Ah
    DB	'------------                   --------                   -----------',0Ah
    DB	'PgDn  = Page forward             C = Copy line(s)          * = Current line',0Ah
    DB	'PgUp  = Page backward            D = Delete line(s)        / = Entire file',0Ah
    DB	'^PgUp = Start of file            F = File info             n = line # (1+)',0Ah
    DB	'^PgDn = End of file             nH = Set Htab size         0 = End of file',0Ah
    DB	'Home  = Start of line            I = Insert new line(s)    = = Tagged lines',0Ah
    DB	'End   = End of line              L = List (unformatted)  r,r = range to range',0Ah
    DB	'^Home = Redraw screen            M = Move line(s)',0Ah
    DB	'^->   = Word right               P = Print (formatted)',0Ah
    DB	'^<-   = Word left                Q = Quit editor',0Ah
    DB	'INS   = Insert/Overwrite        QQ = Quit with no save',0Ah
    DB	'DEL   = Delete character     Rfile = Read & insert file   Examples:',0Ah
    DB	'BKSPC = Delete previous  S/old/new = Substitute text      ---------',0Ah
    DB	'F1    = EOL display              T = Tag lines             D',0Ah
    DB	'F2    = Cursor position          V = Visual mode       1,10C',0Ah
    DB	'F3    = Move line to top   W[file] = Write file           =M',0Ah
    DB	'F4    = Tag line(s)        X[file] = eXit/write file      0R my.fil',0Ah
    DB	'F5    = Del to end of line   ?text = Search for text      /W my.fil',0Ah
    DB	'F6    = Del end of line     $[cmd] = Execute DOS command',0Ah
    DB	'F7    = Insert deleted line (null) = Move to line range',0Ah
    DB	'F10/K+= Line mode command',0Ah
    DB	' F9/K-= Re-execute command',0Ah,0
; Command line help
xh: DB	0Ah,'Use: edt <file> [c=initial_cmd -video_inhibit]',0Ah,0Ah
    DB	'Copyright 1983-2008 Dave Dunfield',0Ah
    DB	'All rights reserved.', 0Ah, 0
;
_TEXT	ENDS
	END
