;
; NorthStar Transfer (NST) disk access stub
;
; This program runs on the NorthStar DOS system, and provides
; access to disk read/write functions.
;
; You must supply host I/O functions to perform raw 8-bit serial
; data transfer with your console I/O hardware - please refer to
; the "Host I/O functions" section at the end of this file.
;
; NST permits comms parameters which are NOT 8-bit, however this
; is only for use with the UB and UH functions (if required) - all
; disk image transfer function (RS, RD, WS, WD) *REQUIRE* 8-bit
; serial I/O.
;
; Default code and data origin occupy memory from $2D00-$2FFF
; and place the 32k disk I/O buffer at $3000 - this is compatible
; with all versions of NorthStar DOS, which has free memory at:
;   old single-density: $2A00 and higher
;   old double-density: $2D00 and higher
;   new relocatable   : $1000 and higher
;
; The DBUF symbol defines a disk I/O buffer which is normally up
; to 32k in size - if you do not have enough memory for a 32k
; buffer, you can force NST to use a smaller buffer with the 'B='
; option. If this option is not used, NST will attempt to pick an
; "optimal" buffer size which is an integral number of tracks that
; fits within 32k.
;
; NOTE: There are several different versions of NorthStar DOS which
; load at different places in memory - the most common being $2000
; for older versions, and $0100 for newer versions - make sure that
; the address of the "DOS" EQU below matches the location where you
; particular version of NorthStar DOS is loaded into memory
;
; Assemble with DDS ASMZ80 assembler: ASMZ80 NST -T
;
; (Code is in Z80 format, however it does not use Z80 extensions,
;  so it should work on an 8080/8085 processor)
;
; The resultant NST.HEX file must be transferred to the NorthStar
; system - NST provides a 'UH' (Upload Hex) function which can do
; this using the NorthStar Mxxxx monitor. The steps are:
;
; ++ This example uses address '2D00' - adjust this value
; ++ if you are loading at a different address
;
;  Connect the PC serial port to the NorthStar system console port.
;
;  Execute the command: NST UH NST.HEX  [C= if needed]
;  You will be presented with a terminal on the NorthStar system.
;
;  Boot NorthStar DOS and get to the '+' or '*' prompt.
;
;  Run the NorthStar monitor: go Mxxxx    (xxxx = monitor address)
;   ** Do not use a monitor which occupies memory at the address
;   ** where this NST stub is located.		(see 'CODE' EQU).
;
;  Enter the monitor command: DS 2D00   	(see 'CODE' EQU).
;  You should see a prompt with the first memory location.
;
;  Press F1 - NST will now "type in" the NST disk stub code.
;
;  When it stops, press ENTER to return to the monitor prompt.
;
;  Enter the command: JP 2D00			(see 'CODE' EQU).
;
;  The stub is now active, press F10 to exit the upload terminal
;  function - you may now use NST to read and write disk images.
;
;  If you prefer, you can save the NST stub to disk, instead of
;  'JP' above, use:
;    Enter the monitor command: OS	(return to DOS prompt)
;    Enter the command: CR NST 2	(create NST file)
;    Enter the command: TY NST 1 2D00	(set executable & address)
;    Enter the command: SF NST 2D00	(save data to file)
;  Now you can execute the stub with GO NST
;  You can EXIT from the stub back to DOS by typing: $Q  (quickly)
;
; *** These EQUs may need to be adjusted to match the configuration
; *** of your system.
DOS	EQU	$2000		;NorthStar DOS base address
CODE	EQU	$2D00		;NST load address
DATA	EQU	$2FC0		;NST Data area (64 bytes)
DBUF	EQU	$3000		;NST disk I/O buffer (32k)
;
; OS entry points - derived from 'DOS' above - should not be altered
HDE	EQU	DOS+$19		;Hard Disk Error
DCOM	EQU	DOS+$22		;Disk access subroutine
EXIT	EQU	DOS+$28		;Exit address
;
; Data storage
	ORG	DATA		;Data area
SECTOR	DS	2		;Sector number
UNIT	DS	1		;Unit number
BLOCKS	DS	1		;# vlocks
HDESAV	DS	3		;HDE save area
STACK	EQU	DATA+64		;Stack position
;
; Main code block
	ORG	CODE
	CALL	HINIT		;Initialize host port
	LD	A,(HDE)
	LD	HL,(HDE+1)
	LD	(HDESAV),A
	LD	(HDESAV+1),HL
	LD	A,$C3
	LD	HL,RESET
	LD	(HDE),A
	LD	(HDE+1),HL
; Command loop - wait for '$c' command and execute
TOP	LD	SP,STACK	;Reset stack
	CALL	GETC		;Get command char
	CP	'$'		;Command lead-in?
	JP	NZ,TOP		;No, wait for it
TOP1	CALL	GETC		;Get command
; Read data from disk
tREAD	CP	'R'		;Read block
	JP	NZ,tWRITE	;No, try next
	CALL	GDISK		;Get disk read/write parameters
	LD	HL,(sector)	;HL = sector
	LD	DE,DBUF		;DE = RAM buffer
	LD	A,(UNIT)	;Get unit
	LD	C,A		;C = unit
	LD	B,1		;Read operation
	LD	A,(BLOCKS)	;A = #blocks
	CALL	DCOM		;Perform disk action
	JP	C,error		;Report error
	CALL	PUTEQ		;Indicator
	CALL	GSIZE		;Get size
tr1	LD	A,(HL)		;Read data byte
	CALL	PUTC		;Write it
	INC	HL		;Skip to next
	ADD	A,C		;Add to checksum
	LD	C,A		;Resave
	JP	NC,tr2		;No carry
	INC	B		;Carry in
tr2	DEC	DE		;Reduce count
	LD	A,D		;Get high
	OR	E		;Remaining data?
	JP	NZ,tr1		;Do them all
	LD	A,B		;Get checksum
	CALL	PUTC		;Write it
	LD	A,C		;Get checksum
putop	CALL	PUTC		;Write it
	JP	TOP
;
; Write data to disk
;
tWRITE	CP	'W'		;Write?
	JP	NZ,tGET		;No, try next
	CALL	GDISK		;Get disk parameters
	CALL	GSIZE		;Get buffer size
	CALL	PUTEQ		;Indicator
twr1	CALL	GETC		;Get data
	LD	(HL),A		;Save it
	INC	HL		;Next position
	ADD	A,C		;Add to checksum
	LD	C,A		;Resave
	JP	NC,twr2		;No carry
	INC	B		;Carry in
twr2	DEC	DE		;Reduce count
	LD	A,D		;Get high
	OR	E		;Any left?
	JP	NZ,twr1		;Yes, do them all
	CALL	GETC		;Get check H
	LD	D,A		;Save
	CALL	GETC		;Get check L
	CP	C		;Match?
	JP	NZ,error	;No, report error
	LD	A,D		;Get H
	CP	B		;Match H
	JP	NZ,error	;Report error
	LD	HL,(sector)	;HL = sector
	LD	DE,DBUF		;DE = RAM buffer
	LD	A,(UNIT)	;Get unit
	LD	C,A		;C = unit
	LD	B,0		;Write operation
	LD	A,(BLOCKS)	;A = #blocks
	CALL	DCOM		;Perform disk action
	JP	C,error		;Report error
pudot	LD	A,'.'		;Done flag
	JP	putop		;Output & exit
;
; Get byte from memory
tGET	CP	'G'		;Get?
	JP	NZ,tPUT		;No, try next
	CALL	GMEM		;Get DOS memory
	CALL	PUTEQ		;Output indicator
	LD	A,(HL)		;Get data
	JP	putop		;Output & exit
;
; Put a byte in memory
tPUT	CP	'P'		;Put?
	JP	NZ,tTEST	;No, try next
	CALL	GMEM		;Get DOS memory
	CALL	GETC		;Get value
	LD	(HL),A		;Write value
	JP	pudot		;And exit
;
; Test for kernel present
;
tTEST	CP	'$'		;Entry again?
	JP	Z,TOP1		;Wait for another
	CP	'?'		;Test1 ?
	JP	Z,pudot		;handle it
	CP	'T'		;Test2 ?
	JP	NZ,tQUIT	;No, try next
	LD	A,'*'		;Response
	JP	putop
;
; Termination request
;
tQUIT	CP	'Q'		;Quit?
	JP	NZ,ERROR	;No, try next
	LD	A,(HDESAV)
	LD	HL,(HDESAV+1)
	LD	(HDE),A
	LD	(HDE+1),HL
	JP	EXIT
;
; Error has occured
;
ERROR	LD	A,'?'		;Error indicator
	CALL	PUTC		;Display it
RESET	CALL	GETC		;Read character
	JP	RESET		;Till timeout & restart
;
; Get DOS memory address
;
GMEM	CALL	GETC		;Read data
	LD	H,A		;Set high addess
	CALL	GETC		;Read data
	LD	L,A		;Set low data
	LD	DE,DOS		;DOS address
	ADD	HL,DE		;Offset to DOS
	RET
;
; Get disk parameters from host
;
GDISK	CALL	GETC		;Get data
	LD	(UNIT),A	;Set unit/density
	CALL	GETC		;Get data
	LD	(SECTOR+1),A	;Set sector high
	CALL	GETC		;Get data
	LD	(SECTOR),A	;Set sector low
	CALL	GETC		;Get # blocks
	LD	(BLOCKS),A	;Save # blocks
	RET
;
; Get size of disk I/O buffer from saved parameters
;
GSIZE	LD	HL,(BLOCKS-1)	;H= # blocks
	LD	L,0		;Zero low (HL = blocks * 256)
	LD	A,(UNIT)	;Get unit
	AND	$80		;Double?
	JP	Z,gsize1	;no - it's ok
	ADD	HL,HL		;HL = blocks * 512
gsize1	EX	DE,HL		;DE = size
	LD	HL,DBUF		;Point to disk I/O buffer
	LD	BC,0		;Zero BC
	RET
;
; Get character from host with timeout
;
GETC	PUSH	HL		;Save HL
	LD	HL,$3FFF	;Init counter
getc1	CALL	TESTC		;Check for character
	JP	NC,getc2	;We have data
	DEC	L		;Decrement counter
	JP	NZ,getc1	;Keep going
	DEC	H		;Decrement counter
	JP	NZ,getc1	;Keep going
	JP	TOP		;Reset and restart
getc2	POP	HL		;Restore HL
	RET
;
; Write the '=' sign
;
PUTEQ	LD	A,'='		;Get indicator
	JP	PUTC		;And display
;
;-------------------------------------------------------------
; Host I/O functions
;-------------------------------------------------------------
;
; NorthStar DOS I/O function do not provide a guaranteed method
; of reading 8-bit raw binary data with the ability to time-out,
; so NST uses it's own I/O functions.
;
; These functions are set up for the standard NorthStar Horizon
; console port ... if you are using different hardware, then you
; will need to modify the HWINIT, PUTC and TESTC functions to
; work with the console I/O hardware of your system.
;
; Write character in ACC to host - no registers may be modified
;
PUTC	PUSH	AF		;Save ACC
putc1	IN	A,(3)		;Read status
	AND	%00000001	;TX ready?
	JP	Z,putc1		;No, wait for it
	POP	AF		;Restore ACC
	OUT	(2),A		;Write to data port
	RET
;
; Test for character available from HOST
; If character is ready, return with C-flag clear and character in ACC
; If no character is ready, return with C-flag SET and ACC undefined
; No other registers may be modified.
;
TESTC	IN	A,(3)		;Read status
	AND	%00000010	;RX ready?
	JP	Z,testc1	;No data
	IN	A,(2)		;Read data
	RET
testc1	SCF			;Indicate no data
	RET
;
; Host initialization function
; Perform any initialization required to set the host port
; to 8-bit raw binary data mode - you may also wish to increase
; the baudrate for faster transfers.
; Called only once at NST startup - all registers may be modified.
HINIT	LD	A,3		; Insure not setup mode
	OUT	(3),A		; Write once
	OUT	(3),A		; Write again (now in operate mode)
	LD	A,%01110111	; Return to setup mode
	OUT	(3),A		; write it
	LD	A,%01001110	; 8 data, 1 stop, x16
	OUT	(3),A		; Write it
	LD	A,%00110111	; RTS,DTR,Enable RX,TX
	OUT	(3),A		; Write it
	IN	A,(2)		; Clear pending
	IN	A,(2)		; Clear pending
	RET
