/*
fcalls.c
Version 1.0 (c) 1987 by CodeWorks.
Mike W.Beutjer, C.Jeff Carter

Legal Stuff:
  This program is 100% public domain and may be freely distributed.
It is illegal to sell it or any modified version thereof, except
it be hacked beyond any recognition of the original.  It would
certainly be kind and proper to mention the original authors in any
future modified versions.  Comments & suggestions are welcome.
The authors may be contacted at:

	CodeWorks
	M.W.Beutjer
	409 Jack Coleman Dr.
	Huntsville, AL 35805

	CompuServe ID: 73657,2614
	BIX:           micsc
	PLINK          ???????  Jeff is a member.

fcalls is a simple utility that examines c source code & produces a
structure hierarchy diagram.  The diagram looks like this:

main(argc,argv)
	function1(arg1,arg2)
		function2(arg1,arg2,arg3)
	function3()
	function4(arg1)

with the level of indentation equal to the function depth.  The
program analyzed may exist in multiple files, each filename to be
analyzed should be passed as a command line arg to fcalls.
The current option arguments are:

	-l	print the filename and line number of each function reference.
	-e	do not list external functions separately.

P.S. - We NEEDED this program the 2 days we wrote it in, so it may
not be thoroughly debugged.  If you find something, leave us a message
so we can help fix it.	It has been run against one application of about
5000 lines & 35 files & worked good.  We wrote it with an eye to
portability, it runs unchanged from UNIX to Amiga (Manx), and there are
no (I think) system specific routines.

Compile command: cc fcalls -fop m=s
*/

#include <stdio.h>
#include <ctype.h>

#define NOFILE 0
#define NOMEM 1
#define NOMAIN 2

#define TRUE 1
#define FALSE 0

#define NEWLINE '\n'

struct Func {
	struct Func	*Next;
	char		*Name;
	char		*TName;
	struct Func	*Xref[100];
	int			Index;
	int			ExtFlag;
	int			UsedFlag;
	int			Line_cnt;
	char		*FName;
};

int			indent;
int			line_cnt;
char		*fname;
unsigned	brace_cnt;
int			sep_ext = TRUE;
int			line_no = FALSE;

struct Func *start = NULL;
struct Func *last;
extern char *fgets ();
extern char *malloc ();

iscsym (c)
char	c;
{
	if (c>='a' && c<='z') return 1;
	if (c>='A' && c<='Z') return 1;
	if (c == '_') return 1;
	return 0;
}

int	incmnt = 0;
int	bincmnt = 0;

char	*my_index (s, c)
char	*s, c;
{
	if (incmnt) {
		while (*s && !((*s == '*')&&(*(s+1)=='/'))) ++s;
		if (!*s) return NULL;
		incmnt = 0;
	}
	while (*s && (*s != c) && (!((*s == '/') && (*(s + 1) == '*')))) ++s;
	switch (*s) {
		case '\0':
			return NULL;
		case '/':
			incmnt = 1;
			s += 2;
			return my_index(s,c);
		default:
			return s;
	}
}

char	*my_bindex (s, c)
char	*s, c;
{
	if (bincmnt) {
		while (*s && !((*s == '*')&&(*(s+1)=='/'))) ++s;
		if (!*s) return NULL;
		bincmnt = 0;
	}
	while (*s && (*s != c) && (!((*s == '/') && (*(s + 1) == '*')))) ++s;
	switch (*s) {
		case '\0':
			return NULL;
		case '/':
			bincmnt = 1;
			s += 2;
			return my_bindex(s,c);
		default:
			return s;
	}
}

struct Func *find_Func (tname)
char	*tname;
{
	struct Func *currFunc;
	
	if (!start) return NULL;
	currFunc = start;
	while (currFunc -> Next) {
		if (!(strcmp (currFunc -> TName, tname))) return currFunc;
		currFunc = currFunc -> Next;
	}
	if (!(strcmp (currFunc -> TName, tname))) return currFunc;
	return NULL;
}

fatal (parm)
unsigned	parm;
{
	switch (parm) {
		case NOFILE:
			printf ("Unable to open file.\n");
			clean_up ();
		case NOMEM:
			printf ("Memory allocation error.\n");
			clean_up ();
		case NOMAIN:
			printf ("No 'main' routine.\n");
			clean_up ();
		default:
			clean_up ();
	}
}

get_tname (name, out)
char	*name,
		*out;
{
	int i,k;

	k = strlen (name);
	for (i = 0;(i < k) && (name[i] != '(') && (!isspace (name[i])); ++i)
		out[i] = name[i];
	out[i] = '\0';
}

struct Func *new_func (name)
char	*name;
{
	char buff[80];

	get_tname(name,buff);

	if (!(strcmp (buff, "if"))) return NULL;
	if (!(strcmp (buff, "for"))) return NULL;
	if (!(strcmp (buff, "while"))) return NULL;
	if (!(strcmp (buff, "return"))) return NULL;
	if (!(strcmp (buff, "sizeof"))) return NULL;
	if (!(strcmp (buff, "switch"))) return NULL;
	if (!(strcmp (buff, "case"))) return NULL;

	if (!start) {
		start = malloc (sizeof (struct Func));
		if (!start) fatal (NOMEM);
		last = start;
	}
	else {
		last -> Next = malloc (sizeof (struct Func));
		last = last -> Next;
		if (!last) fatal (NOMEM);
	}

	last -> Next = NULL;
	last -> Name = malloc (strlen (name)+1);
	if (!last -> Name) fatal (NOMEM);
	strcpy (last -> Name, name);

	last -> TName = malloc (strlen (buff)+1);
	if (!last -> TName) fatal (NOMEM);
	strcpy (last -> TName, buff);

	last -> Xref[0] = NULL;
	if(sep_ext)
		last -> ExtFlag = 1;
	else
		last -> ExtFlag = 0;
	last -> UsedFlag = last -> Index = 0;
	last -> FName = fname;
	last -> Line_cnt = line_cnt;

	return last;
}

xref (mainfunc, xfunc)
struct Func *mainfunc,*xfunc;
{
	int i;
	struct Func *temp;

	for (i = 0; i < mainfunc -> Index; ++i) {
		temp = mainfunc -> Xref[i];
		if (!(strcmp (temp -> TName, xfunc -> TName)))
		return;
	}
	mainfunc -> Xref[mainfunc -> Index++] = xfunc;
}

main (argc, argv)
int argc;
char *argv[];
{
	int i;
	FILE *infile;

	if (argc == 1 || *argv[0] == '?') {
		printf ("usage %s: file0 [file1 ...]\n", argv[0]);
		exit (0);
	}

	for (i = 1; i < argc; ++i) {
		if(*argv[i] == '-') {
			switch (*(argv[i] + 1)) {
				case 'e':				/* List the externals in with others */
					sep_ext = FALSE;
					break;
				case 'l':				/* Print the filenames on the line */
					line_no = TRUE;
					break;
				default:
					break;
			}
			continue;
		}

		line_cnt = 0;
		fname = argv[i];
		infile = fopen (argv[i], "r");
		if (!infile) fatal (NOFILE);
		process (infile);
		fclose (infile);
	}
	print_list ();
	clean_up ();
}

process (file)
FILE *file;
{
	char	buff[512], abuff[80], tbuff[512], tbuff2[120];
	int	j, k, l;
	struct Func *the_Func, *aFunc;
	unsigned	indx, tindx, paren_cnt;
	char	*temp, *nact, *paren;
	char	*bptr;

	incmnt=bincmnt=brace_cnt = 0;

	do {
		if (!(nact = fgets (buff, 120, file))) continue;
		++line_cnt;
		temp = buff;
		while (paren = my_index (temp, '(')) {
			temp = paren + 1;
			/* Skip whitespace back to first char. */
			j = 0;
			while (!j && --paren >= buff) if (!isspace (*paren)) j = 1;
			/*	j means candidate for func	*/
			/*		Back up to start of name	*/
			k = 0;
			if (j && iscsym (*paren)) {
				k = 1;
				while (--paren >= buff) if (!iscsym (*paren)) break;
			}
			++paren;
			if (k) {	/* A function has been found */
				for (paren_cnt = indx = tindx = 0;; ++tindx, ++indx) {
					if (paren[indx] == NEWLINE) {
						l = 0;
						fgets (tbuff2, 120, file);
						++line_cnt;
						while (isspace (tbuff2[l++]));
						/* Don't put blank lines in the middle of function calls. */
						strcpy (&paren[indx], &tbuff2[l]);
					}
					tbuff[tindx] = paren[indx];
					switch (tbuff[tindx]) {
						case '\'':
							while (1) {
								++indx;
								++tindx;
								tbuff[tindx] = paren[indx];
								if (tbuff[tindx] == '\'') break;
								if (tbuff[tindx] == '\\') {
									++indx;
									++tindx;
									tbuff[tindx] = paren[indx];
								}
							}
							break;
						case '"':
							while (1) {
								++indx;
								++tindx;
								if (paren[indx] == NEWLINE) {
									l = 0;
									fgets (tbuff2, 120, file);
									++line_cnt;
									strcpy (&paren[indx], &tbuff2[l]);
								}
								tbuff[tindx] = paren[indx];
								if (tbuff[tindx] == '\"') break;
								if (tbuff[tindx] == '\\') {
									++indx;
									++tindx;
									tbuff[tindx] = paren[indx];
								}
							}
							break;
						case '/':
							if (paren[indx + 1] != '*') break;
							++indx;
							--tindx;
							while (1) {
								++indx;
								if (paren[indx] == NEWLINE) {
									l = 0;
									fgets (tbuff2, 120, file);
									++line_cnt;
									while (isspace (tbuff2[l++]));
									strcpy (&paren[indx], &tbuff2[l]);
								}
								if (paren[indx] == '*' && paren[indx + 1] == '/') 
									break;
							}
							break;
					}
					if (tbuff[tindx] == '(') ++paren_cnt;
					if (tbuff[tindx] == ')') {
						--paren_cnt;
						if (!paren_cnt) break;
					}
				}
				tbuff[++tindx] = '\0';
				/*printf("tbuff = %s\n",tbuff);*/

				/*	A function declaration	*/

				get_tname (tbuff, abuff);
				if (!(aFunc = find_Func (abuff))) aFunc = new_func (tbuff);
				if (aFunc) {
					if (!brace_cnt) {
						the_Func = aFunc;
						bptr = buff;
						while (isspace (*bptr)) ++bptr;
						if (strncmp(bptr, "extern", 6)) the_Func->ExtFlag = 0;
					}

					/* A function call or a keyword */
					else
						xref (the_Func, aFunc);
				}
			}
		}

		temp = buff;
		while (temp = my_bindex (temp, '{')) {
			++temp;
			++brace_cnt;
		}

		temp = buff;
		while (temp = my_bindex (temp, '}')) {
			++temp;
			--brace_cnt;
		}

	} while (nact);
}

print_list () {
	struct Func *currFunc;
	int firstufunc;

	firstufunc = 1;
	currFunc = find_Func ("main");
	if (!currFunc) fatal (NOMAIN);
	indent = 0;
	printf ("Program Structure:\n");
	printf ("---------------------------------------------------------\n\n");
	printf ("%s\n", currFunc -> Name);
	print_Refs (currFunc);

	currFunc = start;
	while (currFunc -> Next) {
		if (!currFunc -> UsedFlag) {
			if(firstufunc) {
				firstufunc=0;
				printf("\n\nUnused Functions:\n");
				printf ("---------------------------------------------------------\n\n");
			}
			printf ("%s\n", currFunc -> Name);
		}
		currFunc = currFunc -> Next;
	}
	if (!currFunc -> UsedFlag) printf ("%s\n", currFunc -> Name);

	if(sep_ext) {
		currFunc = start;
		printf ("\n\nExternal Functions:\n");
		printf ("---------------------------------------------------------\n\n");
		while (currFunc -> Next) {
			if (currFunc -> ExtFlag) {
				printf ("%s", currFunc -> Name);
				if(line_no)
					printf("		%s: %d",currFunc->FName,currFunc->Line_cnt);
				printf("\n");
			}
			currFunc = currFunc -> Next;
		}
		if (currFunc -> ExtFlag) {
			printf ("%s\n", currFunc -> Name);
			if(line_no)
				printf("		%s: %d",currFunc->FName,currFunc->Line_cnt);
			printf("\n");
		}
	}
}

print_Refs (afunc)
struct Func *afunc;
{
	struct Func *temp;
	int i,j;

	++indent;
	for (i = 0; i < afunc -> Index; ++i) {
		temp = afunc -> Xref[i];
		if (!temp -> ExtFlag) {
			for (j = 0; j < indent; ++j) printf ("     ");
			printf ("%s", temp -> Name);
			if(line_no)
				printf("		%s:  %d",temp->FName,temp->Line_cnt);
			printf("\n");
		}
		if (strcmp (temp -> TName, afunc -> TName)) print_Refs (temp);
	}
	--indent;
	afunc -> UsedFlag = 1;
}

clean_up ()
{
	struct Func *temp,*currFunc;
	if(!(currFunc = start)) exit(0);

	while (currFunc -> Next) {
		temp = currFunc;
		currFunc = currFunc -> Next;
		if (temp->Name) free (temp -> Name);
		if (temp->TName) free (temp -> TName);
		free (temp);
	}
	if (currFunc -> Name) 
		free (currFunc -> Name);
	if (currFunc -> TName) 
		free (currFunc -> TName);
	free (currFunc);
	exit(0);
}
