/*
 * Quick & Dirty assembly source file analyser to determine the frequency
 * of the various instruction memonics. I used this to examine many asm
 * source files and used the results to optimize the instruction tables
 * in my assemblers.
 *
 * Copyright 1983-2003 Dave Dunfield
 * All rights reserved.
 *
 * Compile command: cc asmfreq -fop
 */
#include <stdio.h>

#define	MAXSYMS 500		/* Maximum number of different instruction names */
#define	SYMSIZ	15		/* Maximum size of an instruction */

unsigned scount = 0, times[MAXSYMS];
char symbols[MAXSYMS][SYMSIZ+1];

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, k, l;
	char inline[150], *ptr, *iptr;
	FILE *fp;

	if(argc < 2)
		abort("\nUse: asmfreq file ...\n");
	for(i=1; i < argc; ++i) {
		fp = fopen(argv[i], "rvq");
		fprintf(stderr,"Scanning '%s'...\n", argv[i]);
next:	while(fgets(ptr = inline, sizeof(inline), fp)) {
			if((*ptr == '*') || (*ptr == ';'))	/* Comment */
				continue;
			while(*ptr && !isspace(*ptr))		/* Skip label */
				++ptr;
			while(isspace(*ptr))				/* Skip blank */
				++ptr;
			if(!*(iptr = ptr))					/* No instruction */
				continue;
			while(*ptr && !isspace(*ptr)) {		/* Skip to end */
				*ptr = toupper(*ptr);
				++ptr; }
			*ptr = 0;
			for(j=0; j < scount; ++j) {
				if(!strcmp(symbols[j], iptr)) {
					++times[j];
					goto next; } }
			strcpy(symbols[scount], iptr);
			times[scount++] = 1; }
		fclose(fp); }

	fprintf(stderr,"Total of %u symbols found\n", scount);

	/* Dump frequency table in order of occurance */
	for(i=0; i < scount; ++i) {
		for(j=k=l=0; j < scount; ++j) {
			if(times[j] > k)
				k = times[l = j]; }
		printf("%-8s %u\n", symbols[l], k);
		times[l] = 0; }
}
