/*
 * Program to perform common operations on a laserjet or compatible printer.
 *
 * If HOTKEYS are specified on the command line, LZC will install
 * itself as a TSR (Ram-Resident) program, which can be invoked at
 * any time by pressing the HOTKEYS. Available HOTKEYS are:
 *		L - Left SHIFT
 *		R - Right SHIFT
 *		A - ALT
 *		C - CONTROL
 *		S - SysRq (Caution: some systems may not like this one)
 *
 *		eg: LZC LR	(Install with LEFT+RIGHT SHIFT for hotkeys)
 *
 * Copyright 1990-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc lzc -fop
 */
#include <stdio.h>
#include <window.h>
#include <tsr.h>
#include <file.h>

char *port = "LPT1";

char *menu[] = {
	"Control Normal",
	"Control Inhibit",
	"Eject One Page",
	"Font Primary",
	"Font Secondary",
	"Line Wrap On",
	"Line Wrap Off",
	"Reset Printer",
	"Self Test",
	"Underline On",
	"Underline Off",
	"View Portrait",
	"View Landscape",
	"66 line mode",
	"1  Copy",
	"2  Copies",
	"3  Copies",
	"5  Copies",
	"10 Copies",
	"25 Copies",
	"50 Copies",
	0 };

char *funcs[] = {
	"\x1BZ", "\x1BY",			/* Control NORMAL/INHIBIT */
	"\f",						/* Page eject */
	"\x0F", "\x0E",				/* Select Primary/Secondary font */
	"\x1B&s0C", "\x1B&s1C",		/* Line wrap ON/OFF */
	"\x1BE", "\x1Bz",			/* Reset & Self test */
	"\x1B&dD", "\x1B&d@",		/* Underline ON/OFF" */
	"\x1B&l0O","\x1B&l1O",		/* View PORTRAIT/LANDSCAPE */
	"\x1BE\x1B&l66p2e7.6c66F",	/* 66 line mode */
	"\x1B&l1X","\x1B&l2X",		/* 1 & 2 copies */
	"\x1B&l3X","\x1B&l5X",		/* 3 & 5 copies */
	"\x1B&l10X","\x1B&l25X",	/* 10 & 25 copies */
	"\x1B&l50X",				/* 50 copies */
	0 };

int select = 0;

/*
 * Main program
 */
laser()
{
	HANDLE fp;

	if(!(fp = open(port, F_WRITE)))
		return;

	for(;;) {
		if(wmenu(60, 1, WSAVE|WCOPEN|WBOX2|REVERSE, menu, &select)) {
			close(fp);
			return; }
		lputs(funcs[select], fp); }
}

/*
 * Main program, either TSR or execute main tty program menu
 */
main(argc, argv)
	int argc;
	int *argv[];
{
	int hot_keys;
	char *ptr;

/* If RAM-resident, print startup message & TSR */
	if(argc > 1) {
		fputs("Laser Commander\n\nCopyright 1990-2003 Dave Dunfield\nAll rights reserved.", stderr);
		hot_keys = 0;
		ptr = argv[1];
		while(*ptr) switch(toupper(*ptr++)) {
			case 'A' : hot_keys |= ALT;		break;
			case 'C' : hot_keys |= CONTROL;	break;
			case 'L' : hot_keys |= L_SHIFT;	break;
			case 'R' : hot_keys |= R_SHIFT; break;
			case 'S' : hot_keys |= SYS_REQ;	break;
			default: abort("\n\nInvalid HOTKEY"); }
		tsr(&laser, hot_keys, 2000); }

/* Not RAM-resident, execute the program */
	laser();
}
