/*
 * Screen-saver that moves a "happy face" around the screen, with
 * a few effects thrown in at regular intervals.
 *
 * Copyright 1991-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc off -fop
 */
#include <stdio.h>
#include <window.h>

#define	UP		0x1E		/* Trail moving up */
#define	DOWN	0x1F		/* Trail moving down */
#define	RIGHT	0x10		/* Trail moving right */
#define	LEFT	0x11		/* Trail moving left */
#define	STOP	0x02		/* Normal stopped Smiley */
#define	HURT	0x01		/* Smiley taking a beating */
#define	EXPLODE	0x07		/* Expoding markers */

int x = 0, y = 0, x1 = 75, y1 = 24, fillcnt = 0;
char fill = 0;

/* Various trail filler characters */
char filltab[] = { 0, 0x04, 0, 0x09, 0, '*', 0, 0xFE, 0, 0xF9 };

/* Copyright messages shown at opening */
char *yptr = "Smiley Screen Saver";
char *xptr = "Copyright 1991-2003 Dave Dunfield - All rights reserved.";

/* Special effects characters output in same spot */
char rotate1[] = { '-', '\\', '|', '/', 0 };
char rotate2[] = { '-', '/', '|', '\\', 0 };
char fade[] = { 0x20, 0xB0, 0xB1, 0xB2, 0xDB, 0xB2, 0xB1, 0xB0, 0 };
char skip[] = { 0xC4, 0xC2, 0xD2, 0xC2, 0xC4, 0xC1, 0xD0, 0xC1, 0xC4, 0 };
char line[] = { 0xF0, 0x3D, 0x2D, 0x20, 0x2D, 0x3D, 0 };
char grow[] = { 0xFE, 0x04, 0x07, 0xF9, 0xFA, 0x20, 0xFA, 0xF9, 0x07, 0x04,
	0xFE, 0x02, 0x02, 0 };

/* "Fortune Cookie" messages */
static char *msgs[] = {
"Smiley Screen Saver",
"Copyright 1991-2003 Dave Dunfield - All rights reserved.",
"He who has imagination without learning has wings but no feet",
"Everyone needs to believe in something; I believe I'll have another beer",
"God helps those who help themselves.",
"Every absurdity has a champion to defend it",
"Flee at once, all is discovered",
"Everyone is enthuastic about your work",
"Do not underestimate the power of FORCE",
"Don't tell me what you dreamt last nite for I've been reading Freud",
"Death: To suddenly stop sinning",
"Do not merely believe in miracles; rely on them",
"retupmoc eht edisni deppart ma I - PLEH",
"A stitch in time saves nine",
"Shift to the left, Shift to the right, POP up PUSH down, BYTE BYTE BYTE!!!",
"On a clear disk you can seek forever...",
"Beam me up Scottie.... There is no intelligent life down here!",
"Don't be humble... You're not that great",
"Be security conscious -- National defence is at stake!",
"A good memory does not equal pale ink",
"Age and treachery will always overcome youth and skill",
"Your buisness will go though a period of considerable expansion",
"A king's castle is his home",
"A hermit is a deserter from the army of humanity",
"You will be hungry within the hour",
"Volcano: A mountain with hiccups",
"You don't know what I know",
"Too men looking though the same bars; one sees mud, the other one stars",
"Time is nature's way of preventing everything from happening at once",
"Within a computer, natural language in unnatural",
"Those of you who think you know everything are annoying those of us who do!",
"You always have a chance for winning - The others might lose",
"There is no time like the pleasant",
"Use GOTO's only to implement a fundamental structure",
"The plural of spouse is spice",
"Toto, I have a feeling we're not in Kansas any more!",
"The future isn't what it used to be",
"Those who in quarrels interpose must often wipe a bloody nose",
"Sturgeon's Law: Ninety percent of everything is crud",
"The end justifys the means",
"The important thing is not to stop questioning",
"Save yourself!!! - Reboot in 5 seconds",
"Someone is unenthusiastic about your work",
"Passwords are implemented as a result of insecurity",
"Never insult an alligator until you have crossed the river",
"Like winter snow on summer lawn, time past is time gone",
"It's a poor workman who blames his tools",
"Liar: one who tells an unpleasant truth",
"It's easier to write a bad program than to understand a good one",
"It's easier to write a good program than to understand a bad one",
"It is a poor judge who cannot award a prize",
"If you want a fortune, go to a chinese restaurant",
"Modesty is a vastly overrated virtue",
"Mistakes are oft the stepping stones to failure",
"Many are cold, but few are frozen",
"It is a wise bird who builds his nest in a tree",
"Logic is like a little bird, sitting in a tree, that smells AWFUL",
"Ignorance is when you don't know anything, and someone finds out",
"If at first you don't succeed, try again, then quit - no sense being a fool",
"Hell is empty and all the devils are here",
"Is there a pilot on board?",
"She walks as if balancing the family tree on her nose",
"God does not play dice",
"Every purchase has its price",
"He who speak with forked tongue, not need chopsticks",
"A plucked goose won't lay golden eggs",
"There is no heavier burden than a great potential",
"Satire does not look pretty upon a tombstone",
"Some programming languages manage to absorb change, but withstand progress",
"Paranoia doesn't mean the whole world really isn't out to get you",
"No civilized person ever goes to bed the same day he gets up",
"Marriage: A three ring circus - Engagement ring, Wedding ring, Suffering",
"Make sure your comments and code agree",
"It's better to burn out that to rust out",
"Laugh, and the world ignores you. Crying doesn't help either",
"It's better to burn out than to fade away",
"God is not dead; He's only swapped out",
"General notions are generally wrong",
"Good intentions are far more difficult to deal with than malicious behavior",
"Facts do not cease to exist because they are ignored",
"Don't look now, but the man in the moon is laughing at you",
"Anything worth doing is worth asking someone else to do",
"A truly wise man never plays leapfrog with a Unicorn",
"A bird in the bush can't make a mess in your hand",
"To iterate is human, to recurse, divine",
"Those who can, do. Those who can't, simulate",
"Some men are discovered, others are found out",
"Only those who attempt the absurd achieve the impossible",
"Mind your own business Spock, I'm sick of your half-breed interference",
"Of all forms of caution, caution in love is the most fatal",
"Live a clean happy life, and you will soon die of boredom",
"It's easier to fight for one's principles than to live up to them",
"Every creature has within itself a weird uncontrollable urge to punt",
"Don't force it, use a bigger hammer",
"There is so much to say, but your eyes keep interrupting me",
"He who makes no mistakes usually makes nothing",
"Tact is the art of making a point without making an enemy",
"There are more old drunkards than old doctors",
"Last guys don't finish nice",
"I must have slipped a disk, my pack hurts",
"If it doesn't feel good, don't do it",
"God must love the common man, he made so many of them",
"I am not arguing with you -- Im telling you",
"Today is the first day of the rest of your life",
"Today is the last day of your life so far",
"Now and then an innocent man is sent to the legislature",
"Let not the sands of time get in your lunch",
"Never settle with words what you can accomplish with a flame thrower",
"Many pages make a thick book",
"Its a good thing we don't get all the government we pay for",
"Every silver lining has a cloud inside it",
"Due to lack of interest, today has been canceled",
"Even the smallest candle burnes brighter in the dark",
"If you keep burning the candle at both ends, you will soon run out of wax",
"Don't take life too seriously, you will never get out of it alive",
"LISP: To call a spade a thpade.",
"Life as we know it dosn't exist",
"Haste make waste - So do printers",
"Drawing on my fine command of language, I said nothing",
"Better to light one candle than to curse the darkness",
"Avoid temporary variables",
"A hen is only an egg's way of making another egg",
"Lack of leadership is no substitute for inaction",
"A journey of a thousand miles begins with a cash advance",
"To laugh at men of sense is the privilege of fools",
"The best prophet of the future is the past",
"That must be wonderful, I don't understand it at all",
"Out of sight is out of mind",
"Nothing dispells enthusiam like a small admission fee",
"Integrity has no need for rules",
"Let a fool hold his tongue and he will pass for a sage",
"Tis better to die on your feet than live on your knees",
"Everything should be made as simple as possible, but not simpler",
"All great ideas are controversial, or have been at one time",
"Blessed are they who run around in circles, for they shall be known as wheels",
"Words must be weighed, not counted",
"What sin has not been committed in the name of efficiency",	
"Without adventure, civilization is in full decay",
"If Noah had been truly wise... He'd have swatted those two little flys",
"Avoid the fortran arithmetic IF",
"A fanatic is one who can't change his mind, and won't change the subject",
"Bad command or file name",
"A bird in the hand is worth two in the bush",
"10.0 times 0.1 is hardly ever 1.0",
"Watch out for off-by-one errors",
"Writing free verse is like playing tennis with the net down",
"Time is but the stream I go a-fishing in",
"The program is absolutely right; therefore the computer is wrong",
"No one can feel as helpless as the owner of a sick goldfish",
"Observation, not old age, brings wisdom",
"Old MacDonald had an agricultural real estate tax abatement",
"Nature teaches beasts to know their friends",
"Many receive advice, few profit from it",
"It is easier to change the specification to fit the program than vice versa",
"I hate quotations.  -- Ralph Waldo Emerson",
"God may be subtle, but he isn't plain mean",
"Discretion is the better part of valor",
"Anybody can win - If there is no second entry",
"Better living a beggar than buried a king",
"Alimony and bribes will engage a large share of your wealth",
"About the only thing on a farm that has an easy time is the dog",
"A straw vote only shows which way the hot air blows",
"You cannot kill time without injuring eternity",
"We learn from history that we do not learn anything from history",
"Time flies when you don't know what you're doing",
"Quit work and play for once",
"The attacker must vanquish; the defender need only survive",
"People will buy anything thats one to a customer",
"Make it right before you make it faster",
"Most people eat as if they were fattening themselves for market",
"Man's horizons are bounded by his vision",
"Do not adjust your set",
"It seems to make an auto driver mad if he misses you",
"Good intentions randomize behaviour",
"Where theres a will... There are greedy relatives",
"People who live in glass houses.. Don't take baths",
"You can't turn back the clock... But you can wind it up again",
"Macho does not prove mucho",
"The cure for boredom is curiosity. There is no cure for curiosity",
"Nothing confirms suspicion more quickly than an official denial",
"The mills of the gods grind slowly, but they grind exceedingly fine",
"A strange game... The only winning move is not to play!",
"Any sufficiently advanced technology is indistinguishable from magic",
"Pandora's rule: Never open a box you didn't close",
"Login:",
"BURP!!!",
"WHEEE!!!",
"QUACK!!!",
"Lunch Time!"
};

extern unsigned RAND_SEED;

main()
{
	int i, j, k;
	char *ptr, *ptr1, buffer[81];

	/* First, initialize random number generator */
	get_time(&i, &j, &k);
	RAND_SEED = (j*60) + k;

	/* Open window & disable cursor */
	wopen(i = 0, 0, 80, 25, WSAVE|WCOPEN|NORMAL);
	wcursor_off();

	/* Loop forever, traveling to new spots on screen */
	for(;;) {
		move(x1, y1, fill);		/* Move to last selected stop */
		x1 = random(80);		/* Select new X co-ordinate */
		y1 = random(25);		/* Select new Y co-ordinate */
		delay(1000);

		/* Pick a fortune cookie & see it it will fit */
		j = strlen(ptr = msgs[RAND_SEED % (sizeof(msgs)/2)]);
		*(ptr1 = buffer+80) = 0;

		if((y < y1) && ((y1 - y) > j))		/* Try vertical-normal */
			yptr = ptr;
		else if((y - y1) > j) {				/* Try vertical-reversed */
			while(*ptr)
				*--ptr1 = *ptr++;
			yptr = ptr1; }
		else if((x < x1) && ((x1 - x) > j))	/* Try horizontal-normal */
			xptr = ptr;
		else if((x - x1) > j) {				/* Try horizontal-reversed */
			while(*ptr)
				*--ptr1 = *ptr++;
			xptr = ptr1; }

		/* Schedule special effects on a 32 event cycle */
		switch(++i & 31) {
			case 5 :			/* Select a new fill character */
			case 11 :
			case 17 :
			case 23 :
			case 29 :
				fill = filltab[fillcnt = (fillcnt + 1) % sizeof(filltab)];
			default:			/* No action */
				continue;
			case 2 :			/* Head explodes */
				cput(x, y, HURT);
				explode(EXPLODE);
				explode(' ');
				break;
			case 6 :			/* Wink in and out */
				for(j=0; j < 10; ++j) {
					cput(x, y, HURT);
					delay(150);
					cput(x, y, STOP);
					delay(150); }
				break;
			case 10 :			/* Rotate forward */
				ctable(rotate1);
				break;
			case 14 :			/* Fade in and out */
				ctable(fade);
				break;
			case 18 :			/* Skip rope */
				ctable(skip);
				break;
			case 22 :			/* Rotate backward */
				ctable(rotate2);
				break;
			case 26 :			/* Shrink and grow */
				ctable(grow);
				break;
			case 30 :			/* Bouncing lines */
				ctable(line); }
		delay(1000); }
}

/*
 * Move Smiley...
 * If X or Y text pointers are enabled, leave text as we move,
 * otherwise, leave current trail character (if defined).
 * If text or trail, re-draw path with blank spaces at end.
 */
move(int x1, int y1, char fill)
{
	int oldx, oldy;
	char xfill;

	oldx = x;						/* Save position for clean up */
	oldy = y;

	xfill = fill | *xptr | *yptr;	/* Remembed if we have to clean up */

	while(y != y1) {				/* Walk through Y co-ordinate */
		cput(x, y, *yptr ? *yptr++ : fill);
		if(y < y1)
			cput(x, ++y, DOWN);
		else
			cput(x, --y, UP);
		delay(150); }

	while(x != x1) {				/* And then X co-ordinate */
		cput(x, y, *xptr ? *xptr++ : fill);
		if(x < x1)
			cput(++x, y, RIGHT);
		else
			cput(--x, y, LEFT);
		delay(100); }

	cput(x, y, STOP);				/* Always end with STOPPED Smiley */

	if(xfill) {						/* We left droppings... Clean up */
		xptr = yptr = "";
		x = oldx;
		y = oldy;
		move(x1, y1, 0); }
}

/*
 * Explode Smiley....
 * Draw increasing sized box's around him.
 */
explode(int c)
{
	int i, j;

	for(i=1; i < 6; ++i) {
		for(j = -i; j <= i; ++j) {
			cput(x + j, y - i, c);
			cput(x + j, y + i, c);
			cput(x - i, y + j, c);
			cput(x + i, y + j, c); }
		delay(80); }
}

/*
 * Draw a character table at the current X/Y position (10 times).
 */
ctable(char *ptr)
{
	int i;
	char *xptr;

	for(i=0; i < 10; ++i) {
		xptr = ptr;
		while(*xptr) {
			cput(x, y, *xptr++);
			delay(100); } }
	cput(x, y, STOP);
}

/*
 * Put a character on screen at specified position, but only
 * if that position is actually on the physical screen.
 */
cput(int x, int y, int c)
{
	if((x >= 0) && (x < 80) && (y >= 0) && (y < 25)) {
		wgotoxy(x, y);
		wputc(c | 0x100); }
	if(wtstc()) {
		wclose();
		exit(0); }
}
