/*
 * This program uses the LONGMATH libary to locate the first 16k
 * prime numbers, using the division by primes method, with precomputed
 * squares. Note that even though the 32 bit long numbers are not large
 * enough to hold the precomputed square of the largest number we will
 * generate, the results are still valid because we only use the squared
 * values up to that largest number.
 *
 * Note: 1 and 2 are neither tested nor displayed by this program.
 *
 * Compile command: cc prime2 -pof
 */
#include <stdio.h>
#define	LSIZE	4
extern char Longreg[];

extern unsigned PSP;

/*
 * Make printable long number
 * Rotates through four static strings, allowing you to print up to
 * four long numbers in a single statment without worring about the
 * buffer's being overwritten.
 */
char *lp(char l[LSIZE])
{
	static char buffer[4][(LSIZE*25)/10+2];
	static unsigned x;

	ltoa(l, buffer[x = (x+1) & 3], 10);
	return buffer[x];
}

/*
 * Main program
 */
main()
{
	unsigned
		prime_seg,		/* Segment to hold prime numbers */
		square_seg,		/* Segment to hold squares */
		seg_top,		/* High water mark in segments */
		seg_ptr;		/* Current position in segment traverse */
	char
		num[LSIZE],		/* Current number we are testing */
		two[LSIZE],		/* Constant long (2) for addition */
		l1[LSIZE],		/* Temporary location for long */
		l2[LSIZE];		/* Temporary location for long */
	char
		flag;			/* Indicates we found prime number */

	prime_seg = alloc_seg(4096);	/* 64k segment for storing primes */
	square_seg = alloc_seg(4096);	/* 64k segment for storing squares */
	seg_top = 0;					/* Segments initially empty */

	longset(num, 3);	/* Initial prime number */
	longset(two, 2);	/* Advance by two each time */

	for(;;) {
		flag = 1;
		for(seg_ptr = 0; seg_ptr < seg_top; seg_ptr += LSIZE) {
			copy_seg(PSP, l1, square_seg, seg_ptr, LSIZE);
			if(longcmp(l1, num) > 0)		/* Out of range - abort */
				break;
			copy_seg(PSP, l1, prime_seg, seg_ptr, LSIZE);
			longcpy(l2, num);
			longdiv(l2, l1);
			if(!longtst(Longreg)) {			/* No remainder - not prime */
				flag = 0;
				break; } }
		if(flag) {
			printf("%s\n", lp(num));
			copy_seg(prime_seg, seg_top, PSP, num, LSIZE);
			longcpy(l1, num);				/* l1 = num */
			longmul(l1, num);				/* l1 = num*num */
			copy_seg(square_seg, seg_top, PSP, l1, LSIZE);
			if((seg_top += LSIZE) < LSIZE)	/* Segment overflow? */
				break; }
		longadd(num, two); }

	free_seg(prime_seg);
	free_seg(square_seg);
}
