;
; Cromemco Rdos Loader - Binary Transfer Stub
;
; This stub performs high-speed binary transfers to/from memory at
; the track buffer (T= ... normally 0200) and higher.
;
; You should not need to modify this loader unless you have a non-
; standard serial console.
;
; This is a relocatable module - use the RTLREL utility to add the
; Relocation tables - RTLREL will scan the .LST file and identify
; any JMP/CALL family instructions requiring relocation, however
; Any other 16-bit address instructions LDA/STA/LHLD/SHLD/LXI etc.
; which require relocation must be flagged in the source code with
; the character sequence '%%' occuring in the comment field.
;
; Transfer protocol consists of a single-byte command:
;	01-7F = Read memory page 01xx-7Fxx
;		Sends 256 bytes + 8-bit checksum
;	81-FF = Write memory page 01xx-7Fxx
;		Expects 256 bytes + 8-bit checksum
;		Then sends:
;			P = Checksum passed (success)
;			F = Checksum failed (retransmit)
;			T = Timeout waiting for character
;			X = Retry count exceeded, eXiting to RDOS
;	00    = Ignored
;	80    = Exit (return to RDOS)
;
; Assemble with DDS ASM85 assembler:
;   > ASM85 RTLOAD -f		<= Assemble (must have -F for listing)
;   > RTLREL RTLOAD		<= Convert to .RTL load file
;
; Dave Dunfield - April 19, 2005
;
	ORG	0		; Relocatable code MUST go at zero
;
	LXI	H,0		; Get zero
	DAD	SP		; Get RDOS stack
	SHLD	SAVSP		; Save RDOS stack	%%
REST:	LXI	SP,STACK	; Reset stack		%%
RECORD:	XRA	A		; Get zero
	MOV	L,A		; Zero low
	MOV	B,A		; Zero check
	CALL	RDC		; Read character
	MVI	C,5		; Retry count
	ANA	A		; Test type
	JZ	RECORD		; Ignore
	JM	WRITE		; Write to memory
; Read data from memory
READ:	MOV	H,A		; Set high address
REA1:	MOV	D,M		; Get data byte
	CALL	WRC		; Write it
	ADD	B		; Add character
	MOV	B,A		; Resave
	INR	L		; Skip to next
	JNZ	REA1		; Do them all
	MOV	D,B		; Get check character
	CALL	WRC		; Output
	JMP	RECORD		; Next record
; Write data to memory
WRITE:	ANI	$7F		; Strip high bit
	JZ	EXIT		; End of file
	MOV	H,A		; Set high address
WRI1:	CALL	RDC		; Read character
	MOV	M,A		; Write to memory
	ADD	B		; Add to checksum
	MOV	B,A		; Resave
	INR	L		; Advance to next
	JNZ	WRI1		; Move 256 bytes
	CALL	RDC		; Get character
	CMP	B		; Does it match?
	MVI	D,'P'		; Assume pass
	JZ	WRI2		; Correct!
	MVI	D,'F'		; Indicate failure
WRI2:	CALL	WRC		; Write it
	JMP	RECORD		; And continue
TERM:	MVI	D,'X'		; Indicate final
	CALL	WRC		; Display
EXIT:	LHLD	SAVSP		; Get saved SP		%%
	SPHL			; Reset SP
	RET
;
; Console port serial I/O routines
;
STAT	EQU	$00		; Console UART status register
DATA	EQU	$01		; Console UART data   register
RXRDY	EQU	$40		; Console UART receive  ready mask
TXRDY	EQU	$80		; Console UART transmit ready mask
;
; Write character D to serial console port (& return in A)
;
WRC	IN	STAT		; Read status
	ANI	TXRDY		; TX ready
	JZ	WRC		; Wait for it
	MOV	A,D		; Get data
	OUT	DATA		; Write it
	RET
;
; Read character A from serial console port (with timeout)
;
RDC:	LXI	D,0		; Timeout
rdc1:	IN	STAT		; Read status register
	ANI	RXRDY		; Character ready?
	JNZ	rdc2		; Yes, get it
	DCX	D		; Reduce count
	MOV	A,D		; Get high
	ORA	E		; Test with low
	JNZ	rdc1		; Keep waiting
	DCR	C		; End?
	JZ	TERM		; Yes - terminate
	MVI	D,'T'		; Timeout
	CALL	WRC		; Indicate
	JMP	REST		; Restore stack
rdc2:	IN	DATA		; Read data
	RET
;
; Reserved RTL memory
;
SAVSP	RMB	2		; Saved RDOS stack pointer
	RMB	30		; Reserve space for...
STACK	EQU	*		; Small local stack
