/*
 * Quick & dirty speed setup utility for APL2EM
 *
 * Compile with DDS Micro-C/PC, available from: www.dunfield.com
 * Compile command: cc APPLESPD -fop
 *
 * Dave Dunfield - March 2004
 */
#include <stdio.h>
#include <file.h>

#define	SIZE	54740		// Expected size of APPLE.EXE
#define	JOFFSET	0x4014		// Offset to jump to patch
#define	SOFFSET	0xD2A0		// Offset to speed count value

unsigned
	Seg,					// Working segment
	Size,					// Size of loaded file
	Speed;					// Requested speed

static unsigned char help[] = { "\
APL2EM is to fast on modern PC's. Keypad- slows it, but this is inadaquate\n\
because you need to press it over 1000 times on a fast PC, and you must do\n\
this every time you run the simulator.\n\n\
APPLESPD is a utility to allow you to set the initial speed value used by\n\
the simulator. The 'best/correct' value depends on how fast your PC is, and\n\
how fast you want the simulation to run. Higher values mean SLOWER speed.\n\
Here are some sample machines and suggested speed values when booted in\n\
pure DOS - multitasking systems will distort these values:\n\n\
	P166		- 105\n\
	P200MMX		- 600\n\
	K6-2-300	- 925\n\
	PIII/733	- 1150\n\
\nI have added the program APPLESPD to the APL2EM system disk. This program\n\
should output '*'s at a rate of one/second. Ie: one line = 40 seconds.\n\
Use this to guage the accuracy of your speed value. Note: LOAD the program\n\
and then RUN it so that disk load time is not included in run time.\n\
\n" };


main(int argc, char *argv[])
{
	int c;
	unsigned i;
	FILE *fp;

	fputs(help, stdout);				// Display help

	if(argc == 2) {						// Setting speed
		if(!(Speed = atoi(argv[1])))
			abort("Bad operand - use: APPLESPD 1-65535"); }

	IOB_size = 8192;

	if(!(Seg = alloc_seg(5096)))		// Allocate working segment
		abort("No memory");

	fp = fopen("APPLE.EXE", "rvqb");	// Read program file into memory
	while((c = getc(fp)) != EOF)
		poke(Seg, Size++, c);
	fclose(fp);

	if(Size != SIZE)					// Validate file by size
		abort("APPLE.EXE is incorrect size!");

	// Patch JM to JNZ if not already done
	c = peek(Seg, JOFFSET);
	if(c == 0x79)
		poke(Seg, JOFFSET, 0x75);
	else if(c != 0x75)
		abort("APPLE.EXE is corrupt!");

	// Display current speed value
	printf("Current speed value is: ");
	if(i = peekw(Seg, SOFFSET))
		printf("%u\n", i);
	else
		printf("Not set\n");

	// If speed supplied - write to image and save
	if(argc == 2) {
		pokew(Seg, SOFFSET, Speed);
		fp = fopen("APPLE.EXE", "wvqb");
		for(i=0; i < Size; ++i)
			putc(peek(Seg, i), fp);
		fclose(fp);
		printf("New speed value is: %u\n", Speed); }
}
