	Page	58,132
	Title	CPU.ASM 	CPU Initialization
;******************************************************************************
;
;   Name:	CPU.ASM 	CPU Initialization
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple ][
;	CPU initialization.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	CPU_Init		; CPU initialization routine
;
;  External Declarations
;
	Extrn	Get_Parameter:Near	; Get parameter routine       (SUPPORT)
	Extrn	Upper_Case:Near 	; Convert to upper case       (SUPPORT)
	Extrn	Match_Parameter:Near	; Match parameter routine     (SUPPORT)
	Extrn	Assignment:Near 	; Assignment test routine      (CONFIG)
	Extrn	Unknown:Near		; Unknown parameter routine    (CONFIG)
	Extrn	Noise:Near		; Skip noise routine	       (CONFIG)
	Extrn	Error:Near		; Apple emulator error routine	(APPLE)
	Extrn	Exit:Near		; Apple emulator exit routine	(APPLE)
	Extrn	Delimit_Input:Byte	; Input delimiter table 	(DATA)
	Extrn	Parm_Buffer:Byte	; Parameter buffer storage area  (DATA)
	Extrn	System_Flag:Byte	; Apple emulator system flag byte(DATA)
	Extrn	ERR_CPU_TYPE:Abs	; Invalid CPU type error code	 (DATA)
	Extrn	ERR_CPU_MODE:Abs	; Invalid CPU mode error code	 (DATA)
;
;  LOCAL Equates
;
MAX_INTERRUPT	Equ	08h		; Maximum interrupt count value
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include 	Strucs.inc	; Include the structure definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	CPU_Init	CPU Configuration
	Page	+
;******************************************************************************
;
;	CPU_Init(Position, Data, Buffer)
;
;		While there are more non-section parameters
;			If the parameter is non-null
;				Convert parameter to uppercase
;				Check for valid parameter
;				If unknown parameter value
;					Call the unknown parameter routine
;				Else
;					Call routine to handle this parameter
;				Endif
;			Else parameter is null
;				If delimiter type is comment
;					Call routine to skip the comment
;				Endif
;				If delimiter type is section
;					Exit the while loop
;				Endif
;			Endif
;		Endwhile
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Parse offset position
;		DS:SI - Pointer to configuration data (In 65C02 RAM Space)
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Parse position updated
;
;******************************************************************************
		Even			; Force procedure to even address
CPU_Init	Proc	Near		; CPU initialization procedure
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jc	CPU_Exit		; Jump if no more parameters
	jnz	Check_Parameter 	; Jump if a non-null parameter
Check_Type:
	test	ah,SECTION_TYPE 	; Check for section type delimiter
	jnz	CPU_Exit		; Jump if next section reached
	test	ah,COMMENT_TYPE 	; Check for a comment type delimiter
	jz	CPU_Init		; Jump if this is not a comment
	call	Noise			; Call routine to skip this noise
	jmp	Short CPU_Init		; Go continue the parsing
Check_Parameter:
	call	Upper_Case		; Call routine to convert to uppercase
	Save	ax,si,ds		; Save pointer to configuration data
	mov	bx,es			; Setup to access
	mov	ds,bx			;		  parameter match table
	lea	si,ds:[Match_Table]	; Get pointer to start of match table
	xchg	al,ah			; Save the actual parameter length
	lodsb				; Get the match table entry size (Bytes)
	xchg	al,ah			; Restore the actual parameter length
	call	Match_Parameter 	; Call routine to check for a match
	mov	bl,al			; Save the matching parameter number
	Restore ax,si,ds		; Restore pointer to configuration data
	jnc	Process_Parameter	; Jump if a parameter match was found
Parameter_Error:
	call	Unknown 		; Call the unknown parameter routine
	jmp	Short CPU_Exit		; Go return control to the caller
Process_Parameter:
	xor	bh,bh			; Convert match number to a full word
	shl	bx,1			; Convert match number to table index
	call	cs:[Jump_Table + bx]	; Call routine to handle this parameter
	jmp	Short Check_Type	; Loop till all parameters processed
CPU_Exit:
	dec	dx			; Correct the current parse position
	ret				; Return to the caller
CPU_Init	Endp			; End of the CPU_Init procedure
	Subttl	Set_CPU_Type	Set CPU Type Routine
	Page	+
;******************************************************************************
;
;	Set_CPU_Type(Position, Data, Buffer)
;
;		Call routine to check for parameter assignment
;		Call routine to get the next parameter (CPU Type)
;		If a valid (non-null) parameter is present
;			Call routine to convert parameter to uppercase
;			If this is a valid CPU type parameter
;				Default to normal CPU type value
;				If mixed CPU type was requested
;					Set the mixed CPU type flag
;				Endif
;			Else invalid CPU parameter type value
;				Set error code to invalid CPU type
;				Call routine to print error message
;				Call routine to exit the emulator
;			Endif
;		Else no CPU type given
;			Set error code to invalid CPU type
;			Call routine to print error message
;			Call routine to exit the emulator
;		Endif
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AH    - Last delimiter type found
;		BX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
Set_CPU_Type	Proc	Near		; Set CPU type procedure
	call	Assignment		; Call routine to check for assignment
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jbe	Type_Error		; Jump if no/null parameter was given
	call	Upper_Case		; Call routine to convert to uppercase
	Save	ax,si,ds		; Save pointer to configuration data
	mov	bx,es			; Setup to access
	mov	ds,bx			;		  CPU type match table
	lea	si,ds:[Type_Table]	; Get pointer to start of match table
	xchg	al,ah			; Save the actual parameter length
	lodsb				; Get the match table entry size (Bytes)
	xchg	al,ah			; Restore the actual parameter length
	call	Match_Parameter 	; Call routine to check for a match
	mov	bl,al			; Save the matching parameter number
	Restore ax,si,ds		; Restore pointer to configuration data
	jc	Type_Error		; Jump if no parameter match
	and	cs:[System_Flag],Not MIXED_CPU
	or	bl,bl			; Check for a normal CPU type value
	jz	Type_Exit		; Jump if CPU type is normal
	or	cs:[System_Flag],MIXED_CPU
	jmp	Short Type_Exit 	; Go return control to the caller
Type_Error:
	mov	al,ERR_CPU_TYPE 	; Set error code to invalid CPU type
	call	Error			; Call routine to print error message
	call	Exit			; Call routine to exit the emulator
Type_Exit:
	ret				; Return control to the caller
Set_CPU_Type	Endp			; End of the Set_Type procedure
	Subttl	Set_CPU_Mode	Set CPU Mode Routine
	Page	+
;******************************************************************************
;
;	Set_CPU_Mode(Position, Data, Buffer)
;
;		Call routine to check for parameter assignment
;		Call routine to get the next parameter (CPU Mode)
;		If a valid (non-null) parameter is present
;			Call routine to convert parameter to uppercase
;			If this is a valid CPU mode parameter
;				Default to normal CPU mode value
;				If enhanced CPU mode was requested
;					Set the enhanced CPU mode flag
;				Endif
;			Else invalid CPU parameter mode value
;				Set error code to invalid CPU mode
;				Call routine to print error message
;				Call routine to exit the emulator
;			Endif
;		Else no CPU mode given
;			Set error code to invalid CPU mode
;			Call routine to print error message
;			Call routine to exit the emulator
;		Endif
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AH    - Last delimiter type found
;		BX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
Set_CPU_Mode	Proc	Near		; Set CPU mode procedure
	call	Assignment		; Call routine to check for assignment
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jbe	Mode_Error		; Jump if no/null parameter was given
	call	Upper_Case		; Call routine to convert to uppercase
	Save	ax,si,ds		; Save pointer to configuration data
	mov	bx,es			; Setup to access
	mov	ds,bx			;		  CPU mode match table
	lea	si,ds:[Mode_Table]	; Get pointer to start of match table
	xchg	al,ah			; Save the actual parameter length
	lodsb				; Get the match table entry size (Bytes)
	xchg	al,ah			; Restore the actual parameter length
	call	Match_Parameter 	; Call routine to check for a match
	mov	bl,al			; Save the matching parameter number
	Restore ax,si,ds		; Restore pointer to configuration data
	jc	Mode_Error		; Jump if no parameter match
	and	cs:[System_Flag],Not ENHANCED_CPU
	or	bl,bl			; Check for a normal CPU mode value
	jz	Mode_Exit		; Jump if CPU mode is normal
	or	cs:[System_Flag],ENHANCED_CPU
	jmp	Short Mode_Exit 	; Go return control to the caller
Mode_Error:
	mov	al,ERR_CPU_MODE 	; Set error code to invalid CPU mode
	call	Error			; Call routine to print error message
	call	Exit			; Call routine to exit the emulator
Mode_Exit:
	ret				; Return control to the caller
Set_CPU_Mode	Endp			; End of the Set_Mode procedure
	Page
;******************************************************************************
;
;	Define the match and jump tables
;
;******************************************************************************
Match_Table	Equ	This Byte	; Start of the parameter match table
	Db	5			; Size of match table entries
	Db	4,"TYPE"                ; CPU type parameter string
	Db	4,"MODE"                ; CPU mode parameter string
	Db	0			; End of match table
Jump_Table	Equ	This Word	; Start of the parameter jump table
	Dw	Offset Set_CPU_Type	; Set CPU type routine address
	Dw	Offset Set_CPU_Mode	; Set CPU mode routine address
Type_Table	Equ	This Byte	; Start of the CPU type match table
	Db	7			; Size of match table entries
	Db	6,"NORMAL"              ; Normal CPU type string
	Db	5,"MIXED "              ; Mixed CPU type string
	Db	0			; End of match table
Mode_Table	Equ	This Byte	; Start of the CPU mode match table
	Db	9			; Size of match table entries
	Db	6,"NORMAL  "            ; Normal CPU mode string
	Db	8,"ENHANCED"            ; Enhanced CPU mode string
	Db	0			; End of match table
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the CPU module
