	Page	58,132
	Title	EMPTY.ASM	Empty Slot Routines
;******************************************************************************
;
;   Name:	EMPTY.ASM	Empty Slot Routines
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple
;	empty slots.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Empty_ID		; Empty slot ID string
	Public	Empty_Init		; Empty slot initialization routine
	Public	Empty_Ctrl		; Empty slot control routine
	Public	Empty_Rd		; Empty slot read routine
	Public	Empty_Wrt		; Empty slot write routine
	Public	Empty_Mem_Rd		; Empty slot memory read routine
	Public	Empty_Mem_Wrt		; Empty slot memory write routine
	Public	Empty_Exp_Rd		; Empty slot expansion read routine
	Public	Empty_Exp_Wrt		; Empty slot expansion write routine
	Public	Empty_Reset		; Empty slot reset routine
;
;  External Declarations
;
	Extrn	Get_Parameter:Near	; Get parameter routine       (SUPPORT)
	Extrn	Upper_Case:Near 	; Convert to upper case       (SUPPORT)
	Extrn	Match_Parameter:Near	; Match parameter routine     (SUPPORT)
	Extrn	Slot_Address:Near	; Get expansion slot address   (DEVICE)
	Extrn	Assignment:Near 	; Assignment test routine      (CONFIG)
	Extrn	Unknown:Near		; Unknown parameter routine    (CONFIG)
	Extrn	Noise:Near		; Skip noise routine	       (CONFIG)
	Extrn	Error:Near		; Apple emulator error routine	(APPLE)
	Extrn	Exit:Near		; Apple emulator exit routine	(APPLE)
	Extrn	Delimit_Input:Byte	; Input delimiter table 	 (DATA)
	Extrn	Parm_Buffer:Byte	; Parameter buffer storage area  (DATA)
	Extrn	System_Flag:Byte	; Apple emulator system flag byte(DATA)
	Extrn	ERR_NO_PARAMETER:Abs	; No valid parameter error code  (DATA)
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include 	Strucs.inc	; Include the structure definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	Empty_Init	Empty Slot Initialization
	Page	+
;******************************************************************************
;
;	Empty_Init(Data, Offset, Slot_Number)
;
;		Save the required registers
;		If configuration data is present
;			While not at the next section
;				Call routine to get the next parameter
;				If a valid parameter was given (non-null)
;					Set error code to no valid parameters
;					Call routine to print error code
;					Call routine to exit emulator
;				Else no/null parameter given
;					If a comment type parameter
;						Call routine to skip the comment
;					Elseif a section type parameter
;						Exit the while loop
;					Endif
;				Endif
;			Update the current parse position
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		AX    - Slot number (0 - 7)
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data (65C02 RAM segment)
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;		SI-DI - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Init	Proc	Near		; Empty slot initialization procedure
	Save	ds,es			; Save the required registers
	test	cs:[System_Flag],CONFIG_DATA
	jz	Empty_Exit		; Jump if no configuration data present
	mov	ax,cs			; Setup to access
	mov	es,ax			;		  the data tables
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	lea	di,es:[Parm_Buffer]	; Get pointer to parameter buffer
Empty_Loop:
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jc	Empty_Exit		; Jump if no more parameters
	jz	Check_Type		; Jump if a null type parameter
Empty_Error:
	mov	al,ERR_NO_PARAMETER	; Set error code to no valid parameters
	call	Error			; Call routine to print error message
	call	Exit			; Call routine to exit the emulator
Check_Type:
	test	ah,SECTION_TYPE 	; Check for the next section type
	jnz	Empty_Exit		; Jump if start of the next section
	test	ah,COMMENT_TYPE 	; Check for a comment type delimiter
	jz	Empty_Loop		; Jump if this is not a comment
	call	Noise			; Call routine to eat the comment
	jmp	Short Empty_Loop	; Loop till next section is found
Empty_Exit:
	dec	dx			; Update the current parse position
	Restore ds,es			; Restore the required registers
	ret				; Return to the caller
Empty_Init	Endp			; End of the Empty_Init procedure
	Subttl	Empty_Ctrl	Empty Slot Control
	Page	+
;******************************************************************************
;
;	Empty_Ctrl(RAM_Space, Slot_Number)
;
;		Return to the caller
;
;	Registers on Entry:
;
;		AX    - Slot number (0 - 7)
;		DS    - 65C02 RAM space
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Ctrl	Proc	Near		; Empty slot control procedure
	ret				; Return to the caller
Empty_Ctrl	Endp			; End of the Empty_Ctrl procedure
	Subttl	Empty_Rd	Empty Slot Read
	Page	+
;******************************************************************************
;
;	Empty_Rd(Effective_Address)
;
;		Read the memory location value (Byte)
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		AL    - Memory value
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Rd	Proc	Near		; Empty slot read procedure
	mov	al,ds:[di]		; Read the memory location
	ret				; Return to the caller
Empty_Rd	Endp			; End of the Empty_Rd procedure
	Subttl	Empty_Wrt	Empty Slot Write
	Page	+
;******************************************************************************
;
;	Empty_Wrt(Effective_Address)
;
;		Write value to memory location value (Byte)
;		Return to the caller
;
;	Registers on Entry:
;
;		AL    - Memory value
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Wrt	Proc	Near		; Empty slot write procedure
	mov	ds:[di],al		; Write the memory location
	ret				; Return to the caller
Empty_Wrt	Endp			; End of the Empty_Wrt procedure
	Subttl	Empty_Mem_Rd	Empty Slot Memory Read
	Page	+
;******************************************************************************
;
;	Empty_Mem_Rd(Effective_Address)
;
;		Read the memory location value (Byte)
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		AL    - Memory value
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Mem_Rd	Proc	Near		; Empty slot memory read procedure
	mov	al,ds:[di]		; Read the memory location
	ret				; Return to the caller
Empty_Mem_Rd	Endp			; End of the Empty_Mem_Rd procedure
	Subttl	Empty_Mem_Wrt	Empty Slot Memory Write
	Page	+
;******************************************************************************
;
;	Empty_Mem_Wrt(Effective_Address)
;
;		Write value to memory location value (Byte)
;		Return to the caller
;
;	Registers on Entry:
;
;		AL    - Memory value
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Mem_Wrt	Proc	Near		; Empty slot memory write procedure
	mov	ds:[di],al		; Write the memory location
	ret				; Return to the caller
Empty_Mem_Wrt	Endp			; End of the Empty_Mem_Wrt procedure
	Subttl	Empty_Exp_Rd	Empty Slot Expansion Read
	Page	+
;******************************************************************************
;
;	Empty_Exp_Rd(Effective_Address)
;
;		Read the memory location value (Byte)
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		AL    - Memory value
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Exp_Rd	Proc	Near		; Empty slot expansion read procedure
	mov	al,ds:[di]		; Read the memory location
	ret				; Return to the caller
Empty_Exp_Rd	Endp			; End of the Empty_Exp_Rd procedure
	Subttl	Empty_Exp_Wrt	Empty Slot Expansion Write
	Page	+
;******************************************************************************
;
;	Empty_Exp_Wrt(Effective_Address)
;
;		Return to the caller (Area is NOT writable)
;
;	Registers on Entry:
;
;		AL    - Memory value
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Exp_Wrt	Proc	Near		; Empty slot expansion write procedure
	ret				; Return to the caller
Empty_Exp_Wrt	Endp			; End of the Empty_Exp_Wrt procedure
	Subttl	Empty_Reset	Empty Slot Reset Routine
	Page	+
;******************************************************************************
;
;	Empty_Reset()
;
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Empty_Reset	Proc	Near		; Empty slot reset procedure
	ret				; Return to the caller
Empty_Reset	Endp			; End of the Empty_Reset procedure
	Page
;******************************************************************************
;
;	Define the empty slot data structures
;
;******************************************************************************
Empty_ID	Equ	This Byte	; Empty slot ID string
		Db	"Empty Slot",0
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Empty module
