//*****************************************************
//* Ami 99 - TI Emulator for Win32					  *
//* by M.Brent                                        *
//* Win32 WindowProc                                  *
//*****************************************************

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0400

#include <stdio.h>
#include <windows.h>
#include <malloc.h>

#include "resource.h"
#include "tiemul.h"

extern HDC tmpDC;
extern int timer9901;										// 9901 interrupt timer

/////////////////////////////////////////////////////////////////////////
// Window handler
/////////////////////////////////////////////////////////////////////////
LONG FAR PASCAL myproc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	// winuser.h has the VK_key key defines
	// also fill in the key[] array for on/off
    
	PAINTSTRUCT ps;
    HDC hDC;
	char szTemp[1024];
	float height;
	int i1;
	RECT myrect, myrect2;

	if (myWnd == hwnd) {	// Main TI window
		switch(msg) {
		case WM_INITMENUPOPUP:
			if (IsClipboardFormatAvailable(CF_TEXT)) {
				EnableMenuItem(GetMenu(myWnd), ID_EDITPASTE, MF_ENABLED | MF_BYCOMMAND);
				
			} else {
				EnableMenuItem(GetMenu(myWnd), ID_EDITPASTE, MF_GRAYED | MF_BYCOMMAND);
			}
			break;

		case WM_DISPLAYCHANGE:
			if (NULL != tmpDC) {
				DeleteDC(tmpDC);
				tmpDC=CreateCompatibleDC(NULL);
			}
			break;
		
		case WM_MOUSELEAVE:
			while (ShowCursor(true) < 0);	// show cursor
			break;

		case WM_PAINT:
			hDC = BeginPaint(hwnd, &ps);
			GetClientRect(myWnd, &myrect);
			if (StretchMode==0) {
				FillRect(hDC, &myrect, (HBRUSH)(COLOR_MENU+1));
			}
			SetEvent(BlitEvent);
			EndPaint(hwnd, &ps);
			break;

		case WM_DESTROY:
			quitflag=1;
			PostQuitMessage(0);
			break;
		
		case WM_KEYDOWN:
			key[wParam]=1;
			break;

		case WM_KEYUP:
			key[wParam]=0;
			break;

		case WM_SYSCHAR:
			// Don't remove this check, even if we need no ALT keys - otherwise all FCTN keys on the TI ding ;)
			// Fullscreen toggle - Alt-Enter
			if ((wParam==VK_RETURN)&&((lParam&0x8000)==0)) {
				if (3 == StretchMode) {
					StretchMode=2;
					takedownDirectDraw();
					SetupDirectDraw(false);
				} else {
					if ((2 == StretchMode) && (0 != FullScreenMode)) {
						StretchMode=3;
						takedownDirectDraw();
						SetupDirectDraw(FullScreenMode);
					}
				}
			}
			break;

		case WM_SYSKEYDOWN:				// returns from ALT and ALT+KEY (I use as FCTN)
			// some system keys we want Windows to process, namely F4 (close)
			if ((wParam != VK_F4) & (wParam != VK_RETURN))
			{	
				key[wParam]=1;
			}
			else
			{
				switch (wParam)
				{
				case VK_F4:
					quitflag=1;
					PostQuitMessage(0);
					break;
				
				default:
					return(DefWindowProc(hwnd, msg, wParam, lParam));
				}
			}
			break;

		case WM_SYSKEYUP:
			key[wParam]=0;
			break;

		case WM_COMMAND:
			switch (wParam)
			{
			case ID_HELP_ABOUT:
				sprintf(szTemp, "Classic99 %s\n(formerly known as Ami99)\nBy Mike Brent (Tursi)\n(c)1994-2002\n\nThanks to Roland Meier, Jeff Brown, Frank\nPalazolo and Ralph Nebet for assistance.\nThanks to Darrin and Stiletto\nfor encouragement.\n\nContains additional code by:\nFrank Palazolo - Speech (MAME)\nRalph Nebet - Speech Fixes (MESS)\nJohn Butler - 9900 Disasm (MAME)\nDerek Liauw Kie Fa - 2xSaI Renderer\n2xSaI code from the SNES9x project\n\ntursi@yiffco.com\nhttp://tursi.yiffco.com/games/classic99", VERSION);
				MessageBox(myWnd, szTemp, "Classic99 About", MB_OK);
				return 0;
				break;

			case ID_FILE_RESET:
				ST=(ST&0xfff0);							// disable interrupts
				memset(CRU, 1, 4096);					// reset 9901
				timer9901=0;
				WP=romword(0x0000);						// Reset = BLWP @>0000
				wrword(WP+26,0xffff);
				wrword(WP+28,PC);
				wrword(WP+30,ST);
				PC=romword(0x0002);
				grmaccess=0;		// No GROM Access yet
				vdpaccess=0;		// No VDP address writes yet 
				interrupt_needed=0;	// No interrupt missed yet
				break;

			case ID_FILE_QUIT:
				quitflag=1;
				PostQuitMessage(0);
				break;
			
			case ID_VIDEO_50HZ:
				if (hzRate == 60)
				{
					hzRate=50;
					CheckMenuItem(GetMenu(myWnd), ID_VIDEO_50HZ, MF_CHECKED);
				}
				else
				{
					hzRate=60;
					CheckMenuItem(GetMenu(myWnd), ID_VIDEO_50HZ, MF_UNCHECKED);
				}
				break;

			case ID_VIDEO_STARTRECORDING:
				if (Recording == 0)
				{
					debug_write("Starting AVI recording");
					if (0==InitAvi())
					{
						SetWindowText(myWnd, "Classic99 - Recording AVI");
						Recording=1;
						RecordFrame=0;
					}
				}
				break;
			
			case ID_VIDEO_STOPRECORDING:
				if (Recording)
				{
					debug_write("Stoping AVI recording");
					SetWindowText(myWnd, "Classic99");
					CloseAVI();
					Recording=0;
				}
				break;

			case ID_VIDEO_MAINTAINASPECT:
				if (MaintainAspect)
				{
					MaintainAspect=0;
					CheckMenuItem(GetMenu(myWnd), ID_VIDEO_MAINTAINASPECT, MF_UNCHECKED);
				}
				else
				{
					MaintainAspect=1;
					CheckMenuItem(GetMenu(myWnd), ID_VIDEO_MAINTAINASPECT, MF_CHECKED);
				}
				break;

			case ID_OPTIONS_PAUSEINACTIVE:
				if (PauseInactive)
				{
					PauseInactive=0;
					CheckMenuItem(GetMenu(myWnd), ID_OPTIONS_PAUSEINACTIVE, MF_UNCHECKED);
				}
				else
				{
					PauseInactive=1;
					CheckMenuItem(GetMenu(myWnd), ID_OPTIONS_PAUSEINACTIVE, MF_CHECKED);
				}
				break;

			case ID_OPTIONS_CPUTHROTTLING:
				if (CPUThrottle)
				{
					CPUThrottle=0;
					CheckMenuItem(GetMenu(myWnd), ID_OPTIONS_CPUTHROTTLING, MF_UNCHECKED);
				}
				else
				{
					CPUThrottle=1;
					CheckMenuItem(GetMenu(myWnd), ID_OPTIONS_CPUTHROTTLING, MF_CHECKED);
				}
				break;

			case ID_EDITPASTE:
				if (NULL != PasteString) {
					Beep(550,100);
					break;
				}
				if (OpenClipboard(myWnd)) {
					HANDLE data;

					data=GetClipboardData(CF_TEXT);

					if (data) {
						PasteString=(char*)malloc(strlen((char*)data)+1);
						strcpy(PasteString, (char*)data);
						PasteIndex=PasteString;
					}

					CloseClipboard();
				}
				break;

			case ID_VIDEO_STRETCHMODE_NONE:		// This mode is a fallback, it must not fail and must not loop back
				StretchMode=0;
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_NONE, MF_CHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DIB, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DX, MF_UNCHECKED);
				InvalidateRect(myWnd, NULL, false);
				break;

			case ID_VIDEO_STRETCHMODE_DIB:
				StretchMode=1;
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_NONE, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DIB, MF_CHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DX, MF_UNCHECKED);
				InvalidateRect(myWnd, NULL, false);
				break;

			case ID_VIDEO_STRETCHMODE_DX:
				StretchMode=2;
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_NONE, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DIB, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DX, MF_CHECKED);
				takedownDirectDraw();
				SetupDirectDraw(0);
				if (2 != StretchMode) {
					myproc(hwnd, WM_COMMAND, ID_VIDEO_STRETCHMODE_NONE, 0);
				} else {
					InvalidateRect(myWnd, NULL, false);
				}
				break;

			case ID_VIDEO_STRETCHMODE_DXFULL_320X240X8:
			case ID_VIDEO_STRETCHMODE_DXFULL_320X240X16:
			case ID_VIDEO_STRETCHMODE_DXFULL_320X240X24:
			case ID_VIDEO_STRETCHMODE_DXFULL_320X200X8:
			case ID_VIDEO_STRETCHMODE_DXFULL_640X480X8:
			case ID_VIDEO_STRETCHMODE_DXFULL_640X480X16:
			case ID_VIDEO_STRETCHMODE_DXFULL_640X480X24:
			case ID_VIDEO_STRETCHMODE_DXFULL_800X600X16:
			case ID_VIDEO_STRETCHMODE_DXFULL_800X600X24:
				StretchMode=3;
				FullScreenMode=wParam-ID_VIDEO_STRETCHMODE_DXFULL_320X240X8+1;
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_NONE, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DIB, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_STRETCHMODE_DX, MF_UNCHECKED);
				{for (DWORD idx=ID_VIDEO_STRETCHMODE_DXFULL_320X240X8; idx<ID_VIDEO_STRETCHMODE_DXFULL_800X600X24; idx++) {
					if (idx==wParam) {
						CheckMenuItem(GetMenu(myWnd), wParam, MF_CHECKED);
					} else {
						CheckMenuItem(GetMenu(myWnd), wParam, MF_UNCHECKED);
					}
				}}
				takedownDirectDraw();
				SetupDirectDraw(FullScreenMode);
				if (3 != StretchMode) {
					myproc(hwnd, WM_COMMAND, ID_VIDEO_STRETCHMODE_NONE, 0);
				} else {
					InvalidateRect(myWnd, NULL, false);
				}
				break;

			case ID_VIDEO_FILTERMODE_NONE:
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_NONE, MF_CHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_2XSAI, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPER2XSAI, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPEREAGLE, MF_UNCHECKED);
				if (FilterMode != 0) {
					ResizeBackBuffer(256+16, 192+16);
				}
				FilterMode=0;
				InvalidateRect(myWnd, NULL, false);
				break;

			case ID_VIDEO_FILTERMODE_2XSAI:
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_NONE, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_2XSAI, MF_CHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPER2XSAI, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPEREAGLE, MF_UNCHECKED);
				if (FilterMode == 0) {
					ResizeBackBuffer(512+32,384+29);
				}
				FilterMode=1;
				InvalidateRect(myWnd, NULL, false);
				break;

			case ID_VIDEO_FILTERMODE_SUPER2XSAI:
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_NONE, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_2XSAI, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPER2XSAI, MF_CHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPEREAGLE, MF_UNCHECKED);
				if (FilterMode == 0) {
					ResizeBackBuffer(512+32,384+29);
				}
				FilterMode=2;
				InvalidateRect(myWnd, NULL, false);
				break;

			case ID_VIDEO_FILTERMODE_SUPEREAGLE:
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_NONE, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_2XSAI, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPER2XSAI, MF_UNCHECKED);
				CheckMenuItem(GetMenu(myWnd), ID_VIDEO_FILTERMODE_SUPEREAGLE, MF_CHECKED);
				if (FilterMode == 0) {
					ResizeBackBuffer(512+32,384+29);
				}
				FilterMode=3;
				InvalidateRect(myWnd, NULL, false);
				break;

			default:
				return(DefWindowProc(hwnd, msg, wParam, lParam));

			}

		case WM_SIZE: {
				HDC myDC;
				
				if (MaintainAspect)
				{
					GetWindowRect(myWnd, &myrect);
					GetClientRect(myWnd, &myrect2);
					i1=((myrect.right - myrect.left)-(myrect2.right - myrect2.left))/2;
					myrect.left += i1;
					myrect.right = myrect.left + myrect2.right;
					myrect.bottom -= i1;
					myrect.top = myrect.bottom - myrect2.bottom;
					
					height=(float)((myrect.right - myrect.left) * 0.75);
					height-=(myrect.bottom - myrect.top);

					if (height)
					{
						GetWindowRect(myWnd, &myrect);
						myrect.bottom+=(long)height;
						MoveWindow(myWnd, myrect.left, myrect.top, myrect.right-myrect.left, myrect.bottom-myrect.top, true);
					}
				}

				if (0 == StretchMode) {
					GetClientRect(myWnd, &myrect);
					myDC=GetDC(myWnd);
					FillRect(myDC, &myrect, (HBRUSH)(COLOR_MENU+1));
					ReleaseDC(myWnd, myDC);
				}
				}
				break;

		case WM_MOUSEACTIVATE:
				SetEvent(BlitEvent);
				return(DefWindowProc(hwnd, msg, wParam, lParam));
				break;

		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
				if (3 == StretchMode) {
					StretchMode=2;
					takedownDirectDraw();
					SetupDirectDraw(false);
				}
				break;

		default:
			return(DefWindowProc(hwnd, msg, wParam, lParam));
		}
		return 0;
	}

	if ((hwnd==regWnd)||(hwnd==memWnd)||(hwnd==asmWnd)||(hwnd==dbgWnd)) {
		switch (msg) {
		case WM_DESTROY:
			if (hwnd==regWnd) regWnd=NULL;
			if (hwnd==memWnd) memWnd=NULL;
			if (hwnd==asmWnd) asmWnd=NULL;
			if (hwnd==dbgWnd) dbgWnd=NULL;
			break;

		default:
			return(DefWindowProc(hwnd, msg, wParam, lParam));
		}
		return 0;
	}

	return(DefWindowProc(hwnd, msg, wParam, lParam));
}
