/**********************************************************************************************

     TMS5220 interface

     Written for MAME by Frank Palazzolo
     With help from Neill Corlett
     Additional tweaking by Aaron Giles
     Speech ROM support and a few bug fixes by R Nabet
	 Modified by M.Brent for Classic 99

***********************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "tms5220.h"
#include "5220intf.h"
#include <allegro.h>

#define Byte unsigned char

extern Byte SPEECH[];
extern int drawspeed;

/* these describe the current state of the output buffer */
#define MIN_SLICE 100	/* minimum update step for TMS5220 */
static int sample_pos;
static int buffer_len;
static int emulation_rate;
static signed char *buffer;

extern struct TMS5220interface *intf;
extern SAMPLE *spl[];

struct TMS5220interface *intf;

extern SAMPLE *Speech;
SAMPLE *Speech, spch;
extern int voice[];


/* static function prototypes */
static void tms5220_update (int force);

/**********************************************************************************************

     tms5220_sh_start -- allocate buffers and reset the 5220

***********************************************************************************************/

int tms5220_sh_start (const struct TMS5220interface *intf)
{
	if (SPEECH[0] == 0xaa)		// is the speech synth ROM present?
	{
		tms5220_speechrom = &SPEECH[0];
		tms5220_speechROMlen = 0x8000;
	} else
	{
		tms5220_speechrom = NULL;
		tms5220_speechROMlen = 0;
		// speech may still work in some carts without the speech ROM
		// set up the header so that carts can detect it
		SPEECH[0]=0xaa;
	}

    /* determine the output sample rate and buffer size */
    buffer_len = intf->baseclock / 80 / (60/drawspeed);
    emulation_rate = buffer_len * (60/drawspeed);
    sample_pos = 0;
	
    /* start audio stream - buffer_len buffer, 8 bit, 8khz, max vol, center */
    /* note! this is unsigned mono, not signed. Routines modified accordingly */
	Speech=create_sample(8, 0, 8000, 40000);
	voice[4]=allocate_voice(Speech);
	voice_set_volume(voice[4],255);
	voice_start(voice[4]);

    /* reset the 5220 */
    tms5220_reset ();
    tms5220_set_irq (NULL);

    return 0;
}

/**********************************************************************************************

     tms5220_sh_stop -- free buffers

***********************************************************************************************/

void tms5220_sh_stop (void)
{
    if (Speech)
    {
		destroy_sample(Speech);
	}

    Speech = 0;
}



/**********************************************************************************************

     tms5220_sh_update -- update the sound chip

***********************************************************************************************/

void tms5220_sh_update (void)
{
    /* fill the buffer stream if it's time */

    tms5220_process (Speech->data, 40000);    /* fill new buffer */
}



/**********************************************************************************************

     tms5220_data_w -- write data to the sound chip

***********************************************************************************************/

void tms5220_data_w (int offset, int data)
{
    /* bring up to date first */
    tms5220_update (0);
    tms5220_data_write (data);
}



/**********************************************************************************************

     tms5220_status_r -- read status from the sound chip

***********************************************************************************************/

int tms5220_status_r (int offset)
{
    /* bring up to date first */
    tms5220_update (1);
    return tms5220_read ();
}



/**********************************************************************************************

     tms5220_ready_r -- return the not ready status from the sound chip

***********************************************************************************************/

int tms5220_ready_r (void)
{
    /* bring up to date first */
    tms5220_update (0);
    return tms5220_ready_read ();
}



/**********************************************************************************************

     tms5220_int_r -- return the int status from the sound chip

***********************************************************************************************/

int tms5220_int_r (void)
{
    /* bring up to date first */
    tms5220_update (0);
    return tms5220_int_read ();
}



/**********************************************************************************************

     tms5220_update -- update the sound chip so that it is in sync with CPU execution

***********************************************************************************************/

static void tms5220_update (int force)
{

/* this was all about filling the output buffer, so I'll just use the */
/* 'sh' update routine */

tms5220_sh_update();
}
