;
; NorthStar Transfer (NST) disk access client with embedded DOS
; For DOUBLE DENSITY controller
;
; This is a version of the NST client which includes the active
; portion of NorthStar DOS 5.0, so that you can make disk images
; even if you do not have a bootable NorthStar disk system.
; 
; You must supply host I/O functions to perform raw 8-bit serial
; data transfer with your console I/O hardware - please refer to
; the "Host I/O functions" section at the end of this file.
;
; NST permits comms parameters which are NOT 8-bit, however this
; is only for use with the UB and UH functions (if required) - all
; disk image transfer function (RS, RD, WS, WD) *REQUIRE* 8-bit
; serial I/O.
;
; This code MUST load into memory at address $2000, which is the
; origin of the NorthStar DOS image. Once loaded, you MUST launch
; it via a jump to $2900.
;
; The DBUF symbol defines a disk I/O buffer which is normally up to
; 32k in size, starting at $2C00 If you do not have enough memory for
; a 32k buffer, you can force NST to use a smaller buffer with the
; 'B=' option. If this option is not used, NST will attempt to pick
; an "optimal" buffer size which is an integral number of tracks that
; fits within 32k.
;
; Assemble with DDS ASM80 assembler: ASM80 NSTXD -T
;
; The resultant NSTXD.HEX file must be transferred to the NorthStar
; system - NST provides a 'UH' (Upload Hex) function which can do
; this by "typing the code in" to most debug monitors:
;
; Example loading under CP/M DDT:
;
;  Connect the PC serial port to the NorthStar system console port.
;
;  Execute the command: NST UH NSTX.HEX U=2'~s'~R  [C= if needed]
;  You will be presented with a terminal on the CP/M system.
;
;  Boot CP/M and get to the A> prompt.
;
;  Run DDT: DDT
;
;  Enter the DDT command: S2000
;  You should see a prompt with the first memory location.
;
;  Press F1 - NST will now "type in" the NSTXD disk stub code.
;
;  When it stops, press . then ENTER to return to the DDT prompt.
;
;  Enter the DDT command: G2900
;
;  The client should activate and you should see the message "NST"
;  displayed on the terminal. Press F10 to exit the upload terminal
;  function - you may now use NST to read and write disk images.
;
; Fixed EQU - DO NOT CHANGE for the NSTXD client
DOS	EQU	$2000		NorthStar DOS base address
DATA	EQU	$2BC0		NST Data area (64 bytes)
DBUF	EQU	$2C00		NST disk I/O buffer (32k)
;
; OS entry points - derived from 'DOS' above - should not be altered
DCOM	EQU	DOS+$22		Disk access subroutine
;
; Data storage
	ORG	DATA		Data area
SECTOR	DS	2		Sector number
UNIT	DS	1		Unit number
BLOCKS	DS	1		# vlocks
STACK	EQU	DATA+64		Stack position
; Active (saved from in-memory) NorthStar Double-Density DOS image
	ORG	DOS
	FCB	$22,$59,$59,$59,$00,$00,$01,$C9,$00,$00,$C3,$62,$20,$C3,$09,$29
	FCB	$C3,$0D,$29,$C3,$32,$29,$C3,$14,$29,$C3,$9F,$22,$C3,$26,$24,$C3
	FCB	$20,$23,$C3,$9E,$23,$C3,$5E,$26,$C3,$81,$22,$00,$C3,$79,$22,$80
	FCB	$01,$C6,$26,$18,$43,$4F,$50,$59,$52,$49,$47,$48,$A4,$21,$A4,$21
	FCB	$00,$21,$19,$21,$00,$1F,$A4,$21,$A4,$21,$00,$21,$19,$21,$00,$1F
	FCB	$01,$09,$01,$01,$63,$23,$81,$22,$01,$09,$00,$10,$A4,$21,$0A,$2A
	FCB	$FF,$2A,$31,$62,$20,$3E,$59,$32,$00,$20,$3E,$01,$32,$06,$20,$3E
	FCB	$04,$01,$81,$00,$11,$01,$05,$21,$00,$22,$CD,$83,$20,$C2,$62,$20
	FCB	$C3,$2F,$27,$F5,$E5,$79,$E6,$C0,$67,$3E,$14,$B8,$1F,$1F,$1F,$E6
	FCB	$20,$B4,$67,$79,$E6,$3F,$4F,$FE,$03,$DA,$9F,$20,$17,$E6,$0C,$B4
	FCB	$32,$FB,$26,$E1,$E5,$7B,$32,$FA,$26,$B7,$F2,$AF,$20,$1E,$00,$D5
	FCB	$C5,$CD,$B6,$21,$C1,$D1,$7B,$B7,$C2,$C5,$20,$3A,$20,$EB,$E6,$02
	FCB	$3E,$06,$C2,$27,$21,$D5,$C5,$21,$FF,$1F,$06,$00,$09,$7E,$EE,$59
	FCB	$E5,$CC,$48,$21,$E1,$F1,$CD,$48,$21,$2A,$FB,$26,$7E,$7D,$E6,$80
	FCB	$EE,$80,$4F,$EE,$80,$1F,$1F,$1F,$C6,$0F,$47,$D1,$E1,$F1,$3C,$F5
	FCB	$15,$D5,$C5,$C1,$D1,$14,$F1,$3D,$C8,$F5,$D5,$C5,$D5,$CD,$9F,$21
	FCB	$D1,$3A,$35,$EB,$E6,$0F,$BA,$C2,$FC,$20,$1D,$FA,$38,$22,$C2,$FD
	FCB	$21,$06,$8C,$11,$40,$EB,$CD,$83,$21,$3A,$10,$EB,$0F,$DA,$2B,$21
	FCB	$05,$C2,$19,$21,$3E,$01,$E1,$E1,$C1,$B7,$C9,$06,$00,$1A,$77,$A8
	FCB	$07,$47,$23,$37,$1A,$77,$A8,$07,$47,$23,$0D,$C2,$2D,$21,$1A,$A8
	FCB	$CA,$F3,$20,$3E,$02,$C3,$26,$21,$57,$96,$72,$C8,$21,$30,$EA,$4F
	FCB	$F2,$5F,$21,$2F,$3C,$4F,$3A,$20,$EB,$E6,$01,$C0,$21,$10,$EA,$3A
	FCB	$06,$20,$FE,$03,$DA,$6A,$21,$17,$E6,$0C,$B5,$F6,$10,$6F,$56,$EE
	FCB	$10,$6F,$56,$16,$02,$CD,$A1,$21,$3A,$25,$EB,$E6,$01,$C0,$0D,$C2
	FCB	$5F,$21,$C9,$3A,$10,$EB,$E6,$04,$CA,$83,$21,$E3,$E3,$E3,$E3,$E3
	FCB	$E3,$E3,$E3,$3A,$10,$EB,$17,$17,$A9,$3E,$05,$F8,$C3,$F9,$21,$16
	FCB	$01,$CD,$07,$20,$3A,$11,$EB,$3A,$10,$EB,$B7,$F2,$A7,$21,$15,$3A
	FCB	$11,$EB,$C8,$C3,$A1,$21,$CD,$9F,$21,$E6,$10,$3A,$15,$EB,$C2,$D2
	FCB	$21,$16,$30,$3A,$FB,$26,$B7,$F2,$CC,$21,$16,$17,$CD,$A1,$21,$C3
	FCB	$D7,$21,$3A,$06,$20,$B9,$C8,$79,$32,$06,$20,$16,$EA,$3A,$FB,$26
	FCB	$5F,$1A,$16,$02,$CD,$A1,$21,$06,$0C,$CD,$9F,$21,$3A,$10,$EB,$E6
	FCB	$40,$C0,$05,$C2,$E9,$21,$3E,$04,$C1,$C1,$C3,$26,$21,$06,$8C,$11
	FCB	$40,$EB,$CD,$83,$21,$3A,$10,$EB,$0F,$DA,$13,$22,$05,$C2,$05,$22
	FCB	$C3,$24,$21,$06,$00,$1A,$BE,$C2,$33,$22,$A8,$07,$47,$23,$1A,$BE
	FCB	$C2,$33,$22,$A8,$07,$47,$23,$0D,$C2,$15,$22,$1A,$A8,$CA,$F3,$20
	FCB	$C3,$43,$21,$3E,$03,$C3,$26,$21,$3A,$16,$EB,$3A,$15,$EB,$E6,$08
	FCB	$C2,$3B,$22,$3A,$00,$E9,$7F,$16,$E9,$05,$C2,$43,$22,$3A,$FB,$E9
	FCB	$3A,$FB,$26,$07,$D2,$5A,$22,$3A,$FB,$E9,$49,$B7,$7E,$5F,$A8,$07
	FCB	$47,$1A,$23,$7E,$5F,$A8,$07,$47,$1A,$23,$0D,$C2,$5C,$22,$58,$03
	FCB	$1A,$EB,$2A,$F9,$26,$19,$C3,$F3,$20,$06,$3F,$CD,$F7,$25,$CD,$FD
	FCB	$25,$31,$62,$20,$3A,$C3,$26,$B7,$CA,$E7,$2A,$11,$97,$22,$CD,$16
	FCB	$26,$CD,$00,$29,$C3,$00,$E8,$52,$45,$2D,$42,$4F,$4F,$54,$22,$F5
	FCB	$3E,$54,$CD,$11,$26,$F1,$C6,$30,$CD,$11,$26,$CD,$F5,$25,$3E,$44
	FCB	$CD,$11,$26,$79,$C6,$30,$CD,$11,$26,$CD,$F5,$25,$3E,$53,$CD,$11
	FCB	$26,$CD,$C3,$25,$C3,$7E,$22,$CD,$DC,$22,$DA,$2C,$20,$CD,$36,$24
	FCB	$DA,$2C,$20,$C9,$20,$20,$20,$20,$20,$20,$20,$20,$3E,$01,$32,$F5
	FCB	$26,$06,$08,$21,$F5,$26,$2B,$36,$20,$05,$C2,$E6,$22,$54,$5D,$CD
	FCB	$70,$26,$37,$C8,$FE,$20,$CA,$EF,$22,$FE,$2C,$37,$06,$08,$C8,$FE
	FCB	$20,$C8,$FE,$2C,$CA,$12,$23,$05,$37,$F8,$77,$23,$CD,$70,$26,$C3
	FCB	$FE,$22,$CD,$21,$26,$CD,$70,$26,$FE,$20,$C8,$FE,$0D,$C8,$37,$C9
	FCB	$3A,$2F,$20,$21,$F5,$26,$B6,$4F,$3A,$F7,$26,$6F,$26,$00,$06,$00
	FCB	$11,$00,$27,$3E,$01,$CD,$22,$20,$DA,$2C,$20,$C9,$7B,$B7,$CA,$46
	FCB	$23,$D1,$D1,$C3,$9F,$21,$3A,$2B,$20,$B7,$CA,$41,$23,$E1,$F1,$3A
	FCB	$C0,$26,$1E,$02,$32,$C0,$26,$3E,$0A,$F5,$E5,$D5,$C5,$3A,$C0,$26
	FCB	$CD,$83,$20,$32,$C2,$26,$78,$32,$C1,$26,$C1,$D1,$CA,$3C,$23,$E1
	FCB	$3A,$C2,$26,$FE,$04,$D2,$7D,$23,$F1,$3D,$C2,$59,$23,$2A,$C4,$26
	FCB	$F9,$3A,$C0,$26,$21,$C1,$26,$96,$82,$68,$26,$00,$29,$54,$5D,$29
	FCB	$29,$19,$85,$6F,$7C,$CE,$00,$67,$3A,$C2,$26,$C3,$19,$20,$E5,$21
	FCB	$04,$00,$39,$22,$C4,$26,$E1,$D5,$C5,$F5,$E5,$B7,$CA,$D6,$23,$11
	FCB	$A2,$FE,$19,$DA,$D6,$23,$5F,$16,$00,$1B,$19,$DA,$D6,$23,$79,$E6
	FCB	$7F,$FE,$01,$DA,$D6,$23,$FE,$05,$D2,$D6,$23,$78,$C6,$02,$FA,$D6
	FCB	$23,$FE,$05,$DA,$DC,$23,$E1,$F1,$C1,$D1,$37,$C9,$E1,$F1,$11,$F6
	FCB	$FF,$06,$FF,$04,$19,$DA,$E3,$23,$85,$D2,$18,$24,$CA,$18,$24,$67
	FCB	$7D,$C6,$0A,$57,$D6,$0B,$2F,$32,$C1,$26,$68,$22,$E6,$26,$E1,$22
	FCB	$E8,$26,$4D,$5C,$E1,$CD,$54,$23,$E5,$2A,$E8,$26,$E5,$2A,$E6,$26
	FCB	$7C,$45,$04,$2E,$F6,$C3,$E8,$23,$95,$F5,$7D,$C6,$0A,$57,$F1,$E1
	FCB	$5C,$4D,$E1,$C3,$54,$23,$22,$FD,$26,$32,$F5,$26,$7E,$FE,$20,$11
	FCB	$D4,$22,$C4,$E1,$22,$D8,$AF,$32,$F6,$26,$3E,$80,$32,$2F,$20,$21
	FCB	$04,$00,$22,$EB,$26,$01,$00,$04,$EB,$E5,$C5,$CD,$5E,$24,$C1,$D1
	FCB	$3A,$F5,$26,$C8,$0C,$05,$C2,$48,$24,$37,$2A,$EB,$26,$C9,$E5,$79
	FCB	$32,$F7,$26,$2A,$1A,$20,$E5,$21,$E3,$24,$22,$1A,$20,$21,$2F,$20
	FCB	$3A,$F5,$26,$B6,$4F,$3A,$F7,$26,$6F,$26,$00,$11,$00,$27,$06,$01
	FCB	$3E,$01,$CD,$22,$20,$E1,$22,$1A,$20,$06,$20,$3A,$2F,$20,$B7,$FA
	FCB	$94,$24,$06,$10,$21,$00,$27,$D1,$D5,$E5,$0E,$08,$3A,$F6,$26,$B7
	FCB	$C2,$F8,$24,$1A,$BE,$C2,$B2,$24,$13,$23,$0D,$C2,$A3,$24,$C1,$C1
	FCB	$AF,$C9,$E1,$E5,$7E,$FE,$20,$CA,$D6,$24,$C5,$11,$08,$00,$19,$CD
	FCB	$0C,$26,$4E,$23,$46,$EB,$09,$EB,$21,$EB,$26,$CD,$80,$26,$C1,$DA
	FCB	$D6,$24,$EB,$22,$EB,$26,$E1,$11,$10,$00,$19,$D1,$05,$C2,$98,$24
	FCB	$AF,$3C,$C9,$FE,$05,$E3,$22,$1A,$20,$E1,$C2,$19,$20,$3A,$2F,$20
	FCB	$EE,$80,$32,$2F,$20,$C3,$63,$24,$7E,$FE,$20,$CA,$D6,$24,$C5,$3A
	FCB	$EA,$26,$B7,$C2,$31,$25,$3A,$F8,$26,$B7,$CA,$31,$25,$3D,$C2,$2E
	FCB	$25,$E5,$11,$96,$25,$CD,$16,$26,$AF,$CD,$10,$20,$FE,$03,$CA,$2C
	FCB	$20,$FE,$0D,$C2,$18,$25,$CD,$FD,$25,$E1,$3A,$33,$20,$3D,$32,$F8
	FCB	$26,$46,$CD,$F7,$25,$23,$0D,$C2,$31,$25,$CD,$F5,$25,$CD,$0C,$26
	FCB	$E5,$EB,$CD,$C3,$25,$CD,$F5,$25,$E1,$CD,$0C,$26,$E5,$7E,$F5,$EB
	FCB	$B7,$F2,$55,$25,$29,$CD,$C3,$25,$CD,$F5,$25,$F1,$F5,$E6,$80,$06
	FCB	$53,$CA,$66,$25,$06,$44,$CD,$F7,$25,$CD,$F5,$25,$F1,$E6,$7F,$6F
	FCB	$26,$00,$CD,$C3,$25,$E1,$7E,$E6,$7F,$FE,$01,$C2,$89,$25,$CD,$F5
	FCB	$25,$23,$CD,$0C,$26,$EB,$CD,$AF,$25,$CD,$FD,$25,$CD,$16,$20,$C1
	FCB	$C2,$D6,$24,$C3,$2C,$20,$50,$52,$45,$53,$53,$20,$52,$45,$54,$55
	FCB	$52,$4E,$20,$54,$4F,$20,$43,$4F,$4E,$54,$49,$4E,$55,$45,$22,$11
	FCB	$00,$F0,$0E,$30,$CD,$D6,$25,$11,$00,$FF,$CD,$D6,$25,$11,$F0,$FF
	FCB	$C3,$CE,$25,$11,$9C,$FF,$0E,$30,$CD,$D6,$25,$11,$F6,$FF,$CD,$D6
	FCB	$25,$11,$FF,$FF,$0E,$FF,$06,$2F,$22,$C6,$26,$04,$19,$DA,$D8,$25
	FCB	$2A,$C6,$26,$78,$B9,$CA,$F5,$25,$0E,$FF,$FE,$3A,$DA,$F7,$25,$C6
	FCB	$07,$47,$C3,$F7,$25,$06,$20,$3A,$EA,$26,$C3,$0D,$20,$06,$0D,$CD
	FCB	$F7,$25,$06,$0A,$C3,$F7,$25,$73,$23,$72,$23,$C9,$5E,$23,$56,$23
	FCB	$C9,$47,$AF,$C3,$0D,$20,$1A,$FE,$22,$C8,$CD,$11,$26,$13,$C3,$16
	FCB	$26,$0E,$01,$CD,$70,$26,$CA,$3D,$26,$FE,$20,$CA,$21,$26,$D6,$30
	FCB	$DA,$2C,$20,$FE,$05,$D2,$2C,$20,$B7,$CA,$2C,$20,$4F,$79,$32,$F5
	FCB	$26,$C9,$2A,$FD,$26,$7E,$23,$FE,$20,$CA,$45,$26,$FE,$23,$3E,$00
	FCB	$C2,$5A,$26,$7E,$23,$22,$FD,$26,$E6,$07,$6F,$CD,$21,$26,$CD,$33
	FCB	$26,$7D,$32,$EA,$26,$3A,$33,$20,$32,$F8,$26,$3E,$01,$C3,$37,$24
	FCB	$E5,$2A,$FD,$26,$7E,$FE,$0D,$CA,$7E,$26,$23,$22,$FD,$26,$E1,$C9
	FCB	$23,$7A,$BE,$2B,$C0,$7B,$BE,$C9,$CD,$C7,$22,$4F,$CD,$0C,$26,$D5
	FCB	$CD,$0C,$26,$7E,$E6,$80,$B1,$4F,$7E,$E6,$7F,$23,$FE,$01,$C2,$2C
	FCB	$20,$7B,$F5,$CD,$0C,$26,$7A,$FE,$2A,$DA,$B4,$26,$FE,$2D,$D2,$B4
	FCB	$26,$32,$C3,$26,$F1,$E1,$D5,$06,$01,$CD,$22,$20,$2A,$FD,$26,$C9
	FCB	$01,$1F,$00,$00,$60,$20,$52,$44,$20,$33,$34,$39,$20,$31,$30,$30
	FCB	$30,$20,$31,$0D,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$00,$00,$00
	FCB	$00,$00,$00,$00,$00,$01,$01,$03,$0C,$00,$01,$A1,$EA,$D3,$26,$00
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
	FCB	$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
;
; Here we patch the DOS image (at assembly time) to reference our I/O functions
;
	ORG	DOS+$0D
	JMP	NOUT		; Character output
	JMP	NIN		; Character input
	JMP	HINIT		; I/O initialization
	JMP	NCTRLC		; Test for CTRL-C
	ORG	DOS+$19		; HDE handler
	JMP	RESET		; Disk Error
;
; Entry point
; Set up stack, initialize I/O and fall into the NST main loop
;
	ORG	DOS+$900
	DI			No interrupts
	LXI	SP,STACK	Init stack
	CALL	HINIT		Initialize host port
	LXI	H,HELLO		Point to startup message
	MOV	A,M		Get first character
IMSG1	INX	H		Advance
	CALL	PUTC		Display
	MOV	A,M		Get next character
	ANA	A		End of message?
	JNZ	IMSG1		No, display it all
; Command loop - wait for '$c' command and execute
TOP	LXI	SP,STACK	Reset stack
	CALL	GETC		Get command char
	CPI	'$'		Command lead-in?
	JNZ	TOP		No, wait for it
TOP1	CALL	GETC		Get command
; Read data from disk
tREAD	CPI	'R'		Read block
	JNZ	tWRITE		No, try next
	CALL	GDISK		Get disk read/write parameters
	LHLD	sector		HL = sector
	LXI	D,DBUF		DE = RAM buffer
	LDA	UNIT		Get unit
	MOV	C,A		C = unit
	MVI	B,1		Read operation
	LDA	BLOCKS		A = #blocks
	CALL	DCOM		Perform disk action
	JC	error		Report error
	CALL	PUTEQ		Indicator
	CALL	GSIZE		Get size
tr1	MOV	A,M		Read data byte
	CALL	PUTC		Write it
	INX	H		Skip to next
	ADD	C		Add to checksum
	MOV	C,A		Resave
	JNC	tr2		No carry
	INR	B		Carry in
tr2	DCX	D		Reduce count
	MOV	A,D		Get high
	ORA	E		Remaining data?
	JNZ	tr1		Do them all
	MOV	A,B		Get checksum
	CALL	PUTC		Write it
	MOV	A,C		Get checksum
putop	CALL	PUTC		Write it
	JMP	TOP
;
; Write data to disk
;
tWRITE	CPI	'W'		Write?
	JNZ	tGET		No, try next
	CALL	GDISK		Get disk parameters
	CALL	GSIZE		Get buffer size
	CALL	PUTEQ		Indicator
twr1	CALL	GETC		Get data
	MOV	M,A		Save it
	INX	H		Next position
	ADD	C		Add to checksum
	MOV	C,A		Resave
	JNC	twr2		No carry
	INR	B		Carry in
twr2	DCX	D		Reduce count
	MOV	A,D		Get high
	ORA	E		Any left?
	JNZ	twr1		Yes, do them all
	CALL	GETC		Get check H
	MOV	D,A		Save
	CALL	GETC		Get check L
	CMP	C		Match?
	JNZ	error		No, report error
	MOV	A,D		Get H
	CMP	B		Match H
	JNZ	error		Report error
	LHLD	sector		HL = sector
	LXI	D,DBUF		DE = RAM buffer
	LDA	UNIT		Get unit
	MOV	C,A		C = unit
	MVI	B,0		Write operation
	LDA	BLOCKS		A = #blocks
	CALL	DCOM		Perform disk action
	JC	error		Report error
pudot	MVI	A,'.'		Done flag
	JMP	putop		Output & exit
;
; Get byte from memory
tGET	CPI	'G'		Get?
	JNZ	tPUT		No, try next
	CALL	GMEM		Get DOS memory
	CALL	PUTEQ		Output indicator
	MOV	A,M		Get data
	JMP	putop		Output & exit
;
; Put a byte in memory
tPUT	CPI	'P'		Put?
	JNZ	tTEST		No, try next
	CALL	GMEM		Get DOS memory
	CALL	GETC		Get value
	MOV	M,A		Write value
	JMP	pudot		And exit
;
; Test for kernel present
;
tTEST	CPI	'$'		Entry again?
	JZ	TOP1		Wait for another
	CPI	'?'		Test1 ?
	JZ	pudot		handle it
	CPI	'T'		Test2 ?
	JNZ	ERROR		No, try next
	MVI	A,'*'		Response
	JMP	putop
;
; Error has occured
;
ERROR	MVI	A,'?'		Error indicator
	CALL	PUTC		Display it
RESET	CALL	GETC		Read character
	JMP	RESET		Till timeout & restart
;
; Get DOS memory address
;
GMEM	CALL	GETC		Read data
	MOV	H,A		Set high addess
	CALL	GETC		Read data
	MOV	L,A		Set low data
	LXI	D,DOS		DOS address
	DAD	D		Offset to DOS
	RET
;
; Get disk parameters from host
;
GDISK	CALL	GETC		Get data
	STA	UNIT		Set unit/density
	CALL	GETC		Get data
	STA	SECTOR+1	Set sector high
	CALL	GETC		Get data
	STA	SECTOR		Set sector low
	CALL	GETC		Get # blocks
	STA	BLOCKS		Save # blocks
	RET
;
; Get size of disk I/O buffer from saved parameters
;
GSIZE	LHLD	BLOCKS-1	H= # blocks
	MVI	L,0		Zero low (HL = blocks * 256)
	LDA	UNIT		Get unit
	ANI	$80		Double?
	JZ	gsize1		no - it's ok
	DAD	H		HL = blocks * 512
gsize1	XCHG			DE = size
	LXI	H,DBUF		Point to disk I/O buffer
	LXI	B,0		Zero BC
	RET
;
; Get character from host with timeout
;
GETC	PUSH	H		Save HL
	LXI	H,$3FFF		Init counter
getc1	CALL	TESTC		Check for character
	JNC	getc2		We have data
	DCR	L		Decrement counter
	JNZ	getc1		Keep going
	DCR	H		Decrement counter
	JNZ	getc1		Keep going
	JMP	TOP		Reset and restart
getc2	POP	H		Restore HL
	RET
;
; Write the '=' sign
;
PUTEQ	MVI	A,'='		Get indicator
	JMP	PUTC		And display
;
; NorthStar Character input function
NOUT	MOV	A,B
	JMP	PUTC
; NorthStar Character output function
NIN	CALL	TESTC
	JC	NIN
	RET
; NorthStar Test Ctrl-C function
NCTRLC	CALL	TESTC
	CPI	3
	RET
HELLO	STR	'NST'
	DB	$0A,$0D,0
;
;-------------------------------------------------------------
; Host I/O functions
;-------------------------------------------------------------
; These example functions are setup for a NorthStar Horizon.
; If required, modify them to suit your hardware. NOTE: They
; *MUST* perform 8-bit "raw" character I/O.
;
; --- DO NOT MODIFY ANY CODE ABOVE THIS LINE ---
;
; Write character in ACC to host - no registers may be modified
;
PUTC	PUSH	PSW		;Save ACC
putc1	IN	3		;Read status
	ANI	%00000001	;TX ready?
	JZ	putc1		;No, wait for it
	POP	PSW		;Restore ACC
	OUT	2		;Write to data port
	RET
;
; Test for character available from HOST
; If character is ready, return with C-flag clear and character in ACC
; If no character is ready, return with C-flag SET and ACC undefined
; No other registers may be modified.
;
TESTC	IN	3		;Read status
	ANI	%00000010	;RX ready?
	JZ	testc1		;No data
	IN	2		;Read data
	RET
testc1	STC			;Indicate no data
	RET
;
; Host initialization function
; Perform any initialization required to set the host port
; to 8-bit raw binary data mode - you may also wish to increase
; the baudrate for faster transfers.
; Called only once at NST startup - all registers may be modified.
HINIT	MVI	A,3		; Insure not setup mode
	OUT	3		; Write once
	OUT	3		; Write again (now in operate mode)
	MVI	A,%01110111	; Return to setup mode
	OUT	3		; write it
	MVI	A,%01001110	; 8 data, 1 stop, x10
	OUT	3		; Write it
	MVI	A,%00110111	; RTS,DTR,Enable RX,TX
	OUT	3		; Write it
	IN	2		; Clear pending
	IN	2		; Clear pending
	RET
