        TITLE Virtual Disk Format
        ;Copyright (C) 1993 Jeff Vavasour

        ASSUME CS:PROG,DS:PROG
PROG    SEGMENT 'CODE'
START:  MOV DI,129
        MOV DX,DI
        MOV BL,0
        MOV SI,DI
PARSE:  MOV AL,[DI]
        INC DI
        CMP AL,13
        JZ PARSE2
        CMP AL,32
        JNZ PARSE1
        INC SI
        CMP SI,DI
        MOV DX,DI
        JZ PARSE
        DEC SI
        JMP PARSE
PARSE1: CMP AL,'.'
        JNZ PARSE
        MOV BL,1
        JMP PARSE
PARSE2: DEC BL
        JZ PARSE3
        MOV WORD PTR [DI-1],442EH
        MOV WORD PTR [DI+1],4B53H
        ADD DI,4
PARSE3: MOV BYTE PTR [DI-1],0
        CMP SI,DX
        JZ PARSE5
        MOV CS:TRACKS,0
PARSE4: MOV BL,[SI]
        INC SI
        CMP BL,' '
        JZ PARSE5
        SUB BL,30H
        MOV AL,10
        MUL CS:TRACKS
        ADD AL,BL
        MOV CS:TRACKS,AL
        JMP PARSE4
PARSE5: CMP BYTE PTR CS:TRACKS,18
        JB BADCOUNT
        CMP BYTE PTR CS:TRACKS,80
        JA BADCOUNT
        MOV SI,DX
        MOV BX,OFFSET VNAME
PARSE6: MOV AL,[SI]
        CMP AL,'.'
        JZ PARSE7
        MOV CS:[BX],AL
        INC SI
        INC BX
        JMP PARSE6
PARSE7: MOV AX,3D00H
        INT 21H
        PUSHF
        MOV AH,3EH
        INT 21H
        POPF
        JB OK
        JMP REUSE
BADCOUNT:
        MOV AH,9
        PUSH CS
        POP DS
        MOV DX,OFFSET MSG2
        INT 21H
        MOV AX,4C00H
        INT 21H
REUSE:  MOV AH,9
        MOV DX,OFFSET MSG1
        PUSH CS
        POP DS
        INT 21H
        MOV AX,4C00H
        INT 21H
ERROR:  MOV AH,3EH
        INT 21H
        MOV AH,9
        MOV DX,OFFSET ERRMSG
        INT 21H
        MOV AX,4C00H
        INT 21H
OK:     MOV AH,3CH
        MOV CX,0
        INT 21H
        PUSH CS
        POP DS
        MOV HANDLE,AX
        JB ERROR
        MOV AH,0
        MOV AL,TRACKS
        MOV DH,10
        DIV DH
        ADD AX,3030H
        MOV NUMTRK,AX
        MOV DX,OFFSET MSG3
        MOV AH,9
        INT 21H
        MOV AH,2AH
        INT 21H
        SUB CX,1900
        MOV AX,CX
        MOV CL,10
        DIV CL
        ADD AX,3030H
        MOV YEAR,AX
        MOV AH,0
        MOV AL,DL
        DIV CL
        ADD AX,3030H
        MOV DAY,AX
        MOV AH,0
        MOV AL,DH
        DIV CL
        ADD AX,3030H
        MOV MONTH,AX
        MOV CX,OFFSET DIR-OFFSET BOOT
        MOV AH,40H
        MOV BX,HANDLE
        MOV DX,OFFSET BOOT
        INT 21H
        JNB NO_ERROR
ERRORA: JMP ERROR
NO_ERROR:
        MOV AX,4200H
        MOV CX,0
        MOV DX,0AA00H
        INT 21H
        MOV SI,OFFSET DIR
        MOV CL,TRACKS
        MOV CH,0
GAT:    MOV BYTE PTR [SI],0FCH
        MOV BYTE PTR [SI+96],0FCH
        INC SI
        LOOP GAT
        MOV DI,OFFSET EXTRAS
        MOV CX,1760
FILL:   MOV BYTE PTR [DI],0
        INC DI
        LOOP FILL
        MOV DIR,0FDH
        MOV DIR[17],0FFH
        MOV AH,40H
        MOV CX,2560
        MOV DX,OFFSET DIR
        INT 21H
        JB ERRORA
        MOV AH,3EH
        INT 21H
        MOV AH,9
        MOV DX,OFFSET MSG5
        INT 21H
        MOV AX,4C00H
        INT 21H

HANDLE  DW ?
TRACKS  DB 35
ERRMSG  DB 7,'Cannot open virtual disk by that name.',13,10
        DB 'Command format is "VFORMAT [<tracks>] <diskname>".$'
MSG1    DB 7,'Virtual disk exists.  Delete old .DSK file to format.$'
MSG2    DB 7,'Track count invalid.  Must be between 18 and 80.$'
MSG3    DB 'Formatting '
NUMTRK  DW 0
        DB ' tracks.',13,10,'$'
MSG5    DB 'Done.$'
BOOT    DB 0,0FEH,11H,21H,14H,42H,7EH,23H,0CDH,33H,0,0B7H,20H,0F8H,0CDH,49H
        DB 0,0C3H,0,0,1CH,1FH,'Non-system disk.',13,14,'Press any key to'
        DB ' reboot. ',0
DIR     DB 0CBH DUP(255)
        DB 2FH
        DW 0
        DW 42E0H
VNAME   DB 8 DUP(32)
MONTH   DW 0    
        DB '/'
DAY     DW 0
        DB '/'
YEAR    DW 0
        DB 13,31 DUP(32)
HIT     DB 0A2H,0C4H
        DB 254 DUP(0)
FDES    DB 5EH,0,0,0,0,'BOOT    SYS'
        DW 42E0H,42E0H,5,0,-1,-1,-1,-1
        DB 224 DUP(0)
        DB 5DH,0,0,0,0,'DIR     SYS'
        DW 42E0H,42E0H,10,0111H,-1,-1,-1,-1
EXTRAS  DB 0

PROG    ENDS
        END START
