//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <atl\atlvcl.h>

#include "ClockLabel_COM.h"
#include "AboutClockLabel.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

STDMETHODIMP TClockLabelXImpl::_set_Font(IFontDisp* Value)
{
  try
  {
     const DISPID dispid = -512;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     SetOleFont(m_VclCtl->Font, Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::AboutBox()
{
  try
  {
    ShowClockLabelXAbout();
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::ClassNameIs(BSTR string,
  VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->ClassNameIs(string);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Alignment(TxAlignment* Value)
{
  try
  {
    *Value = (TxAlignment)(m_VclCtl->Alignment);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_AutoSize(VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->AutoSize;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_BorderStyle(TxStaticBorderStyle* Value)
{
  try
  {
    *Value = (TxStaticBorderStyle)(m_VclCtl->BorderStyle);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Caption(BSTR* Value)
{
  try
  {
    *Value = WideString(m_VclCtl->Caption).Copy();
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Color(OLE_COLOR* Value)
{
  try
  {
    *Value = (OLE_COLOR)(m_VclCtl->Color);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Cursor(short* Value)
{
  try
  {
    *Value = (short)(m_VclCtl->Cursor);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_DragCursor(short* Value)
{
  try
  {
    *Value = (short)(m_VclCtl->DragCursor);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_DragMode(TxDragMode* Value)
{
  try
  {
    *Value = (TxDragMode)(m_VclCtl->DragMode);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Enabled(VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->Enabled;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Font(IFontDisp** Value)
{
  try
  {
    _di_IFontDisp Temp;
    GetOleFont(m_VclCtl->Font, Temp);
    Temp->AddRef();
    *Value = Temp;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_ParentColor(VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->ParentColor;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_ParentFont(VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->ParentFont;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_ShowAccelChar(VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->ShowAccelChar;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Visible(VARIANT_BOOL* Value)
{
  try
  {
    *Value = m_VclCtl->Visible;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Alignment(TxAlignment Value)
{
  try
  {
     const DISPID dispid = 1;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->Alignment = (TAlignment)(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_AutoSize(VARIANT_BOOL Value)
{
  try
  {
     const DISPID dispid = 2;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->AutoSize = Value;
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_BorderStyle(TxStaticBorderStyle Value)
{
  try
  {
     const DISPID dispid = 3;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->BorderStyle = (TStaticBorderStyle)(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Caption(BSTR Value)
{
  try
  {
     const DISPID dispid = -518;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->Caption = AnsiString(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Color(OLE_COLOR Value)
{
  try
  {
     const DISPID dispid = -501;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->Color = (TColor)(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Cursor(short Value)
{
  try
  {
     const DISPID dispid = 12;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->Cursor = (TCursor)(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_DragCursor(short Value)
{
  try
  {
     const DISPID dispid = 4;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->DragCursor = (TCursor)(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_DragMode(TxDragMode Value)
{
  try
  {
     const DISPID dispid = 5;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->DragMode = (TDragMode)(Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Enabled(VARIANT_BOOL Value)
{
  try
  {
     const DISPID dispid = -514;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->Enabled = Value;
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Font(IFontDisp* Value)
{
  try
  {
     const DISPID dispid = -512;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     SetOleFont(m_VclCtl->Font, Value);
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_ParentColor(VARIANT_BOOL Value)
{
  try
  {
     const DISPID dispid = 6;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->ParentColor = Value;
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_ParentFont(VARIANT_BOOL Value)
{
  try
  {
     const DISPID dispid = 7;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->ParentFont = Value;
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_ShowAccelChar(VARIANT_BOOL Value)
{
  try
  {
     const DISPID dispid = 8;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->ShowAccelChar = Value;
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Visible(VARIANT_BOOL Value)
{
  try
  {
     const DISPID dispid = 9;
     if (FireOnRequestEdit(dispid) == S_FALSE)
       return S_FALSE;
     m_VclCtl->Visible = Value;
     FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------


void __fastcall TClockLabelXImpl::ClickEvent(TObject *Sender)
{
  Fire_OnClick();
};
//---------------------------------------------------------------------------

void __fastcall TClockLabelXImpl::DblClickEvent(TObject *Sender)
{
  Fire_OnDblClick();
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_Active(VARIANT_BOOL* Value)
{
  try
  {
    *Value = FTimer->Enabled;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_ShowDate(VARIANT_BOOL* Value)
{
  try
  {
    *Value = FShowDate;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::get_UpdateInterval(long* Value)
{
  try
  {
    *Value = FTimer->Interval;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_Active(VARIANT_BOOL Value)
{
  try
  {
    const DISPID dispid = 19;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;

    FTimer->Enabled = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_ShowDate(VARIANT_BOOL Value)
{
  try
  {
    const DISPID dispid = 20;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;

    FShowDate = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------

STDMETHODIMP TClockLabelXImpl::set_UpdateInterval(long Value)
{
  try
  {
    const DISPID dispid = 21;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;

    FTimer->Interval = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};
//---------------------------------------------------------------------------
__fastcall TClockLabelXImpl::TClockLabelXImpl()
{
  FTimer = new TTimer(m_VclCtl);
  FTimer->Enabled = true;
  FTimer->Interval = 1000;
  FTimer->OnTimer = OnTimer;
  FShowDate = false;

  ShortDateFormat = "mm'/'dd'/'yyyy";
  LongTimeFormat = "hh:mm:ss";
  OnTimer(NULL);
}
//---------------------------------------------------------------------------
__fastcall TClockLabelXImpl::~TClockLabelXImpl()
{
  delete FTimer;
}
//---------------------------------------------------------------------------
void __fastcall TClockLabelXImpl::OnTimer(TObject* Sender)
{
  if (FShowDate)
    m_VclCtl->Caption = Date().DateString() + ", " + Time().TimeString();
  else
    m_VclCtl->Caption = Time().TimeString();
}
//---------------------------------------------------------------------------
HRESULT TClockLabelXImpl::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
  HRESULT hr = S_OK;
  hr = TVclComControl<TClockLabelXImpl,TStaticText>::IPersistStreamInit_Load(pStm,pMap);
  if (FAILED(hr))
    return hr;

  long lInterval;
  hr = pStm->Read(&lInterval, sizeof(long), NULL);
  if (FAILED(hr))
    return hr;
  set_UpdateInterval(lInterval);

  VARIANT_BOOL bActive;
  hr = pStm->Read(&bActive, sizeof(VARIANT_BOOL), NULL);
  if (FAILED(hr))
    return hr;
  set_Active(bActive);

  VARIANT_BOOL bShowDate;
  hr = pStm->Read(&bShowDate, sizeof(VARIANT_BOOL), NULL);
  if (FAILED(hr))
    return hr;
  set_ShowDate(bShowDate);

  return hr;
}
//---------------------------------------------------------------------------
HRESULT TClockLabelXImpl::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty,
    ATL_PROPMAP_ENTRY* pMap)
{
  HRESULT hr = S_OK;
  hr = TVclComControl<TClockLabelXImpl,TStaticText>::IPersistStreamInit_Save(
    pStm, fClearDirty, pMap);
  if (FAILED(hr))
    return hr;

  long lInterval;
  get_UpdateInterval(&lInterval);
  hr = pStm->Write(&lInterval, sizeof(long), NULL);
  if (FAILED(hr))
    return hr;

  VARIANT_BOOL bActive;
  get_Active(&bActive);
  hr = pStm->Write(&bActive, sizeof(VARIANT_BOOL), NULL);
  if (FAILED(hr))
    return hr;

  VARIANT_BOOL bShowDate;
  get_ShowDate(&bShowDate);
  hr = pStm->Write(&bShowDate, sizeof(VARIANT_BOOL), NULL);

  return hr;
}
//---------------------------------------------------------------------------

