//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <atl\atlvcl.h>

#include <initguid.h>
#include "ClockLabel_prop.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TClockLabelProperties *ClockLabelProperties;
//---------------------------------------------------------------------------
__fastcall TClockLabelProperties::TClockLabelProperties(Classes::TComponent *Component)
    : TPropertyPage(Component)
{
}
//---------------------------------------------------------------------------
void __fastcall TClockLabelProperties::UpdatePropertyPage(void)
{
  // Update your controls from OleObjects
  eInterval->Text = AnsiString(OleObject.OlePropertyGet("UpdateInterval"));
  cbActive->Checked = (OleObject.OlePropertyGet("Active"))? true : false;
  cbShowDate->Checked = (OleObject.OlePropertyGet("ShowDate"))? true : false;
}
//---------------------------------------------------------------------------
void __fastcall TClockLabelProperties::UpdateObject(void)
{
  // Update OleObjects from your controls
  int interval;
  try
  {
    interval = (int)eInterval->Text.ToDouble();
  }
  catch(...)
  {
    AnsiString mes = "Wrong interval value: " + eInterval->Text;
    Application->MessageBox(mes.c_str(),Caption.c_str(),MB_ICONHAND | MB_OK);
    return;
  }

  OleObject.OlePropertySet("UpdateInterval", interval);
  OleObject.OlePropertySet("Active", ((cbActive->Checked)? -1 : 0));
  OleObject.OlePropertySet("ShowDate", ((cbShowDate->Checked)? -1 : 0));
}
//---------------------------------------------------------------------------
