//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <atl\atlvcl.h>

#include "ClockLabelImpl.h"
#include "AboutClockLabel.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

STDMETHODIMP TClockLabelXImpl::_set_Font(IFontDisp** Value)
{
  try
  {
    const DISPID dispid = -512;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;
    SetVclCtlProp(m_VclCtl->Font, Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::AboutBox()
{
  try
  {
  ShowClockLabelXAbout();
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::DrawTextBiDiModeFlagsReadingOnly(
  long* Value)
{
  try
  {

  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Alignment(TxAlignment* Value)
{
  try
  {
   *Value = (TxAlignment)(m_VclCtl->Alignment);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_AutoSize(TOLEBOOL* Value)
{
  try
  {
   *Value = m_VclCtl->AutoSize;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_BorderStyle(TxStaticBorderStyle* Value)
{
  try
  {
   *Value = (TxStaticBorderStyle)(m_VclCtl->BorderStyle);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Caption(BSTR* Value)
{
  try
  {
    *Value = WideString(m_VclCtl->Caption).Copy();
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Color(::OLE_COLOR* Value)
{
  try
  {
   *Value = (::OLE_COLOR)(m_VclCtl->Color);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Cursor(short* Value)
{
  try
  {
   *Value = (short)(m_VclCtl->Cursor);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_DoubleBuffered(TOLEBOOL* Value)
{
  try
  {
   *Value = m_VclCtl->DoubleBuffered;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_DragCursor(short* Value)
{
  try
  {
   *Value = (short)(m_VclCtl->DragCursor);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_DragMode(TxDragMode* Value)
{
  try
  {
   *Value = (TxDragMode)(m_VclCtl->DragMode);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Enabled(TOLEBOOL* Value)
{
  try
  {
   *Value = m_VclCtl->Enabled;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Font(IFontDisp** Value)
{
  try
  {
    GetVclCtlProp(m_VclCtl->Font, Value);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_ParentColor(TOLEBOOL* Value)
{
  try
  {
   *Value = m_VclCtl->ParentColor;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_ShowAccelChar(TOLEBOOL* Value)
{
  try
  {
   *Value = m_VclCtl->ShowAccelChar;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::get_Visible(TOLEBOOL* Value)
{
  try
  {
   *Value = m_VclCtl->Visible;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::InitiateAction()
{
  try
  {

  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::IsRightToLeft(TOLEBOOL* Value)
{
  try
  {

  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Alignment(TxAlignment Value)
{
  try
  {
    const DISPID dispid = 1;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->Alignment = (TAlignment)(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_AutoSize(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 2;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->AutoSize = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_BorderStyle(TxStaticBorderStyle Value)
{
  try
  {
    const DISPID dispid = 3;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->BorderStyle = (TStaticBorderStyle)(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Caption(BSTR Value)
{
  try
  {
    const DISPID dispid = -518;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;
    m_VclCtl->Caption = AnsiString(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Color(::OLE_COLOR Value)
{
  try
  {
    const DISPID dispid = -501;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->Color = (TColor)(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Cursor(short Value)
{
  try
  {
    const DISPID dispid = 18;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->Cursor = (TCursor)(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_DoubleBuffered(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 9;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->DoubleBuffered = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_DragCursor(short Value)
{
  try
  {
    const DISPID dispid = 4;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->DragCursor = (TCursor)(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_DragMode(TxDragMode Value)
{
  try
  {
    const DISPID dispid = 5;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->DragMode = (TDragMode)(Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Enabled(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = -514;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->Enabled = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Font(IFontDisp* Value)
{
  try
  {
    const DISPID dispid = -512;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;
    SetVclCtlProp(m_VclCtl->Font, Value);
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_ParentColor(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 6;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->ParentColor = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_ShowAccelChar(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 7;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->ShowAccelChar = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::set_Visible(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 8;
    if (FireOnRequestEdit(dispid) == S_FALSE)
     return S_FALSE;
    m_VclCtl->Visible = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::UseRightToLeftReading(TOLEBOOL* Value)
{
  try
  {

  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};


STDMETHODIMP TClockLabelXImpl::UseRightToLeftScrollBar(TOLEBOOL* Value)
{
  try
  {

  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

void __fastcall TClockLabelXImpl::ClickEvent(TObject *Sender)
{
  Fire_OnClick();
};

void __fastcall TClockLabelXImpl::DblClickEvent(TObject *Sender)
{
  Fire_OnDblClick();
};

__fastcall TClockLabelXImpl::TClockLabelXImpl()
{
  FTimer = new TTimer(m_VclCtl);
  FTimer->Enabled = true;
  FTimer->Interval = 1000;
  FTimer->OnTimer = OnTimer;
  FShowDate = false;

  ShortDateFormat = "mm'/'dd'/'yyyy";
  LongTimeFormat = "hh:mm:ss";
  OnTimer(NULL);
}

__fastcall TClockLabelXImpl::~TClockLabelXImpl()
{
  delete FTimer;
}

void __fastcall TClockLabelXImpl::OnTimer(TObject* Sender)
{
  if (FShowDate)
    m_VclCtl->Caption = Date().DateString() + ", " + Time().TimeString();
  else
    m_VclCtl->Caption = Time().TimeString();
}

STDMETHODIMP TClockLabelXImpl::get_Active(TOLEBOOL* Value)
{
  try
  {
    *Value = FTimer->Enabled;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

STDMETHODIMP TClockLabelXImpl::get_ShowDate(TOLEBOOL* Value)
{
  try
  {
    *Value = FShowDate;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

STDMETHODIMP TClockLabelXImpl::get_UpdateInterval(long* Value)
{
  try
  {
    *Value = FTimer->Interval;
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

STDMETHODIMP TClockLabelXImpl::set_Active(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 23;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;

    FTimer->Enabled = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

STDMETHODIMP TClockLabelXImpl::set_ShowDate(TOLEBOOL Value)
{
  try
  {
    const DISPID dispid = 24;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;

    FShowDate = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

STDMETHODIMP TClockLabelXImpl::set_UpdateInterval(long Value)
{
  try
  {
    const DISPID dispid = 25;
    if (FireOnRequestEdit(dispid) == S_FALSE)
      return S_FALSE;

    FTimer->Interval = Value;
    FireOnChanged(dispid);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IClockLabelX);
  }
  return S_OK;
};

HRESULT TClockLabelXImpl::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
  HRESULT hr = S_OK;
  hr = TVclComControl<TClockLabelXImpl,TStaticText>::IPersistStreamInit_Load(pStm,pMap);
  if (FAILED(hr))
    return hr;

  long lInterval;
  hr = pStm->Read(&lInterval, sizeof(long), NULL);
  if (FAILED(hr))
    return hr;
  set_UpdateInterval(lInterval);

  TOLEBOOL bActive;
  hr = pStm->Read(&bActive, sizeof(TOLEBOOL), NULL);
  if (FAILED(hr))
    return hr;
  set_Active(bActive);

  TOLEBOOL bShowDate;
  hr = pStm->Read(&bShowDate, sizeof(TOLEBOOL), NULL);
  if (FAILED(hr))
    return hr;
  set_ShowDate(bShowDate);

  return hr;
}

HRESULT TClockLabelXImpl::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty,
    ATL_PROPMAP_ENTRY* pMap)
{
  HRESULT hr = S_OK;
  hr = TVclComControl<TClockLabelXImpl,TStaticText>::IPersistStreamInit_Save(
    pStm, fClearDirty, pMap);
  if (FAILED(hr))
    return hr;

  long lInterval;
  get_UpdateInterval(&lInterval);
  hr = pStm->Write(&lInterval, sizeof(long), NULL);
  if (FAILED(hr))
    return hr;

  TOLEBOOL bActive;
  get_Active(&bActive);
  hr = pStm->Write(&bActive, sizeof(TOLEBOOL), NULL);
  if (FAILED(hr))
    return hr;

  TOLEBOOL bShowDate;
  get_ShowDate(&bShowDate);
  hr = pStm->Write(&bShowDate, sizeof(TOLEBOOL), NULL);

  return hr;
}


