//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "FormClient.h"
#include "DialogConnection.h"
#include "DialogSendText.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TClientForm *ClientForm;
//---------------------------------------------------------------------------
__fastcall TClientForm::TClientForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ButtonOpenClick(TObject *Sender)
{
 if (DlgConnect->ShowModal() == mrOk)
 {
  MemoStatus->Lines->Clear();

  //if the client is already connected, we close the connection
  if (ClientSocket->Active == true)
    ClientSocket->Close();

  //At the least one of the following properties must be set
  if (!DlgConnect->EditAddress->Text.IsEmpty())
    ClientSocket->Address = DlgConnect->EditAddress->Text;
  else
    ClientSocket->Host    = DlgConnect->EditName->Text;
  //At the least one of the following properties must be set
  if (!DlgConnect->EditPort->Text.IsEmpty())
    ClientSocket->Port    = DlgConnect->EditPort->Text.ToInt();
  else
    ClientSocket->Service = DlgConnect->EditService->Text;

  //Ok, now we try to connect with the specified server
  ClientSocket->Open();
 }
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ClientSocketError(TObject *Sender,
      TCustomWinSocket *Socket, TErrorEvent ErrorEvent, int &ErrorCode)
{
 switch (ErrorEvent)
 {
  case eeSend:
    MemoStatus->Lines->Add ("Client Error> An error occurred during a write operation.");
    break;
  case eeReceive:
    MemoStatus->Lines->Add ("Client Error> An error occurred during a read operation.");
    break;
  case eeConnect:
    MemoStatus->Lines->Add ("Client Error> Impossible to connecth with the server.");
    break;
  case eeDisconnect:
    MemoStatus->Lines->Add ("Client Error> An error occurred when trying to close the connection.");
  case eeAccept:
    MemoStatus->Lines->Add ("Client Error> An error occurred when accepting the a connection request.");
    break;
  default:
    MemoStatus->Lines->Add ("Client Error> Unkwon error.");    
 }
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ButtonCloseClick(TObject *Sender)
{
 if (ClientSocket->Active == false)
   ShowMessage ("Connection already closed.");
 else
    ClientSocket->Close();
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ClientSocketLookup(TObject *Sender,
      TCustomWinSocket *Socket)
{
 MemoStatus->Lines->Add ("Client is looking for the server....");
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ClientSocketConnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
 MemoStatus->Lines->Add ("Connection established with server " +
                         Socket->RemoteHost +
                         " (" + Socket->RemoteAddress + ") on port " +
                         Socket->RemotePort);         
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ClientSocketDisconnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
 MemoStatus->Lines->Add ("Connection closed.");
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ClientSocketRead(TObject *Sender,
      TCustomWinSocket *Socket)
{
 AnsiString msg;

 msg = Socket->ReceiveText();
 MemoStatus->Lines->Add ("Server msg> " + msg);
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::ButtonSendClick(TObject *Sender)
{
 if (DlgSend->ShowModal() == mrOk)
 {
   ClientSocket->Socket->SendText (DlgSend->EditMessage->Text);
   MemoStatus->Lines->Add ("Message sent.");
 }
}
//---------------------------------------------------------------------------
void __fastcall TClientForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
 if (ClientSocket->Active)
        ClientSocket->Close();
}
//---------------------------------------------------------------------------
