//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "FormServer.h"
#include "DialogListen.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TServerForm *ServerForm;
//---------------------------------------------------------------------------
__fastcall TServerForm::TServerForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::ButtonListenClick(TObject *Sender)
{
 if (DlgListen->ShowModal() == mrOk)
 {
  //shut down the server if active
  if (ServerSocket->Active == true)
    ServerSocket->Close();

  if (!DlgListen->EditPort->Text.IsEmpty())
    ServerSocket->Port = DlgListen->EditPort->Text.ToInt();
  else
    ServerSocket->Service = DlgListen->EditService->Text;

  ServerSocket->Open();
 }
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::ServerSocketListen(TObject *Sender,
      TCustomWinSocket *Socket)
{
 MemoStatus->Lines->Add ("Server is listening on port " +
                         (String) Socket->LocalPort +
                         " for client requests.");               
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::ServerSocketClientConnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
 MemoStatus->Lines->Add ("Connection established with client " +
                        (String) Socket->RemoteHost +
                        " (" + Socket->RemoteAddress + ") " +
                        " on port " + Socket->RemotePort);
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::ServerSocketClientDisconnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
 MemoStatus->Lines->Add ("Client " +
                        Socket->RemoteHost +
                        " (" + Socket->RemoteAddress +
                        ") disconnected.");
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::ServerSocketClientRead(TObject *Sender,
      TCustomWinSocket *Socket)
{
 AnsiString msg = Socket->ReceiveText();
 MemoStatus->Lines->Add ("Client (" + (String) Socket->RemotePort + ") msg> " +
                         msg);

 //test message
 if (msg == "Are you there?")
        Socket->SendText ("Yes!");
 else if (msg == "What time is it?")
        Socket->SendText (Time().TimeString());
 else if (msg == "Close my connection")
        {
         Socket->SendText ("Closing connection");
         Socket->Close();
        }
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
 if (ServerSocket->Active)
        ServerSocket->Close();        
}
//---------------------------------------------------------------------------
void __fastcall TServerForm::ButtonCloseClick(TObject *Sender)
{
 if (ServerSocket->Active)
        ServerSocket->Close();
 else
        ShowMessage ("Server already closed");
}
//---------------------------------------------------------------------------
