#include <vcl.h>
#pragma hdrstop

#include "ChangeNotification.h"

const DWORD flags = FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME;

__fastcall TChangeNotification::TChangeNotification(TComponent *owner) : TComponent(owner)
   {
   onChange = 0;
   onError = 0;
   thread = 0;
   watchSubFolders = false;
   }

__fastcall TChangeNotification::~TChangeNotification()
   {
   delete thread;
   }

void __fastcall TChangeNotification::Start()
   {
   if (thread == 0) thread = new TCNThread(this);
   }

void __fastcall TChangeNotification::Stop()
   {
   delete thread;
   thread = 0;
   }

void __fastcall TChangeNotification::SetFolder(String aFolder)
   {
   if (thread != 0)
      {
      Stop();
      folder = aFolder;
      Start();
      }
   else
      folder = aFolder;
   }

void __fastcall TChangeNotification::SetOnChange(TNotifyEvent event)
   {
   if (thread != 0)
      {
      thread->Suspend();
      onChange = event;
      thread->Resume();
      }
   else
      onChange = event;
   }

void __fastcall TChangeNotification::SetOnError(TNotifyEvent event)
   {
   if (thread != 0)
      {
      thread->Suspend();
      onError = event;
      thread->Resume();
      }
   else
      onError = event;
   }

void __fastcall TChangeNotification::SetWatchSubFolders(bool watch)
   {
   if (thread != 0)
      {
      Stop();
      watchSubFolders = watch;
      Start();
      }
   else
      watchSubFolders = watch;
   }


// -------------------------------------------------------------------------------------------------

__fastcall TChangeNotification::TCNThread::TCNThread(TChangeNotification *owner) : TThread(false), owner(owner)
   {
   handle = 0;
   }

__fastcall TChangeNotification::TCNThread::~TCNThread()
   {
   Terminate();

   if (handle != 0)
      {
      FindCloseChangeNotification(handle);
      handle = 0;
      }
   }

void __fastcall TChangeNotification::TCNThread::Execute()
   {
   handle = FindFirstChangeNotification(owner->Folder.c_str(), owner->WatchSubFolders, flags);

   if (handle == INVALID_HANDLE_VALUE)
      {
      Synchronize(Error);
      Terminate();
      }

   while (!Terminated)
      {
      DWORD status = WaitForSingleObject(handle, INFINITE);

      if (status == WAIT_OBJECT_0 && Terminated == false)
         {
         Synchronize(Notify);
         if (FindNextChangeNotification(handle) == 0)
            {
            Synchronize(Error);
            Terminate();
            }
         }
      else
         Terminate();
      }
   }

void __fastcall TChangeNotification::TCNThread::Notify(void)
   {
   if (owner->OnChange) owner->OnChange(owner);
   }

void __fastcall TChangeNotification::TCNThread::Error(void)
   {
   if (owner->OnError) owner->OnError(owner);
   }


// -------------------------------------------------------------------------------------------------

static inline void ValidCtrCheck(TChangeNotification *)
   {
   new TChangeNotification(NULL);
   }


#pragma package(smart_init)

