#ifndef ChangeNotificationH
#define ChangeNotificationH

#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>


class PACKAGE TChangeNotification : public TComponent
   {
   __published:
      __property TNotifyEvent OnChange = {read = onChange, write = SetOnChange};
      __property TNotifyEvent OnError = {read = onError, write = SetOnError};
      __property bool WatchSubFolders = {read = watchSubFolders, write = SetWatchSubFolders};
      __property String Folder = {read = folder, write = folder};

   public:
      __fastcall TChangeNotification(TComponent *owner);
      __fastcall ~TChangeNotification();

      void __fastcall Start();
      void __fastcall Stop();

   private:
      void __fastcall SetOnChange(TNotifyEvent event);
      void __fastcall SetOnError(TNotifyEvent event);
      void __fastcall SetWatchSubFolders(bool watch);
      void __fastcall SetFolder(String aFolder);

      TNotifyEvent onChange;
      TNotifyEvent onError;
      bool watchSubFolders;
      String folder;

      class TCNThread : public TThread
         {
         friend TChangeNotification;

         public:
            __fastcall TCNThread(TChangeNotification *owner);
            __fastcall ~TCNThread();

            void __fastcall Execute();
            void __fastcall Notify(void);
            void __fastcall Error(void);

         private:
            TChangeNotification *owner;
            HANDLE handle;
         } *thread;
   };

#endif   // ChangeNotificationH

