#include <vcl.h>
#pragma hdrstop

#include <FileCtrl.hpp>

#include "Main.h"

#pragma package(smart_init)
#pragma link "ChangeNotification"
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   errorState = false;
   Application->OnIdle = OnIdle;
   }

void __fastcall TMainForm::Log(String text)
   {
   text.Insert(Now().DateTimeString() + " - ", 1);
   ChangesEdit->Lines->Add(text);
   }

void __fastcall TMainForm::CloseBtnClick(TObject *Sender)
   {
   Close();
   }

void __fastcall TMainForm::ChangeNotificationError(TObject *Sender)
   {
   Log("Unknown Error");
   String msg = "Unable to monitor changes to folder \"" + ChangeNotification->Folder + "\".";
   Application->MessageBox(msg.c_str(), Application->Title.c_str(), MB_OK | MB_ICONWARNING);
   errorState = true;
   }

void __fastcall TMainForm::ChangeNotificationChange(TObject *Sender)
   {
   String msg = "Change to " + ChangeNotification->Folder;
   if (ChangeNotification->WatchSubFolders) msg += " or a subfolder";
   Log(msg);
   }

void __fastcall TMainForm::ClearBtnClick(TObject *Sender)
   {
   ChangesEdit->Clear();
   }

void __fastcall TMainForm::StartBtnClick(TObject *Sender)
   {
   StartBtn->Enabled = false;
   StopBtn->Enabled = true;

   ChangeNotification->Folder = FolderLabel->Caption;
   ChangeNotification->WatchSubFolders = SubFoldersChk->Checked;
   ChangeNotification->Start();
   Log("Started");
   }

void __fastcall TMainForm::StopBtnClick(TObject *Sender)
   {
   ChangeNotification->Stop();
   Log("Stopped");

   StartBtn->Enabled = true;
   StopBtn->Enabled = false;
   }

void __fastcall TMainForm::FolderBtnClick(TObject *Sender)
   {
   String folder;
   if (SelectDirectory("Select Folder", "C:\\", folder))
      {
      FolderLabel->Caption = folder;
      ChangeNotification->Folder = folder;
      }
   }

void __fastcall TMainForm::SubFoldersChkClick(TObject *Sender)
   {
   ChangeNotification->WatchSubFolders = SubFoldersChk->Checked;
   }

void __fastcall TMainForm::OnIdle(TObject *Sender, bool &Done)
   {
   if (errorState)
      {
      StopBtnClick(Sender);
      errorState = false;
      }
   }
