
/***************************************************************************
                          bitmapprinter.h
                          -----------------
    begin                : February, 2001
    author               : Damon Chandler
    email                : dmc27@cornell.edu
    
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//---------------------------------------------------------------------------
#ifndef BITMAP_PRINTER_H
#define BITMAP_PRINTER_H
//---------------------------------------------------------------------------

#include <vcl.h>
#include <stdexcept>
//-----------------------------------------------------------------------

typedef std::runtime_error EBitmapPrinterError;
enum TBitmapPrinterScale {bpsHorz, bpsVert, bpsPage, bpsCustom};

class TBitmapPrinter : public TObject
{
public:
   __fastcall TBitmapPrinter();
   __fastcall ~TBitmapPrinter();

   // main printing member function   
   void __fastcall PrintBitmap(HDC hPrinterDC)
      { DoPrintBitmap(hPrinterDC); }

   // sets the TBitmap to print      
   __property const Graphics::TBitmap* Bitmap =
      { write = DoSetBitmap };

   // gets/sets the target printing rectangle
   __property RECT PrintRect =
      { read = RPrint_, write = DoSetRect };

   // gets/sets the scaling options
   __property TBitmapPrinterScale PrintScale =
      { read = scale_, write = DoSetScale };

protected:
   // main printing member functions
   virtual void __fastcall DoPrintBitmap(HDC hPrinterDC);
   virtual void __fastcall DoInternalPrintBitmap(HDC hPrinterDC);

   // gets/sets class properties
   virtual void __fastcall DoSetBitmap(const Graphics::TBitmap* Bitmap);
   virtual void __fastcall DoSetRect(RECT RPrint);
   virtual void __fastcall DoSetScale(TBitmapPrinterScale scale);

   // internal utility member functions
   virtual LPBITMAPINFO __fastcall DoCreateDIB(
      const Graphics::TBitmap& Bitmap, unsigned char*& pBits);
   virtual void __fastcall DoCalculatePrintRect(HDC hPrinterDC);
   virtual bool __fastcall DoCalculateBand(RECT& RBand, RECT& RImage);

private:
   // pointer to the header and color table
   LPBITMAPINFO pDIB_;
   // pointer to the pixels
   unsigned char* pBits_;
   // handle to the bitmap's logical palette
   HPALETTE hPal_;
   // target printing rectangle   
   RECT RPrint_;
   // scaling options
   TBitmapPrinterScale scale_;
};

//---------------------------------------------------------------------------
#endif  // BITMAP_PRINTER_H
//---------------------------------------------------------------------------
