//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
  MyTrackBar = new TMyTrackBar(this);
  MyTrackBar->Parent = Panel1;
  MyTrackBar->SetBounds(10, 10, 380, 50);
  MyTrackBar->Max = 40;  
  MyTrackBar->ThumbLength = 30;
  MyTrackBar->TickMarks = tmBoth;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::WMNotify(TMessage& Msg)
{
  // grab a pointer to NMHDR struct
  LPNMHDR pnmh = reinterpret_cast<LPNMHDR>(Msg.LParam);

  //
  // if the notification message is
  // NM_CUSTOMDRAW and from our trackbar
  //
  if (pnmh->code == NM_CUSTOMDRAW &&
      pnmh->hwndFrom == TrackBar->Handle)
  {
    // grab a pointer to NMCUSTOMDRAW
    LPNMCUSTOMDRAW pDraw =
      reinterpret_cast<LPNMCUSTOMDRAW>(Msg.LParam);

    // test the drawing stage...
    switch (pDraw->dwDrawStage)
    {
      // before anything is drawn...
      case CDDS_PREPAINT:
      {
        //
        // tell the trackbar to notify us
        // before it draws its elements
        //
        Msg.Result = CDRF_NOTIFYITEMDRAW;
        return;
      }

      // before an element is drawn...
      case CDDS_ITEMPREPAINT:
      {
        // if we're drawing the channel
        if (pDraw->dwItemSpec == TBCD_CHANNEL)
        {
          std::auto_ptr<TCanvas>
            tbCanvas(new TCanvas());
          TRect Rect = pDraw->rc;            

          // render the background image
          tbCanvas->Handle = pDraw->hdc;
          tbCanvas->StretchDraw(
            Rect, Image1->Picture->Graphic);
          tbCanvas->Handle = NULL;            

          // draw the channel's edge
          DrawEdge(
             pDraw->hdc, &pDraw->rc,
             EDGE_SUNKEN, BF_RECT);

          // tell the trackbar we
          // drew the channel manually
          Msg.Result = CDRF_SKIPDEFAULT;
          return;
        }

        // if we're drawing the thumb
        if (pDraw->dwItemSpec == TBCD_THUMB)
        {
          std::auto_ptr<TCanvas>
            tbCanvas(new TCanvas());
          TRect Rect = pDraw->rc;

          // render the background image
          tbCanvas->Handle = pDraw->hdc;
          Frame3D(tbCanvas.get(),
            Rect, clWhite, clGray, 3);
          tbCanvas->Handle = NULL;

          // tell the trackbar we
          // drew the thumb manually
          Msg.Result = CDRF_SKIPDEFAULT;
          return;
        }

        // if we're drawing the ticks
        if (pDraw->dwItemSpec == TBCD_TICS)
        {
          // determine the thumb dimensions
          RECT RThumb = {0};
          SNDMSG(TrackBar->Handle,
            TBM_GETTHUMBRECT, 0,
            reinterpret_cast<LPARAM>(&RThumb));

          // determine the number of ticks
          const int num_ticks =
            SNDMSG(TrackBar->Handle,
              TBM_GETNUMTICS, 0, 0) - 2;

          // draw the middle ticks  
          for (int iTick = 0; iTick < num_ticks;
               ++iTick)
          {
            const int x_pos =
              SNDMSG(TrackBar->Handle,
                TBM_GETTICPOS, iTick, 0);

            Ellipse(pDraw->hdc,
              x_pos - 2, RThumb.top - 6,
              x_pos + 2, RThumb.top);
            Ellipse(pDraw->hdc,
              x_pos - 2, RThumb.bottom,
              x_pos + 2, RThumb.bottom + 6);
          }

          // draw the first and last ticks
          RECT RChanl = {0};
          SNDMSG(TrackBar->Handle,
            TBM_GETCHANNELRECT, 0,
            reinterpret_cast<LPARAM>(&RChanl));
          InflateRect(&RChanl, -4, 0);
          Rectangle(pDraw->hdc,
            RChanl.left, RThumb.top - 6,
            RChanl.left + 4, RThumb.top);
          Rectangle(pDraw->hdc,
            RChanl.left, RThumb.bottom,
            RChanl.left + 4, RThumb.bottom + 6);
          Rectangle(pDraw->hdc,
            RChanl.right - 4, RThumb.top - 6,
            RChanl.right, RThumb.top);
          Rectangle(pDraw->hdc,
            RChanl.right - 4, RThumb.bottom,
            RChanl.right, RThumb.bottom + 6);

          // tell the trackbar we
          // drew the channel manually
          Msg.Result = CDRF_SKIPDEFAULT;
          return;
        }
      }
    }
  }

  // pass on all other messages
  TForm::Dispatch(&Msg);
}
//---------------------------------------------------------------------------


