//---------------------------------------------------------------------------

#ifndef Unit1H
#define Unit1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Graphics.hpp>
//---------------------------------------------------------------------------

#include <memory>
class TMyTrackBar : public TTrackBar
{
private:
  MESSAGE void __fastcall CNNotify(TMessage& Msg)
  {
    // grab a pointer to NMHDR struct
    LPNMHDR pnmh = reinterpret_cast<LPNMHDR>(Msg.LParam);

    //
    // if the notification message is
    // NM_CUSTOMDRAW and from our trackbar
    //
    if (pnmh->code == NM_CUSTOMDRAW &&
        pnmh->hwndFrom == Handle)
    {
      // grab a pointer to NMCUSTOMDRAW
      LPNMCUSTOMDRAW pDraw =
        reinterpret_cast<LPNMCUSTOMDRAW>(Msg.LParam);

      // test the drawing stage...
      switch (pDraw->dwDrawStage)
      {
        // before anything is drawn...
        case CDDS_PREPAINT:
        {
          //
          // tell the trackbar to notify us
          // before it draws its elements
          //
          Msg.Result = CDRF_NOTIFYITEMDRAW;
          return;
        }

        // before an element is drawn...
        case CDDS_ITEMPREPAINT:
        {
          // if we're drawing the channel
          if (pDraw->dwItemSpec == TBCD_CHANNEL)
          {
            std::auto_ptr<TCanvas>
              tbCanvas(new TCanvas());
            TRect rect = pDraw->rc;

            // render the background color
            tbCanvas->Handle = pDraw->hdc;
            tbCanvas->Brush->Color = clInfoBk;
            tbCanvas->FillRect(rect);
            tbCanvas->Handle = NULL;

            // draw the channel's edge
            DrawEdge(
             pDraw->hdc, &pDraw->rc,
             EDGE_SUNKEN, BF_RECT);

            // tell the trackbar we
            // drew the channel manually
            Msg.Result = CDRF_SKIPDEFAULT;
            return;
          }

          // if we're drawing the thumb
          if (pDraw->dwItemSpec == TBCD_THUMB)
          {
            //
            // here's an example of punting...
            //
            Msg.Result = CDRF_DODEFAULT;
            return;
          }

          // if we're drawing the ticks
          if (pDraw->dwItemSpec == TBCD_TICS)
          {
            // determine the thumb dimensions
            RECT RThumb = {0};
            SNDMSG(Handle, TBM_GETTHUMBRECT, 0,
              reinterpret_cast<LPARAM>(&RThumb));

            // determine the number of ticks
            const int num_ticks =
              SNDMSG(Handle, TBM_GETNUMTICS, 0, 0) - 2;

            // draw the middle ticks  
            for (int iTick = 0; iTick < num_ticks;
                 ++iTick)
            {
              const int x_pos =
                SNDMSG(Handle, TBM_GETTICPOS, iTick, 0);

              Rectangle(pDraw->hdc,
                x_pos - 2, RThumb.top - 6,
                x_pos + 2, RThumb.top);
              Rectangle(pDraw->hdc,
                x_pos - 2, RThumb.bottom,
                x_pos + 2, RThumb.bottom + 6);
            }

            // draw the first and last ticks
            RECT RChanl = {0};
            SNDMSG(Handle, TBM_GETCHANNELRECT, 0,
              reinterpret_cast<LPARAM>(&RChanl));
            InflateRect(&RChanl, -4, 0);
            Ellipse(pDraw->hdc,
              RChanl.left, RThumb.top - 6,
              RChanl.left + 6, RThumb.top);
            Ellipse(pDraw->hdc,
              RChanl.left, RThumb.bottom,
              RChanl.left + 6, RThumb.bottom + 6);
            Ellipse(pDraw->hdc,
              RChanl.right - 6, RThumb.top - 6,
              RChanl.right, RThumb.top);
            Ellipse(pDraw->hdc,
              RChanl.right - 6, RThumb.bottom,
              RChanl.right, RThumb.bottom + 6);

            // tell the trackbar we
            // drew the channel manually
            Msg.Result = CDRF_SKIPDEFAULT;
            return;
          }
        }
      }
    }
    // pass on all other messages
    TTrackBar::Dispatch(&Msg);
  }
  
public:
  __fastcall TMyTrackBar(TComponent* AOwner)
    : TTrackBar(AOwner) {};

BEGIN_MESSAGE_MAP
  MESSAGE_HANDLER(
    CN_NOTIFY, TMessage, CNNotify)
END_MESSAGE_MAP(TTrackBar)
};

class TForm1 : public TForm
{
__published:
  TImage *Image1;
  TTrackBar *TrackBar;
  TPanel *Panel1;
private:
  TMyTrackBar* MyTrackBar;
  MESSAGE void __fastcall WMNotify(
    TMessage& Msg);
public:
  __fastcall TForm1(TComponent* Owner);

BEGIN_MESSAGE_MAP
  MESSAGE_HANDLER(
    WM_NOTIFY, TMessage, WMNotify)
END_MESSAGE_MAP(TForm)
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
