#include <vcl.h>
#pragma hdrstop

#include "ClientMain.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TClientForm *ClientForm;


__fastcall TClientForm::TClientForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   fmHandle = OpenFileMapping(FILE_MAP_ALL_ACCESS, false, "ReisdorphDemoFileMap");
   if (fmHandle == 0)
      {
      ShowMessage("Unable to create File Mapping.");
      Application->Terminate();
      }

   memmap = (char *)MapViewOfFile(fmHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);
   if (memmap == 0)
      {
      ShowMessage("Unable to map view of file.");
      Application->Terminate();
      }

   Application->OnIdle = OnIdle;
   }

__fastcall TClientForm::~TClientForm()
   {
   if (memmap != 0)
      UnmapViewOfFile(memmap);
   if (fmHandle != 0)
      CloseHandle(fmHandle);
   }

void __fastcall TClientForm::Exit(TObject *Sender)
   {
   Close();
   }

void __fastcall TClientForm::Send(TObject *Sender)
   {
   lstrcpy(memmap, Memo1->Text.c_str());
   Memo1->Clear();
   }

void __fastcall TClientForm::OnIdle(TObject *Sender, bool &Done)
   {
   SendBtn->Enabled = Memo1->Lines->Text.IsEmpty() == false;
   }

