
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "PopupListUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PopupFormUnit"
#pragma resource "*.dfm"
TPopupListBox *PopupListBox;
//---------------------------------------------------------------------------

void __fastcall TPopupListBox::
  ListBoxMouseMove(TObject *Sender,
    TShiftState Shift, int X, int Y)
{
  // if the left mouse button is depressed
  if (Shift.Contains(ssLeft))
  {
    if (Grid_ != NULL)
    {
      // convert list-box coordinates to grid coordinates
      POINT PMouse = {X, Y};
      MapWindowPoints(
        ListBox->Handle, Grid_->Handle, &PMouse, 1
        );

      //
      // If the mouse cursor leaves the bounds of the
      // combo-box drop-down button, redraw the button
      // in the unpushed state...
      //
      RECT RBtn =
        Grid_->CellRect(Grid_->Col, Grid_->Row);
      RBtn.left = RBtn.right - 18;
      if (!PtInRect(&RBtn, PMouse))
      {
        PostMessage(
          Grid_->Handle, WM_LBUTTONUP, 0, 0
          );
      }
    }
  }

  // highlight the list-box item that's under the cursor
  const int hit_index =
    ListBox->ItemAtPos(Point(X, Y), false);
  if (hit_index != -1)
  {
    ListBox->ItemIndex = hit_index;
  }
}
//---------------------------------------------------------------------------

void __fastcall TPopupListBox::
  ListBoxMouseUp(TObject *Sender,
    TMouseButton Btn, TShiftState Shift,
    int X, int Y)
{
  if (Grid_ != NULL)
  {
    PostMessage(Grid_->Handle, WM_LBUTTONUP, 0, 0);
  }

  //
  // When the left mouse button is released, change
  // the cell's text to the selected item's text...
  //
  const int hit_index =
    ListBox->ItemAtPos(Point(X, Y), true);
  if (hit_index != -1)
  {
    Close();  
    if (Grid_ != NULL)
    {
      Grid_->Cells[Grid_->Col][Grid_->Row] =
        ListBox->Items->Strings[hit_index];
    }
  }
}
//---------------------------------------------------------------------------

