
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <cassert>
#include "Unit1GridEx.h"
#include "PopupListUnit.h"
#include "DialogUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

void RedrawBtn(TStringGrid& Grid, int col, int row)
{
  RECT RBtn = Grid.CellRect(col, row);
  RBtn.left = RBtn.right - 18;

  RedrawWindow(
    Grid.Handle, &RBtn, NULL,
    RDW_INVALIDATE | RDW_UPDATENOW
    );
}

bool PtInBtn(TStringGrid& Grid, int X, int Y)
{
  int col, row;
  Grid.MouseToCell(X, Y, col, row);
  if (col != -1 && row != -1)
  {
    const POINT PMouse = {X, Y};
    RECT RBtn = Grid.CellRect(col, row);
    RBtn.left = RBtn.right - 18;

    return PtInRect(&RBtn, PMouse);
  }
  return false;
}

void CellRectFromPt(
  TStringGrid& Grid, int X, int Y, RECT& RCell)
{
  int col, row;
  Grid.MouseToCell(X, Y, col, row);
  if (col != -1 && row != -1)
  {
    RCell = Grid.CellRect(col, row);
    MapWindowPoints(
      Grid.Handle, HWND_DESKTOP,
      reinterpret_cast<POINT*>(&RCell), 2
      );
  }
  else SetRectEmpty(&RCell);
}


void DrawCellControl(
  TCanvas& Canvas, TRect& RCell,
  TCellObject::TCellType Type,
  TGridDrawState State, bool BtnDown)
{
  const TColor old_bsh_color =
    Canvas.Brush->Color;
  const TColor old_pen_color =
    Canvas.Pen->Color;
  try {
    Canvas.Brush->Color = clBtnFace;
    if (State.Contains(gdFocused))
    {
      TRect RBtn = RCell;
      RBtn.Left = RBtn.Right - 18;
      Canvas.FillRect(RBtn);

      if (BtnDown)
      {
        Frame3D(&Canvas,
          RBtn, clBtnShadow,
          clBtnHighlight, 1);
      }
      else
      {
        Frame3D(&Canvas,
          RBtn, clBtnHighlight,
          clBtnShadow, 2);
      }
      Canvas.Pen->Color = clBlack;
      Canvas.Brush->Color = clBlack;
    }
    else Canvas.Pen->Color = clBtnShadow;

    //
    // draw the combo box scroll arrow
    // or the dialog button ellipsis...
    //
    TRect RBtn = RCell;
    RBtn.Left = RBtn.Right - 18;
    if (Type == TCellObject::ctCombo)
    {
      TPoint Ps[3];
      Ps[0].x = RBtn.left - 4 +
        0.5 * (RBtn.right - RBtn.left);
      Ps[0].y = RBtn.top - 3 +
        0.5 * (RBtn.bottom - RBtn.top);
      if (BtnDown &&
        State.Contains(gdFocused))
      {
        Ps[0].y += 1;
      }

      Ps[1].x = Ps[0].x + 8;
      Ps[1].y = Ps[0].y;
      Ps[2].x = Ps[0].x + 4;
      Ps[2].y = Ps[0].y + 4;

      // draw the arrow
      Canvas.Polygon(Ps, 2);
    }
    else if (Type ==
      TCellObject::ctDialog)
    {
      TPoint P = Point(
        RBtn.left + 2, RBtn.top - 1 +
        0.5 * (RBtn.bottom - RBtn.top)
        );
      if (BtnDown &&
        State.Contains(gdFocused))
      {
        P.y += 1;
      }

      // draw the ellipsis
      Canvas.Ellipse(P.x + 2, P.y,
        P.x + 5, P.y + 3);
      Canvas.Ellipse(P.x + 6, P.y,
        P.x + 9, P.y + 3);
      Canvas.Ellipse(P.x + 10, P.y,
        P.x + 13, P.y + 3);
    }
  }
  __finally {
    Canvas.Pen->Color = old_pen_color;
    Canvas.Brush->Color = old_bsh_color;
  }
}

TCellObject* CellData(
  TStringGrid& Grid, int col, int row)
{
  if (col == -1 || row == -1 ||
      col >= Grid.ColCount ||
      row >= Grid.RowCount)
  {
    return NULL;
  }
  return static_cast<TCellObject*>(
    Grid.Objects[col][row]
    );
}

TCellObject* CellData(
  TStringGrid& Grid, TPoint P)
{
  int col, row;
  Grid.MouseToCell(P.x, P.y, col, row);
  if (col == -1 || row == -1 ||
      col >= Grid.ColCount ||
      row >= Grid.RowCount)
  {
    return NULL;
  }
  return static_cast<TCellObject*>(
    Grid.Objects[col][row]
    );
}
//---------------------------------------------------------------------------

__fastcall TForm1::
  TForm1(TComponent* Owner)
    : TForm(Owner), BtnDown_(false)
{
  const int r_min =
    StringGrid1->FixedRows;
  const int r_max =
    StringGrid1->RowCount;

  StringGrid1->Cells[0][0] =
    "Text Column";
  StringGrid1->Cells[1][0] =
    "ComboBox Column";
  StringGrid1->Cells[2][0] =
    "Dialog Button Column";
      
  for (int r = r_min; r < r_max; ++r)
  {
    // first column
    TCellObject* pData =
      new TCellObject(StringGrid1, 0, r);
    pData->Type = TCellObject::ctText;
    pData->Text = "Text Cell (" +
      IntToStr(r) + ", 0)";

    // second column
    pData =
      new TCellObject(StringGrid1, 1, r);
    pData->Type = TCellObject::ctCombo;
    pData->Text = "Combo Cell (" +
      IntToStr(r) + ", 1)";

    // third column
    pData =
      new TCellObject(StringGrid1, 2, r);
    pData->Type = TCellObject::ctDialog;
    pData->Text = "Button Cell (" +
      IntToStr(r) + ", 2)";
  }
}
//---------------------------------------------------------------------------

__fastcall TForm1::~TForm1()
{
  const int r_min =
    StringGrid1->FixedRows;
  const int r_max =
    StringGrid1->RowCount;

  for (int r = r_min; r < r_max; ++r)
  {
    delete CellData(*StringGrid1, 2, r);
    delete CellData(*StringGrid1, 1, r);
    delete CellData(*StringGrid1, 0, r);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  StringGrid1DrawCell(TObject *Sender,
    int ACol, int ARow, TRect &ARect,
    TGridDrawState State)
{
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Sender);
  TCanvas& SGCanvas = *Grid.Canvas;
  SGCanvas.Font = Grid.Font;
  RECT RText = ARect;

  // if the cell is fixed (header)
  if (State.Contains(gdFixed))
  {
    SGCanvas.Brush->Color =
      Grid.FixedColor;
    SGCanvas.FillRect(ARect);
    Frame3D(&SGCanvas, ARect,
      clBtnHighlight, clBtnShadow, 1);

    SGCanvas.Font->Style =
      SGCanvas.Font->Style << fsBold;
  }
  // if the cell is not a fixed cell
  else
  {
    SGCanvas.Brush->Color = Grid.Color;
    SGCanvas.FillRect(ARect);

    const TCellObject* pData =
      CellData(Grid, ACol, ARow);
    assert(pData != NULL);
    if (pData->Type !=
      TCellObject::ctText)
    {
      // make room for the button
      RText.right -= 18;

      // draw the combo-box/button
      DrawCellControl(SGCanvas, ARect,
        pData->Type, State, BtnDown_);
    }

    // if the cell is focused
    if (State.Contains(gdFocused))
    {
      //
      // render a black outline
      // (or use DrawFocusRect() if you
      // prefer a classic focus rect)
      //
      SGCanvas.Pen->Color = clBlack;
      SGCanvas.Brush->Style = bsClear;
      SGCanvas.Rectangle(ARect);
      SGCanvas.Brush->Style = bsSolid;
    }

    bool selected =
      State.Contains(gdSelected);
    if (Grid.Options.
      Contains(goDrawFocusSelected))
    {
      selected = selected &&
        !State.Contains(gdFocused);
    }
    // if the cell is selected
    if (selected)
    {
      SGCanvas.Font->Color =
        clHighlightText;
      SGCanvas.Brush->Color =
        clHighlight;
    }
  }

  // draw the text
  RText.left += 2;
  RText.right -= 2;
  DrawText(
    SGCanvas.Handle,
    Grid.Cells[ACol][ARow].c_str(),
    -1, &RText, DT_LEFT |
    DT_SINGLELINE | DT_VCENTER
    );
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  StringGrid1MouseDown(TObject *Sender,
    TMouseButton Button, TShiftState,
    int X, int Y)
{
  if (Button != mbLeft) return;

  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Sender);

  const TCellObject* pData =
    CellData(Grid, Point(X, Y));
  if (!pData) return;

  static int old_col = -1;
  static int old_row = -1;

  BtnDown_ = PtInBtn(Grid, X, Y);
  if (BtnDown_)
  {
    old_col = pData->Col;
    old_row = pData->Row;
  
    // draw the button as pushed
    RedrawBtn(
      Grid, pData->Col, pData->Row);
  }
  else
  {
    if (old_col != pData->Col ||
        old_row != pData->Row)
    {
      old_col = pData->Col;
      old_row = pData->Row;
      return;
    }
  }

  if (pData->Type ==
    TCellObject::ctCombo)
  {
    // show the popup window
    RECT RCell;
    CellRectFromPt(
      *StringGrid1, X, Y, RCell);

    PopupListBox->Left = RCell.left;
    PopupListBox->Top = RCell.bottom;
    PopupListBox->Width = max(
      RCell.right - RCell.left, 50L
      );
    PopupListBox->Grid = StringGrid1;
    PopupListBox->Show();
  }
  else if (pData->Type ==
    TCellObject::ctDialog)
  {
    // defer button click until OnMouseUp
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  StringGrid1MouseUp(TObject *Sender,
    TMouseButton Btn, TShiftState Shift,
    int X, int Y)
{
  if (Btn != mbLeft || !BtnDown_)
    return;

  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Sender);

  // draw the button as unpushed
  BtnDown_ = false;
  RedrawBtn(Grid, Grid.Col, Grid.Row);

  if (PtInBtn(Grid, X, Y))
  {
    const TCellObject* pData =
      CellData(Grid, Point(X, Y));

    if (pData->Type ==
      TCellObject::ctDialog)
    {
      // show the dialog
      DialogForm->ShowModal();

      //
      // adjust the cell's text
      // accordingly...
      //
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  StringGrid1SelectCell(TObject *Sender,
    int ACol, int ARow, bool &CanSelect)
{
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Sender);
  const TCellObject* pData =
    CellData(Grid, ACol, ARow);
  assert(pData != NULL);

  if (pData->Type == TCellObject::ctText)
  {
    Grid.Options =
      Grid.Options << goEditing;
  }
  else
  {
    Grid.Options =
      Grid.Options >> goEditing;
  }
}
//---------------------------------------------------------------------------


