
//---------------------------------------------------------------------------
#ifndef Unit1GridExH
#define Unit1GridExH
#include <Classes.hpp>
#include <Controls.hpp>
#include <Grids.hpp>
#include <StdCtrls.hpp>

#include <cassert>
//---------------------------------------------------------------------------

class TCellObject : public TObject
{
public:
  enum TCellType {ctText, ctCombo, ctDialog};

  __property TCellType Type =
    {read = Type_, write = DoSetType};
  __property AnsiString Text =
    {read = DoGetText, write = DoSetText};
  __property int Col = {read = Col_};
  __property int Row = {read = Row_};

public:
  __fastcall TCellObject(TStringGrid* Grid,
    int Col, int Row) : TObject(), Grid_(Grid),
    Row_(Row), Col_(Col), Type_(ctText)
    {
      assert(Grid_ != NULL);
      Grid_->Objects[Col_][Row_] = this;
    }

protected:
  virtual void __fastcall DoSetType(
    TCellType NewType)
    {
      if (Type_ != NewType)
      {
        Grid_->Objects[Col_][Row_] = this;
        Type_ = NewType;
      }
    }
  virtual AnsiString __fastcall DoGetText()
    {
      return Grid_->Cells[Col_][Row_];
    }
  virtual void __fastcall DoSetText(
    AnsiString NewText)
    {
      Grid_->Cells[Col_][Row_] = NewText;
    }

private:
  TStringGrid* Grid_;
  TCellType Type_;
  int Col_, Row_;
};


class TForm1 : public TForm
{
__published:
  TStringGrid *StringGrid1;
  
  void __fastcall StringGrid1DrawCell(
    TObject *Sender, int ACol, int ARow,
    TRect &ARect, TGridDrawState State);
  void __fastcall StringGrid1MouseDown(
    TObject *Sender, TMouseButton Button,
    TShiftState Shift, int X, int Y);
  void __fastcall StringGrid1MouseUp(
    TObject *Sender, TMouseButton Button,
    TShiftState Shift, int X, int Y);
  void __fastcall StringGrid1SelectCell(
    TObject *Sender, int ACol, int ARow,
    bool &CanSelect);

private:
  bool BtnDown_;

public:
  __fastcall TForm1(TComponent* Owner);
  __fastcall ~TForm1();
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
 