#include <vcl.h>
#pragma hdrstop

#include "DateTime.h"
#include "Main.h"
#include "Numbers.h"
#include "Filename.h"
#include "Files.h"


void TTestForm::AddTest(String name, TestFunc func, bool checked)
   {
   int i = TestLB->Items->AddObject(name, (TObject *)func);
   TestLB->Checked[i] = checked;
   }

void TTestForm::BuildList()
   {
   // Part 1
   AddTest("Time Variables", TestTimeVars, false);
   AddTest("Time Functions", TestTimeFuncs, false);
   AddTest("Date Variables", TestDateVars, false);
   AddTest("Date Functions", TestDateFuncs, false);
   AddTest("DateTime Functions", TestDateTimeFuncs, false);

   // Part 2
   AddTest("Number Variables", TestNumberVars, false);
   AddTest("Number Functions", TestNumberFuncs, false);
   AddTest("Hexadecimal Variable", TestHexVars, false);
   AddTest("Hexadecimal Functions", TestHexFuncs, false);
   AddTest("Currency Variables", TestCurrencyVars, false);
   AddTest("Currency Functions", TestCurrencyFuncs, false);

   // Part 3
   AddTest("File Name Parts", TestFNParts, false);
   AddTest("Alternate Paths", TestFNAltPaths, false);
   AddTest("Expanding Paths", TestFNExpand, false);
   AddTest("File Name Case and Comparison", TestFNCaseComp, false);
   AddTest("Miscellaneous File Name Functions", TestFNMisc, false);

   // Part 4
   AddTest("Directory Functions", TestDirFuncs);
   AddTest("Disk Information Functions", TestDiskInfoFuncs);
   AddTest("Directory Search Functions", TestFileSrchFuncs);
   AddTest("File Date Functions", TestFileDateFuncs);
   AddTest("File Attribute Functions", TestFileAttrFuncs);
   AddTest("File Rename and Delete Functions", TestFileRenDelFuncs);
   AddTest("File Read, Write & Seek Functions", TestFileCRWsFuncs);
   }

