#include <vcl.h>
#pragma hdrstop

#include "DateTime.h"
#include "Log.h"

#pragma package(smart_init)

void TestTimeVars()
   {
   Log("SecsPerDay = " + String(SecsPerDay));
   Log("MSecsPerDay = " + String(MSecsPerDay));
   Log("TimeSeparator = " + String(TimeSeparator));
   Log("TimeAMString = " + TimeAMString);
   Log("TimePMString = " + TimePMString);
   Log("ShortTimeFormat = " + ShortTimeFormat);
   Log("LongTimeFormat = " + LongTimeFormat + nl);
   }

void TestTimeFuncs()
   {
   TDateTime t = EncodeTime(21, 10, 30, 0);
   Word hours, minutes, seconds, milliseconds;
   DecodeTime(t, hours, minutes, seconds, milliseconds);

   LogSubtitle("EncodeTime() and DecodeTime()" + nl);
   LogCode("TDateTime t = EncodeTime(21, 10, 30, 0);");
   LogCode("Word hours, minutes, seconds, milliseconds;");
   LogCode("DecodeTime(t, hours, minutes, seconds, milliseconds);" + nl);
   Log("hours = " + String(hours));
   Log("minutes = " + String(minutes));
   Log("seconds = " + String(seconds));
   Log("milliseconds = " + String(milliseconds) + nl);

   t = Time();
   String s = TimeToStr(t);

   LogSubtitle("Time() and TimeToStr()" + nl);
   LogCode("TDateTime t = Time();");
   LogCode("String s = TimeToStr(t);" + nl);
   Log("s = " + s + nl);

   String h = LongTimeFormat;
   LongTimeFormat = "'Hour' h\, 'Minute' n, 'Second' s ampm";
   s = TimeToStr(t);
   LongTimeFormat = h;

   LogCode("LongTimeFormat = \"'Hour' h\, 'Minute' n, 'Second' s ampm\";");
   LogCode("s = TimeToStr(t);" + nl);
   Log("s = " + s + nl);

   String ha = TimeAMString;
   String hp = TimePMString;
   TimeAMString = "ante meridiem";
   TimePMString = "post meridiem";
   s = TimeToStr(t);
   TimeAMString = ha;
   TimePMString = hp;

   LogCode("TimeAMString = \"ante meridiem\";");
   LogCode("TimePMString = \"post meridiem\";");
   LogCode("s = TimeToStr(t);" + nl);
   Log("s = " + s + nl);

   t = StrToTime("8:27");
   s = TimeToStr(t);

   LogSubtitle("StrToTime()" + nl);
   LogCode("TDateTime t = StrToTime(\"8:27\");");
   LogCode("String s = TimeToStr(t);" + nl);
   Log("s = " + s + nl);

   t = StrToTime("20:27");
   s = TimeToStr(t);

   LogCode("TDateTime t = StrToTime(\"20:27\");");
   LogCode("String s = TimeToStr(t);" + nl);
   Log("s = " + s + nl);

   t = StrToTime("8:27 pm");
   s = TimeToStr(t);

   LogCode("TDateTime t = StrToTime(\"8:27 pm\");");
   LogCode("String s = TimeToStr(t);" + nl);
   Log("s = " + s + nl);
   }

void TestDateVars()
   {
   Log("DateSeparator = " + String(DateSeparator));
   Log("ShortDateFormat = " + ShortDateFormat);
   Log("LongDateFormat = " + LongDateFormat + nl);

   for (int i = 0; i < 12; i++)
      Log("ShortMonthNames[" + String(i) + "] = " + ShortMonthNames[i]);
   Log();

   for (int i = 0; i < 12; i++)
      Log("LongMonthNames[" + String(i) + "] = " + LongMonthNames[i]);
   Log();

   for (int i = 0; i < 7; i++)
      Log("ShortDayNames[" + String(i) + "] = " + ShortDayNames[i]);
   Log();

   for (int i = 0; i < 7; i++)
      Log("LongDayNames[" + String(i) + "] = " + LongDayNames[i]);
   Log();

   Log("TwoDigitYearCenturyWindow = " + String(TwoDigitYearCenturyWindow) + nl);

   for (int i = 0; i < 2; i++)
      {
      LogSubtitle(i == 0 ? "Non-leap Year" : "Leap Year");
      for (int j = 0; j < 12; j++)
         Log("MonthDays[" + String(i) + "][" + String(j) + "] = " + String(MonthDays[i][j]));
      Log();
      }

   int days = MonthDays[IsLeapYear(2000)][1];

   LogCode("int days = MonthDays[IsLeapYear(2000)][1];" + nl);
   Log("days = " + String(days) + nl);
   }

void TestDateFuncs()
   {
   TDateTime d = EncodeDate(2000, 2, 26);
   Word year, month, day;
   DecodeDate(d, year, month, day);

   LogSubtitle("DecodeDate() and EncodeDate()" + nl);
   LogCode("TDateTime d = EncodeDate(2000, 2, 26);");
   LogCode("Word year, month, day;");
   LogCode("DecodeDate(d, year, month, day);" + nl);
   Log("year = " + String(year));
   Log("month = " + String(month));
   Log("day = " + String(day) + nl);

   bool leap = IsLeapYear(1999);

   LogSubtitle("IsLeapYear()" + nl);
   LogCode("bool leap = IsLeapYear(1999);" + nl);
   Log("leap = " + String(leap ? "true" : "false") + nl);

   leap = IsLeapYear(2000);
   LogCode("leap = IsLeapYear(2000);" + nl);
   Log("leap = " + String(leap ? "true" : "false") + nl);

   TDateTime id(2000, 7, 4);
   int dw = DayOfWeek(id);

   LogSubtitle("DayOfWeek()" + nl);
   LogCode("TDateTime id(2000, 7, 4);");
   LogCode("int dw = DayOfWeek(id);" + nl);
   Log("dw = " + String(dw));
   Log("LongDayNames[dw - 1] = " + LongDayNames[dw - 1] + nl);

   TDateTime today = Date();
   String s = DateToStr(today);

   LogSubtitle("Date() and DateToStr()" + nl);
   LogCode("TDateTime today = Date(void);");
   LogCode("String s = DateToStr(today);" + nl);
   Log("s = " + s + nl);

   String hold = ShortDateFormat;
   ShortDateFormat = "M/d/yy";
   s = DateToStr(today);
   ShortDateFormat = hold;

   LogCode("ShortDateFormat = \"M/d/yy\";");
   LogCode("s = DateToStr(today);" + nl);
   Log("s = " + s + nl);

   d = TDateTime(2000, 7, 31);
   TDateTime nextmonth = IncMonth(d, 1);

   LogSubtitle("IncMonth()" + nl);
   LogCode("TDateTime d = TDateTime(2000, 7, 31);" + nl);
   LogCode("TDateTime nextmonth = IncMonth(d, 1);" + nl);
   Log("nextmonth = " + DateToStr(nextmonth) + nl);

   TDateTime lastmonth = IncMonth(d, -1);

   LogCode("TDateTime lastmonth = IncMonth(d, -1);" + nl);
   Log("lastmonth = " + DateToStr(lastmonth) + " <-- Note day" + nl);

   TDateTime nextyear = IncMonth(d, 12);

   LogCode("TDateTime nextyear = IncMonth(d, 12);" + nl);
   Log("nextyear = " + DateToStr(nextyear) + nl);

   TDateTime lastyear = IncMonth(d, -12);

   LogCode("TDateTime lastyear = IncMonth(d, -12);" + nl);
   Log("lastyear = " + DateToStr(lastyear) + nl);

   d = StrToDate("8/27/1954");
   s = DateToStr(d);

   LogSubtitle("StrToDate()" + nl);
   LogCode("TDateTime d = StrToDate(\"8/27/1954\");");
   LogCode("String s = DateToStr(d);" + nl);
   Log("s = " + s + nl);

   d = StrToDate("8/27/54");
   s = DateToStr(d);

   LogCode("TDateTime d = StrToDate(\"8/27/54\");");
   LogCode("String s = DateToStr(d);" + nl);
   Log("s = " + s + " -- Whoops!" + nl);

   Word hw = TwoDigitYearCenturyWindow;
   TwoDigitYearCenturyWindow = 80;
   d = StrToDate("8/27/54");
   s = DateToStr(d);
   TwoDigitYearCenturyWindow = hw;

   LogCode("TwoDigitYearCenturyWindow = 80");
   LogCode("TDateTime d = StrToDate(\"8/27/54\");");
   LogCode("String s = DateToStr(d);" + nl);
   Log("s = " + s + " -- Better!" + nl);

   d = StrToDate("8/27");
   s = DateToStr(d);

   LogCode("TDateTime d = StrToDate(\"8/27\");");
   LogCode("String s = DateToStr(d);" + nl);
   Log("s = " + s + nl);
   }

void TestDateTimeFuncs()
   {
   TDateTime n = Now();
   String s = DateTimeToStr(n);

   LogSubtitle("Now() and DateTimeToStr()" + nl);
   LogCode("TDateTime n = Now();");
   LogCode("String s = DateTimeToStr(n);" + nl);
   Log("s = " + s + nl);

   n = Now();
   String format = "'Date:' mm-dd-yyyy 'and Time:' hh:mm";
   DateTimeToString(s, format, n);

   LogSubtitle("DateTimeToString()" + nl);
   LogCode("TDateTime n = Now();");
   LogCode("String format = \"'Date:' mm-dd-yyyy 'and Time:' hh:nn\";");
   LogCode("String s;");
   LogCode("DateTimeToString(s, format, n);" + nl);
   Log("s = " + s + nl);

   s = FormatDateTime(format, n);

   LogSubtitle("FormatDateTime()" + nl);
   LogCode("s = FormatDateTime(format, n);" + nl);
   Log("s = " + s + nl);

   SYSTEMTIME st;
   n = Now();
   DateTimeToSystemTime(n, st);

   LogSubtitle("DateTimeToSystemTime() and SystemTimeToDateTime()" + nl);
   LogCode("SYSTEMTIME st;");
   LogCode("TDateTime n = Now();");
   LogCode("DateTimeToSystemTime(n, st);" + nl);
   Log("st.wYear = " + String(st.wYear));
   Log("st.wMonth = " + String(st.wMonth));
   Log("st.wDayOfWeek = " + String(st.wDayOfWeek));
   Log("st.wDay = " + String(st.wDay));
   Log("st.wHour = " + String(st.wHour));
   Log("st.wMinute = " + String(st.wMinute));
   Log("st.wSecond = " + String(st.wSecond));
   Log("st.wMilliseconds = " + String(st.wMilliseconds) + nl);

   st.wYear = 2001;
   st.wMonth = 1;
   st.wDay = 1;
   TDateTime d = SystemTimeToDateTime(st);

   LogCode("st.wYear = 2001;");
   LogCode("st.wMonth = 1;");
   LogCode("st.wDay = 1;");
   LogCode("TDateTime d = SystemTimeToDateTime(st);" + nl);
   Log("d = " + DateTimeToStr(d) + nl);

   d = StrToDateTime("7/28/2000 14:30");
   s = DateTimeToStr(d);

   LogSubtitle("StrToDateTime()" + nl);
   LogCode("TDateTime d = StrToDateTime(\"14:30 7/28/00\");");
   LogCode("String s = DateTimeToStr(d);" + nl);
   Log("s = " + s + nl);
   }

