#include <vcl.h>
#pragma hdrstop

#include "Filename.h"
#include "Log.h"

void TestFNParts()
   {
   String filename = "c:\\windows\\notepad.exe";
   String path = ExtractFilePath(filename);
   String dir = ExtractFileDir(filename);
   String drive = ExtractFileDrive(filename);
   String name = ExtractFileName(filename);
   String ext = ExtractFileExt(filename);

   LogCode("String filename = \"c:\\\\windows\\\\notepad.exe\";" + nl);

   LogSubtitle("ExtractFilePath()" + nl);
   LogCode("String path = ExtractFilePath(filename);" + nl);
   Log("path = " + path + nl);

   LogSubtitle("ExtractFileDir()" + nl);
   LogCode("String dir = ExtractFileDir(filename);" + nl);
   Log("dir = " + dir + nl);

   LogSubtitle("ExtractFileDrive()" + nl);
   LogCode("String drive = ExtractFileDrive(filename);" + nl);
   Log("drive = " + drive + nl);

   LogSubtitle("ExtractFileName()" + nl);
   LogCode("String name = ExtractFileName(filename);" + nl);
   Log("name = " + name + nl);

   LogSubtitle("ExtractFileExt()" + nl);
   LogCode("String ext = ExtractFileExt(filename);" + nl);
   Log("ext = " + ext + nl);
   }

void TestFNAltPaths()
   {
   String filename = "c:\\My Documents\\Reports\\1999 Annual Report.doc";
   String relative1 = ExtractRelativePath("c:\\My Documents\\Reports\\", filename);
   String relative2 = ExtractRelativePath("c:\\Windows\\System\\", filename);
   String shortpath = ExtractShortPathName(filename);

   LogCode("String filename = \"c:\\\\My Documents\\\\Reports\\\\1999 Annual Report.doc\";" + nl);

   LogSubtitle("ExtractRelativePath()" + nl);
   LogCode("String relative1 = ExtractRelativePath(\"c:\\\\My Documents\\\\Reports\\\", filename);" + nl);
   Log("relative1 = " + relative1 + nl);
   LogCode("String relative2 = ExtractRelativePath(\"c:\\\\Windows\\\\System\\\\\", filename);" + nl);
   Log("relative2 = " + relative2 + nl);

   LogSubtitle("ExtractShortPathName()" + nl);
   LogCode("String shortpath = ExtractShortPathName(filename);" + nl);
   if (shortpath.IsEmpty())
      {
      Log("File must exist for this function to work.");
      Log("On author's system, shortpath = c:\\MYDOCU~1\\REPORTS\\1999AN~1.DOC");
      }
   else
      Log("shortpath = " + shortpath + nl);
   }

void TestFNExpand()
   {
   String filename = "dummy.txt";
   String expanded = ExpandFileName(filename);
   filename = "k:\\on_net.txt";
   String expandedUNC = ExpandUNCFileName(filename);

   LogCode("String filename = \"dummy.txt\";" + nl);

   LogSubtitle("ExpandFileName()" + nl);
   Log("Current Directory = " + GetCurrentDir() + nl);
   LogCode("String expanded = ExpandFileName(filename);" + nl);
   Log("expanded = " + expanded + nl);

   LogSubtitle("ExpandUNCFileName()" + nl);
   LogCode("String filename = \"k:\\\\on_net.txt\";");
   LogCode("String expandedUNC = ExpandUNCFileName(filename);" + nl);
   if (expandedUNC == filename)
      {
      Log("On your system, k: is not mapped to a network drive.");
      Log("On the author's system, expandedUNC = \\\\SERVER1\\D\\on_net.txt" + nl);
      }
   else
      Log("expandedUNC = " + expandedUNC + nl);
   }

void TestFNCaseComp()
   {
   String filename = "c:\\My Documents\\This File Name has mixed CASE.doc";
   String lower = AnsiLowerCaseFileName(filename);
   String upper = AnsiUpperCaseFileName(filename);
   int compare1 = AnsiCompareFileName(filename, lower);
   int compare2 = AnsiCompareFileName(filename, upper);
   int compare3 = AnsiCompareFileName(filename, "d:\\junk.txt");
   int compare4 = AnsiCompareFileName(filename, "c:\\My Documents\\Stuff.txt");

   LogCode("String filename = \"c:\\\\My Documents\\\\This File Name has mixed CASE.doc\";" + nl);

   LogSubtitle("AnsiLowerCaseFileName()" + nl);
   LogCode("String lower = AnsiLowerCaseFileName(filename);" + nl);
   Log("lower = " + lower + nl);

   LogSubtitle("AnsiUpperCaseFileName()" + nl);
   LogCode("String upper = AnsiUpperCaseFileName(filename);" + nl);
   Log("upper = " + upper + nl);

   LogSubtitle("AnsiCompareFileName()" + nl);
   LogCode("int compare1 = AnsiCompareFileName(filename, lower);" + nl);
   Log("compare1 = " + String(compare1) + nl);
   LogCode("int compare2 = AnsiCompareFileName(filename, upper);" + nl);
   Log("compare2 = " + String(compare2) + nl);
   LogCode("int compare2 = AnsiCompareFileName(filename, \"d:\\\\junk.txt\");" + nl);
   Log("compare3 = " + String(compare3) + nl);
   LogCode("int compare4 = AnsiCompareFileName(filename, \"c:\\\\My Documents\\\\Stuff.txt\");" + nl);
   Log("compare4 = " + String(compare4) + nl);
   }

void TestFNMisc()
   {
   String filename = "c:\\My Documents\\Reports\\1999 Annual Report.doc";
   String newext = ChangeFileExt(filename, ".rpt");
   bool isdelim1 = IsPathDelimiter(filename, 7);
   bool isdelim2 = IsPathDelimiter(filename, 16);
   bool exists = FileExists(filename);

   LogCode("String filename = \"c:\\\\My Documents\\\\Reports\\\\1999 Annual Report.doc\";" + nl);

   LogSubtitle("ChangeFileExt()" + nl);
   LogCode("String newext = ChangeFileExt(filename, \".rpt\");" + nl);
   Log("newext = " + newext + nl);

   LogSubtitle("IsPathDelimiter()" + nl);
   LogCode("bool isdelim1 = IsPathDelimiter(filename, 7);" + nl);
   Log("isdelim1 = " + String(isdelim1 ? "true" : "false") + nl);
   LogCode("bool isdelim2 = IsPathDelimiter(filename, 16);" + nl);
   Log("isdelim2 = " + String(isdelim2 ? "true" : "false") + nl);

   LogSubtitle("FileExists()" + nl);
   LogCode("bool exists = FileExists(filename);" + nl);
   Log("exists = " + String(exists ? "true" : "false") + nl);
   }


#pragma package(smart_init)
