#include <vcl.h>
#pragma hdrstop

#include "Files.h"
#include "Log.h"

static bool CreateTestFile(String fileName)
   {
   int handle = FileCreate(fileName);

   if (handle > 0)
      {
      FileClose(handle);

      LogComment("Created a test file named \"" + fileName + "\"." + nl);

      return(true);
      }

   Log("Unable to create test file. Test cancelled." + nl);

   return(false);
   }

void TestDirFuncs()
   {
   String curdir = GetCurrentDir();

   LogSubtitle("GetCurrentDir()" + nl);
   LogCode("String curdir = GetCurrentDir();" + nl);
   Log("curdir = " + curdir + nl);

   LogSubtitle("CreateDir()" + nl);
   LogCode("String olddir = curdir;");
   LogCode("String newdir = olddir + \"\\SysUtils4\";");
   LogCode("CreateDir(newdir);" + nl);

   String olddir = curdir;
   String newdir = olddir + "\\SysUtils4";
   if (CreateDir(newdir))
      Log("Directory, " + newdir + ", created." + nl);
   else
      {
      Log("Unable to create new directory.  Test stopped." + nl);
      return;
      }

   LogSubtitle("SetCurrentDir()" + nl);
   LogCode("SetCurrentDir(newdir);" + nl);

   if (SetCurrentDir(newdir))
      Log("Changed current directory to " + newdir + "." + nl);
   else
      Log("Unable to change current directory to " + newdir + "." + nl);

   LogSubtitle("RemoveDir()" + nl);
   LogCode("SetCurrentDir(olddir);");
   LogCode("RemoveDir(newdir);" + nl);

   SetCurrentDir(olddir);
   if (RemoveDir(newdir))
      Log("Directory, " + newdir + ", removed." + nl);
   else
      Log("Unable to remove " + newdir + "." + nl);
   }

void TestDiskInfoFuncs()
   {
   __int64 freeSize = DiskFree(0);
   __int64 diskSize = DiskSize(0);

   LogSubtitle("DiskFree" + nl);
   LogCode("__int64 freeSize = DiskFree(0);" + nl);
   Log("freeSize = " + FormatFloat("#,##0", freeSize) + nl);

   LogSubtitle("DiskSize" + nl);
   LogCode("__int64 diskSize = DiskSize(0);" + nl);
   Log("diskSize = " + FormatFloat("#,##0", diskSize) + nl);
   }

void TestFileSrchFuncs()
   {
   LogSubtitle("FindFirst(), FindNext() and FindClose()" + nl);

   LogCode("TSearchRec rec;");
   LogCode("String name;");
   LogCode("int error = FindFirst(\"*.*\", faAnyFile, rec);");
   LogCode("while (error == 0)");
   LogCode("\t{");
   LogCode("\tname = rec.Name;");
   LogCode("\tif (rec.Attr & faDirectory > 0) name += \" (Dir)\";");
   LogCode("\t// Display name ...");
   LogCode("\terror = FindNext(rec);");
   LogCode("\t}");
   LogCode("FindClose(rec);" + nl);

   TSearchRec rec;
   String name;

   int error = FindFirst("*.*", faAnyFile, rec);
   while (error == 0)
      {
      name = rec.Name;
      if (rec.Attr & faDirectory) name += " (Dir)";
      Log(name);
      error = FindNext(rec);
      }
   FindClose(rec);
   Log("");

   LogSubtitle("FileSearch()" + nl);

   LogCode("String fileName = \"notepad.exe\";");
   LogCode("String dirList = \"c:\\Windows;c:\\WinNT\"; + nl");
   LogCode("String path = FileSearch(fileName, dirList);");
   LogCode("if (path.IsEmpty())");
   LogCode("\t// File not found ...");
   LogCode("else");
   LogCode("\t// Display path ..." + nl);

   String fileName = "notepad.exe";
   String dirList = "c:\\Windows;c:\\WinNT";
   String path = FileSearch(fileName, dirList);
   if (path.IsEmpty())
      Log("Could not find " + fileName + " in paths, " + dirList + "." + nl);
   else
      Log("Path is " + path + "." + nl);
   }

void TestFileDateFuncs()
   {
   String fileName = "SysUtils4.txt";
   if (CreateTestFile(fileName) == false) return;

   LogSubtitle("FileAge()" + nl);
   LogCode("String fileName = \"" + fileName + "\";" + nl);

   int dosDate1 = FileAge(fileName);
   LogCode("int dosDate1 = FileAge(fileName);" + nl);
   if (dosDate1 == -1)
      {
      Log("Unable to get file age. Test cancelled." + nl);
      return;
      }
   Log("dosDate1 = " + String(dosDate1) + nl);

   int handle = FileOpen(fileName, fmOpenReadWrite);
   LogCode("handle = FileOpen(fileName, fmOpenReadWrite);");
   if (handle == -1)
      {
      Log("Unable to open test file. Test cancelled." + nl);
      return;
      }

   int dosDate2 = FileGetDate(handle);
   LogCode("int dosDate2 = FileGetDate(handle);" + nl);
   if (dosDate2 == -1)
      {
      Log("Unable to get file date. Test cancelled." + nl);
      return;
      }

   Log("dosDate2 = " + String(dosDate2) + nl);

   LogSubtitle("FileDateToDateTime()" + nl);

   TDateTime dateTime = FileDateToDateTime(dosDate1);
   LogCode("TDateTime dateTime = FileDateToDateTime(dosDate1);" + nl);
   Log("dateTime = " + dateTime.DateTimeString() + nl);

   LogSubtitle("DateTimeToFileDate()" + nl);

   dateTime = TDateTime(1998, 7, 1);
   int dosDate3 = DateTimeToFileDate(dateTime);

   LogCode("dateTime = TDateTime(1998, 7, 1);");
   LogCode("int dosDate3 = DateTimeToFileDate(dateTime);" + nl);
   Log("dosDate3 = " + String(dosDate3) + nl);

   LogSubtitle("FileSetDate()" + nl);

   int error = FileSetDate(handle, dosDate3);
   FileClose(handle);

   LogCode("int error = FileSetDate(handle, dosDate3);" + nl);

   if (error)
      Log("Unable to set file date. Test cancelled." + nl);
   else
      Log("File date set successfully." + nl);

   LogCode("FileClose(handle);");

   DeleteFile(fileName);
   }

static void AddAttrib(String &trans, char *attr)
   {
   if (trans.IsEmpty() == false) trans += " + ";
   trans += attr;
   }

static String TransAttrib(int attrib)
   {
   String trans;

   if (attrib & faReadOnly) AddAttrib(trans, "Read Only");
   if (attrib & faHidden) AddAttrib(trans, "Hidden");
   if (attrib & faSysFile) AddAttrib(trans, "System File");
   if (attrib & faVolumeID) AddAttrib(trans, "Volume ID");
   if (attrib & faDirectory) AddAttrib(trans, "Directory");
   if (attrib & faArchive) AddAttrib(trans, "Archive");

   return(trans);
   }

void TestFileAttrFuncs()
   {
   String fileName = "SysUtils4.txt";
   if (CreateTestFile(fileName) == false) return;

   LogSubtitle("FileGetAttr()" + nl);
   LogCode("String fileName = \"" + fileName + "\";" + nl);

   int attrib = FileGetAttr(fileName);
   LogCode("int attrib = FileGetAttr(fileName);" + nl);
   if (attrib == -1)
      {
      Log("Unable to get file attributes. Test cancelled." + nl);
      DeleteFile(fileName);
      return;
      }

   Log("attrib = " + String(attrib) + " = " + TransAttrib(attrib) + nl);

   LogSubtitle("FileSetAttr()" + nl);

   int error = FileSetAttr(fileName, faReadOnly | faHidden | faArchive);
   LogCode("int error = FileSetAttr(fileName, faReadOnly | faHidden | faArchive);");
   if (error)
      Log("Could not set file attributes. Test cancelled." + nl);
   else
      {
      attrib = FileGetAttr(fileName);

      LogCode("int attrib = FileGetAttr(fileName);" + nl);

      if (attrib == -1)
         {
         Log("Unable to get file attributes. Test cancelled." + nl);
         DeleteFile(fileName);
         return;
         }

      Log("attrib = " + String(attrib) + " = " + TransAttrib(attrib) + nl);
      }

   FileSetAttr(fileName, faArchive);
   DeleteFile(fileName);
   }

void TestFileRenDelFuncs()
   {
   String fileName = "SysUtils4.txt";
   String newName = "NewSysUtils4.txt";
   if (CreateTestFile(fileName) == false) return;

   LogSubtitle("RenameFile()" + nl);
   LogCode("RenameFile(fileName, newName);" + nl);
   if (RenameFile(fileName, newName))
      Log("File was renamed." + nl);
   else
      Log("Unable to rename file." + nl);

   LogSubtitle("DeleteFile()" + nl);
   LogCode("DeleteFile(newName);" + nl);
   if (DeleteFile(newName))
      Log("File was deleted." + nl);
   else
      Log("Unable to delete file." + nl);
   }

void TestFileCRWsFuncs()
   {
   String fileName = "TestFile.txt";

   LogSubtitle("FileCreate()" + nl);
   LogCode("int handle = FileCreate(fileName);" + nl);

   int handle = FileCreate(fileName);
   if (handle == -1)
      {
      Log("Unable to create file. Test cancelled.");
      return;
      }

   Log("File created." + nl);

   LogSubtitle("FileWrite()" + nl);
   LogCode("char text[] = \"This is some text for our test file.\";");
   LogCode("FileWrite(handle, text, strlen(text));" + nl);

   char text[] = "This is some text for our test file.";
   int error = FileWrite(handle, text, strlen(text));
   if (error == -1)
      {
      Log("Unable to write to file. Test cancelled.");
      FileClose(handle);
      return;
      }

   Log("File written." + nl);

   LogSubtitle("FileClose()" + nl);
   LogCode("FileClose(handle);" + nl);

   FileClose(handle);

   Log("File closed." + nl);

   LogSubtitle("FileOpen()" + nl);
   LogCode("handle = FileOpen(fileName, fmOpenRead);" + nl);

   handle = FileOpen(fileName, fmOpenRead);
   if (handle == -1)
      {
      Log("Unable to open file. Test cancelled.");
      return;
      }

   Log("File opened." + nl);

   LogSubtitle("FileRead()" + nl);
   LogCode("char buffer[256];");
   LogCode("FileRead(handle, buffer, sizeof(buffer));" + nl);

   char buffer[256];
   int count = FileRead(handle, buffer, sizeof(buffer));
   if (count == 0)
      {
      Log("Unable to read file. Test cancelled." + nl);
      FileClose(handle);
      return;
      }
   buffer[count] = 0;

   Log("buffer = " + String(buffer) + nl);

   LogSubtitle("FileSeek()" + nl);
   LogCode("int pos = FileSeek(handle, 8, 0);");

   int pos = FileSeek(handle, 8, 0);
   if (pos == -1)
      {
      Log("Unable to seek into file. Test cancelled." + nl);
      FileClose(handle);
      return;
      }

   LogCode("count = FileRead(handle, buffer, 9);");
   count = FileRead(handle, buffer, 9);
   if (count == 0)
      {
      Log("Unable to read file. Test cancelled." + nl);
      FileClose(handle);
      return;
      }
   buffer[count] = 0;

   LogCode("FileClose(handle);" + nl);

   Log("buffer = " + String(buffer) + nl);

   FileClose(handle);

   DeleteFile(fileName);
   }


#pragma package(smart_init)
