#include <vcl.h>
#pragma hdrstop

#include "Log.h"
#include "Main.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TTestForm *TestForm;

__fastcall TTestForm::TTestForm(TComponent* Owner) : TForm(Owner)
   {
   Memo->SelAttributes->Assign(NormalText->Font);
   Memo->Paragraph->Tab[0] = 10;
   Memo->Paragraph->Tab[1] = 20;

   BuildList();
   }

void __fastcall TTestForm::Clear(TObject *Sender)
   {
   Memo->Clear();
   if (ActiveControl == ClearBtn) ActiveControl = RunBtn;
   }

void __fastcall TTestForm::Run(TObject *Sender)
   {
   Memo->Lines->BeginUpdate();

   if (AutoClrChk->Checked) Memo->Clear();

   bool testrun = false;
   for (int i = 0; i < TestLB->Items->Count; i++)
      if (TestLB->Checked[i])
         {
         String title = TestLB->Items->Strings[i];
         StatusBar->SimpleText = "Running " + title;
         LogTitle(title);
         ((TestFunc)(TestLB->Items->Objects[i]))();
         testrun = true;
         }

   StatusBar->SimpleText = testrun ? "Tests completed" : "No tests selected";

   Memo->Lines->EndUpdate();
   }

void __fastcall TTestForm::Select(TObject *Sender)
   {
   bool check = (Sender == SelAllBtn);
   for (int i = 0; i < TestLB->Items->Count; i++)
      TestLB->Checked[i] = check;
   }

