#include <vcl.h>
#pragma hdrstop

#include "Numbers.h"
#include "Log.h"

String CurrFmt[] = {"$1", "1$", "$ 1", "1 $"};
String NegCurrFmt[] = {"($1)", "-$1", "$-1", "$1-", "(1$)", "-1$", "1-$",
   "1$-", "-1 $", "-$ 1", "1 $-", "$ 1-", "$ -1", "1- $", "($ 1)", "(1 $)"};

void TestNumberVars()
   {
   Log("ThousandSeparator = " + String(ThousandSeparator));
   Log("DecimalSeparator = " + String(DecimalSeparator) + nl);
   }

void TestNumberFuncs()
   {
   int i = 1234;
   String s = IntToStr(i);

   LogSubtitle("IntToStr()" + nl);
   LogCode("int i = 1234;");
   LogCode("String s = IntToStr(i);" + nl);
   Log("s = " + s + nl);

   __int64 i64 = 1234567890;
   String s64 = IntToStr(i64);

   LogCode("__int64 i64 = 1234567890;");
   LogCode("String s64 = IntToStr(i64);" + nl);
   Log("s64 = " + s64 + nl);

   LogSubtitle("FloatToStr()" + nl);

   float f = 1234.5;
   String sf = FloatToStr(f);
   double d = 1234.5678;
   String sd = FloatToStr(d);
   long double ld = 1234567890.12345;
   String sld = FloatToStr(ld);

   LogCode("float f = 1234.5;");
   LogCode("String sf = FloatToStr(f);" + nl);
   Log("sf = " + sf + nl);
   LogCode("double d = 1234.5678;");
   LogCode("String sd = FloatToStr(d);" + nl);
   Log("sd = " + sd + nl);
   LogCode("long double ld = 1234567890.12345;");
   LogCode("String sld = FloatToStr(ld);" + nl);
   Log("sld = " + sld + nl);

   double n = 987654.12345;
   String sn = FloatToStrF(n, ffGeneral, 2, 4);

   LogSubtitle("FloatToStrF()" + nl);
   LogCode("double n = 987654.12345;");
   LogCode("String sn = FloatToStrF(n, ffGeneral, 2, 4);" + nl);
   Log("sn = " + sn + nl);

   sn = FloatToStrF(n, ffGeneral, 10, 0);

   LogCode("sn = FloatToStrF(n, ffGeneral, 10, 0);" + nl);
   Log("sn = " + sn + nl);

   sn = FloatToStrF(n, ffFixed, 10, 3);

   LogCode("sn = FloatToStrF(n, ffFixed, 10, 3);" + nl);
   Log("sn = " + sn + nl);

   sn = FloatToStrF(n, ffNumber, 8, 2);

   LogCode("sn = FloatToStrF(n, ffNumber, 8, 2);" + nl);
   Log("sn = " + sn + nl);

   LogSubtitle("FormatFloat()" + nl);

   String fs = "#,##0.00;(#,##0.00);'-zero-'";
   n = 12736.987;
   sn = FormatFloat(fs, n);

   LogCode("String fs = \"#,##0.00;(#,##0.00);'-zero-'\";");
   LogCode("double n = 12736.987;");
   LogCode("sn = FormatFloat(fs, n);" + nl);
   Log("sn = " + sn + nl);

   n = 0;
   sn = FormatFloat(fs, n);

   LogCode("n = 0;");
   LogCode("sn = FormatFloat(fs, n);" + nl);
   Log("sn = " + sn + nl);

   n = -27456;
   sn = FormatFloat(fs, n);

   LogCode("n = -27456;");
   LogCode("sn = FormatFloat(fs, n);" + nl);
   Log("sn = " + sn + nl);

   LogSubtitle("StrToInt() and StrToInt64()" + nl);

   s = "87456";
   i = StrToInt(s);
   i64 = StrToInt64(s);

   LogCode("String s = \"87456\";");
   LogCode("int i = StrToInt(s);");
   LogCode("__int64 i64 = StrToInt64(s);" + nl);
   Log("i = " + IntToStr(i));
   Log("i64 = " + IntToStr(i64) + nl);

   LogSubtitle("StrToIntDef() and StrToInt64Def()" + nl);

   s = "Not a number";
   i = StrToIntDef(s, 5213);
   i64 = StrToInt64Def(s, 789426);

   LogCode("String s = \"Not a number\";");
   LogCode("int i = StrToIntDef(s, 5213);");
   LogCode("__int64 i64 = StrToInt64Def(s, 789426);" + nl);
   Log("i = " + IntToStr(i));
   Log("i64 = " + IntToStr(i64) + nl);

   LogSubtitle("StrToFloat()" + nl);

   s = "23456.78";
   n = StrToFloat(s);

   LogCode("String s = \"23456.78\";");
   LogCode("double n = StrToFloat(s);" + nl);
   Log("n = " + FloatToStr(n) + nl);
   }

void TestHexVars()
   {
   Log("HexDisplayPrefix = " + HexDisplayPrefix + nl);
   }

void TestHexFuncs()
   {
   int i = 1024;
   String s = IntToHex(i, 8);

   LogSubtitle("IntToHex()" + nl);
   LogCode("int i = 1024;");
   LogCode("String s = IntToHex(i, 8);"+ nl);
   Log("s = " + s + nl);

   __int64 i64 = 987654321;
   String s64 = IntToHex(i64, 17);

   LogCode("int i64 = 987654321;");
   LogCode("String s64 = IntToHex(i64, 8);"+ nl);
   Log("s64 = " + s64 + nl);

   s = HexDisplayPrefix + IntToHex(99, 4);

   LogCode("String s = HexDisplayPrefix + IntToHex(99, 4);" + nl);
   Log("s = " + s + nl);
   }

void TestCurrencyVars()
   {
   Log("CurrencyString = " + CurrencyString);
   Log("CurrencyFormat = " + String(CurrencyFormat) + " = " + CurrFmt[CurrencyFormat]);
   Log("NegCurrFormat = " + String(NegCurrFormat) + " = " + NegCurrFmt[NegCurrFormat]);
   Log("CurrencyDecimals = " + String(CurrencyDecimals) + nl);
   }

void TestCurrencyFuncs()
   {
   Currency c = 15128.6;
   String s = CurrToStr(c);

   LogSubtitle("CurrToStr()" + nl);
   LogCode("Currency c = 15128.6;");
   LogCode("String s = CurrToStr(c);" + nl);
   Log("s = " + s + nl);

   c = 15128.6;
   s = CurrToStrF(c, ffCurrency, 0);

   LogSubtitle("CurrToStrF()" + nl);
   LogCode("Currency c = 15128.6;");
   LogCode("String s = CurrToStrF(c, ffCurrency, 0);" + nl);
   Log("s = " + s + nl);

   s = CurrToStrF(c, ffCurrency, 2);

   LogCode("s = CurrToStrF(c, ffCurrency, 2);" + nl);
   Log("s = " + s + nl);

   c = 15128.6;
   s = FormatCurr("#,##0.00;(#,##0.00)", c);

   LogSubtitle("FormatCurr()" + nl);
   LogCode("Currency c = 15128.6;");
   LogCode("String s = FormatCurr(\"#,##0.00;(#,##0.00)\", c);" + nl);
   Log("s = " + s + nl);

   s = FormatCurr("$#,##0.00;($#,##0.00)", c);

   LogCode("s = FormatCurr(\"$#,##0.00;($#,##0.00)\", c);" + nl);
   Log("s = " + s + nl);

   c = StrToCurr("1234.5");
   s = CurrToStrF(c, ffCurrency, 2);

   LogSubtitle("StrToCurr()" + nl);
   LogCode("Currency c = StrToCurr(\"1234.5\");");
   LogCode("String s = CurrToStrF(c, ffCurrency, 2);" + nl);
   Log("s = " + s + nl);
   }

#pragma package(smart_init)
